/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.palette;

import com.spket.palette.Palette;
import com.spket.palette.PaletteCategory;
import com.spket.palette.PaletteEntry;
import com.spket.palette.PalettePage;
import com.spket.palette.PaletteReader;
import com.spket.palette.PaletteSnippet;
import com.spket.palette.PaletteState;
import com.spket.ui.internal.UIMessages;
import com.spket.ui.internal.UIPlugin;
import com.spket.ui.palette.AddCategoryAction;
import com.spket.ui.palette.SnippetAction;
import com.spket.ui.properties.PropertySheetPage;
import com.spket.ui.util.ExtensionReader;
import com.spket.widget.ListItem;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class PaletteViewPage
extends PalettePage
implements IPageBookViewPage,
IAdaptable {
    private static final int EDIT = 1;
    private static final int DELETE = 2;
    private static final int IMPORT = 3;
    private static final int EXPORT = 4;
    private IPageSite site;
    private IPropertySheetPage propertySheet;
    private PaletteEntry entry;
    private AddCategoryAction addCatetory;
    private SnippetAction snippetAction;
    private PaletteAction editAction;
    private PaletteAction deleteAction;
    private PaletteAction importAction;
    private PaletteAction exportAction;
    private boolean changed;
    private String id;
    private Palette palette;
    static /* synthetic */ Class class$org$eclipse$ui$views$properties$IPropertySheetPage;

    public PaletteViewPage(String string) {
        this.id = string;
    }

    public IPageSite getSite() {
        return this.site;
    }

    public void init(IPageSite iPageSite) throws PartInitException {
        this.site = iPageSite;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.makeActions();
        Control control = this.getControl();
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                PaletteViewPage.this.onMenuAboutToShow(iMenuManager);
            }
        });
        menuManager.add((IAction)this.addCatetory);
        menuManager.add((IAction)this.snippetAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.editAction);
        menuManager.add((IAction)this.deleteAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.importAction);
        menuManager.add((IAction)this.exportAction);
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    public Object getAdapter(Class clazz) {
        if ((class$org$eclipse$ui$views$properties$IPropertySheetPage == null ? (class$org$eclipse$ui$views$properties$IPropertySheetPage = PaletteViewPage.class$("org.eclipse.ui.views.properties.IPropertySheetPage")) : class$org$eclipse$ui$views$properties$IPropertySheetPage).equals(clazz)) {
            return this.getPropertySheet();
        }
        return null;
    }

    public void dispose() {
        if (this.changed) {
            this.changed = false;
            if (this.palette != null) {
                try {
                    ExtensionReader.writePalette(this.palette);
                }
                catch (CoreException coreException) {
                    UIPlugin.log(coreException.getStatus());
                }
                catch (IOException iOException) {
                    UIPlugin.log(iOException);
                }
                this.palette = null;
            }
        }
        if (this.propertySheet != null) {
            this.propertySheet.dispose();
            this.propertySheet = null;
        }
        super.dispose();
    }

    public void setPalette(Palette palette, PaletteState paletteState) {
        this.palette = palette;
        if (palette == null) {
            this.setInput(null);
        } else {
            this.setInput(palette.getCategories(), paletteState);
        }
    }

    void setDirty() {
        this.changed = true;
        this.setInput(this.palette.getCategories());
    }

    public Palette getPalette() {
        return this.palette;
    }

    public PaletteCategory getCategory(PaletteSnippet paletteSnippet) {
        ListItem listItem;
        Object object = paletteSnippet;
        if (paletteSnippet == null && (listItem = this.paletteList.getItem(this.paletteList.getSelectionIndex())) != null && (object = listItem.getData()) == null && (listItem = listItem.getParent()) != null) {
            object = listItem.getData();
        }
        if (object instanceof PaletteCategory) {
            return (PaletteCategory)object;
        }
        if (object instanceof PaletteSnippet) {
            return this.palette.getCategory(object);
        }
        return null;
    }

    protected IPropertySheetPage getPropertySheet() {
        if (this.propertySheet == null) {
            this.propertySheet = new PropertySheetPage();
        }
        return this.propertySheet;
    }

    protected void makeActions() {
        this.addCatetory = new AddCategoryAction(this);
        this.snippetAction = new SnippetAction(this);
        this.editAction = new PaletteAction(1);
        this.editAction.setText(UIMessages.EditItem_text);
        this.deleteAction = new PaletteAction(2);
        this.deleteAction.setText(UIMessages.RemoveItem_text);
        this.importAction = new PaletteAction(3);
        this.importAction.setText(UIMessages.Palette_import);
        this.exportAction = new PaletteAction(4);
        this.exportAction.setText(UIMessages.Palette_export);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEdit() {
        if (this.entry == null) {
            return;
        }
        if (this.entry instanceof PaletteCategory) {
            this.addCatetory.setCategory((PaletteCategory)this.entry);
            try {
                this.addCatetory.run();
            }
            finally {
                this.addCatetory.setCategory(null);
            }
        }
        if (this.entry instanceof PaletteSnippet) {
            this.snippetAction.setSnippet((PaletteSnippet)this.entry);
            try {
                this.snippetAction.run();
            }
            finally {
                this.snippetAction.setSnippet(null);
            }
        }
    }

    protected void doDelete() {
        if (this.entry == null) {
            return;
        }
        String string = null;
        String string2 = "Confirm Delete";
        if (this.entry instanceof PaletteCategory) {
            string = "Are you sure you want to delete category '" + this.entry.getLabel() + "'";
        } else if (this.entry instanceof PaletteSnippet) {
            string = "Are you sure you want to delete snippet '" + this.entry.getLabel() + "'";
        }
        if (MessageDialog.openConfirm((Shell)this.getControl().getShell(), (String)string2, string) && this.palette.removeEntry(this.entry)) {
            this.changed = true;
            this.setInput(this.palette.getCategories());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doImport() {
        var1_1 = this.getControl().getShell();
        var2_2 = new FileDialog(var1_1, 4096);
        var3_3 = var2_2.open();
        if (var3_3 != null) {
            block18: {
                var4_4 = null;
                var5_5 = null;
                var6_6 = null;
                try {
                    var5_5 = new FileInputStream(var3_3);
                    var4_4 = ExtensionReader.getPalette(this.id, var5_5);
                    var9_7 = null;
                    ** if (var5_5 == null) goto lbl-1000
                }
                catch (Throwable var8_17) {
                    var9_10 = null;
                    if (var5_5 != null) {
                        try {
                            var5_5.close();
                        }
                        catch (IOException var10_14) {
                            // empty catch block
                        }
                    }
                    throw var8_17;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var5_5.close();
                    }
                    catch (IOException var10_11) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block18;
                    catch (IOException var7_15) {
                        var6_6 = new Status(4, "com.spket.ui", 0, "Internal", (Throwable)var7_15);
                        var9_8 = null;
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (IOException var10_12) {}
                        }
                        break block18;
                    }
                    catch (CoreException var7_16) {
                        var6_6 = var7_16.getStatus();
                        var9_9 = null;
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (IOException var10_13) {}
                        }
                    }
                }
            }
            if (var6_6 == null) {
                if (var4_4 != null) {
                    this.changed = true;
                    this.palette.replace(var4_4);
                    this.setInput(this.palette.getCategories());
                }
            } else {
                UIPlugin.log(var6_6);
                ErrorDialog.openError((Shell)var1_1, (String)"Import", null, (IStatus)var6_6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doExport() {
        Shell shell = this.getControl().getShell();
        FileDialog fileDialog = new FileDialog(shell, 4096);
        String string = fileDialog.open();
        if (string == null) return;
        PaletteReader paletteReader = new PaletteReader();
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(string);
        paletteReader.write((OutputStream)fileOutputStream, this.palette);
        Object var9_6 = null;
        if (fileOutputStream == null) return;
        try {
            ((OutputStream)fileOutputStream).close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                Status status = new Status(4, "com.spket.ui", 0, "Internal", (Throwable)iOException);
                UIPlugin.log((IStatus)status);
                ErrorDialog.openError((Shell)shell, (String)"Export", null, (IStatus)status);
                Object var9_7 = null;
                if (fileOutputStream == null) return;
                try {
                    ((OutputStream)fileOutputStream).close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected void onMenuAboutToShow(IMenuManager iMenuManager) {
        Object object;
        this.entry = null;
        boolean bl = false;
        ListItem listItem = this.getItemUnderMouse();
        if (listItem != null && (object = listItem.getData()) instanceof PaletteEntry) {
            bl = true;
            this.entry = (PaletteEntry)object;
        }
        this.editAction.setEnabled(bl);
        this.deleteAction.setEnabled(bl);
        this.snippetAction.setEnabled(listItem != null);
    }

    protected ListItem getItemUnderMouse() {
        return this.paletteList.getItem(this.paletteList.getMouseOverIndex());
    }

    public void setActionBars(IActionBars iActionBars) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PaletteAction
    extends Action {
        private int action;

        public PaletteAction(int n) {
            this.action = n;
        }

        public void run() {
            switch (this.action) {
                case 1: {
                    PaletteViewPage.this.doEdit();
                    break;
                }
                case 2: {
                    PaletteViewPage.this.doDelete();
                    break;
                }
                case 3: {
                    PaletteViewPage.this.doImport();
                    break;
                }
                case 4: {
                    PaletteViewPage.this.doExport();
                }
            }
        }
    }
}

