/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.part;

import com.spket.ui.part.IPart;
import com.spket.ui.part.IPartListener;
import com.spket.ui.part.PartContext;
import com.spket.ui.part.PartPane;
import java.util.ArrayList;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class PartForm
extends Composite {
    private static final PartPane[] EMPTY_PANE = new PartPane[0];
    Color titleColor;
    Color titleBgColor;
    Color borderColor;
    Color borderDarkColor;
    Color borderLightColor;
    Color tabBackgroundColor;
    int titleHeight;
    int tabHeight;
    boolean showTitle;
    PartPane fMaxPane = null;
    PartPane[] fPanes = null;
    private PartContext fPartContext;
    private PartPane fActivePane;
    private IPart fActivePart;
    private boolean handleMouseDoubleClick = true;
    private ListenerList fPartListeners = new ListenerList(1);

    public PartForm(Composite composite) {
        super(composite, 524288);
        Display display = this.getDisplay();
        this.titleColor = display.getSystemColor(30);
        this.titleBgColor = display.getSystemColor(31);
        this.borderColor = display.getSystemColor(18);
        this.borderDarkColor = display.getSystemColor(17);
        this.borderLightColor = display.getSystemColor(20);
        this.tabBackgroundColor = display.getSystemColor(19);
        this.resetHeight(false);
        this.setLayout(new PartLayout());
        this.installListeners();
    }

    public PartPane addPart(IPart iPart, int n) {
        return this.addPart(iPart, null, n, -1);
    }

    public PartPane addPart(IPart iPart, int n, int n2) {
        return this.addPart(iPart, null, n, n2);
    }

    public PartPane addPart(IPart iPart, IPart iPart2, int n) {
        return this.addPart(iPart, iPart2, n, -1);
    }

    public PartPane addPart(IPart iPart, IPart iPart2, int n, int n2) {
        this.fPanes = null;
        if (this.fPartContext == null) {
            this.fPartContext = new PartContext(this);
        }
        return this.fPartContext.add(iPart, iPart2, n, n2);
    }

    public PartPane findPartPane(IPart iPart) {
        return this.fPartContext != null ? this.fPartContext.getContainer(iPart) : null;
    }

    public void removeAll() {
        if (this.fPartContext == null) {
            return;
        }
        PartPane[] partPaneArray = this.getPanes();
        for (int i = 0; i < partPaneArray.length; ++i) {
            partPaneArray[i].removeAll();
        }
        Control[] controlArray = this.getChildren();
        if (controlArray != null) {
            for (int i = 0; i < controlArray.length; ++i) {
                Control control = controlArray[i];
                if (!(control instanceof Sash) || control.isDisposed()) continue;
                control.dispose();
            }
        }
        this.fPanes = null;
        this.fMaxPane = null;
        this.fActivePane = null;
        this.fActivePart = null;
        this.fPartContext = null;
    }

    public IPart removePart(IPart iPart) {
        if (iPart != null && this.fPartContext != null) {
            PartPane partPane;
            if (iPart == this.fActivePart) {
                this.fActivePart = null;
            }
            if ((partPane = this.findPartPane(iPart)) != null) {
                iPart = partPane.remove(iPart);
                return iPart;
            }
        }
        return null;
    }

    public void showPart(IPart iPart) {
        this.showPart(iPart, true);
    }

    public void showPart(IPart iPart, boolean bl) {
        PartPane partPane;
        if (iPart == null) {
            return;
        }
        if (iPart == this.fActivePart) {
            if (bl) {
                this.fActivePart.setFocus();
            }
            return;
        }
        if (this.fPartContext != null && (partPane = this.findPartPane(iPart)) != null) {
            partPane.showPart(iPart, bl);
            partPane.setVisible(true);
            if (this.fMaxPane != null && this.fMaxPane != partPane) {
                this.fMaxPane = null;
                this.layout(true);
                this.redraw();
            }
        }
    }

    public void setMaximizedPart(IPart iPart) {
        if (iPart == null) {
            if (this.fMaxPane != null) {
                this.fMaxPane = null;
                this.layout(true);
                this.redraw();
            }
        } else {
            PartPane partPane = this.findPartPane(iPart);
            if (partPane != this.fMaxPane) {
                this.fMaxPane = partPane;
                this.layout(true);
                this.redraw();
            }
        }
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean bl) {
        if (this.showTitle == bl) {
            return;
        }
        this.showTitle = bl;
        PartPane[] partPaneArray = this.getPanes();
        if (partPaneArray.length > 0) {
            this.setRedraw(false);
            for (int i = 0; i < partPaneArray.length; ++i) {
                partPaneArray[i].setShowTitle(bl);
            }
            this.setRedraw(true);
        }
    }

    public void requestActivation(PartPane partPane, IPart iPart) {
        if (this.fActivePane == partPane) {
            if (partPane != null && !partPane.isFocused()) {
                partPane.setFocused(true);
            }
        } else {
            if (this.fPanes == null) {
                this.fPanes = this.getPanes();
            }
            for (int i = 0; i < this.fPanes.length; ++i) {
                if (!this.fPanes[i].isFocused()) continue;
                this.fPanes[i].setFocused(false);
                break;
            }
            this.fActivePane = partPane;
            if (partPane != null) {
                partPane.setFocused(true);
            }
        }
        if (this.fActivePart != iPart) {
            this.fActivePart = iPart;
            this.firePartActivated(iPart);
            if (this.fActivePart != null) {
                this.fActivePart.setFocus();
            }
        }
    }

    public PartPane findPartPane(int n, int n2) {
        PartPane partPane;
        block4: {
            block3: {
                if (this.fPartContext == null) {
                    return null;
                }
                partPane = null;
                if (this.fMaxPane == null) break block3;
                if (!this.fMaxPane.getBounds().contains(n, n2)) break block4;
                partPane = this.fMaxPane;
                break block4;
            }
            if (this.fPanes == null) {
                this.fPanes = this.getPanes();
            }
            for (int i = 0; i < this.fPanes.length; ++i) {
                if (!this.fPanes[i].getBounds().contains(n, n2)) continue;
                partPane = this.fPanes[i];
                break;
            }
        }
        return partPane;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.resetHeight(true);
    }

    public PartPane getActivePane() {
        return this.fActivePane;
    }

    public IPart getActivePart() {
        return this.fActivePart;
    }

    public void addPartListener(IPartListener iPartListener) {
        this.fPartListeners.add((Object)iPartListener);
    }

    public void removePartListener(IPartListener iPartListener) {
        this.fPartListeners.remove((Object)iPartListener);
    }

    protected void firePartActivated(IPart iPart) {
        if (!this.fPartListeners.isEmpty()) {
            Object[] objectArray = this.fPartListeners.getListeners();
            for (int i = 0; i < objectArray.length; ++i) {
                ((IPartListener)objectArray[i]).partActivated(iPart);
            }
        }
    }

    private void resetHeight(boolean bl) {
        int n = this.tabHeight;
        GC gC = new GC((Drawable)this);
        Point point = gC.stringExtent("gM");
        gC.dispose();
        this.titleHeight = point.y + 4;
        this.tabHeight = Math.max(this.titleHeight, 18) + 4;
        if (bl) {
            if (this.tabHeight == n) {
                this.redraw();
            } else {
                this.notifyListeners(11, new Event());
            }
        }
    }

    private PartPane[] getPanes() {
        PartPane[] partPaneArray = EMPTY_PANE;
        if (this.fPartContext != null) {
            ArrayList arrayList = new ArrayList(6);
            this.fPartContext.getPanes(arrayList);
            if (arrayList.size() > 0) {
                partPaneArray = new PartPane[arrayList.size()];
                arrayList.toArray(partPaneArray);
            }
        }
        return partPaneArray;
    }

    private void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: {
                        PartForm.this.onMouseMove(event);
                        break;
                    }
                    case 9: {
                        PartForm.this.onPaint(event);
                        break;
                    }
                    case 3: {
                        PartForm.this.onMouseDown(event);
                        break;
                    }
                    case 8: {
                        PartForm.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 27: {
                        PartForm.this.onDeactivate(event);
                        break;
                    }
                    case 12: {
                        PartForm.this.onDispose();
                    }
                }
            }
        };
        this.addListener(5, listener);
        this.addListener(9, listener);
        this.addListener(3, listener);
        this.addListener(8, listener);
        this.getShell().addListener(27, listener);
        this.addListener(12, listener);
    }

    private void onDispose() {
        this.fMaxPane = null;
        this.fPanes = null;
        this.fPartContext = null;
        this.fActivePane = null;
        this.fActivePart = null;
        if (this.fPartListeners != null) {
            this.fPartListeners.clear();
        }
    }

    private void onPaint(Event event) {
        GC gC = event.gc;
        if (this.fPartContext != null) {
            if (this.fPanes == null) {
                this.fPanes = this.getPanes();
            }
            Rectangle rectangle = gC.getClipping();
            for (int i = 0; i < this.fPanes.length; ++i) {
                Rectangle rectangle2 = this.fPanes[i].getBounds();
                if (rectangle2.width <= 0 || rectangle2.height <= 0 || !rectangle.intersects(rectangle2)) continue;
                this.fPanes[i].paint(gC);
            }
        } else {
            gC.fillRectangle(this.getClientArea());
        }
    }

    private void onDeactivate(Event event) {
        if (this.fActivePane != null) {
            this.fActivePane.setFocused(false);
        }
    }

    private void onMouseMove(Event event) {
        String string = this.getToolTipText();
        String string2 = null;
        PartPane partPane = this.findPartPane(event.x, event.y);
        if (partPane != null) {
            string2 = partPane.getToolTipAt(event.x, event.y);
        }
        if (string2 != string) {
            this.setToolTipText(string2);
        }
    }

    private void onMouseDown(Event event) {
        PartPane partPane = this.findPartPane(event.x, event.y);
        if (partPane != null) {
            IPart iPart;
            boolean bl = partPane.isFocused();
            if (!partPane.onMouseDown(event) && !bl && (iPart = partPane.getSelection()) != null) {
                iPart.setFocus();
            }
        }
    }

    public boolean isHandleMouseDoubleClick() {
        return this.handleMouseDoubleClick;
    }

    public void setHandleMouseDoubleClick(boolean bl) {
        this.handleMouseDoubleClick = bl;
    }

    private void onMouseDoubleClick(Event event) {
        if (!this.handleMouseDoubleClick) {
            return;
        }
        if (this.fMaxPane != null) {
            this.setMaximizedPart(null);
        } else {
            PartPane partPane = this.findPartPane(event.x, event.y);
            if (partPane != this.fMaxPane) {
                this.layout(true);
                this.redraw();
            }
        }
    }

    private final class PartLayout
    extends Layout {
        private PartLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (PartForm.this.fPartContext != null) {
                return PartForm.this.fPartContext.computeSize(n, n2, bl);
            }
            return null;
        }

        protected void layout(Composite composite, boolean bl) {
            if (PartForm.this.fPartContext != null) {
                Rectangle rectangle = composite.getClientArea();
                if (PartForm.this.fMaxPane != null) {
                    PartForm.this.fPartContext.setBounds(0, 0, 0, 0);
                    PartForm.this.fMaxPane.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    PartForm.this.fPartContext.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
    }
}

