/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.preferences;

import com.spket.ui.internal.UIPlugin;
import com.spket.ui.preferences.TemplateVariableProcessor;
import com.spket.ui.preferences.TextEditorTemplateMessages;
import com.spket.ui.util.StatusInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class EditTemplateDialog
extends StatusDialog {
    private final Template fOriginalTemplate;
    private Text fNameText;
    private Text fDescriptionText;
    private Combo fContextCombo;
    private SourceViewer fPatternEditor;
    private Button fInsertVariableButton;
    private Button fAutoInsertCheckbox;
    private boolean fIsNameModifiable;
    private StatusInfo fValidationStatus;
    private boolean fSuppressError = true;
    private Map fGlobalActions = new HashMap(10);
    private List fSelectionActions = new ArrayList(3);
    private String[][] fContextTypes;
    private ContextTypeRegistry fContextTypeRegistry;
    private final TemplateVariableProcessor fTemplateProcessor = new TemplateVariableProcessor();
    private Template fNewTemplate;

    public EditTemplateDialog(Shell shell, Template template, boolean bl, boolean bl2, ContextTypeRegistry contextTypeRegistry) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String string = bl ? TextEditorTemplateMessages.EditTemplateDialog_title_edit : TextEditorTemplateMessages.EditTemplateDialog_title_new;
        this.setTitle(string);
        this.fOriginalTemplate = template;
        this.fIsNameModifiable = bl2;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Iterator iterator = contextTypeRegistry.contextTypes();
        while (iterator.hasNext()) {
            TemplateContextType templateContextType = (TemplateContextType)iterator.next();
            arrayList.add(new String[]{templateContextType.getId(), templateContextType.getName()});
        }
        this.fContextTypes = (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
        this.fValidationStatus = new StatusInfo();
        this.fContextTypeRegistry = contextTypeRegistry;
        iterator = this.fContextTypeRegistry.getContextType(template.getContextTypeId());
        this.fTemplateProcessor.setContextType((TemplateContextType)iterator);
    }

    public void create() {
        boolean bl;
        super.create();
        boolean bl2 = bl = this.fNameText == null || this.fNameText.getText().trim().length() != 0;
        if (!bl) {
            StatusInfo statusInfo = new StatusInfo();
            statusInfo.setError(TextEditorTemplateMessages.EditTemplateDialog_error_noname);
            this.updateButtonsEnableState(statusInfo);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EditTemplateDialog.this.doTextWidgetChanged(modifyEvent.widget);
            }
        };
        if (this.fIsNameModifiable) {
            EditTemplateDialog.createLabel(composite2, TextEditorTemplateMessages.EditTemplateDialog_name);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayoutData((Object)new GridData(768));
            gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite3.setLayout((Layout)gridLayout);
            this.fNameText = EditTemplateDialog.createText(composite3);
            this.fNameText.addModifyListener(modifyListener);
            this.fNameText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (EditTemplateDialog.this.fSuppressError) {
                        EditTemplateDialog.this.fSuppressError = false;
                        EditTemplateDialog.this.updateButtons();
                    }
                }
            });
            EditTemplateDialog.createLabel(composite3, TextEditorTemplateMessages.EditTemplateDialog_context);
            this.fContextCombo = new Combo(composite3, 8);
            for (int i = 0; i < this.fContextTypes.length; ++i) {
                this.fContextCombo.add(this.fContextTypes[i][1]);
            }
            this.fContextCombo.addModifyListener(modifyListener);
            this.fAutoInsertCheckbox = EditTemplateDialog.createCheckbox(composite3, TextEditorTemplateMessages.EditTemplateDialog_autoinsert);
            this.fAutoInsertCheckbox.setSelection(this.fOriginalTemplate.isAutoInsertable());
        }
        EditTemplateDialog.createLabel(composite2, TextEditorTemplateMessages.EditTemplateDialog_description);
        int n = this.fIsNameModifiable ? 2048 : 2056;
        this.fDescriptionText = new Text(composite2, n);
        this.fDescriptionText.setLayoutData((Object)new GridData(768));
        this.fDescriptionText.addModifyListener(modifyListener);
        Label label = EditTemplateDialog.createLabel(composite2, TextEditorTemplateMessages.EditTemplateDialog_pattern);
        label.setLayoutData((Object)new GridData(2));
        this.fPatternEditor = this.createEditor(composite2, this.fOriginalTemplate.getPattern());
        Label label2 = new Label(composite2, 0);
        label2.setLayoutData((Object)new GridData());
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData());
        this.fInsertVariableButton = new Button(composite4, 0);
        this.fInsertVariableButton.setLayoutData((Object)EditTemplateDialog.getButtonGridData(this.fInsertVariableButton));
        this.fInsertVariableButton.setText(TextEditorTemplateMessages.EditTemplateDialog_insert_variable);
        this.fInsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.fPatternEditor.getTextWidget().setFocus();
                EditTemplateDialog.this.fPatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.fDescriptionText.setText(this.fOriginalTemplate.getDescription());
        if (this.fIsNameModifiable) {
            this.fNameText.setText(this.fOriginalTemplate.getName());
            this.fNameText.addModifyListener(modifyListener);
            this.fContextCombo.select(this.getIndex(this.fOriginalTemplate.getContextTypeId()));
        } else {
            this.fPatternEditor.getControl().setFocus();
        }
        this.initializeActions();
        EditTemplateDialog.applyDialogFont((Control)composite2);
        return composite4;
    }

    private void doTextWidgetChanged(Widget widget) {
        if (widget == this.fNameText) {
            this.fSuppressError = false;
            this.updateButtons();
        } else if (widget == this.fContextCombo) {
            String string = this.getContextId();
            this.fTemplateProcessor.setContextType(this.fContextTypeRegistry.getContextType(string));
        } else if (widget == this.fDescriptionText) {
            // empty if block
        }
    }

    private String getContextId() {
        if (this.fContextCombo != null && !this.fContextCombo.isDisposed()) {
            String string = this.fContextCombo.getText();
            for (int i = 0; i < this.fContextTypes.length; ++i) {
                if (!string.equals(this.fContextTypes[i][1])) continue;
                return this.fContextTypes[i][0];
            }
        }
        return this.fOriginalTemplate.getContextTypeId();
    }

    private void doSourceChanged(IDocument iDocument) {
        String string = iDocument.get();
        this.fValidationStatus.setOK();
        TemplateContextType templateContextType = this.fContextTypeRegistry.getContextType(this.getContextId());
        if (templateContextType != null) {
            try {
                templateContextType.validate(string);
            }
            catch (TemplateException templateException) {
                this.fValidationStatus.setError(templateException.getLocalizedMessage());
            }
        }
        this.updateUndoAction();
        this.updateButtons();
    }

    private static GridData getButtonGridData(Button button) {
        return new GridData(768);
    }

    private static Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Text createText(Composite composite) {
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private static Button createCheckbox(Composite composite, String string) {
        Button button = new Button(composite, 32);
        button.setText(string);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    protected IContentAssistProcessor getTemplateProcessor() {
        return this.fTemplateProcessor;
    }

    protected void setupDocument(IDocument iDocument) {
    }

    private SourceViewer createEditor(Composite composite, String string) {
        SourceViewer sourceViewer = this.createViewer(composite);
        Document document = new Document(string);
        this.setupDocument((IDocument)document);
        sourceViewer.setEditable(true);
        sourceViewer.setDocument((IDocument)document);
        int n = document.getNumberOfLines();
        if (n < 5) {
            n = 5;
        } else if (n > 12) {
            n = 12;
        }
        Control control = sourceViewer.getControl();
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        gridData.heightHint = this.convertHeightInCharsToPixels(n);
        control.setLayoutData((Object)gridData);
        sourceViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent textEvent) {
                if (textEvent.getDocumentEvent() != null) {
                    EditTemplateDialog.this.doSourceChanged(textEvent.getDocumentEvent().getDocument());
                }
            }
        });
        sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                EditTemplateDialog.this.updateSelectionDependentActions();
            }
        });
        sourceViewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                EditTemplateDialog.this.handleVerifyKeyPressed(verifyEvent);
            }
        });
        return sourceViewer;
    }

    protected SourceViewer createViewer(Composite composite) {
        SourceViewer sourceViewer = new SourceViewer(composite, null, null, false, 2816);
        SourceViewerConfiguration sourceViewerConfiguration = new SourceViewerConfiguration(){

            public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
                ContentAssistant contentAssistant = new ContentAssistant();
                contentAssistant.enableAutoActivation(true);
                contentAssistant.enableAutoInsert(true);
                contentAssistant.setContentAssistProcessor((IContentAssistProcessor)EditTemplateDialog.this.fTemplateProcessor, "__dftl_partition_content_type");
                return contentAssistant;
            }
        };
        sourceViewer.configure(sourceViewerConfiguration);
        return sourceViewer;
    }

    private void handleVerifyKeyPressed(VerifyEvent verifyEvent) {
        if (!verifyEvent.doit) {
            return;
        }
        if (verifyEvent.stateMask != SWT.MOD1) {
            return;
        }
        switch (verifyEvent.character) {
            case ' ': {
                this.fPatternEditor.doOperation(13);
                verifyEvent.doit = false;
                break;
            }
            case '\u001a': {
                this.fPatternEditor.doOperation(1);
                verifyEvent.doit = false;
            }
        }
    }

    private void initializeActions() {
        TextViewerAction textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 1);
        textViewerAction.setText(TextEditorTemplateMessages.EditTemplateDialog_undo);
        this.fGlobalActions.put(ITextEditorActionConstants.UNDO, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 3);
        textViewerAction.setText(TextEditorTemplateMessages.EditTemplateDialog_cut);
        this.fGlobalActions.put(ITextEditorActionConstants.CUT, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 4);
        textViewerAction.setText(TextEditorTemplateMessages.EditTemplateDialog_copy);
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 5);
        textViewerAction.setText(TextEditorTemplateMessages.EditTemplateDialog_paste);
        this.fGlobalActions.put(ITextEditorActionConstants.PASTE, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 7);
        textViewerAction.setText(TextEditorTemplateMessages.EditTemplateDialog_select_all);
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 13);
        textViewerAction.setText(TextEditorTemplateMessages.EditTemplateDialog_content_assist);
        this.fGlobalActions.put("ContentAssistProposal", textViewerAction);
        this.fSelectionActions.add(ITextEditorActionConstants.CUT);
        this.fSelectionActions.add(ITextEditorActionConstants.COPY);
        this.fSelectionActions.add(ITextEditorActionConstants.PASTE);
        MenuManager menuManager = new MenuManager(null, null);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                EditTemplateDialog.this.fillContextMenu(iMenuManager);
            }
        });
        StyledText styledText = this.fPatternEditor.getTextWidget();
        Menu menu = menuManager.createContextMenu((Control)styledText);
        styledText.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new GroupMarker("group.undo"));
        iMenuManager.appendToGroup("group.undo", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO));
        iMenuManager.add((IContributionItem)new Separator("group.edit"));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.CUT));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.PASTE));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        iMenuManager.add((IContributionItem)new Separator("templates"));
        iMenuManager.appendToGroup("templates", (IAction)this.fGlobalActions.get("ContentAssistProposal"));
    }

    private void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    private void updateUndoAction() {
        IAction iAction = (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    private void updateAction(String string) {
        IAction iAction = (IAction)this.fGlobalActions.get(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    private int getIndex(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < this.fContextTypes.length; ++i) {
            if (!string.equals(this.fContextTypes[i][0])) continue;
            return i;
        }
        return -1;
    }

    private void updateButtons() {
        StatusInfo statusInfo;
        boolean bl;
        boolean bl2 = bl = this.fNameText == null || this.fNameText.getText().trim().length() != 0;
        if (!bl) {
            statusInfo = new StatusInfo();
            if (!this.fSuppressError) {
                statusInfo.setError(TextEditorTemplateMessages.EditTemplateDialog_error_noname);
            }
        } else {
            statusInfo = this.fValidationStatus;
        }
        this.updateStatus(statusInfo);
    }

    protected void okPressed() {
        String string = this.fNameText == null ? this.fOriginalTemplate.getName() : this.fNameText.getText();
        boolean bl = this.fAutoInsertCheckbox != null && this.fAutoInsertCheckbox.getSelection();
        this.fNewTemplate = new Template(string, this.fDescriptionText.getText(), this.getContextId(), this.fPatternEditor.getDocument().get(), bl);
        super.okPressed();
    }

    public Template getTemplate() {
        return this.fNewTemplate;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String string = ((Object)((Object)this)).getClass().getName() + "_dialogBounds";
        IDialogSettings iDialogSettings = UIPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(string);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(string);
        }
        return iDialogSettings2;
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer iTextViewer, int n) {
            this.fOperationCode = n;
            this.fOperationTarget = iTextViewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean bl = this.isEnabled();
            boolean bl2 = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(bl2);
            if (bl != bl2) {
                this.firePropertyChange("enabled", bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

