/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.preferences;

import com.spket.ui.internal.UIPlugin;
import com.spket.ui.preferences.AbstractPreferencePage;
import com.spket.ui.preferences.OverlayPreferenceStore;
import com.spket.ui.preferences.PrefMessages;
import com.spket.ui.util.Compatibility;
import com.spket.ui.util.Message;
import com.spket.ui.util.PixelConverter;
import com.spket.ui.util.StatusInfo;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.editors.text.EditorsUI;

public class EditorPreferencePage
extends AbstractPreferencePage {
    private Button fDefaultField;
    private Button fCustomField;
    private Text fSizeField;

    protected Plugin getPlugin() {
        return UIPlugin.getDefault();
    }

    protected String getPluginId() {
        return "com.spket.ui";
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return UIPlugin.getDefault().getPreferenceStore();
    }

    protected OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "tab.char"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "tab.default"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "tab.size"));
        if (!Compatibility.supportsSmartHome()) {
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Navigation.SmartHomeEnd"));
        }
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    protected void initialize() {
        OverlayPreferenceStore overlayPreferenceStore = this.getOverlayPreferenceStore();
        boolean bl = overlayPreferenceStore.getBoolean("tab.default");
        if (bl) {
            this.fDefaultField.setSelection(true);
        } else {
            this.fCustomField.setSelection(true);
        }
        String string = overlayPreferenceStore.getString("tab.size");
        if (string.length() == 0) {
            overlayPreferenceStore = EditorsUI.getPreferenceStore();
            string = overlayPreferenceStore.getString("tabWidth");
        }
        this.fSizeField.setText(string);
        super.initialize();
        this.updateTabSizeControls();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        if (!Compatibility.supportsSmartHome()) {
            this.addCheckBox(composite2, PrefMessages.SmartHome_label, "AbstractTextEditor.Navigation.SmartHomeEnd", 1, 0);
        }
        Composite composite3 = this.createSubsection(composite2, PrefMessages.TabGrp_title, 2);
        composite3.setLayoutData((Object)new GridData(768));
        this.addCheckBox(composite3, PrefMessages.TabConvert_label, "tab.char", 2, 0);
        String string = EditorsUI.getPreferenceStore().getString("tabWidth");
        this.fDefaultField = new Button(composite3, 16);
        this.fDefaultField.setText(Message.format(PrefMessages.TabDisplay_label, string));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 20;
        this.fDefaultField.setLayoutData((Object)gridData);
        this.fCustomField = new Button(composite3, 16);
        this.fCustomField.setText(PrefMessages.TabSize_label);
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        this.fCustomField.setLayoutData((Object)gridData);
        this.fSizeField = new Text(composite3, 133124);
        gridData = new GridData(32);
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(5);
        this.fSizeField.setTextLimit(4);
        this.fSizeField.setLayoutData((Object)gridData);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 24: {
                        EditorPreferencePage.this.onTabSizeChanged(event);
                        break;
                    }
                    case 13: {
                        EditorPreferencePage.this.onTabChanged(event);
                    }
                }
            }
        };
        this.fDefaultField.addListener(13, listener);
        this.fCustomField.addListener(13, listener);
        this.fSizeField.addListener(24, listener);
        return composite2;
    }

    protected void onFieldChanged(String string, Control control) {
        if ("tab.char".equals(string)) {
            this.updateTabSizeControls();
        }
    }

    protected void onTabChanged(Event event) {
        boolean bl = this.fDefaultField.getSelection();
        this.getOverlayPreferenceStore().setValue("tab.default", bl);
        this.fSizeField.setEnabled(!bl);
    }

    protected void onTabSizeChanged(Event event) {
        StatusInfo statusInfo = new StatusInfo(this.getPluginId());
        String string = this.fSizeField.getText();
        if (string.length() == 0) {
            statusInfo.setError(PrefMessages.Pre_empty_input);
        } else {
            try {
                int n = Integer.parseInt(string);
                if (n < 0 || n > 32) {
                    statusInfo.setError(Message.format(PrefMessages.TabSize_invalid, new String[]{"0", Integer.toString(32)}));
                }
            }
            catch (NumberFormatException numberFormatException) {
                statusInfo.setError(Message.format(PrefMessages.Pre_invalid_input, string));
            }
        }
        if (!statusInfo.matches(4)) {
            this.getOverlayPreferenceStore().setValue("tab.size", string);
        }
        this.updateStatus(statusInfo);
    }

    private void updateTabSizeControls() {
        boolean bl = this.getOverlayPreferenceStore().getBoolean("tab.char");
        this.fDefaultField.setEnabled(bl);
        this.fCustomField.setEnabled(bl);
        this.fSizeField.setEnabled(bl && this.fCustomField.getSelection());
    }
}

