/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.preferences;

import com.spket.ui.preferences.TextEditorTemplateMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TemplateVariableProposal
implements ICompletionProposal {
    private TemplateVariableResolver fVariable;
    private int fOffset;
    private int fLength;
    private ITextViewer fViewer;
    private Point fSelection;

    public TemplateVariableProposal(TemplateVariableResolver templateVariableResolver, int n, int n2, ITextViewer iTextViewer) {
        this.fVariable = templateVariableResolver;
        this.fOffset = n;
        this.fLength = n2;
        this.fViewer = iTextViewer;
    }

    public void apply(IDocument iDocument) {
        try {
            String string = this.fVariable.getType().equals("dollar") ? "$$" : "${" + this.fVariable.getType() + '}';
            iDocument.replace(this.fOffset, this.fLength, string);
            this.fSelection = new Point(this.fOffset + string.length(), 0);
        }
        catch (BadLocationException badLocationException) {
            Shell shell = this.fViewer.getTextWidget().getShell();
            MessageDialog.openError((Shell)shell, (String)TextEditorTemplateMessages.TemplateVariableProposal_error_title, (String)badLocationException.getMessage());
        }
    }

    public Point getSelection(IDocument iDocument) {
        return this.fSelection;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.fVariable.getType() + " - " + this.fVariable.getDescription();
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

