/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.properties;

import com.spket.ui.properties.CellEditor;
import com.spket.ui.properties.IDropDownEditor;
import com.spket.ui.properties.IPropertyDescriptor;
import com.spket.ui.properties.IPropertyProvider;
import com.spket.util.StringUtils;
import com.spket.widget.UIUtils;
import java.util.Collection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ListCellEditor
extends CellEditor
implements IDropDownEditor {
    private static final int MIN_ITEM_COUNT = 2;
    private static final int MAX_ITEM_COUNT = 25;
    private List fList;
    private String[] fItems;
    private Object[] fValues;
    private Object fValue;
    private Object fSelection;
    protected Listener fListener = new Listener(){

        public void handleEvent(Event event) {
            boolean bl = false;
            switch (event.type) {
                case 13: {
                    bl = true;
                    break;
                }
                case 31: {
                    bl = event.detail == 4;
                    break;
                }
                case 4: {
                    bl = true;
                }
            }
            if (bl) {
                ListCellEditor.this.valueChanged();
            }
        }
    };

    public void fill(Composite composite) {
        this.fList = new CList(composite, 516);
        if (this.fItems != null && this.fItems.length > 0) {
            this.fList.setItems(this.fItems);
            this.doSelection(this.fSelection);
        }
        this.fList.addListener(4, this.fListener);
        this.fList.addListener(31, this.fListener);
    }

    public void setFocus() {
        if (UIUtils.okToUse((Widget)this.fList)) {
            this.fList.setFocus();
        }
    }

    public void popup(Shell shell) {
    }

    public boolean isFixedSize() {
        return false;
    }

    public void setInput(Object object) {
        if (object instanceof Object[]) {
            this.fValues = (Object[])object;
        } else if (object instanceof Collection) {
            this.fValues = ((Collection)object).toArray();
        } else if (object != null) {
            this.fValues = new Object[1];
            this.fValues[0] = object;
        } else {
            this.fValues = null;
        }
        if (this.fValues == null || this.fValues.length == 0) {
            this.fItems = null;
        } else {
            this.fItems = new String[this.fValues.length];
            for (int i = 0; i < this.fItems.length; ++i) {
                this.fItems[i] = this.fValues[i] == null ? StringUtils.EMPTY_STRING : this.fValues[i].toString();
            }
        }
        if (UIUtils.okToUse((Widget)this.fList)) {
            if (this.fItems == null) {
                if (this.fList.getItemCount() > 0) {
                    this.fList.setItems(StringUtils.EMPTY_STRINGS);
                }
            } else {
                this.fList.setItems(this.fItems);
            }
            this.doSelection(this.fSelection);
        }
    }

    public void setValue(Object object) {
        this.fSelection = object;
        if (UIUtils.okToUse((Widget)this.fList)) {
            this.doSelection(object);
        }
    }

    public Object getValue() {
        return this.fValue;
    }

    public Object getNextValue(IPropertyProvider[] iPropertyProviderArray, IPropertyDescriptor iPropertyDescriptor, Object object) {
        Object[] objectArray = ListCellEditor.getChoiceOfValues(iPropertyProviderArray, iPropertyDescriptor);
        if (objectArray != null && objectArray.length > 0) {
            if (object != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!object.equals(objectArray[i])) continue;
                    if (++i == objectArray.length) {
                        i = 0;
                    }
                    return objectArray[i];
                }
            }
            return objectArray[0];
        }
        return null;
    }

    protected void valueChanged() {
        int n;
        boolean bl = false;
        if (this.fValues != null && (n = this.fList.getSelectionIndex()) >= 0 && n < this.fValues.length) {
            this.fValue = this.fValues[n];
            boolean bl2 = bl = !StringUtils.equals((Object)this.fValue, (Object)this.fSelection);
        }
        if (bl) {
            this.fireApplyEditorValue();
        } else {
            this.fireCancelEditor();
        }
    }

    protected void doSelection(Object object) {
        int n = -1;
        if (this.fValues != null) {
            for (int i = 0; i < this.fValues.length; ++i) {
                if (!StringUtils.equals((Object)object, (Object)this.fValues[i])) continue;
                n = i;
                break;
            }
        }
        this.fList.setSelection(n);
    }

    private static final class CList
    extends List {
        public CList(Composite composite, int n) {
            super(composite, n);
        }

        public Point computeSize(int n, int n2, boolean bl) {
            if (n2 == -1) {
                int n3 = Math.max(2, Math.min(25, this.getItemCount()));
                n2 = this.getItemHeight() * n3;
            }
            return super.computeSize(n, n2, bl);
        }

        protected void checkSubclass() {
        }
    }
}

