/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.tasks;

import com.spket.ui.internal.UIPlugin;
import com.spket.ui.tasks.TaskJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class TaskBuilder
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private static TaskBuilder gScanner;
    private TaskJob fJob;
    private List resources = new ArrayList();

    public static void startup() {
        if (gScanner == null) {
            gScanner = new TaskBuilder();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)gScanner, 1);
        }
    }

    public static void shutdown() {
        if (gScanner != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)gScanner);
            gScanner = null;
        }
    }

    public static void refreshResources(Collection collection) {
        if (gScanner != null) {
            gScanner.enqueue(collection);
        }
    }

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        if (iResourceDelta == null) {
            return false;
        }
        IResource iResource = iResourceDelta.getResource();
        if (iResource != null) {
            switch (iResource.getType()) {
                case 1: {
                    if (4 == iResourceDelta.getKind() && (iResourceDelta.getFlags() & 0x100) != 0) {
                        this.resources.add(iResource);
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta != null) {
            if (this.resources.size() > 0) {
                this.resources.clear();
            }
            try {
                iResourceDelta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException coreException) {
                UIPlugin.log(coreException.getStatus());
            }
            if (this.resources.size() > 0) {
                if (this.fJob == null) {
                    this.fJob = new TaskJob();
                }
                this.fJob.scan(this.resources);
                this.resources.clear();
            }
        }
    }

    protected void enqueue(Collection collection) {
        if (collection != null && collection.size() > 0) {
            if (this.fJob == null) {
                this.fJob = new TaskJob();
            }
            this.fJob.scan(collection);
        }
    }
}

