/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.util;

import com.spket.buffer.CompatibilityBufferProvider;
import com.spket.buffer.IBufferProvider;
import com.spket.util.Debug;
import org.osgi.framework.Version;

public class Compatibility {
    private static final String ID_PROJECT_EXPLORER = "org.eclipse.ui.navigator.ProjectExplorer";
    private static Version gVersion;

    public static IBufferProvider createBufferProvider() {
        int n;
        Version version = Compatibility.getVersion();
        if (version != Version.emptyVersion && ((n = version.getMajor()) > 3 || n == 3 && version.getMinor() > 2)) {
            try {
                return (IBufferProvider)Class.forName("com.spket.buffer.BufferProvider").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.debug((Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                Debug.debug((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Debug.debug((Throwable)illegalAccessException);
            }
        }
        return new CompatibilityBufferProvider();
    }

    public static boolean supportsTextDragAndDrop() {
        Version version = Compatibility.getVersion();
        if (version != Version.emptyVersion) {
            int n = version.getMajor();
            return n > 3 || n == 3 && version.getMinor() > 2;
        }
        return false;
    }

    public static boolean supportsSmartHome() {
        return Compatibility.supportsTextDragAndDrop();
    }

    public static String getTextDragAndDropId() {
        if (Compatibility.supportsTextDragAndDrop()) {
            return "textDragAndDropEnabled";
        }
        return null;
    }

    public static String getExternalEditorInputClassName() {
        Version version = Compatibility.getVersion();
        if (version.getMajor() > 3 || version.getMajor() == 3 && version.getMinor() > 2) {
            return "org.eclipse.ui.ide.FileStoreEditorInput";
        }
        return "org.eclipse.ui.internal.editors.text.JavaFileEditorInput";
    }

    public static String getProjectExplorerId() {
        Version version = Compatibility.getVersion();
        if (version != Version.emptyVersion && version.getMajor() == 3 && version.getMinor() <= 2) {
            return "org.eclipse.ui.views.ResourceNavigator";
        }
        return ID_PROJECT_EXPLORER;
    }

    public static Version getVersion() {
        if (gVersion == null) {
            try {
                gVersion = Version.parseVersion((String)System.getProperty("osgi.framework.version"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                gVersion = Version.emptyVersion;
            }
            if (gVersion == null) {
                gVersion = Version.emptyVersion;
            }
        }
        return gVersion;
    }
}

