/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.views;

import com.spket.ui.internal.UIPlugin;
import com.spket.ui.text.IDocumentation;
import com.spket.ui.text.IDocumentationProvider;
import com.spket.ui.text.html.HTMLPrinter;
import com.spket.ui.text.html.HTMLTextPresenter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class DocumentationView
extends ViewPart
implements ISelectionListener {
    private static String fgDocument;
    private static String fgStyleSheet;
    private Worker fWorker;
    private final Object fMonitor = new Object();
    private StyledText fText;
    private Browser fBrowser;
    private RGB fBackgroundColorRGB;
    private boolean fIsUsingBrowserWidget;
    private TextPresentation fPresentation;
    private DefaultInformationControl.IInformationPresenterExtension fPresenter;
    private IWorkbenchPart fPart;
    private IDocumentation fDocument;
    private IDocumentationProvider fProvider;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference.getId().equals(DocumentationView.this.getSite().getId())) {
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPage().getActivePart();
                if (iWorkbenchPart != null) {
                    DocumentationView.this.selectionChanged(iWorkbenchPart, iWorkbenchPartReference.getPage().getSelection());
                }
                DocumentationView.this.startListeningForSelectionChanges();
            }
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference.getId().equals(DocumentationView.this.getSite().getId())) {
                DocumentationView.this.stopListeningForSelectionChanges();
            }
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            if (!iWorkbenchPartReference.getId().equals(DocumentationView.this.getSite().getId())) {
                IWorkbenchPart iWorkbenchPart;
                ISelectionProvider iSelectionProvider = (iWorkbenchPart = iWorkbenchPartReference.getPart(false)).getSite().getSelectionProvider();
                DocumentationView.this.selectionChanged(iWorkbenchPart, iSelectionProvider == null ? null : iSelectionProvider.getSelection());
            }
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }
    };
    static /* synthetic */ Class class$com$spket$ui$text$IDocumentationProvider;
    static /* synthetic */ Class class$com$spket$ui$text$IDocumentation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initStyleSheet() {
        Bundle bundle = Platform.getBundle((String)"com.spket.ui");
        URL uRL = FileLocator.find((Bundle)bundle, (IPath)new Path("config").append("doc.css"), null);
        if (uRL == null) {
            return;
        }
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
            string = bufferedReader.readLine();
        }
        fgStyleSheet = stringBuffer.toString();
        Object var6_6 = null;
        if (bufferedReader == null) return;
        try {
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                UIPlugin.log(iOException);
                Object var6_7 = null;
                if (bufferedReader == null) return;
                try {
                    bufferedReader.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void createPartControl(Composite composite) {
        Display display = composite.getDisplay();
        Color color = display.getSystemColor(29);
        this.fBackgroundColorRGB = color.getRGB();
        try {
            this.fBrowser = new Browser(composite, 0);
            this.fIsUsingBrowserWidget = true;
            this.fBrowser.setForeground(display.getSystemColor(28));
            this.fBrowser.addListener(35, new Listener(){

                public void handleEvent(Event event) {
                    event.doit = false;
                }
            });
        }
        catch (SWTError sWTError) {
            this.fIsUsingBrowserWidget = false;
        }
        if (this.fIsUsingBrowserWidget) {
            DocumentationView.initStyleSheet();
            this.setInput(null);
        } else {
            this.fText = new StyledText(composite, 768);
            this.fText.setEditable(false);
            this.fText.setBackground(color);
            this.fText.setForeground(display.getSystemColor(28));
            this.fPresentation = new TextPresentation();
            this.fPresenter = new HTMLTextPresenter(false);
            this.fText.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    if (DocumentationView.this.fDocument != null) {
                        DocumentationView.this.setInput(DocumentationView.this.computeInput(DocumentationView.this.fDocument));
                    }
                }
            });
        }
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.fPartListener);
    }

    public void setFocus() {
        if (this.fIsUsingBrowserWidget) {
            this.fBrowser.setFocus();
        } else {
            this.fText.setFocus();
        }
    }

    public void dispose() {
        this.fPart = null;
        this.fProvider = null;
        Worker worker = this.fWorker;
        this.fWorker = null;
        if (worker != null) {
            worker.cancel();
        }
        super.dispose();
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.fPartListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        Object object;
        Object object2;
        if (iWorkbenchPart.equals((Object)this)) {
            return;
        }
        if (this.fPart != iWorkbenchPart) {
            this.fPart = iWorkbenchPart;
            object2 = null;
            if (iWorkbenchPart instanceof IDocumentationProvider) {
                object2 = (IDocumentationProvider)iWorkbenchPart;
            } else {
                object = iWorkbenchPart.getAdapter(class$com$spket$ui$text$IDocumentationProvider == null ? (class$com$spket$ui$text$IDocumentationProvider = DocumentationView.class$("com.spket.ui.text.IDocumentationProvider")) : class$com$spket$ui$text$IDocumentationProvider);
                if (object != null) {
                    object2 = (IDocumentationProvider)object;
                }
            }
            if (this.fProvider != object2) {
                object = this.fMonitor;
                synchronized (object) {
                    this.fProvider = object2;
                }
            }
        }
        if (this.fProvider != null) {
            if (this.fWorker == null) {
                this.fWorker = new Worker();
                this.fWorker.start();
            } else {
                if (!this.fWorker.isAlive()) {
                    try {
                        this.fWorker.start();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                }
                this.fWorker.reset();
            }
            return;
        }
        object2 = null;
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object instanceof IDocumentation) {
                object2 = (IDocumentation)object;
            } else if (object instanceof IAdaptable) {
                object2 = (IDocumentation)((IAdaptable)object).getAdapter(class$com$spket$ui$text$IDocumentation == null ? (class$com$spket$ui$text$IDocumentation = DocumentationView.class$("com.spket.ui.text.IDocumentation")) : class$com$spket$ui$text$IDocumentation);
            }
        }
        if (object2 == null) {
            return;
        }
        if (this.fDocument != object2) {
            this.fDocument = object2;
            this.setInput(this.computeInput((IDocumentation)object2));
        }
    }

    protected void updateDocument() {
        if (this.fProvider == null) {
            return;
        }
        Worker worker = this.fWorker;
        if (worker == null || worker.isDirty()) {
            return;
        }
        IDocumentation iDocumentation = this.fProvider.getDocument();
        if (iDocumentation == null) {
            return;
        }
        if (this.fDocument != iDocumentation) {
            this.fDocument = iDocumentation;
            this.setInput(this.computeInput(iDocumentation));
        }
    }

    protected String computeInput(IDocumentation iDocumentation) {
        if (iDocumentation == null) {
            return null;
        }
        String string = iDocumentation.getDocumentAsHTML();
        if (string == null) {
            string = iDocumentation.getDocument();
        }
        if (string != null) {
            String string2 = iDocumentation.getStyleSheet();
            StringBuffer stringBuffer = new StringBuffer(string.length());
            HTMLPrinter.insertPageProlog(stringBuffer, 0, this.fBackgroundColorRGB, string2 == null ? fgStyleSheet : string2);
            stringBuffer.append(string);
            HTMLPrinter.addPageEpilog(stringBuffer);
            return stringBuffer.toString();
        }
        return null;
    }

    protected void setInput(String string) {
        if (string == null) {
            string = "";
        }
        if (this.fIsUsingBrowserWidget) {
            if (string.length() > 0) {
                boolean bl;
                boolean bl2 = bl = (this.getSite().getShell().getStyle() & 0x4000000) != 0;
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    HTMLPrinter.insertStyles(stringBuffer, new String[]{"direction:rtl"});
                    string = stringBuffer.toString();
                }
                this.fBrowser.setText(string);
            } else {
                if (fgDocument == null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    HTMLPrinter.insertPageProlog(stringBuffer, 0, this.fBackgroundColorRGB, fgStyleSheet);
                    fgDocument = stringBuffer.toString();
                }
                this.fBrowser.setText(fgDocument);
            }
        } else {
            this.fPresentation.clear();
            if (string.length() > 0) {
                Rectangle rectangle = this.fText.getClientArea();
                try {
                    string = this.fPresenter.updatePresentation((Drawable)this.fText.getShell(), string, this.fPresentation, rectangle.width, rectangle.height);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return;
                }
            }
            this.fText.setText(string);
            TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
        }
    }

    protected void startListeningForSelectionChanges() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    protected void stopListeningForSelectionChanges() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Worker
    extends Thread {
        private int fDelay = 500;
        private boolean fReset = false;
        private boolean fIsDirty = false;
        private boolean fCanceled = false;

        public Worker() {
            super("Document Thread");
            this.setPriority(1);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            this.fCanceled = true;
            Object object = DocumentationView.this.fMonitor;
            synchronized (object) {
                DocumentationView.this.fMonitor.notifyAll();
            }
        }

        public synchronized void reset() {
            this.fIsDirty = true;
            this.fReset = true;
        }

        public synchronized boolean isDirty() {
            return this.fIsDirty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.fCanceled) {
                Object object = DocumentationView.this.fMonitor;
                synchronized (object) {
                    try {
                        DocumentationView.this.fMonitor.wait(this.fDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.fCanceled) break;
                if (!this.isDirty()) continue;
                object = this;
                synchronized (object) {
                    if (this.fReset) {
                        this.fReset = false;
                        continue;
                    }
                    this.fIsDirty = false;
                }
                if (DocumentationView.this.fProvider == null) continue;
                object = DocumentationView.this.getSite().getShell();
                if (object.isDisposed()) {
                    return;
                }
                Display display = object.getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(this){
                    private final /* synthetic */ Worker this$1;
                    {
                        this.this$1 = worker;
                    }

                    public void run() {
                        Worker.access$200(this.this$1).updateDocument();
                    }
                });
            }
        }

        static /* synthetic */ DocumentationView access$200(Worker worker) {
            return worker.DocumentationView.this;
        }
    }
}

