/*
 * Decompiled with CFR 0.152.
 */
package com.spket.util;

import com.spket.util.IRenderer;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Renderer
implements IRenderer {
    private static IRenderer renderer;
    private BufferedImage fImage;

    public static IRenderer getRenderer() {
        if (renderer == null) {
            if ("win32".equals(SWT.getPlatform())) {
                try {
                    renderer = (IRenderer)Class.forName("com.spket.internal.win32.Renderer").newInstance();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    renderer = null;
                }
            }
            if (renderer == null) {
                renderer = new Renderer();
            }
        }
        return renderer;
    }

    public BufferedImage createImage(int n, int n2) {
        Rectangle rectangle;
        int n3 = (n + 3) / 4 * 4;
        int n4 = n2;
        if (this.fImage != null && this.fImage.getWidth() >= n3 && this.fImage.getHeight() >= n4) {
            return this.fImage;
        }
        Display display = Display.getCurrent();
        if (display != null && (rectangle = display.getBounds()) != null) {
            if (n3 < rectangle.width && (n3 = rectangle.width) % 4 != 0) {
                n3 = (n3 + 3) / 4 * 4;
            }
            if (n4 < rectangle.height) {
                n4 = rectangle.height;
            }
        }
        this.fImage = new BufferedImage(n3, n4, 5);
        return this.fImage;
    }

    public boolean drawImage(GC gC, BufferedImage bufferedImage, int n, int n2) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (writableRaster == null) {
            return false;
        }
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        if (dataBuffer.getDataType() == 0 && dataBuffer instanceof DataBufferByte) {
            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
            PaletteData paletteData = new PaletteData(255, 65280, 0xFF0000);
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), 24, paletteData, 4, byArray);
            Image image = new Image(null, imageData);
            gC.drawImage(image, n, n2);
            image.dispose();
            return true;
        }
        return false;
    }
}

