/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.widget.IPainter;
import com.spket.widget.IPopup;
import com.spket.widget.IStatuProvider;
import com.spket.widget.UIUtils;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.CPopup;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class CPicker
extends Composite
implements IPopup,
IStatuProvider {
    private static final int F_MOUSE_OVER = 1;
    private static final int F_MOUSE_DOWN = 2;
    protected static final int GAP = 5;
    protected static final int DROP_DOWN_WIDTH = 15;
    private int flags;
    private int fItemSize;
    private CPopup popup;
    protected IPainter painter = UIUtils.getPainter();

    private static int checkStyle(int n) {
        n = (n & 0x800) != 0 ? 2048 : ((n & 0x800000) != 0 ? 0x800000 : 0);
        return n | 0x40000 | 0x100000;
    }

    public CPicker(Composite composite, int n) {
        super(composite, CPicker.checkStyle(n));
        this.installListeners();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3 = this.getBorderWidth();
        int n4 = this.getItemSize() + 5 + 5;
        int n5 = n3 * 2 + n4 * 2 + 15;
        int n6 = n3 * 2 + n4;
        return new Point(n5, n6);
    }

    public void setFont(Font font) {
        this.fItemSize = 0;
        super.setFont(font);
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.getEnabled();
        super.setEnabled(bl);
        if (bl2 != bl) {
            this.redraw();
        }
    }

    public int getStatus() {
        if (this.getFlag(2)) {
            return 2;
        }
        if (this.getFlag(1)) {
            return 1;
        }
        return 0;
    }

    public Rectangle getBounds(boolean bl) {
        Composite composite;
        Rectangle rectangle = this.getBounds();
        if (bl && (composite = this.getParent()) != null) {
            Point point = composite.toDisplay(rectangle.x, rectangle.y);
            rectangle.x = point.x;
            rectangle.y = point.y;
        }
        return rectangle;
    }

    public final Control createControl(Composite composite, int n) {
        if (composite == null) {
            composite = this.getShell();
        }
        this.disposePopup();
        this.popup = this.createPopup(composite, n);
        if (this.popup != null) {
            this.popup.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    CPicker.this.getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (!1.access$000(this.this$1).isDisposed()) {
                                1.access$000(this.this$1).onSelectionChanged();
                                CPicker.access$100(1.access$000(this.this$1));
                            }
                        }
                    });
                }

                static /* synthetic */ CPicker access$000(1 var0) {
                    return var0.CPicker.this;
                }
            });
        }
        return this.popup;
    }

    private void disposePopup() {
        if (UIUtils.okToUse((Widget)this.popup)) {
            this.popup.dispose();
            this.popup = null;
        }
    }

    protected int getItemSize() {
        if (this.fItemSize == 0) {
            GC gC = new GC((Drawable)this);
            this.fItemSize = gC.stringExtent((String)"gM").y;
            gC.dispose();
        }
        return this.fItemSize;
    }

    protected void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        CPicker.this.onPaint(event);
                        break;
                    }
                    case 6: {
                        CPicker.this.setFlag(1, true);
                        CPicker.this.redraw();
                        break;
                    }
                    case 7: {
                        CPicker.this.setFlag(1, false);
                        CPicker.this.redraw();
                        break;
                    }
                    case 3: {
                        CPicker.this.setFlag(2, true);
                        CPicker.this.redraw();
                        break;
                    }
                    case 4: {
                        CPicker.this.onMouseUp(event);
                        break;
                    }
                    case 12: {
                        CPicker.this.onDispose();
                    }
                }
            }
        };
        int[] nArray = new int[]{9, 7, 6, 3, 4, 11, 31, 12};
        for (int i = 0; i < nArray.length; ++i) {
            this.addListener(nArray[i], listener);
        }
    }

    protected void onDispose() {
    }

    protected void onPaint(Event event) {
        int n;
        int n2;
        GC gC = event.gc;
        Rectangle rectangle = this.getClientArea();
        gC.setBackground(this.getBackground());
        gC.fillRectangle(rectangle);
        this.painter.drawBorder((Control)this, gC, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n3 = rectangle.width - 15 - 10 - 1;
        int n4 = rectangle.height - 10 - 1;
        if (n3 > 0 && n4 > 0) {
            n2 = rectangle.x + 5;
            n = rectangle.y + 5;
            this.paintContent(gC, n2, n, n3, n4);
        }
        n3 = 15;
        n2 = rectangle.x + rectangle.width - n3 - 1;
        n = rectangle.y + 1;
        n4 = rectangle.height - 2;
        this.painter.drawDropdownButton((Control)this, gC, n2, n, n3, n4);
    }

    protected void onMouseUp(Event event) {
        if (!this.getFlag(2)) {
            return;
        }
        this.setFlag(2, false);
        this.redraw();
        Rectangle rectangle = this.getClientArea();
        if (!rectangle.contains(event.x, event.y)) {
            return;
        }
        UIUtils.popup(this, 131072);
    }

    protected boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    protected void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    protected abstract void onSelectionChanged();

    protected abstract CPopup createPopup(Composite var1, int var2);

    protected abstract void paintContent(GC var1, int var2, int var3, int var4, int var5);

    static /* synthetic */ void access$100(CPicker cPicker) {
        cPicker.disposePopup();
    }
}

