/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.widget.CItem;
import com.spket.widget.CList;
import com.spket.widget.UIUtils;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class CalendarList
extends CList {
    private static final int WEEKS = 6;
    private static final int DAY_PER_WEEK = 7;
    private int year;
    private int month;
    private int day;
    private Locale locale;
    private int todayIndex = -1;
    private CItem[] headers = new CItem[7];

    public CalendarList(Composite composite, int n) {
        super(composite, n);
        int n2;
        this.locale = Locale.getDefault();
        this.fItemCount = 42;
        this.fItems = new CItem[this.fItemCount];
        for (n2 = 0; n2 < this.fItemCount; ++n2) {
            this.fItems[n2] = new DayItem();
        }
        for (n2 = 0; n2 < 7; ++n2) {
            this.headers[n2] = new CItem();
        }
        Calendar calendar = Calendar.getInstance(this.locale);
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.day = calendar.get(5);
        this.updateDate();
    }

    public void setFont(Font font) {
        this.setFlag(1, false);
        super.setFont(font);
    }

    public void setLocale(Locale locale) {
        if (this.locale == locale) {
            return;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.locale.equals(locale)) {
            return;
        }
        this.locale = locale;
        this.updateDate();
        this.setFlag(1, false);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.layoutHeader();
        int n3 = this.headers[0].bounds.width * 7 + 6;
        int n4 = this.headers[0].bounds.height * 7 + 6;
        return new Point(n3, n4);
    }

    public int getColumnCount() {
        return 7;
    }

    public void setColumnCount(int n) {
    }

    protected int getMinimumColumns() {
        return 7;
    }

    protected void layoutHeader() {
        Point point;
        int n;
        GC gC = new GC((Drawable)this);
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 7; ++n) {
            point = gC.stringExtent(this.headers[n].text);
            if (n2 < point.x) {
                n2 = point.x;
            }
            if (n3 >= point.y) continue;
            n3 = point.y;
        }
        gC.dispose();
        n2 += 6;
        n3 += 6;
        for (n = 0; n < 7; ++n) {
            point = this.headers[n].bounds;
            point.width = n2;
            point.height = n3;
        }
    }

    protected void updateDate() {
        DayItem dayItem;
        int n;
        int n2;
        Calendar calendar = Calendar.getInstance(this.locale);
        int n3 = calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] stringArray = dateFormatSymbols.getShortWeekdays();
        int n4 = n3;
        for (n2 = 0; n2 < 7; ++n2) {
            this.headers[n2].text = stringArray[n4++];
            if (n4 <= 7) continue;
            n4 = 1;
        }
        n2 = calendar.get(1);
        n4 = calendar.get(2);
        int n5 = calendar.get(5);
        if (n2 != this.year) {
            calendar.set(1, this.year);
        }
        if (n4 != this.month) {
            calendar.set(2, this.month);
        }
        calendar.set(5, 1);
        int n6 = calendar.get(7);
        if (n6 <= n3) {
            n6 += 7;
        }
        this.todayIndex = -1;
        for (n = (n6 -= n3) - 1; n >= 0; --n) {
            dayItem = (DayItem)this.fItems[n];
            calendar.add(5, -1);
            dayItem.day = calendar.get(5);
            if (this.todayIndex != -1 || n5 != dayItem.day || n4 != calendar.get(2) || n2 != calendar.get(1)) continue;
            this.todayIndex = n;
        }
        calendar.add(5, n6);
        n = calendar.getActualMaximum(5) + n6;
        int n7 = n6;
        int n8 = 1;
        while (n7 < n) {
            dayItem = (DayItem)this.fItems[n7];
            dayItem.day = n8;
            if (this.todayIndex == -1 && n5 == n8 && n4 == this.month && n2 == this.year) {
                this.todayIndex = n7;
            }
            if (n8 == this.day) {
                this.fSelectedIndex = n7;
            }
            ++n7;
            ++n8;
        }
        calendar.add(5, calendar.getActualMaximum(5));
        for (n7 = n; n7 < this.fItemCount; ++n7) {
            dayItem = (DayItem)this.fItems[n7];
            dayItem.day = calendar.get(5);
            if (this.todayIndex == -1 && n5 == dayItem.day && n4 == calendar.get(2) && n2 == calendar.get(1)) {
                this.todayIndex = n7;
            }
            calendar.add(5, 1);
        }
    }

    protected void doLayout() {
        this.layoutHeader();
        Rectangle rectangle = this.headers[0].bounds;
        int n = rectangle.width;
        int n2 = rectangle.height;
        rectangle = this.getClientArea();
        int n3 = rectangle.x + 3;
        int n4 = rectangle.y + 3;
        int n5 = 0;
        for (int i = 0; i < this.fItemCount; ++i) {
            ++n5;
            Rectangle rectangle2 = this.fItems[i].bounds;
            rectangle2.x = n3;
            rectangle2.y = n4;
            rectangle2.width = n;
            rectangle2.height = n2;
            if (n5 < 7) {
                n3 += n;
                continue;
            }
            n5 = 0;
            n3 = rectangle.x + 3;
            n4 += n2;
        }
    }

    protected void paintBackground(GC gC, Rectangle rectangle) {
        Display display = this.getDisplay();
        Color color = gC.getForeground();
        Color color2 = gC.getBackground();
        gC.setForeground(display.getSystemColor(20));
        gC.setBackground(display.getSystemColor(18));
        Rectangle rectangle2 = this.getClientArea();
        gC.fillGradientRectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
        gC.setForeground(color);
        gC.setBackground(color2);
    }

    protected void paintContentBackground(GC gC, Rectangle rectangle) {
        Image image;
        super.paintContentBackground(gC, rectangle);
        if (this.todayIndex != -1 && (image = UIUtils.getImage("today.gif")) != null) {
            Rectangle rectangle2 = image.getBounds();
            Rectangle rectangle3 = this.getBounds(this.todayIndex);
            rectangle2.x = rectangle3.x - (rectangle2.width - rectangle3.width) / 2;
            rectangle2.y = rectangle3.y - (rectangle2.height - rectangle3.height) / 2;
            if (rectangle2.intersects(rectangle)) {
                gC.drawImage(image, rectangle2.x, rectangle2.y);
            }
        }
    }

    protected void drawItem(GC gC, int n) {
        DayItem dayItem = (DayItem)this.getItem(n);
        if (dayItem == null) {
            return;
        }
        Rectangle rectangle = dayItem.bounds;
        if (this.todayIndex == n) {
            // empty if block
        }
        if (this.fSelectedIndex == n) {
            // empty if block
        }
        gC.drawString(String.valueOf(dayItem.day), rectangle.x + 3, rectangle.y + 3, true);
    }

    private static final class DayItem
    extends CItem {
        int day;

        private DayItem() {
        }
    }
}

