/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.widget.MaskEdit;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;

public class SimpleMaskModel
implements MaskEdit.MaskModel {
    private static final int F_CHAR = 0;
    private static final int F_ALNUM = 1;
    private static final int F_ALPHA = 2;
    private static final int F_DIGIT = 3;
    private static final int F_GRAPH = 4;
    private static final int F_LOWER = 5;
    private static final int F_PUNCT = 6;
    private static final int F_UPPER = 7;
    private static final int F_XDIGIT = 8;
    private static final char DEFAULT_MASK = ' ';
    private static final String PUNCTUATION = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
    private char maskChar;
    private String pattern;
    private Node[] nodes;
    private StyledText styledText;
    private TextListener textListener;

    public SimpleMaskModel(String string) {
        this(string, ' ');
    }

    public SimpleMaskModel(String string, char c) {
        this.maskChar = c;
        this.pattern = string;
        this.parse();
    }

    public boolean usesOverwriteMode() {
        return true;
    }

    public void install(StyledText styledText) {
        if (this.styledText == styledText) {
            return;
        }
        this.uninstall();
        this.styledText = styledText;
        styledText.setText(this.getText());
        if (this.textListener == null) {
            this.textListener = new TextListener();
        }
        styledText.addVerifyListener((VerifyListener)this.textListener);
        styledText.addVerifyKeyListener((VerifyKeyListener)this.textListener);
        styledText.addLineStyleListener((LineStyleListener)this.textListener);
        styledText.addExtendedModifyListener((ExtendedModifyListener)this.textListener);
    }

    public void uninstall() {
        if (this.styledText != null && !this.styledText.isDisposed()) {
            if (this.textListener != null) {
                this.styledText.removeVerifyListener((VerifyListener)this.textListener);
                this.styledText.removeVerifyKeyListener((VerifyKeyListener)this.textListener);
                this.styledText.removeLineStyleListener((LineStyleListener)this.textListener);
                this.styledText.removeExtendedModifyListener((ExtendedModifyListener)this.textListener);
            }
            this.styledText = null;
        }
    }

    protected String getText() {
        int n = this.nodes.length;
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            Node node = this.nodes[i];
            if (node.type == 0) {
                stringBuffer.append(node.c);
                continue;
            }
            stringBuffer.append(this.maskChar);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected String[] filte(String string, StringBuffer stringBuffer, int n, int n2) {
        int n3;
        ArrayList<String> arrayList = null;
        int n4 = this.nodes.length - n;
        int n5 = Math.min(n4, n2 - n);
        if (n5 < (n3 = Math.min(n4, string == null ? 0 : string.length()))) {
            n5 = n3;
        }
        if (stringBuffer != null) {
            stringBuffer.ensureCapacity(n5);
        }
        if (n3 > 0) {
            arrayList = new ArrayList<String>(n3);
            String string2 = this.styledText.getText(n, n + n5 - 1);
            for (int i = 0; i < n3; ++i) {
                char c = string.charAt(i);
                String string3 = this.valid(n + i, c);
                if (string3 == null) {
                    if (stringBuffer == null) continue;
                    stringBuffer.append(c);
                    continue;
                }
                arrayList.add(string3);
                if (stringBuffer == null) continue;
                stringBuffer.append(string2.charAt(i));
            }
        }
        if (stringBuffer != null && stringBuffer.length() < n5) {
            void var9_13;
            n2 = (n += stringBuffer.length()) + n5 - stringBuffer.length();
            int stringArray = n;
            while (var9_13 < n2) {
                if (this.nodes[var9_13].type == 0) {
                    stringBuffer.append(this.nodes[var9_13].c);
                } else {
                    stringBuffer.append(this.maskChar);
                }
                ++var9_13;
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public Point getEditableRange(int n, String string) {
        if (string == null || n >= string.length()) {
            return null;
        }
        if (this.nodes == null || n >= this.nodes.length) {
            return null;
        }
        if (this.nodes[n].type == 0) {
            return null;
        }
        int n2 = n;
        int n3 = n;
        while (n3 >= 0 && this.nodes[n3].type != 0) {
            n2 = n3--;
        }
        n3 = n2 + 1;
        int n4 = string.length();
        for (int i = n2 + 1; i < n4 && this.nodes[i].type != 0; ++i) {
            ++n3;
        }
        return new Point(n2, n3);
    }

    protected void parse() {
        if (this.pattern == null || this.pattern.length() == 0) {
            this.error("pattern needed", 0);
        }
        int n = 0;
        boolean bl = false;
        int n2 = this.pattern.length();
        ArrayList<Node> arrayList = new ArrayList<Node>(n2);
        block14: while (n < n2) {
            char c = this.pattern.charAt(n++);
            if (bl) {
                switch (c) {
                    case '!': 
                    case '#': 
                    case '&': 
                    case '*': 
                    case '/': 
                    case '@': 
                    case 'A': 
                    case 'a': 
                    case 'x': {
                        arrayList.add(new Node(c));
                        break;
                    }
                    default: {
                        this.error("unsupported escape squence", n);
                    }
                }
                bl = false;
                continue;
            }
            switch (c) {
                case '/': {
                    bl = true;
                    continue block14;
                }
                case '#': {
                    arrayList.add(new Node(3));
                    continue block14;
                }
                case 'x': {
                    arrayList.add(new Node(8));
                    continue block14;
                }
                case '@': {
                    arrayList.add(new Node(2));
                    continue block14;
                }
                case '&': {
                    arrayList.add(new Node(1));
                    continue block14;
                }
                case '!': {
                    arrayList.add(new Node(6));
                    continue block14;
                }
                case '*': {
                    arrayList.add(new Node(4));
                    continue block14;
                }
                case 'a': {
                    arrayList.add(new Node(5));
                    continue block14;
                }
                case 'A': {
                    arrayList.add(new Node(7));
                    continue block14;
                }
            }
            arrayList.add(new Node(c));
        }
        if (arrayList.size() > 0) {
            this.nodes = new Node[arrayList.size()];
            arrayList.toArray(this.nodes);
        } else {
            this.error("internal error", 0);
        }
    }

    protected boolean isPunctuation(char c) {
        return PUNCTUATION.indexOf(c) != -1;
    }

    protected String valid(int n, char c) {
        String string = null;
        switch (this.nodes[n].type) {
            case 0: {
                if (this.nodes[n].c == c) break;
                string = "";
                break;
            }
            case 3: {
                if (Character.isDigit(c)) break;
                string = "0-9";
                break;
            }
            case 8: {
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') break;
                string = "0-9a-fA-F";
                break;
            }
            case 5: {
                if (Character.getType(c) == 2) break;
                string = "a-z";
                break;
            }
            case 7: {
                if (Character.getType(c) == 1) break;
                string = "A-Z";
                break;
            }
            case 2: {
                if (Character.isLetter(c)) break;
                string = "a-zA-Z";
                break;
            }
            case 1: {
                if (Character.isLetterOrDigit(c)) break;
                string = "0-9a-zA-Z";
                break;
            }
            case 6: {
                if (this.isPunctuation(c)) break;
                string = PUNCTUATION;
                break;
            }
            case 4: {
                if (Character.isLetterOrDigit(c) || this.isPunctuation(c)) break;
                string = "alphanumeric or punctuation";
            }
        }
        return string;
    }

    protected void error(String string, int n) {
        throw new PatternSyntaxException(string, this.pattern, n);
    }

    protected void onGetStyle(LineStyleEvent lineStyleEvent) {
    }

    protected int relocate(int n) {
        int n2 = n;
        int n3 = this.nodes.length;
        if (n2 < n3 && this.nodes[n2].type == 0) {
            ++n2;
            while (n2 < n3) {
                if (this.nodes[n2].type != 0) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    protected void onModifyText(ExtendedModifyEvent extendedModifyEvent) {
        int n = extendedModifyEvent.start + extendedModifyEvent.length;
        int n2 = this.relocate(n);
        if (n2 != n) {
            this.styledText.setCaretOffset(n2);
        }
    }

    protected void onVerifyKey(VerifyEvent verifyEvent) {
        int n = verifyEvent.keyCode != 0 ? this.styledText.getKeyBinding(verifyEvent.keyCode | verifyEvent.stateMask) : this.styledText.getKeyBinding(verifyEvent.character | verifyEvent.stateMask);
        if (n == 0x1000001) {
            int n2;
            int n3 = n2 = Math.min(this.nodes.length - 1, this.styledText.getCaretOffset());
            if (this.nodes[n2].type != 0) {
                while (n2 > 0) {
                    if (this.nodes[--n2].type != 0) continue;
                    n3 = n2 + 1;
                    break;
                }
            }
            if (this.nodes[n2].type == 0) {
                for (int i = n2 - 1; i > 0; ++i) {
                    if (this.nodes[i].type == 0) continue;
                    n3 = i;
                    break;
                }
            }
            if (this.nodes[n3].type != 0) {
                while (n3 > 0 && this.nodes[n3 - 1].type != 0) {
                    --n3;
                }
            }
            if (n3 != n2) {
                this.styledText.setCaretOffset(n3);
            }
        } else if (n == 0x1000002) {
            int n4;
            int n5 = n4 = Math.min(this.nodes.length - 1, this.styledText.getCaretOffset());
            if (this.nodes[n4].type != 0) {
                for (int i = n4 + 1; i < this.nodes.length; ++i) {
                    if (this.nodes[i].type != 0) continue;
                    n5 = i;
                    break;
                }
            }
            if (this.nodes[n5].type == 0) {
                while (n5 < this.nodes.length) {
                    if (this.nodes[n5].type != 0) {
                        if (n5 == n4) break;
                        this.styledText.setCaretOffset(n5);
                        break;
                    }
                    ++n5;
                }
            }
        }
    }

    protected void onVerifyText(VerifyEvent verifyEvent) {
        int n = verifyEvent.end - verifyEvent.start;
        boolean bl = verifyEvent.doit = verifyEvent.start < this.nodes.length;
        if (!verifyEvent.doit) {
            return;
        }
        if (n == 1) {
            if (verifyEvent.text == null || verifyEvent.text.length() == 0) {
                boolean bl2 = verifyEvent.doit = this.nodes[verifyEvent.start].type != 0;
                if (verifyEvent.doit) {
                    verifyEvent.text = String.valueOf(this.maskChar);
                }
                return;
            }
            if (verifyEvent.text.length() == 1) {
                boolean bl3 = verifyEvent.doit = this.nodes[verifyEvent.start].type != 0;
                if (verifyEvent.doit) {
                    String string = this.valid(verifyEvent.start, verifyEvent.text.charAt(0));
                    verifyEvent.doit = string == null;
                }
                return;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        this.filte(verifyEvent.text, stringBuffer, verifyEvent.start, verifyEvent.end);
        if (n < stringBuffer.length()) {
            verifyEvent.doit = false;
            final int n2 = verifyEvent.start;
            final String string = stringBuffer.toString();
            this.styledText.getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (SimpleMaskModel.this.styledText != null && !SimpleMaskModel.this.styledText.isDisposed()) {
                        int n;
                        int n22 = SimpleMaskModel.this.styledText.getCaretOffset();
                        if (SimpleMaskModel.this.textListener != null) {
                            SimpleMaskModel.this.textListener.verify = false;
                            try {
                                SimpleMaskModel.this.styledText.replaceTextRange(n2, string.length(), string);
                            }
                            finally {
                                SimpleMaskModel.this.textListener.verify = true;
                            }
                        } else {
                            SimpleMaskModel.this.styledText.replaceTextRange(n2, string.length(), string);
                        }
                        if (n22 == SimpleMaskModel.this.styledText.getCaretOffset() && n22 != (n = SimpleMaskModel.this.relocate(n2 + string.length()))) {
                            SimpleMaskModel.this.styledText.setCaretOffset(n);
                        }
                    }
                }
            });
        } else {
            verifyEvent.text = stringBuffer.toString();
        }
    }

    private final class TextListener
    implements VerifyKeyListener,
    VerifyListener,
    LineStyleListener,
    ExtendedModifyListener {
        private boolean verify = true;

        private TextListener() {
        }

        public void verifyKey(VerifyEvent verifyEvent) {
            SimpleMaskModel.this.onVerifyKey(verifyEvent);
        }

        public void verifyText(VerifyEvent verifyEvent) {
            if (this.verify) {
                SimpleMaskModel.this.onVerifyText(verifyEvent);
            }
        }

        public void lineGetStyle(LineStyleEvent lineStyleEvent) {
            SimpleMaskModel.this.onGetStyle(lineStyleEvent);
        }

        public void modifyText(ExtendedModifyEvent extendedModifyEvent) {
            SimpleMaskModel.this.onModifyText(extendedModifyEvent);
        }
    }

    private static final class Node {
        private int type;
        private char c;

        public Node(int n) {
            this.type = n;
        }

        public Node(char c) {
            this.c = c;
            this.type = 0;
        }
    }
}

