/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.editors;

import com.spket.as.core.compiler.IProblem;
import com.spket.as.internal.compiler.ast.CompilationUnitDeclaration;
import com.spket.js.editors.JSItem;
import com.spket.js.editors.JSOutlinePage;
import com.spket.js.internal.JSPlugin;
import com.spket.js.internal.text.BracketInserter;
import com.spket.js.internal.text.JSFoldingSupport;
import com.spket.js.internal.text.JSPairMatcher;
import com.spket.js.internal.text.JSProblem;
import com.spket.js.internal.text.Partitioner;
import com.spket.js.internal.text.hover.JSHyperlinkDetector;
import com.spket.js.model.Context;
import com.spket.js.model.IASTListener;
import com.spket.js.model.ILexerContext;
import com.spket.js.model.ILexerProvider;
import com.spket.js.parser.LexerProvider;
import com.spket.js.text.JSSourceViewerConfiguration;
import com.spket.ui.editors.PlainTextEditor;
import com.spket.ui.text.IFoldingSupport;
import com.spket.ui.text.IProblemRequestor;
import com.spket.ui.text.TextTools;
import com.spket.util.Debug;
import com.spket.util.IDragSource;
import com.spket.util.StringUtils;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class JSEditor
extends PlainTextEditor
implements ILexerContext {
    private LexerProvider fLexerProvider;
    private Partitioner fPartitioner;
    private JSPairMatcher fBracketMatcher;
    private BracketInserter fBracketInserter;
    private long fLastModified;
    private boolean fShowSyntaxError;
    private IASTListener fASTListener = new IASTListener(){

        public void astAboutToBeChanged() {
            JSEditor.this.fLastModified = System.currentTimeMillis();
        }

        public void astChanged(CompilationUnitDeclaration compilationUnitDeclaration) {
            if (JSEditor.this.fShowSyntaxError) {
                JSEditor.this.updateSyntax(compilationUnitDeclaration);
            }
        }
    };
    static /* synthetic */ Class class$com$spket$js$model$ILexerContext;

    public LexerProvider getLexerProvider() {
        if (this.fLexerProvider == null) {
            this.fLexerProvider = this.createLexerProvider();
            this.fLexerProvider.addASTListener(this.fASTListener);
        }
        return this.fLexerProvider;
    }

    public ILexerProvider getLexerProvider(int n) {
        return this.getLexerProvider();
    }

    public Partitioner getPartitioner() {
        if (this.fPartitioner == null) {
            this.fPartitioner = new Partitioner(this.getDocumentPartitioning());
        }
        return this.fPartitioner;
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer instanceof ITextViewerExtension) {
            this.fBracketInserter = new BracketInserter(this, this.getDocumentPartitioning());
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            this.fBracketInserter.setCloseStringsEnabled(iPreferenceStore.getBoolean("js_closeStrings"));
            this.fBracketInserter.setCloseBracketsEnabled(iPreferenceStore.getBoolean("js_closeBrackets"));
            ((ITextViewerExtension)iSourceViewer).appendVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    public void dispose() {
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        if (this.fBracketInserter != null) {
            ISourceViewer iSourceViewer = this.getSourceViewer();
            if (iSourceViewer instanceof ITextViewerExtension) {
                ((ITextViewerExtension)iSourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
            }
            this.fBracketInserter = null;
        }
        if (this.fPartitioner != null) {
            this.fPartitioner.dispose();
            this.fPartitioner = null;
        }
        if (this.fLexerProvider != null) {
            if (this.fASTListener != null) {
                this.fLexerProvider.removeASTListener(this.fASTListener);
            }
            this.fLexerProvider.dispose();
            this.fLexerProvider = null;
        }
        this.fASTListener = null;
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        if ((class$com$spket$js$model$ILexerContext == null ? (class$com$spket$js$model$ILexerContext = JSEditor.class$("com.spket.js.model.ILexerContext")) : class$com$spket$js$model$ILexerContext).equals(clazz)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    public TextTools getTextTools() {
        return JSPlugin.getDefault().getTextTools();
    }

    public void reconcile() {
    }

    protected LexerProvider createLexerProvider() {
        LexerProvider lexerProvider = new LexerProvider();
        return lexerProvider;
    }

    protected boolean isFoldingEnabled() {
        return JSPlugin.getDefault().getPreferenceStore().getBoolean("js_folding");
    }

    protected void initializeEditor() {
        IPreferenceStore iPreferenceStore = JSPlugin.getDefault().getCombinedPreferenceStore();
        this.setPreferenceStore(iPreferenceStore);
        this.setSourceViewerConfiguration(this.createSourceViewerConfiguration(iPreferenceStore));
    }

    protected String getDocumentPartitioning() {
        return "___js_partitioning";
    }

    protected IContentOutlinePage createContentOutlinePage() {
        return new JSOutlinePage(this.getLexerProvider());
    }

    protected IFoldingSupport createFoldingSupport() {
        return new JSFoldingSupport(this.getLexerProvider());
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration(IPreferenceStore iPreferenceStore) {
        return new JSSourceViewerConfiguration(this, this.getTextTools().getColorManager(), iPreferenceStore, this.getDocumentPartitioning());
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport sourceViewerDecorationSupport) {
        if (this.fBracketMatcher == null) {
            this.fBracketMatcher = new JSPairMatcher(this.getPartitioner());
        }
        this.fShowSyntaxError = JSPlugin.getDefault().getPreferenceStore().getBoolean("syx.error");
        this.getLexerProvider();
        if (this.fLexerProvider != null) {
            this.fLexerProvider.setReportSyntaxError(this.fShowSyntaxError);
        }
        sourceViewerDecorationSupport.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        sourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys("matchingBrackets", "matchingBracketsColor");
        super.configureSourceViewerDecorationSupport(sourceViewerDecorationSupport);
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        super.doSetInput(iEditorInput);
        Context context = Context.getContext(iEditorInput);
        if (context != null) {
            context.initialize();
        }
        LexerProvider lexerProvider = this.getLexerProvider();
        lexerProvider.setPath(this.getPath());
        lexerProvider.setContext(context);
    }

    protected void openDeclaration(int n) {
        IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (iDocument == null) {
            return;
        }
        IHyperlink[] iHyperlinkArray = JSHyperlinkDetector.detectHyperlinks((ITextEditor)this, iDocument, this.getDocumentPartitioning(), n);
        if (iHyperlinkArray != null && iHyperlinkArray.length > 0) {
            iHyperlinkArray[0].open();
        }
    }

    protected void onOutlineSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        Object object;
        int n = -1;
        int n2 = 0;
        boolean bl = false;
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof JSItem) {
            JSItem jSItem = (JSItem)object;
            if (jSItem.range != null) {
                n = jSItem.range.x;
                n2 = jSItem.range.y;
                if (n2 > 0) {
                    n2 = n2 - n + 1;
                }
                if (n != -1) {
                    IWorkbenchWindow iWorkbenchWindow = this.getSite().getWorkbenchWindow();
                    IWorkbenchPart iWorkbenchPart = iWorkbenchWindow.getPartService().getActivePart();
                    boolean bl2 = bl = iWorkbenchPart == null || !iWorkbenchPart.equals(this);
                }
            }
        }
        if (bl && n >= 0 && n2 >= 0) {
            this.selectAndReveal(n, n2);
        }
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] stringArray = super.collectContextMenuPreferencePages();
        String[] stringArray2 = new String[stringArray.length + 5];
        stringArray2[0] = "com.spket.js.pref.jseditor";
        stringArray2[1] = "com.spket.js.pref.color";
        stringArray2[2] = "com.spket.js.pref.template";
        stringArray2[3] = "com.spket.js.pref.typing";
        stringArray2[4] = "com.spket.js.pref.profile";
        System.arraycopy(stringArray, 0, stringArray2, 5, stringArray.length);
        return stringArray2;
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (this.fBracketInserter != null) {
            if ("js_closeStrings".equals(string)) {
                this.fBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(string));
                return;
            }
            if ("js_closeBrackets".equals(string)) {
                this.fBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(string));
                return;
            }
        }
        if ("js_closeBrackets".equals(string)) {
            this.fShowSyntaxError = this.getPreferenceStore().getBoolean(string);
            if (this.fLexerProvider != null) {
                this.fLexerProvider.setReportSyntaxError(this.fShowSyntaxError);
            }
            return;
        }
        super.handlePreferenceStoreChanged(propertyChangeEvent);
    }

    protected int determineLineStartPosition(IDocument iDocument, String string, int n, int n2) {
        int n3;
        String string2 = "__dftl_partition_content_type";
        try {
            string2 = TextUtilities.getContentType((IDocument)iDocument, (String)this.getDocumentPartitioning(), (int)n2, (boolean)true);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        for (n3 = 0; n3 < n && Character.isWhitespace(string.charAt(n3)); ++n3) {
        }
        if (string2.equals("__js_jsdoc") || string2.equals("__js_multiline_comment")) {
            if (n3 < n - 1 && string.charAt(n3) == '*' && string.charAt(n3 + 1) != '/') {
                while (++n3 < n && Character.isWhitespace(string.charAt(n3))) {
                }
            }
        } else if (n3 < n - 1 && string.charAt(n3) == '/' && string.charAt(n3 + 1) == '/') {
            ++n3;
            while (++n3 < n && Character.isWhitespace(string.charAt(n3))) {
            }
        }
        return n3;
    }

    protected String getDropData(IDocument iDocument, int n, DropTargetEvent dropTargetEvent) {
        ISelection iSelection;
        int n2 = dropTargetEvent.detail;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(dropTargetEvent.currentDataType) && (iSelection = LocalSelectionTransfer.getTransfer().getSelection()) instanceof IStructuredSelection && !iSelection.isEmpty()) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object instanceof IDragSource) {
                int n3 = 2;
                switch (n2) {
                    case 1: {
                        n3 = 0;
                        break;
                    }
                    case 4: {
                        n3 = 1;
                    }
                }
                return ((IDragSource)object).toSource(n3);
            }
            int n4 = 0;
            int n5 = -1;
            String string = null;
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                ++n4;
                Object e = iterator.next();
                if (e instanceof IResource) {
                    String string2;
                    IResource iResource = (IResource)e;
                    if (n5 == -1) {
                        n5 = 0;
                        try {
                            string2 = TextUtilities.getPartition((IDocument)iDocument, (String)this.getDocumentPartitioning(), (int)n, (boolean)true);
                            if (string2 != null && n == string2.getOffset()) {
                                string2 = iDocument.getPartition(n - 1);
                            }
                            if (string2 != null) {
                                String string3 = string2.getType();
                                if ("__js_string".equals(string3)) {
                                    n5 = 1;
                                } else if ("__js_singleline_comment".equals(string3)) {
                                    n5 = 2;
                                } else if ("__js_multiline_comment".equals(string3)) {
                                    n5 = 3;
                                } else if ("__js_jsdoc".equals(string3)) {
                                    n5 = 4;
                                }
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Debug.debug((Throwable)badLocationException);
                        }
                    }
                    string2 = iResource.getFullPath().toString();
                    if (n5 != 1) {
                        string2 = '\"' + string2 + '\"';
                    }
                    if (n5 > 1 && iResource.getType() == 1) {
                        if (string == null) {
                            string = StringUtils.EMPTY_STRING;
                            switch (n2) {
                                case 1: 
                                case 4: {
                                    string = " @include";
                                }
                            }
                        }
                        if (string != null && string.length() > 0) {
                            stringBuffer.append(string);
                        }
                    }
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    continue;
                }
                stringBuffer.append(' ');
                stringBuffer.append(e.toString());
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
        }
        return super.getDropData(iDocument, n, dropTargetEvent);
    }

    private void updateSyntax(CompilationUnitDeclaration compilationUnitDeclaration) {
        long l = this.fLastModified;
        IAnnotationModel iAnnotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (iAnnotationModel instanceof IProblemRequestor) {
            int n;
            com.spket.ui.text.IProblem[] iProblemArray = null;
            IProblemRequestor iProblemRequestor = (IProblemRequestor)iAnnotationModel;
            if (this.fShowSyntaxError && compilationUnitDeclaration.compilationResult != null && (n = compilationUnitDeclaration.compilationResult.problemCount) > 0) {
                iProblemArray = new com.spket.ui.text.IProblem[n];
                IProblem[] iProblemArray2 = compilationUnitDeclaration.compilationResult.problems;
                for (int i = 0; i < n; ++i) {
                    if (l != this.fLastModified) {
                        return;
                    }
                    iProblemArray[i] = new JSProblem(iProblemArray2[i]);
                }
            }
            iProblemRequestor.beginReporting();
            if (iProblemArray != null && iProblemArray.length > 0) {
                for (n = 0; n < iProblemArray.length && l == this.fLastModified; ++n) {
                    iProblemRequestor.acceptProblem(iProblemArray[n]);
                }
            }
            iProblemRequestor.endReporting(this.fShowSyntaxError && l != this.fLastModified);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

