/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.js.internal.text.JSCommentScanner;
import com.spket.js.internal.text.JSWhitespaceDetector;
import com.spket.ui.text.CombinedWordRule;
import com.spket.ui.text.IColorManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class JSDocScanner
extends JSCommentScanner {
    private static String[] fgTokenProperties = new String[]{"java_doc_keyword", "java_doc_tag", "java_doc_link", "java_doc_default", "js_task_tag"};

    public JSDocScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore) {
        super(iColorManager, iPreferenceStore, "java_doc_default", fgTokenProperties);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    protected List createRules() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Token token = this.getToken("java_doc_tag");
        arrayList.add((Object)new TagRule((IToken)token));
        WordRule wordRule = new WordRule((IWordDetector)new HTMLCommentDetector(), (IToken)token);
        wordRule.addWord("<!--", (IToken)token);
        wordRule.addWord("--!>", (IToken)token);
        arrayList.add(wordRule);
        token = this.getToken("java_doc_link");
        arrayList.add(new SingleLineRule("{@link", "}", (IToken)token));
        arrayList.add(new SingleLineRule("{@value", "}", (IToken)token));
        arrayList.add(new WhitespaceRule((IWhitespaceDetector)new JSWhitespaceDetector()));
        arrayList.addAll(super.createRules());
        return arrayList;
    }

    protected List createMatchers() {
        List list = super.createMatchers();
        Token token = this.getToken("java_doc_keyword");
        CombinedWordRule.WordMatcher wordMatcher = new CombinedWordRule.WordMatcher((IToken)token){
            private final /* synthetic */ IToken val$token;
            {
                this.val$token = iToken;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IToken evaluate(ICharacterScanner iCharacterScanner, CombinedWordRule.CharacterBuffer characterBuffer) {
                int n = characterBuffer.length();
                if (n > 1 && characterBuffer.charAt(0) == '@') {
                    int n2;
                    try {
                        for (n2 = 0; n2 <= n; ++n2) {
                            iCharacterScanner.unread();
                        }
                        int n3 = iCharacterScanner.read();
                        --n2;
                        if (n3 == 42 || Character.isWhitespace((char)n3)) {
                            iCharacterScanner.unread();
                            IToken iToken = this.val$token;
                            return iToken;
                        }
                    }
                    finally {
                        while (n2 >= 0) {
                            iCharacterScanner.read();
                            --n2;
                        }
                    }
                }
                return Token.UNDEFINED;
            }
        };
        list.add(wordMatcher);
        return list;
    }

    class TagRule
    extends SingleLineRule {
        public TagRule(IToken iToken) {
            super("<", ">", iToken, '\u0000');
        }

        public TagRule(IToken iToken, char c) {
            super("<", ">", iToken, c);
        }

        private IToken evaluateToken() {
            try {
                String string = JSDocScanner.this.getDocument().get(JSDocScanner.this.getTokenOffset(), JSDocScanner.this.getTokenLength()) + ".";
                int n = 0;
                char c = string.charAt(++n);
                if (c == '/') {
                    c = string.charAt(++n);
                }
                while (Character.isWhitespace(c)) {
                    c = string.charAt(++n);
                }
                while (Character.isLetterOrDigit(c)) {
                    c = string.charAt(++n);
                }
                while (Character.isWhitespace(c)) {
                    c = string.charAt(++n);
                }
                if (n >= 2 && string.charAt(n) == this.fEndSequence[0]) {
                    return this.fToken;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return JSDocScanner.this.getToken("java_doc_default");
        }

        public IToken evaluate(ICharacterScanner iCharacterScanner) {
            IToken iToken = super.evaluate(iCharacterScanner);
            if (iToken == this.fToken) {
                return this.evaluateToken();
            }
            return iToken;
        }
    }

    static class HTMLCommentDetector
    implements IWordDetector {
        HTMLCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '<' || c == '-';
        }

        public boolean isWordPart(char c) {
            return c == '-' || c == '!' || c == '>';
        }
    }
}

