/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text.hover;

import com.spket.js.internal.text.hover.JSTextHover;
import com.spket.js.model.ILexerContext;
import com.spket.ui.text.DefaultInformationControlCreator;
import com.spket.util.StringUtils;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class JSInformationProvider
implements IInformationProvider,
IInformationProviderExtension2 {
    protected ITextEditor fEditor;
    protected IPartListener fPartListener;
    protected String fCurrentPerspective;
    protected ITextHover fImplementation;
    private String fPartitioning;
    private IInformationControlCreator fPresenterControlCreator;
    static /* synthetic */ Class class$com$spket$js$model$ILexerContext;

    public JSInformationProvider(ITextEditor iTextEditor, String string) {
        this.fEditor = iTextEditor;
        this.fPartitioning = string;
        if (this.fEditor != null) {
            this.fPartListener = new EditorWatcher();
            IWorkbenchWindow iWorkbenchWindow = this.fEditor.getSite().getWorkbenchWindow();
            iWorkbenchWindow.getPartService().addPartListener(this.fPartListener);
            this.update();
        }
    }

    protected void update() {
        IPerspectiveDescriptor iPerspectiveDescriptor;
        IWorkbenchWindow iWorkbenchWindow = this.fEditor.getSite().getWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null && (iPerspectiveDescriptor = iWorkbenchPage.getPerspective()) != null) {
            String string = iPerspectiveDescriptor.getId();
            if (this.fCurrentPerspective == null || this.fCurrentPerspective != string) {
                this.fImplementation = null;
                this.fCurrentPerspective = string;
                ILexerContext iLexerContext = (ILexerContext)this.fEditor.getAdapter(class$com$spket$js$model$ILexerContext == null ? (class$com$spket$js$model$ILexerContext = JSInformationProvider.class$("com.spket.js.model.ILexerContext")) : class$com$spket$js$model$ILexerContext);
                if (iLexerContext != null) {
                    this.fImplementation = new JSTextHover(iLexerContext, this.fPartitioning);
                }
            }
        }
    }

    public IRegion getSubject(ITextViewer iTextViewer, int n) {
        if (this.fImplementation != null) {
            return this.fImplementation.getHoverRegion(iTextViewer, n);
        }
        return null;
    }

    public String getInformation(ITextViewer iTextViewer, IRegion iRegion) {
        String string;
        if (this.fImplementation != null && !StringUtils.isEmpty((String)(string = this.fImplementation.getHoverInfo(iTextViewer, iRegion)))) {
            return string;
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new DefaultInformationControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class EditorWatcher
    implements IPartListener {
        EditorWatcher() {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart == JSInformationProvider.this.fEditor) {
                JSInformationProvider.this.fEditor.getSite().getWorkbenchWindow().getPartService().removePartListener(JSInformationProvider.this.fPartListener);
                JSInformationProvider.this.fPartListener = null;
            }
        }

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            JSInformationProvider.this.update();
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
            JSInformationProvider.this.update();
        }
    }
}

