/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.model;

import com.spket.js.model.Context;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSFunction;
import com.spket.js.model.JSObject;
import com.spket.js.model.ObjectImpl;
import com.spket.js.model.Param;
import com.spket.js.model.Slot;

public class FunctionImpl
extends ObjectImpl
implements JSFunction {
    private static final Param[] NO_PARAMS = new Param[0];
    private ISlot pSlot;
    protected int count;
    protected Param[] parameters;

    public FunctionImpl(String string) {
        super(string);
    }

    public String getFunctionName() {
        return this.getClassName();
    }

    public boolean isClass() {
        return true;
    }

    public void setClassName(String string) {
        JSObject jSObject;
        super.setClassName(string);
        if (this.pSlot != null && (jSObject = this.pSlot.getObject()) != null) {
            jSObject.setClassName(string);
        }
    }

    public int prototype() {
        return 2;
    }

    public ISlot getLocalSlot(String string) {
        if ("prototype".equals(string)) {
            return this.getPrototypeSlot();
        }
        return super.getLocalSlot(string);
    }

    public ISlot getSlot(String string) {
        if ("prototype".equals(string)) {
            return this.getPrototypeSlot();
        }
        return super.getSlot(string);
    }

    public Param[] getParameters() {
        if (this.parameters == null) {
            return NO_PARAMS;
        }
        return this.parameters == null ? NO_PARAMS : this.parameters;
    }

    public int getNumberOfParameters() {
        return this.count;
    }

    public void addParameter(String string, String string2) {
        this.addParameter(string, string2, 0);
    }

    public void addParameter(String string, String string2, int n) {
        if (this.parameters == null || this.count >= this.parameters.length) {
            Param[] paramArray = new Param[this.count + 2];
            if (this.count > 0) {
                System.arraycopy(this.parameters, 0, paramArray, 0, this.count);
            }
            this.parameters = paramArray;
        }
        this.parameters[this.count++] = new Param(string, string2, n);
    }

    public JSObject invoke(Context context, JSObject jSObject, Object[] objectArray) {
        return this.createObject(context, jSObject);
    }

    public JSObject construct(Context context, JSObject jSObject, Object[] objectArray) {
        return this.createObject(context, jSObject);
    }

    public JSObject createObject(Context context, JSObject jSObject) {
        ObjectImpl objectImpl = new ObjectImpl(this.getFunctionName());
        objectImpl.setParentScope(this.getParentScope());
        objectImpl.setPrototype(this.getClassPrototype());
        return objectImpl;
    }

    public void setPrototype(JSObject jSObject) {
        super.setPrototype(jSObject);
        if (this.pSlot != null) {
            System.err.println("already has prototype...");
            JSObject jSObject2 = this.pSlot.getObject();
            if (jSObject2 != null) {
                JSObject jSObject3 = null;
                if (jSObject instanceof JSFunction) {
                    JSObject jSObject4 = this.getParentScope();
                    jSObject3 = ((JSFunction)jSObject).construct(null, jSObject4, null);
                }
                jSObject2.setPrototype(jSObject3);
            }
        }
    }

    public void setProperty(String string, JSObject jSObject) {
        if ("prototype".equals(string)) {
            ISlot iSlot = this.getPrototypeSlot();
            if (iSlot != null) {
                JSObject jSObject2 = iSlot.getObject();
                jSObject2.setPrototype(jSObject);
            }
        } else {
            super.setProperty(string, jSObject);
        }
    }

    protected ISlot getPrototypeSlot() {
        if (this.pSlot == null) {
            JSObject jSObject;
            this.pSlot = new Slot();
            JSObject jSObject2 = this.getParentScope();
            ObjectImpl objectImpl = new ObjectImpl(this.getFunctionName());
            objectImpl.setParentScope(jSObject2);
            this.pSlot.setObject(objectImpl);
            if (jSObject2 != null && (jSObject = this.getPrototype()) instanceof JSFunction && (jSObject = ((JSFunction)jSObject).construct(null, jSObject2, null)) != null) {
                objectImpl.setPrototype(jSObject);
            }
        }
        return this.pSlot;
    }

    protected JSObject getClassPrototype() {
        ISlot iSlot = this.getPrototypeSlot();
        return iSlot.getObject();
    }
}

