/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.model;

import com.spket.js.internal.JSPlugin;
import com.spket.js.model.Context;
import com.spket.js.profile.ProfileContext;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;

public class ProjectContext
implements IResourceDeltaVisitor,
IResourceChangeListener {
    public static final String PROFILE = ".jspf";
    private Map fProjects = new HashMap();

    private ProjectContext() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public Context getContext(IProject iProject) {
        String string = iProject.getName();
        Holder holder = (Holder)this.fProjects.get(string);
        if (holder == null) {
            IPath iPath;
            holder = new Holder();
            this.fProjects.put(string, holder);
            IFile iFile = iProject.getFile(PROFILE);
            if (iFile.exists() && iFile.isAccessible() && (iPath = iFile.getLocation()) != null) {
                holder.context = new ProfileContext(iPath.toOSString());
                holder.context.initialize();
            }
        }
        return holder.context;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta != null) {
            try {
                iResourceDelta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException coreException) {
                JSPlugin.log(coreException.getStatus());
            }
        }
    }

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        if (iResourceDelta == null) {
            return false;
        }
        IResource iResource = iResourceDelta.getResource();
        if (iResource != null) {
            switch (iResource.getType()) {
                case 1: {
                    switch (iResourceDelta.getKind()) {
                        case 4: {
                            if ((iResourceDelta.getFlags() & 0x100) == 0) break;
                        }
                        case 1: 
                        case 2: {
                            IPath iPath = iResource.getFullPath();
                            if (iPath.segmentCount() != 2 || !PROFILE.equals(iPath.segment(1))) break;
                            this.fProjects.remove(iPath.segment(0));
                        }
                    }
                    return false;
                }
                case 4: {
                    switch (iResourceDelta.getKind()) {
                        case 2: {
                            this.fProjects.remove(iResource.getName());
                            return false;
                        }
                        case 4: {
                            if ((iResourceDelta.getFlags() & 0x4000) == 0) break;
                            this.fProjects.remove(iResource.getName());
                            return false;
                        }
                    }
                    return iResourceDelta.getFlags() == 0;
                }
                case 8: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void reloadProfiles(IProject[] iProjectArray) {
        if (iProjectArray != null && iProjectArray.length > 0) {
            int n = 0;
            for (int i = 0; i < iProjectArray.length; ++i) {
                IProject iProject = iProjectArray[i];
                Holder holder = (Holder)this.fProjects.get(iProject);
                if (holder == null) continue;
                ++n;
            }
            if (n > 0) {
                ReloadJob reloadJob = new ReloadJob(iProjectArray);
                reloadJob.setSystem(true);
                reloadJob.schedule();
            }
        }
    }

    private class ReloadJob
    extends UIJob {
        private IProject[] projects;

        public ReloadJob(IProject[] iProjectArray) {
            super("Reload Profile");
            this.projects = iProjectArray;
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            for (int i = 0; i < this.projects.length; ++i) {
                if (iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                IProject iProject = this.projects[i];
                Holder holder = (Holder)ProjectContext.this.fProjects.get(iProject.getName());
                if (holder == null || holder.context == null) continue;
                holder.context.reload();
            }
            return Status.OK_STATUS;
        }
    }

    private static class Holder {
        public Context context;

        private Holder() {
        }
    }
}

