/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.parser;

import com.spket.as.internal.compiler.ast.ASTNode;
import com.spket.as.internal.compiler.ast.Assignment;
import com.spket.as.internal.compiler.ast.BinaryExpression;
import com.spket.as.internal.compiler.ast.Block;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.FieldLiteral;
import com.spket.as.internal.compiler.ast.FunctionExpression;
import com.spket.as.internal.compiler.ast.IdentifierReference;
import com.spket.as.internal.compiler.ast.InvokeExpression;
import com.spket.as.internal.compiler.ast.ObjectInitializer;
import com.spket.as.internal.compiler.ast.Parameter;
import com.spket.as.internal.compiler.ast.ReturnStatement;
import com.spket.as.internal.compiler.ast.ThisReference;
import com.spket.as.internal.compiler.ast.VariableBinding;
import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.as.internal.compiler.parser.ScannerHelper;
import com.spket.js.model.Context;
import com.spket.js.model.ICompletionRequestor;
import com.spket.js.model.ILexerProvider;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSDoc;
import com.spket.js.model.JSDocImpl;
import com.spket.js.model.JSFunction;
import com.spket.js.model.JSObject;
import com.spket.js.model.ObjectImpl;
import com.spket.js.model.Param;
import com.spket.js.model.Scope;
import com.spket.js.model.ScriptFunction;
import com.spket.js.model.Slot;
import com.spket.js.parser.ExpressionEvaluator;
import com.spket.js.parser.ScriptManager;
import com.spket.js.parser.ScriptParser;
import com.spket.util.Debug;
import com.spket.util.IntStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CompletionEngine {
    private String location;
    private Context context;
    private JSObject localScope;
    private JSObject thisScope;
    private boolean hasLeftHandSide;
    private String tokenName;
    private BufferedScanner lexer;
    private ScriptParser parser;
    private ILexerProvider fProvider;
    private ExpressionEvaluator evaluator;

    private static boolean isPrefix(int n) {
        return 37 == n || ScannerHelper.isKeywrod((int)n);
    }

    public CompletionEngine(ILexerProvider iLexerProvider) {
        this(iLexerProvider, iLexerProvider.getGlobalForEdit());
    }

    public CompletionEngine(ILexerProvider iLexerProvider, JSObject jSObject) {
        this(iLexerProvider, jSObject, iLexerProvider.getThisScope(jSObject));
    }

    public CompletionEngine(ILexerProvider iLexerProvider, JSObject jSObject, JSObject jSObject2) {
        this.fProvider = iLexerProvider;
        IPath iPath = iLexerProvider.getPath();
        this.location = iPath == null ? null : iPath.toPortableString();
        this.context = iLexerProvider.getContext();
        this.thisScope = jSObject2;
        this.localScope = jSObject2 == jSObject ? jSObject : new Scope(jSObject2, jSObject);
        this.parser = new ScriptParser();
        this.evaluator = this.context.createExpressionEvaluator();
    }

    public boolean hasLeftHandSideExpression() {
        return this.hasLeftHandSide;
    }

    public void setLexer(BufferedScanner bufferedScanner) {
        this.lexer = bufferedScanner;
        this.parser.setLexer(bufferedScanner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void codeComplete(ICompletionRequestor iCompletionRequestor, int n) {
        if (!this.context.isInitialized()) {
            return;
        }
        char[] cArray = null;
        boolean bl = false;
        JSObject jSObject = this.localScope;
        this.lexer.prepare();
        n -= this.lexer.getSourceOffset();
        if (this.lexer.getSize() > 0) {
            int n2;
            int n3 = this.lexer.getTokenIndex(n);
            if (n3 >= 0) {
                if (n3 > 0 && CompletionEngine.isPrefix(this.lexer.getToken(n3 - 1)) && this.lexer.getTokenEnd(n3 - 1) + 1 == n) {
                    cArray = this.lexer.getTokenSource(--n3);
                } else if (n3 < this.lexer.getSize()) {
                    n2 = this.lexer.getTokenStart(n3);
                    if (n > n2) {
                        if (CompletionEngine.isPrefix(this.lexer.getToken(n3))) {
                            int n4 = n - n2;
                            cArray = new char[n4];
                            System.arraycopy(this.lexer.source, n2, cArray, 0, n4);
                        } else {
                            n3 = -1;
                        }
                    }
                } else if (n3 != this.lexer.getSize() || this.lexer.getToken(n3 - 1) != 11) {
                    n3 = Integer.MIN_VALUE;
                }
            }
            if (n3 > 0) {
                n2 = n3--;
                Expression expression = null;
                int n5 = this.lexer.getToken(n3);
                if (11 == n5) {
                    n2 = -1;
                    if (n3 > 0) {
                        n2 = this.getCompletionStart(this.lexer, 0, n3);
                    }
                    if (n2 != -1 && n2 != n3) {
                        n5 = this.lexer.getToken(n2);
                        BufferedScanner bufferedScanner = this.lexer;
                        synchronized (bufferedScanner) {
                            if (46 == n5) {
                                expression = this.parser.parseObjectInitializer(n2, n3);
                            } else {
                                this.lexer.setRange(n2, n3);
                                expression = this.parser.parseExpression();
                            }
                        }
                        if (expression == null) {
                            n2 = -1;
                        } else {
                            this.hasLeftHandSide = true;
                            iCompletionRequestor.setOffset(this.lexer.getTokenStart(n3));
                        }
                    }
                } else if (52 == n5) {
                    n2 = -1;
                }
                if (n2 == -1) {
                    jSObject = null;
                } else {
                    try {
                        jSObject = this.visit(n, n2);
                    }
                    catch (PositionException positionException) {
                        jSObject = null;
                        Debug.debug((String)"Over parameter");
                    }
                    if (expression != null) {
                        if (jSObject != null) {
                            jSObject = this.evaluator.eval(this.location, expression, this.lexer, this.localScope, jSObject);
                        }
                    } else {
                        jSObject = this.localScope;
                    }
                    if (n2 > 0) {
                        n5 = this.lexer.getToken(n2 - 1);
                    }
                    bl = 54 == n5;
                }
            } else if (n3 == 0) {
                this.visit(n, 0);
            } else if (n3 == Integer.MIN_VALUE) {
                this.visit(n, this.lexer.getSize());
            } else {
                jSObject = null;
            }
        } else {
            this.visit(n, 0);
        }
        if (jSObject != null) {
            iCompletionRequestor.setPrefix(cArray);
            iCompletionRequestor.setNewExpression(bl);
            jSObject.codeComplete(iCompletionRequestor);
        }
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public ISlot select(int n) {
        int n2;
        if (!this.context.isInitialized()) {
            return null;
        }
        this.lexer.prepare();
        if (this.lexer.getSize() > 0 && (n2 = this.lexer.getTokenIndex(n -= this.lexer.getSourceOffset())) >= 0) {
            Expression expression;
            if (n2 == this.lexer.getSize()) {
                --n2;
            }
            if ((expression = this.getLHSExpression(this.lexer, n2)) != null) {
                JSObject jSObject = null;
                try {
                    jSObject = this.visit(n, n2);
                }
                catch (PositionException positionException) {
                    return this.makeSlot(positionException);
                }
                if (jSObject != null) {
                    if (expression instanceof BinaryExpression) {
                        BinaryExpression binaryExpression = (BinaryExpression)expression;
                        expression = binaryExpression.right;
                        JSObject jSObject2 = this.evaluator.eval(this.location, binaryExpression.left, this.lexer, this.localScope, jSObject);
                        if (jSObject2 instanceof JSObject) {
                            jSObject = jSObject2;
                            if (expression instanceof IdentifierReference) {
                                this.tokenName = new String(((IdentifierReference)expression).token);
                                return jSObject.getSlot(this.tokenName);
                            }
                        }
                    } else if (expression instanceof IdentifierReference) {
                        this.tokenName = new String(((IdentifierReference)expression).token);
                        ISlot iSlot = this.localScope.getSlot(this.tokenName);
                        if (iSlot == null && jSObject != this.localScope && jSObject != null) {
                            iSlot = jSObject.getSlot(this.tokenName);
                        }
                        return iSlot;
                    }
                }
            }
        }
        return null;
    }

    protected ISlot makeSlot(PositionException positionException) {
        Object object;
        if (positionException.function == null) {
            return null;
        }
        int n = positionException.index;
        int n2 = positionException.offset;
        String[] stringArray = null;
        String string = null;
        Parameter parameter = positionException.function.parameters[n];
        if (n2 > 0) {
            object = new ScriptFunction(this.location, positionException.function, this.lexer);
            ((ScriptFunction)object).setDocument(new JSDocImpl(n2, this.lexer));
            Param param = ((ScriptFunction)object).getParameters()[n];
            stringArray = param.getTypes();
            this.tokenName = param.getName();
            string = param.getComment();
        } else {
            object = new ArrayList(4);
            JSDocImpl.getInlineType(this.lexer, parameter.sourceStart, (List)object);
            if (object.size() > 0) {
                stringArray = new String[object.size()];
                object.toArray(stringArray);
                this.tokenName = new String(parameter.name);
            }
        }
        if (this.tokenName != null) {
            if (stringArray != null && stringArray.length > 0 || string != null) {
                object = new Slot();
                object.setData(ISlot.P_TYPE, stringArray);
                object.setData(ISlot.P_COMMENT, string);
                return object;
            }
            if (positionException.inherited && positionException.scope != null) {
                return positionException.scope.getSlot(this.tokenName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression getLHSExpression(BufferedScanner bufferedScanner, int n) {
        int n2;
        Expression expression = null;
        if ((n2 = this.getCompletionStart(bufferedScanner, 0, ++n)) != -1 && n2 < n) {
            BufferedScanner bufferedScanner2 = bufferedScanner;
            synchronized (bufferedScanner2) {
                bufferedScanner.setRange(n2, n);
                expression = this.parser.parseExpression();
            }
        }
        return expression;
    }

    protected int getCompletionStart(BufferedScanner bufferedScanner, int n, int n2) {
        int n3 = n2;
        if (n3 > n) {
            int n4 = -1;
            boolean bl = false;
            IntStack intStack = new IntStack();
            block14: do {
                int n5 = bufferedScanner.getToken(--n3);
                block0 : switch (n5) {
                    case 44: 
                    case 48: 
                    case 69: {
                        if (n4 == -1 || n4 == 11) {
                            switch (n5) {
                                case 48: {
                                    intStack.push(4);
                                    break;
                                }
                                case 44: {
                                    intStack.push(46);
                                    break;
                                }
                                case 69: {
                                    intStack.push(5);
                                }
                            }
                            continue block14;
                        }
                        ++n3;
                        break block14;
                    }
                    case 4: 
                    case 5: 
                    case 46: {
                        if (intStack.isEmpty()) {
                            ++n3;
                            break block14;
                        }
                        bl = intStack.pop() != n5;
                        break;
                    }
                    default: {
                        if (!intStack.isEmpty()) continue block14;
                        switch (n5) {
                            case 11: {
                                if (n4 != -1 && n4 != 37) break block14;
                                n4 = n5;
                                break block0;
                            }
                            case 37: {
                                if (n4 != -1 && n4 != 11) break block14;
                                n4 = n5;
                                break block0;
                            }
                            case 56: 
                            case 57: 
                            case 59: {
                                break;
                            }
                            default: {
                                ++n3;
                                break;
                            }
                        }
                        break block14;
                    }
                }
            } while (!bl && n3 > n);
            if (!bl && n3 < n2) {
                return n3;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSObject visit(int n, int n2) {
        Object object;
        BufferedScanner bufferedScanner;
        Object object2;
        ASTNode[] aSTNodeArray = null;
        ArrayList arrayList = null;
        String[] stringArray = this.fProvider.getIncludes();
        ScriptManager scriptManager = this.fProvider.getManager();
        if (stringArray == null) {
            if (arrayList == null || arrayList.size() == 0) {
                arrayList = scriptManager.getIncludes(this.lexer);
            } else {
                object2 = scriptManager.getIncludes(this.lexer);
                if (object2 != null && object2.size() > 0) {
                    arrayList = new ArrayList(arrayList);
                    arrayList.addAll(object2);
                }
            }
        } else if (stringArray.length > 0) {
            arrayList = Arrays.asList(stringArray);
        }
        if (arrayList != null && arrayList.size() > 0 && (object2 = scriptManager.expandIncludes(arrayList, this.location)) != null && object2.size() > 0) {
            bufferedScanner = object2.iterator();
            while (bufferedScanner.hasNext()) {
                object = (String)bufferedScanner.next();
                Path path = new Path((String)object);
                aSTNodeArray = scriptManager.getStatements((IPath)path);
                if (aSTNodeArray == null || aSTNodeArray.length <= 0) continue;
                this.evaluator.visit((String)object, aSTNodeArray, scriptManager.getLexer((IPath)path), this.localScope, this.thisScope);
            }
        }
        if ((object2 = this.fProvider.getScripts()) != null) {
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object = object2[i];
                object.setRange(0, object.getSize());
                this.parser.setLexer((BufferedScanner)object);
                aSTNodeArray = this.parser.parse(4);
                this.evaluator.visit(this.location, aSTNodeArray, (BufferedScanner)object, this.localScope, this.thisScope);
            }
        }
        if (n2 > 0) {
            this.parser.setLexer(this.lexer);
            bufferedScanner = this.lexer;
            synchronized (bufferedScanner) {
                this.lexer.setRange(0, this.lexer.getSize());
                aSTNodeArray = this.parser.parse(4);
            }
            if (aSTNodeArray != null && aSTNodeArray.length > 0) {
                return this.visit(this.location, aSTNodeArray, this.lexer, this.thisScope, n, n2, false);
            }
        }
        return this.thisScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSObject visit(String string, ASTNode[] aSTNodeArray, BufferedScanner bufferedScanner, JSObject jSObject, int n, int n2, boolean bl) {
        if (aSTNodeArray == null || aSTNodeArray.length == 0) {
            return jSObject;
        }
        this.evaluator.visit(string, aSTNodeArray, bufferedScanner, this.localScope, jSObject);
        for (int i = 0; i < aSTNodeArray.length; ++i) {
            JSObject jSObject2;
            Object object;
            ASTNode aSTNode = aSTNodeArray[i];
            if (aSTNode.sourceStart > n) break;
            Object object2 = -1;
            Expression expression = null;
            try {
                expression = this.find(aSTNode, n, bl);
            }
            catch (PositionException positionException) {
                if (positionException.offset == 0) {
                    if (aSTNode instanceof VariableBinding || aSTNode instanceof FunctionExpression) {
                        positionException.offset = aSTNode.sourceStart;
                    } else if (aSTNode instanceof Assignment) {
                        Expression expression2 = ((Assignment)aSTNode).lhs;
                        while (expression2 instanceof BinaryExpression) {
                            expression2 = ((BinaryExpression)expression2).left;
                        }
                        if (expression2 != null) {
                            positionException.offset = expression2.sourceStart;
                        }
                    }
                }
                throw positionException;
            }
            if (expression == null) continue;
            JSObject jSObject3 = jSObject;
            FunctionExpression functionExpression = null;
            if (expression instanceof FunctionExpression) {
                Object object3;
                functionExpression = (FunctionExpression)expression;
                if (aSTNode instanceof Assignment) {
                    object = new int[]{-1};
                    jSObject3 = this.eval(((Assignment)aSTNode).lhs, jSObject, (int[])object);
                    object2 = object[0];
                } else if (functionExpression.name != null && (object = this.localScope.getSlot(new String(functionExpression.name))) != null && (object3 = object.getData(ISlot.P_COMMENT)) instanceof JSDoc && ((JSDoc)object3).hasClassTag() && (jSObject2 = object.getObject()) != null) {
                    jSObject3 = new ObjectImpl(jSObject2.getClassName());
                    jSObject3.setParentScope(jSObject2.getParentScope());
                    jSObject3.setPrototype(jSObject2.getProperty("prototype"));
                }
            } else if (expression instanceof Assignment) {
                object = (Assignment)expression;
                object2 = ((Assignment)object).sourceStart;
                functionExpression = (FunctionExpression)((Assignment)object).expression;
                jSObject3 = this.evaluator.eval(string, ((Assignment)object).lhs, bufferedScanner, this.localScope, jSObject);
            }
            if (jSObject3 == null || functionExpression == null || functionExpression.body == null) break;
            object = functionExpression.body;
            int n3 = ((Block)object).declarationSourceStart;
            if (n2 <= n3 || ((Block)object).declarationSourceEnd <= n3) break;
            this.visitParameter(string, functionExpression, (int)object2, bl);
            if (n2 > ++n3) {
                this.parser.setLexer(bufferedScanner);
                jSObject2 = bufferedScanner;
                synchronized (jSObject2) {
                    bufferedScanner.setRange(n3, ((Block)object).declarationSourceEnd);
                    aSTNodeArray = this.parser.parse(0, n2);
                }
                return this.visit(string, aSTNodeArray, bufferedScanner, jSObject3, n, n2, true);
            }
            return jSObject3;
        }
        return jSObject;
    }

    protected JSObject create(JSObject jSObject, String string) {
        JSObject jSObject2 = jSObject.getProperty(string);
        if (jSObject2 instanceof JSFunction) {
            return ((JSFunction)jSObject2).construct(this.context, jSObject, null);
        }
        Debug.warn((String)("The property {" + string + "} of {" + jSObject.getClassName() + "} is not function"));
        return null;
    }

    protected JSObject get(JSObject jSObject, JSObject jSObject2, String string) {
        ISlot iSlot = jSObject2.getSlot(string);
        if (iSlot != null) {
            JSObject jSObject3 = iSlot.getObject();
            if (jSObject3 == null) {
                jSObject3 = jSObject2.createProperty(jSObject, string);
            }
            return jSObject3;
        }
        return null;
    }

    protected JSObject eval(Expression expression, JSObject jSObject, int[] nArray) {
        JSObject jSObject2 = null;
        JSObject jSObject3 = Context.getTopLevelScope(this.localScope);
        if (!(expression instanceof IdentifierReference)) {
            if (expression instanceof BinaryExpression) {
                JSObject jSObject4 = null;
                ArrayList<Expression> arrayList = new ArrayList<Expression>();
                BinaryExpression binaryExpression = (BinaryExpression)expression;
                while (binaryExpression.left instanceof BinaryExpression) {
                    binaryExpression = (BinaryExpression)binaryExpression.left;
                    arrayList.add(binaryExpression.right);
                }
                arrayList.add(binaryExpression.left);
                int n = arrayList.size() - 1;
                Expression expression2 = (Expression)arrayList.get(n);
                nArray[0] = expression2.sourceStart;
                if (expression2 instanceof ThisReference) {
                    --n;
                    jSObject4 = jSObject;
                } else {
                    jSObject4 = this.localScope;
                }
                while (n >= 0 && jSObject4 != null) {
                    if ((expression2 = (Expression)arrayList.get(n--)) instanceof IdentifierReference) {
                        JSObject jSObject5 = null;
                        String string = new String(((IdentifierReference)expression2).token);
                        if ("prototype".equals(string)) {
                            if (jSObject4 instanceof JSFunction) {
                                jSObject5 = ((JSFunction)jSObject4).construct(this.context, jSObject3, null);
                            }
                            if (jSObject5 == null) {
                                jSObject5 = this.create(jSObject3, "Object");
                                jSObject5.setPrototype(jSObject4.getProperty("prototype"));
                            }
                        } else {
                            jSObject5 = this.get(jSObject3, jSObject4, string);
                        }
                        jSObject4 = jSObject5;
                        continue;
                    }
                    jSObject4 = null;
                }
                jSObject2 = jSObject4;
            } else {
                Debug.debug((String)"Should not happend!");
            }
        }
        return jSObject2;
    }

    protected void visitParameter(String string, FunctionExpression functionExpression, int n, boolean bl) {
        if (functionExpression.parameters == null || functionExpression.parameters.length == 0) {
            return;
        }
        JSDocImpl jSDocImpl = null;
        if (n == -1) {
            n = functionExpression.sourceStart;
        }
        if (n > 0) {
            jSDocImpl = new JSDocImpl(n, this.lexer);
        }
        if (this.evaluator.resolveParameters(this.lexer, this.localScope, string, functionExpression, jSDocImpl, bl)) {
            return;
        }
        ScriptFunction scriptFunction = new ScriptFunction(string, functionExpression, this.lexer);
        scriptFunction.setDocument(jSDocImpl);
        scriptFunction.visitParameter(this.context, this.localScope, this.localScope, bl);
    }

    protected Expression find(ASTNode aSTNode, int n, boolean bl) {
        Parameter parameter;
        int n2;
        Expression expression;
        Expression[] expressionArray;
        if (aSTNode instanceof FunctionExpression) {
            expressionArray = (Expression[])aSTNode;
            if (expressionArray.body != null && expressionArray.body.sourceStart < n && expressionArray.body.sourceEnd >= n) {
                return expressionArray;
            }
            if (expressionArray.parameters != null) {
                expression = expressionArray.parameters;
                for (n2 = 0; n2 < ((Parameter[])expression).length; ++n2) {
                    parameter = expression[n2];
                    if (parameter.sourceStart > n || parameter.sourceEnd + 1 < n) continue;
                    throw new PositionException((FunctionExpression)expressionArray, n2, this.localScope, bl);
                }
            }
        }
        if (aSTNode instanceof Assignment) {
            return this.find((ASTNode)((Assignment)aSTNode).expression, n, bl);
        }
        if (aSTNode instanceof VariableBinding) {
            return this.find((ASTNode)((VariableBinding)aSTNode).initializer, n, bl);
        }
        if (aSTNode instanceof ReturnStatement) {
            return this.find((ASTNode)((ReturnStatement)aSTNode).expression, n, bl);
        }
        if (aSTNode instanceof InvokeExpression) {
            return this.find((ASTNode)((InvokeExpression)aSTNode).receiver, n, bl);
        }
        if (aSTNode instanceof ObjectInitializer && (expressionArray = ((ObjectInitializer)aSTNode).expressions) != null) {
            for (n2 = 0; n2 < expressionArray.length; ++n2) {
                parameter = (FieldLiteral)expressionArray[n2];
                Expression expression2 = parameter.field;
                if (expression2.sourceStart <= n && expression2.sourceEnd >= n) {
                    throw new PositionException(null, 0, this.localScope, false);
                }
                try {
                    expression = this.find((ASTNode)parameter.value, n, bl);
                }
                catch (PositionException positionException) {
                    positionException.offset = expression2.sourceStart;
                    throw positionException;
                }
                if (expression == null) continue;
                if (expression instanceof FunctionExpression) {
                    Assignment assignment = new Assignment((Expression)aSTNode, expression, 0);
                    assignment.sourceStart = expression2.sourceStart;
                    return assignment;
                }
                return expression;
            }
        }
        return null;
    }

    private static class PositionException
    extends RuntimeException {
        public int offset;
        public int index;
        public JSObject scope;
        public boolean inherited;
        public FunctionExpression function;

        public PositionException(FunctionExpression functionExpression, int n, JSObject jSObject, boolean bl) {
            this.function = functionExpression;
            this.index = n;
            this.scope = jSObject;
            this.inherited = bl;
        }
    }
}

