/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.profile;

import com.spket.as.core.compiler.CharOperation;
import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.BinaryExpression;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.IdentifierReference;
import com.spket.as.internal.compiler.ast.IfStatement;
import com.spket.as.internal.compiler.ast.InvokeExpression;
import com.spket.as.internal.compiler.ast.ObjectInitializer;
import com.spket.as.internal.compiler.ast.StringLiteral;
import com.spket.as.internal.compiler.ast.UnaryExpression;
import com.spket.as.internal.compiler.lookup.Frame;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSDoc;
import com.spket.js.model.JSDocImpl;
import com.spket.js.model.JSFunction;
import com.spket.js.model.JSNamespace;
import com.spket.js.model.JSObject;
import com.spket.js.model.ObjectImpl;
import com.spket.js.model.Param;
import com.spket.js.profile.ExtFunction;
import com.spket.js.profile.ExtNamespace;
import com.spket.js.profile.JSVisitor;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Point;

public class ExtVisitor
extends JSVisitor {
    private static final char[] NS_Ext = "Ext".toCharArray();
    private static final char[] F_namespace = "namespace".toCharArray();
    private static final char[] F_apply = "apply".toCharArray();
    private static final char[] F_applyIf = "applyIf".toCharArray();
    private static final char[] F_extend = "extend".toCharArray();
    private ExtNamespace fNamespace = new ExtNamespace();

    protected ObjectImpl apply(Expression expression, Expression expression2, boolean bl) {
        int n = this.size();
        expression.traverse((ASTVisitor)this, null);
        JSObject jSObject = this.pop(n);
        if (jSObject instanceof ObjectImpl) {
            ObjectImpl objectImpl = (ObjectImpl)jSObject;
            this.apply(objectImpl, expression2, bl);
            return objectImpl;
        }
        return null;
    }

    protected void apply(ObjectImpl objectImpl, Expression expression, boolean bl) {
        int n = this.size();
        expression.traverse((ASTVisitor)this, null);
        JSObject jSObject = this.pop(n);
        if (jSObject instanceof ObjectImpl) {
            Map map = ((ObjectImpl)jSObject).getSlots();
            if (map != null && map.size() > 0) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    if (!bl && objectImpl.hasProperty(string)) continue;
                    objectImpl.defineProperty(string, entry.getValue());
                }
            }
        } else {
            System.err.println("Shoule be Object");
        }
    }

    protected void defineNamespaces(Expression[] expressionArray) {
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression = expressionArray[i];
            if (!(expression instanceof StringLiteral)) continue;
            JSObject jSObject = this.localScope;
            String[] stringArray = StringUtils.split((String)new String(((StringLiteral)expression).source()), (char)'.');
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                ISlot iSlot = null;
                JSObject jSObject2 = jSObject.getProperty(string);
                if (jSObject2 == null) {
                    jSObject2 = new ObjectImpl();
                    jSObject.setProperty(string, jSObject2);
                    iSlot = jSObject.getSlot(string);
                    if (iSlot != null) {
                        iSlot.setData(ISlot.P_SOURCE, this.fileName);
                        iSlot.setData(ISlot.P_RANGE, new Point(expression.sourceStart, expression.sourceEnd));
                    }
                } else {
                    iSlot = jSObject.getSlot(string);
                }
                if (iSlot != null) {
                    iSlot.setFlag(0x800000, true);
                }
                jSObject = jSObject2;
            }
        }
    }

    protected void construct(JSFunction jSFunction, JSObject jSObject, Expression[] expressionArray) {
        int n = jSFunction.getNumberOfParameters();
        if (n > 0 && jSObject instanceof ObjectImpl) {
            Param[] paramArray = jSFunction.getParameters();
            for (int i = 0; i < n; ++i) {
                if (!"config".equals(paramArray[i].getName())) continue;
                if (expressionArray == null || expressionArray.length <= i) break;
                this.apply((ObjectImpl)jSObject, expressionArray[i], false);
                break;
            }
        }
    }

    protected JSNamespace getNamespace() {
        return this.fNamespace;
    }

    public boolean visit(IfStatement ifStatement, Frame frame) {
        int n;
        if (this.globalScope == this.localScope && ifStatement.thenStatement != null && ifStatement.condition instanceof UnaryExpression && 11 == (n = (ifStatement.condition.bits & 0xFC0) >> 6)) {
            ifStatement.thenStatement.traverse((ASTVisitor)this, frame);
        }
        return false;
    }

    public boolean visit(InvokeExpression invokeExpression, Frame frame) {
        if (invokeExpression.arguments != null && invokeExpression.receiver instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)invokeExpression.receiver;
            if (binaryExpression.left instanceof IdentifierReference && binaryExpression.right instanceof IdentifierReference && CharOperation.equals((char[])NS_Ext, (char[])((IdentifierReference)binaryExpression.left).token)) {
                char[] cArray = ((IdentifierReference)binaryExpression.right).token;
                if (CharOperation.equals((char[])F_namespace, (char[])cArray)) {
                    this.defineNamespaces(invokeExpression.arguments);
                    return false;
                }
                if (CharOperation.equals((char[])F_apply, (char[])cArray)) {
                    Expression[] expressionArray = invokeExpression.arguments;
                    if (expressionArray.length == 2) {
                        this.apply(expressionArray[0], expressionArray[1], true);
                    } else if (expressionArray.length == 3) {
                        ObjectImpl objectImpl = this.apply(expressionArray[0], expressionArray[2], true);
                        if (objectImpl != null) {
                            this.apply(objectImpl, expressionArray[1], true);
                        }
                    } else {
                        System.err.println("Illegal Argument");
                    }
                    return false;
                }
                if (CharOperation.equals((char[])F_applyIf, (char[])cArray)) {
                    Expression[] expressionArray = invokeExpression.arguments;
                    if (expressionArray.length == 2) {
                        this.apply(expressionArray[0], expressionArray[1], false);
                    } else {
                        System.err.println("Illegal Argument");
                    }
                    return false;
                }
                if (CharOperation.equals((char[])F_extend, (char[])cArray)) {
                    Expression[] expressionArray = invokeExpression.arguments;
                    if (expressionArray.length == 2 || expressionArray.length == 3) {
                        int n = this.size();
                        expressionArray[0].traverse((ASTVisitor)this, frame);
                        JSObject jSObject = this.pop(n);
                        if (jSObject instanceof ObjectImpl) {
                            if (expressionArray.length == 2 && expressionArray[1] instanceof ObjectInitializer) {
                                ExtFunction extFunction = new ExtFunction(null);
                                extFunction.setParentScope(this.globalScope);
                                extFunction.setPrototype(jSObject);
                                ObjectImpl objectImpl = null;
                                jSObject = extFunction.getProperty("prototype");
                                if (jSObject == null) {
                                    objectImpl = new ObjectImpl();
                                    extFunction.setProperty("prototype", objectImpl);
                                } else if (jSObject instanceof ObjectImpl) {
                                    objectImpl = (ObjectImpl)jSObject;
                                }
                                if (objectImpl != null) {
                                    this.apply(objectImpl, expressionArray[1], true);
                                }
                                this.push(extFunction);
                                return false;
                            }
                            ObjectImpl objectImpl = (ObjectImpl)jSObject;
                            expressionArray[1].traverse((ASTVisitor)this, frame);
                            jSObject = this.pop(n);
                            if (jSObject instanceof ObjectImpl) {
                                objectImpl.setPrototype(jSObject);
                            }
                            if (expressionArray.length == 3) {
                                Map map;
                                expressionArray[2].traverse((ASTVisitor)this, frame);
                                jSObject = this.pop(n);
                                if (jSObject instanceof ObjectImpl && (map = ((ObjectImpl)jSObject).getSlots()) != null && map.size() > 0) {
                                    ObjectImpl objectImpl2 = null;
                                    jSObject = objectImpl.getProperty("prototype");
                                    if (jSObject == null) {
                                        objectImpl2 = new ObjectImpl();
                                        objectImpl.setProperty("prototype", objectImpl2);
                                    } else if (jSObject instanceof ObjectImpl) {
                                        objectImpl2 = (ObjectImpl)jSObject;
                                    }
                                    if (objectImpl2 == null) {
                                        System.err.println("Something wrong with prototype");
                                    } else {
                                        Iterator iterator = map.entrySet().iterator();
                                        while (iterator.hasNext()) {
                                            Map.Entry entry = iterator.next();
                                            objectImpl2.defineProperty((String)entry.getKey(), entry.getValue());
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        System.err.println("Illegal Argument");
                    }
                    return false;
                }
            }
        }
        return super.visit(invokeExpression, frame);
    }

    protected void consumeComments() {
        int n = this.lexer.commentPtr + 1;
        if (n < 1) {
            return;
        }
        char[] cArray = this.lexer.source;
        try {
            for (int i = 0; i < n; ++i) {
                String[] stringArray;
                char c;
                int n2;
                int n3;
                int n4 = this.lexer.commentStarts[i];
                if (n4 < 0 || (n3 = this.lexer.commentStops[i]) <= n4 || (n2 = this.lexer.commentTagStarts[i]) <= 0 || cArray[++n2] != 'c' || !Character.isWhitespace(cArray[n2 + 5]) || cArray[++n2] != 'l' || cArray[++n2] != 'a' || cArray[++n2] != 's' || cArray[++n2] != 's') continue;
                ++n2;
                StringBuffer stringBuffer = new StringBuffer();
                while (n2 < n3 && (c = cArray[n2++]) != '\n' && c != '\r') {
                    stringBuffer.append(c);
                }
                if (stringBuffer.length() <= 0 || (stringArray = StringUtils.split((String)stringBuffer.toString(), (char)'.', (boolean)false)).length <= 0) continue;
                ISlot iSlot = null;
                JSObject jSObject = this.globalScope;
                for (int j = 0; j < stringArray.length && (jSObject = (iSlot = jSObject.getSlot(stringArray[j])) != null ? iSlot.getObject() : null) != null; ++j) {
                }
                if (iSlot != null && jSObject != null) {
                    JSDoc jSDoc;
                    JSDoc jSDoc2;
                    if (stringArray.length > 1) {
                        this.fNamespace.registerShortHand(stringArray);
                    }
                    if ((jSDoc2 = (JSDoc)iSlot.getData(ISlot.P_COMMENT)) == null || !jSDoc2.isValid()) {
                        ExtFunction extFunction;
                        jSDoc2 = jSDoc = new JSDocImpl(cArray, n4, n3);
                        ((JSDocImpl)jSDoc).setNamespace(this.getNamespace());
                        iSlot.setData(ISlot.P_COMMENT, jSDoc2);
                        if (!(jSObject instanceof ExtFunction) || (extFunction = (ExtFunction)jSObject).getDocument() != null) continue;
                        extFunction.setDocument(jSDoc2);
                        continue;
                    }
                    if (!(jSObject instanceof ExtFunction) || (jSDoc = ((ExtFunction)jSObject).getDocument()) != null && jSDoc == jSDoc2) continue;
                    System.out.println("JSDoc 1: " + stringBuffer.toString());
                    continue;
                }
                Debug.debug((String)stringBuffer.toString());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.debug((Throwable)arrayIndexOutOfBoundsException);
        }
    }
}

