/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.profile;

import com.spket.as.core.compiler.CharOperation;
import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.DefaultErrorHandlingPolicies;
import com.spket.as.internal.compiler.IProblemFactory;
import com.spket.as.internal.compiler.ast.ASTNode;
import com.spket.as.internal.compiler.ast.ArrayInitializer;
import com.spket.as.internal.compiler.ast.Assignment;
import com.spket.as.internal.compiler.ast.BinaryExpression;
import com.spket.as.internal.compiler.ast.Block;
import com.spket.as.internal.compiler.ast.BooleanLiteral;
import com.spket.as.internal.compiler.ast.CompilationUnitDeclaration;
import com.spket.as.internal.compiler.ast.ConditionalExpression;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.ExpressionStatement;
import com.spket.as.internal.compiler.ast.FieldLiteral;
import com.spket.as.internal.compiler.ast.FunctionDeclaration;
import com.spket.as.internal.compiler.ast.FunctionExpression;
import com.spket.as.internal.compiler.ast.IdentifierReference;
import com.spket.as.internal.compiler.ast.IfStatement;
import com.spket.as.internal.compiler.ast.InvokeExpression;
import com.spket.as.internal.compiler.ast.NumberLiteral;
import com.spket.as.internal.compiler.ast.ObjectInitializer;
import com.spket.as.internal.compiler.ast.Parameter;
import com.spket.as.internal.compiler.ast.PostfixExpression;
import com.spket.as.internal.compiler.ast.PrefixExpression;
import com.spket.as.internal.compiler.ast.RegExpLiteral;
import com.spket.as.internal.compiler.ast.ReturnStatement;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.ast.StringLiteral;
import com.spket.as.internal.compiler.ast.ThisReference;
import com.spket.as.internal.compiler.ast.UnaryExpression;
import com.spket.as.internal.compiler.ast.VariableBinding;
import com.spket.as.internal.compiler.impl.CompilerOptions;
import com.spket.as.internal.compiler.lookup.Frame;
import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.as.internal.compiler.parser.Scanner;
import com.spket.as.internal.compiler.problem.DefaultProblemFactory;
import com.spket.as.internal.compiler.problem.ProblemReporter;
import com.spket.js.internal.JSPlugin;
import com.spket.js.model.Context;
import com.spket.js.model.FunctionImpl;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSDoc;
import com.spket.js.model.JSDocImpl;
import com.spket.js.model.JSFunction;
import com.spket.js.model.JSNamespace;
import com.spket.js.model.JSObject;
import com.spket.js.model.ObjectImpl;
import com.spket.js.model.Slot;
import com.spket.js.parser.ScriptVisitor;
import com.spket.js.profile.ExtFunction;
import com.spket.js.profile.ProfileParser;
import com.spket.util.Debug;
import com.spket.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;

public class JSVisitor
extends ScriptVisitor {
    protected String path;
    protected String fileName;
    protected BufferedScanner lexer;
    protected FileUtils fu = new FileUtils();
    protected JSObject globalScope;
    protected JSObject localScope;
    protected JSObject thisScope;
    protected int count;
    protected JSObject[] items = new JSObject[10];

    public final void visit(String string) {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            try {
                this.parse(file.getAbsolutePath());
            }
            catch (IOException iOException) {
                JSPlugin.log(iOException);
            }
        }
    }

    public void setScope(JSObject jSObject) {
        this.thisScope = this.globalScope = jSObject;
        this.localScope = this.globalScope;
    }

    protected void parse(String string) throws IOException {
        char[] cArray;
        File file;
        if ('/' != File.separatorChar) {
            string = string.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            string = string.replace('\\', File.separatorChar);
        }
        if ((file = new File(string)).exists() && file.isFile() && (cArray = this.fu.getContents(string = file.getAbsolutePath())) != null) {
            CompilationUnitDeclaration compilationUnitDeclaration;
            this.lexer = new BufferedScanner(6);
            this.lexer.setSource(cArray);
            CompilerOptions compilerOptions = new CompilerOptions();
            compilerOptions.sourceLevel = this.lexer.sourceLevel;
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, (IProblemFactory)new DefaultProblemFactory());
            ProfileParser profileParser = new ProfileParser(problemReporter, (Scanner)this.lexer);
            this.lexer.prepare();
            int n = this.lexer.commentPtr;
            int[] nArray = null;
            int[] nArray2 = null;
            int[] nArray3 = null;
            if (n != -1) {
                nArray = new int[n + 1];
                nArray2 = new int[n + 1];
                nArray3 = new int[n + 1];
                System.arraycopy(this.lexer.commentStarts, 0, nArray, 0, n + 1);
                System.arraycopy(this.lexer.commentStops, 0, nArray2, 0, n + 1);
                System.arraycopy(this.lexer.commentTagStarts, 0, nArray3, 0, n + 1);
            }
            if ((compilationUnitDeclaration = profileParser.parseProgram()) != null) {
                String string2 = this.fileName;
                this.fileName = string;
                if (n != -1) {
                    this.lexer.commentPtr = n;
                    this.lexer.commentStarts = nArray;
                    this.lexer.commentStops = nArray2;
                    this.lexer.commentTagStarts = nArray3;
                }
                compilationUnitDeclaration.traverse((ASTVisitor)this, null);
                this.consumeComments();
                this.fileName = string2;
                return;
            }
        }
        System.out.println(string);
    }

    protected JSNamespace getNamespace() {
        return null;
    }

    protected JSDoc createDoc(int n, BufferedScanner bufferedScanner) {
        JSDocImpl jSDocImpl = new JSDocImpl(n, bufferedScanner);
        JSNamespace jSNamespace = this.getNamespace();
        if (jSNamespace != null) {
            jSDocImpl.setNamespace(jSNamespace);
        }
        return jSDocImpl;
    }

    protected void consumeComments() {
    }

    protected boolean isNamespace(Expression expression, char[] cArray, char[] cArray2) {
        if (expression instanceof IdentifierReference) {
            return CharOperation.equals((char[])cArray, (char[])((IdentifierReference)expression).token);
        }
        if (cArray2 != null && expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            if (binaryExpression.left instanceof IdentifierReference && binaryExpression.right instanceof IdentifierReference && CharOperation.equals((char[])cArray, (char[])((IdentifierReference)binaryExpression.left).token)) {
                return CharOperation.equals((char[])cArray2, (char[])((IdentifierReference)binaryExpression.right).token);
            }
        }
        return false;
    }

    protected int size() {
        return this.count;
    }

    protected void push(JSObject jSObject) {
        if (this.items == null) {
            this.items = new JSObject[10];
        } else if (this.count >= this.items.length) {
            JSObject[] jSObjectArray = new JSObject[this.count + 10];
            System.arraycopy(this.items, 0, jSObjectArray, 0, this.count);
            this.items = jSObjectArray;
        }
        this.items[this.count++] = jSObject;
    }

    protected JSObject pop(int n) {
        if (n + 1 == this.count) {
            --this.count;
            return this.items[this.count];
        }
        if (this.count < n) {
            throw new IllegalStateException("Stack Point: " + this.count + " - " + n);
        }
        this.count = n;
        return null;
    }

    protected void reset(int n) {
        if (this.count > n) {
            this.count = n;
        } else if (this.count < n) {
            throw new IllegalStateException("Stack Point: " + this.count + " - " + n);
        }
    }

    protected boolean isTypeOf(JSObject jSObject, String string) {
        return jSObject != null && !(jSObject instanceof JSFunction) && string.equals(jSObject.getClassName());
    }

    protected JSObject eval(Expression expression, Frame frame, int n) {
        int n2 = this.size();
        JSObject jSObject = null;
        if (expression instanceof InvokeExpression) {
            InvokeExpression invokeExpression = (InvokeExpression)expression;
            Expression expression2 = invokeExpression.receiver;
            if (expression2 instanceof FunctionExpression) {
                Block block = ((FunctionExpression)expression2).body;
                if (block != null && block.statements != null && block.statements.length > 0) {
                    JSObject jSObject2 = null;
                    JSObject jSObject3 = this.localScope;
                    this.localScope = new ObjectImpl();
                    this.localScope.setPrototype(jSObject3);
                    if (invokeExpression.kind == 50) {
                        jSObject2 = this.thisScope;
                        this.thisScope = jSObject = new ObjectImpl();
                    }
                    Statement[] statementArray = block.statements;
                    for (int i = 0; i < statementArray.length; ++i) {
                        Statement statement = statementArray[i];
                        if (statement instanceof ReturnStatement) {
                            ReturnStatement returnStatement = (ReturnStatement)statement;
                            if (returnStatement.expression == null) continue;
                            int n3 = this.size();
                            returnStatement.expression.traverse((ASTVisitor)this, frame);
                            jSObject = this.pop(n3);
                            break;
                        }
                        statement.traverse((ASTVisitor)this, frame);
                    }
                    this.localScope = jSObject3;
                    if (jSObject2 != null) {
                        this.thisScope = jSObject2;
                    }
                }
                this.reset(n2);
                return jSObject;
            }
        }
        expression.traverse((ASTVisitor)this, frame);
        jSObject = this.pop(n2);
        return jSObject;
    }

    protected JSObject evalAssignment(Assignment assignment, Frame frame, int n) {
        JSDoc jSDoc = null;
        JSObject jSObject = null;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(assignment.lhs);
        Expression expression = assignment.expression;
        while (expression instanceof Assignment) {
            assignment = (Assignment)expression;
            arrayList.add(assignment.lhs);
            expression = assignment.expression;
        }
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        block1: for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            Object object2;
            arrayList2.clear();
            boolean bl = false;
            Expression expression2 = (Expression)arrayList.get(i);
            while (expression2 != null) {
                if (expression2 instanceof IdentifierReference || expression2 instanceof ThisReference) {
                    if (i == 0 && n == -1) {
                        n = expression2.sourceStart;
                    }
                    arrayList2.add(expression2);
                    break;
                }
                if (expression2.kind == 46 && expression2 instanceof InvokeExpression) {
                    object2 = (InvokeExpression)expression2;
                    if (((InvokeExpression)object2).arguments != null && ((InvokeExpression)object2).arguments.length == 1) {
                        arrayList2.add(((InvokeExpression)object2).arguments[0]);
                        expression2 = ((InvokeExpression)object2).receiver;
                        continue;
                    }
                    bl = true;
                    break;
                }
                if (expression2.kind == 44 && expression2 instanceof BinaryExpression) {
                    object2 = (BinaryExpression)expression2;
                    if (((BinaryExpression)object2).right instanceof IdentifierReference) {
                        arrayList2.add(((BinaryExpression)object2).right);
                        expression2 = ((BinaryExpression)object2).left;
                        continue;
                    }
                    bl = true;
                    break;
                }
                bl = true;
                break;
            }
            if (i == 0 && expression != null) {
                jSObject = this.eval(expression, frame, n);
                if (arrayList.size() == 1 && arrayList2.size() > 0 && jSObject != null) {
                    if (expression instanceof InvokeExpression) {
                        if (jSObject.getClassName() == null && (expression2 = (Expression)arrayList2.get(0)) instanceof IdentifierReference) {
                            object2 = new String(((IdentifierReference)expression2).token);
                            jSObject.setClassName((String)object2);
                        }
                    } else if (expression instanceof FunctionExpression && jSObject instanceof ExtFunction && ((ObjectImpl)(object2 = (ExtFunction)jSObject)).getClassName() == null && (expression2 = (Expression)arrayList2.get(0)) instanceof IdentifierReference) {
                        object = new String(((IdentifierReference)expression2).token);
                        ((FunctionImpl)object2).setClassName((String)object);
                    }
                }
            }
            if (bl || arrayList2.size() <= 0) continue;
            object = null;
            int n2 = arrayList2.size() - 1;
            expression2 = (Expression)arrayList2.get(n2);
            if (expression2 instanceof IdentifierReference) {
                object = this.localScope;
            } else if (expression2 instanceof ThisReference && n2 > 0) {
                --n2;
                object = this.thisScope;
            }
            while (object != null && n2 >= 0) {
                object2 = null;
                if ((expression2 = (Expression)arrayList2.get(n2--)) instanceof IdentifierReference) {
                    object2 = new String(((IdentifierReference)expression2).token);
                } else {
                    Object object3;
                    int n3 = this.size();
                    expression2.traverse((ASTVisitor)this, frame);
                    JSObject jSObject2 = this.pop(n3);
                    if (this.isTypeOf(jSObject2, "String") && (object3 = jSObject2.getValue()) instanceof String) {
                        object2 = (String)object3;
                    }
                }
                if (object2 == null) continue block1;
                if (n2 < 0) {
                    ISlot iSlot = this.setProperty((ASTNode)expression2, (JSObject)object, (String)object2, jSObject, false);
                    if (n <= 0 || iSlot == null || iSlot.getData(ISlot.P_COMMENT) != null) continue;
                    if (jSDoc == null) {
                        jSDoc = this.createDoc(n, this.lexer);
                    }
                    iSlot.setData(ISlot.P_COMMENT, jSDoc);
                    continue;
                }
                JSObject jSObject3 = object.getProperty((String)object2);
                if (jSObject3 == null) {
                    jSObject3 = new ObjectImpl();
                    this.setProperty((ASTNode)expression2, (JSObject)object, (String)object2, jSObject3, true);
                }
                object = jSObject3;
            }
        }
        if (jSDoc != null && jSObject instanceof ExtFunction) {
            ((ExtFunction)jSObject).setDocument(jSDoc);
        }
        return jSObject;
    }

    public boolean visit(ArrayInitializer arrayInitializer, Frame frame) {
        JSObject jSObject;
        Object object = null;
        Expression[] expressionArray = arrayInitializer.expressions;
        if (expressionArray != null && expressionArray.length > 0 && (jSObject = expressionArray[0]) != null) {
            int n = this.size();
            jSObject.traverse(this, frame);
            JSObject jSObject2 = this.pop(n);
            if (jSObject2 != null) {
                object = jSObject2;
                if (jSObject2 instanceof JSFunction) {
                    object = "Function";
                } else if (!"Array".equals(jSObject2.getClassName())) {
                    object = jSObject2.getClassName();
                }
            }
        }
        if ((jSObject = this.create("Array", object)) != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(Assignment assignment, Frame frame) {
        this.evalAssignment(assignment, frame, -1);
        return false;
    }

    public boolean visit(BinaryExpression binaryExpression, Frame frame) {
        Object var3_3 = null;
        String string = "Boolean";
        int n = (binaryExpression.bits & 0xFC0) >> 6;
        switch (n) {
            case 44: {
                if (binaryExpression.right instanceof IdentifierReference) {
                    int n2 = this.size();
                    binaryExpression.left.traverse((ASTVisitor)this, frame);
                    JSObject jSObject = this.pop(n2);
                    if (jSObject != null && (jSObject = jSObject.getProperty(new String(((IdentifierReference)binaryExpression.right).token))) != null) {
                        this.push(jSObject);
                    }
                }
                return false;
            }
            case 14: {
                string = "String";
                if (binaryExpression.left instanceof NumberLiteral && binaryExpression.right instanceof NumberLiteral) {
                    string = "Number";
                    break;
                }
                if (binaryExpression.left instanceof StringLiteral || binaryExpression.right instanceof StringLiteral) break;
                int n3 = this.size();
                binaryExpression.left.traverse((ASTVisitor)this, frame);
                JSObject jSObject = this.pop(n3);
                if (!this.isTypeOf(jSObject, "Number")) break;
                binaryExpression.right.traverse((ASTVisitor)this, frame);
                jSObject = this.pop(n3);
                if (!this.isTypeOf(jSObject, "Number")) break;
                string = "Number";
                break;
            }
            case 1: {
                if (binaryExpression.left instanceof BooleanLiteral || binaryExpression.right instanceof BooleanLiteral) break;
                int n3 = this.size();
                binaryExpression.left.traverse((ASTVisitor)this, frame);
                JSObject jSObject = this.pop(n3);
                if (jSObject == null) {
                    binaryExpression.right.traverse((ASTVisitor)this, frame);
                    jSObject = this.pop(n3);
                }
                if (jSObject == null) break;
                this.push(jSObject);
                return false;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string = "Number";
            }
        }
        JSObject jSObject = this.create(string, var3_3);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(BooleanLiteral booleanLiteral, Frame frame) {
        Boolean bl = booleanLiteral.value ? Boolean.TRUE : Boolean.FALSE;
        JSObject jSObject = this.create("Boolean", bl);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(ConditionalExpression conditionalExpression, Frame frame) {
        int n = this.size();
        conditionalExpression.valueIfTrue.traverse((ASTVisitor)this, frame);
        if (n == this.size()) {
            conditionalExpression.valueIfFalse.traverse((ASTVisitor)this, frame);
        }
        return false;
    }

    public boolean visit(ExpressionStatement expressionStatement, Frame frame) {
        Expression[] expressionArray = expressionStatement.expressions;
        if (expressionArray != null && expressionArray.length > 0) {
            int n = this.size();
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray[i].traverse((ASTVisitor)this, frame);
            }
            this.reset(n);
        }
        return false;
    }

    protected void setParameters(ExtFunction extFunction, Parameter[] parameterArray) {
        if (parameterArray == null || parameterArray.length == 0) {
            return;
        }
        for (int i = 0; i < parameterArray.length; ++i) {
            extFunction.addParameter(new String(parameterArray[i].name), null);
        }
    }

    public boolean visit(FunctionExpression functionExpression, Frame frame) {
        String string = null;
        if (functionExpression.name != null) {
            string = new String(functionExpression.name);
        }
        ExtFunction extFunction = new ExtFunction(string);
        this.push(extFunction);
        extFunction.setParentScope(this.globalScope);
        this.setParameters(extFunction, functionExpression.parameters);
        return false;
    }

    public boolean visit(FunctionDeclaration functionDeclaration, Frame frame) {
        String string = null;
        if (functionDeclaration.name != null) {
            string = new String(functionDeclaration.name);
        }
        ExtFunction extFunction = new ExtFunction(string);
        JSDoc jSDoc = this.createDoc(functionDeclaration.sourceStart, this.lexer);
        extFunction.setDocument(jSDoc);
        extFunction.setParentScope(this.globalScope);
        ISlot iSlot = this.setProperty((ASTNode)functionDeclaration, this.localScope, string, extFunction, true);
        if (iSlot != null && iSlot.getData(ISlot.P_COMMENT) == null) {
            iSlot.setData(ISlot.P_COMMENT, jSDoc);
        }
        this.setParameters(extFunction, functionDeclaration.parameters);
        return false;
    }

    public boolean visit(IdentifierReference identifierReference, Frame frame) {
        String string = new String(identifierReference.token);
        JSObject jSObject = this.localScope.getProperty(string);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    protected void construct(JSFunction jSFunction, JSObject jSObject, Expression[] expressionArray) {
    }

    public boolean visit(IfStatement ifStatement, Frame frame) {
        return false;
    }

    public boolean visit(InvokeExpression invokeExpression, Frame frame) {
        if (invokeExpression.receiver instanceof FunctionExpression) {
            JSObject jSObject = this.localScope;
            this.localScope = new ObjectImpl();
            this.localScope.setPrototype(jSObject);
            FunctionExpression functionExpression = (FunctionExpression)invokeExpression.receiver;
            if (functionExpression.body != null) {
                functionExpression.body.traverseBody((ASTVisitor)this, frame);
            }
            this.localScope = jSObject;
            return false;
        }
        int n = this.size();
        invokeExpression.receiver.traverse((ASTVisitor)this, frame);
        JSObject jSObject = this.pop(n);
        if (jSObject != null) {
            Expression[] expressionArray = invokeExpression.arguments;
            switch (invokeExpression.kind) {
                case 0: {
                    if (jSObject instanceof JSFunction) {
                        JSFunction jSFunction = (JSFunction)jSObject;
                        if ((jSObject = jSFunction.invoke(null, this.localScope, null)) == null) break;
                        this.push(jSObject);
                        break;
                    }
                    Debug.warn((String)"The expression is not function");
                    break;
                }
                case 50: {
                    if (jSObject instanceof JSFunction) {
                        JSFunction jSFunction = (JSFunction)jSObject;
                        if ((jSObject = jSFunction.construct(null, this.localScope, null)) == null) break;
                        this.push(jSObject);
                        this.construct(jSFunction, jSObject, expressionArray);
                        break;
                    }
                    Debug.warn((String)"The expression is not function");
                    break;
                }
                case 46: {
                    Object object;
                    JSObject jSObject2;
                    if (expressionArray != null && expressionArray.length == 1) {
                        n = this.size();
                        expressionArray[0].traverse((ASTVisitor)this, frame);
                        jSObject2 = this.pop(n);
                        if (this.isTypeOf(jSObject2, "String")) {
                            Object object2 = jSObject2.getValue();
                            if (!(object2 instanceof String) || (jSObject2 = jSObject.getProperty((String)object2)) == null) break;
                            this.push(jSObject2);
                            break;
                        }
                    }
                    if ((object = jSObject.getValue()) instanceof JSObject) {
                        this.push((JSObject)object);
                        break;
                    }
                    if (!(object instanceof String) || (jSObject2 = this.create((String)object, null)) == null) break;
                    this.push(jSObject2);
                }
            }
        }
        return false;
    }

    protected JSObject create(String string, Object object) {
        JSObject jSObject = this.localScope;
        ISlot iSlot = jSObject.getSlot(string);
        if (iSlot != null) {
            JSObject jSObject2 = iSlot.getObject();
            if (jSObject2 instanceof JSFunction) {
                if ((jSObject2 = ((JSFunction)jSObject2).construct(null, jSObject, null)) != null) {
                    jSObject2.setValue(object);
                }
                return jSObject2;
            }
            Debug.warn((String)("The property {" + string + "} of {" + jSObject.getClassName() + "} is not function"));
        }
        return null;
    }

    public boolean visit(NumberLiteral numberLiteral, Frame frame) {
        Object object = new String(numberLiteral.source());
        try {
            object = new Double(Double.parseDouble((String)object));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        JSObject jSObject = this.create("Number", object);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(ObjectInitializer objectInitializer, Frame frame) {
        ObjectImpl objectImpl = new ObjectImpl();
        objectImpl.setPrototype(Context.getObjectPrototype(this.globalScope));
        this.push(objectImpl);
        Expression[] expressionArray = objectInitializer.expressions;
        if (expressionArray != null && expressionArray.length > 0) {
            int n = this.size();
            JSObject jSObject = this.thisScope;
            this.thisScope = objectImpl;
            for (int i = 0; i < expressionArray.length; ++i) {
                Object object;
                if (!(expressionArray[i] instanceof FieldLiteral)) continue;
                String string = null;
                FieldLiteral fieldLiteral = (FieldLiteral)expressionArray[i];
                if (fieldLiteral.field instanceof IdentifierReference) {
                    string = new String(((IdentifierReference)fieldLiteral.field).token);
                } else if (fieldLiteral.field instanceof StringLiteral) {
                    string = new String(((StringLiteral)fieldLiteral.field).source());
                }
                if (string == null) continue;
                JSDoc jSDoc = null;
                JSObject jSObject2 = null;
                if (fieldLiteral.value != null) {
                    fieldLiteral.value.traverse((ASTVisitor)this, frame);
                    jSObject2 = this.pop(n);
                    if (jSObject2 instanceof ExtFunction && ((ExtFunction)(object = (ExtFunction)jSObject2)).getDocument() == null) {
                        jSDoc = this.createDoc(fieldLiteral.field.sourceStart, this.lexer);
                        ((ExtFunction)object).setDocument(jSDoc);
                    }
                }
                if ((object = this.setProperty((ASTNode)fieldLiteral.field, objectImpl, string, jSObject2, true)) == null || object.getData(ISlot.P_COMMENT) != null) continue;
                if (jSDoc == null) {
                    jSDoc = this.createDoc(fieldLiteral.field.sourceStart, this.lexer);
                }
                object.setData(ISlot.P_COMMENT, jSDoc);
            }
            this.reset(n);
            this.thisScope = jSObject;
        }
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression, Frame frame) {
        JSObject jSObject = this.create("Number", null);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression, Frame frame) {
        JSObject jSObject = this.create("Number", null);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(RegExpLiteral regExpLiteral, Frame frame) {
        JSObject jSObject = this.create("RegExp", null);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(StringLiteral stringLiteral, Frame frame) {
        JSObject jSObject = this.create("String", new String(stringLiteral.source()));
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(ThisReference thisReference, Frame frame) {
        this.push(this.thisScope);
        return false;
    }

    public boolean visit(UnaryExpression unaryExpression, Frame frame) {
        JSObject jSObject;
        String string = null;
        int n = (unaryExpression.bits & 0xFC0) >> 6;
        switch (n) {
            case 11: 
            case 41: 
            case 42: {
                string = "Boolean";
                break;
            }
            case 43: {
                string = "String";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 32: 
            case 33: {
                string = "Number";
            }
        }
        if (string != null && (jSObject = this.create(string, null)) != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(VariableBinding variableBinding, Frame frame) {
        ISlot iSlot;
        JSDoc jSDoc = null;
        JSObject jSObject = null;
        Expression expression = variableBinding.initializer;
        if (expression instanceof Assignment) {
            jSObject = this.evalAssignment((Assignment)expression, frame, variableBinding.sourceStart);
            if (jSObject instanceof ExtFunction) {
                jSDoc = ((ExtFunction)jSObject).getDocument();
            }
        } else if (expression != null) {
            jSObject = this.eval(expression, frame, variableBinding.sourceStart);
        }
        if ((iSlot = this.setProperty((ASTNode)variableBinding, this.localScope, new String(variableBinding.name), jSObject, true)) != null && iSlot.getData(ISlot.P_COMMENT) == null) {
            if (jSDoc == null) {
                jSDoc = this.createDoc(variableBinding.sourceStart, this.lexer);
            }
            iSlot.setData(ISlot.P_COMMENT, jSDoc);
        }
        if (jSDoc != null && jSObject instanceof ExtFunction) {
            ((ExtFunction)jSObject).setDocument(jSDoc);
        }
        return false;
    }

    protected ISlot setProperty(ASTNode aSTNode, JSObject jSObject, String string, JSObject jSObject2, boolean bl) {
        if (!(jSObject instanceof ObjectImpl)) {
            return null;
        }
        ISlot iSlot = jSObject.getSlot(string);
        if (iSlot != null && !"prototype".equals(string) && !bl) {
            return null;
        }
        if (iSlot == null) {
            iSlot = new Slot();
            ((ObjectImpl)jSObject).defineProperty(string, iSlot);
        } else if ("prototype".equals(string)) {
            JSObject jSObject3;
            if (jSObject2 == null) {
                jSObject2 = new ObjectImpl();
            }
            if (jSObject2.getClassName() == null && (jSObject3 = iSlot.getObject()) != null && jSObject3.getClassName() != null) {
                jSObject2.setClassName(jSObject3.getClassName());
            }
        }
        iSlot.setData(ISlot.P_SOURCE, this.fileName);
        iSlot.setObject(jSObject2);
        if (aSTNode != null) {
            iSlot.setData(ISlot.P_RANGE, new Point(aSTNode.sourceStart, aSTNode.sourceEnd));
        }
        return iSlot;
    }
}

