/*
 * Decompiled with CFR 0.152.
 */
package com.spket.dtd.text;

import com.spket.dtd.text.DTDPartitions;
import com.spket.ui.text.BufferedDocumentScanner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class DTDPartitionScanner
implements IPartitionTokenScanner,
DTDPartitions {
    private static final int DTD = 0;
    private static final int ENTITY = 1;
    private static final int COMMENT = 2;
    private static final int PI = 3;
    private static final int STRING = 4;
    private static final int NONE = 0;
    private static final IToken[] Tokens = new IToken[]{new Token(null), new Token((Object)"__xml_tag"), new Token((Object)"__xml_comment"), new Token((Object)"__xml_pi")};
    private int fLast;
    private int fQuote;
    private int fState;
    private int fTokenOffset;
    private int fTokenLength;
    private int fPrefixLength;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);

    private static int getState(String string) {
        if (string == null) {
            return 0;
        }
        if ("__xml_tag".equals(string)) {
            return 1;
        }
        if ("__xml_comment".equals(string)) {
            return 2;
        }
        if ("__xml_pi".equals(string)) {
            return 3;
        }
        return 0;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public IToken nextToken() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        while (true) {
            int n = this.fScanner.read();
            switch (n) {
                case -1: {
                    if (this.fTokenLength > 0) {
                        this.fLast = 0;
                        if (this.fState == 4) {
                            this.fState = 1;
                        }
                        return this.preFix(this.fState, 0, 0, 0);
                    }
                    this.fLast = 0;
                    this.fPrefixLength = 0;
                    return Token.EOF;
                }
            }
            block3 : switch (this.fState) {
                case 0: {
                    switch (n) {
                        case 33: {
                            if (this.fLast == 60) {
                                if (this.fScanner.skipString("--")) {
                                    this.fState = 2;
                                    if (this.fTokenLength > 1) {
                                        --this.fTokenLength;
                                        this.fPrefixLength = 4;
                                        return Tokens[0];
                                    }
                                    this.fTokenLength = 4;
                                    break block3;
                                }
                                if (this.fScanner.skipString("ENTITY")) {
                                    this.fState = 1;
                                    if (this.fTokenLength > 1) {
                                        --this.fTokenLength;
                                        this.fPrefixLength = 8;
                                        return Tokens[0];
                                    }
                                    this.fTokenLength = 8;
                                    break block3;
                                }
                                this.consume();
                                break block3;
                            }
                            this.consume();
                            break block3;
                        }
                        case 63: {
                            if (this.fLast == 60) {
                                this.fState = 3;
                                if (this.fTokenLength > 1) {
                                    --this.fTokenLength;
                                    this.fPrefixLength = 2;
                                    return Tokens[0];
                                }
                                this.fTokenLength = 2;
                                break block3;
                            }
                            this.consume();
                            break block3;
                        }
                    }
                    ++this.fTokenLength;
                    this.fLast = n;
                    break;
                }
                case 1: {
                    switch (n) {
                        case 34: 
                        case 39: {
                            this.fQuote = n;
                            this.fState = 4;
                            break;
                        }
                        case 62: {
                            return this.postFix(1);
                        }
                    }
                    this.consume();
                    break;
                }
                case 4: {
                    if (this.fQuote == n) {
                        this.fState = 1;
                    }
                    this.consume();
                    break;
                }
                case 2: {
                    if (n == 45) {
                        if (this.fLast == 45) {
                            if (this.fScanner.skipChar('>')) {
                                ++this.fTokenLength;
                            }
                            return this.postFix(2);
                        }
                        ++this.fTokenLength;
                        this.fLast = n;
                        break;
                    }
                    this.consume();
                    break;
                }
                case 3: {
                    if (n == 62 && this.fLast == 63) {
                        return this.postFix(3);
                    }
                    this.fLast = n;
                    ++this.fTokenLength;
                }
            }
        }
    }

    public void setRange(IDocument iDocument, int n, int n2) {
        this.fLast = 0;
        this.fState = 0;
        this.fTokenLength = 0;
        this.fPrefixLength = 0;
        this.fTokenOffset = n;
        this.fScanner.setRange(iDocument, n, n2);
    }

    public void setPartialRange(IDocument iDocument, int n, int n2, String string, int n3) {
        this.fLast = 0;
        this.fTokenLength = 0;
        this.fTokenOffset = n3;
        this.fPrefixLength = n - n3;
        this.fState = n == n3 ? 0 : DTDPartitionScanner.getState(string);
        this.fScanner.setRange(iDocument, n, n2);
    }

    private final IToken postFix(int n) {
        this.fLast = 0;
        this.fState = 0;
        ++this.fTokenLength;
        this.fPrefixLength = 0;
        return Tokens[n];
    }

    private final IToken preFix(int n, int n2, int n3, int n4) {
        this.fLast = n3;
        this.fState = n2;
        this.fPrefixLength = n4;
        return Tokens[n];
    }

    private final void consume() {
        ++this.fTokenLength;
        this.fLast = 0;
    }
}

