/*
 * Decompiled with CFR 0.152.
 */
package com.spket.dtd.text;

import com.spket.dtd.text.EntityScanner;
import com.spket.ui.text.ConfigurableScanner;
import com.spket.ui.text.IColorManager;
import com.spket.ui.text.IConfigurable;
import com.spket.ui.text.SingleTokenScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class DTDSourceViewerConfiguration
extends TextSourceViewerConfiguration
implements IConfigurable {
    static final String[] TYPES = new String[]{"__dftl_partition_content_type", "__xml_tag", "__xml_comment", "__xml_pi"};
    private IColorManager fColorManager;
    private String fDocumentPartitioning;
    private ConfigurableScanner[] fScanners;

    public DTDSourceViewerConfiguration(IPreferenceStore iPreferenceStore, IColorManager iColorManager, String string) {
        super(iPreferenceStore);
        this.fColorManager = iColorManager;
        this.fDocumentPartitioning = string;
        this.initializeScanners();
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer iSourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(iSourceViewer);
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return TYPES;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        presentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        for (int i = 0; i < this.fScanners.length; ++i) {
            ConfigurableScanner configurableScanner = this.fScanners[i];
            if (configurableScanner == null) continue;
            DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.fScanners[i]);
            presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, TYPES[i]);
            presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, TYPES[i]);
        }
        return presentationReconciler;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        for (int i = 0; i < this.fScanners.length; ++i) {
            if (this.fScanners[i] == null || !this.fScanners[i].affectsTextPresentation(propertyChangeEvent)) continue;
            return true;
        }
        return false;
    }

    public void changeConfiguration(PropertyChangeEvent propertyChangeEvent) {
        for (int i = 0; i < this.fScanners.length; ++i) {
            if (this.fScanners[i] == null) continue;
            this.fScanners[i].changeConfiguration(propertyChangeEvent);
        }
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    private void initializeScanners() {
        IColorManager iColorManager = this.getColorManager();
        this.fScanners = new ConfigurableScanner[4];
        this.fScanners[0] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_default");
        this.fScanners[1] = new EntityScanner(iColorManager, this.fPreferenceStore);
        this.fScanners[2] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_comments");
        this.fScanners[3] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_proc_instr");
    }
}

