use namespace internal;

class Point {
	var x:Number;
	var y:Number;
}

class Matrix {
	var M11:Number;
	var M12:Number;
	var M21:Number;
	var M22:Number;
	var OffsetX:Number;
	var OffsetY:Number;
}

abstract class DependencyObject {
	var name:String;
	
	function findName(name:String):DependencyObject;
	function getValue(name:String):Object;
	function setValue(name:String, value:Object);
}

template class Collection extends DependencyObject {
	var count:Number;
	
	function getItem(index:Number):[T];
	function insert(index:Number, value:[T]):void;
	function remove(value:[T]):Boolean;
	function removeAt(index:Number):Boolean;
	function add(value:[T]):Number;
}

class EventArgs {
}

ErrorType = [ "DownloadError", "ImageError", "InitializeError", "MediaError", "NoError", "ObjectModelError", "ParserError", "RuntimeError", "UnknownError" ]

Key = [ "KEYNONE", "BACKSPACE", "TAB", "ENTER", "SHIFT", "CTRL", "ALT", "CAPSLOCK", "ESCAPE", "SPACE", "PAGEUP", "PAGEDOWN", "END", "HOME", "LEFT", "UP", "RIGHT", "DOWN", "INSERT", "DELETE", "DIGIT0", "DIGIT1", "DIGIT2", "DIGIT3", "DIGIT4", "DIGIT5", "DIGIT6", "DIGIT7", "DIGIT8", "DIGIT9", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11", "F12", "NUMPAD0", "NUMPAD1", "NUMPAD2", "NUMPAD3", "NUMPAD4", "NUMPAD5", "NUMPAD6", "NUMPAD7", "NUMPAD8", "NUMPAD9", "MULTIPLY", "ADD", "SUBTRACT", "DECIMAL", "DIVIDE", "KEYUNKNOWN" ]
Color = [ "aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkgrey", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkslategrey", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dimgrey", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "grey", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgray", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightslategrey", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "slategrey", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen" ]

class KeyboardEventArgs extends EventArgs {
	var ctrl:Boolean;
	var key:Key;
	var platformKeyCode:Key;
	var shift:Boolean;
}

TabletDeviceType = [ "Mouse", "Stylus", "Touch" ]

class StylusInfo extends DependencyObject {
	var deviceType:TabletDeviceType;
	var IsInverted:Boolean;
}

class MouseEventArgs extends EventArgs {
	var ctrl:Boolean;
	var shift:Boolean;
	
	function getPosition(uiElement:UIElement):Point;
	function getStylusInfo():StylusInfo;
	function getStylusPoints(uiElement:UIElement):Collection[StylusPoint];
}

class ErrorEventArgs extends EventArgs {
	var errorCode:Number;
	var errorMessage:String;
	var errorType:ErrorType;
}

class ParserErrorEventArgs extends EventArgs {
	var charPosition:Number;
	var lineNumber:Number;
	var xamlFile:String;
	var xmlAttribute:String;
	var xmlElement:String;
}

class RuntimeErrorEventArgs extends EventArgs {
	var charPosition:Number;
	var lineNumber:Number;
	var methodName:String;
}

class TimelineMarkerEventArgs extends EventArgs {
	var marker:TimelineMarker;
}

class Duration extends DependencyObject {}
class TimeSpan extends DependencyObject {}
class RepeatBehavior extends DependencyObject {}

FillBehavior = [ "HoldEnd", "Stop" ]

abstract class Timeline extends DependencyObject {
	var autoReverse:Boolean;
	var beginTime:TimeSpan;
	var duration:Duration;
	var fillBehavior:FillBehavior;
	var repeatBehavior:RepeatBehavior;
	var speedRatio:Number;
	
	var StoryBoard$TargetName:String;
	var StoryBoard$TargetProperty:String;
}

abstract class Animation extends Timeline {
	var by:Number;
	var from:Number;
	var to:Number;
}

class ColorAnimation extends Animation {}
class DoubleAnimation extends Animation {}
class PointAnimation extends Animation {}

class KeyTime extends DependencyObject {}

abstract class KeyFrame extends DependencyObject {
	var keyTime:KeyTime;
}

class KeySpline extends DependencyObject {
	var keyTime:KeyTime;
}

abstract class ColorKeyFrame extends KeyFrame {
	var value:Color;
}

class DiscreteColorKeyFrame extends ColorKeyFrame {}
class LinearColorKeyFrame extends ColorKeyFrame {}
class SplineColorKeyFrame extends ColorKeyFrame {
	var keySpline:KeySpline;
}

abstract class DoubleKeyFrame extends KeyFrame {
	var value:Number;
}

class DiscreteDoubleKeyFrame extends DoubleKeyFrame {}
class LinearDoubleKeyFrame extends DoubleKeyFrame {}
class SplineDoubleKeyFrame extends DoubleKeyFrame {
	var keySpline:KeySpline;
}

abstract class PointKeyFrame extends KeyFrame {
	var value:Point;
}

class DiscretePointKeyFrame extends PointKeyFrame {}
class LinearPointKeyFrame extends PointKeyFrame {}
class SplinePointKeyFrame extends PointKeyFrame {
	var keySpline:KeySpline;
}

class ColorAnimationUsingKeyFrames extends ColorAnimation {
	var KeyFrames:Collection[KeyFrame];
}

class DoubleAnimationUsingKeyFrames extends DoubleAnimation {
	var KeyFrames:Collection[KeyFrame];
}

class PointAnimationUsingKeyFrames extends PointAnimation {
	var KeyFrames:Collection[KeyFrame];
}

abstract class TimelineGroup extends Timeline {
	var children:Timeline;
}

abstract class ParallelTimeline extends TimelineGroup {}

[Event(Completed=EventHandler)]
class Storyboard extends ParallelTimeline {
	function begin():void;
	function pause():void;
	function resume():void;
	function seek(timespan:TimeSpan):void;
	function stop():void;
}

class BeginStoryboard extends DependencyObject {
	var storyboard:Storyboard;
}

abstract class PathSegment extends DependencyObject {
}

SweepDirection = [ "Clockwise", "CounterClockwise" ]

class ArcSegment extends PathSegment {
	var isLargeArc:Boolean;
	var point:Point;
	var rotationAngle:Number;
	var size:Point;
	var sweepDirection:SweepDirection;
}

class BezierSegment extends PathSegment {
	var point1:Point;
	var point2:Point;
	var point3:Point;
}

class LineSegment extends PathSegment {
	var point:Point;
}

class PolyBezierSegment extends PathSegment {
	var points:Collection[Point];
}

class PolyLineSegment extends PathSegment {
	var points:Collection[Point];
}

class PolyQuadraticBezierSegment extends PathSegment {
	var points:Collection[Point];
}

class QuadraticBezierSegment extends PathSegment {
	var point1:Point;
	var point2:Point;
}

abstract class Brush extends DependencyObject {
	var opacity:Number;
	var transform:Transform;
	var relativeTransform:Transform;
}

class SolidColorBrush extends Brush {
	var color:Color;
	var offset:Number;
}

ColorInterpolationMode = [ "ScRgbLinearInterpolation", "SRgbLinearInterpolation" ]

class GradientStop extends DependencyObject {
	var color:Color;
}

BrushMappingMode = [ "Absolute", "RelativeToBoundingBox" ]
GradientSpreadMethod = [ "Pad", "Reflect", "Repeat" ]

abstract class GradientBrush extends Brush {
	var colorInterpolationMode:ColorInterpolationMode;
	var gradientStops:Collection[GradientStop];
	var mappingMode:BrushMappingMode;
	var spreadMethod:GradientSpreadMethod;
}

class LinearGradientBrush extends GradientBrush {
	var startPoint:Point;
	var endPoint:Point;
}

class RadialGradientBrush extends GradientBrush {
	var center:Point;
	var gradientOrigin:Point;
	var radiusX:Point;
	var radiusY:Point;
}

AlignmentX = [ "Center", "Left", "Right" ]
AlignmentY = [ "Bottom", "Center", "Top" ]
Stretch = [ "Fill", "None", "Uniform", "UniformToFill" ]

abstract class TileBrush extends Brush {
	var alignmentX:AlignmentX;
	var alignmentY:AlignmentY;
	var stretch:Stretch;
}

class ImageBrush extends TileBrush {
	var downloadProgress:Number;
	var imageSource:String;
}

class VideoBrush extends TileBrush {
	var sourceName:String;
}

abstract class Transform extends DependencyObject {
}

class MatrixTransform extends Transform {
	var matrix:Matrix;
}

class RotateTransform extends Transform {
	var angle:Number;
	var centerX:Number;
	var centerY:Number;
}

class ScaleTransform extends Transform {
	var centerX:Number;
	var centerY:Number;
	var scaleX:Number;
	var scaleY:Number;
}

class SkewTransform extends Transform {
	var angleX:Number;
	var angleY:Number;
	var centerX:Number;
	var centerY:Number;
}

class TransformGroup extends Transform {
	var children:Collection[Transform];
}

class TranslateTransform extends Transform {
	var x:Number;
	var y:Number;
}

abstract class Geometry extends DependencyObject {
	var fillRule:FillRule;
	var transform:Transform;
}

class EllipseGeometry extends Geometry {
	var center:Point;
	var radiusX:Number;
	var radiusY:Number;
}

class GeometryGroup extends Geometry {
	var children:Collection[Geometry];
}

class LineGeometry extends Geometry {
	var endPoint:Point;
	var startPoint:Point;
}

class PathFigure extends DependencyObject {
	var isClosed:Boolean;
	var isFilled:Boolean;
	var segments:Collection[PathSegment];
	var startPoint:Point;
}

class PathGeometry extends Geometry {
	var figures:Collection[PathFigure];
	var fillRule:Boolean;
}

class Rect {
	var x:Number;
	var y:Number;
	var width:Number;
	var height:Number;
}

class RectangleGeometry extends Geometry {
	var rect:Rect;
	var radiusX:Number;
	var radiusY:Number;
}

class DrawingAttributes extends DependencyObject {
	var color:Color;
	var outlineColor:Color;
	
	var width:Number;
	var height:Number;
}

class StylusPoint extends DependencyObject {
	var x:Number;
	var y:Number;
	var pressureFactor:Number;
}

class Stroke extends DependencyObject {
	var drawingAttributes:DrawingAttributes;
	var stylusPoints:Collection[StylusPoint];
	
	function getBounds():Rect;
	function hitTest(stylusPointCollection:Collection[StylusPoint]):Boolean;
}

Visibility = [ "Collapsed", "Hidden", "Visible" ]

class EventTrigger extends DependencyObject {
	var actions:Collection[BeginStoryboard, "TriggerAction"];
	var routedEvent:String
}

[Event(
	OnError=ErrorEventHandler,
	OnFullScreenChange=EventHandler,
	OnLoad=EventHandler,
	OnResize=EventHandler
)]
class SilverlightControl {
	var actualHeight:Number;
	var actualWidth:Number;
	var fullScreen:Boolean;
	
	function createFromXaml(xamlContent:String, nameScope:Boolean=false):DependencyObject;
	function createFromXamlDownloader(downloader:Downloader, part:String):DependencyObject;
	function findName(name:String):DependencyObject;
}

class Settings {
	var background:Color;
	var enableFramerateCounter:Boolean;
	var enableHtmlAccess:Boolean;
	var enableRedrawRegions:Boolean;
	var maxFrameRate:Number;
	var version:String;
	var windowless:Boolean;
}

class SilverlightControlHost {
	var content:SilverlightControl;
	var initParams:String;
	var isLoaded:Boolean;
	var source:String;
	var settings:Settings;
	
	function createObject(objectType:String):Object;
}

[Event(
	GotFocus=EventHandler,
	KeyDown=KeyboardEventHandler,
	KeyUp=KeyboardEventHandler,
	Loaded=EventHandler,
	LostFocus=EventHandler,
	MouseEnter=MouseEventHandler,
	MouseLeave=EventHandler,
	MouseLeftButtonDown=MouseEventHandler,
	MouseLeftButtonUp=MouseEventHandler,
	MouseMove=MouseEventHandler
)]
abstract class UIElement extends DependencyObject {
	var clip:Geometry;
	var cursor:Cursors;
	var isHitTestVisible:Boolean;
	var opacity:Number;
	var opacityMask:Brush;
	var renderTransform:Transform;
	var renderTransformOrigin:Point;
	var resources:Collection[DependencyObject, "Resource"];
	var triggers:Collection[EventTrigger, "Trigger"];
	var visibility:Visibility;
	var Canvas$Left:Number;
	var Canvas$Top:Number;
	var Canvas$zIndex:Number;
	var width:Number;
	var height:Number;
	
	function captureMouse():Boolean;
	function releaseMouseCapture():void;
	function getHost():SilverlightControlHost;
	function getParent():Canvas;
}

/*
abstract class FrameworkElement extends UIElement {
}
*/
PenLineCap = [ "Flat", "Round", "Square", "Triangle" ]
PenLineJoin = [ "Bevel", "Miter", "Round" ]

abstract class Shape extends UIElement {
	var fill:Brush;
	var stretch:Stretch;
	var stroke:Brush;
	var strokeDashArray:Collection[Number, "Double"];
	var strokeDashCap:PenLineCap;
	var strokeDashOffset:Number;
	var strokeEndLineCap:PenLineCap;
	var strokeLineJoin:PenLineJoin;
	var strokeMiterLimit:Number;
	var strokeStartLineCap:PenLineCap;
	var strokeThickness:Number;
}

class Ellipse extends Shape {}
class Line extends Shape {
	var x1:Number;
	var y1:Number;
	var x2:Number;
	var y2:Number;
}

class Path extends Shape {
	var data:Geometry;
}

FillRule = [ "EvenOdd", "Nonzero" ]

class Polygon extends Shape {
	var fillRule:FillRule;
	var points:Collection[Point];
}

class Polyline extends Shape {
	var fillRule:FillRule;
	var points:Collection[Point];
}

class Rectangle extends Shape {
	var radiusX:Number;
	var radiusY:Number;
}

class Glyphs extends UIElement {
	var fill:Brush;
	var fontRenderingEmSize:Number;
	var fontUri:String;
	var indices:String;
	var originX:Number;
	var originY:Number;
	var styleSimulations:String;
	var unicodeString:String;
}

[Event(MediaEnded=EventHandler, MediaFailed=ErrorEventHandler, MediaOpened=EventHandler)]
abstract class MediaBase extends UIElement {
	var source:String;
	var stretch:Stretch;
}

[Event(ImageFailed=ErrorEventHandler)]
class Image extends MediaBase {
	var downloadProgress:Number;
	
	function setSource(downloader:Downloader, partName:String):void;
}

class MediaAttribute extends DependencyObject {
	var value:String;
}

class TimelineMarker extends DependencyObject {
	var text:String;
	var time:TimeSpan;
	var type:String;
}

[Event(
	BufferingProgressChanged=EventHandler,
	CurrentStateChanged=EventHandler,
	DownloadProgressChanged=EventHandler,
	MarkerReached=TimelineMarkerEventHandler
)]
class MediaElement extends MediaBase {
	var attributes:Collection[MediaAttribute];
	var autoPlay:Boolean;
	var balance:Number;
	var bufferingProgress:Number;
	var bufferingTime:TimeSpan;
	var downloadProgress:Number;
	var isMuted:Boolean;
	var markers:Collection[TimelineMarker];
	var naturalDuration:Duration;
	var naturalVideoHeight:Number;
	var naturalVideoWidth:Number;
	var position:TimeSpan;
	var volume:Number;
	
	function pause():void;
	function play():void;
	function setSource(downloader:Downloader, partName:String):void;
	function stop():void;
}

FontStretches = [ "Condensed", "Expanded", "ExtraCondensed", "ExtraExpanded", "Medium", "Normal", "SemiCondensed", "SemiExpanded", "UltraCondensed", "UltraExpanded" ]
FontStyles = [ "Italic", "Normal", "Oblique" ]
FontWeights = [ "Black", "Bold", "DemiBold", "ExtraBlack", "ExtraBold", "ExtraLight", "Heavy", "Light", "Medium", "Normal", "Regular", "SemiBold", "Thin", "UltraBlack", "UltraBold", "UltraLight" ]
TextDecorations = [ "None", "Underline" ]

abstract class Inline extends DependencyObject {
	var fontFamily:String;
	var fontSize:Number;
	var fontStretch:FontStretches;
	var fontStyle:FontStyles;
	var fontWeight:FontWeights;
	var foreground:Brush;
	var textDecorations:TextDecorations;
}

class LineBreak extends Inline {
}

class Run extends Inline {
	var text:String;
}

class Canvas extends UIElement {
	var background:Brush;
	var children:Collection[UIElement];
}

class InkPresenter extends Canvas {
	var strokes:Collection[Stroke];
}

TextWrapping = ["NoWrap", "Wrap", "WrapWithOverflow" ]

class TextBlock extends UIElement {
	var actualHeight:Number;
	var actualWidth:Number;
	var fontFamily:String;
	var fontSize:Number;
	var fontStretch:FontStretches;
	var fontStyle:FontStyles;
	var fontWeight:FontWeights;
	var foreground:Brush;
	var inlines:Collection[Inline];
	var text:String;
	var textDecorations:TextDecorations;
	var textWrapping:TextWrapping;
	
	function setFontSource(downloader:Downloader):void;
}

[Event(Completed=EventHandler, DownloadFailed=ErrorEventHandler, DownloadProgressChanged=EventHandler)]
class Downloader extends DependencyObject {
	var downloadProgress:Number;
	var status:Number;
	var statusText:String;
	var uri:String;
	
	function abort():void;
	function getResponseText(part:String):String;
	function open(verb:String, uri:String, async:Boolean):void;
	function send():void;
}

Collection[ColorKeyFrame]
Collection[DoubleKeyFrame]
Collection[PointKeyFrame]
Collection[Timeline]
