//html2
interface HTMLCollection {
	const length:Number;
	function item(index:Number):Node;
	function namedItem(name:String):Node;
}

interface HTMLOptionsCollection {
	var length:Number;
	function item(index:Number):Node;
	function namedItem(name:String):Node;
}

interface HTMLDocument extends Document, EventTarget {
	var title:String;
	const referrer:String;
	const domain:String;
	const URL:String;
	var body:HTMLElement;
	const images:HTMLCollection;
	const applets:HTMLCollection;
	const links:HTMLCollection;
	const forms:HTMLCollection;
	const anchors:HTMLCollection;
	var cookie:String;
	function open():void;
	function close():void;
	function write(text:String):void;
	function writeln(text:String):void;
	function getElementsByName(elementName:String):NodeList;
}

interface HTMLElement extends Element, EventTarget {
	var id:String;
	var title:String;
	var lang:String;
	var dir:String;
	var className:String;
}

interface HTMLHtmlElement extends HTMLElement {
	var version:String;
}

interface HTMLHeadElement extends HTMLElement {
	var profile:String;
}

interface HTMLLinkElement extends HTMLElement {
	var disabled:Boolean;
	var charset:String;
	var href:String;
	var hreflang:String;
	var media:String;
	var rel:String;
	var rev:String;
	var target:String;
	var type:String;
}

interface HTMLTitleElement extends HTMLElement {
	var text:String;
}

interface HTMLMetaElement extends HTMLElement {
	var content:String;
	var httpEquiv:String;
	var name:String;
	var scheme:String;
}

interface HTMLBaseElement extends HTMLElement {
	var href:String;
	var target:String;
}

interface HTMLIsIndexElement extends HTMLElement {
	const form:HTMLFormElement;
	var prompt:String;
}

interface HTMLStyleElement extends HTMLElement {
	var disabled:Boolean;
	var media:String;
	var type:String;
}

interface HTMLBodyElement extends HTMLElement {
	var aLink:String;
	var background:String;
	var bgColor:String;
	var link:String;
	var text:String;
	var vLink:String;
}

interface HTMLFormElement extends HTMLElement {
	const elements:HTMLCollection;
	const length:Number;
	var name:String;
	var acceptCharset:String;
	var action:String;
	var enctype:String;
	var method:String;
	var target:String;
	function submit():void;
	function reset():void;
}

interface HTMLSelectElement extends HTMLElement {
	const type:String;
	var selectedIndex:Number;
	var value:String;
	var length:Number;
	const form:HTMLFormElement;
	const options:HTMLOptionsCollection;
	var disabled:Boolean;
	var multiple:Boolean;
	var name:String;
	var size:Number;
	var tabIndex:Number;
	throws(DOMException) function add(element:HTMLElement, before:HTMLElement):void;
	function remove(index:Number):void;
	function blur():void;
	function focus():void;
}

interface HTMLOptGroupElement extends HTMLElement {
	var disabled:Boolean;
	var label:String;
}

interface HTMLOptionElement extends HTMLElement {
	const form:HTMLFormElement;
	var defaultSelected:Boolean;
	const text:String;
	const index:Number;
	var disabled:Boolean;
	var label:String;
	var selected:Boolean;
	var value:String;
}

interface HTMLInputElement extends HTMLElement {
	var defaultValue:String;
	var defaultChecked:Boolean;
	const form:HTMLFormElement;
	var accept:String;
	var accessKey:String;
	var align:String;
	var alt:String;
	var checked:Boolean;
	var disabled:Boolean;
	var maxLength:Number;
	var name:String;
	var readOnly:Boolean;
	var size:Number;
	var src:String;
	var tabIndex:Number;
	var type:String;
	var useMap:String;
	var value:String;
	function blur():void;
	function focus():void;
	function select():void;
	function click():void;
}

interface HTMLTextAreaElement extends HTMLElement {
	var defaultValue:String;
	const form:HTMLFormElement;
	var accessKey:String;
	var cols:Number;
	var disabled:Boolean;
	var name:String;
	var readOnly:Boolean;
	var rows:Number;
	var tabIndex:Number;
	const type:String;
	var value:String;
	function blur():void;
	function focus():void;
	function select():void;
}

interface HTMLButtonElement extends HTMLElement {
	const form:HTMLFormElement;
	var accessKey:String;
	var disabled:Boolean;
	var name:String;
	var tabIndex:Number;
	const type:String;
	var value:String;
}

interface HTMLLabelElement extends HTMLElement {
	const form:HTMLFormElement;
	var accessKey:String;
	var htmlFor:String;
}

interface HTMLFieldSetElement extends HTMLElement {
	const form:HTMLFormElement;
}

interface HTMLLegendElement extends HTMLElement {
	const form:HTMLFormElement;
	var accessKey:String;
	var align:String;
}

interface HTMLUListElement extends HTMLElement {
	var compact:Boolean;
	var type:String;
}

interface HTMLOListElement extends HTMLElement {
	var compact:Boolean;
	var start:Number;
	var type:String;
}

interface HTMLDListElement extends HTMLElement {
	var compact:Boolean;
}

interface HTMLDirectoryElement extends HTMLElement {
	var compact:Boolean;
}

interface HTMLMenuElement extends HTMLElement {
	var compact:Boolean;
}

interface HTMLLIElement extends HTMLElement {
	var type:String;
	var value:Number;
}

interface HTMLDivElement extends HTMLElement {
	var align:String;
}

interface HTMLParagraphElement extends HTMLElement {
	var align:String;
}

interface HTMLHeadingElement extends HTMLElement {
	var align:String;
}

interface HTMLQuoteElement extends HTMLElement {
	var cite:String;
}

interface HTMLPreElement extends HTMLElement {
	var width:Number;
}

interface HTMLBRElement extends HTMLElement {
	var clear:String;
}

interface HTMLBaseFontElement extends HTMLElement {
	var color:String;
	var face:String;
	var size:Number;
}

interface HTMLFontElement extends HTMLElement {
	var color:String;
	var face:String;
	var size:String;
}

interface HTMLHRElement extends HTMLElement {
	var align:String;
	var noShade:Boolean;
	var size:String;
	var width:String;
}

interface HTMLModElement extends HTMLElement {
	var cite:String;
	var dateTime:String;
}

interface HTMLAnchorElement extends HTMLElement {
	var accessKey:String;
	var charset:String;
	var coords:String;
	var href:String;
	var hreflang:String;
	var name:String;
	var rel:String;
	var rev:String;
	var shape:String;
	var tabIndex:Number;
	var target:String;
	var type:String;
	function blur():void;
	function focus():void;
}

interface HTMLImageElement extends HTMLElement {
	var name:String;
	var align:String;
	var alt:String;
	var border:String;
	var height:Number;
	var hspace:Number;
	var isMap:Boolean;
	var longDesc:String;
	var src:String;
	var useMap:String;
	var vspace:Number;
	var width:Number;
}

interface HTMLObjectElement extends HTMLElement {
	const form:HTMLFormElement;
	var code:String;
	var align:String;
	var archive:String;
	var border:String;
	var codeBase:String;
	var codeType:String;
	var data:String;
	var declare:Boolean;
	var height:String;
	var hspace:Number;
	var name:String;
	var standby:String;
	var tabIndex:Number;
	var type:String;
	var useMap:String;
	var vspace:Number;
	var width:String;
	const contentDocument:Document;
}

interface HTMLParamElement extends HTMLElement {
	var name:String;
	var type:String;
	var value:String;
	var valueType:String;
}

interface HTMLAppletElement extends HTMLElement {
	var align:String;
	var alt:String;
	var archive:String;
	var code:String;
	var codeBase:String;
	var height:String;
	var hspace:Number;
	var name:String;
	var object:String;
	var vspace:Number;
	var width:String;
}

interface HTMLMapElement extends HTMLElement {
	const areas:HTMLCollection;
	var name:String;
}

interface HTMLAreaElement extends HTMLElement {
	var accessKey:String;
	var alt:String;
	var coords:String;
	var href:String;
	var noHref:Boolean;
	var shape:String;
	var tabIndex:Number;
	var target:String;
}

interface HTMLScriptElement extends HTMLElement {
	var text:String;
	var htmlFor:String;
	var event:String;
	var charset:String;
	var defer:Boolean;
	var src:String;
	var type:String;
}

interface HTMLTableElement extends HTMLElement {
	var caption:HTMLTableCaptionElement;
	var tHead:HTMLTableSectionElement;
	var tFoot:HTMLTableSectionElement;
	const rows:HTMLCollection;
	const tBodies:HTMLCollection;
	var align:String;
	var bgColor:String;
	var border:String;
	var cellPadding:String;
	var cellSpacing:String;
	var frame:String;
	var rules:String;
	var summary:String;
	var width:String;
	function createTHead():HTMLElement;
	function deleteTHead():void;
	function createTFoot():HTMLElement;
	function deleteTFoot():void;
	function createCaption():HTMLElement;
	function deleteCaption():void;
	throws(DOMException) function insertRow(index:Number):HTMLElement;
	throws(DOMException) function deleteRow(index:Number):void;
}

interface HTMLTableCaptionElement extends HTMLElement {
	var align:String;
}

interface HTMLTableColElement extends HTMLElement {
	var align:String;
	var ch:String;
	var chOff:String;
	var span:Number;
	var vAlign:String;
	var width:String;
}

interface HTMLTableSectionElement extends HTMLElement {
	var align:String;
	var ch:String;
	var chOff:String;
	var vAlign:String;
	const rows:HTMLCollection;
	throws(DOMException) function insertRow(index:Number):HTMLElement;
	throws(DOMException) function deleteRow(index:Number):void;
}

interface HTMLTableRowElement extends HTMLElement {
	const rowIndex:Number;
	const sectionRowIndex:Number;
	const cells:HTMLCollection;
	var align:String;
	var bgColor:String;
	var ch:String;
	var chOff:String;
	var vAlign:String;
	throws(DOMException) function insertCell(index:Number):HTMLElement;
	throws(DOMException) function deleteCell(index:Number):void;
}

interface HTMLTableCellElement extends HTMLElement {
	const cellIndex:Number;
	var abbr:String;
	var align:String;
	var axis:String;
	var bgColor:String;
	var ch:String;
	var chOff:String;
	var colSpan:Number;
	var headers:String;
	var height:String;
	var noWrap:Boolean;
	var rowSpan:Number;
	var scope:String;
	var vAlign:String;
	var width:String;
}

interface HTMLFrameSetElement extends HTMLElement {
	var cols:String;
	var rows:String;
}

interface HTMLFrameElement extends HTMLElement {
	var frameBorder:String;
	var longDesc:String;
	var marginHeight:String;
	var marginWidth:String;
	var name:String;
	var noResize:Boolean;
	var scrolling:String;
	var src:String;
	const contentDocument:Document;
}

interface HTMLIFrameElement extends HTMLElement {
	var align:String;
	var frameBorder:String;
	var height:String;
	var longDesc:String;
	var marginHeight:String;
	var marginWidth:String;
	var name:String;
	var scrolling:String;
	var src:String;
	var width:String;
	const contentDocument:Document;
}

