<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of RssToCoop.
# Copyright (c) 2006 Pierre Rouarch and contributors. All rights
# reserved. 
#
# See original tool running at http://www.seo-search.net/rsstoccop/
# See last version of this software running at http://www.seo-search.net/rsstocoopmirror/
# Download last version at http://www.seo-search.net/rsstocoopdev/
#
# RssToCoop is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# RssToCoop is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with RssToCoop; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

//// functions and classes 

  function _GetParam($Name, $Default = "") {
    if ( isset($_GET[$Name]) )
      return $_GET[$Name];
    else if ( isset($_POST[$Name]) )
      return $_POST[$Name];
    else
      return $Default;
  }


function cleanText($intext) {
  $intext = str_replace("[","\[",$intext);
 $intext = str_replace("]","\]",$intext);
  return htmlspecialchars($intext); 
}



/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

class xml {
	var $parser;

	function parse($xmlstring){
		$this->parser = xml_parser_create();
		xml_set_object($this->parser, $this);
		xml_parser_set_option($this->parser, XML_OPTION_CASE_FOLDING, false);
		xml_set_element_handler($this->parser, "tag_open", "tag_close");
		xml_set_character_data_handler($this->parser, "cdata");

		// Initialization
        $this->node_stack = array();
        $this->tag_open(null, "root", array());

        xml_parse($this->parser, $xmlstring);
        xml_parser_free($this->parser);

        $rnode = array_pop($this->node_stack);
 
        return($rnode);
	}

	function tag_open($parser, $tag, $attributes){
        // create a new node
        $node = array();
        $node["_NAME"]      = $tag;
        foreach ($attributes as $key => $value) {
            $node[$key] = $value;
        }
        $node["_DATA"]      = "";
        $node["_ELEMENTS"]  = array();

        // add a new node at the end of the stack
        array_push($this->node_stack, $node);		
	}

	function cdata($parser, $cdata){
		// add data in the last node
        $lastnode = count($this->node_stack);
        $this->node_stack[$lastnode-1]["_DATA"] .= $cdata;
	}

	function tag_close($parser, $tag){

        $node = array_pop($this->node_stack);
        $node["_DATA"] = trim($node["_DATA"]);

        $lastnode = count($this->node_stack);
        array_push($this->node_stack[$lastnode-1]["_ELEMENTS"], $node);
	}
} // end of class xml





///////////////////////////////////////////////////////////////////////////////
///////////////// Beginning  ///////////////////////////////
///////////////////////////////////////////////////////////////////////////////

  $rssurl = _GetParam("rssurl");
  $resultSpec_count = 0;
 

  if (substr(strtolower($rssurl),0,7) <> "http://")
    die ("<b>Error:</b> RSS  URL must begin with http://<br>Press the Back button.<br>");

  if (strtolower($rssurl) == "http://")
    die ("<b>Error:</b> No RSS URL submitted. Press the Back button.<br>");

// Read the file
  $count=0;
  $fp = @fopen($rssurl, "r");
  while ((!@feof ($fp)) and ($count<10000)) {
		$data .= @fgets($fp, 4096);
        $count++;
		}
  @fclose ($fp);

	

  $initPos = strpos($data, "<channel>"); // Saut de l'entte

 //parse data
 
 $xml_parser = new xml();
 $data = substr($data, $initPos);
 $root_node = $xml_parser->parse($data);
 $channel    = array_shift($root_node["_ELEMENTS"]);

if ($channel<>"") {

$show_channel="<br/>Channel:<br/>";

// nameb the new xml file
$cooppath=$rssurl;
$cooppath=str_replace("http://","",$cooppath);
$cooppath=str_replace(".xml","",$cooppath);
$cooppath=str_replace("/","-",$cooppath);
$cooppath=str_replace("?","-",$cooppath);
$cooppath=str_replace("=","-",$cooppath);
$cooppath="googlecoop/googlecoop-".$cooppath.".xml";

$file= fopen("$cooppath", "w");

 $_xml ="<Results>\r\n";   // first tag 
  
//Read data from teh RSS file 

////// get channel data  /////////////////////////////////////////////////////////

 foreach ($channel["_ELEMENTS"] as $channel_element) {


	if($channel_element[_NAME]=="title") $channel_title=$channel_element[_DATA];
	if($channel_element[_NAME]=="link") $channel_link = $channel_element[_DATA];
	if($channel_element[_NAME]=="description") $channel_description=$channel_element[_DATA];

    	 }  /// For each Channel mais il n'y en a qu'un


if (($channel_title <>'') and ($channel_link <> '')) {

		$query_title=$channel_title;
        $channel_title=cleanText($channel_title);
		$channel_link=cleanText($channel_link);
		$channel_description=cleanText($channel_description);


	//	save in the  xml coop file
		 $resultSpec_count++ ;
		$_xml.="<ResultSpec id=\"$resultSpec_count - $channel_title\">\r\n";
       	$_xml.="<Query>$channel_title</Query>\r\n";
    $_xml.=" <Response>\r\n";
      	$_xml.="<Output name=\"title\">$channel_title</Output>\r\n";   
      	$_xml.="<Output name=\"more_url\">$channel_link</Output>\r\n";
        $_xml.="<Output name=\"text1\">$channel_description ...</Output>\r\n";
     	$_xml.="</Response>\r\n";
    	$_xml.="</ResultSpec> \r\n"; 



		// remove punctuation characters to create additional Queries
		 $query_title = str_replace(",","",$query_title);
		 $query_title = str_replace("?","",$query_title);
 		 $query_title = str_replace("!","",$query_title);
		 $query_title = str_replace(":","",$query_title);
		 $query_title = str_replace(";","",$query_title);
		 $query_title = str_replace(".","",$query_title);
  		 $query_title = str_replace("#","",$query_title);

				
		$explode_query_title= explode(" ",$query_title);

		foreach ($explode_query_title as $one_query_title) {
        if ((strlen($one_query_title)>2) and ($one_query_title<>$channel_title)){
			 $resultSpec_count++ ;
			$one_query_title=cleanText($one_query_title);

		$_xml.="<ResultSpec id=\"$resultSpec_count - $channel_title\">\r\n";
	$_xml.="<Query>$one_query_title</Query>\r\n";
    $_xml.=" <Response>\r\n";
      	$_xml.="<Output name=\"title\">$channel_title</Output>\r\n";   // Changed mysite.xcom for your own domain
      	$_xml.="<Output name=\"more_url\">$channel_link</Output>\r\n";
        $_xml.="<Output name=\"text1\">$channel_description ...</Output>\r\n";
     	$_xml.="</Response>\r\n";
    	$_xml.="</ResultSpec> \r\n"; 
			}
         }  /// for each

///
		$show_channel="<br/>Channel:<br/>".$channel_title."<br/><br/>";				
		}  /// si pas vide 





/////////////////////////////////////////////////////////////////////////
////////// get Item  data  
 //////////////////////////////////////////////////////
$nbnews=1000;  // you can change this value 
$ncount=0;
$news="Items:<br/>";

$item_title  = '';
$item_link = '';
$item_description = '';     


 foreach ($channel["_ELEMENTS"] as $item) { 

	if (($item[_NAME]=="item") and ($ncount < $nbnews) ) {
				
		foreach ($item["_ELEMENTS"] as $tag) {

            
			 if($tag["_NAME"]=="title") $item_title=$tag[_DATA];
			 if($tag["_NAME"]=="link") $item_link=$tag[_DATA];
   		  	 if($tag["_NAME"]=="description") $item_description=$tag[_DATA];

  			} // for each  tag
       
			 if (($item_title <>'') and ($item_link <> '') and (item_description<>'') ) {
				$query_title=$item_title;
                $item_title=cleanText($item_title);
				$item_link=cleanText($item_link);
				$item_description=cleanText($item_description);


	//	save in  xml coop
		 $resultSpec_count++ ;
		$_xml.="<ResultSpec id=\"$resultSpec_count - $item_title\">\r\n";
       	$_xml.="<Query>$item_title</Query>\r\n";
    $_xml.=" <Response>\r\n";
      	$_xml.="<Output name=\"title\">$item_title</Output>\r\n";   
      	$_xml.="<Output name=\"more_url\">$item_link</Output>\r\n";
        $_xml.="<Output name=\"text1\">$item_description ...</Output>\r\n";
     	$_xml.="</Response>\r\n";
    	$_xml.="</ResultSpec> \r\n"; 



		// remove punctuation from  $query_title to create queries
		 $query_title = str_replace(",","",$query_title);
		 $query_title = str_replace("?","",$query_title);
 		 $query_title = str_replace("!","",$query_title);
		 $query_title = str_replace(":","",$query_title);
		 $query_title = str_replace(";","",$query_title);
		 $query_title = str_replace(".","",$query_title);
  		 $query_title = str_replace("#","",$query_title);

				
		$explode_query_title= explode(" ",$query_title);

		foreach ($explode_query_title as $one_query_title) {
        if ((strlen($one_query_title)>2) and ($one_query_title<>$channel_title) ) {
			 $resultSpec_count++ ;
			$one_query_title=cleanText($one_query_title);

		$_xml.="<ResultSpec id=\"$resultSpec_count - $item_title\">\r\n";
	$_xml.="<Query>$one_query_title</Query>\r\n";
    $_xml.=" <Response>\r\n";
      	$_xml.="<Output name=\"title\">$item_title</Output>\r\n";   
      	$_xml.="<Output name=\"more_url\">$item_link</Output>\r\n";
        $_xml.="<Output name=\"text1\">$item_description ...</Output>\r\n";
     	$_xml.="</Response>\r\n";
    	$_xml.="</ResultSpec> \r\n"; 
			}
         }  /// for each


				$news.=" ".$item_title."<br/>";


				}        // if ok to save 


		    $ncount++;
				

 		}  ///  item
	} // for each channel

//////////////


 $_xml .="</Results>\r\n";


fwrite($file, $_xml);

 fclose($file);



} // end if  channel not empty


?>
<html>
<head>
<title>Create Google Co-op XML file  from  <?php echo $channel_title ?> </title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta name="description" content="Create Google Co-op XML file  from  <?php echo $channel_title ?>">
<meta name="keywords" content="RSS, Googgle Co-op, Google coop, Google, Co-op, coop, googlecoop, subscribed links, subscribed, link, xml, file, converter, <?php echo $channel_title ?>">
</head>
<body>

<Table  border="0" align="center" width="908" cellspacing="0" cellpadding="0">
<TR valign="top" >
<TD valign="top" colspan="2"> 
<?php include("includes/header.php"); ?>
</td>
</tr>

<tr>
<td width='50%' valign='top'>
<?php
if ($show_channel<>"") {
?>
<h3>Your RSS : </h3>
<a href="<?php echo $rssurl; ?>"><b><?php echo $rssurl; ?></b></a>
<br>
<br>
<h3>Your Google Co-op Subscribed links XML file: </h3>
      <a href="<?php echo $cooppath ?>"><b>Click to view your Google Co-op XML file</b></a><br/>
      &nbsp;then save it and upload it on your web site.*<br/>
	  <p>Next, you need to submit it to the <br/>
<a href="http://www.google.com/coop/manage/subscribedlinks"><b>Google Co-op Subscribed links management page</b></a>.
<br/>
<br/>
	  <i>*We do not store Co-op files for the moment. </i>
<br/>
<br/>
<h3>Your Info: </h3>
<?php 
echo $show_channel;
echo $news;
}
else {
?>
      <h3>Sorry we do not find info in your feed in order to create a Google Co-op 
        XML file : </h3>
<?php echo $rssurl; ?>
<br>

<?php
}
?>
<br/>

<?php

// Change thie profile url to your own one

?>

<br>
      (my Google Co-op profile : <a href="http://www.google.com/coop/profile?user=007298144610813589956">http://www.google.com/coop/profile?user=007298144610813589956</a>) <br/>
    </TD>
<td valign='top'>
</td>
</tr>

<tr>
<td colspan="2">
<?php include("includes/footer.php") ?>
</td>
</tr>
 </Table>


</body>
</html>