
/*FILEHEAD(/in/jpack_begin.js)SIZE(4878)TIME(1188383718500)*/
HOST = location.href.split("?")[0].replace(/(\/\/[^\/]*)\/.*$/, "$1");
HOST_PATH = location.href.split("?")[0].replace(/\/[^\/]*$/, "") + "/";
CWD = location.href.split("?")[0].replace(/^(.*\/)[^\/]*$/, "$1") + "/";
PACKAGED = true;
DEBUG = true;
DEBUG_TYPE = "Memory";
DEBUG_FILTER = "!teleport";
WARNINGS = false;

IS_OPERA = navigator.userAgent.toLowerCase().indexOf("opera") != -1;

IS_KONQUEROR = navigator.userAgent.toLowerCase().indexOf("konqueror") != -1;
IS_SAFARI = !IS_OPERA && ((navigator.vendor && navigator.vendor.match(/Apple/) ? true : false) || navigator.userAgent.toLowerCase().indexOf("safari") != -1 || IS_KONQUEROR);
IS_SAFARI_OLD = false;
if(IS_SAFARI){
	var matches = navigator.userAgent.match(/AppleWebKit\/(\d+)/);
	if(matches) IS_SAFARI_OLD = parseInt(matches[1]) < 420;
}

IS_GECKO = !IS_OPERA && !IS_SAFARI && navigator.userAgent.toLowerCase().indexOf("gecko") != -1;
IS_IE = document.all && !IS_OPERA && !IS_SAFARI ? true : false;
IS_IE50 = IS_IE && navigator.userAgent.toLowerCase().indexOf("5.0") != -1;
IS_IE55 = IS_IE && navigator.userAgent.toLowerCase().indexOf("5.5") != -1;
IS_IE6 = IS_IE && navigator.userAgent.toLowerCase().indexOf("6.") != -1;
IS_IE7 = IS_IE && navigator.userAgent.toLowerCase().indexOf("7.") != -1;;

//temp
MAX_JAV_RETRIES = IS_OPERA ? 0 : 3;

try{HAS_DESKRUN = window.external && window.external.shell && window.external.shell.version && window.external.shell.runtime == 2;}catch(e){HAS_DESKRUN = false;}
try{HAS_WEBRUN  = !HAS_DESKRUN && jdshell.runtime==1;}catch(e){HAS_WEBRUN = false;}

TAGNAME = IS_IE ? "baseName" : "localName";

//mozilla root detection
//try{ISROOT = !window.opener || !window.opener.Kernel}catch(e){ISROOT = true}
ISROOT = true;

function include(sourceFile, doBase){
	setStatus("including js file: " + sourceFile);
	
	//Safari Special Case
	/*if(IS_SAFARI){
		document.write("<script src='" + (doBase ? BASEPATH + sourceFile : sourceFile) + "' defer='true'></script>");
	}
	//Other browsers
	else{*/
		var head = $("head")[0];
		var elScript = document.createElement("script");
		elScript.defer = true;
		elScript.src = doBase ? BASEPATH + sourceFile : sourceFile;
		head.appendChild(elScript);
	//}
}

if(IS_OPERA){
	var $ = function(tag, doc, prefix, force){
		// || doc && (doc.nodeType == 9 ? doc : doc.ownerDocument) != document
		if(!prefix) 
			return (doc || document).getElementsByTagName(tag);

		return (doc || document).getElementsByTagName(prefix + ":" + tag);
	}
}
else
	var $ = function(tag, doc, prefix, force){
		// || IS_SAFARI
		return (doc || document).getElementsByTagName((prefix && (force || IS_GECKO) ? prefix + ":" : "") + tag);
	}

var $j = function(xmlNode, tag){
	if(IS_IE){
		if(xmlNode.style)
			return xmlNode.getElementsByTagName(tag)
		else{
			xmlNode.ownerDocument.setProperty("SelectionNamespaces", "xmlns:j='http://www.javeline.net/j'");
			return xmlNode.selectNodes(".//" + tag + "|.//j:" + tag)
		}
	}
	else
		return xmlNode.getElementsByTagNameNS("http://www.javeline.net/j", tag);
}

function setStatus(str){
	if(!DEBUG) return;
	
	if(false && IS_OPERA) status = str;
	//else if(HAS_DESKRUN || HAS_WEBRUN)	lp.Write("STATUS",str);
	else if(self.Kernel){
		var dt = new Date();
		var date = dt.getHours() + ":" + dt.getMinutes() + ":" + dt.getSeconds() + ":" + dt.getMilliseconds();	
		Kernel.debugMsg("[" + date + "] " + str.replace(/\n/g, "<br />").replace(/\t/g,"&nbsp;&nbsp;&nbsp;") + "<br />", "status");
	}
	else document.title = str;
}

Init = {
	queue : [],
	cond : {
		combined : []	
	},
	done : {},
	
	add : function(func, o){
		if(this.inited) func.call(o);
		else if(func) this.queue.push([func, o]);
	},
	
	addConditional : function(func, o, strObj){
		if(typeof strObj != "string"){
			if(this.checkCombined(strObj)) return func.call(o);
			this.cond.combined.push([func, o, strObj]);
		}
		else if(self[strObj]) func.call(o);
		else{
			if(!this.cond[strObj]) this.cond[strObj] = [];
			this.cond[strObj].push([func, o]);
			
			this.checkAllCombined();
		}
	},
	
	checkAllCombined : function(){
		for(var i=0;i<this.cond.combined.length;i++){
			if(!this.cond.combined[i]) continue;
			
			if(this.checkCombined(this.cond.combined[i][2])){
				this.cond.combined[i][0].call(this.cond.combined[i][1])
				this.cond.combined[i] = null;
			}
		}
	},
	
	checkCombined : function(arr){
		for(var i=0;i<arr.length;i++){
			if(!this.done[arr[i]]) return false;
		}

		return true;
	},
	
	run : function(strObj){
		this.inited = true;
		this.done[strObj] = true;
		
		this.checkAllCombined();
		
		var data = strObj ? this.cond[strObj] : this.queue;
		if(!data) return;
		for(var i=0;i<data.length;i++) data[i][0].call(data[i][1]);
	}
}
/*FILEHEAD(/in/Components/Bar.js)SIZE(901)TIME(1171287888899)*/

function Bar(pHtmlNode){
	Kernel.register(this, "Bar", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal();
	}
		
	this.__loadJML = function(x){
		var oInt = this.__getLayoutNode("Main", "container", this.oExt);
	
		this.oInt = this.oInt ? 
			Application.replaceNode(oInt, this.oInt) : 
			Application.loadSubNode(x, oInt, this);
	}
}

/*FILEHEAD(/in/Components/Browser.js)SIZE(2806)TIME(1179307594016)*/

function Browser(pHtmlNode){
	Kernel.register(this, "Browser", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	//this.focussable = true; // This object can get the focus
	this.inherit(Validation);
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.loadURL = function(src){
		try{
			this.oInt.src = src;
		}catch(e){
			this.oInt.src = "about:blank";
		}
	}
	
	this.getURL = function(){
		return this.oInt.src;
	}
	
	this.back = function(){
		this.oInt.contentWindow.history.back();
	}
	
	this.forward = function(){
		this.oInt.contentWindow.history.forward();
	}
	
	this.reload = function(){
		this.oInt.src = this.oInt.src;	
	}
	
	this.print = function(){
		this.oInt.contentWindow.print();
	}
	
	this.runCode = function(str, no_error){
		if(no_error) try{this.oInt.contentWindow.eval(str);}catch(e){}
		else this.oInt.contentWindow.eval(str);
	}
	
	/************************
	  Other Inheritance
	************************/
	this.inherit(DataBinding);
	
	/****************
		DATABINDING
	****************/
	this.mainBind = "Source";
	
	
	this.__supportedProperties = ["value", "src"];
	this.__handlePropSet = function(prop, value){
		switch(prop){
			case "src":
			case "value":
				this.loadURL(value);
			break;
		}
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		if(!parentNode) parentNode = this.pHtmlNode;
		
		//Build Main Skin
		if(false && IS_IE){
			this.oExt = parentNode.appendChild(document.createElement("DIV")).appendChild(document.createElement("iframe")).parentNode;//parentNode.appendChild(document.createElement("iframe"));//
			this.oExt.style.width = "100px";
			this.oExt.style.height = "100px";
			this.oInt = this.oExt.firstChild;
			//this.oInt = this.oExt;
			this.oInt.style.width = "100%";
			this.oInt.style.height = "100%";
		}
		else{
			this.oExt = parentNode.appendChild(document.createElement("iframe"));
			this.oExt.style.width = "100px";
			this.oExt.style.height = "100px";
			this.oInt = this.oExt;
			//this.oExt.style.border = "2px inset white";
		}
		
		//this.oInt = this.oExt.contentWindow.document.body;
		this.oExt.host = this;
		//this.oInt.host = this;
	}
	
	this.__loadJML = function(x){
	}
}

/*FILEHEAD(/in/Components/Button.js)SIZE(6074)TIME(1185389434903)*/

function Button(pHtmlNode){
	Kernel.register(this, "Button", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	this.editableParts = {"Main" : [["caption","text()"]]};
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.focussable = true; // This object can get the focus
	this.value = null;
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/

	this.setActive = 
	this.__enable = function(){
		this.__doBgSwitch(1);
	}
	
	this.setInactive = 
	this.__disable = function(){
		this.__doBgSwitch(4);
		this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Over", this.baseCSSname + "Down"]);
	}
	
	this.__doBgSwitch = function(nr){
		if(this.bgswitch && (this.bgoptions[1] >= nr || nr == 4)){
			if(nr == 4) nr = this.bgoptions[1] + 1;
			
			var strBG = this.bgoptions[0] == "vertical" ? 
				"0 -" + (parseInt(this.bgoptions[2])*(nr-1)) + "px": 
				"-" + (parseInt(this.bgoptions[2])*(nr-1)) + "px 0";

			this.__getLayoutNode("Main", "background", this.oExt).style.backgroundPosition = strBG;
		}
	}
	
	this.__setStateBehaviour = function(value){
		this.value = value || false;
		this.isBoolean = true;
		this.__setStyleClass(this.oExt, this.baseCSSname + "Bool");
		
		if(this.value){
			this.__setStyleClass(this.oExt, this.baseCSSname + "Down");
			this.__doBgSwitch(this.states["Down"]);
		}
	}
	
	this.__setNormalBehaviour = function(){
		this.value = null;
		this.isBoolean = false;
		this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Bool"]);
	}
	
	this.setValue = function(value){
		if(value === undefined) value = !this.value;
		this.value = value;
		
		if(this.value) this.__setStyleClass(this.oExt, this.baseCSSname + "Down", [this.baseCSSname + "Over"]);
		else this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Down"]);
		
		this.dispatchEvent("onclick");
	}
		
	this.setCaption = function(value){
		if(this.oCaption) this.oCaption.nodeValue = value;
	}
	
	this.setIcon = function(url){
		if(this.oIcon.tagName == "img") this.oIcon.setAttribute("src", this.iconPath + url);
		else this.oIcon.style.backgroundImage = "url(" + this.iconPath + url + ")";
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/
	
	/****************
		Init
	****************/
	this.inherit(JmlNode);
	this.inherit(BcButton);
	
	this.__setState = function(state, e, strEvent){
		if(this.disabled) return;

		this.__doBgSwitch(this.states[state]);
		this.__setStyleClass(this.oExt, (state != "Out" ? this.baseCSSname + state : ""), [(this.value ? "" : this.baseCSSname + "Down"), this.baseCSSname + "Over"]);
		this.dispatchEvent(strEvent, e);
		
		if(state != "Down") e.cancelBubble = true;
	}
	
	this.draw = function(clear, parentNode, Node, transform){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oIcon = this.__getLayoutNode("Main", "icon", this.oExt);
		this.oCaption = this.__getLayoutNode("Main", "caption", this.oExt);
	
		this.__setupEvents();	
	}
	
	this.__clickHandler = function(){
		// This handles the actual OnClick action. Return true to redraw the button.
		if(this.isBoolean){	
			this.value = !this.value;
			return true;
		}
	}
	
	this.__supportedProperties = ["icon", "value", "tooltip", "state", "color", "caption"];
	this.__handlePropSet = function(prop, value){
		if(prop == "icon") this.setIcon(value);
		else if(prop == "value") this.sValue = value;
		else if(prop == "tooltip") this.oExt.setAttribute("title", value);
		else if(prop == "state") this.__setStateBehaviour(value == 1);
		else if(prop == "color") this.oCaption.parentNode.style.color = value;
		else if(prop == "caption") this.setCaption(value);
	}
	
	this.__loadJML = function(x){
		this.setCaption(x.firstChild ? x.firstChild.nodeValue : "");
		
			this.__makeEditable("Main", this.oExt, this.jml);
		
		
		this.bgswitch = x.getAttribute("bgswitch") ? true : false;
		if(this.bgswitch){
			this.__getLayoutNode("Main", "background", this.oExt).style.backgroundImage = "url(" + this.mediaPath + x.getAttribute("bgswitch") + ")";
			this.__getLayoutNode("Main", "background", this.oExt).style.backgroundRepeat = "no-repeat";

			this.bgoptions = x.getAttribute("bgoptions") ? x.getAttribute("bgoptions").split("\|") : ["vertical", 2, 16];
		}
		
		//this.__focus();
		
		
		this.action = x.getAttribute("action");
		if(this.action && !this.form){
			var id = XMLDatabase.getInheritedAttribute(x, "connect", function(xmlNode){return xmlNode.tagName.replace(/^j\:/, "") == "Submitform" ? xmlNode.getAttribute("id") : false});
			
			if(!id) throw new Error(1004, Kernel.formErrorString(1004, this, "Button action setup", "Could not find Form element whilst trying to bind to it's Data."));
			else 
				this.form = self[id];
				
			if(!this.form || !this.form.tagName.match(/Submitform$/)) throw new Error(1005, Kernel.formErrorString(1005, this, "Textbox", "Could not find Form element whilst trying to bind to it's Data."));
			
			if(x.getAttribute("condition")) this.condition = x.getAttribute("condition");
			this.form.registerButton(this.action, this);
		}
		
		
		// this.doOptimize(false);
	}
}
/*FILEHEAD(/in/Components/Checkbox.js)SIZE(4795)TIME(1186393727279)*/

function Checkbox(pHtmlNode){
	Kernel.register(this, "Checkbox", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	this.inherit(BcButton);
	
	this.editableParts = {"Main" : [["label","text()"]]};
	
	this.inherit(DataBinding);
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.focussable = true; // This object can get the focus
	this.checked = false;
	this.inherit(Validation);
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/

	this.setValue = function(value){
		if(!this.values) return;
		this.setProperty("value", value);
	}
	
	this.getValue = function(){
		return this.XMLRoot ? this.values[this.checked ? 0 : 1] : this.value;
	}
	
	this.check = function(){
		this.setProperty("value", true);
	}
	
	this.uncheck = function(){
		this.setProperty("value", false);
	}
	
	this.setError = function(value){
		this.__setStyleClass(this.oExt, this.baseCSSname + "Error");
	}
	
	this.clearError = function(value){
		this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Error"]);
	}
	
	this.__enable = function(){
		if(this.oInt) this.oInt.disabled = false;
		this.__doBgSwitch(1);
	}
	
	this.__disable = function(){
		if(this.oInt) this.oInt.disabled = true;
		this.__doBgSwitch(4);
	}
	
	this.__doBgSwitch = function(nr){
		if(this.bgswitch && (this.bgoptions[1] >= nr || nr == 4)){
			if(nr == 4) nr = this.bgoptions[1] + 1;
			
			var strBG = this.bgoptions[0] == "vertical" ? 
				"0 -" + (parseInt(this.bgoptions[2])*(nr-1)) + "px": 
				"-" + (parseInt(this.bgoptions[2])*(nr-1)) + "px 0";

			this.__getLayoutNode("Main", "background", this.oExt).style.backgroundPosition = strBG;
		}
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/

	this.__supportedProperties = ["value"];
	this.__handlePropSet = function(prop, value){
		switch(prop){
			case "value":
				this.value = value = value.trim();
				this.checked = value.toString() == this.values[0].toString();
				if(!isNull(value) && value.toString() == this.values[0].toString()) 
					this.__setStyleClass(this.oExt, this.baseCSSname + "Checked");
				else this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Checked"]);
			break;
		}
	}

	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.__setState = function(state, e, strEvent){
		if(this.disabled) return;

		this.__doBgSwitch(this.states[state]);
		this.__setStyleClass(this.oExt, (state != "Out" ? this.baseCSSname + state : ""), [this.baseCSSname + "Down", this.baseCSSname + "Over"]);
		this.state = state; // Store the current state so we can check on it coming here again.
		
		this.dispatchEvent(strEvent, e);
		
		if(state == "Down") Kernel.cancelBubble(e, this);
		else e.cancelBubble = true;
	}
	
	this.__clickHandler = function(){
		this.checked = !this.checked;
		this.Change(this.values[(this.checked) ? 0 : 1]);
		if(this.validate) this.validate();
		return true;		
	}
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal();
		this.oInt = this.__getLayoutNode("Main", "input", this.oExt);
		
		this.__setupEvents();
	}
	
	this.__loadJML = function(x){
		//this.value = x.getAttribute("value");
		if(x.getAttribute("checked") == "true") this.check();
		if(x.firstChild){
			XMLDatabase.setNodeValue(this.__getLayoutNode("Main", "label", this.oExt), x.firstChild.nodeValue);
		}
		
			this.__makeEditable("Main", this.oExt, this.jml);
		
		this.bgswitch = x.getAttribute("bgswitch") ? true : false;
		if(this.bgswitch){
			this.__getLayoutNode("Main", "background", this.oExt).style.backgroundImage = "url(" + this.mediaPath + x.getAttribute("bgswitch") + ")";
			this.__getLayoutNode("Main", "background", this.oExt).style.backgroundRepeat = "no-repeat";

			this.bgoptions = x.getAttribute("bgoptions") ? x.getAttribute("bgoptions").split("\|") : ["vertical", 2, 16];
		}
		
		this.values = x.getAttribute("values") ? x.getAttribute("values").split("\|") : [1, 0];
	}
}

/*FILEHEAD(/in/Components/Colorpicker.js)SIZE(9830)TIME(1179307594016)*/

function Colorpicker(pHtmlNode){
	Kernel.register(this, "Colorpicker", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	this.inherit(DataBinding);
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.focussable = true; // This object can get the focus
	this.inherit(Validation);
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.setValue = function(value, type){
		//this.value = value;

		if(!type) type = "RGBHEX";
		switch(type){
			case "HSL":
				this.fill(value[0], value[1], value[2]);
			break;
			case "RGB":
				var a = this.RGBtoHLS(value[0], value[1], value[2]);
				this.fill(a[0], a[1], a[2]);
			break;
			case "RGBHEX":
				var RGB = arguments[0].match(/(..)(..)(..)/);
				var a = this.RGBtoHLS(Math.hexToDec(RGB[0]), Math.hexToDec(RGB[1]), Math.hexToDec(RGB[2]));
				this.fill(a[0], a[1], a[2]);
			break;
		}
	}
	
	this.getValue = function(type){
		return this.HSLRangeToRGB(this.cH, this.cS, this.cL);
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/
	
	this.cL = 120;
	this.cS = 239;
	this.cH = 0;
	this.cHex = "#FF0000";
	this.HSLRange = 240;
	
	this.HSLRangeToRGB = function(H, S, L){
	  return this.HSLtoRGB (H / (this.HSLRange-1), S / this.HSLRange, Math.min(L / this.HSLRange, 1))
	}
	
	this.RGBtoHLS = function(R,G,B){
		var RGBMAX = 255;
		var HLSMAX = this.HSLRange;
		var UNDEF = (HLSMAX*2/3);
	
	   /* calculate lightness */ 
	   cMax = Math.max(Math.max(R,G), B);
	   cMin = Math.min(Math.min(R,G), B);
	   L = (((cMax+cMin)*HLSMAX) + RGBMAX )/(2*RGBMAX);
	
	   if(cMax == cMin) {           /* r=g=b --> achromatic case */ 
	      S = 0;                     /* saturation */ 
	      H = UNDEF;             		/* hue */ 
	   }
	   else{                        /* chromatic case */ 
	      /* saturation */ 
	      if(L <= (HLSMAX/2)) S = ( ((cMax-cMin)*HLSMAX) + ((cMax+cMin)/2) ) / (cMax+cMin);
	      else S = (((cMax-cMin)*HLSMAX) + ((2*RGBMAX-cMax-cMin)/2)) / (2*RGBMAX-cMax-cMin);
	
	      /* hue */ 
		   Rdelta = ( ((cMax-R)*(HLSMAX/6)) + ((cMax-cMin)/2) ) / (cMax-cMin);
		   Gdelta = ( ((cMax-G)*(HLSMAX/6)) + ((cMax-cMin)/2) ) / (cMax-cMin);
		   Bdelta = ( ((cMax-B)*(HLSMAX/6)) + ((cMax-cMin)/2) ) / (cMax-cMin);
	
	      if(R == cMax) H = Bdelta - Gdelta;
	      else if(G == cMax) H = (HLSMAX/3) + Rdelta - Bdelta;
	      else H = ((2*HLSMAX)/3) + Gdelta - Rdelta;
	
	      if(H < 0) H += HLSMAX;
	      if(H > HLSMAX) H -= HLSMAX;
	   }

	   return [H,S,L];
	}
	
	this.HueToColorValue = function(Hue){
		var V;
	  
		if(Hue < 0) Hue = Hue + 1
		else if(Hue > 1) Hue = Hue - 1;
		
		if(6 * Hue < 1) V = M1 + (M2 - M1) * Hue * 6
		else if(2 * Hue < 1) V = M2
		else if(3 * Hue < 2) V = M1 + (M2 - M1) * (2/3 - Hue) * 6
		else V = M1;

		return Math.max(Math.floor(255 * V), 0);
	}
	
	this.HSLtoRGB = function(H, S, L){
		var R,  G,  B;
		
		if(S == 0) G = B = R = Math.round (255 * L);
		else{
			M2 = L <= 0.5 ? L * (1 + S) : L + S - L * S;
		
			M1 = 2 * L - M2;
			R = this.HueToColorValue(H + 1/3);
			G = this.HueToColorValue(H);
			B = this.HueToColorValue(H - 1/3);
		}

		return Math.decToHex(R) + "" + Math.decToHex(G) + "" + Math.decToHex(B);
	}
	
	this.fill = function(H, S, L){
		var Hex = this.HSLRangeToRGB(H,S,L);
		this.value = Hex;

		//RGB
		var RGB = Hex.match(/(..)(..)(..)/);
		this.tbRed.value = Math.hexToDec(RGB[1]);
		this.tbGreen.value = Math.hexToDec(RGB[2]);
		this.tbBlue.value = Math.hexToDec(RGB[3]);
		
		//HSL
		this.tbHue.value = Math.round(H);
		this.tbSatern.value = Math.round(S);
		this.tbLuminance.value = Math.round(L);
		
		//HexRGB
		this.tbHexColor.value = Hex;
		
		//Shower
		this.shower.style.backgroundColor = Hex;
	
		//Luminance
		var HSL120 = this.HSLRangeToRGB(H, S, 120);
		this.bar1.style.backgroundColor = HSL120;
		this.bgBar1.style.backgroundColor = this.HSLRangeToRGB(H, S, 240);
		this.bar2.style.backgroundColor = this.HSLRangeToRGB(H, S, 0);
		this.bgBar2.style.backgroundColor = HSL120;
	}		
	
	this.movePointer = function(){
		var cs = __ColorPicker;
		
		var ty = cs.pHolder.ty;
		if((event.clientY - ty >= 0) && (event.clientY - ty <= cs.pHolder.offsetHeight - cs.pointer.offsetHeight + 22))
			cs.pointer.style.top = event.clientY - ty;
		if(event.clientY - ty < 21) cs.pointer.style.top = 21;
		if(event.clientY - ty > cs.pHolder.offsetHeight - cs.pointer.offsetHeight + 19)
			cs.pointer.style.top = cs.pHolder.offsetHeight - cs.pointer.offsetHeight + 19;

		var y = cs.pointer.offsetTop - 22;
		cs.cL = (255-y) / 2.56 * 2.4;
		cs.fill(cs.cH, cs.cS, cs.cL);
		
		window.event.returnValue = false;
		window.event.cancelBubble = true;
	}
	
	this.setLogic = function(){
		this.pHolder.host = this;
		this.pHolder.style.zIndex = 10;
		this.pHolder.onmousedown = function(){
			__ColorPicker = this.host;
			
			this.ty = Kernel.compat.getAbsolutePosition(this)[1] - 20;
			
			this.host.movePointer();
			document.onmousemove = this.host.movePointer
			document.onmouseup = function(){this.onmousemove = function(){}}
		}
		
		this.container.host = this;
		this.container.onmousedown = function(e){
			__ColorPicker = this.host;
			
			this.active = true;
			if(event.srcElement == this){
				if(event.offsetX >= 0 && event.offsetX <= 256 && event.offsetY >= 0 && event.offsetY <= 256){
					this.host.cS = (256-event.offsetY) / 2.56 * 2.4
					this.host.cH = event.offsetX / 2.56 * 2.39
				}
				this.host.fill(this.host.cH, this.host.cS, this.host.cL);
				this.host.shower.style.backgroundColor = this.host.currentColor;
			}
			this.host.point.style.display = "none";
			
			event.cancelBubble = true;
		}
		
		this.container.onmouseup = function(e){
			this.active = false;	
			this.host.point.style.top = event.offsetY - this.host.point.offsetHeight - 2;
			this.host.point.style.left = event.offsetX - this.host.point.offsetWidth - 2;
			this.host.point.style.display = "block";
			
			this.host.Change(this.host.tbHexColor.value);
		}
		
		this.container.onmousemove = function(e){
			if(this.active){
				if(event.offsetX >= 0 && event.offsetX <= 256 && event.offsetY >= 0 && event.offsetY <= 256){
					this.host.cS = (256-event.offsetY) / 2.56 * 2.4
					this.host.cH = event.offsetX / 2.56 * 2.39
				}
				this.host.fill(this.host.cH, this.host.cS, this.host.cL);
				this.host.shower.style.backgroundColor = this.host.currentColor;
			}
		}
		
		/*this.tbHexColor.host = 
		this.tbRed.host = 
		this.tbGreen.host = 
		this.tbBlue.host = this;
		this.tbHexColor.onblur = function(){this.host.setValue("RGBHEX", this.value);}
		this.tbRed.onblur = function(){this.host.setValue("RGB", this.value, this.host.tbGreen.value, this.host.tbBlue.value);}
		this.tbGreen.onblur = function(){this.host.setValue("RGB", this.host.tbRed.value, this.value, this.host.tbBlue.value);}
		this.tbBlue.onblur = function(){this.host.setValue("RGB", this.host.tbRed.value, this.host.tbGreen.value, this.value);}
		*/
	}
	
	/**********
		Databinding
	**********/
	this.mainBind = "Color";
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(parentNode, clear){
		//Build Main Skin
		this.oExt = this.__getExternal(); 

		this.tbRed = this.__getLayoutNode("Main", "red", this.oExt);
		this.tbGreen = this.__getLayoutNode("Main", "green", this.oExt);
		this.tbBlue = this.__getLayoutNode("Main", "blue", this.oExt);
		
		this.tbHue = this.__getLayoutNode("Main", "hue", this.oExt);
		this.tbSatern = this.__getLayoutNode("Main", "satern", this.oExt);
		this.tbLuminance = this.__getLayoutNode("Main", "luminance", this.oExt);
		
		this.tbHexColor = this.__getLayoutNode("Main", "hex", this.oExt);
		this.tbHexColor.host = this;
		this.tbHexColor.onchange = function(){
			this.host.setValue(this.value, "RGBHEX");
		}
		
		this.shower = this.__getLayoutNode("Main", "shower", this.oExt);
		
		this.bar1 = this.__getLayoutNode("Main", "bar1", this.oExt);
		this.bgBar1 = this.__getLayoutNode("Main", "bgbar1", this.oExt);
		this.bar2 = this.__getLayoutNode("Main", "bar2", this.oExt);
		this.bgBar2 = this.__getLayoutNode("Main", "bgbar2", this.oExt);
		
		this.pHolder = this.__getLayoutNode("Main", "pholder", this.oExt);
		this.pointer = this.__getLayoutNode("Main", "pointer", this.oExt);
		this.container = this.__getLayoutNode("Main", "container", this.oExt);
		this.point = this.__getLayoutNode("Main", "point", this.oExt);

		var nodes = this.oExt.getElementsByTagName("input");
		for(var i=0;i<nodes.length;i++){
			nodes[i].onselectstart = function(e){if(!e) e = event;e.cancelBubble = true}
		}

		this.setLogic();
		
		this.setValue("ffffff");
		//this.fill(this.cH, this.cS, this.cL);
	}
	
	this.__loadJML = function(x){
		if(x.getAttribute("color")) this.setValue(x.getAttribute("color"));
	}
	
	this.__destroy = function(){
		this.container.host =
		this.tbRed.host = 
		this.tbGreen.host = 
		this.tbBlue.host = 
		this.tbHexColor.host = 
		this.pHolder.host = null;
	}
}

/*FILEHEAD(/in/Components/Container.js)SIZE(2706)TIME(1184254307389)*/

function Container(pHtmlNode){
	Kernel.register(this, "Container", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	this.inherit(DelayedRender);
	
	this.inherit(Validation);
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.setActive = function(){
		this.setProperty("active", true);
	}
	
	this.setInactive = function(){
		this.setProperty("active", false);
	}
	
	this.__supportedProperties = ["active"];
	this.__handlePropSet = function(prop, value){
		if(prop == "active"){
			if(isTrue(value)){
				this.render();
				
				this.__setStyleClass(this.oExt, this.baseCSSname + "Active", [this.baseCSSname + "Inactive"]);
				this.dispatchEvent("onactivate");
			}
			else{
				this.__setStyleClass(this.oExt, this.baseCSSname + "Inactive", [this.baseCSSname + "Active"]);
				this.dispatchEvent("oninactivate");
			}	
		}
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		
		this.setInactive();
	}
	
	this.__loadJML = function(x){
		//Set Form
		var y = x;
		do{
			y = y.parentNode;
		}while(!y.tagName.match(/Submitform$/) && y.parentNode && y.parentNode.nodeType != 9);
		
		if(y.tagName.match(/Submitform$/)){
			//if(!y.tagName.match(/Submitform$/)) throw new Error(1004, Kernel.formErrorString(1004, this, "Loading JML", "Could not find Form element whilst trying to bind to it's Data."));
			if(!y.getAttribute("id")) throw new Error(1005, Kernel.formErrorString(1005, this, "Loading JML", "Found Form element but the id attribute is empty or missing."));
			
			this.form = eval(y.getAttribute("id"));
			this.condition = x.getAttribute("condition") || x.getAttribute("js-condition");
			this.onlyWhenActive = x.getAttribute("active-only") == "show";
		}
		
		//parse children
		var oInt = this.__getLayoutNode("Main", "container", this.oExt) || this.oExt;
		this.oInt = this.oInt ? 
			Application.replaceNode(oInt, this.oInt) : 
			Application.loadSubNode(this.jml, oInt, this, true);
		
		if(this.condition) this.form.registerCondition(this, this.condition, x.getAttribute("js-condition") ? true : false);
	}
}
/*FILEHEAD(/in/Components/Collection.js)SIZE(695)TIME(1165459806275)*/

function Collection(pHtmlNode){
	Kernel.register(this, "Collection", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		this.oExt = pHtmlNode;
		this.oInt = pHtmlNode;
		Application.loadSubNode(this.jml, this.oInt, this);
	}
	
	this.__loadJML = function(x){}
}

/*FILEHEAD(/in/Components/Datagrid.js)SIZE(48052)TIME(1188383718500)*/

/*
<Heading caption="Contact Naam" span="2" width="18" />
<Heading width="105" />
<Heading caption="E-mail Adres" width="159" />

<Column_0 type="icon" select="." default="icoUsers.gif" />
<Column_1 select="@name" />
<Column_2 select="@email" />

<Traverse select="Person" />
<Heading name="Subject" .. />
<Name select=".@icon" type="icon" .... />
<Name select="." type="icon" .... />
<Subject select=".@icon" type="icon" .... />
<Subject select=".@icon" type="j:Textbox" .... />

type="icon|color|text|mask"
widget="j:Textbox"

selecttype = "row|cell"
*/

DgSizeServer = {
	init : function(){
		Kernel.DragMode.defineMode("dgdragsize", this);
	},
	
	start : function(host, heading){

		//EVENT - cancellable: ondragstart
		if(host.dispatchEvent("onsizeheadingstart") === false) 
			return false;//(this.host.tempsel ? select(this.host.tempsel) : false);

		host.oSplitter.className = host.oSplitterLeft.className = "dg_size_headers";
		host.oSplitter.style.display = "block";
		
		var pos = Kernel.compat.getAbsolutePosition(heading);
		host.oSplitter.style.left = (pos[0] + heading.offsetWidth - 1) +  "px";//+ (onRight ? heading.offsetWidth : 0)
		host.oSplitter.style.top = (pos[1]) + "px";

		var s = Kernel.compat.getBox(Kernel.compat.getStyle(host.oExt, "borderWidth"));
		host.oSplitter.style.height = host.oExt.offsetHeight - (s[0] + s[2]);
		var intWidth = host.oInt.clientWidth; // host.oExt.offsetWidth - (s[1] + s[3]);

		Kernel.Plane.show (host.oSplitter).style.cursor = "w-resize";

		if (!(heading === host.headings[0].html))
		{
			host.oSplitterLeft.style.left = (pos[0] - 1) +  "px";//+ (onRight ? heading.offsetWidth : 0)
			host.oSplitterLeft.style.top = (pos[1]) + "px";
			host.oSplitterLeft.style.display = "block";
			host.oSplitterLeft.style.height = host.oSplitter.style.height;
		}

		// Make sure we'll take the header's border and padding into account when sizing.		
		var padding = (parseInt(Kernel.compat.getStyle(heading, "paddingLeft")) || 0) + (parseInt(Kernel.compat.getStyle(heading, "paddingRight")) || 0);
		var border = (parseInt(Kernel.compat.getStyle(heading, "borderLeftWidth")) || 0) + (parseInt(Kernel.compat.getStyle(heading, "borderRightWidth")) || 0);
		
		// Figure out the heading index we're sizing.
		var curHeading;
		for (var i=0; i<host.headings.length; i++)
			if (heading === host.headings[i].html)
			{
				curHeading = i;
				DgSizeServer.sizeHeading = i;
				break;
			}
		
		// Make sure that we can't make the right columns disappear.
		var minRemaining = 0;	
		for (var i=curHeading+1; i<host.headings.length; i++)
			minRemaining += Math.max(parseInt(host.headings[i].xml.getAttribute("min-width")) || 0, padding+border);

		// Store relative widths - we'll keep these ratios when sizing.	
		host.rightWidth = 0;
		for (var i=curHeading+1;i<host.headings.length;i++)
			host.rightWidth += host.headings[i].width;

		host.orgSizeWidths = new Array();
		for (var i=curHeading; i<host.headings.length; i++)
			host.orgSizeWidths[i] = host.headings[i].width;
	
		this.dragdata = {
			heading : heading, 
			indicator : host.oSplitter,
			indicatorLeft : host.oSplitterLeft,
			host : host,
			minWidth : Math.max(padding+border, parseInt(host.headings[curHeading].xml.getAttribute("min-width"))||0),
			maxWidth : Math.min(intWidth - heading.offsetLeft - minRemaining, (parseInt(host.headings[curHeading].xml.getAttribute("max-width")) || 9999999))
		};
		
		DgSizeServer.isActive = true;

		Kernel.DragMode.setMode("dgdragsize");
	},
	
	/***********************
		Mouse Movements
	***********************/
	
	ontimerevent : function() {
		var dragdata = DgSizeServer .dragdata;
		dragdata.host.__updateColumnSizes(dragdata.heading.getAttribute('hid'));
		DgSizeServer.timerEvent = undefined;
	},

	onmousemove : function(e){
		if(!e) e = event;
		var dragdata = DgSizeServer .dragdata;

		// Calc the new size.
		var pos = Kernel.compat.getAbsolutePosition(dragdata.heading);
		var newSize = (e.clientX+DgSizeServer.sizeOffset) - pos[0];
		if(dragdata.indicator) dragdata.indicator.style.left = 
			pos[0] + Math.min(Math.max(newSize, dragdata.minWidth), dragdata.maxWidth) - 1;

		dragdata.host.sizeColumn(dragdata.heading.getAttribute("hid"), newSize + dragdata.host.oInt.scrollLeft, true);

		if (DgSizeServer.timerEvent) 
		{
			clearTimeout(DgSizeServer.timerEvent);
			DgSizeServer.timerEvent = undefined;
		}

		if (!DgSizeServer.timerEvent) 
			DgSizeServer.timerEvent = setTimeout(DgSizeServer.ontimerevent, 100);
	},
	
	stop : function(reset) {
		if (DgSizeServer.timerEvent) clearTimeout(DgSizeServer.timerEvent);
		DgSizeServer.timerEvent = undefined;
		DgSizeServer.sizeOffset = undefined;

		Kernel.DragMode.clear();
		Kernel.Plane.hide ().style.cursor = "default";
		
		if(!DgSizeServer.dragdata) return;
		var dragdata = DgSizeServer .dragdata;
		dragdata.indicator.style.display = "none"; // Let's hide it again.
		dragdata.indicatorLeft.style.display = "none"; // Let's hide it again.
		
		// Clear the sizing-cursor. Although, one could argue that we'd have to check the mouse position 
		// to see whether it shouldn't again be the sizing cursor if the mouse is over a splitter.
		dragdata.heading.style.cursor = "default";
		if (DgSizeServer.sizeHeading < dragdata.host.headings.length-1)
			dragdata.host.headings[DgSizeServer.sizeHeading+1].html.style.cursor = "default";
		
		if (reset) 
		{
			for (var i=DgSizeServer.sizeHeading; i<dragdata.host.headings.length; i++)
				dragdata.host.headings[i].width = dragdata.host.orgSizeWidths[i];
			dragdata.host.__updateHeadingSizes(DgSizeServer.sizeHeading);
			dragdata.host.__updateColumnSizes(DgSizeServer.sizeHeading);
		}
		
		DgSizeServer.isActive = false;
	},
	
	onmouseup : function(e){
		if(!e) e = event;
		var dragdata = DgSizeServer .dragdata;
		var pos = Kernel.compat.getAbsolutePosition(dragdata.heading);
		var newSize = (e.clientX+DgSizeServer.sizeOffset) - pos[0];
		
		DgSizeServer.stop();
		dragdata.host.sizeColumn(dragdata.heading.getAttribute("hid"), newSize + dragdata.host.oInt.scrollLeft);
		dragdata.host.__storeRelativeWidths();
	}
}
Init.add(DgSizeServer.init, DgSizeServer);

DgHeadServer = {
	init : function(){
		Kernel.DragMode.defineMode("dgdraghead", this);
	},
	
	start : function(host, heading){
		this.dragdata = {
			heading : heading, 
			indicator : host.__showDragHeading(heading, this.coordinates),
			host : host
		};

		//EVENT - cancellable: ondragstart
		if(host.dispatchEvent("ondragheadingstart") === false) return false;//(this.host.tempsel ? select(this.host.tempsel) : false);
		host.dragging = 2;

		Kernel.DragMode.setMode("dgdraghead");
	},
	
	stop : function(runEvent){
		//Reset Objects
		var dg = this.dragdata.host;

		dg.dragging = 0;
		dg.__hideDragHeading();
		dg.__setStyleClass(this.dragdata.heading, "", ["state_down"]);
		
		dg.oSplitter.style.display = "none";
		dg.oSplitterLeft.style.display = "none";
		
		Kernel.DragMode.clear();
		this.dragdata = null;
	},
	
	/***********************
		Mouse Movements
	***********************/
	
	onmousemove : function(e){
		if(!e) e = event;
		var dragdata = DgHeadServer .dragdata;
		
		//get Element at x, y
		if(dragdata.indicator) dragdata.indicator.style.top = "10000px";
		var el = document.elementFromPoint(e.clientX+document.documentElement.scrollLeft, e.clientY+document.documentElement.scrollTop);
		
		var o = el;
		while(o && !o.host && o.parentNode) o = o.parentNode;
		var host = o && o.host ? o.host : false;

		//Set Indicator
		dragdata.host.__moveDragHeading(e);
		
		//show highlighter..
		var dg = DgHeadServer.dragdata.host;
		if(host && host == DgHeadServer.dragdata.host && host.oExt != o){
			var oEl = dg.oSplitter;
			oEl.style.display = "block";
			
			var pos = Kernel.compat.getAbsolutePosition(o);
			//var dgpos = Kernel.compat.getAbsolutePosition(host.oExt);
			var toRight = (e.clientX+document.documentElement.scrollLeft - pos[0])/o.offsetWidth > 0.5
			oEl.style.left = pos[0] - 2 + (toRight ? o.offsetWidth : 0);
			oEl.style.top = pos[1] - 2;
		}
		else{
			var oEl = dg.oSplitter;
			oEl.style.display = "none";
		}
	},
	
	onmouseup : function(e){
		if(!e) e = event;
		var dragdata = DgHeadServer .dragdata;
		
		//get Element at x, y
		if(dragdata.indicator) dragdata.indicator.style.top = "10000px";
		var el = document.elementFromPoint(e.clientX+document.documentElement.scrollLeft, e.clientY+document.documentElement.scrollTop);
		
		var o = el;
		while(o && !o.host && o.parentNode) o = o.parentNode;
		var host = o && o.host ? o.host : false;

		//show highlighter..
		var dg = DgHeadServer.dragdata.host;
		if(host && host == DgHeadServer.dragdata.host && host.oExt != o){
			var pos = Kernel.compat.getAbsolutePosition(o);
			
			var toRight = (e.clientX+document.documentElement.scrollLeft - pos[0])/o.offsetWidth > 0.5
			var hid = parseInt(o.getAttribute("hid")) + (toRight ? 1 : 0);
			dg.moveColumn(parseInt(dragdata.heading.getAttribute("hid")), hid);
		}
		
		//Run Events
		DgHeadServer.stop(true);
		
		//Clear Selection
		if(Kernel.isNS){
			var selObj = window.getSelection();
			if(selObj) selObj.collapseToEnd();
		}
	}	
}
Init.add(DgHeadServer.init, DgHeadServer);

function Datagrid(pHtmlNode){
	Kernel.register(this, "Datagrid", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/

	this.focussable = true; // This object can get the focus
	this.multiselect = true; // Enable MultiSelect

	this.clearMessage = "There are no items"; // There is no spoon
	
	var colspan = 0;
	var totalWidth = 0;
	//this.htmlHeadings = [];
	this.headings = [];
	this.cssRules = [];
	
	this.dynCssClasses = [];

	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/

	this.Data = function(xmlNode, data, fieldnum){
		if(xmlNode) this.select(xmlNode);
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/

	this.showSelection = function(){
		var Q = (this.current || this.selected);
		var o = this.__getLayoutNode("Main", "body", this.oExt);
		o.scrollTop = (Q.offsetTop)-21;
	}

	/************************
		Keyboard Support
	************************/
	this.keyHandler = function(key, ctrlKey, shiftKey){
		/*if(!this.oContainer || this.dragging) return;

		if(!this.selected){
			if(o.firstChild.firstChild && o.firstChild.firstChild.firstChild)
				this.select(o.firstChild.firstChild.firstChild);
			else return;
			
			//this.selected.scrollIntoView(true);
		}
		else 
		*/	
		
		if(!this.selected || !this.value) return;	
		
		var Q = (this.current || this.selected);
		var o = this.__getLayoutNode("Main", "body", this.oExt);
		var st = o.scrollTop;
		var oh = o.offsetHeight;
		
		if(this.colSorting && sortObj && (key > 32 && key < 41)) return; //Hack
		
		if(key == 27 && DgSizeServer.isActive)
			DgSizeServer.stop(true);
		else if(key == 38){
			//UP
			//REWRITE if(shiftKey) else select(htmlNode)
			var node = this.getNextTraverseSelected(this.value, false);
			if(node) this.select(node, ctrlKey, shiftKey);
			
			if(Q.offsetTop < st+Q.offsetHeight+20 || Q.offsetTop > st + oh) o.scrollTop = (Q.offsetTop - Q.offsetHeight) - 20
				//Q.scrollIntoView(true);
		}
		else if(key == 40){
			//DOWN
			//REWRITE if(shiftKey) else select(htmlNode)
			var node = this.getNextTraverseSelected(this.value, true);
			if(node) this.select(node, ctrlKey, shiftKey);
			
			if(Q.offsetTop < st || Q.offsetTop+Q.offsetHeight >= st + oh-20) o.scrollTop = (Q.offsetTop + 2*Q.offsetHeight) - o.offsetHeight + 20;
				//Q.scrollIntoView(false);
		}
		else if(key == 33){
			//PGUP
			var p = Q, count = parseInt((oh-50) / Q.offsetHeight);
			
			for(var i=0;i<count;i++)
				if(p.previousSibling) p = p.previousSibling;
				
			this.select(p, ctrlKey, shiftKey);
			o.scrollTop = (p.offsetTop)-21;
			//Q.scrollIntoView(true);
		}
		else if(key == 34){
			//PGDN
			var p = Q, count = parseInt((oh-50) / (Q.offsetHeight));
			
			for(var i=0;i<count;i++)
				if(p.nextSibling) p = p.nextSibling;
				
			this.select(p, ctrlKey, shiftKey);
			o.scrollTop = (p.offsetTop + p.offsetHeight) - o.offsetHeight+20;
			//Q.scrollIntoView(false);
		}
		else if(key == 36){
			//HOME
			this.select(Q.parentNode.firstChild, ctrlKey, shiftKey);
			o.scrollTop = 0;
			//Q.scrollIntoView(true);
		}
		else if(key == 35){
			//END
			this.select(Q.parentNode.lastChild, ctrlKey, shiftKey);
			o.scrollTop = o.scrollHeight;
			//Q.scrollIntoView(true);
		}
		else if(key == 46){
			//DEL
			var ln = this.getSelectCount();
			var xmlNode = ln == 1 ? this.value : null;
			this.Remove(xmlNode, true);
		}
		else if(ctrlKey && key == 65){
			this.selectAll();	
			return false;
		}
		else if(key == 93){
			//CONTEXT MENU
			if(this.value && this.oncontextmenu) this.oncontextmenu(event, true);
		}
		else if(key == 13)
			this.dispatchEvent('onchoose');
		else return;

		return false;
	}
	
	/************************
				SELECT
	************************/
	
	this.__calcSelectRange = function(xmlStartNode, xmlEndNode){
		var r = [], loopNode = xmlStartNode;
		while(loopNode && loopNode != xmlEndNode.nextSibling){
			if(loopNode.nodeType == 1) r.push(loopNode);
			loopNode = loopNode.nextSibling;
		}

		if(r[r.length-1] != xmlEndNode){
			var r = [], loopNode = xmlStartNode;
			while(loopNode && loopNode != xmlEndNode.previousSibling){
				if(loopNode.nodeType == 1) r.push(loopNode);
				loopNode = loopNode.previousSibling;
			};
		}
		
		return r;
	}
	
	this.inherit(MultiSelect);
	this.inherit(Cache);
	
	/************************
			SKIN
	************************/
	
	this.__deInitNode = function(xmlNode, htmlNode){
		//Remove htmlNodes from tree
		htmlNode.parentNode.removeChild(htmlNode);
	}
	
	this.__updateNode = function(xmlNode, htmlNode){
		var dataset = this.dataset.set[htmlNode.getAttribute(XMLDatabase.htmlIdTag)];
		//Update Identity (Look)
		//this.__getLayoutNode("Item", "icon", htmlNode).style.backgroundImage = "url(" + this.iconPath + this.applyRuleSetOnNode("Icon", xmlNode) + ")";
		//this.__getLayoutNode("Item", "caption", htmlNode).nodeValue = this.applyRuleSetOnNode("Caption", xmlNode);

		var nodes = [];
		for(var j=0;j<htmlNode.childNodes.length;j++){
			if(htmlNode.childNodes[j].nodeType == 1) nodes.push(htmlNode.childNodes[j]);
		}

		//Build the Cells
		for(var i=0;i<this.headings.length;i++){
			var value = this.applyRuleSetOnNode(this.headings[i].xml.getAttribute("name"), xmlNode);
			if(dataset) dataset[i] = value;

			this.__getNewContext("Cell");
			var txtNode = this.__getLayoutNode("Cell", "caption", nodes[i]) || nodes[i];

			if(this.headings[i].xml.getAttribute("type") == "icon"){
				nodes[i].getElementsByTagName("img")[0].setAttribute("src", value ? this.iconPath + value : this.mediaPath + "spacer.gif");
			}
			else if(!value) XMLDatabase.setNodeValue(txtNode, " ");
			else XMLDatabase.setNodeValue(txtNode, value);
		}
		
		var cssClass = this.applyRuleSetOnNode("CSS", xmlNode);
		if(cssClass || this.dynCssClasses.length){
			this.__setStyleClass(htmlNode, cssClass, this.dynCssClasses);
			if(cssClass && !this.dynCssClasses.contains(cssClass)) this.dynCssClasses.push(cssClass);
		}
	}
	
	this.__moveNode = function(xmlNode, htmlNode){
		if(!htmlNode) return;
		var oPHtmlNode = htmlNode.parentNode;
		var beforeNode = xmlNode.nextSibling ? XMLDatabase.findHTMLNode(this.getNextTraverse(xmlNode), this) : null;

		oPHtmlNode.insertBefore(htmlNode, beforeNode);
		
		//if(this.emptyMessage && !oPHtmlNode.childNodes.length) this.setEmpty(oPHtmlNode);
	}
	
	this.__setLoading = function(htmlNode, container){
		//xmlNode.setAttribute("_loaded", "potential");
		//XMLDatabase.htmlImport(this.__getLayoutNode("Loading"), container);
	}
	
	this.__removeLoading = function(htmlNode){
		//this.__getLayoutNode("Item", "container", htmlNode).innerHTML = "";
	}
	
	/************************
			DATABINDING
	************************/
	
	this.__selectDefault = function(XMLRoot){
		this.select(XMLRoot.selectSingleNode(this.ruleTraverse));
	}
	
	this.__addHeadings = function(xmlHeadings, headParent){
		// Calculate the control's inner width.
		var s = Kernel.compat.getBox(Kernel.compat.getStyle(this.oExt, "borderWidth"));
		var innerWidth = this.oExt.offsetWidth - (s[1] + s[3]);	// Now everything needs to fit in 'innerWidth' pixels.

		// Calc/retrieve heading sizes.
		var colWidths = new Array();
		var pixelsLeft = innerWidth;
		var colsLeft = xmlHeadings.length;
		for (var iHeading=0; iHeading<xmlHeadings.length; iHeading++)
		{
			var xmlHeading = xmlHeadings[iHeading];
			var xmlWidth = xmlHeading.getAttribute("width");
			if (typeof(xmlWidth) == "string" && xmlWidth.indexOf("%") != -1)
				xmlWidth = Math.round ((parseInt(xmlWidth) * innerWidth) / 100);
			else if (typeof(xmlWidth) == "string")				
				xmlWidth = parseInt(xmlWidth) || "*";

			if (typeof(xmlWidth) == "number")
			{
				// The width is beknownst to us. Do some min/max clampery, if applicable. 
				// Except for border/padding, because we don't know of those yet.
				xmlWidth = Math.min(xmlWidth, parseInt(xmlHeading.getAttribute("max-width"))||99999999);
				xmlWidth = Math.max(xmlWidth, parseInt(xmlHeading.getAttribute("min-width"))||0);
				colWidths[iHeading] = xmlWidth;
				pixelsLeft -= xmlWidth;
				colsLeft--;
			}
		}
		
		var pixelsPerColumn = Math.round(pixelsLeft/colsLeft);
		for (var iHeading=0; iHeading<xmlHeadings.length; iHeading++)
		{
			if (!colWidths[iHeading])
			{
				colsLeft--;
				colWidths[iHeading] = colsLeft?pixelsPerColumn:pixelsLeft;
				pixelsLeft-=colWidths[iHeading];
			}
		}

		// Create the HTML components, calculate the desired widths, but don't size them yet.
		for (var iHeading=0; iHeading<xmlHeadings.length; iHeading++)
		{
			var xmlHeading = xmlHeadings[iHeading];
			//Check Colspan settings
			if(--this.colspan > 0){
				this.headings.push({
					xml : xmlHeading
				});
				continue;
			}
			colspan = xmlHeading.getAttribute("span") || 1;

			//Set CSS
			var cssClass = "col" + this.uniqueId + iHeading;
			var cssRule = "width:" + (colWidths[iHeading] - this.cellBorderPadding) + "px;" + (xmlHeading.getAttribute("align") ? "text-align:" + xmlHeading.getAttribute("align") : "");
			this.cssRules.push(["." + cssClass, cssRule]);
			
			//Get Width (possibly over colspan)
			var wt = colWidths[iHeading];
			for(var q=xmlHeading,i=1;i<colspan;i++){
				if((q = q.nextSibling).nodeType != 1 && i--) continue; //for Mozilla
				wt += parseInt(q.getAttribute("width"));
			}
	
			totalWidth += wt;
			
			//Add to htmlRoot
			this.__getNewContext("HeadItem");
			var Head = this.__getLayoutNode("HeadItem");
			Head.setAttribute("class", cssClass);
	
			if(colspan) Head.setAttribute("style", "width:" + (wt) + "px;" + (xmlHeading.getAttribute("align") ? "text-align:" + xmlHeading.getAttribute("align") : ""));//hack
			var hCaption = this.__getLayoutNode("HeadItem", "caption");
	
			if(xmlHeading.getAttribute("icon")){
				hCaption.nodeValue = "";
				hCaption.parentNode.appendChild(hCaption.parentNode.ownerDocument.createElement("img")).setAttribute("src", this.iconPath + xmlHeading.getAttribute("icon"));
			}
			else hCaption.nodeValue = xmlHeading.getAttribute("caption");
	
			//Import Head XML -> HTML
			var Head = XMLDatabase.htmlImport(Head, headParent);
	
			// Query the padding and border so the css rule actually produces the correct width.
			var padding = (parseInt(Kernel.compat.getStyle(Head, "paddingLeft")) || 0) + (parseInt(Kernel.compat.getStyle(Head, "paddingRight")) || 0);
			var border = (parseInt(Kernel.compat.getStyle(Head, "borderLeftWidth")) || 0) + (parseInt(Kernel.compat.getStyle(Head, "borderRightWidth")) || 0);
			Head.style.width = Math.max(0,wt-(padding+border)) + "px";
			
			//Add to this.headings
			var hid = this.headings.push({
				xml : xmlHeading,
				html : Head,
				width : Math.max(wt,padding+border),
				colspan : colspan,
				cssClass : cssClass
			}) - 1;

			Head.host = this;
			Head.setAttribute("hid", hid);
			
			/* Moving a column */
			Head.onmousedown = function(e){
				if(!e) e = event;
				e.cancelBubble = true;
				
				if(!IS_IE && !DgHeadServer.coordinates) return; //firefox quick fix
				
				// Sizing
				if(this.host.colSizing){
					var xpos = e.layerX ? e.layerX - DgHeadServer.coordinates.srcElement.offsetLeft : e.offsetX;
					var onRight = this.offsetWidth - xpos < 6;
					var onLeft = xpos < 3;
					if(onLeft || onRight){
						DgSizeServer.sizeOffset = (onRight ? this.offsetWidth-xpos : -xpos)-3; // Fixme: where the hell does this 3 come from?
						var sizeCol = onRight ? this : this.previousSibling;
						if (sizeCol) // Make sure the user is not sizing column -1.


						{
							var xmlHead = sizeCol.host.headings[sizeCol.hid].xml;
							if ((parseInt (xmlHead.getAttribute("min-width")) || 0) != (parseInt (xmlHead.getAttribute("max-width")) || 9999999))
							{
								DgSizeServer.start(this.host, sizeCol);
							}
						}
						return;
					}

				}
				
				if(this.host.colSorting) 
					this.host.__setStyleClass(this, "state_down");
				
				//Dragging
				if(this.host.colMoving){
					this.host.dragging = 1;
					this.host.oSplitter.className = "dg_move_headers";
					DgHeadServer.coordinates = {
						srcElement : this, 
						offsetX : e.layerX ? e.layerX - this.offsetLeft : e.offsetX, 
						offsetY : e.layerY ? e.layerY - this.offsetTop : e.offsetY,
						clientX : e.clientX, 
						clientY : e.clientY
					};
				}
			}

			Head.__isSizingColumn = function(xpos) {
				var onRight = this.offsetWidth - xpos < 6;
				var onLeft = xpos < 3;
				if(onLeft || onRight)
				{
					col = onRight ? this : this.previousSibling;
					return col || -1;
				}
			}
		
			Head.__isSizeableColumn = function(sizeCol) {
				var xmlHead = sizeCol.host.headings[sizeCol.hid].xml;
				if ((parseInt (xmlHead.getAttribute("min-width")) || 0) != (parseInt (xmlHead.getAttribute("max-width")) || 9999999))
					return true;
			}

			Head.onmousemove = function(e){
				if(!IS_IE && !DgHeadServer.coordinates) return;
				if(!e) var e = event;
				
				//Sizing
				if(!this.host.colSizing) return;
				
				var xpos = e.layerX ? e.layerX - DgHeadServer.coordinates.srcElement.offsetLeft : e.offsetX;
				var sizeCol = this.__isSizingColumn(xpos)	
				if (sizeCol && sizeCol != -1) // Make sure the user is not sizing column -1.
				{
					var xmlHead = sizeCol.host.headings[sizeCol.hid].xml;
					if ((parseInt (xmlHead.getAttribute("min-width")) || 0) != (parseInt (xmlHead.getAttribute("max-width")) || 9999999))
						this.style.cursor = "w-resize";
				}
				else
					this.style.cursor = "default";
					
				if (!sizeCol)
				{
					//Dragging
					if(this.host.dragging != 1) return;//e.button != 1 || 
					if(Math.abs(DgHeadServer.coordinates.offsetX - (e.layerX ? e.layerX - DgHeadServer.coordinates.srcElement.offsetLeft : e.offsetX)) < 6 && Math.abs(DgHeadServer.coordinates.offsetY - (e.layerX ? e.layerY - DgHeadServer.coordinates.srcElement.offsetTop : e.offsetY)) < 6)
						return;
		
					DgHeadServer.start(this.host, this);
				}
			}
			
			Head.onmouseup = function(){
				this.host.dragging = 0;
				this.host.oSplitter.style.display = "none";
				this.host.__setStyleClass(this, "", ["state_down"]);
			}
			
			Head.ondragmove = 
			Head.ondragstart = function(){return false}
			
			/* Sorting a column */
			Head.onclick = function(){
				this.host.sortColumn(this.getAttribute("hid"));
			}
			
			Head.ondblclick = function(e)
			{
				if(!this.host.colSizing) return;
				
				// Autosize
				if(!e) var e = event;
				var xpos = e.layerX ? e.layerX - DgHeadServer.coordinates.srcElement.offsetLeft : e.offsetX;
				var sizeCol = this.__isSizingColumn(xpos)	
				if (sizeCol && sizeCol != -1 && this.__isSizeableColumn(sizeCol)) // Make sure the user is not sizing column -1.
				{
					// Autosize the heading
// 				sizeCol.style.width = "auto"; 
					var minWidth = 0;// sizeCol.offsetWidth;
					Kernel.setStyleRule("." + this.host.headings[sizeCol.hid].cssClass, "width", "auto");
					
					// Iterate over all the cells. This ain't not no quick.
					var nodes = this.host.oExt.lastChild.childNodes;
					for(var i=0; i<nodes.length; i++)
						minWidth = Math.max(minWidth, nodes[i].childNodes[sizeCol.hid].offsetWidth);
					this.host.sizeColumn (sizeCol.hid, minWidth);
					this.host.__storeRelativeWidths();
				}
			}
			
		} // for(iHeading)

		// Store the relative sizes for later use.
		this.__storeRelativeWidths();
	}

	this.__loaddatabinding = function(){
		document.body.appendChild(this.oExt);
		
		var headParent = this.__getLayoutNode("Main", "head", this.oExt);
		
		this.__initDragHeading();

		// Measure Cell
		this.__getNewContext("Cell");
		var newCell = XMLDatabase.htmlImport(this.__getLayoutNode("Cell"), this.oInt);
		newCell.style.display = "block";
		//newCell.style.width = "1px";
		//newCell.style.height = "1px";
		var diff = Kernel.compat.getDiff(newCell);
		newCell.parentNode.removeChild(newCell);
		this.cellBorderPadding = diff[0];
		
		//Set Up Headings
		this.__addHeadings(this.bindingRules.Heading, headParent);
		this.cssRules.push([".row" + this.uniqueId, "width:" + (totalWidth) + "px"]);

		//Add extra header for empty space....
		this.__getNewContext("HeadItem");
		this.__getLayoutNode("HeadItem", "caption").nodeValue = "";
		//this.__getLayoutNode("HeadItem").setAttribute("style", "width:" + (this.jml.getAttribute("width")-totalWidth) + "px");
		this.__getLayoutNode("HeadItem").setAttribute("class", "lastHead");
		if(IS_IE6) this.__getLayoutNode("HeadItem").setAttribute("style", "display:none");
		XMLDatabase.htmlImport(this.__getLayoutNode("HeadItem"), headParent);

		//Activate CSS Rules
		Kernel.importStylesheet(this.cssRules, window);
		this.__getLayoutNode("Main", "body", this.oExt).onscroll = new Function('var o = Kernel.lookup(' + this.uniqueId + '); var head = o.__getLayoutNode("Main", "scrollhead", o.oExt);head.scrollLeft = this.scrollLeft;');
		
		pHtmlNode.appendChild(this.oExt);
	}
	
	this.__unloaddatabinding = function(){
		var headParent = this.__getLayoutNode("Main", "head", this.oExt);
		for(var i=0;i<headParent.childNodes.length;i++){
			headParent.childNodes[i].host = null;
			headParent.childNodes[i].onmousedown = null;
			headParent.childNodes[i].__isSizingColumn = null;
			headParent.childNodes[i].__isSizeableColumn = null;
			headParent.childNodes[i].onmousemove = null;
			headParent.childNodes[i].onmouseup = null;
			headParent.childNodes[i].ondragmove = null;
			headParent.childNodes[i].ondragstart = null;
			headParent.childNodes[i].onclick = null;
			headParent.childNodes[i].ondblclick = null;
		}
		
		this.__getLayoutNode("Main", "body", this.oExt).onscroll = null;
		
		Kernel.removeNode(this.oDragHeading);
		this.oDragHeading = null;
		Kernel.removeNode(this.oSplitter);
		this.oSplitter = null;
		Kernel.removeNode(this.oSplitterLeft);
		this.oSplitterLeft = null;
		
		headParent.innerHTML = "";
		totalWidth = 0;
		this.headings = [];
	}

	this.nodes = [];
	this.dataset = {set:{},seq:[]};
	//<CSS select="@new='true'" default="classname" />
	this.__add = function(xmlNode, Lid, xmlParentNode, htmlParentNode, beforeNode){
		var dataset = [];
		
		//Build Row
		this.__getNewContext("Row");
		var Row = this.__getLayoutNode("Row");
		Row.setAttribute("id", Lid);
		Row.setAttribute("class", "row" + this.uniqueId);//"width:" + (totalWidth+40) + "px");
		Row.setAttribute("ondblclick", 'Kernel.lookup(' + this.uniqueId + ').choose()');
		Row.setAttribute("onmousedown", 'var o = Kernel.lookup(' + this.uniqueId + ');o.select(this, event.ctrlKey, event.shiftKey);');//, true;o.dragging=1;
		//Row.setAttribute("onmouseup", 'var o = Kernel.lookup(' + this.uniqueId + ');o.select(this, event.ctrlKey, event.shiftKey);o.dragging=false;');
		
		//Build the Cells
		for(var i=0;i<this.headings.length;i++){
			this.__getNewContext("Cell");
			var value = this.applyRuleSetOnNode(this.headings[i].xml.getAttribute("name"), xmlNode);
			
			//(i == this.colCount-1 ? "width=100%" : "" )
			var Cell = this.__setStyleClass(this.__getLayoutNode("Cell"), "col" + this.uniqueId + i);
			var txtNode = this.__getLayoutNode("Cell", "caption");

			if(this.headings[i].xml.getAttribute("type") == "icon"){
				txtNode.nodeValue = "";
				txtNode.parentNode.appendChild(txtNode.parentNode.ownerDocument.createElement("img")).setAttribute("src", value ? this.iconPath + value : this.mediaPath + "spacer.gif");
			}
			else if(!value) XMLDatabase.setNodeValue(txtNode, " ");
			else XMLDatabase.setNodeValue(txtNode, value);

			Row.appendChild(Cell);
			dataset.push(value);
		}
		
		var cssClass = this.applyRuleSetOnNode("CSS", xmlNode);
		if(cssClass){
			this.__setStyleClass(Row, cssClass);
			if(cssClass) this.dynCssClasses.push(cssClass);
		}

		//return XMLDatabase.htmlImport(Row, htmlParentNode || this.oInt, beforeNode);
		if(htmlParentNode) XMLDatabase.htmlImport(Row, htmlParentNode, beforeNode);
		else this.nodes.push(Row);
		
		dataset.id = Lid;
		this.dataset.set[Lid] = dataset;
		dataset.index = this.dataset.seq.push(dataset);
	}
	
	this.__fill = function(nodes){
		XMLDatabase.htmlImport(this.nodes, this.oInt);
		this.nodes.length = 0;
	}

	/************************
			DRAGDROP
	************************/
	
	this.__showDragIndicator = function(sel, e){
		var x = e.offsetX;
		var y = e.offsetY;

		this.oDrag.startX = x;
		this.oDrag.startY = y;

		document.body.appendChild(this.oDrag);
		//this.__updateNode(this.value, this.oDrag); // Solution should be found to have this on conditionally
		
		return this.oDrag;
	}
	
	this.__hideDragIndicator = function(){
		this.oDrag.style.display = "none";
	}
	
	this.__moveDragIndicator = function(e){
		this.oDrag.style.left = (e.clientX) + "px";// - this.oDrag.startX
		this.oDrag.style.top = (e.clientY+15) + "px";// - this.oDrag.startY
	}
	
	this.__initDragDrop = function(){
		if(!this.__hasLayoutNode("DragIndicator")) return;
		this.oDrag = XMLDatabase.htmlImport(this.__getLayoutNode("DragIndicator"), document.body);
		
		this.oDrag.style.zIndex = 1000000;
		this.oDrag.style.position = "absolute";
		this.oDrag.style.cursor = "default";
		this.oDrag.style.display = "none";
	}
	
	this.__dragout = 
	this.__dragover = 
	this.__dragdrop = function(){}
	
	this.inherit(DragDrop);
	
	/************************
			DRAGDROP
			headings
	************************/
	
	this.__showDragHeading = function(heading, e){
		var x = e.offsetX;
		var y = e.offsetY;

		this.oDragHeading.startX = x;
		this.oDragHeading.startY = y;
		this.oDragHeading.style.left = e.clientX;
		this.oDragHeading.style.top = e.clientY;

		
		document.body.appendChild(this.oDragHeading);
		//this.oDragHeading.getElementsByTagName("DIV")[0].innerHTML = this.selected.innerHTML;
		//this.oDragHeading.getElementsByTagName("IMG")[0].src = this.selected.parentNode.parentNode.childNodes[1].firstChild.src;
		this.oDragHeading.innerHTML = heading.innerHTML;
		
		var diff = Kernel.compat.getDiff(heading);
		this.oDragHeading.style.width = Kernel.compat.getStyle(heading, "width");
		this.oDragHeading.style.height = Kernel.compat.getStyle(heading, "height");;
		this.oDragHeading.style.padding = Kernel.compat.getStyle(heading, "padding");;
		
		return this.oDragHeading;
	}
	
	this.__hideDragHeading = function(){
		this.oDragHeading.style.display = "none";
	}
	
	this.__moveDragHeading = function(e){
		this.oDragHeading.style.left = (e.clientX - this.oDragHeading.startX) + "px";
		this.oDragHeading.style.top = (e.clientY - this.oDragHeading.startY) + "px";
	}
	
	this.__initDragHeading = function(){
		if(!this.__hasLayoutNode("DragHeading") || this.oDragHeading) return;
		this.oDragHeading = XMLDatabase.htmlImport(this.__getLayoutNode("DragHeading"), document.body);
		this.oSplitter = XMLDatabase.htmlImport(this.__getLayoutNode("Splitter"), document.body);
		this.oSplitterLeft = this.oSplitter.parentNode.appendChild(this.oSplitter.cloneNode(true));
		
		this.oDragHeading.style.zIndex = 1000000;
		this.oDragHeading.style.position = "absolute";
		this.oDragHeading.style.cursor = "default";
		this.oDragHeading.style.display = "none";
	}
	
	this.__dragout = 
	this.__dragover = 
	this.__dragdrop = function(){}
	
	this.hideColumn = function(nr){
		Kernel.setStyleRule(".col" + this.uniqueId + nr, "visibility", "hidden");
	}
	
	this.showColumn = function(){
		
	}
	
	this.moveColumn = function(from, to){
		if(from == to-1 || from == to) return;
		
		var pHeadings = this.__getLayoutNode("Main", "head", this.oExt);
		pHeadings.insertBefore(this.headings[from].html, this.headings[to] ? this.headings[to].html : pHeadings.lastChild);
		
		var min = Math.min(from, to), max = Math.max(from, to), htmlHeading = [];
		for(var i=0;i<min;i++) htmlHeading.push(this.headings[i]);

		if(min != from) this.headings[from].html.setAttribute("hid", htmlHeading.push(this.headings[from])-1);
		for(var i=min==from?min+1:min;i<max;i++)
			this.headings[i].html.setAttribute("hid", htmlHeading.push(this.headings[i])-1);
		if(min == from) this.headings[from].html.setAttribute("hid", htmlHeading.push(this.headings[from])-1);

		for(var i=max==from?max+1:max;i<this.headings.length;i++)
			this.headings[i].html.setAttribute("hid", htmlHeading.push(this.headings[i])-1);
		
		//if(this.htmlHeadings.length != htmlHeading.length) debugger;
		this.headings = htmlHeading;
		
		var nodes = this.__getLayoutNode("Main", "body", this.oExt).childNodes;
		for(var i=0;i<nodes.length;i++){
			nodes[i].insertBefore(nodes[i].childNodes[from], nodes[i].childNodes[to] || null);
		}
	}

	var sortObj = new Sort();
	this.sortAscending = true;
	this.currentSortColumn = null;
	this.sortColumn = function(nr){
		if(!this.colSorting) return;
		
		//Profiler.start(true);
		var sel = this.getSelection();
		for(var ids=[],i=0;i<sel.length;i++) ids.push(sel[i].getAttribute(XMLDatabase.xmlIdTag) + "|" + this.uniqueId);
		sel = null;
		//this.clearSelection();
		
		this.sortAscending = this.currentSortColumn == nr ? !this.sortAscending : true;
		sortObj.set({
			//method : sortCompare,
			getValue : function(item){return item[nr];},
			isAscending : this.sortAscending,
			type : "alpha"
		});
		this.dataset.seq = sortObj.apply(this.dataset.seq);

		var strHtml = this.oInt.innerHTML;
		var htmlNodes = strHtml.split("\n");
		var resultNodes = [];
		for(var i=0;i<htmlNodes.length;i++){
			htmlNodes[i].match(/id\=(\d+\|\d+\|\d+)/);
			resultNodes[RegExp.$1] = htmlNodes[i] + "\n";
		}

		//if(this.sortAscending) this.dataset.seq.invert();

		
		for(var sortNodes=[],i=0;i<this.dataset.seq.length;i++){
			if(this.dataset.seq[i])
				sortNodes.push(resultNodes[this.dataset.seq[i].id]);
		}

		this.oInt.innerHTML = sortNodes.join("");
		
		for(var i=0;i<ids.length;i++) 
			this.select(ids[i], true, null, true, true, true); 
		
		//Profiler.end();
		//alert(Profiler.totalTime);
		
		this.currentSortColumn = nr;
	}
	
	this.updateWindowSize = function(force)
	{
		// Size the header
		var fNode = Kernel.compat.getFirstElement(this.oExt);
		
		var oldWidth = fNode.offsetWidth; // Old size.
		if (oldWidth != this.oInt.clientWidth || force) 
		{
			var innerWidth = this.oInt.clientWidth; // IE only?
			fNode.style.width = innerWidth + "px";
			
			if (this.headings && this.headings.length)
			{
				// Pass 1: Calculate the minimum/maximum usage for all following columns based on border, padding and min-width attribute.
				var minWidths = new Array();
				var maxWidths = new Array();
				var minUsage = 0, maxUsage = 0, curUsage = 0;
				for (var i=0; i<this.headings.length; i++)
				{
					// User defined minimum width.
					var minWidth = parseInt(this.headings[i].xml.getAttribute("min-width"))||0;
					
					// Take the header's border and padding.
					var diff = Kernel.compat.getWidthDiff(this.headings[i].html);

					minWidths[i] = Math.max(diff, minWidth);
					maxWidths[i] = parseInt(this.headings[i].xml.getAttribute("max-width"))||999999999;

					minUsage += minWidths[i];
					maxUsage += maxWidths[i];
					curUsage += this.headings[i].width;
				}

				// If there's blank space at the end, we'll just be sizing emptyness. Which is fairly easy.
				if ((curUsage < oldWidth && innerWidth > oldWidth) ||
						(curUsage < oldWidth && innerWidth < oldWidth && innerWidth >= curUsage))
				{
					Kernel.setStyleRule(".row" + this.uniqueId, "width", (innerWidth) + "px");
					return; // Do jack.
				}

				// Clamp the size to min/border/padding and max widths.
				innerWidth = Math.min (Math.max (innerWidth, minUsage), maxUsage);

				// Store all relative widths and the total, so we can keep the ratios the same.
				var relativeTotal = 0, fixedTotal = 0;
				var oldRelativeTotal = 0;
				for (var i=0; i<this.headings.length; i++)
				{
					if (this.headings[i].relativeWidth)
					{
						oldRelativeTotal += this.headings[i].relativeWidth; // Before sizing.
						relativeTotal += this.headings[i].width;
					}
					else fixedTotal += this.headings[i].width;
				}

				// Crunch the relative columns first until they hit the minimum size. Then try the fixed columns.
				var newRelativeTotal = innerWidth - fixedTotal; // Space to divide over the relative columns.

				// Relative, first pass. We'll divide newRelativeTotal over all relative columns, with the exception of the ones that 
				// have complaints due to min or maximum widths. We'll remove these from the equasion.

				var usedWidth = 0;
				var relativeLeft = newRelativeTotal;
				var oldRelativeLeft = oldRelativeTotal;
				
				for (var i=0; i<this.headings.length; i++)
					this.headings[i].clamped = undefined;
					
				var nRelColsLeft = 0;
				for (var i=0; i<this.headings.length; i++)
					if (this.headings[i].relativeWidth) nRelColsLeft++;
					
				var nObjections;
				do
				{
					nObjections = 0;
					var passRelLeft = relativeLeft;
					var passOldRelLeft = oldRelativeLeft;
					for (var i=0; i<this.headings.length; i++)
					{
						if (this.headings[i].relativeWidth && !this.headings[i].clamped)
						{
							var freeSize = (nRelColsLeft == 1) ? (newRelativeTotal - usedWidth) : Math.round((this.headings[i].relativeWidth * passRelLeft) / passOldRelLeft);
							var clampedSize = Math.max(freeSize, minWidths[i]);
							clampedSize = Math.min(clampedSize, maxWidths[i]);
							if (freeSize != clampedSize)
							{
								// Objection, your honor!
								relativeLeft -= clampedSize;
								oldRelativeLeft -= this.headings[i].relativeWidth;
								this.headings[i].width = clampedSize;
								usedWidth += clampedSize;
								this.headings[i].clamped = true;
								nRelColsLeft--;
								nObjections++;
							}
						}
					}
				} while (nObjections);
				
				// Now process all the leftover relative columns that didn't have any objection.
				for (var i=0; i<this.headings.length; i++)
				{
					if (this.headings[i].relativeWidth && !this.headings[i].clamped)
					{
							var freeSize = (nRelColsLeft == 1) ? (newRelativeTotal - usedWidth) : Math.round((this.headings[i].relativeWidth * passRelLeft) / passOldRelLeft);
							this.headings[i].width = freeSize;
							usedWidth += freeSize;
							nRelColsLeft--;
					}
				}
				
				// Adjust fixed width columns.
				var pixelsShort = (usedWidth + fixedTotal) - innerWidth;
				if (pixelsShort > 0)
				{
					// We haven't the size. No, sir.
					for (var i=this.headings.length-1; i>=0; i--)
					{
						if (!this.headings[i].relativeWidth)
						{
							var newWidth = Math.max(this.headings[i].width-pixelsShort, minWidths[i]);
							pixelsShort -= (this.headings[i].width-newWidth);
							this.headings[i].width = newWidth;
							if (pixelsShort == 0)
								break; // Done.	
						}
					}
				}
					
				this.__updateHeadingSizes(0);
				this.innerWidth = innerWidth;
				this.__updateColumnSizes(0);
			}
		}
		
		this.dispatchEvent("onafterresize");
	}
	
	this.__updateHeadingSizes = function(nr)
	{
		for (var i=nr; i<this.headings.length; i++)
		{
			var diff = Kernel.compat.getWidthDiff(this.headings[i].html);
			this.headings[i].html.style.width = Math.max (0,(this.headings[i].width-diff)) + "px";
		}
	}

	this.__storeRelativeWidths = function()
	{
		for (var i=0; i<this.headings.length; i++)
		{
			var xmlWidth = this.headings[i].xml.getAttribute("width");
			if (typeof(xmlWidth) == "string" && xmlWidth.indexOf("%") == -1)
				xmlWidth = parseInt(xmlWidth) || "*"; 
			if (typeof(xmlWidth) != "number") // Then it's relative.
				this.headings[i].relativeWidth = this.headings[i].width;
		}
	}

	this.__updateColumnSizes = function(nr)
	{
		// Pass 2: Apply the new sizes.
		for (var i=nr; i<this.headings.length; i++)
			Kernel.setStyleRule("." + this.headings[i].cssClass, "width", (this.headings[i].width-(this.cellBorderPadding)) + "px");
		Kernel.setStyleRule(".row" + this.uniqueId, "width", (this.innerWidth) + "px");
	}
	
	// This function updates all of the headings that need resizing.
	this.sizeColumn = function(nr, size, preview) 
	{
		// Calculate inner width of the datagrid control.
		var s = Kernel.compat.getBox(Kernel.compat.getStyle(this.oExt, "borderWidth"));
		this.innerWidth = this.oInt.clientWidth; //this.oExt.offsetWidth - (s[1] + s[3]);	// Now everything needs to fit in 'innerWidth' pixels.

		// Pass 1: Calculate the minimum usage for all following columns based on border, padding and min-width attribute.
		var minWidths = new Array();
		var minUsage = 0;
		for (var i=nr; i<this.headings.length; i++)
		{
			// User defined minimum width.
			var minWidth = parseInt(this.headings[i].xml.getAttribute("min-width"))||0;
			
			// Take the header's border and padding.
			var diff = Kernel.compat.getWidthDiff(this.headings[i].html);
			minWidths[i] = Math.max(diff, minWidth);
			if (i>nr) minUsage += minWidths[i];
		}

		// Clamp the size to min/border/padding and max widths.
		size = Math.max(minWidths[nr], size);
		size = Math.min(size, parseInt(this.headings[nr].xml.getAttribute("max-width"))||99999999);

		var leftWidth = 0, rightWidth = 0;
		for (var i=0;i<nr;i++)
			leftWidth += this.headings[i].width;
		for (var i=nr+1;i<this.headings.length;i++)
			rightWidth += this.headings[i].width;
		size = Math.min(size, this.innerWidth-(leftWidth+minUsage)); // Clamp to the right columns' minimum values as well.			
			
		if (size > this.headings[nr].width && leftWidth+size+rightWidth <= this.innerWidth)
			this.headings[nr].width = size; // Nothing fancy to do.
		else
		{
			// Store all relative widths and the total, so we can keep the ratios the same.
			var relativeRightTotal = 0;
			var oldRelativeRightTotal = 0;
			for (var i=nr+1; i<this.headings.length; i++)
			{
				if (this.headings[i].relativeWidth)
				{
					oldRelativeRightTotal += this.headings[i].relativeWidth; // Before sizing.
					relativeRightTotal += this.headings[i].width;
				}
			}
			
			if (size != this.headings[nr].width)
			{
				// Sizing right. Crunch the relative columns first until they hit the minimum size. Then try the fixed columns.
				var spaceAvailable = this.innerWidth - (leftWidth+size); // This is what we have divide the pixels over.
				if (size < this.headings[nr].width)
					spaceAvailable = rightWidth + (this.headings[nr].width-size);
					
				var fixedRightTotal = rightWidth - relativeRightTotal; // This is what we had for fixed columns.
				var newRelativeTotal = spaceAvailable - fixedRightTotal; // Space to divide over the relative columns.

				var relativeUsed = 0;
				for (var i=nr+1;i<this.headings.length;i++)
				{
					if (this.headings[i].relativeWidth)
					{
						// Fixme: this could overflow by one pixel due to roundoff errors.
						var colSize = Math.round((this.headings[i].relativeWidth * newRelativeTotal)/oldRelativeRightTotal);
						colSize = Math.max(colSize, minWidths[i]);
						colSize = Math.min(colSize, parseInt(this.headings[i].xml.getAttribute("max-width"))||99999999);
						relativeUsed += colSize;
						rightWidth += (colSize - this.headings[i].width); // Adjust rightWidth.
						this.headings[i].width = colSize;
					}
				}
				
				// Adjust fixed width columns.
				var pixelsShort = rightWidth-spaceAvailable;
				if (pixelsShort > 0)
				{
					for (var i=this.headings.length-1; i>nr; i--)
					{
						var newWidth = Math.max(this.headings[i].width-pixelsShort, minWidths[i]);
						pixelsShort -= (this.headings[i].width-newWidth);
						this.headings[i].width = newWidth;
						if (pixelsShort == 0)
							break; // Done.				
					}
				}
			}
			
			this.headings[nr].width = size; // Don't forget to set the sizing column.
		}

		// Pass 2: Apply the new sizes.
		this.__updateHeadingSizes(nr);
		if (!preview)
			this.__updateColumnSizes (nr);			
	}
	
	/************************
	  Other Inheritance
	************************/
	
	this.inherit(Presentation);
	this.inherit(DataBinding);
	
	/************************
				INIT
	************************/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oInt = this.__getLayoutNode("Main", "body", this.oExt);

		LayoutServer.setRules(this.oInt, "dg" + this.uniqueId, "Kernel.lookup(" + this.uniqueId + ").updateWindowSize();setTimeout(function(){Kernel.lookup(" + this.uniqueId + ").updateWindowSize();});", true);

		var updScroll = this;
		setTimeout(function(){updScroll.updateWindowSize(true);}); 
		this.addEventListener("onafterload", function(){
			// Once for scrollbar due to data changes. This gets processed when everything has been redrawn. Could move this to __fill or so.
			setTimeout(function(){updScroll.updateWindowSize(true);}); 	
		});
		this.oExt.onclick = function(){this.host.focus()}
		Application.loadSubNode(this.jml, null, this);
	}
	
	this.__loadJML = function(x){
		if(x.getAttribute("message")) this.clearMessage = x.getAttribute("message");
		this.colSizing = !isFalse(x.getAttribute("colsizing")) && IS_IE; //temp fix
		this.colMoving = !isFalse(x.getAttribute("colmoving")) && IS_IE;//temp fix
		this.colSorting = !isFalse(x.getAttribute("colsorting")) && IS_IE;//temp fix
	}
	
	this.__destroy = function(){
		Kernel.removeNode(this.oDrag);
		this.oDrag = null;
		this.oExt.onclick = null;
		this.oInt.onresize = null;
		
		LayoutServer.removeRule(this.oInt, "dg" + this.uniqueId);
		LayoutServer.activateRules(this.oInt);
	}
	
	this.counter = 0;
}
/*FILEHEAD(/in/Components/Datastore.js)SIZE(1425)TIME(1181922744090)*/

function Datastore(){
	Kernel.register(this, "Datastore", NOGUI_NODE);

	/************************
			  Inheritance
	************************/
	this.inherit(DataBinding);
	this.smartBinding = true;

	/*********************************************************************
			       PUBLIC METHODS
	*********************************************************************/
	
	this.select = function(xpath){
		var obj = typeof xpath == "string" ? this.XMLRoot.selectSingleNode(xpath) : xpath;
		this.setConnections(obj, "select");
		this.value = obj;
	}

	this.__load = function(){
		this.value = this.sXpath ? this.XMLRoot.selectSingleNode(this.sXpath) : this.XMLRoot;
		this.setConnections(this.value, "select");
	}

	this.__xmlUpdate= function(){
		
	}
	this.clear = function(){}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);

	this.draw = function(){}
	this.__loadJML = function(x){
		if(x.getAttribute("xpath")) this.sXpath = x.getAttribute("xpath");

		if(x.getAttribute("load")){
			var sNode = Kernel.getObject("XMLDOM", "<BindClass><Data file='" + x.getAttribute("load") + "' /><Bindings /></BindClass>").documentElement;
			var dbnode = sNode.selectSingleNode("Bindings");

			Application.addToSbStack(this.uniqueId, sNode);
		}
		
		Application.loadSubNode(x, null, this);
	}
}

/*FILEHEAD(/in/Components/Dropdown.js)SIZE(11030)TIME(1186078399114)*/

function Dropdown(pHtmlNode){
	Kernel.register(this, "Dropdown", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/

	this.animType = 1;
	this.animSteps = 5;
	this.animSpeed = 20;
	this.itemSelectEvent = "onmouseup";
	
	this.hasCheckbox = false;
	this.dragdrop = false;
	this.reselectable = true;
	this.focussable = true;

	/************************
	  Other Inheritance
	************************/
	this.inherit(BcList);

	this.autoselect = false;
	this.multiselect = false;
	
	this.setLabel = function(value){
		this.oLabel.innerHTML = value || this.initialMsg || "";
		
		this.__setStyleClass(this.oExt, value ? "" : this.baseCSSname + "Initial", [!value ? "" : this.baseCSSname + "Initial"]);
	}

	this.addEventListener("onafterselect", function(e){
		if(IS_IE) e = event;
		
		this.slideUp();
		if(!this.isOpen) this.__setStyleClass(this.oExt, "", [this.baseCSSname + "over"]);
		
		this.setLabel(this.applyRuleSetOnNode("Caption", this.value))
		//return selBindClass.applyRuleSetOnNode(selBindClass.mainBind, selBindClass.XMLRoot, null, true);
		
		this.__updateOtherBindings();
		
		if(this.hasFeature(__VALIDATION__) && this.form){
			this.validate();
		}
	});
	
	this.addEventListener("onafterdeselect", function(){
		this.setLabel("");
	});
	
	function setMaxCount(){
		this.setMaxItems(this.getTraverseNodes().length);
		if(this.isOpen == 2) this.slideDown();
	}
	this.addEventListener("onafterload", setMaxCount);
	this.addEventListener("onxmlupdate", function(){
		setMaxCount.call(this);
		this.setLabel(this.applyRuleSetOnNode("Caption", this.value));
	});
	
	/*this.addEventListener("oninitselbind", function(bindclass){
		var jmlNode = this;
		bindclass.addEventListener("onxmlupdate", function(){
			debugger;
			jmlNode.__showSelection();
		});
	});*/
	
	//For MultiBinding
	this.__showSelection = function(value){
		//Set value in Label
		var bc = this.getSelectionBindClass();

		//Only display caption when a value is set
		if(value === undefined){
			var sValue2, sValue = bc.applyRuleSetOnNode("Value", bc.XMLRoot, null, true);
			if(sValue) sValue2 = bc.applyRuleSetOnNode("Caption", bc.XMLRoot, null, true);

			if(!sValue2 && this.XMLRoot){
				var rule = this.getBindRule(this.mainBind).getAttribute("select");
				
				xpath = this.ruleTraverse + "[" + rule + "='" + sValue.replace(/'/g, "\\'") + "']";
				
				var xmlNode = this.XMLRoot.selectSingleNode(xpath);// + "/" + this.getBindRule("Caption").getAttribute("select")
				value = this.applyRuleSetOnNode("Caption", xmlNode);
			}
			else{
				value = sValue2 || sValue;
			}
		}
		this.setLabel(value || "");
	}
	
	//I might want to move this method to the MultiLevelBinding baseclass
	this.__updateOtherBindings = function(){
		if(!this.multiselect){
			// Set Caption bind
			var bc = this.getSelectionBindClass(), caption;
			if(bc && bc.XMLRoot && (caption = bc.bindingRules["Caption"])){
				var xmlNode = XMLDatabase.createNodeFromXpath(bc.XMLRoot, bc.bindingRules["Caption"][0].getAttribute("select"));
				if(!xmlNode) return;
	
				XMLDatabase.setNodeValue(xmlNode, this.applyRuleSetOnNode("Caption", this.value));
			}
		}
	}
	
	/************************
	  Private functions
	************************/
	
	this.__blur = function(){
		this.slideUp();
		//this.oExt.dispatchEvent("onmouseout")
		if(!this.isOpen) this.__setStyleClass(this.oExt, "", [this.baseCSSname + "over"])
		//if(this.oExt.onmouseout) this.oExt.onmouseout();
		
		this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Focus"]);
	}
	
	this.keyHandler = function(key, ctrlKey, shiftKey, altKey){
		//this.__keyHandler(key, ctrlKey, shiftKey, altKey);
		if(!this.XMLRoot) return;
		
		switch(key){
			case 38:
			//UP
				if(!this.value && !this.indicator) return;
				var node = this.getNextTraverseSelected(this.indicator || this.value, false);
				if(node) this.select(node);
				
			break;
			case 40:
			//DOWN
				var node;
				
				if(!this.value && !this.indicator){
					node = this.getFirstTraverseNode();
					if(!node) return;
				}
				else node = this.getNextTraverseSelected(this.indicator || this.value, true);
				if(node) this.select(node);
				
			break;
			default:
				if(key == 9) return;	
			
				//if(key > 64 && key < 
				if(!this.lookup || new Date().getTime() - this.lookup.date.getTime() > 1000) this.lookup = {
					str : "",
					date : new Date()
				};

				this.lookup.str += String.fromCharCode(key);
				
				var nodes = this.getTraverseNodes();
				for(var i=0;i<nodes.length;i++){
					if(this.applyRuleSetOnNode("Caption", nodes[i]).indexOf(this.lookup.str) > -1){
						this.select(nodes[i]);
						return;
					}
				}
			return;
		}

		return false;
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.__setClearMessage = function(msg){
		this.setLabel(msg);
	}
	
	this.__removeClearMessage = function(){
		this.setLabel("");
	}

	this.slideToggle = function(e){
		if(!e) e = event;
		
		if(this.isOpen) this.slideUp();
		else this.slideDown(e);
	}

	this.slideDown = function(e){
		if(this.dispatchEvent("onslidedown") === false) return false;
		
		this.isOpen = true;
		
		this.oSlider.style.display = "block";
		this.oSlider.style[IS_IE ? "overflowY" : "overflow"] = "hidden";
		
		this.oSlider.style.display = "";
		this.__setStyleClass(this.oExt, this.baseCSSname + "Down");
		
		/*var HT = this.sliderHeight;
		new GuiAnimation(this.oSlider, this.direction == "up" ? 'scrolltop' : 'scrollheight', 0, HT, this.animType, this.animSteps, this.animSpeed, 
			function(container){
				container.style[IS_IE ? "overflowY" : "overflow"] = "auto";
			});*/

		//var pos = Kernel.compat.getAbsolutePosition(this.oExt);
		this.oSlider.style.height = (this.sliderHeight - 1) + "px";
		this.oSlider.style.width = (this.oExt.offsetWidth - 2) + "px";
		Kernel.Popup.show(this.uniqueId, 0, this.oExt.offsetHeight, true, this.oExt, this.oExt.offsetWidth, this.containerHeight,
			function(container){
				container.style[IS_IE ? "overflowY" : "overflow"] = "auto";
			});
	}
	this.addEventListener("onslidedown", function(){
		//THIS SHOULD BE UPDATED TO NEW SMARTBINDINGS
		if(!this.form || !this.form.xmlActions || this.XMLRoot) return;
		var loadlist = this.form.xmlActions.selectSingleNode("LoadList[@element='" + this.name + "']");
		if(!loadlist) return;
		
		this.isOpen = 2;
		this.form.processLoadRule(loadlist, true, [loadlist]);
		
		return false;
	});
	
	this.slideUp = function(){
		if(this.isOpen == 2) return;
		if(this.dispatchEvent("onslideup") === false) return false;
		
		this.isOpen = false;
		if(this.value){
			var htmlNode = XMLDatabase.findHTMLNode(this.value, this);
			if(htmlNode) this.__setStyleClass(htmlNode, '', ["hover"]);
		}
		
		this.__setStyleClass(this.oExt, '', [this.baseCSSname + "Down"]);
		Kernel.Popup.hide();
	}
	this.addEventListener("onpopuphide", this.slideUp);
	
	this.setMaxItems = function(count){
		this.sliderHeight = count ? (Math.min(this.maxItems, count) * this.itemHeight) : 10;
		this.containerHeight = count ? (Math.min(this.maxItems, count) * this.itemHeight) : 10;
		if(this.containerHeight > 20) this.containerHeight = Math.ceil(this.containerHeight*0.9);
	}
	
	this.draw = function(){
		this.animType = this.__getOption("Main", "animtype") || 1;
		this.clickOpen = this.__getOption("Main", "clickopen") || "button";

		//Build Main Skin
		this.oExt = this.__getExternal(null, null, function(oExt){
			oExt.setAttribute("onmouseover", 'var o = Kernel.lookup(' + this.uniqueId + ');o.__setStyleClass(o.oExt, o.baseCSSname + "over");');
			oExt.setAttribute("onmouseout", 'var o = Kernel.lookup(' + this.uniqueId + ');if(o.isOpen) return;o.__setStyleClass(o.oExt, "", [o.baseCSSname + "over"]);');
			
			//Button
			var oButton = this.__getLayoutNode("Main", "button", oExt);
			if(oButton){
				oButton.setAttribute("onmousedown", 'Kernel.lookup(' + this.uniqueId + ').slideToggle(event);');
				//oButton.setAttribute("onmouseup", 'var o = Kernel.lookup(" + this.uniqueId + ");o.__setStyleClass(o.oExt, '', [o.oExt.className.split(' ')[0] + 'down'])");
				//oButton.setAttribute("onmouseout", 'var o = Kernel.lookup(" + this.uniqueId + ");o.__setStyleClass(o.oExt, '', [o.oExt.className.split(' ')[0] + 'down'])");
			}
			
			//Label
			var oLabel = this.__getLayoutNode("Main", "label", oExt);
			if(this.clickOpen == "both"){
				oLabel.parentNode.setAttribute("onmousedown", 'Kernel.lookup(' + this.uniqueId + ').slideToggle(event);');
			}
		});
		this.oLabel = this.__getLayoutNode("Main", "label", this.oExt);
		
		if(this.oLabel.nodeType == 3) this.oLabel = this.oLabel.parentNode;
		
		this.oIcon = this.__getLayoutNode("Main", "icon", this.oExt);
		if(this.oButton) this.oButton = this.__getLayoutNode("Main", "button", this.oExt);
		
		//Slider
		/*var oSlider = this.__getLayoutNode("Container", null, oExt);
		oSlider.setAttribute("onmouseover", "event.cancelBubble = true");
		oSlider.setAttribute("onmouseout", "event.cancelBubble = true");*/
		this.oSlider = XMLDatabase.htmlImport(this.__getLayoutNode("Container"), document.body);
		this.oInt = this.__getLayoutNode("Container", "contents", this.oSlider);
		
		//Set up the popup
		this.pHtmlDoc = Kernel.Popup.setContent(this.uniqueId, this.oSlider, PresentationServer.getTemplate(this.skinName).selectSingleNode("style").firstChild.nodeValue);
		
		//Get Options form skin
		this.listtype = parseInt(this.__getLayoutNode("Main", "type")) || 1; //Types: 1=One dimensional List, 2=Two dimensional List
		
		if(this.jml.childNodes.length) this.loadInlineData(this.jml);
		if(this.jml.getAttribute("fill")) this.loadFillData(this.jml.getAttribute("fill"));
	}
	
	this.__loadJML = function(x){
		this.name = x.getAttribute("id");
		this.maxItems = x.getAttribute("max-items") || 5;
		this.disableremove = x.getAttribute("disableremove") != "false";
		
		this.setMaxItems();
		
		if(x.getAttribute("multibinding") == "true" && !x.getAttribute("bind"))
			this.inherit(MultiLevelBinding);
		
		this.initialMsg = x.getAttribute("initial");
		
		this.itemHeight = this.__getOption("Main", "item-height") || 18.5;
	}
	
	this.__destroy = function(){
		Kernel.Popup.removeContent(this.uniqueId);
		Kernel.removeNode(this.oSlider);
		this.oSlider = null;
	}
}
/*FILEHEAD(/in/Components/Errorbox.js)SIZE(2368)TIME(1179307594016)*/

function Errorbox(pHtmlNode){
	Kernel.register(this, "Errorbox", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	this.editableParts = {"Main" : [["container","@invalidmsg"]]};
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.setMessage = function(value){
		if(value.indexOf(";")>-1){
			value = value.split(";");
			value = "<strong>" + value[0] + "</strong>" + value[1];
		}
		this.oInt.innerHTML = value;
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);
		
		this.hide();
	}
	
	this.__loadJML = function(x){
		if(x.firstChild) this.setMessage(x.firstChild.nodeValue);
		
		
		//Set Form
		/*
		var y = x;
		do{
			y = y.parentNode;
		}while(!y.tagName.match(/Submitform$/) && y.parentNode && y.parentNode.nodeType != 11);
		
		if(!y.tagName.match(/Submitform$/)) throw new Error(1004, Kernel.formErrorString(1004, this, "Errorbox", "Could not find Form element whilst trying to bind to it's Data."));
		if(!y.getAttribute("id")) throw new Error(1005, Kernel.formErrorString(1005, this, "Errorbox", "Found Form element but the id attribute is empty or missing."));
		
		this.form = eval(y.getAttribute("id"));
		
		if(x.getAttribute("for")) this.form.registerErrorBox(x.getAttribute("for"), this);
		*/
		
		
	}
}

/*FILEHEAD(/in/Components/Insert.js)SIZE(2236)TIME(1166375348945)*/

function Insert(pHtmlNode, data, skin){
	Kernel.register(this, "Insert", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	
	this.editableParts = {"Main" : [["caption","text()"]]};
	this.inherit(DataBinding);
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.getValue = function(){
		return this.value;
	}
	
	this.setValue = function(value){
		this.value = value;
		//pHtmlNode.innerHTML = value;
		this.oTxt.nodeValue = value;
	}
	
	/****************
		DATABINDING
	****************/
	this.mainBind = "Caption";
	
	this.__xmlUpdate = function(action, xmlNode, listenNode, UndoObj){
		//Action Tracker Support
		if(UndoObj) UndoObj.xmlNode = this.XMLRoot;
		
		//Refresh Properties
		this.setValue(this.applyRuleSetOnNode("Caption", this.XMLRoot) || "");
	}
	
	this.__load = function(node){
		/*
			absolutely weird behaviour when bind="" is set. 
			This function is loaded twice. First with some xml, 
			dunno why it's selected or called
		*/
		
		//Add listener to XMLRoot Node
		XMLDatabase.addNodeListener(node, this);
	
		var value = this.applyRuleSetOnNode("Caption", node);
		this.setValue(value || typeof value == "string" ? value : "");
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oInt = this.oExt = pHtmlNode;
		this.oTxt = document.createTextNode("");
		pHtmlNode.appendChild(this.oTxt);
	}
	
	
	this.__loadJML = function(x){
		if(x.firstChild){
			if(x.childNodes.length > 1 || x.firstChild.nodeType == 1){
				this.setValue("");
				Application.loadSubNode(x, this.oExt, this);
			}
			else this.setValue(x.firstChild.nodeValue);
		}
		
		//this.__makeEditable("Main", this.oExt, this.jml);
	}
}


/*FILEHEAD(/in/Components/FileUploadBox.js)SIZE(8828)TIME(1188383718500)*/

function FileUploadBox(pHtmlNode){
	Kernel.register(this, "FileUploadBox", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.focussable = true; // This object can get the focus
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.setIcon = function(url){
		if(this.oIcon.tagName == "img") this.oIcon.setAttribute("src", this.iconPath + url);
		else this.oIcon.style.backgroundImage = "url(" + this.iconPath + url + ")";
	}
	
	this.SetCaption = function(value){
		this.oCaption.nodeValue = value;
		//this.Change(value, true);
	}
	
	/****************
		API
	****************/
	
	this.getValue = function(){
		return this.value;
	}
	
	this.setValue = function(value){
		if(!this.value) this.old_value = value;
		this.value = value;
		
		if(this.oInt.nodeType == 1) this.oInt.innerHTML = value;
		else this.oInt.nodeValue = value;
		//this.Change(value);
	}
	
	this.setCaption = function(value){
		if(!value) value = "";
		//this.oInt.innerHTML = value;
		//this.SetCaption(value);
		this.lastCaption = value;
		this.oCaption.nodeValue = value;
	}
	
	this.__enable = function(){
		enable(this.oBtn);
	}
	
	this.__disable = function(){
		disable(this.oBtn);
	}
	
	this.showBrowseWindow = function(){
		if(this.disabled) return;

		this.inpFile.click();
		//this.__startUpload();
	}
	
	this.__startUpload = function(){
		if(this.value == this.inpFile.value || !this.inpFile.value) return;
		
		this.old_value = this.value;
		this.value = this.inpFile.value;
		this.setValue(this.value);
		
		this.upload();
	}
	
	this.updateProgress = function(){
		this.oSlider.style.width = this.oSlider.offsetWidth + 1;
	}
	
	this.upload = function(){
		this.uploading = true;
		
		this.disableEvents();
		this.oCaption.nodeValue = "Uploading...";
		this.oSliderExt.style.display = "block";
		//this.oSlider.style.display = "block";
		this.oSlider.style.width = 1;
		this.timer = setInterval('Kernel.lookup(' + this.uniqueId + ').updateProgress()', 800);
		this.timeout_timer = setTimeout('Kernel.lookup(' + this.uniqueId + ').doTimeout()', this.timeout);
		this.form.submit();
	}
	
	this.done = function(value, caption){
		window.clearInterval(this.timer);
		window.clearInterval(this.timeout_timer);
		this.oSlider.style.width = "100%";
		window.setTimeout('Kernel.lookup(' + this.uniqueId + ').clearProgress()', 300);

		if(value) this.setValue(value);
		this.old_value = null;
		
		//if(caption) 
		this.setCaption(this.lastCaption);

		this.dispatchEvent("onreceive", value);

		this.initForm();
		this.uploading = false;
		this.setEvents();
	}
	
	this.cancel = function(value, caption){
		window.clearInterval(this.timer);
		window.clearInterval(this.timeout_timer);
		this.clearProgress();

		this.setCaption(this.lastCaption);
		if(this.old_value) this.setValue(this.old_value);
		this.old_value = null;
		
		this.dispatchEvent("oncancel", value);

		this.initForm();
		this.uploading = false;
		this.setEvents();
	}
	
	this.doTimeout = function(){
		clearInterval(this.timer);
		
		this.setEvents();
		this.oCaption.nodeValue = this.jml.firstChild ? this.jml.firstChild.nodeValue : "";
		this.clearProgress();
		
		if(this.old_value) this.setValue(this.old_value);
		this.old_value = null;
		
		this.initForm();
		this.uploading = false;
		
		this.dispatchEvent("ontimeout");
	}
	
	this.clearProgress = function(){
		//this.oInt.style.display = "block";
		this.oSliderExt.style.display = "none";
	}
	
	/****************
		DATABINDING
	****************/
	
	this.inherit(DataBinding);
	
	/************************
	  Other Inheritance
	************************/
	
	this.inherit(Presentation);
	
	/************************
	  		Events
	************************/
	
	this.disableEvents = function(){
		this.oBtn.onclick = this.oBtn.onmouseover = this.oBtn.onmouseout = this.oBtn.onmouseup = this.oBtn.onmousedown = null;
	}
	
	this.setEvents = function(){
		this.oBtn.onmousedown = function(e){
			this.host.__setStyleClass(this, this.host.baseCSSname + "down", [this.host.baseCSSname + "over"]);
			if(this.host.onmousedown) this.host.onmousedown();
			(e || event).cancelBubble = true;
		};
		this.oBtn.onmouseover = function(e){
			this.host.__setStyleClass(this, this.host.baseCSSname + "over", [this.host.baseCSSname + "down"]);
			if(this.host.bgswitch) this.host.__getLayoutNode("Main", "background", this.host.oBtn).style.backgroundPosition = "-" + Kernel.getStyle(this.host.oBtn, "width") + " 0";
			if(this.host.onmouseover) this.host.onmouseover();
			(e || event).cancelBubble = true;
		};
		this.oBtn.onmouseout = function(e){
			this.host.__setStyleClass(this, "", [this.host.baseCSSname + "down", this.host.baseCSSname + "over"]);
			if(this.host.bgswitch) this.host.__getLayoutNode("Main", "background", this.host.oBtn).style.backgroundPosition = "0 0";
			if(this.host.onmouseout) this.host.onmouseout();
			(e || event).cancelBubble = true;
		};
		this.oBtn.onmouseup = function(e){
			this.host.__setStyleClass(this, this.host.baseCSSname + "over", [this.host.baseCSSname + "down"]);
			if(this.host.bgswitch) this.host.__getLayoutNode("Main", "background", this.host.oBtn).style.backgroundPosition = "-" + Kernel.getStyle(this.host.oBtn, "width") + " 0";
			if(this.host.onmouseup)this.host.onmouseup();
			(e || event).cancelBubble = true;
		};
		this.oBtn.onclick = function(e){
			if(this.host.onclick) this.host.onclick();
			(e || event).cancelBubble = true;
			
			this.host.showBrowseWindow();
		}
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.setTarget = function(target){
		this.target = target;
		this.initForm();
	}
	
	this.initForm = function(){
		if(IS_IE){
			this.oFrame.contentWindow.document.write("<body></body>");
			this.form = XMLDatabase.htmlImport(this.__getLayoutNode("Form"), this.oFrame.contentWindow.document.body);
		}
		
		//this.form = this.__getLayoutNode("Main", "form", this.oExt);
		this.form.setAttribute("action", this.target);
		this.form.setAttribute("target", "upload" + this.uniqueId);
		this.__getLayoutNode("Form", "inp_uid", this.form).setAttribute("value", this.uniqueId);
		this.inpFile = this.__getLayoutNode("Form", "inp_file", this.form);
		
		var jmlNode = this;
		this.inpFile.onchange = function(){
			jmlNode.__startUpload();
		}
		
		if(IS_GECKO){
			this.inpFile.onmouseover = function(e){
				if(jmlNode.oBtn.onmouseover)
					jmlNode.oBtn.onmouseover(e);
			}
			this.inpFile.onmouseout = function(e){
				if(jmlNode.oBtn.onmouseout)
					jmlNode.oBtn.onmouseout(e);
			}
		}

		if(DEBUG == 2){
			this.oFrame.style.visibility = "visible";
			this.oFrame.style.width = "100px";
			this.oFrame.style.height = "100px";
		}
	}
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal("Main", null, function(oExt){
			oExt.appendChild(oExt.ownerDocument.createElement("iframe")).setAttribute("name", "upload" + this.uniqueId);
		});
		
		this.oInt = this.__getLayoutNode("Main", "value", this.oExt);
		this.oBtn = this.__getLayoutNode("Main", "button", this.oExt);
		this.oIcon = this.__getLayoutNode("Main", "icon", this.oExt);
		this.oCaption = this.__getLayoutNode("Main", "caption", this.oExt);
		this.oSliderExt = this.__getLayoutNode("Main", "slider", this.oExt);
		this.oSlider = this.__getLayoutNode("Main", "slidemove", this.oExt);
		
		this.oFrame = this.oExt.getElementsByTagName("iframe")[0];
		if(!IS_IE) this.form = XMLDatabase.htmlImport(this.__getLayoutNode("Form"), this.oExt);
		
		this.oBtn.host = this;
		
		this.setEvents();
	}
	
	this.__loadJML = function(x){
		this.target = x.getAttribute("target");
		if(x.getAttribute("value")) this.setValue(x.getAttribute("value"));
		
		this.setCaption(x.firstChild ? x.firstChild.nodeValue : "");
		if(x.getAttribute("icon")) this.setIcon(x.getAttribute("icon"));
		if(x.getAttribute("onclick")) this.onclick = x.getAttribute("onclick");
		this.timeout = x.getAttribute("timeout") || 100000;
		
		this.bgswitch = x.getAttribute("bgswitch") ? true : false;
		if(this.bgswitch){
			this.__getLayoutNode("Main", "background", this.oExt).style.backgroundImage = "url(" + this.mediaPath + x.getAttribute("bgswitch") + ")";
			this.__getLayoutNode("Main", "background", this.oExt).style.backgroundRepeat = "no-repeat";
		}
		
		this.initForm();
	}
	
	this.__destroy = function(){
		this.oBtn.host = null;
	}
}
/*FILEHEAD(/in/Components/Frame.js)SIZE(1449)TIME(1162219256467)*/

function Frame(pHtmlNode){
	Kernel.register(this, "Frame", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;

	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	this.editableParts = {"Main" : [["caption","@caption"]]};
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.setCaption = function(value){
		this.oCaption.nodeValue = value;
	}
		
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oCaption = this.__getLayoutNode("Main", "caption", this.oExt);
		var oInt = this.__getLayoutNode("Main", "container", this.oExt);
		
			this.__makeEditable("Main", this.oExt, this.jml);
		
		this.oInt = this.oInt ? 
			Application.replaceNode(oInt, this.oInt) : 
			Application.loadSubNode(this.jml, oInt, this);
	}
	
	this.__loadJML = function(x){
		if(x.getAttribute("caption")) this.setCaption(x.getAttribute("caption"));
	}
}

/*FILEHEAD(/in/Components/FastList.js)SIZE(3692)TIME(1182723583203)*/

function FastList(pHtmlNode){
	Kernel.register(this, "FastList", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
			  RENAME
	************************/
	
	this.__getCaptionElement = function(){
		var x = this.__getLayoutNode("Item", "caption", this.selected);
		return x.nodeType == 1 ? x : x.parentNode;
	}
	
	this.addEventListener("onafterselect",function(e){
		if(this.hasFeature(__VALIDATION__)) this.validate();
	});
	
	/************************
	  Other Inheritance
	************************/
	this.inherit(BcFastList);
	
	this.keyHandler = this.__keyHandler;
	
	this.inherit(Rename);
	
	/************************
			DRAGDROP
	************************/
	
	this.__showDragIndicator = function(sel, e){
		var x = e.offsetX;
		var y = e.offsetY;

		this.oDrag.startX = x;
		this.oDrag.startY = y;
		
		document.body.appendChild(this.oDrag);
		//this.oDrag.getElementsByTagName("DIV")[0].innerHTML = this.selected.innerHTML;
		//this.oDrag.getElementsByTagName("IMG")[0].src = this.selected.parentNode.parentNode.childNodes[1].firstChild.src;
		this.__updateNode(this.value, this.oDrag);
		
		return this.oDrag;
	}
	
	this.__hideDragIndicator = function(){
		this.oDrag.style.display = "none";
	}
	
	this.__moveDragIndicator = function(e){
		this.oDrag.style.left = (e.clientX - this.oDrag.startX) + "px";
		this.oDrag.style.top = (e.clientY - this.oDrag.startY) + "px";
	}
	
	this.__initDragDrop = function(){
		if(!this.__hasLayoutNode("DragIndicator")) return;
		this.oDrag = XMLDatabase.htmlImport(this.__getLayoutNode("DragIndicator"), document.body);
		
		this.oDrag.style.zIndex = 1000000;
		this.oDrag.style.position = "absolute";
		this.oDrag.style.cursor = "default";
		this.oDrag.style.display = "none";
	}
	
	this.__dragout = 
	this.__dragover = 
	this.__dragdrop = function(){}
	
	this.inherit(DragDrop);
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);

		/*this.oExt.onmousedown = function(e){
			if(!e) e = event;
			if(e.ctrlKey || e.shiftKey) return;
			
			var srcElement = IS_IE ? e.srcElement : e.target;
			debugger;
			if(this.host.allowDeselect && (srcElement == this || srcElement.getAttribute(XMLDatabase.htmlIdTag)))
				this.host.clearSelection(); //hacky
		}*/
		
		this.oExt.onclick = function(){
			this.host.dispatchEvent("onclick");
		}
		
		this.sb = new Scrollbar(this.pHtmlNode);

		//Get Options form skin
		this.listtype = parseInt(this.__getLayoutNode("Main", "type")) || 1; //Types: 1=One dimensional List, 2=Two dimensional List
		this.behaviour = parseInt(this.__getLayoutNode("Main", "behaviour")) || 1; //Types: 1=Check on click, 2=Check independent
		this.hasCheckbox = this.__getLayoutNode("Main", "checkbox") ? true : false;
	}
	
	this.__loadJML = function(x){
		if(this.jml.childNodes.length) this.loadInlineData(this.jml);
		
		if(this.hasFeature(__MULTIBINDING__) && x.getAttribute("value")) this.setValue(x.getAttribute("value"));
		
		// this.doOptimize(true);
		
		if(x.getAttribute("multibinding") == "true" && !x.getAttribute("bind")) 
			this.inherit(MultiLevelBinding);
	}
	
	this.__destroy = function(){
		this.oExt.onclick = null;	
	}
}

/*FILEHEAD(/in/Components/Label.js)SIZE(2626)TIME(1175798211810)*/

function Label(pHtmlNode, data, skin){
	Kernel.register(this, "Label", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	this.editableParts = {"Main" : [["caption","text()"]]};
	
	this.setValue = function(value){
		this.value = value;
		this.oInt.innerHTML = value;
	}
	
	this.__supportedProperties = ["value"];
	this.__handlePropSet = function(prop, value){
		switch(prop){
			case "value":
				this.oInt.innerHTML = value;
			break;
		}
	}
	
	/****************
		DATABINDING
	****************/
	this.mainBind = "Value";
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oInt = this.__getLayoutNode("Main", "caption", this.oExt);
		if(this.oInt.nodeType != 1) this.oInt = this.oInt.parentNode;
		
		this.oExt.onmousedown = function(){
			if(this.host.formEl && this.host.formEl.nodeType == GUI_NODE){
				//this.host.formEl.focus();
				me.__focus(this.host.formEl);
			}
		}
	}
	
	this.setFormEl = function(formEl){
		this.formEl = formEl;
	}
	
	this.__loadJML = function(x){
		if(x.firstChild){
			if(x.childNodes.length > 1 || x.firstChild.nodeType == 1){
				this.setValue("");
				Application.loadSubNode(x, this.oExt, this);
			}
			else this.setValue(x.firstChild.nodeValue);
		}
		
			this.__makeEditable("Main", this.oExt, this.jml);
		
		
		//Set Form
		var y = x;
		do{
			y = y.parentNode;
		}while(y.tagName && !y.tagName.match(/Submitform$/) && y.parentNode && y.parentNode.nodeType != 9);
		if(y.tagName && y.tagName.match(/Submitform$/)){
			if(!y.tagName.match(/Submitform$/)) throw new Error(1004, Kernel.formErrorString(1004, this, "Textbox", "Could not find Form element whilst trying to bind to it's Data."));
			if(!y.getAttribute("id")) throw new Error(1005, Kernel.formErrorString(1005, this, "Textbox", "Found Form element but the id attribute is empty or missing."));
			
			this.form = eval(y.getAttribute("id"));
		}
		
		if(x.getAttribute("for") && this.form) this.form.addConnectQueue(this, this.setFormEl, x.getAttribute("for"));
		
	}
	
	this.inherit(BcSimple);
}

/*FILEHEAD(/in/Components/Picture.js)SIZE(1319)TIME(1187087508069)*/

function Picture(pHtmlNode, data, skin){
	Kernel.register(this, "Picture", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	this.editableParts = {"Main" : [["image","@src"]]};
	
	this.setValue = function(value){
		//this.setProperty("value", value);
	}
	
	this.__supportedProperties = ["value"];
	this.__handlePropSet = function(prop, value){
		switch(prop){
			case "value":
				var imgNode = this.__getLayoutNode("Main", "image", this.oExt);
				if(imgNode.nodeType == 1) imgNode.style.backgroundImage = "url("+ value+")";
				else imgNode.nodeValue = value;
			break;
		}
	}
	
	this.draw = function(){
		//Build Main Skin
		this.oInt = this.oExt = this.__getExternal();
		this.oExt.onclick = function(){this.host.dispatchEvent("onclick");}
	}
	
	this.__loadJML = function(x){
		this.setProperty("value", x.getAttribute("src"));
		
			this.__makeEditable("Main", this.oExt, this.jml);
		
		Application.loadSubNode(x, null, this);
	}
	
	this.inherit(BcSimple);
}


/*FILEHEAD(/in/Components/Flash.js)SIZE(2169)TIME(1188900006250)*/

function Flash(pHtmlNode, data, skin){
	Kernel.register(this, "Flash", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	//this.editableParts = {"Main" : [["image","@src"]]};
	
	this.setValue = function(value){
		//this.setProperty("value", value);
	}
	
	this.getApi = function(){
		return this.oExt;
	}
	
	this.__supportedProperties = ["value"];
	this.__handlePropSet = function(prop, value){
		switch(prop){
			case "value":
				this.setSource(value);
			break;
		}
	}
	
	this.draw = function(){
		//Build Main Skin
		//this.oInt = this.oExt = this.__getExternal();
		//this.oExt.onclick = function(){this.host.dispatchEvent("onclick");}
		
		var src = this.jml.getAttribute("src") || "";
		document.body.insertAdjacentHTML("beforeend", '<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,0,0" width="1" height="1" align="middle"><param name="allowScriptAccess" value="sameDomain" /><param name="allowFullScreen" value="false" /><param name="movie" value="' + src + '" /><param name="play" value="false" /><param name="menu" value="false" /><param name="quality" value="high" /><param name="wmode" value="transparent" /><param name="bgcolor" value="#ffffff" />	<embed src="' + src + '" play="false" menu="false" quality="high" wmode="transparent" bgcolor="#ffffff" width="1" height="1" align="middle" allowScriptAccess="sameDomain" allowFullScreen="false" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" /></object>')
		this.oExt = document.body.lastChild;
		pHtmlNode.appendChild(this.oExt);
	}
	
	this.__loadJML = function(x){
			//this.__makeEditable("Main", this.oExt, this.jml);
		
		Application.loadSubNode(x, null, this);
	}
	
	this.inherit(BcSimple);
}


/*FILEHEAD(/in/Components/Portal.js)SIZE(7502)TIME(1188900006250)*/

function Portal(pHtmlNode){
	Kernel.register(this, "Portal", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/

	/************************
				Skin
	************************/

	this.__deInitNode = function(xmlNode, htmlNode){
		if(!htmlNode) return;

		//Remove htmlNodes from tree
		htmlNode.parentNode.removeChild(htmlNode);
	}
	
	this.__updateNode = function(xmlNode, htmlNode){
		this.applyRuleSetOnNode("Icon", xmlNode);
	}
	
	this.__moveNode = function(xmlNode, htmlNode){
		if(!htmlNode) return;
	}
	
	/************************
		Keyboard Support
	************************/
	
	//Handler for a plane list
	this.__keyHandler = function(key, ctrlKey, shiftKey, altKey){
		if(!this.selected) return;

		switch(key){
			default:
			break;
		}
	}
	
	/************************
			  CACHING
	************************/
	
	this.__getCurrentFragment = function(){
		//if(!this.value) return false;

		var fragment = IS_IE55 ? new DocFrag() : document.createDocumentFragment(); //IE55
		while(this.columns[0].childNodes.length){
			fragment.appendChild(this.columns[0].childNodes[0]);
		}

		return fragment;
	}
	
	this.__setCurrentFragment = function(fragment){
		IS_IE55 ? fragment.reinsert(this.oInt) : this.oInt.appendChild(fragment); //IE55
		
		if(!me.isFocussed(this)) this.blur();
	}

	this.__findNode = function(cacheNode, id){
		if(!cacheNode) return this.pHtmlDoc.getElementById(id);
		return cacheNode.getElementById(id);
	}
	
	this.__setClearMessage = function(msg){
		var oEmpty = XMLDatabase.htmlImport(this.__getLayoutNode("Empty"), this.oInt);
		var empty = this.__getLayoutNode("Empty", "caption", oEmpty);
		if(empty) empty.nodeValue = msg || "";
		if(oEmpty) oEmpty.setAttribute("id", "empty" + this.uniqueId);
	}
	
	this.__removeClearMessage = function(){
		var oEmpty = document.getElementById("empty" + this.uniqueId);
		if(oEmpty) oEmpty.parentNode.removeChild(oEmpty);
		//else this.oInt.innerHTML = ""; //clear if no empty message is supported
	}
	
	this.inherit(Cache);

	/************************
			DATABINDING
	************************/
	
	var portalNode = this;
	function createWidget(xmlNode, widget, dataNode){
		/* Model replacement - needs to be build
		var models = xmlNode.selectNodes("//model/@id");
		for(var i=0;i<models.lenth;i++){
			xmlNode.selectNodes("//node()[@model='" + models[i]
		}
		*/
		
		//also replace widget id's

		var name = xmlNode.getAttribute("name");
		
		//Load Widget
		widget.jml = xmlNode;
		widget.loadSkin("default:PortalWindow");
		widget.btnedit = true;
		widget.btnmin = true;
		widget.btnclose = true;
		
		widget.draw();//name
		widget.__loadJML(xmlNode, name);
		widget.setCaption(portalNode.applyRuleSetOnNode("Caption", dataNode));
		widget.setIcon(portalNode.applyRuleSetOnNode("Icon", dataNode));
		
		if(xmlNode.getAttribute("width")) widget.setWidth(xmlNode.getAttribute("width"));
		else widget.oExt.style.width = "auto";
		//if(xmlNode.getAttribute("height")) widget.setHeight(xmlNode.getAttribute("height"));
		//else widget.oExt.style.height = "auto";
		
		widget.display(0, 0);

		//Create WidgetClass
		if(!self[name]) alert("could not find class '" + name + "'");
		
		//instantiate class
		var widgetClass = new self[name]();
		portalNode.widgets.push(widgetClass);
		widgetClass.init(dataNode, widget);
	}
	
	this.widgets = [];
	var widget_cache = {}
	this.__add = function(dataNode, Lid, xmlParentNode, htmlParentNode, beforeNode){
		//Build window
		var widget = new ModalWindow(this.columns[this.applyRuleSetOnNode("Column", dataNode) || 0], true);
		widget.parentNode = this;
		widget.inherit(JmlDomAPI);
		//this.applyRuleSetOnNode("Border", xmlNode);
		
		var srcUrl = this.applyRuleSetOnNode("Src", dataNode);
		
		if(!widget_cache[srcUrl]) new HTTP().getXML(srcUrl, function(xmlNode, status, extra){
			if(IS_IE) xmlNode.ownerDocument.setProperty("SelectionNamespaces", "xmlns:j='http://www.javeline.net/j'");
			widget_cache[extra.url] = xmlNode.cloneNode(true);
			createWidget(xmlNode, widget, dataNode);
		}, false);
		else createWidget(widget_cache[srcUrl], widget, dataNode);
	}
	
	this.__fill = function(){
	}
	
	/************************
	  Other Inheritance
	************************/
	
	this.inherit(Presentation);
	this.inherit(MultiSelect);
	this.inherit(DataBinding);
	
	this.__selectDefault = function(xmlNode){
		/*if(this.select(this.getFirstTraverseNode(xmlNode))) return true;
		else{
			var nodes = this.getTraverseNodes(xmlNode);
			for(var i=0;i<nodes.length;i++){
				if(this.__selectDefault(nodes[i])) return true;
			}
		}*/
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	var totalWidth = 0;
	this.columns = [];
	this.addColumn = function(size){
		this.__getNewContext("Column");
		var col = XMLDatabase.htmlImport(this.__getLayoutNode("Column"), this.oInt);
		var id = this.columns.push(col) - 1;
		
		col.style.left = totalWidth + (size.match(/%/) ? "%" : "px");
		totalWidth += parseFloat(size);
		
		col.style.width = size;//"33.33%";
		col.isColumn = true;
		col.host = this;
	}
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);

		//Create columns
		var cols = (this.jml.getAttribute("columns") || "33.33%,33.33%,33.33%").split(",");
		for(var i=0;i<cols.length;i++){
			this.addColumn(cols[i]);
		}

		//if(this.jml.childNodes.length) this.loadInlineData(this.jml);
		Application.loadSubNode(this.jml, null, this);
	}
	
	this.__loadJML = function(x){
		
	}
	
	this.loadInlineData = function(x){
		var hasIcon, strData = [], nodes = x.childNodes;

		for(var i=nodes.length-1;i>=0;i--){
			if(nodes[i].nodeType != 1) continue;
			if(nodes[i][TAGNAME] != "Item") continue;
			
			hasIcon = nodes[i].getAttribute("icon") || "icoAnything.gif";
			strData.unshift("<Item " + (hasIcon ? "icon='" + hasIcon + "'" : "") + " value='" + (nodes[i].getAttributeNode("value") ? nodes[i].getAttribute("value") : nodes[i].firstChild.nodeValue) + "'>" + nodes[i].firstChild.nodeValue + "</Item>");
			nodes[i].parentNode.removeChild(nodes[i]);
		}

		if(strData.length){
			var sNode = new SmartBinding(null, XMLDatabase.getObject("XMLDOM", "<j:smartbindings xmlns:j='http://www.javeline.net/j'><j:bindings><Caption select='text()' />" + (hasIcon ? "<Icon select='@icon'/>" : "") + "<Value select='@value'/><Traverse select='Item' /></j:bindings><j:model><Items>" + strData.join("") + "</Items></j:model></j:smartbindings>").documentElement);
			Application.addToSbStack(this.uniqueId, sNode);
		}
		
		if(x.childNodes.length)
			Application.loadSubNode(x, null, this);
	}
}

function PortalWidget(){
	this.init = function(xmlSettings, oWidget){
		this.xmlSettings = xmlSettings
		this.oWidget = oWidget;
		
		if(this.__init) this.__init(xmlSettings, oWidget);
	}
}


/*FILEHEAD(/in/Components/Jslt.js)SIZE(2695)TIME(1177277319193)*/

function Jslt(pHtmlNode, data, skin){
	Kernel.register(this, "Jslt", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;

	/************************
	  		Inheritance
	************************/
	
	this.inherit(DataBinding);
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	
	/****************
		DATABINDING
	****************/
	this.mainBind = "Contents";
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.parse = function(code){
		this.setProperty("value", code);
	}

	this.clear = function(a,b){
		//BUG: WTF? clear gets called before load AND if there is nothing to load but with different args
		//IF YOU CLEAR HERE A REDRAW WITH THE SAME CONTENT WILL FAIL 
		if(b==true){
			this.oInt.innerHTML = "";//alert(a+"-"+b);
			// WHY . if i dont do this the setProperty loses its update. 
			this.setProperty("value","");
		}
		//alert(this.uniqueId);
		//this.oInt.innerHTML = "";
	}
	
	this.__supportedProperties = ["value"];
	this.__handlePropSet = function(prop, code){
		switch(prop){
			case "value":
				if(this.createJml){
					if(typeof code == "string") code = XMLDatabase.getXml(code);
					// To really make it dynamic, the objects created should be 
					// deconstructed and the xml should be attached and detached
					// of the this.jml xml. 
					Application.loadSubNode(code, this.oInt, this);
					if(Application.inited) Application.processDatabinding();
				}
				else{
					this.oInt.innerHTML = code;
				}
			break;
		}
	}
	
	this.draw = function(){
		//Build Main Skin
		//alert("REDRAW");
		this.oInt = this.oExt = this.jml.parentNode.lastChild == this.jml.parentNode.firstChild ? pHtmlNode : pHtmlNode.appendChild(document.createElement("div"));
		if(this.jml.getAttribute("cssclass")) this.oExt.className = this.jml.getAttribute("cssclass");
	}
	
	this.__loadJML = function(x){
		this.createJml = isTrue(x.getAttribute("jml"));

		if(x.firstChild){
			var bind = x.getAttribute("bind") || "."; x.removeAttribute("bind");
			var strBind = "<smartbinding><bindings><Contents select='" + bind + "'><![CDATA[" + x.firstChild.nodeValue + "]]></Contents></bindings></smartbinding>";
			Application.addToSbStack(this.uniqueId, new SmartBinding(null, XMLDatabase.getXml(strBind)));
		}
	}
}


/*FILEHEAD(/in/Components/Layoutbuilder.js)SIZE(13422)TIME(1163341815679)*/

function Layoutbuilder(pHtmlNode){
	Kernel.register(this, "Layoutbuilder", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/

	//Options
	this.focussable = true; // This object can get the focus
	this.multiselect = false; // Initially Disable MultiSelect
	this.structs = {};
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/

	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/

	/************************
				Skin
	************************/

	this.__deInitNode = function(xmlNode, htmlNode){
		if(!htmlNode) return;

		htmlNode.parentNode.removeChild(htmlNode);
	}
	
	this.checkPosition = function(m){
		
	}
	
	this.isValid = function(){
		for(var i=0;i<this.oInt.childNodes.length;i++){
			this.layout.align(this.oInt.childNodes[i], this.structs[this.oInt.childNodes[i].getAttribute("id")]);
		}
		
		//can be optimized
		var result = this.layout.check(true);
		this.layout.reset();
		
		return result;
	}
	
	this.alignElement = function(xmlNode, htmlNode, purge){
		var aData = {};
		if(xmlNode.getAttribute("align")) aData.template = xmlNode.getAttribute("align");
		if(xmlNode.getAttribute("align-lean")) aData.isBottom = xmlNode.getAttribute("align-lean").match(/bottom/);
		if(xmlNode.getAttribute("align-lean")) aData.isRight = xmlNode.getAttribute("align-lean").match(/right/);
		if(xmlNode.getAttribute("align-position")){
			xmlNode.getAttribute("align-position").match(/\((\d+),(\d+)\)/);
			aData.vpos = parseInt(RegExp.$1);
			aData.hpos = parseInt(RegExp.$2);
			aData.template = undefined;
		}
		if(xmlNode.getAttribute("align-margin")) aData.edgeMargin = xmlNode.getAttribute("align-margin");
		if(xmlNode.getAttribute("align-span")) aData.span = parseInt(xmlNode.getAttribute("align-span"));
		if(xmlNode.getAttribute("align-splitter") || xmlNode.getAttribute("align-edge") == "splitter") aData.splitter = xmlNode.getAttribute("align-splitter") || (xmlNode.getAttribute("align-edge") == "splitter" ? 3 : false);
		if(xmlNode.getAttribute("width")) aData.fwidth = xmlNode.getAttribute("width");
		if(xmlNode.getAttribute("height")) aData.fheight = xmlNode.getAttribute("height");
		if(xmlNode.getAttribute("min-width")) aData.minwidth = xmlNode.getAttribute("min-width");
		if(xmlNode.getAttribute("min-height")) aData.minheight = xmlNode.getAttribute("min-height");

		/*var id = htmlNode.getAttribute("id");
		if(this.structs[id]) this.layout.remove(this.structs[id]);*/
		
		//var struct = this.layout.align(htmlNode, aData);
		this.structs[xmlNode.getAttribute(XMLDatabase.xmlIdTag)] = aData;
		
		this.sort();
		
		if(false && !this.isValid() && !this.isInError){
			this.isInError = true;
			return this.__setStyleClass(htmlNode, "error");
		}
		
		if(purge) this.purge();
	}
	
	this.seq = {"top":0, "left":1, "middle":2, "right":3, "bottom":4};
	this.getPrevSibl = function(node){if(!node) return; return !node.previousSibling || node.previousSibling.nodeType == 1 ? node.previousSibling : node.previousSibling.previousSibling}
	this.getNextSibl = function(node){if(!node) return; return !node.nextSibling || node.nextSibling.nodeType == 1 ? node.nextSibling : node.nextSibling.nextSibling}
	this.sort = function(){
		var node = this.XMLRoot.childNodes[0], prevSib = this.getPrevSibl(node);
		do{
			while(prevSib && prevSib.nodeType == 1 && node.nodeType == 1 && this.seq[node.getAttribute("align")] < this.seq[prevSib.getAttribute("align")]){
				node.parentNode.insertBefore(node, prevSib);
				prevSib = this.getPrevSibl(node);
			}
			node = this.getNextSibl(node);
			prevSib = this.getPrevSibl(node);
		}while(node);
	}
	
	this.purge = function(){
		//if(!this.isValid()) return;
		this.isInError = false;
		
		/*this.layout = new Layout(this.oExt);
		var pMargin = this.XMLRoot.getAttribute("margin");
		if(pMargin) this.layout.setMargin(pMargin.split(/,\s* /));*/
		
		//Replace below with sorting of the LayoutServer
		var nodes = this.XMLRoot.childNodes;//this.oInt.childNodes;//
		for(var i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1) continue;
			//this.layout.align(XMLDatabase.findHTMLNode(nodes[i], this), this.structs[nodes[i].getAttribute("id")]);
			this.layout.align(XMLDatabase.findHTMLNode(nodes[i], this), this.structs[nodes[i].getAttribute(XMLDatabase.xmlIdTag)]);
			//this.__setStyleClass(this.oInt.childNodes[i], "", ["error"]);
		}
		
		var cResult = this.layout.compile();
		this.layout.reset();
		if(cResult){
			this.__setStyleClass(this.oExt, this.baseCSSname + "Error");
			alert(cResult);
		}
		else this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Error"]);
	}
	
	this.__updateNode = function(xmlNode, htmlNode){
		var elCaption = this.__getLayoutNode("Item", "caption", htmlNode);
		if(elCaption)
			this.__getLayoutNode("Item", "caption", htmlNode).parentNode.innerHTML = this.applyRuleSetOnNode("Caption", xmlNode);

		this.alignElement(xmlNode, htmlNode);
	}
	
	this.__moveNode = function(xmlNode, htmlNode){
		if(!htmlNode) return;
		var oPHtmlNode = htmlNode.parentNode;
		var beforeNode = xmlNode.nextSibling ? XMLDatabase.findHTMLNode(this.getNextTraverse(xmlNode), this) : null;

		oPHtmlNode.insertBefore(htmlNode, beforeNode);
		
		this.alignElement(xmlNode, htmlNode);
	}
	
	this.addEventListener("onxmlupdate", function(action){
		if(action == "remove") return;
		this.purge();
	});
	
	/************************
		Keyboard Support
	************************/
	
	this.__keyHandler = function(key, ctrlKey, shiftKey, altKey){
		if(!this.selected) return;

		switch(key){
			case 13:
				this.choose(this.selected);
			break;
			case 32:
				this.select(this.indicator, true);
			break;
			case 46:
			//DELETE
				var ln = this.getSelectCount();
				var xmlNode = ln == 1 ? this.value : null;
				this.Remove(xmlNode);
			break;
			case 37:
			//LEFT
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
			
				if(!this.value) return;
				var node = this.getNextTraverseSelected(this.indicator || this.value, false);
				if(node){
					if(ctrlKey) this.setIndicator(node);
					else this.select(node, null, shiftKey);
				}
				
				if(this.selected.offsetTop < this.oExt.scrollTop)
					this.oExt.scrollTop = this.selected.offsetTop - margin[0];
			break;
			case 38:
			//UP
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				
				if(!this.value && !this.indicator) return;
				var hasScroll = this.oExt.scrollHeight > this.oExt.offsetHeight;
				var items = Math.floor((this.oExt.offsetWidth - (hasScroll ? 15 : 0)) / (this.selected.offsetWidth+margin[1]+margin[3]));
				var node = this.getNextTraverseSelected(this.indicator || this.value, false, items);
				if(node){
					if(ctrlKey) this.setIndicator(node);
					else this.select(node, null, shiftKey);
				}
				
				if(this.selected.offsetTop < this.oExt.scrollTop)
					this.oExt.scrollTop = this.selected.offsetTop - margin[0];
			break;
			case 39:
			//RIGHT
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				
				if(!this.value) return;
				var node = this.getNextTraverseSelected(this.indicator || this.value, true);
				if(node){
					if(ctrlKey) this.setIndicator(node);
					else this.select(node, null, shiftKey);
				}
				
				if(this.selected.offsetTop + this.selected.offsetHeight > this.oExt.scrollTop + this.oExt.offsetHeight)
					this.oExt.scrollTop = this.selected.offsetTop - this.oExt.offsetHeight + this.selected.offsetHeight + margin[0];
					
			break;
			case 40:
			//DOWN
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				
				if(!this.value && !this.indicator) return;
				var hasScroll = this.oExt.scrollHeight > this.oExt.offsetHeight;
				var items = Math.floor((this.oExt.offsetWidth - (hasScroll ? 15 : 0)) / (this.selected.offsetWidth+margin[1]+margin[3]));
				var node = this.getNextTraverseSelected(this.indicator || this.value, true, items);
				if(node){
					if(ctrlKey) this.setIndicator(node);
					else this.select(node, null, shiftKey);
				}
				
				if(this.selected.offsetTop + this.selected.offsetHeight > this.oExt.scrollTop + this.oExt.offsetHeight)
					this.oExt.scrollTop = this.selected.offsetTop - this.oExt.offsetHeight + this.selected.offsetHeight + 10;
				
			break;
			case 65:
				if(ctrlKey){
					this.selectAll();	
					return false;
				}
			break;
			case 93:
			//CONTEXT MENU
				if(this.value) this.dispatchEvent("oncontextmenu", true);
				return false;
			break;
			default: 
			return;
		}
		
		return false;
	}
	
	/************************
			DATABINDING
	************************/
	
	this.nodes = [];
	
	this.__add = function(xmlNode, Lid, xmlParentNode, htmlParentNode, beforeNode){
		//Build Item
		this.__getNewContext("Item");
		var Item = this.__getLayoutNode("Item");
		var elSelect = this.__getLayoutNode("Item", "select");
		var elCaption = this.__getLayoutNode("Item", "caption");
		
		Item.setAttribute("id", Lid);
		
		elSelect.setAttribute("oncontextmenu", 'Kernel.lookup(' + this.uniqueId + ').dispatchEvent("oncontextmenu");');
		elSelect.setAttribute("ondblclick", 'Kernel.lookup(' + this.uniqueId + ').choose()');
		elSelect.setAttribute("onmousedown", 'Kernel.lookup(' + this.uniqueId + ').select(this, event.ctrlKey, event.shiftKey)'); 
		elSelect.setAttribute("onmouseover", 'Kernel.lookup(' + this.uniqueId + ').__setStyleClass(this, "hover");'); 
		elSelect.setAttribute("onmouseout", 'Kernel.lookup(' + this.uniqueId + ').__setStyleClass(this, "", ["hover"]);'); 
		
		if(elCaption) elCaption.nodeValue = this.applyRuleSetOnNode("Caption", xmlNode);

		if(htmlParentNode){
			XMLDatabase.htmlImport(Item, htmlParentNode, beforeNode);
			this.alignElement(xmlNode, Item);
		}
		else{
			this.nodes.push(Item);
			this.alignElement(xmlNode, Item);
		}
	}
	
	this.__fill = function(){
		XMLDatabase.htmlImport(this.nodes, this.oInt);
		
		var pMargin = this.XMLRoot.getAttribute("margin");
		if(pMargin) this.layout.setMargin(pMargin.split(/,\s*/));

		this.sort();
		this.purge();
		
		this.nodes.length = 0;
	}
	
	/************************
				SELECT
	************************/
	
	this.__calcSelectRange = function(xmlStartNode, xmlEndNode){
		var r = [], loopNode = xmlStartNode;
		while(loopNode && loopNode != xmlEndNode.nextSibling){
			r.push(loopNode);
			loopNode = loopNode.nextSibling;
		}

		if(r[r.length-1] != xmlEndNode){
			var r = [], loopNode = xmlStartNode;
			while(loopNode && loopNode != xmlEndNode.previousSibling){
				r.push(loopNode);
				loopNode = loopNode.previousSibling;
			};
		}
		
		return r;
	}
	
	this.__selectDefault = function(XMLRoot){
		this.select(XMLRoot.selectSingleNode(this.ruleTraverse));
	}
	
	this.inherit(MultiSelect);
	
	/************************
			  CACHING
	************************/
	
	this.__getCurrentFragment = function(){
		//if(!this.value) return false;

		var fragment = IS_IE55 ? new DocFrag() : document.createDocumentFragment(); //IE55
		while(this.oInt.childNodes.length){
			fragment.appendChild(this.oInt.childNodes[0]);
		}

		return fragment;
	}
	
	this.__setCurrentFragment = function(fragment){
		IS_IE55 ? fragment.reinsert(this.oExt) : this.oExt.appendChild(fragment); //IE55
		
		//Select First Node....
		if(!me.isFocussed(this)) this.blur();
	}

	this.__findNode = function(cacheNode, id){
		if(!cacheNode) return document.getElementById(id);
		return cacheNode.getElementById(id);
	}
	
	this.__setClearMessage = function(msg){
		var oEmpty = XMLDatabase.htmlImport(this.__getLayoutNode("Empty"), this.oInt);
		var empty = this.__getLayoutNode("Empty", "caption", oEmpty);
		if(empty) empty.nodeValue = msg;
		if(oEmpty) oEmpty.setAttribute("id", "empty" + this.uniqueId);
	}
	
	this.__removeClearMessage = function(){
		var oEmpty = document.getElementById("empty" + this.uniqueId);
		if(oEmpty) oEmpty.parentNode.removeChild(oEmpty);
		else this.oInt.innerHTML = ""; //clear if no empty message is supported
	}
	
	this.inherit(Cache);
	this.caching = false;

	/************************
	  Other Inheritance
	************************/
	
	this.inherit(Presentation);
	this.inherit(DataBinding);
	
	this.keyHandler = this.__keyHandler;

	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);
		
		this.layout = new Layout(this.oExt);
	}
	
	this.__loadJML = function(x){
	}
}

/*FILEHEAD(/in/Components/Lineselect.js)SIZE(3590)TIME(1155654515941)*/

/*FILEHEAD(/in/Components/List.js)SIZE(3716)TIME(1182723583203)*/
	
function List(pHtmlNode){
	Kernel.register(this, "List", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
			  RENAME
	************************/
	
	this.__getCaptionElement = function(){
		var x = this.__getLayoutNode("Item", "caption", this.selected);
		return x.nodeType == 1 ? x : x.parentNode;
	}
	
	this.addEventListener("onafterselect",function(e){
		if(this.hasFeature(__VALIDATION__)) this.validate();
	});
	
	/************************
	  Other Inheritance
	************************/
	this.inherit(BcList);
	
	this.keyHandler = this.__keyHandler;
	
	this.inherit(Rename);
	
	/************************
			DRAGDROP
	************************/
	
	this.__showDragIndicator = function(sel, e){
		var x = e.offsetX;
		var y = e.offsetY;

		this.oDrag.startX = x;
		this.oDrag.startY = y;

		
		document.body.appendChild(this.oDrag);
		//this.oDrag.getElementsByTagName("DIV")[0].innerHTML = this.selected.innerHTML;
		//this.oDrag.getElementsByTagName("IMG")[0].src = this.selected.parentNode.parentNode.childNodes[1].firstChild.src;
		this.__updateNode(this.value, this.oDrag);
		
		return this.oDrag;
	}
	
	this.__hideDragIndicator = function(){
		this.oDrag.style.display = "none";
	}
	
	this.__moveDragIndicator = function(e){
		this.oDrag.style.left = (e.clientX - this.oDrag.startX) + "px";
		this.oDrag.style.top = (e.clientY - this.oDrag.startY) + "px";
	}
	
	this.__initDragDrop = function(){
		if(!this.__hasLayoutNode("DragIndicator")) return;
		this.oDrag = XMLDatabase.htmlImport(this.__getLayoutNode("DragIndicator"), document.body);
		
		this.oDrag.style.zIndex = 1000000;
		this.oDrag.style.position = "absolute";
		this.oDrag.style.cursor = "default";
		this.oDrag.style.display = "none";
	}
	
	this.__dragout = 
	this.__dragover = 
	this.__dragdrop = function(){}
	
	this.inherit(DragDrop);
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);

		/*this.oExt.onmousedown = function(e){
			if(!e) e = event;
			if(e.ctrlKey || e.shiftKey) return;
			
			var srcElement = IS_IE ? e.srcElement : e.target;
			debugger;
			if(this.host.allowDeselect && (srcElement == this || srcElement.getAttribute(XMLDatabase.htmlIdTag)))
				this.host.clearSelection(); //hacky
		}*/
		
		this.oExt.onclick = function(){
			this.host.dispatchEvent("onclick");
		}

		//Get Options form skin
		this.listtype = parseInt(this.__getLayoutNode("Main", "type")) || 1; //Types: 1=One dimensional List, 2=Two dimensional List
		this.behaviour = parseInt(this.__getLayoutNode("Main", "behaviour")) || 1; //Types: 1=Check on click, 2=Check independent
		this.hasCheckbox = this.__getLayoutNode("Main", "checkbox") ? true : false;
	}
	
	this.__loadJML = function(x){
		if(this.jml.childNodes.length) this.loadInlineData(this.jml);
		
		if(this.hasFeature(__MULTIBINDING__) && x.getAttribute("value")) this.setValue(x.getAttribute("value"));
		
		// this.doOptimize(true);
		
		if(x.getAttribute("multibinding") == "true" && !x.getAttribute("bind")) 
			this.inherit(MultiLevelBinding);
	}
	
	this.__destroy = function(){
		this.oExt.onclick = null;
		Kernel.removeNode(this.oDrag);
		this.oDrag = null;
	}
}

/*FILEHEAD(/in/Components/Menu.js)SIZE(11939)TIME(1182723583203)*/

function Menu(pHtmlNode){
	Kernel.register(this, "Menu", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/

	//Options
	this.focussable = false; // This object can't get the focus
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/
	
	this.display = function(x, y, noanim, opener){
		//TEMP SPEED enhancement
		//noanim = true;
		
		this.opener = opener;
		this.dispatchEvent("ondisplay");
		
		//this.draw(null, null, true);
		this.setPos(x, y);
		this.showMenu(noanim);
		
		/*if(event){
			event.cancelBubble = true;
		   event.returnValue  = false;
		}*/
	}
	
	this.setDisabled = function(list){
		if(!this.oExt) return (this.todo = list);
		var o = this.oExt.firstChild.firstChild;
		//this.showMenu(true);
		
		for(var i=0;i<list.length;i++){
			if(o.childNodes[i].disabled == list[i]) continue;
			o.childNodes[i].disabled = list[i];
			
			var q = o.childNodes[i].lastChild;//.previousSibling

			if(list[i] == false) enable(q);
			else if(list[i] == true) disable(q);
		}
	}
	
	this.setPos = function(x, y){
		/*dh = (this.oExt.offsetHeight+y) - document.body.clientHeight;
		dw = (this.oExt.offsetWidth+x)  - document.body.clientWidth;
		
		var px = x - (dw > 0 ? dw : 0) + document.body.scrollLeft;
		var py = y - (dh > 0 ? dh : 0) + document.body.scrollTop;
		
		if(!this.menuNode){
			this.oExt.style.display = "block";
			var diffX = (this.oExt.offsetWidth + x + this.parentNode.offsetLeft) - document.body.clientWidth;
			var diffY = (this.oExt.offsetHeight + y + this.parentNode.offsetTop) - document.body.clientHeight;
			this.oExt.style.display = "none";
		}*/
		
		this.oExt.style.left = x + "px";//px - (diffX > 0 ? diffX : 0);
		this.oExt.style.top = y + "px";//py - (diffY > 0 ? diffY : 0);
	}
	
	this.showMenu = function(noanim){
		if(noanim){
			//this.oExt.style.visibility = "visible";
			this.oExt.style.display = "block";
		}
		else{
			//this.oExt.style.visibility = "visible";
			this.oExt.style.display = "block";
			if(IS_IE) fadeIn(this.oExt, 0.15);
			else new GuiAnimation(this.oExt, 'fade', 0, 1, 0, 7, 10);
		}
		
		currentMenu = this;
	}
	
	this.hideMenu = function(hideOpener){
		this.oExt.style.display = "none";
		//this.oExt.style.visibility = "";
		
		this.hideSubMenu();
		
		currentMenu = null;
		
		if(hideOpener && this.opener) this.opener.hideMenu(true);
	}
	
	this.normalize = function(){
		this.hideMenu();
		for(var i=0;i<this.last.length;i++){
			//this.last[i].style.visibility = "";
			this.last[i].style.filter = "";
		}
	}
	
	this.setValue = function(value, matchCaption){
		var nodes = this.jml.childNodes;
		for(var i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1) continue;
			var tagName = nodes[i].tagName.replace(/^j\:/, "");
			if(tagName == "Item" && (matchCaption ? nodes[i].firstChild.nodeValue : nodes[i].getAttribute("value")) == value) this.value = nodes[i];
		}
	}
	
	this.clearSelection = function(){
		this.value = null;
	}
	
	this.select = function(o, id, subctx, e){
		if(isFading(o)) return;
		
		//if(e) this.evnt = e;
		
		this.setValue(o.firstChild.nodeValue, true);

		//if(!this.onselect) 
		this.hideMenu(true);
		
		this.dispatchEvent("onanyclick");
		this.dispatchEvent("onafterselect");
		
		if(o.getAttribute("action")){
			strfunc = o.getAttribute("action");
			if(IS_IE) strfunc = strfunc.split("\n")[2]
			eval(strfunc);
		}
		
		return;

		//var method = this.data[id];
		//this.oExt.style.visibility = "hidden";
		//o.style.visibility = "visible";
		//for(var i=0;i<this.oInt.childNodes.length;i++) this.oInt.childNodes[i].style.visibility = "visible";
		//(this.last = this.oInt.childNodes)
		this.last = [o];
		fadeOut(o, 0.30);
		setTimeout('Kernel.lookup('+this.uniqueId+').normalize()', 250);
		//if(typeof method == "function") method();
	}
	
	/************************
				Skin
	************************/
	
	this.__deInitNode = function(xmlNode, htmlNode){
		//Remove htmlNodes from tree
		htmlNode.parentNode.removeChild(htmlNode);
	}
	
	this.__updateNode = function(xmlNode, htmlNode){
		//Update Identity (Look)
		if(this.__getLayoutNode("Item", "icon", htmlNode)) 
			this.__getLayoutNode("Item", "icon", htmlNode).style.backgroundImage = "url(" + this.iconPath + this.applyRuleSetOnNode("Icon", xmlNode) + ")";
		else this.__getLayoutNode("Item", "Image", htmlNode).style.backgroundImage = "url(" + this.applyRuleSetOnNode("Image", xmlNode) + ")";
			
		this.__getLayoutNode("Item", "caption", htmlNode).nodeValue = this.applyRuleSetOnNode("Caption", xmlNode);
	}
	
	
	/************************
		Keyboard Support
	************************/
	
	//Handler for a plane list
	this.keyHandler = function(key, ctrlKey, shiftKey, altKey){
		if(!this.selected) return;
		//error after delete...

		switch(key){
			case 13:
				this.select(this.selected);
				if(this.onchoose) this.onchoose();
			break;
			case 37:
			//LEFT
			case 38:
			//UP
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				
				if(!this.value) return;
				var hasScroll = this.oExt.scrollHeight > this.oExt.offsetHeight;
				var items = Math.floor((this.oExt.offsetWidth - (hasScroll ? 15 : 0)) / (this.selected.offsetWidth+margin[1]+margin[3]));
				var node = this.getNextTraverseSelected(this.value, false, items);
				if(node) this.select(node);
				
				if(this.selected.offsetTop < this.oExt.scrollTop)
					this.oExt.scrollTop = this.selected.offsetTop - margin[0];
			break;
			case 39:
			//RIGHT
			case 40:
			//DOWN
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				
				if(!this.value) return;
				var hasScroll = this.oExt.scrollHeight > this.oExt.offsetHeight;
				var items = Math.floor((this.oExt.offsetWidth - (hasScroll ? 15 : 0)) / (this.selected.offsetWidth+margin[1]+margin[3]));
				var node = this.getNextTraverseSelected(this.value, true, items);
				if(node) this.select(node);
				
				if(this.selected.offsetTop + this.selected.offsetHeight > this.oExt.scrollTop + this.oExt.offsetHeight)
					this.oExt.scrollTop = this.selected.offsetTop - this.oExt.offsetHeight + this.selected.offsetHeight + 10;
				
			break;
			default: 
			return;
		}
		
		return false;
	}
	
	
	this.inherit(Cache);

	/************************
			DATABINDING
	************************/
	
	this.nodes = [];
	
	this.__add = function(xmlNode, Lid, xmlParentNode, htmlParentNode, beforeNode){
		var item = this.addItem(
			this.applyRuleSetOnNode("Caption", xmlNode),
			this.applyRuleSetOnNode("Icon", xmlNode),
			this.applyRuleSetOnNode("Disabled", xmlNode),
			this.applyRuleSetOnNode("Submenu", xmlNode),
			this.applyRuleSetOnNode("Value", xmlNode)
		);
		
		item.setAttribute("id", Lid);
	}
	
	this.addItem = function(caption, icon, disabled, submenu, value, onclick){
		this.__getNewContext("Item");
		this.__getLayoutNode("Item", "caption").nodeValue = caption;
		//var elImage = this.__getLayoutNode("Item", "image");
		var elItem = this.__getLayoutNode("Item");
		//if(onclick) elItem.setAttribute("action", onclick);
		//if(elImage.nodeType == 1) elImage.setAttribute("style", "background-image:url(" + this.applyRuleSetOnNode("Image", xmlNode) + ")");
		//else elImage.nodeValue = this.applyRuleSetOnNode("Image", xmlNode);
		
		if(submenu) this.__setStyleClass(elItem, "submenu");
		
		elItem.setAttribute("onmouseup", 'Kernel.lookup(' + this.uniqueId + ').select(this, null, null, event)'); 
		elItem.setAttribute("onmouseover", 'var o = Kernel.lookup(' + this.uniqueId + ');o.__setStyleClass(this, "hover");' + (submenu ? 'o.showSubMenu(this, "' + submenu + '")' : 'o.hideSubMenu();')); 
		elItem.setAttribute("onmouseout", 'if(isChildOf(this, event.toElement ? event.toElement : event.explicitOriginalTarget))return;var o = Kernel.lookup(' + this.uniqueId + ');o.__setStyleClass(this, "", ["hover"]);' + (submenu && false ? 'o.hideSubMenu()' : "")); 
		if(onclick) elItem.setAttribute("onclick", onclick);
		
		this.nodes.push(elItem);
		
		return elItem;
	}
	
	this.hideSubMenu = function(){
		if(!this.showingSubMenu) return;
		self[this.showingSubMenu].oExt.style.display = "none";
		this.showingSubMenu = null;
	}
	
	this.showSubMenu = function(htmlNode, submenu){
		if(this.showingSubMenu == submenu) return;
		
		var pos = Kernel.compat.getAbsolutePosition(htmlNode);
		/*self[submenu].oExt.style.left = pos[0] + htmlNode.offsetWidth - 2;
		self[submenu].oExt.style.top = pos[1] - 2;
		self[submenu].oExt.style.display = "block";*/
		self[submenu].display(pos[0] + htmlNode.offsetWidth - 2, pos[1] - 2, false, this);
		
		this.showingSubMenu = submenu;
	}
	
	this.addDivider = function(){
		this.__getNewContext("Divider");
		
		this.nodes.push(this.__getLayoutNode("Divider"));
	}
	
	this.__fill = function(){
		XMLDatabase.htmlImport(this.nodes, this.oInt);
		this.nodes.length = 0;
	}
	
	/************************
	  Other Inheritance
	************************/
	
	this.inherit(Presentation);
	
	this.inherit(DataBinding);

	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal();
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);
		this.oExt.onmousedown = function(e){(e || event).cancelBubble = true;}
		
		//Build JML defined contents (if any
		var nodes = this.jml.childNodes;
		for(var i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1) continue;
			var tagName = nodes[i].tagName.replace(/^j\:/, "");

			if(tagName == "Item") this.addItem(nodes[i].firstChild.nodeValue, nodes[i].getAttribute("icon"), nodes[i].getAttribute("disabled"), nodes[i].getAttribute("submenu"), nodes[i].getAttribute("value"), nodes[i].getAttribute("onclick"));
			else if(tagName == "Divider") this.addDivider();
		}
		
		if(this.nodes.length) this.__fill();
	}
	
	this.__loadJML = function(x){}
}

function disable(o){
	/*if (D.readyState != "complete") {
		window.setTimeout("disable(" + el.id + ")", 100);	// If document not finished rendered try later.
		return;
	}*/
	
	//o.style.filter = "chroma(color=red) dropshadow(color=buttonhighlight, offx=1, offy=1)";
	o.innerHTML =	"<span style='background: buttonshadow; filter: chroma(color=red) dropshadow(color=buttonhighlight, offx=1, offy=1); width: 100%; height: 100%;'>" +
					"<span style='filter: mask(color=red); width: 100%; height: 100%;'>" +
					o.innerHTML +
					"</span>" +
					"</span>";
	
	//o.firstChild.firstChild.backgroundColor = "Transparent";				
	//o.firstChild.firstChild.filter = "gray() chroma(color=#ffffff) chroma(color=#fefefe) chroma(color=#fdfdfd) chroma(color=#fcfcfc) chroma(color=#fbfbfb) chroma(color=#fafafa) chroma(color=#f9f9f9) chroma(color=#f8f8f8) chroma(color=#f7f7f7) chroma(color=#f6f6f6) chroma(color=#f5f5f5) chroma(color=#f4f4f4) chroma(color=#f3f3f3)  mask(color=#010101);"
}

function enable(o){
	o.innerHTML = o.innerHTML.replace(/^<.*?><.*?>(.*)<.*?><.*?>$/, "$1");
}

/*****************

	NOT 100%..

*****************/

var currentMenu;

function isChildOf(parent, child){
	var nodes = parent.childNodes;
	for(var i=0;i<nodes.length;i++){
		if(nodes[i] == child) return true;
		else if(nodes[i].childNodes.length && isChildOf(nodes[i], child)) return true;
	}
	
	return false;
}
/*FILEHEAD(/in/Components/ModalWindow.js)SIZE(12854)TIME(1185133511901)*/

//Fix this to only include the widget support when needed is 6Kb

WinServer = {
	count : 9000,
	wins : [],
	
	setTop : function(win){
		win.setZIndex(this.count++);
		this.wins.remove(win);
		this.wins.push(win);
		return win;
	},
	
	setNext : function(){
		if(this.wins.length < 2) return;
		var nwin, start = this.wins.shift();
		do{
			if(this.setTop(nwin || start).visible) break;
			nwin = this.wins.shift();
		}while(start != nwin);
	},
	
	setPrevious : function(){
		if(this.wins.length < 2) return;
		this.wins.unshift(this.wins.pop());
		var nwin, start = this.wins.pop();
		do{
			if(this.setTop(nwin || start).visible) break;
			nwin = this.wins.pop();
		}while(start != nwin);
	},
	
	remove : function(win){
		this.wins.remove(win);	
	}
}

function ModalWindow(pHtmlNode, isWidget){
	Kernel.register(this, "ModalWindow", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	this.focussable = true;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	this.inherit(DelayedRender);
	
	this.editableParts = {"Main" : [["title","@title"]]};

	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	this.minWT = null;
	this.minHT = null;

	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.setCaption = function(caption){
		this.oTitle.nodeValue = caption;
	}
	
	this.setIcon = function(icon){
		if(this.oIcon.tagName.toLowerCase() == "img") this.oIcon.src = this.iconPath + icon;
		else this.oIcon.style.backgroundImage = "url(" + this.iconPath + ")";
	}
	
	this.display = function(center, x, y){
		this.setProperty("visible", true);
		
		if(x) this.oExt.style.left = x + "px";
		if(y) this.oExt.style.top = y + "px";
		if(center){
			this.oExt.style.left = Math.max(0,(((IS_IE ? document.documentElement.offsetWidth : window.innerWidth) - this.oExt.offsetWidth)/2)) + "px";
			this.oExt.style.top = Math.max(0,(((IS_IE ? document.documentElement.offsetHeight : window.innerHeight) - this.oExt.offsetHeight)/3)) + "px";
		}
		
		if(!this.isModal) WinServer.setTop(this);
	}
	
	this.close = function(){
		this.setProperty("visible", false);
	}
	
	var state = 0;//normal = 1, min = -1, max = 2
	this.min = function(){
		//toggle
		if(state < 0){
			state = 1;
			this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Min"]);
		}
		else{
			state = -1;
			this.__setStyleClass(this.oExt, this.baseCSSname + "Min");
		}
	}
	
	this.__handlePropSet = function(prop, value){
		switch(prop){
			case "visible":
				if(isTrue(value)){
					//if(!x && !y && !center) center = true;
			
					this.render();
					
					if(this.isModal){ 
						this.oCover.style.height = Math.max(document.body.scrollHeight,document.documentElement.offsetHeight)+'px';
						this.oCover.style.width = Math.max(document.body.scrollWidth,document.documentElement.offsetWidth)+'px';
						this.oCover.style.display = "block";
					}

					//!IS_IE && 
					if(LayoutServer) LayoutServer.forceResize(this.oInt); //this should be recursive down
					
					if(this.center){
						this.oExt.style.left = (((IS_IE ? document.documentElement.offsetWidth : window.innerWidth) - this.oExt.offsetWidth)/2) + "px";
						this.oExt.style.top = (((IS_IE ? document.documentElement.offsetHeight : window.innerHeight) - this.oExt.offsetHeight)/3) + "px";
					}
					
					if(!this.isRendered){
						this.addEventListener("onafterrender", function(){
							this.dispatchEvent("ondisplay");
							this.removeEventListener("ondisplay", arguments.callee);
						});
					}
					else this.dispatchEvent("ondisplay");
				}
				else{
					this.setProperty("visible", false);
					if(this.isModal) this.oCover.style.display = "none";
				}
			break;
		}
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/

	if(isWidget){
		//Should be moved to an init function
		this.positionHolder = document.body.appendChild(document.createElement("div"));
	
		this.winMouseDown = function(e){
			if(!e) e = event;
			MOVER = this;
			//Kernel.Plane.show(MOVER.host.showDragBox());
	
			this.coX = e.clientX;
			this.stX = this.host.oExt.offsetLeft - 10;
			this.coY = e.clientY;
			this.stY = this.host.oExt.offsetTop - 10;
	
			var htmlNode = this.host.oExt;
			var p = this.host.positionHolder;
			p.className = "position_holder"
			
			htmlNode.parentNode.insertBefore(p, htmlNode);
			//p.style.width = (htmlNode.offsetWidth - 2) + "px";
			p.style.height = (htmlNode.offsetHeight - 2) + "px";
			
			var diff = [2, 19];//Kernel.compat.getDiff(htmlNode);
			var lastSize = [htmlNode.style.width, htmlNode.style.height];
			htmlNode.style.width = (htmlNode.offsetWidth - diff[0]) + "px";
			//htmlNode.style.height = (htmlNode.offsetHeight - diff[1]) + "px";
			var toX = e.clientX - this.coX + this.stX;
			var toY = e.clientY - this.coY + this.stY;
			htmlNode.style.left = toX + "px";
			htmlNode.style.top = toY + "px";
			htmlNode.style.position = "absolute";
			htmlNode.style.zIndex = htmlNode.parentNode.style.zIndex = 100000;
			Animate.fade(htmlNode, 0.6);
	
			document.cData = [htmlNode, p];
			document.onmousemove = this.host.winMouseMove;
			document.onmouseup = function(){
				document.onmousemove = document.onmouseup = null;
				
				htmlNode.style.position = "static";
				htmlNode.style.width = lastSize[0];
				//htmlNode.style.height = lastSize[1];
				htmlNode.style.zIndex = htmlNode.parentNode.style.zIndex = 1;
				p.parentNode.insertBefore(htmlNode, p);
				p.parentNode.removeChild(p);
				Animate.fade(htmlNode, 1);
				
				//MOVER.host.hideDragBox();
				//Kernel.Plane.hide();
				//MOVER.host.set_Top();
			}
			
			//REALLY DIRTY SOLUTION
			//winAbout.hide();
			e.cancelBubble = true;
			return false;
		}
		
		function insertInColumn(el, ey){
			//search for position
			var pos = Kernel.compat.getAbsolutePosition(el);
			var cy = ey - pos[1];
			var nodes = el.childNodes;
			for(var th=0,i=0;i<nodes.length;i++){
				if(nodes[i].nodeType != 1 || Kernel.getStyle(nodes[i], "position") == "absolute") continue;
				th = nodes[i].offsetTop + nodes[i].offsetHeight;
				if(th > cy){
					if(th - (nodes[i].offsetHeight/2) > cy)
						el.insertBefore(document.cData[1], nodes[i]);
					else
						el.insertBefore(document.cData[1], nodes[i].nextSibling);
					break;	
				}
			}
			if(i == nodes.length) el.appendChild(document.cData[1]);	
		}
		
		this.winMouseMove = function(e){
			if(!e) e = event;
			
			var o = MOVER;
			
			var toX = e.clientX - o.coX + o.stX;
			var toY = e.clientY - o.coY + o.stY;
			
			var db = MOVER.host.oExt;//.host.showDragBox();
			
			//status = "(" + toX + ", " + toY + ")";
			
			db.style.top = "10000px";
			var ex = e.clientX+document.documentElement.scrollLeft;
			var ey = e.clientY+document.documentElement.scrollTop;
			var el = document.elementFromPoint(ex, ey);
			if(el.isColumn){
				insertInColumn(el, ey);
			}
			else{
				//search for element
				while(el.parentNode && !el.isColumn){
					el = el.parentNode;
				}
				if(el.isColumn) insertInColumn(el, ey);
				else status = "notfound" + new Date();
			}
			
			db.style.left = toX + "px";
			db.style.top = toY + "px";
			
			e.cancelBubble = true;
		}
	}
	else{
		this.winMouseDown = function(e){
			if(!this.host.draggable) return;
			
			if(!e) e = event;
			MOVER = this;
			//Kernel.Plane.show(MOVER.host.showDragBox());
	
			this.coX = e.clientX;
			this.stX = this.host.oExt.offsetLeft;
			this.coY = e.clientY;
			this.stY = this.host.oExt.offsetTop;
	
			document.onmousemove = this.host.winMouseMove;
			document.onmouseup = function(){
				document.onmousemove = document.onmouseup = null;
				
				//MOVER.host.hideDragBox();
				//Kernel.Plane.hide();
				//MOVER.host.set_Top();
			}
			
			return false;
		}
		
		this.winMouseMove = function(e){
			if(!e) e = event;
			
			var o = MOVER;
			
			var toX = e.clientX - o.coX + o.stX;
			var toY = e.clientY - o.coY + o.stY;
			
			var db = MOVER.host.oExt;//.host.showDragBox();
			
			//status = "(" + toX + ", " + toY + ")";
			
			db.style.left = toX + "px";
			db.style.top = toY + "px";
			
			//e.cancelBubble = true;
		}
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.setZIndex = function(value){
		this.oExt.style.zIndex = value + 1;
		if(this.isModal) this.oCover.style.zIndex = value;
	}

	function addButton(prop, type, func, oButtons){
		if(!this[prop]) this[prop] = this.jml.getAttribute(prop) == "true";
		if(this[prop]){
			this.__getNewContext(type);
			var btn = oButtons.appendChild(this.__getLayoutNode(type));
			btn.setAttribute("onclick", func);
		}
	}
	
	this.draw = function(){
		this.oExt = this.__getExternal(null, null, function(oExt){
			var oButtons = this.__getLayoutNode("Main", "buttons", oExt);
			
			addButton.call(this, "btnclose", "CloseBtn", "Kernel.lookup(" + this.uniqueId + ").close()", oButtons);
			addButton.call(this, "btnmin", "MinBtn", "Kernel.lookup(" + this.uniqueId + ").min()", oButtons);
			addButton.call(this, "btnmax", "MaxBtn", "Kernel.lookup(" + this.uniqueId + ").close()", oButtons);
			addButton.call(this, "btnedit", "EditBtn", "Kernel.lookup(" + this.uniqueId + ").dispatchEvent('onedit')", oButtons);
		});
		this.oTitle = this.__getLayoutNode("Main", "title", this.oExt);
		this.oIcon = this.__getLayoutNode("Main", "icon", this.oExt);
		this.oDrag = this.__getLayoutNode("Main", "drag", this.oExt);

		var oCover = this.__getLayoutNode("Cover");
		if(oCover){
			this.oCover = XMLDatabase.htmlImport(oCover, this.pHtmlNode);
			this.oCover.style.display = "none";
		}
		
		this.movable = this.jml.getAttribute("movable") != "false";
		if(this.movable) this.oDrag.onmousedown = this.winMouseDown;
		this.oDrag.host = this;
		
		if(this.hasFeature(__MULTILANG__)) this.__makeEditable("Main", this.oExt, this.jml);
	}
	
	this.__loadJML = function(x, skinName){
		if(x.getAttribute("minwidth")) this.minWT = x.getAttribute("minwidth");
		if(x.getAttribute("minheight")) this.minHT = x.getAttribute("minheight");
		
		if(x.getAttribute("title")) this.setCaption(x.getAttribute("title"));
		if(x.getAttribute("icon")) this.setIcon(x.getAttribute("icon"));
		if(x.getAttribute("center")) this.center = x.getAttribute("center") == "true";
		//if(x.getAttribute("zindex")) this.setZIndex(x.getAttribute("zindex"));
		
		this.isModal = this.oCover && (x.getAttribute("modal") != "false");
		
		this.draggable = x.getAttribute("draggable") != "false";
		
		if(!this.isModal){
			this.oExt.onmousedown = function(e){
				WinServer.setTop(this.host);
				//(e || event).cancelBubble = true;
			}
		}
		
		WinServer.setTop(this);
		
		var oInt = this.__getLayoutNode("Main", "container", this.oExt);
		var oSettings = this.__getLayoutNode("Main", "settings", this.oExt);
			
		//PresentationServer.defaultSkin = skinName;

		if(!isWidget){
			this.oInt = this.oInt ? 
				Application.replaceNode(oInt, this.oInt) : 
				Application.loadSubNode(this.jml, oInt, this, true);
		}
		else{
			var oConfig = XMLDatabase.selectSingleNode("j:Config", this.jml);
			oConfig.parentNode.removeChild(oConfig);
			var oBody = XMLDatabase.selectSingleNode("j:Body", this.jml);
			oBody.parentNode.removeChild(oBody);

			Application.loadSubNode(this.jml, null, this);
			
			this.jml.appendChild(oConfig);
			this.jml.appendChild(oBody);
		
			if(oSettings){
				this.oSettings = this.oSettings ? 
					Application.replaceNode(oSettings, this.oSettings) : 
					Application.loadSubNode(oConfig, oSettings, this, true);
			}
			
			this.oInt = this.oInt ? 
				Application.replaceNode(oInt, this.oInt) : 
				Application.loadSubNode(oBody, oInt, this, true);
		}
		
		//PresentationServer.defaultSkin = null;
		
		this.close();
	}	
	
	this.__destroy = function(){
		this.oDrag.host = null;
		Kernel.removeNode(this.oDrag);
		this.oDrag = null;
		this.oTitle = null;
		this.oIcon = null;
		this.oCover = null;
		this.oExt.onmousedown = null;
	}
}
/*FILEHEAD(/in/Components/Pages.js)SIZE(907)TIME(1181922744090)*/

function Pages(pHtmlNode){
	Kernel.register(this, "Pages", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  Other Inheritance
	************************/
	this.inherit(BcTab);
	this.inherit(Presentation);
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal();
		this.oPages = this.__getLayoutNode("Main", "pages", this.oExt);
	}
	
	this.__loadJML = function(x){
		this.switchType = x.getAttribute("switch-type") || "incremental";
		
		this.__drawTabs();
	}
}
/*FILEHEAD(/in/Components/Palette.js)SIZE(3457)TIME(1179307594016)*/

function Palette(pHtmlNode){
	Kernel.register(this, "Palette", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	this.inherit(DataBinding);
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/

	//Options
	this.focussable = true; // This object can get the focus
	this.value = null;
	this.inherit(Validation);
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/

	this.setValue = function(value){
		this.value = value;
		
		this.oViewer.style.backgroundColor = value;
	}
	
	this.getValue = function(){
		return this.value ? this.value.nodeValue : "";
	}
	
	this.addColor = function(clr, oContainer){
		if(!oContainer) oContainer = this.oCustom;
		
		var oItem = this.__getLayoutNode("Item");
		
		if(oContainer == this.oCustom){
			oItem.setAttribute("onmousedown", "Kernel.lookup(" + this.uniqueId + ").doCustom(this)");
			oItem.setAttribute("ondblclick", "Kernel.lookup(" + this.uniqueId + ").doCustom(this, true)");
		}
		else oItem.setAttribute("onmousedown", "Kernel.lookup(" + this.uniqueId + ").Change(this.style.backgroundColor.replace(/^#/, ''))");
		
		oItem = XMLDatabase.htmlImport(oItem, oContainer, null, true);
		this.__getLayoutNode("Item", "background", oItem).style.backgroundColor = clr;
	}
	
	this.setCustom = function(oItem, clr){
		oItem.style.backgroundColor = clr;
		this.Change(clr);
	}
	
	this.doCustom = function(oItem, force_create){
		if(force_create || oItem.style.backgroundColor == "#ffffff"){
			this.dispatchEvent("oncreatecustom", oItem);
		}
		else this.Change(oItem.style.backgroundColor.replace(/^#/, ""));
	}
	
	/************************
		Keyboard Support
	************************/
	
	this.keyHandler = function(key){}
	
	this.__focus = function(){
	}
	
	this.__blur = function(){
	}
	
	this.focussable = true;
	
	/************************
			Databinding
	************************/
	this.mainBind = "Value";
	this.defaultValue = "ff0000";
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);

	this.colors = [
		"fc0025", "ffd800", "7dff00", "32ffe0", "0026ff", "cd00ff", "ffffff", "e5e5e5", "d9d9d9",
		"de003a", "ffc600", "009022", "00bee1", "003e83", "dc0098", "737373", "666666", "000000"
	];
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal();
		this.oViewer = this.__getLayoutNode("Main", "viewer", this.oExt);
		this.oStandard = this.__getLayoutNode("Main", "standard", this.oExt);
		this.oCustom = this.__getLayoutNode("Main", "custom", this.oExt);
		
		for(var i=0;i<this.colors.length;i++) this.addColor(this.colors[i], this.oStandard);
		for(var i=0;i<9;i++) this.addColor("ffffff");

		//this.oViewer.setAttribute("ondblclick", "Kernel.lookup(" + this.uniqueId + ").openColorPicker()");
	}
	
	this.__loadJML = function(x){
		this.name = x.getAttribute("id");
		this.inline = x.getAttribute("inline") == "true";
		this.direction = x.getAttribute("direction") || "down";
	}
}
/*FILEHEAD(/in/Components/Progressbar.js)SIZE(3043)TIME(1183730063251)*/

function Progressbar(pHtmlNode){
	Kernel.register(this, "Progressbar", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;

	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	this.inherit(DataBinding);

	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.focussable = true; // This object can get the focus

	/****************
		API
	****************/
	this.value = 0;
	this.min = 0;
	this.max = 1;
	
	this.setCaption = function(value){
		this.oCaption.nodeValue = value;
	}
	
	this.getValue = function(){
		return this.value;
	}
	
	this.setValue = function(value){
		this.value = parseInt(value);
		this.oSlider.style.width = Math.max(0, Math.round((this.oExt.offsetWidth-5) * (value/(this.max-this.min)))) + "px";
		
		this.setCaption(Math.round((value/(this.max-this.min))*100) + "%");
	}
	
	this.clear = function(restart, restart_time){
		this.dispatchEvent("onclear");
		
		clearInterval(this.timer);
		this.setValue(this.min);
		this.oSlider.style.display = "none";
		this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Running"]);
		
		if(restart) this.timer = setInterval("Kernel.lookup(" + this.uniqueId + ").start(" + restart_time + ")");
	}
	
	this.start = function(time){
		clearInterval(this.timer);
		this.oSlider.style.display = "block";
		this.timer = setInterval("Kernel.lookup(" + this.uniqueId + ").__step()", time || 1000);
		this.__setStyleClass(this.oExt, this.baseCSSname + "Running");
	}
	
	this.__step = function(){
		if(this.value == this.max) return;
		this.setValue(this.value + 1);
	}
	
	this.pause = function(){
		clearInterval(this.timer);
	}
	
	this.stop = function(restart, time, restart_time){
		clearInterval(this.timer);
		this.setValue(this.max);
		this.timer = setTimeout("Kernel.lookup(" + this.uniqueId + ").clear(" + restart + ", " + (restart_time || 0) + ")", time || 500);
	}
	
	this.__supportedProperties = ["value"];
	this.__handlePropSet = function(prop, value){
		switch(prop){
			case "value":
				this.setValue(value);
			break;
		}
	}
	
	/**********
		INIT
	**********/
	
	/****************
		Init
	****************/
	this.inherit(JmlNode);
	
	this.draw = function(clear, parentNode, Node, transform){
		//Build Main Skin
		this.oExt = this.__getExternal();
		this.oSlider = this.__getLayoutNode("Main", "progress", this.oExt);
		this.oCaption = this.__getLayoutNode("Main", "caption", this.oExt);
	}
	
	this.__loadJML = function(x){
		//this.setCaption(x.firstChild ? x.firstChild.nodeValue : "");
		this.min = x.getAttribute("min") || 0;
		this.max = x.getAttribute("max") || 100;
		
		if(x.getAttribute("autostart")) this.start();
	}
}


/*FILEHEAD(/in/Components/Radiobutton.js)SIZE(10045)TIME(1188383718500)*/

function Radiogroup(oChild){
	Kernel.register(this, "Radiogroup", GUI_NODE);
	//this.tagName = "Radiogroup";
	//this.nodeType = GUI_NODE;
	//this.uniqueId = Kernel.all.push(this) - 1;
	//this.jml = oChild.jml.parentNode.insertBefore(oChild.jml.cloneNode(true), oChild.jml);
	//this.jml.removeAttribute("value");
	this.pHtmlNode = oChild.pHtmlNode
	
	this.inherit(DataBinding);

	this.radiobuttons = [];
	this.inherit(Validation);
	this.isShowing = true;
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/

	this.addRadio = function(oRB){
		this.radiobuttons.push(oRB);
		if(!this.isShowing){
			oRB.hide();
			//if(oRB.tNode)
				//oRB.tNode.style.display = "none";
		}
	}
	
	this.setValue = function(value){
		for(var i=0;i<this.radiobuttons.length;i++){
			if(this.radiobuttons[i].check_value	== value){
				var oRB = this.radiobuttons[i];
				if(this.current && this.current != oRB) 
					this.current.uncheck();
				oRB.check();
				this.current = oRB;
				break;
			}
		}

		return this.setProperty("value", value);
		//return false;
	}

	this.setCurrent = function(oRB){
		if(this.current && this.current != oRB) this.current.uncheck();
		this.value = oRB.check_value;
		oRB.check();
		this.current = oRB;
	}

	this.getValue = function(){
		return this.current ? this.current.check_value : "";
	}
	
	this.__setCurrent = function(oRB){
		if(this.current) this.current.uncheck();
		this.current = oRB;
		this.value = oRB.check_value;
		this.Change(oRB.check_value);
	}
			
	this.disable = function(){
		for(var i=0;i<this.radiobuttons.length;i++){
			this.radiobuttons[i].disable();
		}
	}
	
	this.enable = function(){
		for(var i=0;i<this.radiobuttons.length;i++){
			this.radiobuttons[i].enable();
		}
	}
	
	this.setZIndex = function(value){
		for(var i=0;i<this.radiobuttons.length;i++){
			this.radiobuttons[i].setZIndex(value);
		}
	}
	
	this.show = function(){
		this.isShowing = true;
		for(var i=0;i<this.radiobuttons.length;i++){
			this.radiobuttons[i].show();
			//if(this.radiobuttons[i].tNode)
				//this.radiobuttons[i].tNode.style.display = "block";
		}
	}
	
	this.hide = function(){
		this.isShowing = false;
		for(var i=0;i<this.radiobuttons.length;i++){
			this.radiobuttons[i].hide();
			//if(this.radiobuttons[i].tNode)
				//this.radiobuttons[i].tNode.style.display = "none";
		}
	}
	
	this.focus = this.blur = function(){}
	
	//These should be moved to inside the form
	this.isValid = function(checkRequired){
		if(checkRequired && this.required){
			var value = this.getValue();
			if(!value || value.toString().length == 0) return false;
		}
		
		//for(var i=0;i<vRules.length;i++) if(!eval(vRules[i])) return false;
		//if(this.vRules.length) return eval("(" + this.vRules.join(") && (") + ")");
		return true;
	}
	
	this.init = function(oRB){
		if(this.inited) return;
		
		x = oRB.jml;//.cloneNode(true);//.parentNode.insertBefore(oRB.jml.cloneNode(true), oChild.jml);
		//x.removeAttribute("value");
		this.oExt = oRB.oExt;
		
		//this.processBindclass = oRB.processBindclass;
		//this.processBindclass(x);
		
		this.jml = x;
		
		//this.setCurrent(oRB);
		this.inited = true;
		
		return this;
	}
	
	this.init(oChild);
	
	this.__supportedProperties = ["value"];
	this.__handlePropSet = function(prop, value){
		switch(prop){
			case "value":
				// Set Value
				for(var i=0;i<this.radiobuttons.length;i++){
					if(this.radiobuttons[i].check_value	== value)
						return this.setCurrent(this.radiobuttons[i]);
				}
			break;
		}
	}
	
	this.draw = function(){}
	this.inherit(JmlNode);
	//if(self.Validation) this.inherit(Validation);
	this.loadJML(this.jml);
}

function Radiobutton(pHtmlNode){
	Kernel.register(this, "Radiobutton", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/	
	this.inherit(Presentation);
	
	this.editableParts = {"Main" : [["label","text()"]]};
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.focussable = true; // This object can get the focus
	this.inherit(Validation);
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/

	this.setValue = function(value){
		this.check_value = value;
	}
	
	this.getValue = function(){
		return this.checked ? this.check_value : null;
	}
	
	this.setError = function(value){
		this.__setStyleClass(this.oExt, this.baseCSSname + "Error");
	}
	
	this.clearError = function(value){
		this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Error"]);
	}
	
	this.__enable = function(){
		if(this.oInt) this.oInt.disabled = false;
		
		if(this.oExt.tagName.toLowerCase() == "input"){
			this.oExt.onclick = function(){
				this.host.dispatchEvent("onclick");
				if(this.checked){
					//this.host.oContainer.setValue(this.host.check_value);
					this.host.oContainer.current = this.host;
					this.host.oContainer.Change(this.host.check_value);
				}
				//if(this.checked) this.host.oContainer.__setCurrent(this.host);
			}
		}
		else{
			this.oExt.onclick = function(){
				this.host.dispatchEvent("onclick");
				//this.host.oContainer.setValue(this.host.check_value);
				this.host.oContainer.current = this.host;
				this.host.oContainer.Change(this.host.check_value);
				//this.host.oContainer.__setCurrent(this.host);
			}
		}
	}
	
	this.__disable = function(){
		if(this.oInt) this.oInt.disabled = true;
		this.oExt.onclick = null
	}
	
	this.doBgSwitch = function(nr){
		if(this.bgswitch && (this.bgoptions[1] >= nr || nr == 4)){
			if(nr == 4) nr = this.bgoptions[1] + 1;
			
			var strBG = this.bgoptions[0] == "vertical" ? 
				"0 -" + (parseInt(this.bgoptions[2])*(nr-1)) + "px": 
				"-" + (parseInt(this.bgoptions[2])*(nr-1)) + "px 0";

			this.__getLayoutNode("Main", "background", this.oExt).style.backgroundPosition = strBG;
		}
	}
	
	this.check = function(){
		this.__setStyleClass(this.oExt, this.baseCSSname + "Checked");
		this.checked = true;
		if(this.oInt.tagName.toLowerCase() == "input")
			this.oInt.checked = true;
		this.doBgSwitch(2);
	}
	
	this.uncheck = function(){
		this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Checked"]);
		this.checked = false;
		if(this.oInt.tagName.toLowerCase() == "input")
			this.oInt.checked = false;
		this.doBgSwitch(1);
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/

	/************************
		Keyboard Support
	************************/
	
	this.keyHandler = function(key){
		this.dispatchEvent("onkeypress", key);
		
		if(key == 13 || key == 32){
			//this.check();
			this.oContainer.current = this;
			this.oContainer.Change(this.check_value);
		}
	}
	
	/************************
				Focus
	************************/
	
	this.__focus = function(){
		if(!this.oExt) return;
		if(this.oInt && this.oInt.disabled) return false;
		
		this.__setStyleClass(this.oExt, this.baseCSSname + "Focus");
	}
	
	this.__blur = function(){
		if(!this.oExt) return;
		this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Focus"]);
	}
	
	this.focussable = true;

	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(null, null, function(oExt){
			var oInt = this.__getLayoutNode("Main", "input", oExt);
			if(oInt.tagName.toLowerCase() == "input") oInt.setAttribute("name", this.jml.getAttribute("id"));
		});
		this.oInt = this.__getLayoutNode("Main", "input", this.oExt);
		
		if(this.jml.firstChild){
			this.tNode = this.__getLayoutNode("Main", "label", this.oExt);
			if(!this.tNode){
				this.tNode = document.createElement("span");
				this.tNode.className = "labelfont";
				pHtmlNode.insertBefore(this.tNode, this.oExt.nextSibling);
			}
			
			this.tNode.innerHTML = (!IS_IE && !IS_GECKO ? this.jml.serialize() : this.jml.xml) || this.jml.innerHTML;
		}
		
			this.__makeEditable("Main", this.oExt, this.jml);
		
		this.enable();

		if(self[this.jml.getAttribute("id")].tagName != "Radiogroup"){
			var oC = new Radiogroup(this);
			oC.name = this.jml.getAttribute("id");
			oC.labelEl = this.labelEl;
			oC.errBox = this.errBox;
			oC.parentNode = this.parentNode;
			
			self[oC.name] = oC;
		}
		
		this.oContainer = self[this.jml.getAttribute("id")];
		this.oContainer.addRadio(this);
		this.processBindclass = function(){}
	}

	this.__loadJML = function(x){
		this.name = x.getAttribute("id");
		this.check_value = x.getAttribute("value");
		
		this.bgswitch = x.getAttribute("bgswitch") ? true : false;
		if(this.bgswitch){
			this.__getLayoutNode("Main", "background", this.oExt).style.backgroundImage = "url(" + this.mediaPath + x.getAttribute("bgswitch") + ")";
			this.__getLayoutNode("Main", "background", this.oExt).style.backgroundRepeat = "no-repeat";

			this.bgoptions = x.getAttribute("bgoptions") ? x.getAttribute("bgoptions").split("\|") : ["vertical", 2, 16];
			if(!this.bgoptions[2]) this.bgoptions[2] = parseInt(this.jml.getAttribute("height"));
		}
		
		this.form = this.oContainer.form;
		
		if(x.getAttribute("checked") == "true") this.oContainer.setValue(this.check_value);//setCurrent(this);
	}
}

/*FILEHEAD(/in/Components/RichTextEditor.js)SIZE(6529)TIME(1181917074721)*/

function RichTextEditor(pHtmlNode){
	Kernel.register(this, "RichTextEditor", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;

	/************************
	  		Inheritance
	************************/
	//this.inherit(Presentation);
	this.inherit(DataBinding);
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.focussable = true; // This object can get the focus
	this.inherit(Validation);
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	/****************
		API
	****************/
	
	this.getValue = function(textonly){
		var value = this.router.getActiveEditor().getValue();
		return textonly ? value.replace(/<[^>]+>/, "") : value;
	}
	
	this.setValue = function(value){
		if(!this.router) return this.value = value;
		this.router.getActiveEditor().setValue(value);
	}
	
	this.getValueList = function(){
		return this.router.getValue();
	}
	
	this.setValueList = function(){
		this.router.setValue(arguments);
	}
	
	this.setEditorHTML = function(id, html){
		this.router.getEditor(id).setValue(html);
	}
	
	this.getEditor = function(id){
		return this.router.getEditor(id);
	}
	
	this.selectAll = function(){
		this.router.getActiveEditor().selectAll();
	}
	
	this.insertImage = function(path){
		this.router.getActiveEditor().insertImage(path);
	}
	
	/****************
		PRIVATE
	****************/
	
	this.exec = function(value, gui, type){
		var Editor = this.router.getActiveEditor();
		if(!Editor) return alert("Please select an area to edit");
		
		//Font Color
		if(value == "ForeColor"){
			var sColor = this.dlgHelper.ChooseColorDlg(this.oDoc.queryCommandValue(value));
			sColor = sColor.toString(16);
			if(sColor.length < 6) sColor = "000000".substring(0,6-sColor.length).concat(sColor);
			this.oDoc.execCommand(value, false, sColor);
		}
		//Execute a standard command
		else this.oDoc.selection.createRange().execCommand(value, true, type);
		
		//Check for possible Local Images
		if(value == "InsertImage") Editor.fixContent();
		
		//Set Buttons
		this.redoButtons();
		
		this.Change(this.getValue());
	}
	
	this.redoButtons = function(){
		if(!this.toolbar) return;

		//Sync Buttons with current selection
		var bar = this.toolbar.bars[0].children;
		for(var i=0;i<bar.length;i++){
			if(bar[i].tagName != "Button" || !bar[i].isBoolean) continue;
			bar[i].setValue(this.oDoc.queryCommandValue(bar[i].sValue));
		}
	}
	
	/****************
		FOCUS
	****************/
	
	this.keyHandler = function(){}
	
	this.__focus = function(){
		if(this.oExt){
			//this.oExt.contentEditable = true;
			this.oExt.firstChild.contentWindow.focus();
			this.router.focus();
			
			return false;
		}
	}
	
	this.__blur = function(){
		//this.oExt.contentWindow.blur();
		//document.body.click();//focus();
		//this.oDoc.body.focus();
		//this.oExt.contentEditable = false;
	}
	
	this.focussable = true;
	
	/****************
		XML Support
	****************/
	
	this.__load = function(XMLRoot, id){
		//Add listener to XMLRoot Node
		XMLDatabase.addNodeListener(XMLRoot, this);
		
		var value = this.applyRuleSetOnNode("Value", XMLRoot);
		this.setValue(value || "");
	}
	
	this.__xmlUpdate = function(action, xmlNode, listenNode, UndoObj){
		//Action Tracker Support
		if(UndoObj) UndoObj.xmlNode = this.XMLRoot;
		
		var value = this.applyRuleSetOnNode("Value", this.XMLRoot);
		if(value != this.getValue()) this.setValue(value || "");
	}
	
	this.inherit(DataBinding);
	
	/****************
		INIT
	****************/
	this.inherit(JmlNode);
	
	this.register = function(o){
		this.router = o;
		this.router.host = this;
		
		if(this.template) this.router.load(this.template);
		else this.router.Init();
		
		if(this.value) this.setValue(this.value);
	}
	
	this.draw = function(clear, parentNode){
		//Setup IFRAME
		this.oExt = this.pHtmlNode.appendChild(document.createElement("DIV"));
		this.oExt.style.width = "100px";
		this.oExt.style.height = "100px";
		this.oExt.innerHTML = "<IFRAME id='me" + this.uniqueId + "' src='empty.html' width='100%' height='100%'></IFRAME>";//));

		//Initialize Iframe
		var win = this.pHtmlDoc.getElementById("me" + this.uniqueId).contentWindow;//Kernel.compat.initializeIframe("me" + this.uniqueId, strInit);
		this.oDoc = win.document;
		
		if(IS_IE){
			var strInit = "<html><head><style>BODY{background-color:white;} P{margin : 0px;} BODY{background-color:white;margin:0px;overflow:auto;}</style><script>HOST=" + this.uniqueId + "</script><script src='" + BASEPATH + "Library/Widgets/RTEHelper.js'></script><script src='" + BASEPATH + "Library/Widgets/RTETemplateViewer.js'></script></head><body></body>";
			
			this.oDoc.open();
			this.oDoc.write(strInit);
			this.oDoc.close();
		}

		this.oDoc.onkeydown = this.oDoc.onmousedown = this.oDoc.onmouseup = this.oDoc.onclick = function(e){}
		
		if(IS_IE){
			document.body.insertAdjacentHTML("beforeend", "<OBJECT id=dlgHelper CLASSID='clsid:3050f819-98b5-11cf-bb82-00aa00bdce0b' width='0px' height='0px'></OBJECT>");
			this.dlgHelper = document.getElementById("dlgHelper");
		}

		//this.oDoc.body.
		this.oExt.firstChild.host = 
		this.oExt.host = this;
		
		//Prevent selection from outside elements
		for(var i=0;i<document.all.length;i++){
			//if(document.all[i].tagName.toLowerCase() != "input" && document.all[i].tagName.toLowerCase() != "select") document.all[i].unselectable = "On";
			//else document.all[i].unselectable = "Off";
		}
	}
	
	this.__loadJML = function(x){
		// XML Options for later: Overflow, Font 
		this.template = x.getAttribute("template") || null;
		this.toolbar = x.getAttribute("toolbar")  ? self[x.getAttribute("toolbar")] : false;

		if(x.firstChild) this.setValue(x.innerHTML || (IS_IE ? x.firstChild.xml : x.xml));
	}
	
	this.__destroy = function(){
		this.router.host = null;
		this.oDoc.onkeydown = this.oDoc.onmousedown = this.oDoc.onmouseup = this.oDoc.onclick = null;
		this.oExt.firstChild.host = null;
	}
}


/*FILEHEAD(/in/Components/RTEHelper.js)SIZE(5332)TIME(1165249311419)*/

/*FILEHEAD(/in/Components/RTETemplateViewer.js)SIZE(2173)TIME(1154558873328)*/

/*FILEHEAD(/in/Components/Slider.js)SIZE(5397)TIME(1181917074721)*/
function Slider(pHtmlNode){
	Kernel.register(this, "Slider", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;

	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	this.inherit(DataBinding);
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.focussable = true; // This object can get the focus
	this.disabled = false; // Object is enabled
	this.inherit(Validation);
	this.value = 0;
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.setValue = function(value){
		this.value = Math.max(0, Math.min(1, value));

		if(this.direction == "horizontal"){
			var max = parseInt(Kernel.compat.getStyle(this.oContainer, "width")) - this.oSlider.offsetWidth;
			var min = parseInt(Kernel.compat.getBox(Kernel.compat.getStyle(this.oContainer, "padding"))[3]);
		}
		else{
			var max = parseInt(Kernel.compat.getStyle(this.oContainer, "height")) - this.oSlider.offsetHeight;
			var min = parseInt(Kernel.compat.getBox(Kernel.compat.getStyle(this.oContainer, "padding"))[0]);
		}

		if(this.direction == "horizontal")
			this.oSlider.style.left = (((max-min)*this.value) + min) + "px";
		else
			this.oSlider.style.top = (((max-min)*(1-this.value)) + min) + "px";
	}
	
	this.getValue = function(){
		return this.value;
	}
	
	/************************
		Keyboard Support
	************************/
	
	//Handler for a plane list
	this.keyHandler = function(key, ctrlKey, shiftKey, altKey){
		switch(key){
			case 37:
			//LEFT
				if(this.direction != "horizontal") return;
				this.setValue(this.value - (ctrlKey ? 0.01 : 0.1));
			break;
			case 38:
			//UP
				if(this.direction != "vertical") return;
				this.setValue(this.value + (ctrlKey ? 0.01 : 0.1));
			break;
			case 39:
			//RIGHT
				if(this.direction != "horizontal") return;
				this.setValue(this.value + (ctrlKey ? 0.01 : 0.1));
			break;
			case 40:
			//DOWN
				if(this.direction != "vertical") return;
				this.setValue(this.value - (ctrlKey ? 0.01 : 0.1));
			break;
			case 93:
			//CONTEXT MENU
				if(this.value) this.dispatchEvent("oncontextmenu", true);
				return false;
			break;
			default: 
			return;
		}
		
		return false;
	}
	
	/************************
				INIT
	************************/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal();
		this.oSlider = this.__getLayoutNode("Main", "slider", this.oExt);
		this.oContainer = this.__getLayoutNode("Main", "container", this.oExt);
		this.oSlider.host = this;
		
		this.oSlider.style.left = (parseInt(Kernel.compat.getBox(Kernel.compat.getStyle(this.oExt, "padding"))[3])) + "px";
		
		this.oSlider.onmousedown = function(e){
			if(this.host.disabled) return false;
			
			if(!e) e = event;
			document.dragNode = this;

			this.x = (e.clientX || e.x);
			this.y = (e.clientY || e.y);
			this.stX = this.offsetLeft;
			this.siX = this.offsetWidth
			this.stY = this.offsetTop;
			this.siY = this.offsetheight
			
			if(this.host.direction == "horizontal"){
				this.max = parseInt(Kernel.compat.getStyle(this.host.oContainer, "width")) - this.offsetWidth;
				this.min = parseInt(Kernel.compat.getBox(Kernel.compat.getStyle(this.host.oContainer, "padding"))[3]);
			}
			else{
				this.max = parseInt(Kernel.compat.getStyle(this.host.oContainer, "height")) - this.offsetHeight;
				this.min = parseInt(Kernel.compat.getBox(Kernel.compat.getStyle(this.host.oContainer, "padding"))[0]);
			}
			
			this.host.__setStyleClass(this, "btndown", ["btnover"]);
			
			document.onmousemove = function(e){
				if(!e) e = event;
				//if(e.button != 1) return this.onmouseup();
				
				var o = this.dragNode;
				
				var to = o.host.direction == "horizontal" ? (e.clientX || e.x) - o.x + o.stX : (e.clientY || e.y) - o.y + o.stY;
				to = (to > o.max ? o.max : (to < o.min ? o.min : to));

				var value = Math.round((to - o.min)*100/(o.max - o.min))/100;
				o.host.Change(o.host.direction == "horizontal" ? value : 1-value);
			}
			
			document.onmouseup = function(){
				var o = this.dragNode;
				this.dragNode = null;
				o.onmouseout();
				
				document.onmousemove = null;
				document.onmouseup = null;
			}
			
			//event.cancelBubble = true;
			return false;
		}
		
		this.oSlider.onmouseup = 
		this.oSlider.onmouseover = function(){
			if(document.dragNode != this) this.host.__setStyleClass(this, "btnover", ["btndown"]);
		}
		
		this.oSlider.onmouseout = function(){
			if(document.dragNode != this) this.host.__setStyleClass(this, "", ["btndown", "btnover"]);
		}
	}
	
	this.__loadJML = function(x){
		if(x.getAttribute("value")) this.setValue(x.getAttribute("value"));
		this.direction = x.getAttribute("direction") || "horizontal";
		
		this.setValue(this.value);
	}
	
	this.__destroy = function(){
		this.oSlider.host = null;
		this.oSlider.onmousedown = null;
		this.oSlider.onmouseup = null;
		this.oSlider.onmouseover = null;
		this.oSlider.onmouseout = null;
	}
}

/*FILEHEAD(/in/Components/Sourceedit.js)SIZE(7849)TIME(1179307594016)*/

//IDEAS:
// Ctrl-E delete line
// Ctrl-R replace function.. regexp support

function Sourceedit(parentNode, data, skin){
	Kernel.register(this, "Sourceedit", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	this.inherit(DataBinding);
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.focussable = true; // This object can get the focus
	this.disabled = false; // Object is enabled
	this.value = null;
	this.inherit(Validation);
	
	this.toolbars = new Array();
	this.buttons = new Array();
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	//API
	
	this.WordWrap = function(){
		this.oTxt.style.width = "100%";	
	}
	
	this.setValue = function(value){
		if(IS_IE) this.oTxt.innerText = value;
		else this.oTxt.value = value;	
	}
	
	this.getValue = function(){
		return this.oTxt.innerText;
	}
	
	this.find = function(text, noshow){
		/*
			scope
			
			0 Default. Match partial words. 
			1 Match backwards. 
			2 Match whole words only. 
			4 Match case. 
			131072 Match bytes. 
			536870912 Match diacritical marks. 
			1073741824 Match Kashida character. 
			2147483648 Match AlefHamza character. 

		*/

		var o = this.oTxt;
		o.focus();
		var r = document.selection.createRange();//o.createTextRange();
		r.collapse(false);
		var found = r.findText(text, 100000);
		
		if(found) r.select();
		else{
			//eigenlijk mooier om bovenaan te beginnen.. maar later...
			var r = document.selection.createRange();
			r.select();
			if(!noshow) this.showSearch(true);
		}
	}
	
	this.gotoLineNumber = function(ln, selectLine){
		var o = this.oTxt;
		o.focus();
		
		var r = o.createTextRange();//document.selection.createRange();
		r.moveEnd("character", 1);
		
		var ar = o.innerText.split("\n");
		var rs = ar.slice(0, ln);
		for(var i=0;i<rs.length;i++) r.findText(rs[i]);
		if(!selectLine) r.collapse();
		r.select();
		
		if(this.onshowlinenr) this.onshowlinenr(this.getLineNumber());
	}
	
	this.getLineNumber = function(){
		var o = this.oTxt;

		var r = document.selection.createRange();
		r.moveEnd("character", 1);
		var q = r.duplicate();//o.createTextRange();
		q.moveToElementText(o);
		//q.collapse();
		q.setEndPoint("EndToEnd", r);

		var str = q.text;
		return str.split("\n").length + (r.text == "" ? 1 : 0);
	}
	
	this.selectAll = function(){
		this.oTxt.select();
	}
	
	/************************
				FOCUS
	************************/
	
	this.__focus = function(){
		if(document.activeElement == this.oTxt) return;
		//return; //TEMP SOLUTION
		try{
			this.oTxt.focus();
		}catch(e){}
	}
	
	this.__blur = function(){
		this.oTxt.blur();
	}
	
	this.focussable = true;
	
	/************************
			Databinding
	************************/
	
	this.__xmlUpdate = function(action, xmlNode, listenNode, UndoObj){
		//Action Tracker Support
		if(UndoObj) UndoObj.xmlNode = this.XMLRoot;
		
		//Refresh Properties
		//var value = this.applyRuleSetOnNode("Value", this.XMLRoot);
		//if(value != this.getValue()) this.setValue(value || "");
		
		var value = this.applyRuleSetOnNode("Value", this.XMLRoot);
		if((value || typeof value == "string")){
			if(value != this.getValue()) this.setValue(value);
		}
		else this.setValue("");
	}
	
	this.__load = function(XMLRoot, id){
		//Add listener to XMLRoot Node
		XMLDatabase.addNodeListener(XMLRoot, this);
		
		var value = (this.bindingRules ? this.applyRuleSetOnNode("Value", XMLRoot) : (this.jml.firstChild ? this.jml.firstChild.nodeValue : false));

		if((value || typeof value == "string")){
			if(value != this.getValue()) this.setValue(value);
		}
		else this.setValue("");
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/
	
	/************************
		SEARCH|GOTO|KEYBOARD
	************************/
	
	this.lastSearch = "";
	this.lastGoto = "";
	
	this.showSearch = function(noclear){
		this.oFind.className = this.baseCSSname + "_find";
		if(!noclear) this.oFindInput.value = this.lastSearch;
		this.oFindLabel.nodeValue = "Search";
		
		//setting function
		this.oFindInput.onkeydown = new Function('e', 'if(!e) e = event;if(e.keyCode==13){Kernel.lookup('+this.uniqueId+').find(this.value);return false}')
		
		this.showBox();
	}
	
	this.showGoto = function(){
		this.oFind.className = this.baseCSSname + "_goto";
		this.oFindInput.value = this.lastGoto;
		this.oFindLabel.nodeValue = "Goto Line:";
		
		//setting function
		this.oFindInput.onkeydown = new Function('e', 'if(!e) e = event;if(e.keyCode==13){Kernel.lookup('+this.uniqueId+').gotoLineNumber(this.value);return false}')
		
		this.showBox();
	}
	
	this.showBox = function(){
		this.oFind.style.top = this.oExt.scrollTop + 15;
		
		this.oFind.style.display = "block";
		this.oFindInput.select();
		this.oFindInput.focus();
	}
	
	this.hideBox = function(){
		this.oFind.style.display = "none";
		
		if(this.oFindLabel.innerHTML == "Search")
			this.lastSearch = this.oFindInput.value;
		else
			this.lastGoto = this.oFindInput.value;
	}
	
	this.keyHandler = function(key, ctrlKey){
		if(key == 114 && this.lastSearch){
			this.find(this.lastSearch, true);
			return false;
		}
		else if(ctrlKey && key == 70){
			if(!document.selection) return false;
			
			//Find
			this.showSearch();
			return false;
		}
		else if(ctrlKey && key == 71){
			if(!document.selection) return false;
			
			//Goto Line
			this.showGoto();
			return false;
		}
		else if(key == 27){
			this.hideBox();
			return false;
		}
		else if(key == 9){
			if(!IS_IE) return;
			var r = document.selection.createRange();
			r.text = "	";
			return false;
		}
	}
	
	/****************
		Init
	****************/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal();
		this.oTxt = this.__getLayoutNode("Main", "input", this.oExt);
		this.oTxt.host = this;
		
		this.oFind = XMLDatabase.htmlImport(this.__getLayoutNode("FindPopup"), this.oExt);
		this.oFindLabel = this.__getLayoutNode("FindPopup", "label", this.oFind);
		this.oFindInput = this.__getLayoutNode("FindPopup", "input", this.oFind);

		//this.oExt.onmousedown = 
		this.oExt.onfocus = function(e){
			if(!e) e = event;
			
			if(e.offsetX < this.offsetWidth - 23 && e.offsetY < this.offsetHeight - 23){
				setTimeout('Kernel.lookup(' + this.host.uniqueId + ').focus()', 100);
				e.cancelBubble = true;
			}
		}
		
		this.oTxt.onselectstart = function(e){if(!e) e = event;e.cancelBubble = true};
		this.oTxt.onmousemove = 
		this.oTxt.onmouseover = function(e){if(!e) e = event;e.cancelBubble = true;}
		
		this.oTxt.onmousedown = function(e){
			if(!e) e = event;
			
			me.__focus(this.host);
			e.cancelBubble = true;	
		}
		
		this.oTxt.onmouseup = 
		this.oTxt.onkeydown = 
		this.oTxt.onkeyup = function(e){
			if(!e) e = event;
			
			if(this.host.onshowlinenr) this.host.onshowlinenr(this.host.getLineNumber());
			if(e.keyCode == 9) return false;
		}
	}
	
	this.__loadJML = function(x){
		this.setValue(x.firstChild ? x.firstChild.nodeValue : "");
		
		this.__focus();
	}
}


/*FILEHEAD(/in/Components/Statusbar.js)SIZE(3298)TIME(1182723583203)*/
function Statusbar(pHtmlNode, icon, skin){
	Kernel.register(this, "Statusbar", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;

	var rest;
	this.panels = [];

	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.getPanel = function(id){
		return this.panels[id];
	}
	
	this.addPanel = function(xmlNode){
		this.__getNewContext("Panel");
		var p = this.__getLayoutNode("Panel");
		if(xmlNode.getAttribute("css")) p.setAttribute("style", xmlNode.getAttribute("css"));
		
		var elPanel = XMLDatabase.htmlImport(p, this.oInt, this.oInt.firstChild);
		var elPanelInt = this.__getLayoutNode("Panel", "container", elPanel);
		
		var oPanel = {
			host : this,
			oExt : elPanel,
			oInt : elPanelInt,
			oIcon : this.__getLayoutNode("Panel", "icon", elPanel),
			oCaption : this.__getLayoutNode("Panel", "caption", elPanel),
			
			setCaption : function(caption){
				this.oInt.innerHTML = caption;
			},
			
			setIcon : function(iconURL){
				if(this.oIcon.tagName && this.oIcon.tagName.match(/^img$/i)) elIcon.src = this.host.iconPath + iconURL;
				else this.oIcon.style.backgroundImage = "url(" + this.host.iconPath + iconURL + ")";
			},
			
			setStatus : function(iconURL, caption){
				this.setIcon(iconURL);
				this.setCaption(caption);
			}
		};
		
		if(xmlNode.getAttribute("icon")){
			oPanel.setIcon(xmlNode.getAttribute("icon"));
			this.__setStyleClass(oPanel.oExt, "win_panel_icon");
		}
		
		var wt = xmlNode.getAttribute("width");
		if(wt == "rest" || wt == "*"){
			this.__setStyleClass(oPanel.oExt, "rest");
			rest = oPanel;
		}
		else if(wt) oPanel.oExt.style.width = wt + "px";
		
		if(xmlNode.getAttribute("height")) oPanel.oExt.style.height = xmlNode.getAttribute("height") + "px";
		if(oPanel.oCaption) oPanel.setCaption(xmlNode.firstChild ? xmlNode.firstChild.nodeValue : "");
		if(xmlNode.getAttribute("id")) this.panels[xmlNode.getAttribute("id")] = oPanel
		this.panels.push(oPanel);
		
		//parse children
		if(this.lastpages){
			var childs = this.lastpages[id].childNodes;
			for(var i=childs.length-1;i>=0;i--) elPanelInt.insertBefore(childs[i], elPanelInt.firstChild);
		}
		else if(elPanelInt && !oPanel.oCaption) Application.loadSubNode(xmlNode, elPanelInt, this);
		
		return oPanel;
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal();
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);
		this.oCorner = this.__getLayoutNode("Main", "corner", this.oExt)
		
		rest = null;
		var nodes = this.jml.childNodes;
		for(var p,i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1) continue;
			var tagName = nodes[i].tagName.replace(/^j\:/, "");

			if(tagName == "Panel"){
				p = this.addPanel(nodes[i]);
				if(this.panels.length == 1) this.__setStyleClass(p.oExt, "first");
			}
		}
		
		if(p) this.__setStyleClass(p.oExt, "last");
		//if(rest) this.oInt.appendChild(rest.oExt);
	}
}

/*FILEHEAD(/in/Components/Submitform.js)SIZE(31111)TIME(1181923224389)*/

/* Validation:

required="true"		niet runtime
notnull="true" 		wel runtime
min-value="0"
max-value="10"
max-length="10"
validation="/regexp/" | EMAIL, DATE, DATENL
*/

function Submitform(pHtmlNode){
	Kernel.register(this, "Submitform", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	this.inherit(DataBinding);
	this.inherit(BcTab);
	
	/*********************************************************************
										PRIVATE PROPERTIES
	*********************************************************************/
	this.focussable = false;
	this.allowMultipleErrors = true;
	
	this.inputs = [];
	this.elements = {};
	this.errorEl = {};
	this.cq = {};
	this.reqs = [];
	this.conditionDeps = {};
	this.depends = {};
	var buttons = {
		"next" : [],
		"previous" : [],
		"submit" : [],
		"follow" : []
	};

	this.loadValueDeps = {};
	this.loadValues = {};
	
	this.listsHeldBack = {};
	this.nextHeldBack = {};
	
	this.activePage = 0;
	this.zCount = 1000000;
	
	this.clear = function(){}
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.checkRequired = function(){
		if(this.testing) return false;
		
		for(var found=false,i=0;i<this.reqs.length;i++){
			var cObj = this.reqs[i];
			if(new String(cObj.getValue()).length == 0){
				cObj.setError();
				if(cObj.errBox){
					cObj.errBox.setMessage(cObj.invalidmsg);
					cObj.errBox.show();
				}
				
				found = true;
			}
		}
		return found;
	}
	
	this.showLoader = function(checked, nr){
		if(checked){
			var page = nr ? this.getPage(nr) : this.getNextPage();
			if(!page || page.isRendered) return;
		}
		
		if(this.loadState){
			this.loadState.style.display = "block";
			
			var message = this.getPage().jml.getAttribute("load-message");
			if(message) (XMLDatabase.selectSingleNode("div[@class='msg']", this.loadState) || this.loadState).innerHTML = message;
		}
	}
	
	this.hideLoader = function(){
		if(this.loadState)
			this.loadState.style.display = "none";
	}
	
	var nextpagenr;
	this.getNextPage = function(){
		var nextpage, pageNr = this.activePage;
		do{
			nextpage = this.getPage(++pageNr);
		}while(nextpage && !this.testCondition(nextpage.condition));
		
		nextpagenr = pageNr;
		return nextpage;
	}
	
	this.next = function(no_error){
		if(!this.testing && !this.isValid(true, true)){
			this.hideLoader();
			return;//checkRequired
		}
		
		var nextpage = nextpagenr ? this.getPage(nextpagenr):this.getNextPage();
		if(this.dispatchEvent("onbeforeswitch", nextpagenr)=== false)return false;

		this.getPage().hide();
		this.activePage = nextpagenr;
		
		if(!no_error && !nextpage) throw new Error(1006, Kernel.formErrorString(1006, this, "Form", "End of pages reached."));
		
		nextpage.show();
		
		if(nextpage.isRendered) this.hideLoader();
		else nextpage.addEventListener("onafterrender", function(){this.parentNode.hideLoader()});
		
		for(var prop in buttons){
			if(!prop.match(/next|previous|submit/)) continue;
			this.updateButtons(prop);
		}
		
		nextpagenr = null;
		
		var jmlNode = this;
		setTimeout(function(){
			jmlNode.dispatchEvent("onafterswitch", jmlNode.activePage, nextpage);
		}, 1);
	}
	
	this.previous = function(){
		var active = this.activePage;
		do{var prevpage = this.getPage(--active);}
		while(prevpage && ! this.testCondition(prevpage.condition));
		
		if(this.dispatchEvent("onbeforeswitch", active)=== false) return false;
		this.getPage().hide();
		this.activePage = active;

		if(!prevpage) throw new Error(1006, Kernel.formErrorString(1006, this, "Form", "End of pages reached."));
		
		prevpage.show();
		
		if(prevpage.isRendered) this.hideLoader();
		else prevpage.addEventListener("onafterrender", function(){this.parentNode.hideLoader()});
		
		for(var prop in buttons){
			if(!prop.match(/next|previous|submit/)) continue;
			this.updateButtons(prop);
		}

		this.dispatchEvent("onafterswitch", this.activePage);
	}
	
	this.getJsonObject = function(){
		var data = {};
		
		for(var p in this.elements){
			var name = this.elements[p].jml.getAttribute("name") || this.elements[p].name;
			if(name) data[name] = this.elements[p].getValue();
		}
		
		return data;
	}
	
	this.submit = function(){
		if(this.checkRequired() || !this.isValid(true, true)) return;
		
		var data;
		
		this.showLoader();
		if(this.type == "array"){
			data = this.getJsonObject();
		}
		else if(this.XMLRoot && this.type == "xml") 
			data = XMLDatabase.serializeNode(this.XMLRoot);
		
		this.Submit(data);
		
		//this.next(true);
	}
	
	this.__enable = function(){
		forbuttons('enable');
	}
	
	this.__disable = function(){
		forbuttons('disable');
	}
	
	function forbuttons(feat){
		var arr = ["next", "previous", "submit", "follow"];
		for(var k=0;k<arr.length;k++){
			for(var i=0;i<buttons[arr[k]].length;i++){
				buttons[arr[k]][i][feat]();
			}
		}
	}
	
	this.registerErrorBox = function(strFormEl, oHTML){
		if(self[strFormEl]) self[strFormEl].errBox = oHTML;
		this.errorEl[strFormEl] = oHTML;
	}
	this.getErrorBox = function(strFormEl){
		return this.errorEl[strFormEl];
	}
	
	this.addConnectQueue = function(oRef, funcRef, strFormEl){
		if(this.elements[strFormEl]){
			funcRef.call(oRef, this.elements[strFormEl]);
			this.elements[strFormEl].labelEl = oRef;
			if(!this.elements[strFormEl].isActive)
				oRef.hide();
		}
		else{
			if(!this.cq[strFormEl]) this.cq[strFormEl] = Array();
			this.cq[strFormEl].push([oRef, funcRef]);
		}
	}
	
	this.processValueChange = function(oFormEl){
		if(this.conditionDeps[oFormEl.name]){
			var c = this.conditionDeps[oFormEl.name];
			for(var i=0;i<c.length;i++){
				if(this.testCondition(c[i].condition)) c[i].setActive();
				else c[i].setInactive();
			}
		}
		
		for(var prop in buttons){
			if(!prop.match(/next|previous|submit/)) continue;
			this.updateButtons(prop);
		}

		this.setLoadValues(oFormEl.name);
	}
	
	/************************
				Actions
	************************/
	
	this.Submit = function(value){
		/*if(!this.actionRules || !this.actionRules["Submit"]) return;
		
		//Get Rules from Array
		rules = this.actionRules["Submit"];

		for(var node=null,i=0;i<(rules.length || 1);i++){
			if(!rules[i] || !rules[i].getAttribute("select") || this.XMLRoot.selectSingleNode(rules[i].getAttribute("select"))){
				//Call Event and cancel if it returns false
				var evnt = "onsubmit";// + action.toLowerCase();
				if(this[evnt] && this[evnt]() == false) return false;

				//Make RPC call
				var q = rules[i].getAttribute("rpc").split(";");
				var obj = eval(q[0]); var method = q[1];

				//obj[method](value);
				if(Kernel.TelePort.hasLoadRule(rules[i]))
					Kernel.TelePort.callMethodFromNode(rules[i], this.XMLRoot, new Function('data', 'state', 'extra', 'Kernel.lookup(' + this.uniqueId + ').processServerData(data, state, extra);'));//else alert("error posting form")

				return true;
			}
		}

		//Action not executed
		this.hideLoader();
		return false;*/
		
		this.executeAction("setUndoObject", [this.XMLRoot], "Submit", this.XMLRoot);
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/
	
	this.processServerData = function(data, state, extra){
		if(state != __RPC_SUCCESS__){
			this.dispatchEvent("onsubmiterror", extra);
			return this.hideLoader();
		}
		
		if(data){
			/*var el, page = this.getPage();
			if(page) page.hide();
			var pages = this.getPages();
			if(pages && pages[pages.length-1] && pages[pages.length-1] != this.getPage())
				pages[pages.length-1].show();
			else*/
			
			if(elName = this.actionRules["Submit"][0].getAttribute("element"))
				self[elName].load(data);
			
			if(this.getPage(this.activePage+1)) this.setActiveTab(this.activePage+1);
			else this.reset();
		}
		else{
			for(var i=0;i<data.length;i++){
				if(!data[i][1]){
					this.elements[data[i][0]].clearError();
					this.errorEl[data[i][0]].hide();
				}
				else{
					this.elements[data[i][0]].setError();
					this.errorEl[data[i][0]].setMessage(data[i][1]);
					this.errorEl[data[i][0]].show();
				}
			}
		}
		
		this.hideLoader();
	}
	
	this.addInput = function(objEl){
		var name = objEl.name;

		if(this.elements[name] && !this.elements[name].length){
			this.elements[name] = [this.elements[name]];
			this.elements[name].getValue = new Function('for(var i=0;i<this.length;i++) if(this[i].oInt.checked) return this[i].getValue();');
		}

		if(this.elements[name]) this.elements[name].push(objEl);
		else this.elements[name] = objEl;

		if(this.cq[name]){
			for(var i=0;i<this.cq[name].length;i++){
				this.cq[name][i][1].call(this.cq[name][i][0], objEl);
				objEl.labelEl = this.cq[name][i][0];
			}
		}
		
		if(objEl.jml.getAttribute("depends-on")){
			var o = self[objEl.jml.getAttribute("depends-on")];
			if(!this.depends[o.name]) this.depends[o.name] = [];
			this.depends[o.name].push(objEl);
			objEl.setInactive();
		}
		
		if(objEl.nodeType == GUI_NODE) objEl.setZIndex(--this.zCount);
		
		if(this.listsHeldBack[name]){
			var ld = this.listsHeldBack[name];
			this.loadLists(ld[0], ld[1], ld[2]);
			this.listsHeldBack[name] = null;
		}

		if(this.nQuest && objEl.jml.getAttribute("checknext") == "true"){
			if(this.lastEl){
				this.lastEl.nextEl = objEl;
				objEl.prevEl = this.lastEl;
			}
			this.lastEl = objEl;
			
			if(objEl.prevEl && objEl.jml.getAttribute("show") != "true" && !this.nextHeldBack[name] && !objHasValue(objEl)) objEl.setInactive(true);
			else if(this.condActiveCheck[objEl.name]) this.condActiveCheck[objEl.name].setActive();
			
			//terrible code, but what the heck
			if(this.condActiveCheck[objEl.name]){
				objEl.container = this.condActiveCheck[objEl.name];
				
				function activateHandler(){
					if(this.form.hasActiveElement(this.container)) this.container.setActive();
					else this.container.setInactive();
				}
				
				objEl.addEventListener("onactivate", activateHandler);
				objEl.addEventListener("ondeactivate", activateHandler);
			}
		}
	}
	
	this.loadNextElement = function(data, state, extra){
		if(state != __HTTP_SUCCESS__){
			if(extra.retries < MAX_JAV_RETRIES) return extra.tpModule.retry(extra.id);
			else throw new Error(1007, Kernel.formErrorString(1007, this, "Next Question", "Could not execute Next Question query :\n\n" + extra.message));
		}
		
		if(this.dispatchEvent("onloadnextquestion", data) === false) return this.hideLoader();
		
		if(this.condActiveCheck[data])
			this.condActiveCheck[data].setActive();

		if(self[data]){
			self[data].setActive();
			self[data].focus();
		}
		else if(parseInt(data) == data){
			var o = this.elements[this.nQuest.getAttribute("final")];
			
			if(!o) throw new Error(1008, Kernel.formErrorString(1008, this, "Next Question End", "Could not find next question final Control:" + this.nQuest.getAttribute("final")));
			
			o.setValue(data);
		}
		else{
			this.nextHeldBack[data] = true;
		}
		
		this.hideLoader();
	}
	
	this.addRequired = function(objEl){
		this.reqs.push(objEl);
		objEl.required = true;
	}
	
	this.addContainer = function(objEl){
		this.registerCondition(objEl, objEl.condition);
	}
	
	this.parseCondition = function(objEl, strCondition){
		objEl.condition = strCondition.replace(/(\W|^)(\w+)\=/g, '$1this.elements["$2"].getValue()==').replace(/(\W|^)(\w+)\!\=/g, '$1this.elements["$2"].getValue()!=').replace(/\Wand\W/g, "&&").replace(/\Wor\W/g, "||");
	}
	
	//this can be optimized a lot!!!! (do some storing of information etc etc
	this.hasActiveElement = function(objEl){
		var nodes = objEl.jml.getElementsByTagName("*");
		for(var i=0;i<nodes.length;i++){
			if(!nodes[i].getAttribute("id")) continue;
			var comp = this.elements[nodes[i].getAttribute("id")];
			if(comp && comp.form == this && comp.isActive) return true;
		}
		
		return false;
	}
	
	this.condActiveCheck = {};
	
	this.registerCondition = function(objEl, strCondition, no_parse){
		if(!no_parse) this.parseCondition(objEl, strCondition);
		
		var forceActive = false;
		if(objEl.onlyWhenActive){
			var nodes = objEl.jml.getElementsByTagName("*");
			for(var i=0;i<nodes.length;i++){
				if(!nodes[i].getAttribute("id")) continue;
				
				if(this.nextHeldBack[nodes[i].getAttribute("id")]) forceActive = true;
				else if(nodes[i].getAttribute("bind") && this.XMLRoot && XMLDatabase.getNodeValue(this.XMLRoot.selectSingleNode(nodes[i].getAttribute("bind"))) != ""){
					forceActive = true;
					nodes[i].setAttribute("show", "true");
				}
				
				this.condActiveCheck[nodes[i].getAttribute("id")] = objEl;
			}
		}

		if(forceActive || this.testCondition(objEl.condition) && (!objEl.onlyWhenActive || this.hasActiveElement(objEl, true))) objEl.setActive();
		else objEl.setInactive();
		
		var matches = !no_parse ? 
			strCondition.match(/(\W|^)(\w+)(?:\=|\!\=)/g) :
			strCondition.match(/(\b|^)([\w\.]+)/g);
		if(!matches) return;
		
		for(var i=0;i<matches.length;i++){
			if(!no_parse){
				var m = matches[i].replace(/(?:\=|\!\=)$/, "").replace(/(^\s+|\s+$)/g, "");
			}
			else{
				var m = matches[i].split(".");
				if(m.length < 2) continue;
				m = m[0];
			}
			
			if(!this.conditionDeps[m]) this.conditionDeps[m] = Array();
			this.conditionDeps[m].push(objEl);
		}
	}
	
	this.testCondition = function(strCondition){
		//somename='somestr' and (sothername='que' or iets='niets') and test=15

		try{
			return eval(strCondition);
		}
		catch(e){
			return false;
			//throw new Error(1009, Kernel.formErrorString(1009, this, "Form", "Invalid conditional statement [" + strCondition + "] : " + e.message));
		}
	}
	
	this.getButtons = function(action){return buttons[action];}
	
	this.registerButton = function(action, oBtn){
		buttons[action].push(oBtn);
		
		if(oBtn.condition) this.parseCondition(oBtn, oBtn.condition);
		this.updateButtons(action, oBtn);
		
		if(action == "follow") return;
		
		var jmlNode = this;
		oBtn.onclick = function(){
			jmlNode.showLoader(true);
			setTimeout(function(){jmlNode[action]()}, 10);
		};
		
		/*
			new Function(
				'Kernel.lookup(' + this.uniqueId + ').showLoader(true);setTimeout("Kernel.lookup(' + this.uniqueId + ').' + action + '()", 10)'
			);
		
			action == "previous" ?
				'Kernel.lookup(' + this.uniqueId + ').' + action + '()' :
				'Kernel.lookup(' + this.uniqueId + ').showLoader();setTimeout("Kernel.lookup(' + this.uniqueId + ').' + action + '()", 10)'
			);
		*/
	}
	
	//refactor to give buttons classes, so they can decide what to do when inactive
	this.updateButtons = function(action, singleBtn){
		return false;//
		
		if(!buttons[action]) return false;
		
		var result = true;
		if(action == "previous" && this.activePage == 0) result = false;
		else if(!this.testing && action == "next" && !this.isValid()) result = false;
		else if(action == "next"){
			var cp = this.activePage;
			do{var nextpage = this.getPage(++cp);
			}while(nextpage && !this.testCondition(nextpage.condition));

			if(!nextpage) result = false;
		}

		if(this.testing) return true;

		var buttons = singleBtn ? [singleBtn] : buttons[action];
		for(var i=0;i<buttons.length;i++){
			if(result && (!buttons[i].condition || this.testCondition(buttons[i].condition))) buttons[i].setActive();
			else buttons[i].setInactive();
		}

		return true;
	}
	
	this.clearNextQuestionDepencies = function(oEl, force){
		if(oEl.selectable && (force || oEl.getValue())){
			oEl.clearSelection();
			this.setLoadValues(oEl.name, true);
			if(oEl.jml.getAttribute("checknext") == "true" && (!oEl.nextEl || force)) oEl.deActivateAllNext();
		}
		else if(!oEl.selectable){
			oEl.Change("");
			if(oEl.jml.getAttribute("checknext") == "true" && (!oEl.nextEl || force)) oEl.deActivateAllNext();
		}
	}
	
	this.setLoadValues = function(item, clearElements, noload){
		var lvDep = this.loadValueDeps[item];
		if(!lvDep) return;
		//alert(item);
		for(var i=0;i<lvDep.length;i++){
			try{if(!eval(lvDep[i][1])) throw new Error();}catch(e){
				if(clearElements){
					var oEl = self[lvDep[i][0].getAttribute("element")];
					if(oEl) this.clearNextQuestionDepencies(oEl, true);//might be less optimized...

					if(lvDep[i][0].tagName == "LoadValue")
						this.dispatchEvent("onclearloadvalue", lvDep[i][0]);

					/*else if(lvDep[i][0].getAttribute("lid")){
						var lid = lvDep[i][0].getAttribute("lid");
						var nodes = this.XMLRoot.selectSingleNode("node()[@lid='" + lid + "']");
						
						for(var i=0;i<nodes.length;i++){
							XMLDatabase.removeNode(nodes[i]);
						}
					}*/
				}
				continue;
			}
			
			if(noload) continue;
			
			if(lvDep[i][0].getAttribute("runonrequest") != "true"){
				this.processLoadRule(lvDep[i][0], lvDep[i][2], lvDep[i]);
			}
			else if(self[lvDep[i][0].getAttribute("element")]){
				//This should be different :'(
				self[lvDep[i][0].getAttribute("element")].clear();
			}
		}
	}
	
	this.processLoadRule = function(xmlCommNode, isList, data){
		//Extend with Method etc
		if(!Kernel.TelePort.hasLoadRule(xmlCommNode)) return;
		
		this.dispatchEvent(isList ? "onbeforeloadlist" : "onbeforeloadvalue");
		
		//Process basedon arguments
		var nodes = xmlCommNode.childNodes;//selectNodes("node()[@arg-type | @arg-nr]"); //Safari bugs on this XPath... hack!
		if(nodes.length){
			var arr, arg = xmlCommNode.getAttribute(Kernel.TelePort.lastRuleFound.args);
			arg = arg ? arg.split(";") : [];

			if(xmlCommNode.getAttribute("arg-array")) arr = [];
			for(var j=0;j<nodes.length;j++){
				if(nodes[j].nodeType != 1) continue; //for safari
				if(nodes[j].getAttribute("arg-type").match(/fixed|param|nocheck/)){ //Where does item come from??? || item == nodes[j].getAttribute("element")
					var el = self[nodes[j].getAttribute("element")];
					var xpath = el.getMainBindXpath();
					var xNode = XMLDatabase.createNodeFromXpath(this.XMLRoot, xpath);
					var nType = xNode.nodeType;
					(arr || arg)[nodes[j].getAttribute("arg-nr") || j] = "xpath:" + xpath + (nType == 1 ? "/text()" : "");
				}
				else if(nodes[j].getAttribute("arg-type") == "xpath"){
					(arr || arg)[nodes[j].getAttribute("arg-nr") || j] = "xpath:" + nodes[j].getAttribute("select");//getXMLValue(this.XMLRoot, );
				}
			}

			if(xmlCommNode.getAttribute("arg-array")){
				arg[xmlCommNode.getAttribute("arg-array")] = "(" + arr.join(",") + ")";
			}

			xmlCommNode.setAttribute(Kernel.TelePort.lastRuleFound.args, arg.join(";"));
		}

		//this.XMLRoot.firstChild
		//if(confirm("do you want to debug?")) throw new Error();
		
		var jNode = self[xmlCommNode.getAttribute("element")];
		if(jNode && jNode.nodeType == GUI_NODE) jNode.__setStyleClass(jNode.oExt, "loading", ["loaded"]);
		
		//if(!isList && !data[0].getAttribute("lid")) data[0].setAttribute("lid", Kernel.getUniqueId());
		Kernel.TelePort.callMethodFromNode(xmlCommNode, this.XMLRoot, Function('data', 'state', 'extra', 'Kernel.lookup(' + this.uniqueId + ').' + (isList ? 'loadLists' : 'loadValues') + '(data, state, extra)'), null, data);
	}
	
	this.loadValues = function(data, state, extra){
		if(state != __HTTP_SUCCESS__){
			if(extra.retries < MAX_JAV_RETRIES) return extra.tpModule.retry(extra.id);
			else throw new Error(1010, Kernel.formErrorString(1010, this, "LoadVaLue", "Could not load values with LoadValue query :\n\n" + extra.message));
		}

		if(extra.userdata[0].getAttribute("return-type") == "array"){
			//integrate array
			for(var i=0;i<data.length;i++){
				var pnode = this.XMLRoot.selectSingleNode("//" + data[i][0]);
				XMLDatabase.setTextNode(pnode, data[i][1] || "");
			}
		}
		else{
			//integrate xml
			if(typeof data != "object") data = Kernel.getObject("XMLDOM", data).documentElement;
			var nodes = data.childNodes;
			var strUnique = extra.userdata[0].getAttribute("unique");

			for(var i=nodes.length-1;i>=0;i--){
				var xmlNode = nodes[i];
				var unique = strUnique ? xmlNode.selectSingleNode(strUnique) : false;
				
				var node = unique ? this.XMLRoot.selectSingleNode("node()[" + strUnique + " = '" + unique.nodeValue + "']") : null;
				if(node){
					//Move all this into the XMLDatabase
					XMLDatabase.copyConnections(node, xmlNode);
					XMLDatabase.notifyListeners(xmlNode);
					
					//node.setAttribute("lid", data.getAttribute("lid"));
					
					//hack!! - should be recursive
					var valueNode = xmlNode.selectSingleNode("value");
					if(valueNode){
						XMLDatabase.copyConnections(node.selectSingleNode("value"), valueNode);
						XMLDatabase.notifyListeners(valueNode);
					}
				}
				
				this.XMLRoot.insertBefore(xmlNode, node); //consider using replaceChild here
				if(node) this.XMLRoot.removeChild(node);
				XMLDatabase.applyChanges("attribute", xmlNode);
			}
		}

		this.dispatchEvent("onafterloadvalue");
	}
	
	this.loadLists = function(data, state, extra){
		if(state != __HTTP_SUCCESS__){
			if(extra.retries < MAX_JAV_RETRIES) return extra.tpModule.retry(extra.id);
			else throw new Error(1011, Kernel.formErrorString(1011, this, "Load List", "Could not load data with LoadList query :\n\n" + extra.message));
		}
		
		if(!self[extra.userdata[0].getAttribute("element")])
			return this.listsHeldBack[extra.userdata[0].getAttribute("element")] = [data, state, extra];
		
		//set style
		var jNode = self[extra.userdata[0].getAttribute("element")];
		if(jNode && jNode.nodeType == GUI_NODE){
			jNode.__setStyleClass(jNode.oExt, "loaded", ["loading"]);
			setTimeout("var jNode = Kernel.lookup(" + jNode.uniqueId + ");jNode.__setStyleClass(jNode.oExt, '', ['loading', 'loaded']);", 500);
		}

		if(extra.userdata[0].getAttribute("clearonload") == "true"){
			jNode.clearSelection();
			//this.setLoadValues(jNode.name, true);
			this.clearNextQuestionDepencies(jNode, true);
		}
		
		//load xml in element
		jNode.load(data);
		//if(!jNode.value){
			//this.clearNextQuestionDepencies(jNode, true);
		//}
		
		this.dispatchEvent("onafterloadlist");
	}
	
	function checkValidChildren(oParent, checkReq, setError){
		var found;
		
		//Per Element
		for(var i=0;i<oParent.childNodes.length;i++){
			var oEl = oParent.childNodes[i];

			if(!oEl) continue;
			if(oEl.oContainer) oEl = oEl.oContainer; //hack for radiobuttons
			if(
				(!oEl.oExt || oEl.oExt.offsetHeight) && 
				(
					oEl.hasFeature(__VALIDATION__) && oEl.isValid && !oEl.isValid() ||
					checkReq && oEl.required && new String(oEl.getValue()).length == 0
				)
			){
				if(setError){
					oEl.validate(true);
					found = true;
				}
				else return true;
			}
			if(oEl.childNodes.length) found = checkValidChildren(oEl, checkReq, setError) || found;
		}
		
		return found;
	}
	
	this.isValid = function(checkReq, setError, page){
		if(!page) page = this.getPage() || this;
		var found = checkValidChildren(page, checkReq, setError);
		
		//Global Rules
		//
		
		return !found;
	}
	
	this.validate = function(){
		if(!this.isValid()){
			
		}
	}
	
	//HACK!
	this.reset = function(){
	  //Clear all error states
		for(name in this.elements){		
			var el = this.elements[name];
			
			//Hack!!! maybe traverse
			if(el.length){
				throw new Error(0, Kernel.formErrorString(this, "clearing form", "Found controls without a name or with a name that isn't unique. Please give all elements of your Submitform an id: '" + name + "'"));
			}
			
			el.clearError();
			if(this.errorEl[name])
				this.errorEl[name].hide();
			
			if(el.hasFeature(__MULTIBINDING__)) el.getSelectionBindClass().clear();
			else el.clear();
		}
	}
	
	/************************
			Databinding
	************************/
	
	this.__xmlUpdate = function(action, xmlNode, listenNode, UndoObj){
		//this.setConnections(this.XMLRoot, "select");
		//if(confirm("debug? " + this.toString())) debugger;
		this.dispatchEvent("onxmlupdate");
	}
	
	this.smartBinding = {};
	this.__load = function(XMLRoot, id){
		XMLDatabase.addNodeListener(XMLRoot, this);
		//this.setConnections(XMLDatabase.getElement(XMLRoot, 0), "select");	
		//this.setConnections(XMLRoot, "select");	
	}
	
	function objHasValue(objEl){
		var oCheck = objEl.hasFeature(__MULTISELECT__) ? objEl.getSelectionBindClass() : objEl;
		if(!oCheck) return false;
		return oCheck.applyRuleSetOnNode(oCheck.mainBind, oCheck.XMLRoot, null, true);
	}
	
	//Reset form
	function onafterload(){
		//Clear all error states
		for(name in this.elements){
			if(IS_SAFARI && (!this.elements[name] || !this.elements[name].__jmlLoaders)) continue;
			
			//Hack!!! maybe traverse
			if(this.elements[name].length){
				throw new Error(1012, Kernel.formErrorString(1012, this, "clearing form", "Found controls without a name or with a name that isn't unique("+name+"). Please give all elements of your Submitform an id: '" + name + "'"));
			}
			
			this.elements[name].clearError();
			if(this.errorEl[name])
				this.errorEl[name].hide();
		}
		
		if(this.nQuest){
			//Show all controls and labels which are in the nquest stack
			for(name in this.elements){
				
				var objEl = this.elements[name];
				
				if(objEl.jml.getAttribute("checknext") == "true"){
					if(objHasValue(objEl)){//oCheck.value || 
						objEl.setActive();
						if(this.condActiveCheck[name])
							this.condActiveCheck[name].setActive();
					}
					else{
						objEl.setInactive(true);
					}
				}
				else{
					//que ???
					if(objEl.tagName == "Radiogroup" && objEl.current)
						objEl.current.uncheck();
				}
			}
		}

		if(this.nQuest && this.XMLRoot.childNodes.length > 0){
			var element = this.nQuest.getAttribute("final");
			var jmlNode = self[element].jml;//XMLDatabase.selectSingleNode(".//node()[@id='" + element + "']", this.jml);

			if(jmlNode && !XMLDatabase.getBoundValue(jmlNode, this.XMLRoot)){
				var fNextQNode = XMLDatabase.selectSingleNode(".//node()[@checknext='true']", this.jml);
				if(!fNextQNode) return;
				self[fNextQNode.getAttribute("id")].dispatchEvent("onafterchange");
			}
		}
	}
	this.addEventListener("onafterload", onafterload);
	this.addEventListener("onafterinsert", onafterload);
	
	this.addEventListener("onbeforeload", function(){
		if(!this.smartBinding || !this.smartBinding.actions) return;
		var nodes = this.smartBinding.actions.LoadList;
		if(nodes){
			for(var objEl, i=0;i<nodes.length;i++){
				if(!nodes[i].getAttribute("element") || !(objEl = this.elements[nodes[i].getAttribute("element")])) continue;
				objEl.clear();
			}
		}
		
		var nodes = this.smartBinding.actions.NextQuestion;
		if(nodes){
			for(var objEl, i=0;i<nodes.length;i++){
				if(!nodes[i].getAttribute("final") || !(objEl = this.elements[nodes[i].getAttribute("element")])) continue;
				objEl.clear();
			}
		}
	});
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.addOther = function(tagName, oJml){
		if(tagName != "LoadState") return;
		var htmlNode = Kernel.compat.getFirstElement(oJml);
		this.loadState = XMLDatabase.htmlImport(htmlNode, this.oInt);
		this.loadState.style.display = "none";
	}
	
	this.draw = function(){
		//Build Main Skin
		this.oPages = this.oExt = this.__getExternal(); 
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);
		this.oExt.host = this;
	}
	
	this.__loadJML = function(x){
		this.type = x.getAttribute("dataformat") || "xml";
		this.testing = x.getAttribute("testing") == "true";
		
		this.__drawTabs(function(xmlPage){
			this.condition = xmlPage.getAttribute("condition") || "true";
		});
	}

	this.addEventListener("onsetsmartbinding", function(){
		if(this.smartBinding && this.smartBinding.actions){
			if(this.smartBinding.actions.LoadValue)
				this.initLoadDeps(this.smartBinding.actions.LoadValue);
				
			if(this.smartBinding.actions.LoadList)
				this.initLoadDeps(this.smartBinding.actions.LoadList, true);
			
			if(this.smartBinding.actions.NextQuestion)
				this.nQuest = this.smartBinding.actions.NextQuestion[0];
		}
	});

	this.initLoadDeps = function(lvNodes, isList){
		for(var i=0;i<lvNodes.length;i++){
			var nodes = lvNodes[i].selectNodes("BasedOn[@element]");
			//HACK!! quick resolution
			for(var sNodes=[],j=0;j<nodes.length;j++) if(nodes[j].getAttribute("arg-type") != "param") sNodes.push(nodes[j]);
			
			var check = [];
			for(var j=0;j<sNodes.length;j++){
				if(sNodes[j].getAttribute("arg-type") != "nocheck")
					check.push('this.elements["' + sNodes[j].getAttribute("element") + '"].isValid(true)');
			}
			for(var j=0;j<sNodes.length;j++){
				if(!this.loadValueDeps[sNodes[j].getAttribute("element")]) this.loadValueDeps[sNodes[j].getAttribute("element")] = new Array();
				this.loadValueDeps[sNodes[j].getAttribute("element")].push(new Array(lvNodes[i], check.join(" && ") || "true", isList));
			}
		}
	}
}

function FormValue(form){
	Kernel.register(this, "FormValue", NOGUI_NODE);

	/************************
			  Inheritance
	************************/
	this.inherit(DataBinding);
	
	//this.form = form;
	this.inherit(Validation);
	
	/*********************************************************************
			       PUBLIC METHODS
	*********************************************************************/
	
	this.clear = function(){}
	
	this.__load = function(XMLRoot){
		XMLDatabase.addNodeListener(XMLRoot, this);
		this.__xmlUpdate(null, null, null, null, true);
	}
		
	this.__xmlUpdate = function(action, xmlNode, actionNode, undoObj, no_event){
		//HACK!: Integration should be fixed!!! (by setting XMLRoot of listeners etc...
		
		if(this.XMLRoot != xmlNode && xmlNode){
			this.XMLRoot = xmlNode;
			XMLDatabase.addNodeListener(xmlNode, this);
		}
		
		if(this.value == this.getValue()) return;
		
		this.setValue(null, no_event);
	}
	
	this.setValue = function(value, no_event){
		if(!this.jml.getAttribute("bind") || !this.XMLRoot) return "";
		
		if(value){
			var xmlNode = XMLDatabase.createNodeFromXpath(this.XMLRoot, this.bindingRules[this.mainBind][0].getAttribute("select"));//this.jml.getAttribute("bind"));//this.XMLRoot.selectSingleNode(this.jml.getAttribute("bind"));
			if(xmlNode && xmlNode.nodeType == 1) xmlNode = xmlNode.firstChild;
			if(!xmlNode) return;
			
			xmlNode.nodeValue = value;
		}
		
		if(!no_event) this.dispatchEvent("onafterchange");
		this.value = this.getValue();
	}

	this.getValue = function(){
		if(!this.XMLRoot) return this.value || "";
		return this.applyRuleSetOnNode(this.mainBind, this.XMLRoot);
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);

	this.draw = function(){}
	this.__loadJML = function(x){
		this.value = x.getAttribute("value");
		this.setValue(this.value);
	}
}

/*FILEHEAD(/in/Components/State.js)SIZE(4061)TIME(1185049651181)*/

StateServer = {
	states : {},
	groups : {},
	locs : {},
	
	removeGroup : function(name, elState){
		this.groups[name].remove(elState);
		if(!this.groups[name].length){
			self[name].destroy();
			self[name] = null;
			delete this.groups[name];
		}
	},
	
	addGroup : function(name, elState){
		if(!this.groups[name]){
			this.groups[name] = [];
			self[name] = new State();
			self[name].name = name;
			self[name].toggle = function(){
				for(var next=0,i=0;i<StateServer.groups[name].length;i++){
					if(StateServer.groups[name][i].active){
						next = i+1;
						break;
					}
				}
				
				StateServer.groups[name][next == StateServer.groups[name].length ? 0 : next].activate();
			}
		}
		
		this.groups[name].push(elState);
	},
	
	removeState : function(elState){
		delete this.states[elState.name];
	},
	
	addState : function(elState){
		this.states[elState.name] = elState;
	}
}

function State(pHtmlNode){
	Kernel.register(this, "State", NOGUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.setValue = function(value){
		this.active = 9999;
		this.setProperty("active", value);
	}
	
	/*this.getValue = function(){
		return this.value;
	}*/
	
	//this group stuff can prolly be more optimized
	this.activate = function(){
		this.active = 9999;
		this.setProperty("active", true);
	}
	
	this.deactivate = function(){
		this.setProperty("active", false);
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.__supportedProperties = ["active"];
	this.__handlePropSet = function(prop, value){
		if(prop == "active"){
			//Activate State
			if(isTrue(value)){
				if(this.group){
					var nodes = StateServer.groups[this.group];
					for(var i=0;i<nodes.length;i++){
						if(nodes[i] != this && nodes[i].active !== false)
							nodes[i].deactivate();
					}
				}
				
				var q = this.__signalElements;
				for(var i=0;i<q.length;i++){
					if(!self[q[i][0]] || !self[q[i][0]].setProperty){
						throw new Error(0, Kernel.formErrorString(1013, this, "Setting State", "Could not find object to give state: '" + q[i][0] + "' on property '" + q[i][1] + "'"));
					}
					
					self[q[i][0]].setProperty(q[i][1], this[q[i].join(".")]); 
				}
				
				if(this.group){
					var attr = this.jml.attributes;
					for(var i=0;i<attr.length;i++){
						if(attr[i].nodeName.match(/^on|^(?:group|id)$|^.*\..*$/)) continue;
						self[this.group].setProperty(attr[i].nodeName, attr[i].nodeValue);
					}
				}
				
				this.dispatchEvent("onstatechange");
				
				setStatus("Setting state '" + this.name + "' to ACTIVE");
			}
			
			//Deactivate State
			else{
				this.setProperty("active", false);
				this.dispatchEvent("onstatechange");
				
				setStatus("Setting state '" + this.name + "' to INACTIVE");
			}
		}
	}
	this.__signalElements = [];
	
	this.__loadJML = function(x){
		StateServer.addState(this);
		
		this.group = x.getAttribute("group");
		if(this.group) StateServer.addGroup(this.group, this);
		
		if(x.getAttribute("location")) StateServer.locs[x.getAttribute("location")] = this;
		
		//Properties initialization
		var attr = x.attributes;
		for(var s,i=0;i<attr.length;i++){
			if(attr[i].nodeName.match(/^on|^(?:group|id)$/)) continue;
			
			s = attr[i].nodeName.split(".");
			if(s.length == 2) this.__signalElements.push(s);
			
			this[attr[i].nodeName] = attr[i].nodeValue;
		}
	}	
	
	this.__destroy = function(){
		this.__signalElements = null;
		StateServer.removeState(this);
		if(this.group) StateServer.removeGroup(this.group, this);
	}
}


/*FILEHEAD(/in/Components/Tab.js)SIZE(1026)TIME(1181922744090)*/

function Tab(pHtmlNode){
	Kernel.register(this, "Tab", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	this.hasButtons = true;
	this.focussable = true; // This object can get the focus
	
	/************************
	  Other Inheritance
	************************/
	this.inherit(Presentation);
	this.inherit(BcTab);
	this.keyHandler = this.__keyHandler;
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal();
		this.oPages = this.__getLayoutNode("Main", "pages", this.oExt);
		this.oButtons = this.__getLayoutNode("Main", "buttons", this.oExt);
	}
	
	this.__loadJML = function(x){
		this.__drawTabs();
	}
}

/*FILEHEAD(/in/Components/Text.js)SIZE(9136)TIME(1182723583203)*/

function Text(pHtmlNode){
	Kernel.register(this, "Text", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	this.inherit(DataBinding);
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.focussable = true; // This object can't get the focus
	this.inherit(Validation);

	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.getValue = function(){
		return this.oInt.innerHTML;
	}
	
	this.keyHandler = function(key,ctrlKey,shiftKey,altKey){
		switch(key){
			case 33:
			//PGUP
				this.oInt.scrollTop -= this.oInt.offsetHeight;
			break;
			case 34:
			//PGDN
				this.oInt.scrollTop += this.oInt.offsetHeight;
			break;
			case 35:
				//END
				this.oInt.scrollTop = this.oInt.scrollHeight;
			break;
			case 36:
			//HOME
				this.oInt.scrollTop = 0;
			break;
			case 38:
				this.oInt.scrollTop -= 10;
			break;
			case 40:
				this.oInt.scrollTop += 10;
			break;
			default:
			return;
		}
		
		return false;
	}
	
	this.setValue = 
	this.loadHTML = function(strHTML, doInsert, cacheObj){
		if(typeof strHTML != "string") strHTML = strHTML ? strHTML.toString() : "";
		
		if(this.protection){
			strHTML = strHTML.replace(/<a /gi, "<a target='_blank' ");
			strHTML = strHTML.replace(/<object.*?\/object>/g, "");
			strHTML = strHTML.replace(/<script.*?\/script>/g, "");
			strHTML = strHTML.replace(new RegExp("ondblclick|onclick|onmouseover|onmouseout|onmousedown|onmousemove|onkeypress|onkeydown|onkeyup|onchange|onpropertychange", "g"), "ona");
		}

		if(doInsert){
			if(cacheObj) cacheObj.contents += strHTML;
			else this.oInt.insertAdjacentHTML("beforeend", strHTML);
		}
		else{
			strHTML = strHTML.replace(/\<\?xml version="1\.0" encoding="UTF-16"\?\>/, "");
		
			//var win = window.open();
			//win.document.write(strHTML);
			if(cacheObj) cacheObj.contents = strHTML;
			else this.oInt.innerHTML = strHTML;//.replace(/<img[.\r\n]*?>/ig, "")
		}
		
		//Iframe bug fix for IE (leaves screen white);
		if(IS_IE && this.oIframe) this.oIframe.style.width = this.oIframe.offsetWidth + "px";

		if(this.scrolldown) this.oInt.scrollTop = this.oInt.scrollHeight;
	}
	
	this.clear = function(){
		//this.oInt.innerHTML = "<div style='text-align:center;font-family:MS Sans Serif;font-size:8pt'>" + this.msg + "</div>";
	}
	
	/****************
		DATABINDING
	****************/
	this.mainBind = "Contents";
	
	this.__xmlUpdate = function(action, xmlNode, listenNode, UndoObj){
		if(this.addOnly && action != "add") return;
		
		//Action Tracker Support
		if(UndoObj) UndoObj.xmlNode = this.addOnly ? xmlNode : this.XMLRoot;//(contents ? contents.XMLRoot : this.XMLRoot);
		
		//Refresh Properties
		if(this.addOnly){
			XMLDatabase.nodeConnect(this.documentId, xmlNode, null, this);
			var cacheObj = this.getNodeFromCache(listenNode.getAttribute("id")+"|"+this.uniqueId);

			this.loadHTML(this.applyRuleSetOnNode("Contents", xmlNode) || "", true, cacheObj);
		}
		else this.loadHTML(this.applyRuleSetOnNode("Contents", this.XMLRoot) || "");
	}
	
	this.__load = function(node){
		//Add listener to XMLRoot Node
		XMLDatabase.addNodeListener(node, this);
		var value = this.applyRuleSetOnNode("Contents", node);
		
		if(value || typeof value == "string"){
			if(this.caching){
				var cacheObj = this.getNodeFromCache(node.getAttribute("id")+"|"+this.uniqueId);
				if(cacheObj) cacheObj.contents = value;
			}
			this.loadHTML(value);
		}
		else this.clear();
	}
	
	/************************
			DRAGDROP
	************************/
	this.__showDragIndicator = function(sel, e){
		var x = e.offsetX + 22;
		var y = e.offsetY;

		this.oDrag.startX = x;
		this.oDrag.startY = y;

		
		document.body.appendChild(this.oDrag);
		//this.oDrag.getElementsByTagName("DIV")[0].innerHTML = this.selected.innerHTML;
		//this.oDrag.getElementsByTagName("IMG")[0].src = this.selected.parentNode.parentNode.childNodes[1].firstChild.src;
		var oInt = this.__getLayoutNode("Main", "caption", this.oDrag);
		if(oInt.nodeType != 1) oInt = oInt.parentNode;
		
		oInt.innerHTML = this.applyRuleSetOnNode("Caption", this.XMLRoot) || "";
		
		return this.oDrag;
	}
	
	this.__hideDragIndicator = function(){
		this.oDrag.style.display = "none";
	}
	
	this.__moveDragIndicator = function(e){
		this.oDrag.style.left = (e.clientX - this.oDrag.startX) + "px";
		this.oDrag.style.top = (e.clientY - this.oDrag.startY) + "px";
	}
	
	this.__initDragDrop = function(){
		//don't execute when only receiving;
		
		this.oDrag = document.body.appendChild(this.oExt.cloneNode(true));
		this.oDrag.id = "";
		
		this.oDrag.style.zIndex = 1000000;
		this.oDrag.style.position = "absolute";
		this.oDrag.style.cursor = "default";
		this.oDrag.style.filter = "progid:DXImageTransform.Microsoft.Alpha(opacity=50)";
		this.oDrag.style.MozOpacity = 0.5;
		this.oDrag.style.opacity = 0.5;
		this.oDrag.style.display = "none";
		
		//remove id's
	}
	
	this.__dragout = 
	this.__dragover = 
	this.__dragdrop = function(){}
	
	this.inherit(DragDrop);
	
	/************************
			  CACHING
	************************/
	
	this.__getCurrentFragment = function(){
		return {
			nodeType : 1,
			contents : this.oInt.innerHTML
		}
	}
	
	this.__setCurrentFragment = function(fragment){
		this.oInt.innerHTML = fragment.contents;
		if(this.scrolldown) this.oInt.scrollTop = this.oInt.scrollHeight;
	}

	this.__findNode = function(cacheNode, id){
		id = id.split("\|");
		
		if((cacheNode ? cacheNode : this).XMLRoot.selectSingleNode("descendant-or-self::node()[@id='" + (id[0]+"|"+id[1]) + "']")) 
			return (cacheNode ? cacheNode : null);

		return false;
	}
	
	this.__setClearMessage = function(msg){
		/*var oEmpty = XMLDatabase.htmlImport(this.__getLayoutNode("Empty"), this.oInt);
		var empty = this.__getLayoutNode("Empty", "caption", oEmpty);
		if(empty) empty.nodeValue = msg;
		if(oEmpty) oEmpty.setAttribute("id", "empty" + this.uniqueId);*/
		
		//hack!
		this.oInt.innerHTML = "";
	}
	
	this.__removeClearMessage = function(){
		var oEmpty = document.getElementById("empty" + this.uniqueId);
		if(oEmpty) oEmpty.parentNode.removeChild(oEmpty);
		else this.oInt.innerHTML = ""; //clear if no empty message is supported
	}
	
	this.inherit(Cache);
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		this.oExt = this.__getExternal(); 
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);
		
		if(this.oInt.tagName.toLowerCase() == "iframe"){
			if(IS_IE){
				this.oIframe = this.oInt;
				var iStyle = this.skin.selectSingleNode("iframe_style");
				this.oIframe.contentWindow.document.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><head><style>" + (iStyle ? iStyle.firstChild.nodeValue : "") + "</style><script>document.onkeydown = function(e){if(!e) e = event;if(" + 'top.Kernel.disableF5' + " && e.keyCode == 116){e.keyCode = 0;return false;}}</script></head><body oncontextmenu='return false'></body>");
				this.oInt = this.oIframe.contentWindow.document.body;
			}
			else{
				var node = document.createElement("div");
				this.oExt.parentNode.replaceChild(node, this.oExt);
				node.className = this.oExt.className;
				this.oExt = this.oInt = node;
			}
		}
		else{
			this.oInt.onselectstart = function(e){(e?e:event).cancelBubble = true;}
			this.oInt.oncontextmenu = function(e){(e?e:event).cancelBubble = true;}
			this.oInt.style.cursor = "";
		
			this.oInt.onmouseover = function(e){
				if(!self.STATUSBAR) return;
				if(!e) e = event;
				
				if(e.srcElement.tagName.toLowerCase() == "a"){
					if(!this.lastStatus) this.lastStatus = STATUSBAR.getStatus();
					STATUSBAR.setStatus("icoLink.gif", e.srcElement.getAttribute("href"));
				}
				else if(this.lastStatus){
					STATUSBAR.setStatus(this.lastStatus[0], this.lastStatus[1]);
					this.lastStatus = false;
				}
			}
		}
	}

	this.__loadJML = function(x){
		if(x.getAttribute("behavior") == "add-only") this.addOnly = true;
		if(x.getAttribute("scrolldown") == "true") this.scrolldown = true;
		
		this.protection = x.getAttribute("protection") == "true";
		this.caching = false;// hack
		
		if(x.childNodes.length == 1 && x.firstChild.nodeType != 1) this.loadHTML(x.firstChild.nodeValue)
		else if(x.childNodes) Application.loadSubNode(x, this.oInt, this);
	}
	
	this.__destroy = function(){
		Kernel.removeNode(this.oDrag);
		this.oDrag = null;
		this.oIframe = null;
	}
}

/*FILEHEAD(/in/Components/Textbox.js)SIZE(22383)TIME(1188383718500)*/

var _FALSE_ = 9128748732;

var _REF = {};
_REF["0"] = "\\d";
_REF["1"] = "[12]";
_REF["9"] = "[\\d ]";
_REF["#"] = "[\\d +-]";
_REF["L"] = "[A-Za-z]";
_REF["?"] = "[A-Za-z ]";
_REF["A"] = "[A-Za-z0-9]";
_REF["a"] = "[A-Za-z0-9 ]";
_REF["X"] = "[0-9A-Fa-f]";
_REF["V"] = "[0-9A-Fa-fV]"; //Vonage virtual mac address
_REF["x"] = "[0-9A-Fa-f ]";
_REF["&"] = "[^\s]";
_REF["C"] = ".";

var KNOWN = {}
KNOWN["EMAIL"] = /^[A-Z0-9\.\_\%\-]+@(?:[A-Z0-9\-]+\.)+[A-Z]{2,4}$/i;
KNOWN["URL"] = /^(?:https?:\/\/)?(?:(?:[\w\-]+\.)+(?:[a-z]+)|(?:(?:1?\d?\d?|2[0-4]9|25[0-5])\.){3}(?:1?\d\d|2[0-4]9|25[0-5]))(?:\:\d+)?(?:\/([^\s\\\%]+|%[\da-f]{2})*)?$/i;
KNOWN["DATE"] = "checkDate(this.getValue())";
KNOWN["EXPDATE"] = "checkExpDate(this.getValue())";
KNOWN["EXPFULLDATE"] = "checkExpDate(this.getValue(), true)";
KNOWN["DATENL"] = "checkDate(this.getValue(), true)";
KNOWN["DATESE"] = "checkSeDate(this.getValue())";
KNOWN["CREDITCARD"] = "checkCreditCard(this.getValue())";
KNOWN["WECHARS"] = /^[0-9A-Za-z\xC0-\xCF\xD1-\xD6\xD8-\xDD\xDF-\xF6\xF8-\xFF -\.',]+$/;

//http://www.beachnet.com/~hstiles/cardtype.html
function checkCreditCard(value){
	value = value.replace(/ /g, "");
	value = value.pad(21, "0", PAD_LEFT);
	for(var total=0,r,i=value.length;i>=0;i--){
		r = value.substr(i, 1)*(i%2+1);
		total += r > 9 ? r-9 : r;
	}
	return total%10==0;
}

function checkExpDate(value, fulldate){
	value = value.replace(/-/g, "/");
	value = value.split("/");//.match(/(\d{2})\/(\d{2})/);

	var dt = new Date(value[0] + "/01/" + value[1]);
	if(fulldate && dt.getFullYear() != parseFloat(value[1])) return false;
	if(!fulldate && dt.getYear() != parseFloat(value[1])) return false;
	if(dt.getMonth() != parseFloat(value[0])-1) return false;
	
	return true;
}

function checkDate(value, isNlDate){
	value = value.replace(/-/g, "/");

	if(isNlDate) value = value.replace(/(\d{2})\/(\d{2})\/(\d{4})/, "$2/$1/$3");
	else value.match(/(\d{2})\/(\d{2})\/(\d{4})/);
	if(!RegExp.$3 || RegExp.$3.length < 4) return false;

	var dt = new Date(value);
	//var year = dt.getYear().toString();
	//(year.length == 2 ? "19" + year : year)
	if(dt.getFullYear() != parseFloat(RegExp.$3)) return false;
	if(dt.getMonth() != parseFloat(RegExp.$2)-1) return false;
	if(dt.getDate() != parseFloat(RegExp.$1)) return false;
	
	return true;
}

function checkSeDate(value){
	value = value.replace(/-/g, "/");

	value = value.replace(/(\d{2})\/(\d{2})\/(\d{2})/, "$2/$3/20$1");
	//if(!RegExp.$1 || RegExp.$1.length < 2) return false;

	var dt = new Date(value);
	//var year = dt.getYear().toString();
	//(year.length == 2 ? "19" + year : year)
	if(dt.getFullYear() != 2000+parseInt(RegExp.$1)) return false;
	if(dt.getMonth() != parseInt(RegExp.$2)-1) return false;
	if(dt.getDate() != parseInt(RegExp.$3)) return false;
	
	return true;
}

function Textbox(pHtmlNode){
	Kernel.register(this, "Textbox", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	this.inherit(DataBinding);
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.focussable = true; // This object can get the focus
	this.inherit(Validation);
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/

	this.setValue = function(value){
		return this.setProperty("value", value);
	}
	
	this.clear = function(){
		this.value = "";
		if(this.mask) return this.setValue("");
		
		if(this.oInt.tagName.toLowerCase().match(/input|textarea/i)) this.oInt.value = "";
		else{
			this.oInt.innerHTML = "";
			//try{this.oInt.focus();}catch(e){}
			
			if(!IS_IE) return;
			
			//will fail when object isn't visible
			//N.B. why a select in a clear function.. isn't consistent...
			try{
				var range = document.selection.createRange();
				range.moveStart("sentence", -1);
				//range.text = "";
				range.select();
			}catch(e){}
		}
	}
	
	this.getValue = function(){
		//.replace(/\<P\>(.*)\<\/P\>/gi, "$1\n").replace(/\&nbsp;/, " ")
		return this.isHTMLBox ? this.oInt.innerHTML : this.oInt.value;
	}
	
	this.insert = function(text){
		if(IS_IE){
			try{this.oInt.focus();}catch(e){}
			var range = document.selection.createRange();
			if(this.oninsert) text = this.oninsert(text);
			range.pasteHTML(text);
			range.collapse(true);
			range.select();
		}
		else{
			this.oInt.value += text;
		}
	}
	
	this.__enable = function(){
		this.oInt.disabled = false;
	}
	
	this.__disable = function(){
		this.oInt.disabled = true;
	}
	
	this.select = function(){
		this.oInt.select();
	}
	
	this.deselect = function(){
		this.oInt.deselect();
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/

	/************************
			MASK Support
	************************/
	var lastPos = -1;
	var focusSelect = false;
	var masking = false;
	var initial, pos, myvalue, format, fcase, replaceChar, oExt;
	
	this.__initMasking = function(){
		this.keyHandler = this._keyHandler;
		this.keyHandlerWA = this._keyHandler; //temp solution
		masking = true;

		this.oInt.onkeypress = function(){
			var chr = String.fromCharCode(self.event.keyCode);
			chr = (self.event.shiftKey ? chr.toUpperCase() : chr.toLowerCase());
			if(setCharacter(chr)) setPosition(lastPos + 1);

			return false;
		}
		
		this.oInt.onmouseup = function(){
         var pos = Math.min(calcPosFromCursor(), myvalue.length);
         setPosition(pos);
         return false;
     }
		
		this.oInt.onpaste = function(){
			event.returnValue = false;
			this.host.setValue(window.clipboardData.getData("Text") || "");
			//setPosition(lastPos);
			setTimeout(function(){setPosition(lastPos);}, 1); //HACK good enough for now...
		}
		
		this.getValue = function(){
			if(this.includeNonTypedChars) return initial == this.oInt.value ? "" : this.oInt.value.replace(new RegExp(replaceChar, "g"), "");
			else return myvalue.join("");
		}
		
		this.setValue = function(value){
			if(this.includeNonTypedChars){
				for(var data="",i=0;i<initial.length;i++){
					if(initial.substr(i,1) != value.substr(i,1)) data += value.substr(i,1);//initial.substr(i,1) == replaceChar
				}
			}
			this.__insertData(data);
		}
	}
	
	this.setMask = function(m){
		if(!masking) this.__initMasking();
		
		var m = m.split(";");
		replaceChar = m.pop();
		this.includeNonTypedChars = parseInt(m.pop()) !== 0, mask = m.join(""); //why a join here???
		var validation = "", visual="", mode_case="-", strmode = false, startRight = false, chr;
		pos=[], format="", fcase="";
		
		for(var looppos=-1,i=0;i<mask.length;i++){
			chr = mask.substr(i,1);
			
			if(!chr.match(/[\!\'\"\>\<\\]/)) looppos++;
			else{
				if(chr == "!") startRight = true;
				else if(chr == "<" || chr == ">") mode_case = chr;
				else if(chr == "'" || chr == "\"") strmode = !strmode;
				continue;
			}
			
			if(!strmode && _REF[chr]){
				pos.push(looppos);
				visual += replaceChar;
				format += chr;
				fcase += mode_case;
				validation += _REF[chr];
			}
			else visual += chr;
		}

		this.oInt.value = visual;
		initial = visual;
		//pos = pos;
		myvalue = [];
		//format = format;
		//fcase = fcase;
		replaceChar = replaceChar;
		
		//setPosition(0);//startRight ? pos.length-1 : 0);
		
		//validation..
		//forgot \ escaping...
	}
	
	function checkChar(chr, p){
		var f = format.substr(p, 1);
		var c = fcase.substr(p, 1);
	
		if(chr.match(new RegExp(_REF[f])) == null) return _FALSE_;
		if(c == ">") return chr.toUpperCase();
		if(c == "<") return chr.toLowerCase();
		return chr;
	}
	
	function setPosition(p){
		if(p < 0) p = 0;

		var range = oExt.createTextRange();
		range.expand("textedit");
		range.select();
		
		if(pos[p] == null){
			range.collapse(false);
			range.select();
			lastPos = pos.length;
			return false;
		}
		
		range.collapse();
		range.moveStart("character", pos[p]);
		range.moveEnd("character", 1);
		range.select();

		lastPos = p;
	}
	
	function setCharacter(chr){
		if(pos[lastPos] == null) return false;
		
		var chr = checkChar(chr, lastPos);
		if(chr == _FALSE_) return false;

		var range = oExt.createTextRange();
		range.expand("textedit");
		range.collapse();
		range.moveStart("character", pos[lastPos]);
		range.moveEnd("character", 1);
		range.text = chr;
		if(me.getFocussedObject == this) range.select();
		
		myvalue[lastPos] = chr;
		
		return true;
	}
	
	function deletePosition(p){
		if(pos[p] == null) return false;
		
		var range = oExt.createTextRange();
		range.expand("textedit");
		range.collapse();
		range.moveStart("character", pos[p]);
		range.moveEnd("character", 1);
		range.text = replaceChar;
		range.select();
		
		//ipv lastPos
		myvalue[p] = " ";
	}
	
	this.__insertData = function(str){
		if(!masking) return this.setValue(str);
		
		if(str == this.getValue()) return;
		str = this.dispatchEvent("oninsert", str) || str;
		
		if(!str){
			if(!this.getValue()) return; //maybe not so good fix... might still flicker when content is cleared
			for(var i=this.getValue().length-1;i>=0;i--) deletePosition(i);
			setPosition(0);	
			return;
		}
		
		for(var i=0;i<str.length;i++){
			lastPos = i;
			setCharacter(str.substr(i,1));
		}
		if(str.length) lastPos++;
	}
	
	function calcPosFromCursor(){
		var range = document.selection.createRange();
		r2 = range.duplicate();
		r2.expand("textedit");
		r2.setEndPoint("EndToStart", range);
		var lt = r2.text.length;
	
		for(var i=0;i<pos.length;i++)
			if(pos[i] > lt) return i == 0 ? 0 : i-1;
	}
	
	/************************
		Keyboard Support
	************************/
	this.z = 0;
	
	this.keyHandler = function(){}
	
	//Normal
	this.keyHandlerWA = function(key, ctrlKey, shiftKey, altKey, e){
		if(this.dispatchEvent("onkeydown", key, ctrlKey, shiftKey, altKey, e) === false) return false;
		
		if(false && IS_IE && (key == 86 && ctrlKey || key == 45 && shiftKey)){
			var text = window.clipboardData.getData("Text");
			if((text = this.dispatchEvent("onkeydown", this.onpaste(text)) === false)) return false;
			if(!text) text = window.clipboardData.getData("Text");
			
			this.oInt.focus();
			var range = document.selection.createRange();
			range.text = "";
			range.collapse();
			range.pasteHTML(text.replace(/\n/g, "<br />").replace(/\t/g, "&nbsp;&nbsp;&nbsp;"));
			
			return false;
		}
	}
	
	//Mask
	this._keyHandler = function(key, ctrlKey, shiftKey, altKey, e){
		if(this.dispatchEvent("onkeydown", key, ctrlKey, shiftKey, altKey, e) === false) return false;

		switch(key){
			case 39:	
			//RIGHT
				setPosition(lastPos+1);
			break;
			case 37:
			//LEFT
				setPosition(lastPos-1);
			break;
			case 35:
			case 34:
				setPosition(myvalue.length);
			break;
			case 33:
			case 36:
				setPosition(0);
			break;
			case 8:
			//BACKSPACE
				deletePosition(lastPos-1);
				setPosition(lastPos-1);
			break;
			case 46:
			//DEL
				deletePosition(lastPos);
				setPosition(lastPos);
			break;
			default:
				if(key == 67 && ctrlKey)
					window.clipboardData.setData("Text", this.getValue());  
				/*else if((key == 86 && ctrlKey) || (shiftKey && key == 45)){
					this.setValue(window.clipboardData.getData("Text"));
					setPosition(lastPos);
				}*/
				else return;
			break;
		}
			
		return false
	}
	
	/************************
				Focus
	************************/
	
	this.__focus = function(){
		if(!this.oExt) return;
		if(this.oExt && this.oExt.disabled) return false;

		try{this.oInt.focus();}catch(e){}
		this.__setStyleClass(this.oExt, this.baseCSSname + "Focus");

		if(masking) setPosition(lastPos || 0);
		
		if(this.selectFocus){focusSelect = true;this.select();}
	}
	
	this.__blur = function(){
		if(!this.oExt) return;
		this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Focus"]);
		
		if(masking){
			var r = oExt.createTextRange();
			r.collapse();
			r.select();
		}
		
		try{
			this.oExt.blur();
			document.body.focus();
		}catch(e){}
		
		if(this.changeTrigger == "enter")
			this.Change(this.getValue());
			
		focusSelect = false;
		// check if we clicked on the oContainer. ifso dont hide it
		if(this.oContainer)
			setTimeout('var o = Kernel.lookup(' + this.uniqueId + ');o.oContainer.style.display = "none"', 100);
	}
	
	this.__supportedProperties = ["value"];
	this.__handlePropSet = function(prop, value){
		switch(prop){
			case "value":
				// Set Value
				if(this.isHTMLBox){
					if(this.oInt.innerHTML != value)
						this.oInt.innerHTML = value;
				}
				else if(this.oInt.value != value){
					if(this.mask){
						var data = "";
						if(this.includeNonTypedChars){
							for(var i=0;i<initial.length;i++){
								if(initial.substr(i,1) != value.substr(i,1)) data += value.substr(i,1);//initial.substr(i,1) == replaceChar
							}
						}
						
						this.__insertData(data || value);
					}
					else this.oInt.value = value;
				}
			break;
		}
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = oExt = this.__getExternal(null, null, function(){
			if(this.jml.getAttribute("mask") == "PASSWORD"){
				this.jml.removeAttribute("mask");
				this.__getLayoutNode("Main", "input").setAttribute("type", "password");
			}
		}); 
		this.oInt = this.__getLayoutNode("Main", "input", this.oExt);	
		
		if(!IS_IE && !this.oInt.tagName.toLowerCase().match(/input|textarea/)){
			var node = this.oInt;
			this.oInt = node.parentNode.insertBefore(document.createElement("textarea"), node);
			node.parentNode.removeChild(node);
			this.oInt.className = node.className;
			//this.oInt.onmousedown = function(e){e.cancelBubble = true;}
			if(this.oExt == node) this.oExt = this.oInt;
		}
		
		this.oInt.onselectstart = function(e){if(!e) e = event;e.cancelBubble = true}
		/*this.oInt.onkeydown = function(e){
			if(!e) e = event;
			if(this.host.changeTrigger == "realtime" || this.host.changeTrigger == "enter" && e.keyCode == 13){
				this.host.Change(this.host.getValue());
			}
		}*/
		this.oInt.host = this;
		
		//temp fix
		this.oInt.onkeydown = function(e){
			if(this.disabled) return false;
			
			if(!e) e = event;
			//e.cancelBubble = true;
			
			if(!e) e = event;
			if(this.host.changeTrigger == "enter"){
				if(e.keyCode == 13) this.host.Change(this.host.getValue());
			}
			else if(IS_SAFARI && this.host.XMLRoot){ //safari issue (only old??)
				setTimeout('var o = Kernel.lookup(' + this.host.uniqueId + ');o.Change(o.getValue())');
			}
			
			if(e.ctrlKey && (e.keyCode == 66 || e.keyCode == 73 || e.keyCode == 85)) return false; 
			
			if(this.host.oContainer){
				var oTxt = this.host;
				var keyCode = e.keyCode;
				setTimeout(function(){fillAutocomplete.call(oTxt, keyCode);});
			}
			
			if(!this.host.mask) return this.host.keyHandlerWA(e.keyCode, e.ctrlKey, e.shiftKey, e.altKey, e);
		}
		
		this.oInt.onkeyup = function(e){
			var keyCode = (e||event).keyCode, jmlNode = this.host;
			if(this.host.changeTrigger != "enter") {

				setTimeout(function(){
					if(!jmlNode.mask) jmlNode.Change(jmlNode.getValue()); //this is a hack
					jmlNode.dispatchEvent("onkeyup", keyCode);
				});
			}
			else{
				jmlNode.dispatchEvent("onkeyup", keyCode);
			}

			//if(this.host.oContainer) fillAutocomplete.call(this.host, e || event);
		}

		this.oInt.onfocus = function(){
			if(this.host.initial && this.value == this.host.initial){
				this.value = "";
				this.host.__setStyleClass(this.host.oExt, "", [this.host.baseCSSname + "Initial"]);
			}
		}
		
		this.oInt.onblur = function(){
			if(this.host.initial && this.value == ""){
				this.value = this.host.initial;
				this.host.__setStyleClass(this.host.oExt, this.host.baseCSSname + "Initial");
			}
		}

		//if(IS_IE){
			//Why this event??????
			/*this.oInt.onchange = function(){
				if(this.host.changeTrigger != "enter") 
					setTimeout('var o = Kernel.lookup(' + this.host.uniqueId + ');o.Change(o.getValue())');
				//this.host.Change(this.host.getValue());
			}*/
		//}
		
		if(!this.oInt.tagName.toLowerCase().match(/input|textarea/)){
			this.isHTMLBox = true;
			
			this.oInt.unselectable = "Off";
			this.oInt.contentEditable = true;
			//this.oTxt.canHaveHTML = false;
			this.oInt.style.width = "1px";
			
			this.oInt.select = function(){
				var r = document.selection.createRange();
				//r.moveEnd("character", this.oExt.innerText.length);
				r.moveToElementText(this);
				r.select();
			}
		}
		
		this.oInt.deselect = function(){
			if(!document.selection) return;
			
			var r = document.selection.createRange();
			r.collapse();
			r.select();
		}
	}
	
	/*
		Special Masking Values:
		- PASSWORD
		
		<j:Textbox name="custref" mask="CS20999999" maskmsg="" validation="/CS200[3-5]\d{4}/" invalidmsg="" bind="custref/text()" />
	*/
	var autocomplete = {};
	this.__loadJML = function(x){
		if(IS_IE){
			this.mask = x.getAttribute("mask");
			if(this.mask && !this.mask.match(/PASSWORD/)) this.setMask(this.mask);
			this.maskmsg = x.getAttribute("maskmsg");
		}
		
		this.initial = x.getAttribute("initial") || "";
		if(this.initial){
			this.oInt.onblur();
			this.setValue(this.initial);
		}
		
		this.changeTrigger = XMLDatabase.getInheritedAttribute(x, "change") || "realtime";
		this.selectFocus = x.getAttribute("focusselect") == "true";
		if(this.mask){
			this.selectFocus = false;
			this.changeTrigger = "enter";
		}
		//if(x.getAttributeNode("value")) this.setValue(x.getAttribute("value"));
		if(this.selectFocus){
			this.oInt.onmouseup = function(){if(focusSelect){this.select();focusSelect=false;}this.host.dispatchEvent("onmouseup");return false;}
		}
		
		if(x.getAttribute("max-length") && this.oInt.tagName.toLowerCase().match(/input|textarea/))
			this.oInt.maxLength = parseInt(x.getAttribute("max-length"));
		
		var ac = $j(x, "autocomplete")[0];
		if(ac){
			x.removeChild(ac);
			autocomplete.nodeset = ac.getAttribute("nodeset").split(":");
			autocomplete.method = ac.getAttribute("method");
			autocomplete.value = ac.getAttribute("value");
			autocomplete.count = parseInt(ac.getAttribute("count")) || 5;
			autocomplete.sort = ac.getAttribute("sort");
			autocomplete.lastStart = -1;
			
			this.oContainer = XMLDatabase.htmlImport(this.__getLayoutNode("Container"), this.oExt.parentNode, this.oExt.nextSibling);
		}
		
		this.oExt.onmousedown = function(){this.host.dispatchEvent("onmousedown");}
		if(!this.oExt.onmouseup) this.oExt.onmouseup = function(){this.host.dispatchEvent("onmouseup");}
		this.oExt.onclick = function(){this.host.dispatchEvent("onclick");}
		
		Application.loadSubNode(this.jml, null, this);
	}
	
	/*
		missing features:
		- web service based autocomplete
	*/
	function fillAutocomplete(keyCode){
		if(keyCode){
			switch(keyCode){
				case 9:
				case 27: 
				case 13:  
					return this.oContainer.style.display = "none";
				case 40: //DOWN
					if(autocomplete.suggestData && autocomplete.lastStart < autocomplete.suggestData.length){
						this.clear();
						var value = autocomplete.suggestData[autocomplete.lastStart++];
						this.oInt.value = value; //hack!
						this.Change(value);
						//this.oInt.select(); this.oInt.focus();
						this.oContainer.style.display = "none";
						return;
					}
				break;
				case 38: //UP
					if(autocomplete.lastStart > 0){
						if(autocomplete.lastStart >= autocomplete.suggestData.length) 
							autocomplete.lastStart = autocomplete.suggestData.length - 1;

						this.clear();
						var value = autocomplete.suggestData[autocomplete.lastStart--];
						this.oInt.value = value; //hack!
						this.Change(value);
						//this.oInt.select(); this.oInt.focus();
						this.oContainer.style.display = "none";
						return;
					}
				break;
			}
			
			if(keyCode > 10 && keyCode < 20) return;
		}
		
		if(autocomplete.method){
			var start=0, suggestData = self[autocomplete.method]();
			autocomplete.count = suggestData.length;
		}
		else{
			if(this.oInt.value.length==0){
				this.oContainer.style.display = "none";
				return;
			}
			if(!autocomplete.suggestData){
				//Get data from model
				var nodes = self[autocomplete.nodeset[0]].data.selectNodes(autocomplete.nodeset[1]);
				for(var value, suggestData=[],i=0;i<nodes.length;i++){
					value = getXMLValue(nodes[i], autocomplete.value);
					if(value) suggestData.push(value.toLowerCase());
				}
				if(autocomplete.sort) suggestData.sort();
				autocomplete.suggestData = suggestData;
			}
			else{
				suggestData = autocomplete.suggestData;
			}
			
			//Find Startpoint in lookup list
			var value = this.oInt.value.toUpperCase();
			for(var start=suggestData.length-autocomplete.count,i=0;i<suggestData.length;i++){
				if(value <= suggestData[i].toUpperCase()){
					start = i;
					break;
				}
			}
			
			autocomplete.lastStart = start;
		}
		
		//Create html items
		this.oContainer.innerHTML = "";
		
		for(var arr=[],j=start;j<Math.min(start+autocomplete.count, suggestData.length);j++){
			this.__getNewContext("Item")
			var oItem = this.__getLayoutNode("Item");
			XMLDatabase.setNodeValue(this.__getLayoutNode("Item", "caption"), suggestData[j]);
			
			oItem.setAttribute("onmouseover", 'this.className = "hover"');
			oItem.setAttribute("onmouseout", 'this.className = ""');
			oItem.setAttribute("onmousedown", 'event.cancelBubble = true');
			oItem.setAttribute("onclick", 'var o = Kernel.lookup(' + this.uniqueId + ');o.oInt.value = this.innerHTML;o.Change(this.innerHTML);o.oInt.select();o.oInt.focus();o.oContainer.style.display = "none";');
			
			arr.push(this.__getLayoutNode("Item"));
		}
		XMLDatabase.htmlImport(arr, this.oContainer);
		
		this.oContainer.style.display = "block";
	}
	
	this.__destroy = function(){
		this.oInt.onkeypress = 
		this.oInt.onmouseup = 
		this.oInt.onkeydown = 
		this.oInt.onkeyup = 
		this.oInt.onselectstart = null;
	}
}

/*FILEHEAD(/in/Components/Tinymce.js)SIZE(3091)TIME(1188383718500)*/

function Tinymce(pHtmlNode){
	Kernel.register(this, "Tinymce", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
	  		Inheritance
	************************/
	this.inherit(DataBinding);
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.focussable = true; // This object can't get the focus
	this.inherit(Validation);

	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.getValue = function(){
		this.oExt.contentWindow.getEditorHtml();
	}
	
	this.keyHandler = function(key,ctrlKey,shiftKey,altKey){
		switch(key){
			default:
			return;
		}
		
		return false;
	}
	
	this.setValue = 
	this.loadHTML = function(strHTML){
		if(this.oExt.contentWindow.setEditorHtml && this.oExt.contentWindow.getEditorHtml() != strHTML)
			this.oExt.contentWindow.setEditorHtml(strHTML);
	}
	
	this.clear = function(){
		if(this.oExt.contentWindow.setEditorHtml)
			this.oExt.contentWindow.setEditorHtml("");
	}
	
	this.__focus = function(){
		try{
			this.oExt.contentWindow.document.getElementsByTagName("IFRAME")[0].contentWindow.document.body.focus();
		}catch(e){}
	}
	this.__blur = function(){}
	
	/****************
		DATABINDING
	****************/
	this.mainBind = "Contents";
	
	this.__xmlUpdate = function(action, xmlNode, listenNode, UndoObj){
		//Action Tracker Support
		if(UndoObj) UndoObj.xmlNode = this.XMLRoot;//(contents ? contents.XMLRoot : this.XMLRoot);
		
		//Refresh Properties
		this.loadHTML(this.applyRuleSetOnNode("Contents", this.XMLRoot) || "");
	}
	
	this.__load = function(node){
		//Add listener to XMLRoot Node
		XMLDatabase.addNodeListener(node, this);
		this.loadHTML(this.applyRuleSetOnNode("Contents", node) || "");
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.initFrame = function(win){
		if(this.XMLRoot) this.reload();
	}
	
	this.draw = function(){
		pHtmlNode.insertAdjacentHTML("beforeend", "<iframe id='iframe_" + this.uniqueId + "' width='100%' height='100%' src='tinymce/HTMLEditor.htm?" + this.uniqueId + "'></iframe>");
		this.oExt = this.oInt = document.getElementById("iframe_" + this.uniqueId);
		this.oExt.contentWindow.uniqueId = this.uniqueId;
		this.oExt.contentWindow.host = this;
		
		this.oExt.host = this;
		this.oExt.onblur = function(){
			if(this.host.XMLRoot)
				this.host.Change(this.contentWindow.getEditorHtml());	
		}
	}

	this.__loadJML = function(x){
		if(x.childNodes.length == 1 && x.firstChild.nodeType != 1) this.loadHTML(x.firstChild.nodeValue)
		else if(x.childNodes) Application.loadSubNode(x, this.oInt, this);
	}
	
	this.__destroy = function(){
		this.oExt.onblur = null;
	}
}


/*FILEHEAD(/in/Components/Toolbar.js)SIZE(6399)TIME(1182723583203)*/

function Toolbar(pHtmlNode){
	Kernel.register(this, "Toolbar", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;

	var lastbars = null, bars = [];

	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.addDivider = function(elBar){
		elBar.children.push({
			tagName : "Divider",
			oExt : XMLDatabase.htmlImport(this.__getLayoutNode("Divider"), elBar.oInt),
			hide : function(){this.oExt.style.display = "none";},
			show : function(){this.oExt.style.display = "block";}
		});
	}
	
	this.addBar = function(xmlNode){
		this.__getNewContext("Bar");
		var p = this.__getLayoutNode("Bar");
		if(xmlNode.getAttribute("css")) p.setAttribute("style", xmlNode.getAttribute("css"));
		
		var elBar = XMLDatabase.htmlImport(p, this.oInt);
		var elBarInt = this.__getLayoutNode("Bar", "container", elBar);
		var isMenu = xmlNode.getAttribute("type") == "menu";
		if(isMenu) this.__setStyleClass(elBar, "menubar");

		var oBar = {
			oExt : elBar,
			oInt : elBarInt,
			isMenu : isMenu,
			children : [],
			childNodes : []
		};
		oBar.inherit = Kernel.inherit;
		oBar.inherit(JmlDomAPI);
		//oBar.childNodes = oBar.children;
		this.childNodes.push(oBar);
		
		if(xmlNode.getAttribute("height")) oBar.oExt.style.height = xmlNode.getAttribute("height") + "px";
		var id = bars.push(oBar) - 1;
		
		//parse children
		if(lastbars){
			var childs = lastbars[id].children;
			for(var i=0;i<childs.length;i++){
				if(childs[i].tagName == "Divider") this.addDivider(oBar);
				else{
					childs[i].parentNode = oBar;
					elBarInt.appendChild(childs[i].oExt);
					oBar.children.push(childs[i]);
				}
			}
			oBar.childNodes = lastbars[id].childNodes;
		}
		else{
			var nodes = xmlNode.childNodes;
			for(var i=0;i<nodes.length;i++){
				if(nodes[i].nodeType != 1) continue;
				var tagName = nodes[i].tagName.replace(/^j\:/, "");
				
				if(tagName == "Divider") this.addDivider(oBar);
				else{
					var o = Application.createElement(nodes[i], elBarInt);
					oBar.childNodes.push(o);
					this.__setStyleClass(o.oExt, "toolbar_item");
					
					if(tagName == "Button"){
						if(nodes[i].getAttribute("submenu")) this.setMenuButton(o, nodes[i], xmlNode, oBar);
						o.focussable = false;
					}
					
					o.barId = oBar.children.push(o) - 1;
					//o.focussable = false;
					
					//if(!o.onclick){
						var toolbar = this;
						o.addEventListener("onclick", function(){toolbar.dispatchEvent("onitemclick", this.sValue);});
					//}
				}
			}
		}

		return oBar;
	}
	
	this.setMenuButton = function(o, node, xmlNode, oBar){
		o.submenu = node.getAttribute("submenu");
		o.bar = this;
		o.subbar = oBar;
		o.__setStateBehaviour();
		o.__blurhook = function(){if(this.value){this.__setState("Down", {}, "onmousedown");this.hideMenu()}}
		
		o.addEventListener("onmousedown", function(e){
			if(!e) e = event;
			
			if(this.value){
				self[this.submenu].hideMenu();
				this.__setState("Over", {}, "ontbover");
				if(this.bar.hasMoved) this.value = false;
				this.bar.menuIsPressed = false;
				return;
			}

			this.bar.menuIsPressed = this;
			
			var pos = Kernel.compat.getAbsolutePosition(this.oExt, self[this.submenu].oExt.offsetParent || self[this.submenu].oExt.parentNode);
			self[this.submenu].oExt.style.left = pos[0] + "px";
			self[this.submenu].oExt.style.top = (pos[1]+this.oExt.offsetHeight) + "px";
			//self[this.submenu].oExt.style.visibility = "visible";
			//self[this.submenu].oExt.style.display = "block";
			self[this.submenu].showMenu();
			e.cancelBubble = true;
			//self[this.submenu].display(pos[0], pos[1]+this.oExt.offsetHeight, false, this);
			
			this.bar.hasMoved = false;
		});
		
		o.addEventListener("onmouseover", function(){
			if(this.bar.menuIsPressed && this.bar.menuIsPressed != this){
				this.bar.menuIsPressed.setValue(false);
				self[this.bar.menuIsPressed.submenu].hideMenu();
				
				this.setValue(true);
				
				this.bar.menuIsPressed = this;
				var pos = Kernel.compat.getAbsolutePosition(this.oExt, self[this.submenu].oExt.offsetParent || self[this.submenu].oExt.parentNode);
				self[this.submenu].display(pos[0], pos[1]+this.oExt.offsetHeight, true, this);
				
				me.__focus(this);
				
				this.bar.hasMoved = true;
			}
		});
			
		//keyboard hook
		o.addEventListener("onkeydown", function(key){
			switch(key){
				case 37:
					//left
					var id = this.barId == 0 ? this.subbar.children.length-1 : this.barId-1;
					this.subbar.children[id].dispatchEvent("onmouseover");
				break;
				case 39:
					//right
					var id = this.barId >= this.subbar.children.length-1 ? 0 : this.barId+1;
					this.subbar.children[id].dispatchEvent("onmouseover");
				break;
			}
		});
		
		o.hideMenu = function(){
			this.setValue(false);
			//this.oExt.onmouseout({});
			this.__setState("Out", {}, "onmouseout");
			this.bar.menuIsPressed = false;
		}
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);
	}
	
	this.__loadJML = function(x){
		if(bars.length){
			lastbars = bars;
			bars = []; 
			this.childNodes = [];
		}
		
		lastpages = null;

		var nodes = this.jml.childNodes;
		for(var i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1) continue;
			var tagName = nodes[i].tagName.replace(/^j\:/, "");

			if(tagName == "Bar"){
				var p = this.addBar(nodes[i]);
				if(i == 0) this.__setStyleClass(p.oExt, "first");
				if(i == nodes.length-2) this.__setStyleClass(p.oExt, "last");
			}
		}

		lastbars = null;

		/* // Rich Text Editor
		
		var nodes = this.oExt.getElementsByTagName("*");
		for(var i=0;i<nodes.length;i++){
			if(nodes[i].tagName.toLowerCase() != "input" && nodes[i].tagName.toLowerCase() != "select") nodes[i].unselectable = "On";
			else nodes[i].unselectable = "Off";
		}*/
	}
}


/*FILEHEAD(/in/Components/Tree.js)SIZE(31293)TIME(1187087508069)*/

/****************
	TREE
****************/

var HAS_CHILD = 1<<1;
var IS_CLOSED = 1<<2;
var IS_LAST = 1<<3;
var IS_ROOT = 1<<4;

function Tree(pHtmlNode){
	Kernel.register(this, "Tree", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	//Options
	this.isTreeArch = true; // Tree Architecture for loading Data
	this.focussable = true; // This object can get the focus
	this.inherit(Validation);
	
	this.clearMessage = "There are no items";
	this.startClosed = true;
	this.animType = 0;
	this.animSteps = 3;
	this.animSpeed = 20;
	
	this.dynCssClasses = [];
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.openAll = function(){

	}

	this.closeAll = function(){

	}
	
	this.selectPath = function(path){
		
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/
	
	/************************
			DRAGDROP
	************************/
	this.__showDragIndicator = function(sel, e){
		var x = e.offsetX + 22;
		var y = e.offsetY;

		this.oDrag.startX = x;
		this.oDrag.startY = y;

		
		document.body.appendChild(this.oDrag);
		//this.oDrag.getElementsByTagName("DIV")[0].innerHTML = this.selected.innerHTML;
		//this.oDrag.getElementsByTagName("IMG")[0].src = this.selected.parentNode.parentNode.childNodes[1].firstChild.src;
		this.__updateNode(this.value, this.oDrag);
		
		return this.oDrag;
	}
	
	this.__hideDragIndicator = function(){
		this.oDrag.style.display = "none";
	}
	
	this.__moveDragIndicator = function(e){
		this.oDrag.style.left = (e.clientX - this.oDrag.startX) + "px";
		this.oDrag.style.top = (e.clientY - this.oDrag.startY) + "px";
	}
	
	this.__initDragDrop = function(){
		if(!this.__hasLayoutNode("DragIndicator")) return;
		this.oDrag = XMLDatabase.htmlImport(this.__getLayoutNode("DragIndicator"), document.body);
		
		this.oDrag.style.zIndex = 1000000;
		this.oDrag.style.position = "absolute";
		this.oDrag.style.cursor = "default";
		this.oDrag.style.display = "none";
	}
	
	this.findValueNode = function(el){
		if(!el) return null;

		while(el && el.nodeType == 1 && !el.getAttribute(XMLDatabase.htmlIdTag)){
			el = el.parentNode;
		}

		return el && el.nodeType == 1 && el.getAttribute(XMLDatabase.htmlIdTag) ? el : null;
	}
	
	this.__dragout = function(dragdata){
		if(this.lastel) this.__setStyleClass(this.lastel, "", ["dragDenied", "dragInsert", "dragAppend", "selected", "indicate"]);
		this.__setStyleClass(this.selected, "selected", ["dragDenied", "dragInsert", "dragAppend", "indicate"]);
		
		/*if(this.lastel) this.__dragdeselect(this.lastel);
		this.__dragdeselect(this.selected);
		this.__select(this.selected);*/
		this.lastel = null;
	}

	this.__dragover = function(el, dragdata, extra){
		if(el == this.oExt) return;
		
		this.__setStyleClass(this.lastel || this.selected, "", ["dragDenied", "dragInsert", "dragAppend", "selected", "indicate"]);
		//if(this.lastel) this.__dragdeselect(this.lastel);
		//else this.__dragdeselect(this.selected);
		
		
		this.__setStyleClass(this.lastel = this.findValueNode(el), extra ? (extra[1].getAttribute("operation") == "insert-before" ? "dragInsert" : "dragAppend") : "dragDenied");
		//this.__dragselect(this.lastel = this.findValueNode(el));
	}

	this.__dragdrop = function(el, dragdata, extra){
		this.__setStyleClass(this.lastel || this.selected, this.selected ? "selected" : "", ["dragDenied", "dragInsert", "dragAppend", "selected", "indicate"]);
		//if(this.lastel) this.__dragdeselect(this.lastel);
		//this.__dragdeselect(this.selected);
		//this.__select(this.selected);
		
		this.lastel = null;
	}
	
	this.inherit(DragDrop);
	
	/************************
		Sliding Functions
	************************/
	
	this.slideToggle = function(htmlNode, force){
		if(this.noCollapse) return;
		
		var id = htmlNode.getAttribute(XMLDatabase.htmlIdTag);
		while(!id && htmlNode.parentNode)
			var id = (htmlNode = htmlNode.parentNode).getAttribute(XMLDatabase.htmlIdTag);

		/*var xmlNode = XMLDatabase.getNodeById(id);
		var hasChildren = this.getTraverseNodes(xmlNode).length || this.emptyMessage && this.applyRuleSetOnNode("Empty", xmlNode);
		if(!hasChildren) return false;
		else if(!htmlNode.className.match(/plus|min/)) this.fixItem(xmlNode, htmlNode);*/

		var container = this.__getLayoutNode("Item", "container", htmlNode);
		if(Kernel.getStyle(container, "display") == "block"){
			if(force == 1) return;
			htmlNode.className = htmlNode.className.replace(/min/, "plus");
			this.slideClose(container, XMLDatabase.getNode(htmlNode));
		}
		else{
			if(force == 2) return;
			htmlNode.className = htmlNode.className.replace(/plus/, "min");
			this.slideOpen(container, XMLDatabase.getNode(htmlNode));
		}
	}
	
	//htmlNode || xmlNode
	var lastOpened = {};
	this.slideOpen = function(container, xmlNode){
		var htmlNode = XMLDatabase.findHTMLNode(xmlNode, this);
		if(!container)container = this.__findContainer(htmlNode);

		if(this.singleopen){
			var pNode = this.getTraverseParent(xmlNode)
			var p = (pNode || this.XMLRoot).getAttribute(XMLDatabase.xmlIdTag);
			if(lastOpened[p] && lastOpened[p][1] != xmlNode && this.getTraverseParent(lastOpened[p][1]) == pNode) 
				this.slideToggle(lastOpened[p][0], 2);//lastOpened[p][1]);
			lastOpened[p] = [htmlNode, xmlNode];
		}
		
		container.style.display = "block";

		new GuiAnimation(container, 'scrollheight', 0, container.scrollHeight, this.animType, this.animSteps, this.animSpeed, 
			function(container, data){
				if(data[1] && data[0].hasLoadStatus(data[1], "potential")){
					//'Kernel.lookup(' + data[0].uniqueId + ').doUpdate(XMLDatabase.getElementById("' + data[1].getAttribute(XMLDatabase.xmlIdTag) + '"));'
					setTimeout(function(){data[0].doUpdate(data[1], container);});
				}
				else{
					//container.style.overflow = "visible";
					container.style.height = "auto";
				}
			}, [this, xmlNode]);
			
		/*animate([[container.style, "height", container.offsetHeight, container.scrollHeight], [container, "scrollTop", container.scrollHeight, container.scrollHeight]], 3, 10, function (o){
			container.style.overflow = "visible";
			container.style.height = "auto";
		});*/
	}

	this.slideClose = function(container, xmlNode){
		if(this.noCollapse) return;
		
		if(this.singleopen){
			var p = (this.getTraverseParent(xmlNode) || this.XMLRoot).getAttribute(XMLDatabase.xmlIdTag);
			lastOpened[p] = null;
		}
		
		container.style.height = container.offsetHeight;
		container.style.overflow = "hidden";

		new GuiAnimation(container, 'scrollheight', container.offsetHeight, 0, this.animType, this.animSteps, this.animSpeed, 
			function(container, data){
				container.style.display = "none";
			});
		
		/*animate([[container.style, "height", container.offsetHeight, 1], [container, "scrollTop", container.scrollHeight, container.scrollHeight]], 3, 10, function(container, data){
			container.style.display = "none";
		});*/
	}

	//check databinding for how this is normally implemented
	this.doUpdate = function(xmlNode, container){
		var rule = this.getNodeFromRule("Insert", xmlNode, null, true);
		if(rule && xmlNode.selectSingleNode(rule.getAttribute("select"))){
			this.setLoadStatus(xmlNode, "loading");
			
			if(rule.getAttribute("method"))
				return this.insert(self[rule.getAttribute("method")](xmlNode), xmlNode);
			else if(rule.getAttribute("file"))
				this.insertFile(rule.getAttribute("file"), xmlNode);
			
			// Communication
			Kernel.TelePort.hasLoadRule(rule);
			
			var modules = Kernel.TelePort.getModules();
			
			for(var i=0;i<modules.length;i++){
				if(rule.getAttribute(modules[i].name)){
					//modules[i].obj
					this.insertComm(rule, xmlNode, xmlNode);
				}
			}
		}
		else if(!this.prerender){
			this.setLoadStatus(xmlNode, "loading");
			var result = this.__addNodes(xmlNode, container, true); //checkChildren ???
			xmlUpdateHandler.call(this, "insert", xmlNode, result);
		}
	}
	
	/************************
				Skin
	************************/

	this.State = {};
	this.State[0] 											= "";
	this.State[HAS_CHILD] 								= "min";
	this.State[HAS_CHILD | IS_CLOSED] 				= "plus";
	this.State[IS_LAST] 									= "last";
	this.State[IS_LAST | HAS_CHILD] 					= "minlast";
	this.State[IS_LAST | HAS_CHILD | IS_CLOSED] 	= "pluslast";
	this.State[IS_ROOT] 									= "root";

	this.fixItem = function(xmlNode, htmlNode, isDeleting, oneLeft, noChildren){
		if(!htmlNode) return;

		if(isDeleting){
			//if isLast fix previousSibling
			if(prevSib = this.getNextTraverse(xmlNode, true))
				this.fixItem(prevSib, this.getNodeFromCache(prevSib.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId), null, true);

			//if no sibling fix parent
			if(!this.emptyMessage && xmlNode.parentNode.selectNodes(this.ruleTraverse).length == 1)
				this.fixItem(xmlNode.parentNode, this.getNodeFromCache(xmlNode.parentNode.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId), null, false, true); 
		}
		else{
			var container = this.__getLayoutNode("Item", "container", htmlNode);
			var hasChildren = noChildren ? false : (xmlNode.selectNodes(this.ruleTraverse).length > 0 ? true : false);
			var isClosed = hasChildren && container.style.display != "block";
			var isLast = this.getNextTraverse(xmlNode, null, oneLeft ? 2 : 1) ? false : true;

			var state = (hasChildren ? HAS_CHILD : 0) | (isClosed ? IS_CLOSED : 0) | (isLast ? IS_LAST : 0);
			this.__setStyleClass(this.__getLayoutNode("Item", "class", htmlNode), this.State[state], ["min", "plus", "last", "minlast", "pluslast"]);
			this.__setStyleClass(this.__getLayoutNode("Item", "container", htmlNode), this.State[state], ["min", "plus", "last", "minlast", "pluslast"]);
			
			if(!hasChildren) container.style.display = "none";
			
			//Setting events below doesn't work, check out why
			/*if(state & HAS_CHILD){
				this.__getLayoutNode("Item", "openclose", htmlNode).onmousedown = new Function('if(event.button != 1) return;var o = Kernel.lookup(' + this.uniqueId + ');o.slideToggle(this);if(o.onmousedown) o.onmousedown(event, this);Kernel.cancelBubble(event,o);');
				this.__getLayoutNode("Item", "icon", htmlNode)[this.opencloseaction || "ondblclick"] = new Function('var o = Kernel.lookup(' + this.uniqueId + ');o.slideToggle(this);o.choose();');
				this.__getLayoutNode("Item", "select", htmlNode)[this.opencloseaction || "ondblclick"] = new Function('var o = Kernel.lookup(' + this.uniqueId + ');o.slideToggle(this);o.choose();');
			}*/
		}
	}

	//This can be optimized by NOT using getLayoutNode all the time
	this.initNode = function(xmlNode, state, Lid){
		//Setup Nodes Interaction
		this.__getNewContext("Item");
		
		var hasChildren = state & HAS_CHILD || this.emptyMessage && this.applyRuleSetOnNode("Empty", xmlNode);
		
		//should be restructured and combined events set per element 
		this.__getLayoutNode("Item").setAttribute("onmouseover", 'var o = Kernel.lookup(' + this.uniqueId + ');if(o.onmouseover) o.onmouseover(event, this)');
		this.__getLayoutNode("Item").setAttribute("onmouseout", 'var o = Kernel.lookup(' + this.uniqueId + ');if(o.onmouseout) o.onmouseout(event, this)');
		this.__getLayoutNode("Item").setAttribute("onmousedown", 'var o = Kernel.lookup(' + this.uniqueId + ');if(o.onmousedown) o.onmousedown(event, this);');
		
		//Set open/close skin class & interaction
		this.__setStyleClass(this.__getLayoutNode("Item", "class"), this.State[state]).setAttribute(XMLDatabase.htmlIdTag, Lid);
		this.__setStyleClass(this.__getLayoutNode("Item", "container"), this.State[state])
		this.__setStyleClass(this.__getLayoutNode("Item"), xmlNode.tagName)
		var elOpenClose = this.__getLayoutNode("Item", "openclose");
		if(hasChildren) elOpenClose.setAttribute(this.opencloseaction || "onmousedown", 'var o = Kernel.lookup(' + this.uniqueId + ');o.slideToggle(this);if(o.onmousedown) o.onmousedown(event, this);Kernel.cancelBubble(event,o);');
		
		//Icon interaction
		var elIcon = this.__getLayoutNode("Item", "icon");
		if(hasChildren){
			var strFunc = 'var o = Kernel.lookup(' + this.uniqueId + ');o.slideToggle(this);Kernel.cancelBubble(event,o);o.choose();';
			if(this.opencloseaction != "onmousedown") elIcon.setAttribute(this.opencloseaction || "ondblclick", strFunc);
		}
		elIcon.setAttribute("onmousedown", 'Kernel.lookup(' + this.uniqueId + ').select(this);' + (strFunc && this.opencloseaction == "onmousedown" ? strFunc : ""));
		if(!elIcon.getAttribute("ondblclick")) elIcon.setAttribute("ondblclick", 'Kernel.lookup(' + this.uniqueId + ').choose();');
		
		//Select interaction
		var elSelect = this.__getLayoutNode("Item", "select");
		if(hasChildren){
			var strFunc2 = 'var o = Kernel.lookup(' + this.uniqueId + ');o.slideToggle(this);Kernel.cancelBubble(event,o)';
			if(this.opencloseaction != "onmousedown") elSelect.setAttribute(this.opencloseaction || "ondblclick", strFunc2);
		}
		//if(event.button != 1) return; 
		elSelect.setAttribute("onmousedown", 'var o = Kernel.lookup(' + this.uniqueId + ');if(!o.renaming && o.isFocussed() && XMLDatabase.isChildOf(o.selected, this)) this.dorename = true;o.select(this);if(o.onmousedown) o.onmousedown(event, this);' + (strFunc2 && this.opencloseaction == "onmousedown" ? strFunc2 : ""));
		if(!elSelect.getAttribute("ondblclick")) elSelect.setAttribute("ondblclick", 'var o = Kernel.lookup(' + this.uniqueId + '); o.cancelRename(); o.choose();');
		elSelect.setAttribute("onmouseup", 'if(this.dorename) Kernel.lookup(' + this.uniqueId + ').startDelayedRename(event); this.dorename = false;');
		//elItem.setAttribute("contextmenu", 'alert(1);var o = Kernel.lookup(' + this.uniqueId + ');o.dispatchEvent("oncontextMenu", o.value);');
		
		//Setup Nodes Identity (Look)
		var iconURL = this.applyRuleSetOnNode("Icon", xmlNode);
		if(iconURL){
			if(elIcon.tagName.match(/^img$/i)) elIcon.setAttribute("src", this.iconPath + iconURL);
			else elIcon.setAttribute("style", "background-image:url(" + this.iconPath + iconURL + ")");
		}

		var elCaption = this.__getLayoutNode("Item", "caption");
		if(elCaption) XMLDatabase.setNodeValue(elCaption, this.applyRuleSetOnNode("Caption", xmlNode));
		
		var cssClass = this.applyRuleSetOnNode("CSS", xmlNode);
		if(cssClass){
			this.__setStyleClass(this.__getLayoutNode("Item", null, this.__getLayoutNode("Item")), cssClass);
			if(cssClass) this.dynCssClasses.push(cssClass);
		}

		return this.__getLayoutNode("Item");
	}
	
	this.__deInitNode = function(xmlNode, htmlNode){
		//Lookup container
		var containerNode = this.__getLayoutNode("Item", "container", htmlNode);
		var pContainer = htmlNode.parentNode;
		
		//Remove htmlNodes from tree
		containerNode.parentNode.removeChild(containerNode);
		pContainer.removeChild(htmlNode);
		
		//Fix Images (+, - and lines)
		if(xmlNode.parentNode != this.XMLRoot) this.fixItem(xmlNode, htmlNode, true);
		
		if(this.emptyMessage && !pContainer.childNodes.length) this.setEmpty(pContainer);
		
		//Fix look (tree thing)
		this.fixItem(xmlNode, htmlNode, true);
		//this.fixItem(xmlNode.parentNode, XMLDatabase.findHTMLNode(xmlNode.parentNode, this));
		/*throw new Error();
		if(xmlNode.previousSibling) //should use traverse here
			this.fixItem(xmlNode.previousSibling, XMLDatabase.findHTMLNode(xmlNode.previousSibling, this));*/
	}
	
	this.__moveNode = function(xmlNode, htmlNode){
		if(!self.DEBUG && !htmlNode) return;
		
		var oPHtmlNode = htmlNode.parentNode;
		var pHtmlNode = XMLDatabase.findHTMLNode(xmlNode.parentNode, this);
		//if(!pHtmlNode) return;
		
		var beforeNode = xmlNode.nextSibling ? XMLDatabase.findHTMLNode(this.getNextTraverse(xmlNode), this) : null;
		var pContainer = pHtmlNode ? this.__getLayoutNode("Item", "container", pHtmlNode) : this.oInt;
		var container = this.__getLayoutNode("Item", "container", htmlNode);

		if(pContainer != oPHtmlNode && this.getTraverseNodes(xmlNode.parentNode).length == 1) this.clearEmpty(pContainer);

		pContainer.insertBefore(htmlNode, beforeNode);
		pContainer.insertBefore(container, beforeNode);
		
		if(!this.startClosed){
			//pContainer.style.display = "block";
			//pContainer.style.height = "auto";
		}
		
		if(this.emptyMessage && !oPHtmlNode.childNodes.length) this.setEmpty(oPHtmlNode);
		
		if(this.openOnAdd && pHtmlNode != this.oInt && pContainer.style.display != "block") 
			this.slideOpen(pContainer, pHtmlNode);
		
		//Fix look (tree thing)
		this.fixItem(xmlNode, htmlNode);
		this.fixItem(xmlNode.parentNode, XMLDatabase.findHTMLNode(xmlNode.parentNode, this));
		if(this.getNextTraverse(xmlNode, true)){ //should use traverse here
			this.fixItem(this.getNextTraverse(xmlNode, true), XMLDatabase.findHTMLNode(this.getNextTraverse(xmlNode, true), this));
		}
	}
	
	this.__updateNode = function(xmlNode, htmlNode){
		//Update Identity (Look)
		var elIcon = this.__getLayoutNode("Item", "icon", htmlNode);
		//if(!elIcon) alert(htmlNode.outerHTML);
		var iconURL = this.applyRuleSetOnNode("Icon", xmlNode);
		if(elIcon && iconURL){
			if(elIcon.tagName && elIcon.tagName.match(/^img$/i)) elIcon.src = this.iconPath + iconURL;
			else elIcon.style.backgroundImage = "url(" + this.iconPath + iconURL + ")";
		}

		var elCaption = this.__getLayoutNode("Item", "caption", htmlNode);
		if(elCaption){
			if(elCaption.nodeType == 1)
				elCaption.innerHTML = this.applyRuleSetOnNode("Caption", xmlNode);
			else elCaption.nodeValue = this.applyRuleSetOnNode("Caption", xmlNode);
		}

		var cssClass = this.applyRuleSetOnNode("CSS", xmlNode);
		if(cssClass || this.dynCssClasses.length){
			this.__setStyleClass(htmlNode, cssClass, this.dynCssClasses);
			if(cssClass && !this.dynCssClasses.contains(cssClass)) this.dynCssClasses.push(cssClass);
		}
	}
	
	this.clearEmpty = function(container){
		container.innerHTML = "";
	}
		
	this.setEmpty = function(container){
		this.__getNewContext("Empty");
		var oItem = this.__getLayoutNode("Empty");
		this.__getLayoutNode("Empty", "caption").nodeValue = this.emptyMessage;
		XMLDatabase.htmlImport(oItem, container);
		
		if(!this.startClosed){
			if(container.style){
				//container.style.display = "block";
				//container.style.height = "auto";
			}
			//else container.setAttribute("style", "display:block;height:auto;");
		}
	}
	
	this.__setLoading = function(xmlNode, container){
		this.__getNewContext("Loading");
		this.setLoadStatus(xmlNode, "potential");
		XMLDatabase.htmlImport(this.__getLayoutNode("Loading"), container);
	}
	
	this.__removeLoading = function(htmlNode){
		if(!htmlNode) return;
		this.__getLayoutNode("Item", "container", htmlNode).innerHTML = "";
	}
	
	function xmlUpdateHandler(action, xmlNode, result){
		/*
			Display the animation if the item added is 
			* Not in the cache
			- Being insterted using xmlUpdate
			- there is at least 1 child inserted
		*/
		
		if(action == "move-away")
			this.fixItem(xmlNode, XMLDatabase.findHTMLNode(xmlNode, this), true);

		if(action != "insert") return;
		
		var htmlNode = this.getNodeFromCache(xmlNode.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId);
		if(!htmlNode) return;
		if(this.hasLoadStatus(xmlNode, "loading") && result.length > 0){
			var container = this.__getLayoutNode("Item", "container", htmlNode);
			this.slideOpen(container, xmlNode);
		}
		else this.fixItem(xmlNode, htmlNode);
		
		//Can this be removed?? (because it was added in the insert function)
		if(this.hasLoadStatus(xmlNode, "loading"))
			this.setLoadStatus(xmlNode, "loaded");
	}
	
	this.addEventListener("onxmlupdate", xmlUpdateHandler);
	
	/************************
		Keyboard Support
	************************/
	this.addEventListener("onbeforerename", function(){
		if(this.tempsel){
			clearTimeout(this.timer);
			this.select(this.tempsel);
			this.tempsel = null;
			this.timer = null;
		}
	});
	
	this.keyHandler = function(key, ctrlKey, shiftKey, altKey){
		if(!this.selected) return;
		//if(!this.selected || this.dragging) return;
		//var img = this.selected.parentNode.parentNode.firstChild.firstChild;

		switch(key){
			case 109:
			case 37:
			//LEFT
				if(this.tempsel){
					clearTimeout(this.timer);
					this.select(this.tempsel);
					this.tempsel = null;
					this.timer = null;
				}
			
				if(this.value.selectSingleNode(this.ruleTraverse))
					this.slideToggle(this.selected, 2)
			break;
			case 107:
			case 39:
			//RIGHT
				if(this.tempsel){
					clearTimeout(this.timer);
					this.select(this.tempsel);
					this.tempsel = null;
					this.timer = null;
				}
			
				if(this.value.selectSingleNode(this.ruleTraverse))
					this.slideToggle(this.selected, 1)
			break;
			case 46:
			//DELETE
				var xmlNode = this.value;
				var i=0, ln=1, nextNode = xmlNode;
				this.Remove(xmlNode, true);
			break;
			case 187:
			//+
				if(shiftKey) this.keyHandler(39);
			break;
			case 189:
			//-
				if(!shiftKey) this.keyHandler(37);
			break;
			case 38:
			//UP
				if(!this.value && !this.tempsel) return;
				var node = this.tempsel ? XMLDatabase.getNode(this.tempsel) : this.value;
				
				var sNode = this.getNextTraverse(node, true);
				if(sNode){
					var nodes = sNode.selectNodes(this.ruleTraverse);
					
					do{
						var container = this.__getLayoutNode("Item", "container", this.getNodeFromCache(XMLDatabase.getID(sNode, this)));
						if(Kernel.getStyle(container, "display") == "block"){
							if(nodes.length) sNode = nodes[nodes.length-1];
							else break;
						}
						else break;
					}while(sNode && (nodes = sNode.selectNodes(this.ruleTraverse)).length);
				}
				else if(node.parentNode == this.XMLRoot) return;
				else sNode = node.parentNode;

				if(sNode && sNode.nodeType == 1){
					clearTimeout(this.timer);
					var id = XMLDatabase.getID(sNode, this);
					this.__deselect(this.tempsel || this.selected);
					this.tempsel = this.__select(document.getElementById(id));//SHOULD BE FAKE SELECT
					this.timer = setTimeout('var o = Kernel.lookup(' + this.uniqueId + ');o.tempsel=null;o.timer=null;o.select(document.getElementById("' + id + '"));', 300);
				}
				
				if(this.tempsel && this.tempsel.offsetTop < this.oExt.scrollTop)
					this.oExt.scrollTop = this.tempsel.offsetTop;
				
				return false;
			break;
			case 40:
			//DOWN
				if(!this.value && !this.tempsel) return;
				var node = this.tempsel ? XMLDatabase.getNode(this.tempsel) : this.value;
				
				var sNode = node.selectSingleNode(this.ruleTraverse);
				if(sNode){
					var container = this.__getLayoutNode("Item", "container", this.getNodeFromCache(XMLDatabase.getID(node, this)));
					if(Kernel.getStyle(container, "display") != "block") sNode = null;
				}
				
				while(!sNode && node.parentNode){
					var i=0, nodes = node.parentNode.selectNodes(this.ruleTraverse);
					while(nodes[i] && nodes[i] != node) i++;
					sNode	= nodes[i+1];
					node = node.parentNode;
				}
				
				if(sNode && sNode.nodeType == 1){
					clearTimeout(this.timer);
					var id = XMLDatabase.getID(sNode, this);
					this.__deselect(this.tempsel || this.selected);
					this.tempsel = this.__select(document.getElementById(id));//SHOULD BE FAKE SELECT
					this.timer = setTimeout('var o = Kernel.lookup(' + this.uniqueId + ');o.tempsel=null;o.select(document.getElementById("' + id + '"));', 300);
				}
				
				if(this.tempsel && this.tempsel.offsetTop + this.tempsel.offsetHeight > this.oExt.scrollTop + this.oExt.offsetHeight)
					this.oExt.scrollTop = this.tempsel.offsetTop - this.oExt.offsetHeight + this.tempsel.offsetHeight + 10;
				
				return false;
			break;
			case 93:
			//CONTEXT MENU
				//if(this.value && this.oncontextmenu) this.oncontextmenu(event, true);
			break;
		}
	}
	
	/************************
			  RENAME
	************************/
	this.__getCaptionElement = function(){
		var x = this.__getLayoutNode("Item", "caption", this.selected);
		return x.nodeType == 1 ? x : x.parentNode;
	}
	
	/************************
			DATABINDING
	************************/

	this.nodes = [];

	this.__add = function(xmlNode, Lid, xmlParentNode, htmlParentNode, beforeNode, isLast){
		//WHY THE FUCK IS THIS FUNCTION CALLED 3 TIMES when adding ONE node? (hack/should)
		var loadChildren = this.bindingRules["Insert"] ? this.getNodeFromRule("Insert", xmlNode) : false;
		var hasChildren = loadChildren || xmlNode.selectSingleNode(this.ruleTraverse) ? true : false;
		var state = (hasChildren ? HAS_CHILD : 0) | (this.startClosed && hasChildren  || loadChildren ? IS_CLOSED : 0) | (isLast ? IS_LAST : 0);

		var htmlNode = this.initNode(xmlNode, state, Lid);
		var container = this.__getLayoutNode("Item", "container");
		if(!this.startClosed && !this.noCollapse) container.setAttribute("style", "overflow:visible;height:auto;display:block;");
		
		//TEMP on for dynamic subloading
		if(!hasChildren || loadChildren) container.setAttribute("style", "display:none;");
		
		//Dynamic SubLoading (Insertion) of SubTree
		if(loadChildren && !this.hasLoadStatus(xmlNode))
			this.__setLoading(xmlNode, container);
		else if(!this.getTraverseNodes(xmlNode).length && this.applyRuleSetOnNode("Empty", xmlNode))
			this.setEmpty(container);
		
		if(!htmlParentNode && xmlParentNode == this.XMLRoot){
			this.nodes.push(htmlNode);
			if(!XMLDatabase.isChildOf(htmlNode, container, true)) this.nodes.push(container);
			
			this.__setStyleClass(htmlNode, "root");
			this.__setStyleClass(container, "root");
		}
		else{
			if(!htmlParentNode){
				var htmlParentNode = XMLDatabase.findHTMLNode(xmlNode.parentNode, this);
				htmlParentNode = htmlParentNode ? this.__getLayoutNode("Item", "container", htmlParentNode) : this.oInt;
			}
			
			if(htmlParentNode == this.oInt){
				this.__setStyleClass(htmlNode, "root");
				this.__setStyleClass(container, "root");
			}
			
			if(!beforeNode && this.getNextTraverse(xmlNode)) beforeNode = XMLDatabase.findHTMLNode(this.getNextTraverse(xmlNode), this);
			if(beforeNode && beforeNode.parentNode != htmlParentNode) beforeNode = null;
		
			if(htmlParentNode.style && this.getTraverseNodes(xmlNode.parentNode).length == 1) this.clearEmpty(htmlParentNode);
		
			//alert("|" + htmlNode.nodeType + "-" + htmlParentNode.nodeType + "-" + beforeNode + ":" + container.nodeType);
			//Insert Node into Tree
			XMLDatabase.htmlImport(htmlNode, htmlParentNode, beforeNode);
			if(!XMLDatabase.isChildOf(htmlNode, container, true)) 
				var container = XMLDatabase.htmlImport(container, htmlParentNode, beforeNode);

			//Fix parent if child is added to drawn parentNode
			if(htmlParentNode.style){
				if(!this.startClosed && this.openOnAdd && htmlParentNode != this.oInt && htmlParentNode.style.display != "block") 
					this.slideOpen(htmlParentNode, xmlParentNode);
				
				//this.fixItem(xmlNode, htmlNode); this one shouldn't be called, because it should be set right at init
				this.fixItem(xmlParentNode, XMLDatabase.findHTMLNode(xmlParentNode, this));
				if(this.getNextTraverse(xmlNode, true)){ //should use traverse here
					this.fixItem(this.getNextTraverse(xmlNode, true), XMLDatabase.findHTMLNode(this.getNextTraverse(xmlNode, true), this));
				}
			}
		}
		
		if(this.prerender) this.__addNodes(xmlNode, container, true); //checkChildren ???
		else{
			this.setLoadStatus(xmlNode, "potential");
		}

		return container;
	}
	
	this.__fill = function(){
		//if(!this.nodes.length) return;
		//this.oInt.innerHTML = "";
		XMLDatabase.htmlImport(this.nodes, this.oInt);
		this.nodes.length = 0;

		//for(var i=0;i<this.nodes.length;i++)
			//XMLDatabase.htmlImport(this.nodes[i], this.oInt);
		//this.nodes.length = 0;
	}
	
	this.__getParentNode = function(htmlNode){
		return htmlNode ? this.__getLayoutNode("Item", "container", htmlNode) : this.oInt;
	}
	
	/************************
	  		SELECT
	************************/
	
	this.__calcSelectRange = function(xmlStartNode, xmlEndNode){
		//should be implemented :)
		return [xmlStartNode, xmlEndNode];
	}
	
	this.__findContainer = function(htmlNode){
		return this.__getLayoutNode("Item", "container", htmlNode);
	}
	
	this.inherit(MultiSelect);
	this.inherit(Cache);
	this.multiselect = false; // Initially Disable MultiSelect
	
	this.__selectDefault = function(xmlNode){
		if(this.select(this.getFirstTraverseNode(xmlNode))) return true;
		else{
			var nodes = this.getTraverseNodes(xmlNode);
			for(var i=0;i<nodes.length;i++){
				if(this.__selectDefault(nodes[i])) return true;
			}
		}
	}
	
	/************************
	  Other Inheritance
	************************/
	
	this.inherit(Presentation);
	this.inherit(DataBinding);
	
	this.inherit(Rename);
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	//render the outer framework of this object
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);
		this.opencloseaction = this.__getOption("Main", "openclose");
		
		//Need fix...
		//this.oExt.style.MozUserSelect = "none";

		this.oExt.oncontextmenu = function(e){
			if(!e) e = event;
			this.host.dispatchEvent("oncontextmenu", e);
			e.cancelBubble = true;
			return false;
		}
		
		this.oExt.onclick = function(){
			this.host.dispatchEvent("onclick");
		}
	}
	
	this.__loadJML = function(x){
		this.openOnAdd = x.getAttribute("openonadd") != "false";
		this.startClosed = (this.jml.getAttribute("startclosed") || this.__getOption("Main", "startclosed")) != "false" ;
		this.noCollapse = this.jml.getAttribute("no-collapse") == "true";
		this.singleopen = this.jml.getAttribute("singleopen") == "true";
		this.prerender = this.jml.getAttribute("prerender") != "false";
		
		Application.loadSubNode(this.jml, null, this);
	}
	
	this.__destroy = function(){
		this.oExt.oncontextmenu = null;
		this.oExt.onclick = null;
		Kernel.removeNode(this.oDrag);
		this.oDrag = null;
	}
}


/*FILEHEAD(/in/Components/Toc.js)SIZE(4400)TIME(1185049651181)*/

function Toc(pHtmlNode){
	Kernel.register(this, "Toc", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;

	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);
	
	this.editableParts = {"Page" : [["caption","@caption"]]};
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.represent = function(oJmlNode){
		this.oJmlNode = oJmlNode;
		var toc = this;
		
		oJmlNode.addEventListener("onafterswitch", function(active, page){
			toc.setActivePage(active);
		});
		
		if(oJmlNode.drawed) this.createReflection()
		else oJmlNode.addEventListener("ondraw", function(){toc.createReflection()});
	}
	
	this.createReflection = function(){
		var pages = this.oJmlNode.getPages();
		
		for(var p=[],i=0;i<pages.length;i++){
			this.__getNewContext("Page");
			var page = this.__getLayoutNode("Page", "caption");
			if(!pages[i].jml.getAttribute("caption")){
				issueWarning(0, "Page element without caption found.");
				continue;
			}

			XMLDatabase.setNodeValue(page, pages[i].jml.getAttribute("caption") || "");
			page.setAttribute("onmousedown", 'Kernel.lookup(' + this.uniqueId + ').gotoPage(' + i + ')');
			p.push(XMLDatabase.htmlImport(this.__getLayoutNode("Page"), this.oInt));
			
				this.__makeEditable("Page", p[i], pages[i].jml);
		}
		
		//XMLDatabase.htmlImport(p, this.oInt);
		this.pages = p;
		
		this.setActivePage(0);
		
		if(IS_GECKO){
			var tocNode = this;
			setTimeout(function(){
				tocNode.oExt.style.height = tocNode.oExt.offsetHeight+1 + "px";
				tocNode.oExt.style.height = tocNode.oExt.offsetHeight-1 + "px";
			}, 10);
		}
	}
	
	this.gotoPage = function(nr){
		if(!this.oJmlNode.testing){
			var pages = this.oJmlNode.getPages();
			var activePage = this.oJmlNode.activePage;
			for(var i=activePage;i<nr;i++){
				pages[i].oExt.style.position = "absolute"; //hack
				pages[i].oExt.style.left = "10000"; //hack
				pages[i].oExt.style.display = "block"; //hack
				var test = !this.oJmlNode.isValid || this.oJmlNode.isValid(true, activePage == i, pages[i], true);
				pages[i].oExt.style.display = ""; //hack
				pages[i].oExt.style.position = ""; //hack
				pages[i].oExt.style.left = ""; //hack
				pages[i].oExt.style.width = "1px";
				pages[i].oExt.style.width = "";
	
				if(!test) return this.oJmlNode.setActiveTab(i);
			}
		}
		
		if(this.oJmlNode.showLoader) this.oJmlNode.showLoader(true, nr); 

		var oJmlNode = this.oJmlNode;
		setTimeout(function(){
			oJmlNode.setActiveTab(nr);
		}, 1);
		//setTimeout("Kernel.lookup(" + this.oJmlNode.uniqueId + ").setActiveTab(" + nr + ");", 1);
	}
	
	this.setActivePage = function(active){
		if(active > this.pages.length-1) return;
		
		for(var i=0;i<this.pages.length;i++){
			if(i < active) this.__setStyleClass(this.pages[i], "past", ["future", "present"]);
			if(i == active) this.__setStyleClass(this.pages[i], "present", ["future", "past"]);
			if(i > active) this.__setStyleClass(this.pages[i], "future", ["past", "present"]);
			if(i == this.pages.length-1) this.__setStyleClass(this.pages[i], "last");
		}
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oCaption = this.__getLayoutNode("Main", "caption", this.oExt);
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);
	}
	
	this.__loadJML = function(x){
		//if(!x.getAttribute("represent")) return;
		
		if(!x.getAttribute("represent")) throw new Error(1013, Kernel.formErrorString(1013, this, "Find representation", "Could not find representation for the Toc: '" + x.getAttribute("represent") + "'"))
		
		var jmlNode = this;
		setTimeout(function(){
			jmlNode.represent(self[jmlNode.jml.getAttribute("represent")]);
		});
	}
}

/*FILEHEAD(/in/Components/Workarea.js)SIZE(9262)TIME(1188900006250)*/

function Workarea(pHtmlNode){
	Kernel.register(this, "Workarea", GUI_NODE);
	this.pHtmlNode = pHtmlNode || document.body;
	this.pHtmlDoc = this.pHtmlNode.ownerDocument;
	
	/************************
			  RENAME
	************************/
	
	this.__getCaptionElement = function(){
		var x = this.__getLayoutNode("Item", "caption", this.selected);
		return x.nodeType == 1 ? x : x.parentNode;
	}
	
	this.addEventListener("onafterselect",function(e){
		if(this.hasFeature(__VALIDATION__)) this.validate();
	});
	
	/************************
	  Other Inheritance
	************************/
	this.inherit(BcList);
	
	this.keyHandler = function(key, ctrlKey, shiftKey, altKey){
		if(!this.value) return;
		var value = (ctrlKey ? 10 : (shiftKey ? 100 : 1));
		
		switch(key){
			case 37:
				this.MoveTo(this.value, parseInt(this.applyRuleSetOnNode("Left", this.value)) - value, this.applyRuleSetOnNode("Top", this.value));  
			return false;
			case 38:
				this.MoveTo(this.value, this.applyRuleSetOnNode("Left", this.value), parseInt(this.applyRuleSetOnNode("Top", this.value)) - value);
			return false;
			case 39:  
				this.MoveTo(this.value, parseInt(this.applyRuleSetOnNode("Left", this.value)) + value, this.applyRuleSetOnNode("Top", this.value));
			return false;
			case 40:
				this.MoveTo(this.value, this.applyRuleSetOnNode("Left", this.value), parseInt(this.applyRuleSetOnNode("Top", this.value)) + value);
			return false;
		}
	}
	
	this.inherit(Rename);
	
	/************************
			DRAGDROP
	************************/
	
	this.__showDragIndicator = function(sel, e){
		var x = e.offsetX;
		var y = e.offsetY;

		this.oDrag.startX = x;
		this.oDrag.startY = y;
		
		document.body.appendChild(this.oDrag);
		//this.oDrag.getElementsByTagName("DIV")[0].innerHTML = this.selected.innerHTML;
		//this.oDrag.getElementsByTagName("IMG")[0].src = this.selected.parentNode.parentNode.childNodes[1].firstChild.src;
		this.__updateNode(this.value, this.oDrag, true);
		
		return this.oDrag;
	}
	
	this.__hideDragIndicator = function(){
		this.oDrag.style.display = "none";
	}
	
	this.__moveDragIndicator = function(e){
		this.oDrag.style.left = (e.clientX - this.oDrag.startX) + "px";
		this.oDrag.style.top = (e.clientY - this.oDrag.startY) + "px";
	}
	
	this.__initDragDrop = function(){
		if(!this.__hasLayoutNode("DragIndicator")) return;
		this.oDrag = XMLDatabase.htmlImport(this.__getLayoutNode("DragIndicator"), document.body);
		
		this.oDrag.style.zIndex = 1000000;
		this.oDrag.style.position = "absolute";
		this.oDrag.style.cursor = "default";
		this.oDrag.style.display = "none";
	}
	
	this.__dragout = function(el, dragdata){
		var htmlNode = XMLDatabase.findHTMLNode(dragdata.data, this);
		if(htmlNode) htmlNode.style.display = "block";
	}
	this.__dragover = function(el, dragdata, candrop){
		var htmlNode = XMLDatabase.findHTMLNode(dragdata.data, this);
		if(htmlNode){
			htmlNode.style.display = candrop[0] && XMLDatabase.isChildOf(this.XMLRoot, candrop[0], true) ? "none" : "block"; 
		}
	}
	this.__dragstart = function(el, dragdata){
		var htmlNode = XMLDatabase.findHTMLNode(dragdata.data, this);
		if(htmlNode) htmlNode.style.display = "none";
	}
	this.__dragdrop = function(el, dragdata, candrop){
		//if(!dragdata.resultNode.
	}
	
	this.addEventListener("ondragstart", function(dragdata){
		return this.applyRuleSetOnNode("Move", dragdata.data) ? true : false;
	});
	
	this.addEventListener("ondragdrop", function(dragdata, candrop){ 
		if(candrop && dragdata.host == this){
			var pos = Kernel.compat.getAbsolutePosition(this.oInt, null, true);
			this.MoveTo(dragdata.data, (dragdata.x - pos[0] - dragdata.indicator.startX), (dragdata.y - pos[1] - dragdata.indicator.startY));
			
			return false;
		}
	});
	
	this.MoveTo = function(xmlNode, x, y){
		//Use Action Tracker
		var lnode = this.getNodeFromRule("Left", xmlNode, null, null, true);
		var tnode = this.getNodeFromRule("Top", xmlNode, null, null, true);
		
		var attrs = {};
		attrs[lnode.nodeName] = x;
		attrs[tnode.nodeName] = y;
		
		var exec = this.executeAction("setAttributes", [xmlNode, attrs], "MoveTo", xmlNode);
		if(exec !== false) return xmlNode;
	}
	
	this.SetZindex = function(xmlNode, value){
		var node = this.getNodeFromRule("Zindex", xmlNode, null, null, true);
		if(!node) return;
		
		var atAction = node.nodeType == 1 || node.nodeType == 3 || node.nodeType == 4 ? "setTextNode" : "setAttribute";
		var args = node.nodeType == 1 ? [node, value] : (node.nodeType == 3 || node.nodeType == 4 ? [node.parentNode, value] : [node.ownerElement || node.selectSingleNode(".."), node.nodeName, value]);

		//Use Action Tracker
		this.executeAction(atAction, args, "SetZindex", xmlNode);
	}	
	
	this.inherit(DragDrop);
	
	/**********
		Item creation
	**********/
	
	this.__updateModifier = function(xmlNode, htmlNode){
		htmlNode.style.left = (this.applyRuleSetOnNode("Left", xmlNode) || 10) + "px";
		htmlNode.style.top = (this.applyRuleSetOnNode("Top", xmlNode) || 10) + "px";
		htmlNode.style.width = (this.applyRuleSetOnNode("Width", xmlNode) || 100) + "px";
		htmlNode.style.height = (this.applyRuleSetOnNode("Height", xmlNode) || 100) + "px";
		
		var zindex = parseInt(this.applyRuleSetOnNode("Zindex", xmlNode));
		var curzindex = parseInt(Kernel.compat.getStyle(htmlNode, IS_IE ? "zIndex" : "z-index")) || 1;
		if(curzindex != zindex){
			var nodes = this.getTraverseNodes();
			for(var res=[],i=0;i<nodes.length;i++){
				if(nodes[i] == xmlNode) continue;
				res[nodes[i].getAttribute("zindex")] = nodes[i];
			}
			res[curzindex] = xmlNode;

			if(curzindex < zindex){
				for(var k=curzindex;k<zindex;k++){
					if(!res[k+1]) continue;
					res[k+1].setAttribute("zindex", k);
					XMLDatabase.findHTMLNode(res[k+1], this).style.zIndex = k;
				}
			}
			else{
				for(var k=zindex;k<curzindex;k++){
					if(!res[k]) continue;
					res[k].setAttribute("zindex", k+1);
					XMLDatabase.findHTMLNode(res[k], this).style.zIndex = k+1;
				}
			}

			htmlNode.style.zIndex = zindex;
		}
	}
	
	this.__addModifier = function(xmlNode, htmlNode){
		if(!xmlNode.getAttribute("zindex")){
			xmlNode.setAttribute("zindex", this.oExt.childNodes.length+1);
		}
		
		var x, y;
		if(DragServer.dragdata){
			var pos = Kernel.compat.getAbsolutePosition(this.oInt, null, true);
			if(!xmlNode.getAttribute("left")) xmlNode.setAttribute("left", (DragServer.dragdata.x - pos[0] - DragServer.dragdata.indicator.startX));
			if(!xmlNode.getAttribute("top")) xmlNode.setAttribute("top", (DragServer.dragdata.y - pos[1] - DragServer.dragdata.indicator.startY));
		}

		if(htmlNode.style){
			htmlNode.style.left = (this.applyRuleSetOnNode("Left", xmlNode) || 10) + "px";
			htmlNode.style.top = (this.applyRuleSetOnNode("Top", xmlNode) || 10) + "px";
			htmlNode.style.width = (this.applyRuleSetOnNode("Width", xmlNode) || 100) + "px";
			htmlNode.style.height = (this.applyRuleSetOnNode("Height", xmlNode) || 100) + "px";
			htmlNode.style.zIndex = (this.oExt.childNodes.length+1);
		}
		else{
			var style = [];
			style.push("left:" + (this.applyRuleSetOnNode("Left", xmlNode) || 10) + "px");
			style.push("top:" + (this.applyRuleSetOnNode("Top", xmlNode) || 10) + "px");
			style.push("width:" + (this.applyRuleSetOnNode("Width", xmlNode) || 100) + "px");
			style.push("height:" + (this.applyRuleSetOnNode("Height", xmlNode) || 100) + "px");
			style.push("z-index:" + (this.oExt.childNodes.length+1));
			htmlNode.setAttribute("style", style.join(";"));
		}
	}
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);
	
	this.draw = function(){
		//Build Main Skin
		this.oExt = this.__getExternal(); 
		this.oInt = this.__getLayoutNode("Main", "container", this.oExt);

		/*this.oExt.onmousedown = function(e){
			if(!e) e = event;
			if(e.ctrlKey || e.shiftKey) return;
			
			var srcElement = IS_IE ? e.srcElement : e.target;
			debugger;
			if(this.host.allowDeselect && (srcElement == this || srcElement.getAttribute(XMLDatabase.htmlIdTag)))
				this.host.clearSelection(); //hacky
		}*/
		
		this.oExt.onclick = function(){
			this.host.dispatchEvent("onclick");
		}

		//Get Options form skin
		this.listtype = parseInt(this.__getLayoutNode("Main", "type")) || 1; //Types: 1=One dimensional List, 2=Two dimensional List
		this.behaviour = parseInt(this.__getLayoutNode("Main", "behaviour")) || 1; //Types: 1=Check on click, 2=Check independent
		this.hasCheckbox = this.__getLayoutNode("Main", "checkbox") ? true : false;
	}
	
	this.__loadJML = function(x){
		if(this.jml.childNodes.length) this.loadInlineData(this.jml);
		
		if(this.hasFeature(__MULTIBINDING__) && x.getAttribute("value")) this.setValue(x.getAttribute("value"));
		
		// this.doOptimize(true);
		
		if(x.getAttribute("multibinding") == "true" && !x.getAttribute("bind")) 
			this.inherit(MultiLevelBinding);
	}
	
	this.__destroy = function(){
		this.oExt.onclick = null;
		Kernel.removeNode(this.oDrag);
		this.oDrag = null;
	}
}


/*FILEHEAD(/in/Components/bcList.js)SIZE(16832)TIME(1188900006250)*/

function BcList(){
	/*********************************************************************
										PROPERTIES
	*********************************************************************/

	//Options
	this.inherit(Validation);
	this.focussable = true; // This object can get the focus
	this.multiselect = true; // Initially Disable MultiSelect
	
	this.dynCssClasses = [];
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/

	/************************
				Skin
	************************/

	this.__deInitNode = function(xmlNode, htmlNode){
		if(!htmlNode) return;

		//Remove htmlNodes from tree
		htmlNode.parentNode.removeChild(htmlNode);
	}
	
	this.__updateNode = function(xmlNode, htmlNode, noModifier){
		//Update Identity (Look)
		var elIcon = this.__getLayoutNode("Item", "icon", htmlNode);
		
		if(elIcon){
			if(elIcon.nodeType == 1) elIcon.style.backgroundImage = "url(" + this.iconPath + this.applyRuleSetOnNode("Icon", xmlNode) + ")";
			else elIcon.nodeValue = this.iconPath + this.applyRuleSetOnNode("Icon", xmlNode);
		}
		else{
			var elImage = this.__getLayoutNode("Item", "image", htmlNode);//.style.backgroundImage = "url(" + this.applyRuleSetOnNode("Image", xmlNode) + ")";
			if(elImage){
				if(elImage.nodeType == 1) elImage.style.backgroundImage = "url(" + this.mediaPath + this.applyRuleSetOnNode("Image", xmlNode) + ")";
				else elImage.nodeValue = this.mediaPath + this.applyRuleSetOnNode("Image", xmlNode);
			}
		}
			
		//this.__getLayoutNode("Item", "caption", htmlNode).nodeValue = this.applyRuleSetOnNode("Caption", xmlNode);
		var elCaption = this.__getLayoutNode("Item", "caption", htmlNode);
		if(elCaption){
			if(elCaption.nodeType == 1)
				elCaption.innerHTML = this.applyRuleSetOnNode("Caption", xmlNode);
			else elCaption.nodeValue = this.applyRuleSetOnNode("Caption", xmlNode);
		}
		
		htmlNode.title = this.applyRuleSetOnNode("Title", xmlNode) || "";
		
		var cssClass = this.applyRuleSetOnNode("CSS", xmlNode);
		if(cssClass || this.dynCssClasses.length){
			this.__setStyleClass(htmlNode, cssClass, this.dynCssClasses);
			if(cssClass && !this.dynCssClasses.contains(cssClass)) this.dynCssClasses.push(cssClass);
		}
		
		if(!noModifier && this.__updateModifier) this.__updateModifier(xmlNode, htmlNode);
	}
	
	this.__moveNode = function(xmlNode, htmlNode){
		if(!htmlNode) return;
		var oPHtmlNode = htmlNode.parentNode;
		var beforeNode = xmlNode.nextSibling ? XMLDatabase.findHTMLNode(this.getNextTraverse(xmlNode), this) : null;

		oPHtmlNode.insertBefore(htmlNode, beforeNode);
		
		//if(this.emptyMessage && !oPHtmlNode.childNodes.length) this.setEmpty(oPHtmlNode);
	}
	
	/************************
		Keyboard Support
	************************/
	
	//Handler for a plane list
	this.__keyHandler = function(key, ctrlKey, shiftKey, altKey){
		if(!this.selected) return;
		//error after delete...

		switch(key){
			case 13:
				this.choose(this.selected);
			break;
			case 32:
				this.select(this.indicator, true);
			break;
			case 46:
			//DELETE
				if(this.disableremove) return;
			
				this.Remove(null, true);
			break;
			case 37:
			//LEFT
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
			
				if(!this.value) return;
				var node = this.getNextTraverseSelected(this.indicator || this.value, false);
				if(node){
					if(ctrlKey || this.ctrlSelect) this.setIndicator(node);
					else this.select(node, null, shiftKey);
				}
				
				if(this.selected.offsetTop < this.oExt.scrollTop)
					this.oExt.scrollTop = this.selected.offsetTop - margin[0];
			break;
			case 38:
			//UP
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				
				if(!this.value && !this.indicator) return;
				var hasScroll = this.oExt.scrollHeight > this.oExt.offsetHeight;
				var items = Math.floor((this.oExt.offsetWidth - (hasScroll ? 15 : 0)) / (this.selected.offsetWidth+margin[1]+margin[3]));
				var node = this.getNextTraverseSelected(this.indicator || this.value, false, items);
				if(node){
					if(ctrlKey || this.ctrlSelect) this.setIndicator(node);
					else this.select(node, null, shiftKey);
				}
				
				if(this.selected.offsetTop < this.oExt.scrollTop)
					this.oExt.scrollTop = this.selected.offsetTop - margin[0];
			break;
			case 39:
			//RIGHT
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				
				if(!this.value) return;
				var node = this.getNextTraverseSelected(this.indicator || this.value, true);
				if(node){
					if(ctrlKey || this.ctrlSelect) this.setIndicator(node);
					else this.select(node, null, shiftKey);
				}
				
				if(this.selected.offsetTop + this.selected.offsetHeight > this.oExt.scrollTop + this.oExt.offsetHeight)
					this.oExt.scrollTop = this.selected.offsetTop - this.oExt.offsetHeight + this.selected.offsetHeight + margin[0];
					
			break;
			case 40:
			//DOWN
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				
				if(!this.value && !this.indicator) return;
				var hasScroll = this.oExt.scrollHeight > this.oExt.offsetHeight;
				var items = Math.floor((this.oExt.offsetWidth - (hasScroll ? 15 : 0)) / (this.selected.offsetWidth+margin[1]+margin[3]));
				var node = this.getNextTraverseSelected(this.indicator || this.value, true, items);
				if(node){
					if(ctrlKey || this.ctrlSelect) this.setIndicator(node);
					else this.select(node, null, shiftKey);
				}
				
				if(this.selected.offsetTop + this.selected.offsetHeight > this.oExt.scrollTop + this.oExt.offsetHeight - (hasScroll ? 10 : 0))
					this.oExt.scrollTop = this.selected.offsetTop - this.oExt.offsetHeight + this.selected.offsetHeight + 10 + (hasScroll ? 10 : 0);
				
			break;
			case 33:
			//PGUP
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				
				if(!this.value && !this.indicator) return;
				var hasScrollY = this.oExt.scrollHeight > this.oExt.offsetHeight;
				var hasScrollX = this.oExt.scrollWidth > this.oExt.offsetWidth;
				var items = Math.floor((this.oExt.offsetWidth - (hasScrollY ? 15 : 0)) / (this.selected.offsetWidth+margin[1]+margin[3]));
				var lines = Math.floor((this.oExt.offsetHeight - (hasScrollX ? 15 : 0)) / (this.selected.offsetHeight+margin[0]+margin[2]));
				var node = this.getNextTraverseSelected(this.indicator || this.value, false, items*lines);
				if(!node) node = this.getFirstTraverseNode();
				if(node){
					if(ctrlKey || this.ctrlSelect) this.setIndicator(node);
					else this.select(node, null, shiftKey);
				}
				
				if(this.selected.offsetTop < this.oExt.scrollTop)
					this.oExt.scrollTop = this.selected.offsetTop - margin[0];
			break;
			case 34:
			//PGDN
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				
				if(!this.value && !this.indicator) return;
				var hasScrollY = this.oExt.scrollHeight > this.oExt.offsetHeight;
				var hasScrollX = this.oExt.scrollWidth > this.oExt.offsetWidth;
				var items = Math.floor((this.oExt.offsetWidth - (hasScrollY ? 15 : 0)) / (this.selected.offsetWidth+margin[1]+margin[3]));
				var lines = Math.floor((this.oExt.offsetHeight - (hasScrollX ? 15 : 0)) / (this.selected.offsetHeight+margin[0]+margin[2]));
				var node = this.getNextTraverseSelected(this.indicator || this.value, true, items*lines);
				if(!node) node = this.getLastTraverseNode();
				if(node){
					if(ctrlKey || this.ctrlSelect) this.setIndicator(node);
					else this.select(node, null, shiftKey);
				}
				
				if(this.selected.offsetTop + this.selected.offsetHeight > this.oExt.scrollTop + this.oExt.offsetHeight - (hasScrollY ? 10 : 0))
					this.oExt.scrollTop = this.selected.offsetTop - this.oExt.offsetHeight + this.selected.offsetHeight + 10 + (hasScrollY ? 10 : 0);
			break;
			case 36:
				//HOME
				this.select(this.getFirstTraverseNode(), false, shiftKey);
				this.oInt.scrollTop = 0;
				//Q.scrollIntoView(true);
			break;
			case 35:
				//END
				this.select(this.getLastTraverseNode(), false, shiftKey);
				this.oInt.scrollTop = this.oInt.scrollHeight;
				//Q.scrollIntoView(true);
			break;
			case 93:
			//CONTEXT MENU
				if(this.value && this.oncontextmenu) this.oncontextmenu(true);
				return false;
			break;
			default:
				if(key == 65 && ctrlKey){
					this.selectAll();
				}
				else if(this.bindingRules["Caption"]){
					//this should move to a onkeypress based function
					if(!this.lookup || new Date().getTime() - this.lookup.date.getTime() > 300) this.lookup = {
						str : "",
						date : new Date()
					};
					
					this.lookup.str += String.fromCharCode(key);
	
					var nodes = this.getTraverseNodes();
					for(var v,i=0;i<nodes.length;i++){
						v = this.applyRuleSetOnNode("Caption", nodes[i]);
						if(v && v.substr(0, this.lookup.str.length).toUpperCase() == this.lookup.str){
							this.select(nodes[i]);
							if(this.selected) this.oInt.scrollTop = this.selected.offsetTop - (this.oInt.offsetHeight - this.selected.offsetHeight)/2;
							return;
						}
					}
					
					return;
				}
			break;
		};
		
		this.lookup = null;
		return false;
	}
	
	
	/************************
			DATABINDING
	************************/
	
	this.nodes = [];
	
	this.__add = function(xmlNode, Lid, xmlParentNode, htmlParentNode, beforeNode){
		//Build Row
		this.__getNewContext("Item");
		var Item = this.__getLayoutNode("Item");
		var elSelect = this.__getLayoutNode("Item", "select");
		var elIcon = this.__getLayoutNode("Item", "icon");
		var elImage = this.__getLayoutNode("Item", "image");
		var elCheckbox = this.__getLayoutNode("Item", "checkbox");
		var elCaption = this.__getLayoutNode("Item", "caption");
		
		Item.setAttribute("id", Lid);
		
		elSelect.setAttribute("oncontextmenu", 'Kernel.lookup(' + this.uniqueId + ').dispatchEvent("oncontextmenu");');
		elSelect.setAttribute("onmouseover", 'Kernel.lookup(' + this.uniqueId + ').__setStyleClass(this, "hover");');
		elSelect.setAttribute("onmouseout", 'Kernel.lookup(' + this.uniqueId + ').__setStyleClass(this, "", ["hover"]);'); 
		
		if(this.hasFeature(__RENAME__)){
			elSelect.setAttribute("ondblclick", 'var o = Kernel.lookup(' + this.uniqueId + '); o.cancelRename(); o.choose()');
			elSelect.setAttribute(this.itemSelectEvent || "onmousedown", 'var o = Kernel.lookup(' + this.uniqueId + ');if(!o.renaming && o.isFocussed() && XMLDatabase.isChildOf(o.selected, this)) this.dorename = true;o.select(this, event.ctrlKey, event.shiftKey)'); 
			elSelect.setAttribute("onmouseup", 'if(this.dorename) Kernel.lookup(' + this.uniqueId + ').startDelayedRename(event); this.dorename = false;');
		}
		else{
			elSelect.setAttribute("ondblclick", 'var o = Kernel.lookup(' + this.uniqueId + '); o.choose()');
			elSelect.setAttribute(this.itemSelectEvent || "onmousedown", 'var o = Kernel.lookup(' + this.uniqueId + '); o.select(this, event.ctrlKey, event.shiftKey)'); 
		}
		
		//Setup Nodes Identity (Look)
		if(elIcon){
			if(elIcon.nodeType == 1) elIcon.setAttribute("style", "background-image:url(" + this.iconPath + this.applyRuleSetOnNode("Icon", xmlNode) + ")");
			else elIcon.nodeValue = this.iconPath + this.applyRuleSetOnNode("Icon", xmlNode);
		}
		else if(elImage){
			if(elImage.nodeType == 1) elImage.setAttribute("style", "background-image:url(" + this.mediaPath + this.applyRuleSetOnNode("Image", xmlNode) + ")");
			else{
				if(IS_SAFARI_OLD){ //HAAAAACCCCKKKKKK!!! this should be changed... blrgh..
					var p = elImage.ownerElement.parentNode;
					var img = p.appendChild(p.ownerDocument.createElement("img"));
					img.setAttribute("src", this.mediaPath + this.applyRuleSetOnNode("Image", xmlNode));
				}
				else{
					elImage.nodeValue = this.mediaPath + this.applyRuleSetOnNode("Image", xmlNode);
				}
			}
		}
		
		if(elCaption){
			XMLDatabase.setNodeValue(elCaption, this.applyRuleSetOnNode("Caption", xmlNode));
			
		}
		Item.setAttribute("title", this.applyRuleSetOnNode("Title", xmlNode) || "");
		
		var cssClass = this.applyRuleSetOnNode("CSS", xmlNode);
		if(cssClass){
			this.__setStyleClass(Item, cssClass);
			if(cssClass) this.dynCssClasses.push(cssClass);
		}

		if(this.__addModifier) this.__addModifier(xmlNode, Item);

		if(htmlParentNode) XMLDatabase.htmlImport(Item, htmlParentNode, beforeNode);
		else this.nodes.push(Item);
	}
	
	this.__fill = function(){
		XMLDatabase.htmlImport(this.nodes, this.oInt);
		this.nodes.length = 0;
		//alert((this == prevMainBG) + ":" + this.oInt.outerHTML + ":" + this.XMLRoot.xml);
		
	}
	
	/************************
				SELECT
	************************/
	
	this.__calcSelectRange = function(xmlStartNode, xmlEndNode){
		var r = [], loopNode = xmlStartNode;
		while(loopNode && loopNode != xmlEndNode.nextSibling){
			if(this.applyRuleSetOnNode("Select", loopNode, ".") !== false) r.push(loopNode);
			loopNode = loopNode.nextSibling;
		}

		if(r[r.length-1] != xmlEndNode){
			var r = [], loopNode = xmlStartNode;
			while(loopNode && loopNode != xmlEndNode.previousSibling){
				if(this.applyRuleSetOnNode("Select", loopNode, ".") !== false) r.push(loopNode);
				loopNode = loopNode.previousSibling;
			};
		}
		
		return r;
	}
	
	this.__selectDefault = function(XMLRoot){
		this.select(this.getTraverseNodes()[0]);
	}
	
	this.inherit(MultiSelect);
	this.inherit(Cache);
	
	/************************
	  Other Inheritance
	************************/
	
	this.inherit(Presentation);
	this.inherit(DataBinding);
	
	this.loadInlineData = function(x){
		var hasIcon, strData = [], nodes = x.childNodes;

		for(var i=nodes.length-1;i>=0;i--){
			if(nodes[i].nodeType != 1) continue;
			if(nodes[i][TAGNAME] != "Item") continue;
			
			hasIcon = nodes[i].getAttribute("icon") || "icoAnything.gif";
			hasImage = nodes[i].getAttribute("image");

			strData.unshift(
				"<Item " + 
				(hasImage ? "image='" + hasImage + "'" : (hasIcon ? "icon='" + hasIcon + "'" : "")) + 
				" value='" + (nodes[i].getAttributeNode("value") ? nodes[i].getAttribute("value") : (nodes[i].firstChild ? nodes[i].firstChild.nodeValue : "")).replace(/'/g, "") + "'>" + 
				(nodes[i].firstChild ? nodes[i].firstChild.nodeValue : "") + "</Item>");//HACK!
			nodes[i].parentNode.removeChild(nodes[i]);
		}

		if(strData.length){
			var sNode = new SmartBinding(null, Kernel.getObject("XMLDOM", "<j:smartbindings xmlns:j='http://www.javeline.net/j'><j:bindings><Caption select='text()' />" + (hasImage ? "<Image select='@image' />" : (hasIcon ? "<Icon select='@icon'/>" : "")) + "<Value select='@value'/><Traverse select='Item' /></j:bindings><j:model><Items>" + strData.join("") + "</Items></j:model></j:smartbindings>").documentElement);
			Application.addToSbStack(this.uniqueId, sNode);
		}
		
		if(x.childNodes.length)
			Application.loadSubNode(x, null, this);
	}
	
	this.loadFillData = function(str){
		var parts = str.split("-");
		var start = parseInt(parts[0]);
		var end = parseInt(parts[1]);
		
		strData = [];
		for(var i=start;i<end+1;i++){
			strData.push("<Item>" + (i+"").pad(Math.max(parts[0].length, parts[1].length), "0") + "</Item>");
		}
		
		if(strData.length){
			var sNode = new SmartBinding(null, Kernel.getObject("XMLDOM", "<j:smartbindings xmlns:j='http://www.javeline.net/j'><j:bindings><Caption select='text()' /><Value select='text()'/><Traverse select='Item' /></j:bindings><j:model><Items>" + strData.join("") + "</Items></j:model></j:smartbindings>").documentElement);
			Application.addToSbStack(this.uniqueId, sNode);
		}
	}
}


/*FILEHEAD(/in/Components/bcTab.js)SIZE(9980)TIME(1187087508069)*/

function BcTab(){
	/*********************************************************************
										PROPERTIES
	*********************************************************************/

	this.activePage = -1;
	this.isPaged = true;
	this.focussable = true;
	var lastpages = [], pages = [], pageLUT = {};

	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.setActiveTab = function(active){
		return this.setProperty("activepage", active);	
	}

	this.__setActiveTab = function(active, no_event){
		if(typeof active == "string") active = pageLUT[active] || parseInt(active);
		if(!active) active = 0;
		
		if(!no_event && this.dispatchEvent("onbeforeswitch", active, pages[active]) === false){
			if(this.hideLoader) this.hideLoader(); 
			return false;
		}
		if(this.switchType == "hide-all" && (HAS_DESKRUN || HAS_WEBRUN)) DeskRun.hideAll();
		if(!pages[active]) return false;
		
		// if we have a fake-page structure, only update the tabs visiblity when active==0	
		if(this.activePage > -1) pages[this.activePage].deactivate(pages[active].fake);
		pages[active].activate();
		
		this.activePage = active;
		
		if(self.LayoutServer)
			LayoutServer.forceResize(pages[active].oInt);
		/*if(IS_IE){
			if(pages[active].oInt.onresize) pages[active].oInt.onresize();
		}
		else if(window.onresize) window.onresize();*/
		
		if(HAS_DESKRUN || HAS_WEBRUN){
			if(this.switchType == "hide-all") DeskRun.showAll();
			else DeskRun.fixShow();
		}
		
		if(this.hideLoader) this.hideLoader(); 
		if(!no_event) this.dispatchEvent("onafterswitch", active, pages[active]);
	}
	
	this.__supportedProperties = ["activepage"];
	this.__handlePropSet = function(prop, value, reqValue){
		if(prop == "activepage") this.__setActiveTab(value);
	}
	
	this.getPages = function(){return pages}
	this.getPage = function(id){return pages[id || id === 0 ? id : this.activePage]}
	this.getPageName = function(id){return pages[id || id === 0 ? id : this.activePage].jml.getAttribute("name");}
	this.getPageId = function(name){return pageLUT[name];}
	
	function forpages(feat){
		for(var i=0;i<pages.length;i++)
			pages[i][feat]();
	}
	
	/************************
		DISABLING
	************************/
	
	this.__enable = function(){
		forpages("enable");
	}
	
	this.__disable = function(){
		forpages("disable");
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/

	this.addPage = function(xmlNode, userfunc){
		var id = pages.push(new TabPage(xmlNode, this)) - 1;
		if(pages[id].jml.getAttribute("name")) pageLUT[pages[id].jml.getAttribute("name")] = id;
		pages[id].draw(this.hasButtons, id, lastpages[id]);
		if(userfunc) userfunc.call(pages[id], xmlNode);
	}
	
	/************************
		Keyboard Support
	************************/
	
	//Handler for a plane list
	this.__keyHandler = function(key, ctrlKey, shiftKey, altKey){
		switch(key){
			case 9:
			
			break;
			case 13:
			
			break;
			case 32:
			
			break;
			case 37:
			//LEFT
				prevPage = this.activePage-1;
				while(prevPage >= 0 && !pages[prevPage].isVisible())
					prevPage--;
				if (prevPage >= 0)
					this.setActiveTab(prevPage);
			break;
			case 39:
			//RIGHT
				nextPage = this.activePage+1;
				while(nextPage < pages.length && !pages[nextPage].isVisible())
					nextPage++;
				if (nextPage < pages.length)
					this.setActiveTab(nextPage);	
			break;
			case 93:
			//CONTEXT MENU
			
			break;
			default:
			
			return;
		}
		
		//return false;
	}
	

	/************************
	  Other Inheritance
	************************/
	this.inherit(Presentation);
	
	this.editableParts = {"Button" : [["caption","@caption"]]};
	
	this.__drawTabs = function(userfunc){
		if(pages.length){
			lastpages = pages;
			pages = []; 
		}
		
		var nodes = this.jml.childNodes;
		for(var i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1) continue;
			var tagName = nodes[i].tagName.replace(/^j\:/, "");

			if(tagName == "Page") this.addPage(nodes[i], userfunc);
			else if(tagName == "Loading") this.setLoading(nodes[i]);
			else if(this.addOther) this.addOther(tagName, nodes[i]);
		}
		
		lastpages = null;

		if(pages.length && this.activepage == 0) this.__setActiveTab(0);
		else if(pages.length){
			this.activepage = 0;
			this.__setActiveTab(0, true);
		}
		else Application.loadSubNode(this.jml, this.oExt, this);
	}
}

function TabPage(JML, pJmlNode){
	Kernel.register(this, "TabPage", GUI_NODE);

	this.jml = JML;
	this.name = this.jml.getAttribute("name");
	this.fake = this.jml.getAttribute("fake")=='true';
	
	if(this.name) Kernel.setReference(this.name, this);
	this.hasButtons = false;
	this.pHtmlNode = pJmlNode.oPages;
	
	this.parentNode = pJmlNode;
	
	//Hack!!! somehow loadJml parts should be done here...
	if(this.jml.getAttribute("actiontracker")){
		if(this.jml.getAttribute("actiontracker") == "new")
			this.__ActionTracker = new _ActionTracker(this);
		else if(self[this.jml.getAttribute("actiontracker")])
			this.__ActionTracker = Application.getActionTracker(this.jml.getAttribute("actiontracker"));
	}
	
	this.editableParts = {"Button" : [["caption","@caption"]]};
	
	this.setCaption = function(caption){
		this.caption = caption;
		XMLDatabase.setNodeValue(pJmlNode.__getLayoutNode("Button", "caption", this.oButton), caption);
	}

	/*this.getCaption = function(caption){
		return XMLDatabase.getNodeValue(pJmlNode.__getLayoutNode("Button", "caption", this.oButton));
	}*/
	
	// Actually, these two should be clearly marked as internals as they allow for total 
	// loss of any active tab, or activating more than one.	
	this.deactivate = function(fakeOther){
		if(this.disabled) return false;

		this.isActive = false
		
		if(this.hasButtons){
			//if(active == 0) this.__setStyleClass(this.buttons[active], "", ["firstcurbtn"]);
			pJmlNode.__setStyleClass(this.oButton, "", ["curbtn"]);
		}
		if(!this.fake && !fakeOther)pJmlNode.__setStyleClass(this.oExt, "", ["curpage"]);
	}
	
	this.activate = function(){
		if(this.disabled) return false;
		
		if(this.hasButtons){
			//if(active == 0) this.__setStyleClass(this.buttons[active], "firstcurbtn");
			pJmlNode.__setStyleClass(this.oButton, "curbtn");
		}
		if(!this.fake)pJmlNode.__setStyleClass(this.oExt, "curpage");
		
		this.isActive = true;
		
		this.render(true);
	}
	
	this.hide = function(){
		//if(this.oButton) this.oButton.style.display = "none";
		//this.oExt.style.display = "none";
		
		if (this.isActive)
		{
			this.deactivate();
			
			// Try to find a next page, if any.
			var nextPage = this.parentNode.activePage + 1;
			while (nextPage < this.parentNode.getPages().length && !this.parentNode.getPage(nextPage).isVisible())
				nextPage++;
			if (nextPage == this.parentNode.getPages().length)
			{
				// Try to find a previous page, if any.
				nextPage = this.parentNode.activePage - 1;
				while (nextPage >= 0 && this.parentNode.getPages().length && !this.parentNode.getPage(nextPage).isVisible())
					nextPage--;
			}
			
			if (nextPage >= 0)
				this.parentNode.getPage(nextPage).activate();		
		}
	}
	
	this.show = function(){
		//if(this.oButton) this.oButton.style.display = "block";
		//this.oExt.style.display = "block";
		
		if (!this.isActive){
			this.activate();
			var pages = this.parentNode.getPages();
			for(var i=0;i<pages.length;i++){
				if(pages[i] == this){
					pJmlNode.setActiveTab(i);
					break;
				}
			}
		}
	}
	
	this.draw = function(drawButtons, id, lastPage){
		this.hasButtons = drawButtons;
		this.caption = this.jml.getAttribute("caption");
		
		if(drawButtons){
			pJmlNode.__getNewContext("Button");
			var elBtn = pJmlNode.__getLayoutNode("Button");
			elBtn.setAttribute(pJmlNode.__getOption("Main", "select") || "onmousedown", 'Kernel.lookup(' + pJmlNode.uniqueId + ').setActiveTab(' + id + ');if(!IS_SAFARI_OLD) this.onmouseout()');
			elBtn.setAttribute("onmouseover", 'var o = Kernel.lookup(' + pJmlNode.uniqueId + ');if(' + id + ' != o.activePage) o.__setStyleClass(this, "over");');
			elBtn.setAttribute("onmouseout", 'var o = Kernel.lookup(' + pJmlNode.uniqueId + '); o.__setStyleClass(this, "", ["over"]);');
			this.oButton = XMLDatabase.htmlImport(elBtn, pJmlNode.oButtons);
			
			this.setCaption(this.caption);
			
				pJmlNode.__makeEditable("Button", this.oButton, this.jml);
		}
		
		this.oExt = pJmlNode.__getExternal("Page", pJmlNode.oPages, null, this.jml);
		this.oInt = pJmlNode.__getLayoutNode("Page", "container", this.oExt);
		
		if(lastPage){
			Application.replaceNode(this.oInt, lastPage.oInt);
			this.oInt.setAttribute("id", lastPage.oInt.getAttribute("id"));
		}
		else Application.loadSubNode(this.jml, this.oInt, this, true);
	}
	
	this.__destroy = function(){
		this.oButton = null;
	}
	
	/************************
		OTHER INHERITANCE
	************************/
	
	this.inherit(DelayedRender);
	
	//Hack
	this.addEventListener("onbeforerender", function(){pJmlNode.dispatchEvent("onbeforerender", this);});
	this.addEventListener("onafterrender", function(){pJmlNode.dispatchEvent("onafterrender", this);});
	
	//this.inherit(Presentation);
	this.inherit(JmlNode);
	
	this.inherit(JmlDomAPI);
}


/*FILEHEAD(/in/Components/bcFastList.js)SIZE(16393)TIME(1182088294453)*/

function BcFastList(){
	/*********************************************************************
										PROPERTIES
	*********************************************************************/

	//Options
	this.inherit(Validation);
	this.focussable = true; // This object can get the focus
	this.multiselect = true; // Initially Disable MultiSelect
	
	this.dynCssClasses = [];
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/

	/************************
				Skin
	************************/

	this.__deInitNode = function(xmlNode, htmlNode){
		if(!htmlNode) return;

		//Remove htmlNodes from tree
		htmlNode.parentNode.removeChild(htmlNode);
	}

	this.scrollTo = function(xmlNode, updateScrollbar){
		this.lastScroll = xmlNode;
		
		var xNodes = this.getTraverseNodes();
		for(var j=xNodes.length-1;j>=0;j--){
			if(xNodes[j] == xmlNode) break;
		}
		
		if(updateScrollbar){
			this.sb.setPosition(j/(xNodes.length-this.nodeCount), true);
		}
		
		var sNodes = {}, selNodes = this.getSelection();
		for(var i=selNodes.length-1;i>=0;i--){
			sNodes[selNodes[i].getAttribute(XMLDatabase.xmlIdTag)] = true;
			this.__deselect(document.getElementById(selNodes[i].getAttribute(XMLDatabase.xmlIdTag) + "|" + this.uniqueId));
		}
		
		var nodes = this.oInt.childNodes;
		for(var id, i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1) continue;
			xmlNode = xNodes[j++];
			
			if(!xmlNode) nodes[i].style.display = "none";
			else{
				nodes[i].setAttribute(XMLDatabase.htmlIdTag, xmlNode.getAttribute(XMLDatabase.xmlIdTag) + "|" + this.uniqueId);
				this.__updateNode(xmlNode, nodes[i]);
				nodes[i].style.display = "block"; // or inline
				
				if(sNodes[xmlNode.getAttribute(XMLDatabase.xmlIdTag)])
					this.__select(nodes[i]);
			}
		}
	}

	this.__updateNode = function(xmlNode, htmlNode){
		//Update Identity (Look)
		var elIcon = this.__getLayoutNode("Item", "icon", htmlNode);
		
		if(elIcon){
			if(elIcon.nodeType == 1) elIcon.style.backgroundImage = "url(" + this.iconPath + this.applyRuleSetOnNode("Icon", xmlNode) + ")";
			else elIcon.nodeValue = this.iconPath + this.applyRuleSetOnNode("Icon", xmlNode);
		}
		else{
			var elImage = this.__getLayoutNode("Item", "image", htmlNode);//.style.backgroundImage = "url(" + this.applyRuleSetOnNode("Image", xmlNode) + ")";
			if(elImage){
				if(elImage.nodeType == 1) elImage.style.backgroundImage = "url(" + this.applyRuleSetOnNode("Image", xmlNode) + ")";
				else elImage.nodeValue = this.applyRuleSetOnNode("Image", xmlNode);
			}
		}
			
		//this.__getLayoutNode("Item", "caption", htmlNode).nodeValue = this.applyRuleSetOnNode("Caption", xmlNode);
		var elCaption = this.__getLayoutNode("Item", "caption", htmlNode);
		if(elCaption){
			if(elCaption.nodeType == 1)
				elCaption.innerHTML = this.applyRuleSetOnNode("Caption", xmlNode);
			else elCaption.nodeValue = this.applyRuleSetOnNode("Caption", xmlNode);
		}

		var cssClass = this.applyRuleSetOnNode("CSS", xmlNode);
		if(cssClass || this.dynCssClasses.length){
			this.__setStyleClass(htmlNode, cssClass, this.dynCssClasses);
			if(cssClass && !this.dynCssClasses.contains(cssClass)) this.dynCssClasses.push(cssClass);
		}
	}
	
	this.__moveNode = function(xmlNode, htmlNode){
		if(!htmlNode) return;
		var oPHtmlNode = htmlNode.parentNode;
		var beforeNode = xmlNode.nextSibling ? XMLDatabase.findHTMLNode(this.getNextTraverse(xmlNode), this) : null;

		oPHtmlNode.insertBefore(htmlNode, beforeNode);
		
		//if(this.emptyMessage && !oPHtmlNode.childNodes.length) this.setEmpty(oPHtmlNode);
	}
	
	/************************
		Keyboard Support
	************************/
	
	//Handler for a plane list
	this.__keyHandler = function(key, ctrlKey, shiftKey, altKey){
		if(!this.selected) return;
		//error after delete...
		
		var jNode = this;
		function selscroll(sel, scroll){
			if(!jNode.selected){
				jNode.scrollTo(scroll || sel, true);
				
				if(ctrlKey) jNode.setIndicator(sel);
				else jNode.select(sel, null, shiftKey);
			}
		}

		switch(key){
			case 13:
				this.choose(this.selected);
			break;
			case 32:
				this.select(this.indicator, true);
			break;
			case 46:
			//DELETE
				if(this.disableremove) return;
			
				this.Remove(null, true);
			break;
			case 37:
			//LEFT
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
			
				if(!this.value) return;
				var node = this.getNextTraverseSelected(this.indicator || this.value, false);
				if(node){
					if(ctrlKey) this.setIndicator(node);
					else this.select(node, null, shiftKey);
					
					if(!this.selected) selscroll(node, this.getNextTraverse(this.lastScroll, true));
					if(!this.selected) selscroll(node, node);
				}
			break;
			case 38:
			//UP
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				
				if(!this.value && !this.indicator) return;
				var hasScroll = this.oExt.scrollHeight > this.oExt.offsetHeight;
				var items = Math.floor((this.oExt.offsetWidth - (hasScroll ? 15 : 0)) / (this.selected.offsetWidth+margin[1]+margin[3]));
				var node = this.getNextTraverseSelected(this.indicator || this.value, false, items);

				if(node){
					if(ctrlKey) this.setIndicator(node);
					else this.select(node, null, shiftKey);
					
					if(!this.selected) selscroll(node, this.getNextTraverse(this.lastScroll, true));
					if(!this.selected) selscroll(node, node);
				}
			break;
			case 39:
			//RIGHT
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				
				if(!this.value) return;
				var node = this.getNextTraverseSelected(this.indicator || this.value, true);
				if(node){
					if(ctrlKey) this.setIndicator(node);
					else this.select(node, null, shiftKey);
					
					if(!this.selected) selscroll(node, this.getNextTraverse(this.lastScroll, true));
					if(!this.selected) selscroll(node, node);
				}
			break;
			case 40:
			//DOWN
				var margin = Kernel.compat.getBox(Kernel.getStyle(this.selected, "margin"));
				if(!this.value && !this.indicator) return;
				var hasScroll = this.oExt.scrollHeight > this.oExt.offsetHeight;
				var items = Math.floor((this.oExt.offsetWidth - (hasScroll ? 15 : 0)) / (this.selected.offsetWidth+margin[1]+margin[3]));
				var node = this.getNextTraverseSelected(this.indicator || this.value, true, items);
				if(node){
					if(ctrlKey) this.setIndicator(node);
					else this.select(node, null, shiftKey);

					var s2 = this.getNextTraverseSelected(node, true, items);
					if(s2 && !document.getElementById(s2.getAttribute(XMLDatabase.xmlIdTag) + "|" + this.uniqueId)){
						if(!this.selected) selscroll(node, this.getNextTraverse(this.lastScroll));
						if(!this.selected) selscroll(node, node);
					}
					else if(s2 == node){
						var nodes = this.getTraverseNodes();
						if(!this.selected) selscroll(node, nodes[nodes.length-this.nodeCount+1]);
						if(!this.selected) selscroll(node, node);
					}
				}
				
				//if(this.selected.offsetTop + this.selected.offsetHeight > this.oExt.scrollTop + this.oExt.offsetHeight - (hasScroll ? 10 : 0))
					//this.oExt.scrollTop = this.selected.offsetTop - this.oExt.offsetHeight + this.selected.offsetHeight + 10 + (hasScroll ? 10 : 0);
				
			break;
			case 33:
			//PGUP
				if(!this.value && !this.indicator) return;
				
				var node = this.getNextTraverseSelected(this.indicator || this.value, false, this.nodeCount-1);//items*lines);
				if(!node) node = this.getFirstTraverseNode();
				
				this.scrollTo(node, true);
				if(node){
					if(ctrlKey) this.setIndicator(node);
					else this.select(node, null, shiftKey);
				}
			break;
			case 34:
			//PGDN
				if(!this.value && !this.indicator) return;
				var node = this.getNextTraverseSelected(this.indicator || this.value, true, this.nodeCount-1);
				if(!node) node = this.getLastTraverseNode();
				
				var xNodes = this.getTraverseNodes();
				for(var j=xNodes.length-1;j>=0;j--) if(xNodes[j] == node) break;
				if(j>xNodes.length-this.nodeCount-1) j = xNodes.length-this.nodeCount+1;
				this.scrollTo(xNodes[j], true);
				if(xNodes[j] != node) node = xNodes[xNodes.length-1];
				
				if(node){
					if(ctrlKey) this.setIndicator(node);
					else this.select(node, null, shiftKey);
				}
			break;
			case 36:
				//HOME
				var xmlNode = this.getFirstTraverseNode();
				this.scrollTo(xmlNode, true);
				this.select(xmlNode, null, shiftKey);
				//this.oInt.scrollTop = 0;
				//Q.scrollIntoView(true);
			break;
			case 35:
				//END
				var nodes = this.getTraverseNodes(xmlNode || this.XMLRoot);//.selectNodes(this.ruleTraverse);
				this.scrollTo(nodes[nodes.length-this.nodeCount+1], true);
				this.select(nodes[nodes.length-1], null, shiftKey);
				//Q.scrollIntoView(true);
			break;
			case 93:
			//CONTEXT MENU
				if(this.value && this.oncontextmenu) this.oncontextmenu(true);
				return false;
			break;
			default:
				if(key == 65 && ctrlKey){
					this.selectAll();
				}
				else if(this.bindingRules["Caption"]){
					//this should move to a onkeypress based function
					if(!this.lookup || new Date().getTime() - this.lookup.date.getTime() > 300) this.lookup = {
						str : "",
						date : new Date()
					};
					
					this.lookup.str += String.fromCharCode(key);
	
					var nodes = this.getTraverseNodes();
					for(var i=0;i<nodes.length;i++){
						if(this.applyRuleSetOnNode("Caption", nodes[i]).substr(0, this.lookup.str.length).toUpperCase() == this.lookup.str){
							this.scrollTo(nodes[i], true);
							this.select(nodes[i]);
							return;
						}
					}
					
					return;
				}
			break;
		};
		
		this.lookup = null;
		return false;
	}
	
	
	/************************
			DATABINDING
	************************/
	
	this.nodes = [];
	
	this.nodeCount = 0;
	this.__add = function(xmlNode, Lid, xmlParentNode, htmlParentNode, beforeNode){
		if(!this.oInt.childNodes.length) this.nodeCount = 0;
		
		//Check if more items should be added
		if(this.nodeCount > 9){//this.oInt.scrollHeight >= this.oInt.offsetHeight){
			// || this.oInt.scrollWidth > this.oInt.offsetWidth
			return false;
		}
		this.nodeCount++;
		
		//Build Row
		this.__getNewContext("Item");
		var Item = this.__getLayoutNode("Item");
		var elSelect = this.__getLayoutNode("Item", "select");
		var elIcon = this.__getLayoutNode("Item", "icon");
		var elImage = this.__getLayoutNode("Item", "image");
		var elCheckbox = this.__getLayoutNode("Item", "checkbox");
		var elCaption = this.__getLayoutNode("Item", "caption");
		
		Item.setAttribute("id", Lid);
		
		elSelect.setAttribute("oncontextmenu", 'Kernel.lookup(' + this.uniqueId + ').dispatchEvent("oncontextmenu");');
		elSelect.setAttribute("ondblclick", 'Kernel.lookup(' + this.uniqueId + ').choose()');
		elSelect.setAttribute(this.itemSelectEvent || "onmousedown", 'Kernel.lookup(' + this.uniqueId + ').select(this, event.ctrlKey, event.shiftKey)'); 
		elSelect.setAttribute("onmouseover", 'Kernel.lookup(' + this.uniqueId + ').__setStyleClass(this, "hover");');
		elSelect.setAttribute("onmouseout", 'Kernel.lookup(' + this.uniqueId + ').__setStyleClass(this, "", ["hover"]);'); 
		
		//Setup Nodes Identity (Look)
		if(elIcon){
			if(elIcon.nodeType == 1) elIcon.setAttribute("style", "background-image:url(" + this.iconPath + this.applyRuleSetOnNode("Icon", xmlNode) + ")");
			else elIcon.nodeValue = this.iconPath + this.applyRuleSetOnNode("Icon", xmlNode);
		}
		else if(elImage){
			if(elImage.nodeType == 1) elImage.setAttribute("style", "background-image:url(" + this.applyRuleSetOnNode("Image", xmlNode) + ")");
			else elImage.nodeValue = this.applyRuleSetOnNode("Image", xmlNode);
		}
		
		if(elCaption) XMLDatabase.setNodeValue(elCaption, this.applyRuleSetOnNode("Caption", xmlNode));
		
		var cssClass = this.applyRuleSetOnNode("CSS", xmlNode);
		if(cssClass){
			this.__setStyleClass(Item, cssClass);
			if(cssClass) this.dynCssClasses.push(cssClass);
		}

		XMLDatabase.htmlImport(Item, htmlParentNode || this.oInt, beforeNode);
		/*
		if(htmlParentNode) XMLDatabase.htmlImport(Item, htmlParentNode || this.oInt, beforeNode);
		else this.nodes.push(Item);
		*/
	}
	
	this.__fill = function(){
		//XMLDatabase.htmlImport(this.nodes, this.oInt);
		//this.nodes.length = 0;
		//alert((this == prevMainBG) + ":" + this.oInt.outerHTML + ":" + this.XMLRoot.xml);
		
		var jmlNode = this;
		this.lastScroll = this.getFirstTraverseNode();
		if(this.sb) this.sb.attach(this.oExt, this.nodeCount, this.getTraverseNodes().length, function(time, perc){
			var nodes = jmlNode.getTraverseNodes();
			jmlNode.scrollTo(nodes[Math.round((nodes.length-jmlNode.nodeCount+1)*perc)]);
		});
	}
	
	/************************
				SELECT
	************************/
	
	this.__calcSelectRange = function(xmlStartNode, xmlEndNode){
		var r = [], loopNode = xmlStartNode;
		while(loopNode && loopNode != xmlEndNode.nextSibling){
			if(this.applyRuleSetOnNode("Select", loopNode, ".") !== false) r.push(loopNode);
			loopNode = loopNode.nextSibling;
		}

		if(r[r.length-1] != xmlEndNode){
			var r = [], loopNode = xmlStartNode;
			while(loopNode && loopNode != xmlEndNode.previousSibling){
				if(this.applyRuleSetOnNode("Select", loopNode, ".") !== false) r.push(loopNode);
				loopNode = loopNode.previousSibling;
			};
		}
		
		return r;
	}
	
	this.__selectDefault = function(XMLRoot){
		this.select(this.getTraverseNodes()[0]);
	}
	
	this.inherit(MultiSelect);
	this.inherit(Cache);
	
	/************************
	  Other Inheritance
	************************/
	
	this.inherit(Presentation);
	this.inherit(DataBinding);
	
	this.loadInlineData = function(x){
		var hasIcon, strData = [], nodes = x.childNodes;

		for(var i=nodes.length-1;i>=0;i--){
			if(nodes[i].nodeType != 1) continue;
			if(nodes[i][TAGNAME] != "Item") continue;
			
			hasIcon = nodes[i].getAttribute("icon") || "icoAnything.gif";
			strData.unshift("<Item " + (hasIcon ? "icon='" + hasIcon + "'" : "") + " value='" + (nodes[i].getAttributeNode("value") ? nodes[i].getAttribute("value") : nodes[i].firstChild.nodeValue) + "'>" + nodes[i].firstChild.nodeValue + "</Item>");
			nodes[i].parentNode.removeChild(nodes[i]);
		}

		if(strData.length){
			var sNode = new SmartBinding(null, Kernel.getObject("XMLDOM", "<j:smartbindings xmlns:j='http://www.javeline.net/j'><j:bindings><Caption select='text()' />" + (hasIcon ? "<Icon select='@icon'/>" : "") + "<Value select='@value'/><Traverse select='Item' /></j:bindings><j:model><Items>" + strData.join("") + "</Items></j:model></j:smartbindings>").documentElement);
			Application.addToSbStack(this.uniqueId, sNode);
		}
		
		if(x.childNodes.length)
			Application.loadSubNode(x, null, this);
	}
	
	this.loadFillData = function(str){
		var parts = str.split("-");
		var start = parseInt(parts[0]);
		var end = parseInt(parts[1]);
		
		strData = [];
		for(var i=start;i<end+1;i++){
			strData.push("<Item>" + (i+"").pad(Math.max(parts[0].length, parts[1].length), "0") + "</Item>");
		}
		
		if(strData.length){
			var sNode = new SmartBinding(null, Kernel.getObject("XMLDOM", "<j:smartbindings xmlns:j='http://www.javeline.net/j'><j:bindings><Caption select='text()' /><Value select='text()'/><Traverse select='Item' /></j:bindings><j:model><Items>" + strData.join("") + "</Items></j:model></j:smartbindings>").documentElement);
			Application.addToSbStack(this.uniqueId, sNode);
		}
	}
}


/*FILEHEAD(/in/Components/bcButton.js)SIZE(3884)TIME(1185133511901)*/

function BcButton(pHtmlNode){
		
	/****************
		Init
	****************/

	this.refKeyDown = 0;			// Number of keys pressed. 
	this.refMouseDown = 0;		// Mouse button down?
	this.mouseOver = false;		// Mouse hovering over the button?
	this.mouseLeft = false;		// Has the mouse left the control since pressing the button.
	
	/************************
		Keyboard Support
	************************/
	
	this.keyHandler = function(key, ctrlKey, shiftKey, altKey, evnt){
		switch(key){
			case 32:
			case 13:
				if (!evnt.repeat) // Only when first pressed, not on autorepeat.
				{
					this.refKeyDown++;
					return this.__updateState(evnt);
				}
				else return false;
		}
	}

	this.keyUpHandler = function(key, ctrlKey, shiftKey, altKey, evnt){
		switch(key){
			case 32:
			case 13:
				this.refKeyDown--;
				if (this.refKeyDown + this.refMouseDown == 0 && !this.disabled){
					//if(this.oExt.onclick) this.oExt.onclick(evnt, true);
					//else if(this.oExt.onmouseup) 
					this.oExt.onmouseup(evnt, true);
				}
				return this.__updateState(evnt);
		}
	}

	this.states = {"Out":1,"Over":2,"Down":3}
	
	this.__updateState = function(e, strEvent)
	{
		if (this.disabled)
		{
			this.refKeyDown = 0;
			this.refMouseDown = 0;
			this.mouseOver = false;
			return false;
		}
		else
		{
			if (this.refKeyDown > 0 || (this.refMouseDown > 0 && this.mouseOver) || (this.isBoolean && this.value))
				this.__setState ("Down", e, strEvent);
			else if (this.mouseOver)
				this.__setState ("Over", e, strEvent);
			else this.__setState ("Out", e, strEvent);
		}
	}	
	
	this.__setupEvents = function()
	{
		this.oExt.onmousedown = function(e) { this.host.refMouseDown = 1; this.host.mouseLeft=false; this.host.__updateState(e || event, "onmousedown"); };
		this.oExt.onmouseup = function(e, force) {
			if(!e) e = event;
			if(e) e.cancelBubble = true;
			
			if(!force && (!this.host.mouseOver || !this.host.refMouseDown)) return;
			this.host.refMouseDown = 0; this.host.__updateState (e, "onmouseup"); 

			// If this is coming from a mouse click, we shouldn't have left the button.
			if (this.host.disabled || (e && e.type == "click" && this.host.mouseLeft == true))
				return false;
				
			// If there are still buttons down, this is not a real click.
			if (this.host.refMouseDown + this.host.refKeyDown)
				return false;	
	
			if (this.host.__clickHandler && this.host.__clickHandler())
				this.host.__updateState (e || event, "onclick");
			else this.host.dispatchEvent("onclick");
			
			return false;
		};
		this.oExt.onmousemove = function(e) { this.host.mouseOver = true; this.host.__updateState (e || event, "onmouseover"); };
		this.oExt.onmouseout = function(e) { 
			if(!e) e = event;
			
			//Check if the mouse out is meant for us
			var tEl = e.explicitOriginalTarget || e.toElement;
			if(this == tEl || XMLDatabase.isChildOf(this, tEl)) return;
				
			this.host.mouseOver = false; this.host.refMouseDown = 0; this.host.mouseLeft=true; this.host.__updateState (e || event, "onmouseout"); 
		};

		if(IS_IE) this.oExt.ondblclick = this.oExt.onmouseup;
	}
	
	this.__destroy = function(){
		this.oExt.onmousedown = null;
		this.oExt.onmouseup = null;
		this.oExt.onmouseover = null;
		this.oExt.onmouseout = null;
		this.oExt.onclick = null;
		this.oExt.ondblclick = null;
	}
	
	this.__focus = function(){
		if(!this.oExt) return;
		this.__setStyleClass(this.oExt, this.baseCSSname + "Focus");
	}

	this.__blur = function(e){
		if(!this.oExt) return; //FIREFOX BUG!
		if(IS_IE) e = event;
		
		this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Focus"]);
		this.refKeyDown = 0;
		this.refMouseDown = 0;
		this.mouseLeft=true;
		
		if(e) this.__updateState(e, "onblur");
	}	
}


/*FILEHEAD(/in/Components/bcSimple.js)SIZE(2448)TIME(1182726961382)*/

function BcSimple(){
	/************************
	  		Inheritance
	************************/
	this.inherit(Presentation);

	this.inherit(DataBinding);
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	this.getValue = function(){
		return this.value;
	}

	/************************
			DRAGDROP
	************************/
	
	this.__showDragIndicator = function(sel, e){
		var x = e.offsetX + 22;
		var y = e.offsetY;

		this.oDrag.startX = x;
		this.oDrag.startY = y;

		
		document.body.appendChild(this.oDrag);
		//this.oDrag.getElementsByTagName("DIV")[0].innerHTML = this.selected.innerHTML;
		//this.oDrag.getElementsByTagName("IMG")[0].src = this.selected.parentNode.parentNode.childNodes[1].firstChild.src;
		var oInt = this.__getLayoutNode("Main", "caption", this.oDrag);
		if(oInt.nodeType != 1) oInt = oInt.parentNode;
		
		oInt.innerHTML = this.applyRuleSetOnNode("Caption", this.XMLRoot) || "";
		
		return this.oDrag;
	}
	
	this.__hideDragIndicator = function(){
		this.oDrag.style.display = "none";
	}
	
	this.__moveDragIndicator = function(e){
		this.oDrag.style.left = (e.clientX - this.oDrag.startX + document.documentElement.scrollLeft) + "px";
		this.oDrag.style.top = (e.clientY - this.oDrag.startY + document.documentElement.scrollTop) + "px";
	}
	
	this.__initDragDrop = function(){
		this.oDrag = document.body.appendChild(this.oExt.cloneNode(true));
		
		this.oDrag.style.zIndex = 1000000;
		this.oDrag.style.position = "absolute";
		this.oDrag.style.cursor = "default";
		this.oDrag.style.filter = "progid:DXImageTransform.Microsoft.Alpha(opacity=50)";
		this.oDrag.style.MozOpacity = 0.5;
		this.oDrag.style.opacity = 0.5;
		this.oDrag.style.display = "none";
	}
	
	this.__dragout = 
	this.__dragover = 
	this.__dragdrop = function(){}
	
	this.inherit(DragDrop);
	
	
	/**********
		INIT
	**********/
	this.inherit(JmlNode);

	this.setFormEl = function(formEl){
		this.formEl = formEl;
	}
}


/*FILEHEAD(/in/Core/Kernel.js)SIZE(17079)TIME(1187087508069)*/
/** 
* @projectDescription 	Javeline Platform
*
* @author	Ruben Daniels ruben@javeline.nl
* @version	1.0
*/

VERSION 			= 0x000900;

NOGUI_NODE 		= 101;
GUI_NODE 		= 102;
KERNEL_MODULE	= 103;
MF_NODE 		= 104;

if(!self.DEBUG) DEBUG = false;
//NAMESPACE = document.all ? "scopeName" : "prefix";

//CGI VARS
var HTTP_GET_VARS={}, vars = location.href.split(/[\?\&\=]/);
for(var k=1;k<vars.length;k+=2) HTTP_GET_VARS[vars[k]] = vars[k+1] || "";

Array.prototype.dataType = "array";
Number.prototype.dataType = "number";
Date.prototype.dataType = "date";
Boolean.prototype.dataType = "boolean";
String.prototype.dataType = "string";
RegExp.prototype.dataType = "regexp";
Function.prototype.dataType = "function";

/**
 * @moduleDescription 	Javeline Platform Kernel
 */

//Initalizing Kernel
Kernel = {
	/**
	* This method returns a string representation of the object
	* @return {String}	Returns a string representing the object.
	* @method
	*/
	toString : function(){
		return "[Javeline (Kernel)]";
	},
	
	emptyf : function(){},
	
	all : [],
	hasContentEditable : IS_IE || IS_SAFARI,
	
	getElement : function(parent, nr){
		var nodes = parent.childNodes;
		for(var j=0,i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1) continue;
			if(j++ == nr) return nodes[i];
		}
	},
	
	/**
	* This method inherit all properties and methods to this object from another class
	* @param {Function}	classRef	Required Class reference 
	* @method
	*/
	inherit : function(classRef){classRef.call(this);},
	
	/**
	* This method transforms an object into a Javeline Class
	* @param {Object}	oBlank Required Object to be transformed into a Javeline Class
	* @method
	*/
	makeClass : function(oBlank){oBlank.inherit = this.inherit;oBlank.inherit(Class);},
	
	XSLTPrefix : IS_IE ? "xsl:" : "",
	
	/********* BROWSER FEATURES ***********
		Compatibility Methods and functions
	**************************************/
	root : true,
	named : {},

	Init : function(){
		try{
			//if(window.opener && window.opener.Kernel) this.all = window.opener.Kernel.all;
			if(IS_IE) document.execCommand("BackgroundImageCache", false, true);
		}catch(e){}
	},

	cancelBubble : function(e, o){
		e.cancelBubble = true;
		if(o.focussable && !o.disabled) me.__focus(o);
	},

	/**
	* This method sets a single CSS rule 
	* @param {String}	name Required CSS name of the rule (i.e. '.cls' or '#id')
	* @param {String}	type Required CSS property to change
	* @param {String}	value Required CSS value of the property
	* @param {String}	stylesheet Optional Name of the stylesheet to change 
	* @method
	*/	
	setStyleRule : function(name, type, value, stylesheet){
		var rules = document.styleSheets[stylesheet || 0][IS_IE ? "rules" : "cssRules"] ;
		for(var i=0;i<rules.length;i++){
			if(rules.item(i).selectorText == name){
				rules.item(i).style[type] = value;
				return;
			}
		}
	},

	/**
	* This method imports a stylesheet defined in a multidimensional array 
	* @param {Array}	def Required Multidimensional array specifying 
	* @param {Object}	win Optional Reference to a window
	* @method
	* @deprecated
	*/	
	importStylesheet : function(def, win){
		//if(IS_OPERA) return; //maybe version check here 9.21 it works, below might not
		for(var i=0;i<def.length;i++){
			if(def[i][1]){
				if(IS_IE)
					(win || window).document.styleSheets[0].addRule(def[i][0], def[i][1]);
				else
					(win || window).document.styleSheets[0].insertRule(def[i][0] + " {" + def[i][1] + "}", 0);
			}
		}
	},

	/**
	* This method imports a CSS stylesheet from a string 
	* @param {Object}	doc Required Reference to the document where the CSS is applied on
	* @param {String}	cssString Required String containing the CSS definition 
	* @param {String}	media Optional The media to which this CSS applies (i.e. 'print' or 'screen')
	* @method
	*/
	importCssString : function(doc, cssString, media){
		var htmlNode = doc.getElementsByTagName("head")[0];//doc.documentElement.getElementsByTagName("head")[0]
		if(htmlNode.insertAdjacentHTML){
			htmlNode.insertAdjacentHTML("beforeend", ".<style media='" + (media || "all") + "'>" + cssString + "</style>");

			//IE bug fix
			if(document.body && IS_IE6 && Application.IE6Fix){
				//document.body.style.height = "100%";
				//setTimeout('document.body.style.height = "auto"');
			}
		}
		else{
			var r = htmlNode.ownerDocument.createRange();
			r.setStartBefore(htmlNode);
			var parsedHTML = r.createContextualFragment("<style media='" + (media || "all") + "'>" + cssString + "</style>");
			htmlNode.appendChild(parsedHTML);
		}
	},

	/**
	* This method loads a stylesheet from a url
	* @param {String}	filename Required The url to load the stylesheet from
	* @param {String}	title Optional Title of the stylesheet to load
	* @method
	*/
	loadStylesheet : function(filename, title){
		with(o = document.getElementsByTagName("head")[0].appendChild(document.createElement("LINK"))){
			rel = "stylesheet";
			type = "text/css";
			href = filename;
			title = title;
		}

		return o;
	},

	/**
	* This method retrieves the current value of a property on a HTML element
	* @param {HTMLElement}	el Required The element to read the property from
	* @param {String}	prop Required The property to read 
	* @method
	*/
	getStyle : function(el, prop) {
		if(typeof document.defaultView != "undefined"
		   && typeof document.defaultView.getComputedStyle != "undefined")
			return document.defaultView.getComputedStyle(el,'').getPropertyValue(prop);
		return el.currentStyle[prop];
	},
	
	addEventListener : function(oHtml, eventName, method){
		if(IS_IE) oHtml["on" + eventName] = method;
		else oHtml.addEventListener(eventName, method, false);
	},
	
	removeNode : function (element) {
		if(!element) return;
		
		if(!IS_IE){
			if(element.parentNode) element.parentNode.removeChild(element);
			return;
		}
		
		var garbageBin = document.getElementById('IELeakGarbageBin');
		if (!garbageBin) {
			garbageBin = document.createElement('DIV');
			garbageBin.id = 'IELeakGarbageBin';
			garbageBin.style.display = 'none';
			document.body.appendChild(garbageBin);
		}
	
		// move the element to the garbage bin
		garbageBin.appendChild(element);
		garbageBin.innerHTML = '';
	},
	
	uniqueHtmlIds : 0,
	setUniqueHtmlId : function(oHtml){
		oHtml.setAttribute("id", "q" + this.uniqueHtmlIds++)
	},
	
	getUniqueId : function(oHtml){return this.uniqueHtmlIds++;},

	/********* NODE METHODS ***********
		Methods to help Javeline Nodes
	**********************************/

	local : [],
	locals : {},

	getRoot : function(){
		return this.root ? this : window.opener.Kernel;
	},

	getActiveWindow : function(){
		return this.getRoot().activeWindow;
	},

	getPath : function(path){
		return (path.match(/http\:\/\/|file\:\/\//) ? path : HOST_PATH + path);
	},

	register : function(o, tagName, nodeType){
		o.tagName = tagName;
		o.nodeType = nodeType || NOGUI_NODE;
		//o.kernel = this;
		o.uniqueId = this.all.push(o)-1;
		
		this.makeClass(o);

		if(o.nodeType == MF_NODE) DeskRun.register(o);

		if(!this.root){
			this.local.push(o);
			this.locals[o.uniqueId] = true;
		}
	},
	
	lookup : function(uniqueId){
		return this.all[uniqueId];
	},

	localLookup : function(uniqueId){
		if(this.locals.length && !this.locals[uniqueId]) return;
		return this.all[uniqueId];
	},

	findHost : function(o){
		var node = o;
		while(o && !o.host && o.parentNode) o = o.parentNode;
		return o && o.host ? o.host : false;
	},

	sleep : function(ms){
		if(IS_IE) window.showModalDialog('javascript:document.writeln("<script>window.setTimeout(function () { window.close(); }, ' + ms + ');</script>")');
	},
	
	availHTTP : [],
	
	releaseHTTP : function(http){
		if(IS_IE6) return;
		if(self.XMLHttpRequestUnSafe && http.constructor == XMLHttpRequestUnSafe) return;
		
		http.onreadystatechange = this.emptyf;
		http.abort();
		this.availHTTP.push(http);
	},

	/********* SETREFERENCE ***********
		Set Reference to an object by name
	
		INTERFACE:
		this.setReference(name, o, global);
	****************************/
	setReference : function(name, o, global){
		if(self[name] && self[name].hasFeature) return;
		return (self[name] = o);
	},
	
	getRules : function(node){
		var rules = {};
		
		for(var w = node.firstChild;w;w=w.nextSibling){
			if(w.nodeType != 1) continue;
			else{
				if(!rules[w[TAGNAME]]) rules[w[TAGNAME]] = [];
				rules[w[TAGNAME]].push(w);
			}
		}
		
		return rules;
	},

	/********* NODE METHODS ***********
		Debug functions
	**********************************/

	warnings : {},
	DEBUG_INFO : "",

	debugMsg : function(msg, type, forceWin){
		if(!DEBUG) return;

		if(DEBUG_FILTER.match(new RegExp("!" + type + "(\||$)", "i"))) return;
		if(DEBUG_TYPE.toLowerCase() == "window" || this.win && !this.win.closed || forceWin){
			this.win = window.open("", "debug");
			if(!this.win){
				if(!this.haspopupkiller) alert("Could not open debug window, please check your popupkiller");
				this.haspopupkiller = true;
			}
			else this.win.document.write(msg);
		}
		
		this.DEBUG_INFO += msg;

		if(this.ondebug) this.ondebug(msg);
	},

	showDebug : function(){
		this.win = window.open("", "debug");
		this.win.document.write(this.DEBUG_INFO);
	},
	
	formErrorString : function(number, control, process, message, jmlContext, outputname, output){
		var str = ["---- Javeline Error ----"];
		if(jmlContext){
			var c = jmlContext.ownerDocument.outerHTML || jmlContext.ownerDocument.xml || "";
			var jmlStr = (jmlContext.outerHTML || jmlContext.xml || jmlContext.serialize()).replace(/\<\?xml\:namespace prefix = j ns = "http\:\/\/www.javeline.net\/j" \/\>/g, "").replace(/xmlns:j="[^"]*"\s*/g, "");
			var linenr = c.substr(0, c.indexOf(jmlStr)).split("\n").length;
			str.push("jml file: [line: " + linenr + "] " + removePathContext(HOST_PATH, jmlContext.ownerDocument.documentElement.getAttribute("filename")));
		}
		if(control) str.push("Control: '" + (control.name||control.jml.getAttribute("id")||"{Anonymous}") + "' [" + control.tagName + "]");
		if(process) str.push("Process: " + process);
		if(message) str.push("Message: [" + number + "] " + message);
		if(outputname) str.push(outputname+ ": " + output);
		if(jmlContext) str.push("\n===\n" + jmlStr);

		return str.join("\n");
	},
	
	//throw new Error(1101, Kernel.formErrorString(1101, this, null, "A dropdown with a bind='' attribute needs a bindclass='' attribute or have <j:Item /> children.", "JML", this.jml.outerHTML));
	

	/********* DRAGMODE ***********
		Drag Mode - Handles Drag&Drop Methods on Body
	*******************************/
	DragMode : {
		modes : {},

		defineMode : function(mode, struct){
			this.modes[mode] = struct;
		},

		setMode : function(mode){
			for(prop in this.modes[mode])
				if(prop.match(/^on/))
					document.body[prop] = this.modes[mode][prop];

			this.mode = mode;
		},

		clear : function(){
			for(prop in this.modes[this.mode])
				if(prop.match(/^on/))
					document.body[prop] = null;
		}
	},

	Plane : {
		init : function(){
			if(!this.plane){
				this.plane = document.createElement("DIV");
				this.plane.style.background = "url(spacer.gif)";
				this.plane.style.position = "absolute";
				this.plane.style.zIndex = 99999;
				this.plane.style.left = 0;
				this.plane.style.top = 0;
			}
		},

		show : function(o){
			this.init();
			
			this.current = o;
			this.lastZ = this.current.style.zIndex;
			this.current.style.zIndex = 100000;

			o.parentNode.appendChild(this.plane);
			var p = document.body == this.plane.parentNode ? document.documentElement : this.plane.parentNode;

			this.plane.style.display = "block";
			this.plane.style.left = p.scrollLeft;
			this.plane.style.top = p.scrollTop;
			
			var diff = Kernel.compat.getDiff(p);
			this.plane.style.width = p.offsetWidth - diff[0];
			this.plane.style.height = p.offsetHeight - diff[1];
			
			return this.plane;
		},

		hide : function(){
			this.plane.style.display = "none";
			this.current.style.zIndex = this.lastZ;
			
			return this.plane;
		}
	},
	
	Popup : {
		cache : {},
		setContent : function(cacheId, content, style, width, height){
			if(!this.popup) this.init();

			this.cache[cacheId] = {
				content : content,
				style : style,
				width : width,
				height : height
			};
			content.style.position = "absolute";
			//if(content.parentNode) content.parentNode.removeChild(content);
			//if(style) Kernel.importCssString(this.popup.document, style);
			
			return content.ownerDocument;
		},
		removeContent : function(cacheId){
			this.cache[cacheId] = null;
			delete this.cache[cacheId];
		},
		init : function(){
			//consider using iframe
			this.popup = {};
		},
		show : function(cacheId, x, y, animate, ref, width, height, callback){
			if(!this.popup) this.init();
			if(this.last != cacheId) this.hide();
			
			var o = this.cache[cacheId];
			//if(this.last != cacheId) 
			//this.popup.document.body.innerHTML = o.content.outerHTML;

			var popup = o.content;
			o.content.onmousedown = function(e){(e||event).cancelBubble = true;}
			o.content.style.zIndex = 10000000;
			//o.content.style.display = "block";
			
			var pos = Kernel.compat.getAbsolutePosition(ref);//[ref.offsetLeft+2,ref.offsetTop+4];//
			var top = y+pos[1];
			var p = Kernel.compat.getOverflowParent(o.content);
			var moveUp = (top + height + y) > p.offsetHeight;
			
			popup.style.top = top + "px";
			popup.style.left = (x+pos[0]) + "px";
			popup.style.width = ((width || o.width)-3) + "px";

			if(animate){
				var iVal, steps = 7, i = 0;
				
				iVal = setInterval(function(){
					var value = ++i*((height || o.height)/steps);
					popup.style.height = value + "px";
					if(moveUp) popup.style.top = (top - value - y) + "px"
					else popup.scrollTop = -1*(i-steps-1)*((height || o.height)/steps);
					popup.style.display = "block";
					if(i > steps){
						clearInterval(iVal)
						callback(popup);
					}
				}, 10);
			}
			else{
				popup.style.height = (height || o.height) + "px"
			}

			this.last = cacheId;
		},
		hide : function(){
			if(this.cache[this.last])
				this.cache[this.last].content.style.display = "none";
			//if(this.popup) this.popup.hide();
		},
		forceHide : function(){
			if(this.last) Kernel.lookup(this.last).dispatchEvent("onpopuphide");
		},
		destroy : function(){
			if(!this.popup) return;
			//this.popup.document.body.c = null;
			//this.popup.document.body.onmouseover = null;
		}
	},
	

	destroy : function(exclude){
		this.Popup.destroy();
		
		for(var i=0;i<this.all.length;i++)
			if(this.all[i] && this.all[i] != exclude && this.all[i].destroy)
				this.all[i].destroy();
		
		document.oncontextmenu = null;
		document.onmousedown = null;
		document.onselectstart = null;
		document.onkeyup = null;
		document.onkeydown = null;
		
		for(var i=0;i<this.availHTTP.length;i++){
			this.availHTTP[i] = null;
		}
	}
};
//try{Kernel.root = !window.opener || !window.opener.Kernel;}
//catch(e){Kernel.root = false}
Kernel.root = true;

Init.run('Kernel');


/********* COOKIE METHODS *********
	Cookie Handling Methods
**********************************/

function setcookie(name, value, expire, path, domain, secure){
	var ck = name + "=" + escape(value) + ";";
	if(expire) ck += "expires=" + new Date(expire + new Date().getTimezoneOffset()*60).toGMTString() + ";";
	if(path) ck += "path=" + path + ";";
	if(domain) ck += "domain=" + domain;
	if(secure) ck += "secure";

	document.cookie = ck;
	return true
}

function getcookie(name){
  var aCookie = document.cookie.split("; ");
  for (var i=0; i < aCookie.length; i++){
	var aCrumb = aCookie[i].split("=");
	if (name == aCrumb[0])
	  return unescape(aCrumb[1]);
  }

  return "";
}

function delcookie(name,domain){
  	document.cookie = name + "=blah; expires=Fri, 31 Dec 1999 23:59:59 GMT;"+domain?'domain='+domain:'';
}


/********* HELPER FUNCTIONS *********
**********************************/


function getXMLValue(xmlNode, xpath){
	if(!xmlNode) return "";
	xmlNode = xmlNode.selectSingleNode(xpath);
	if(xmlNode && xmlNode.nodeType == 1) xmlNode = xmlNode.firstChild;
	return xmlNode ? xmlNode.nodeValue : "";
}


function removeParts(str){
	q = str.replace(/^\s*function\s*\w*\s*\([^\)]*\)\s*\{/, "");
	q = q.replace(/\}\s*$/, "");
	return q;
}

function importClass(ref, strip, win){
	if(!ref) throw new Error(1018, Kernel.formErrorString(1018, null, "importing class", "Could not load reference. Reference is null"));

	if(!IS_IE) return ref();//.call(self);

	if(!strip) return (win.execScript ? win.execScript(ref.toString()) : eval(ref.toString()));
	var q = removeParts(ref.toString());

	//var q = ref.toString().split("\n");q.shift();q.pop();
	//if(!win.execScript) q.shift();q.pop();

	return win.execScript ? win.execScript(q) : eval(q);
}
/*FILEHEAD(/in/Core/TelePort.js)SIZE(7645)TIME(1176705070849)*/
__HTTP_SUCCESS__ = 1;
__HTTP_TIMEOUT__ = 2;
__HTTP_ERROR__ = 3;

__RPC_SUCCESS__ = 1;
__RPC_TIMEOUT__ = 2;
__RPC_ERROR__ = 3;


Kernel.TelePort = {
	modules : new Array(),
	named : {},

	register : function(obj){
		var id = false, data = {
			name : obj.SmartBindingHook[0],
			args : obj.SmartBindingHook[1],
			obj : obj
		};

		this.named[obj.SmartBindingHook[0]] = data;
		return this.modules.push(data) - 1;
	},

	getModules : function(){
		return this.modules;
	},

	getModuleByName : function(defname){
		return this.named[defname]
	},

	hasLoadRule : function(xmlNode){
		for(mod in this.named){
			if(!this.named[mod] || !this.named[mod].args) continue;

			if(xmlNode.getAttribute(this.named[mod].name)){
				this.lastRuleFound = this.named[mod];
				return true;
			}
		}
		
		this.lastRuleFound = {};
		return false;
	},
	
	removeLoadRule : function(xmlNode){
		if(!this.hasLoadRule(xmlNode));
		
		// Could go wrong because one of the two doesn't exist... just a precaution
		try{
			xmlNode.removeAttribute(xmlNode.getAttributeNode(this.lastRuleFound.name));
			xmlNode.removeAttribute(xmlNode.getAttributeNode(this.lastRuleFound.args));
		}catch(e){}
	},

	// Set Communication
	Init : function(){
		this.inited = true;

		var comdef = document.documentElement.getElementsByTagName("head")[0].getElementsByTagName(IS_IE ? "teleport" : "j:teleport")[0];
		if(!comdef && document.documentElement.getElementsByTagNameNS) comdef = document.documentElement.getElementsByTagNameNS("http://javeline.nl/j", "j:teleport")[0];
		if(!comdef){
			this.isInited = true;
			return issueWarning(1006, "Could not find Javeline TelePort Definition")
		}
		if(comdef.getAttribute("src")){
			new HTTP().getXML(HOST_PATH + comdef.getAttribute("src"), function(xmlNode, state, extra){
				if(state != __RPC_SUCCESS__){
					if(extra.retries < MAX_RETRIES) return HTTP.retry(extra.id);
					else throw new Error(1021, Kernel.formErrrorString(1021, null, "Application", "Could not load Javeline TelePort Definition:\n\n" + extra.message));
				}

				Kernel.TelePort.xml = xmlNode;
				Kernel.TelePort.isInited = true;

				//if(self.PACKAGED) Kernel.TelePort.load();
			}, true);
		}
		else{
			var xmlNode = comdef.firstChild ? XMLDatabase.getDataIsland(comdef.firstChild) : null

			Kernel.TelePort.xml = xmlNode;
			Kernel.TelePort.isInited = true;

			//if(self.PACKAGED) Kernel.TelePort.load();
		}
	},

	// Load TelePort Definition
	load : function(xml){
		if(xml) this.xml = xml;
		if(!this.xml) return;

		var nodes = this.xml.childNodes;
		if(!nodes.length) return;

		for(var i=0;i<nodes.length;i++)
			this.initComm(nodes[i]);

		this.loaded = true;
		if(this.onload) this.onload();
	},

	/********* INITCOMM ***********
		Initialize Communication Protocols

		INTERFACE:
		this.initComm(xmlNode);
	****************************/
	initComm : function(x){
		if(x.nodeType != 1) return;

		//Socket Communication
		if(x[TAGNAME] == "Socket"){
			var o = new Socket();
			Kernel.setReference(x.getAttribute("id"), o);
			o.load(x);
		}

		//Polling Engine
		else if(x[TAGNAME] == "Poll")
			Kernel.setReference(x.getAttribute("id"), new Poll().load(x));

		//Initialize Communication Component
		else Kernel.setReference(x.getAttribute("id"), new CommBaseClass(x));
	},

	/********* CALLMETHODFROMNODE ***********
		Call method by the definition in an Xml Node

		INTERFACE:
		this.callMethodFromNode(xmlCommNode, xmlNode, receive, multicall);
	****************************/
	callMethodFromNode : function(xmlCommNode, xmlNode, receive, multicall, userdata, arg){
		var commRule = xmlCommNode.getAttribute(this.lastRuleFound.name);
		if(!commRule){
			if(xmlCommNode.getAttribute("src")){
				var commRule = new HTTP().instantiate(xmlCommNode);
				xmlCommNode.setAttribute("http", commRule);
				xmlCommNode.removeAttributeNode(xmlCommNode.getAttributeNode("src"));
			}
			
			if(!commRule){
				if(!this.hasLoadRule(xmlCommNode)) throw new Error(1022, Kernel.formErrorString(1022, null, "TelePort load from xmlNode", "Could not load method from node :" + (xmlRPCNode ? xmlRPCNode.xml : "")));
				commRule = xmlCommNode.getAttribute(this.lastRuleFound.name);
			}
		}

		var q = commRule.split(";");
		var obj = eval(q[0]);
		var method = q[1];
		if(!arg && this.lastRuleFound.args){
			arg = xmlCommNode.getAttribute(this.lastRuleFound.args);
			arg = arg ? arg.split(";") : [];
		}

		//force multicall if needed;
		if(multicall) obj.force_multicall = true;
		
		//Get values from dynamic args
		if(arg) arg = this.processArguments(arg, xmlNode, xmlCommNode);
		
		//Set information later neeed
		if(userdata) obj[method].userdata = userdata;
		if(!obj.multicall) obj.callbacks[method] = receive; //&& obj[method].async
		
		//Call method
		var data = obj.call(method, arg ? obj.fArgs(arg, obj.names[method], (obj.vartype != "cgi" && obj.vexport == "cgi")) : null);//obj.named ? obj.names[method] : []));

		if(obj.multicall) return obj.purge(receive, "&@^%!@");
		else if(multicall){
			obj.force_multicall = false;
			return obj;
		}

		if(data && !obj.multicall && !obj[method].async) return receive(data);
	},
	
	processArguments : function(arg, xmlNode, xmlCommNode){
		for(var i=0;i<arg.length;i++){
			if(typeof arg[i] == "object") continue;
			
			if(typeof arg[i] == "string"){
				//this could be optimized if needed
				if(arg[i].match(/^xpath\:(.*)$/)){
					var o = xmlNode.selectSingleNode(RegExp.$1);
	
					if(!o) arg[i] = "";
					else if(o.nodeType >= 2 && o.nodeType <= 4) arg[i] = o.nodeValue;
					//else if(o.firstChild) arg[i] = o.firstChild.nodeValue;// && (o.firstChild.nodeType == 3 || o.firstChild.nodeType == 4)
					//else arg[i] = "";
					else arg[i] = o.serialize ? o.serialize() : o.xml;
				}
				else if(arg[i].match(/^method\:(.*)$/)){
					arg[i] = self[RegExp.$1](xmlNode, xmlCommNode);
				}
				else if(arg[i].match(/^eval\:(.*)$/)){
					arg[i] = eval(RegExp.$1);
				}
				else if(arg[i].match(/^\((.*)\)$/)){
					arg[i] = this.processArguments(RegExp.$1.split(","), xmlNode, xmlCommNode);
				}
				else arg[i] = arg[i] || "";
			}
			else arg[i] = arg[i] || "";
		}
		
		return arg;
	}
}

function CommBaseClass(xml){
	this.xml = xml;
	this.uniqueId = Kernel.all.push(this) - 1;
	Kernel.makeClass(this);

	this.toString = function(){
		return "[Javeline TelePort Component : " + (this.name || "") + " (" + this.type + ")]";
	}

	if(this.xml){
		this.name = xml.getAttribute("id");
		this.type = xml[TAGNAME];

		// Inherit from the specified baseclass
		if(!self[this.type]) throw new Error(1023, Kernel.formErrorString(1023, null, "TelePort baseclass", "Could not find Javeline TelePort Component '" + this.type + "'", this.xml));
		this.inherit(self[this.type]);

		if(this.useHTTP){
			// Inherit from HTTP Module
			if(!self.HTTP) throw new Error(1024, Kernel.formErrorString(1024, null, "Teleport baseclass", "Could not find Javeline TelePort HTTP Component", this.xml));
			this.inherit(HTTP);
		}

		if(this.xml.getAttribute("protocol")){
			// Inherit from Module
			if(!self[this.xml.getAttribute("protocol")]) throw new Error(1025, Kernel.formErrorString(1025, null, "Teleport baseclass", "Could not find Javeline TelePort RPC Component '" + this.xml.getAttribute("protocol") + "'", this.xml));
			this.inherit(self[this.xml.getAttribute("protocol")]);
		}
	}

	// Load Comm definition
	if(this.xml) this.load(this.xml);
}


Init.run('TelePort');
/*FILEHEAD(/in/Core/Window.js)SIZE(13734)TIME(1187087508069)*/

_Window = {
	Init : function(){
		if(!Kernel.root){
			//_Window = window.opener._Window;
			
			for(var i=0;i<_Window.forms.length;i++){
				Kernel.setReference(_Window.forms[i].name, _Window.forms[i].win, true);
			}
			
			return;
		}
		
		//document.body.onbeforeunload = function(){_Window.closeAll();}
		this.root_kernel = Kernel;
	},
	
	destroy : function(frm){
		//Remove All Cross Window References Created on Init by _Window
		//for(var i=0;i<this.globals.length;i++) frm.win[this.globals[i]] = null;
	},
	
	root : self,
	userdata : [],
	
	/*********************************************************************
											FORMS
	*********************************************************************/
	forms : new Array(),
	
	addForm : function(xmlFormNode){
		var x = new Form(xmlFormNode);
		this.forms.push(Kernel.setReference(x.name, x, true));
		return x;
	},
	
	getForm : function(value){
		for(var i=0;i<this.forms.length;i++) if(this.forms[i].name == value) return this.forms[i];
		
		return this.forms.length ? this.forms[0] : false;
	},
	
	closeAll : function(){
		for(var i=0;i<this.forms.length;i++) if(this.forms[i].name != "main" && this.forms[i].type != "modal") this.forms[i].hide();
	}
}

/*****************
	FORM CLASS
*****************/

function Form(xmlData){
	this.uniqueId = Kernel.all.push(this) - 1;
	this.tagName = "Form";
	
	this.loaded = false;
	this.loading = false;
	this.win = this.window = null;

	this.jml = xmlData;
	this.name = xmlData.getAttribute("id");
	this.title = xmlData.getAttribute("caption");
	this.icon = xmlData.getAttribute("icon");
	this.type = xmlData.getAttribute("frm-type") || "normal";
	this.singleton = xmlData.getAttribute("singleton") != "false";
	this.code = xmlData.getAttribute("code");
	this.loader = xmlData.getAttribute("loader") != "false";
	
	if(!this.jml.getAttribute("width")) this.jml.setAttribute("width", "400");
	if(!this.jml.getAttribute("height")) this.jml.setAttribute("height", "300");
	if(!this.jml.getAttribute("resizable")) this.jml.setAttribute("resizable", "true");
	
	/************************
			INIT
	************************/
	
	this.getActionTracker = function(){return ActionTracker}
	
	this.show = function(userdata, parentWindow){
		if(!parentWindow) parentWindow = self;
		this.parentWindow = (parentWindow.win ? parentWindow.win : parentWindow);

		if(!this.loaded || !this.singleton || this.type == "modal"){
			var rv = this.init(null, userdata);
			if(!rv) return false;
			if(this.type == "modal") return rv;
		}
		
		if(this.win && !this.win.closed){
			this.win.focus();
			if(this.win.loadUserData) this.win.loadUserData(userdata);
		}
		else{
			//caching entire window???? 
			//what about references???
			this.init(null, userdata);
		}
		
		return this.win;
	}
	
	this.openWindow = function(userdata){
		//Open Window and Initialize it. ([LATER] one might also create an Iframe and treat it as a window)
		//http://www.mozilla.org/docs/dom/domref/dom_window_ref76.html

		//(DEBUG ? "" : "left=2000,top=2000,") + 
		if(this.type == "normal")
			return window.open("",new Date().getTime(),"width=" + this.jml.getAttribute("width") + ",height=" + this.jml.getAttribute("height") + ", " + (DEBUG ? "status=yes," : "") + (!this.jml.getAttribute("resizable").match(/^(no|false|off)$/) ? "resizable" : ""))
		else if(this.type == "modal")
			return (this.parentWindow || window).showModalDialog(this.name + ".html", [window, this, userdata, this.title, this.code], "dialogWidth:" + (parseInt(this.jml.getAttribute("width"))+10) + "px;dialogHeight:" + (parseInt(this.jml.getAttribute("height"))+30) + "px,edge:raised;resizable:" + (this.jml.getAttribute("resizable") && this.jml.getAttribute("resizable").match(/^(no|false|off)$/) ? "no" : "yes") + ";status:" + (DEBUG ? "yes" : "no") + ";scroll:no;center:yes;help:no");
		else if(this.type == "modeless")
			return (this.parentWindow || window).showModelessDialog("blah", window, "dialogWidth:" + (parseInt(this.jml.getAttribute("width"))+10) + "px;dialogHeight:" + (parseInt(this.jml.getAttribute("height"))+30) + "px,edge:raised;resizable:" + (this.jml.getAttribute("resizable") != "no" ? "yes" : "no") + ";status:" + (DEBUG ? "yes" : "no") + ";scroll:no;center:yes;help:no");
	}
	
	this.importModal = function(win){
		this.win = this.window = win;
		this.document = this.win.document;
		this.document.title = this.title;
		
		//window[this.name] = this.win;
		this.win.userdata = this.win.dialogArguments[2];
		//this.win.me = this;
		this.initWindow();
	}
	
	this.init = function(isMain, userdata){
		if(this.loading) return;
		this.loading = true;
		this.loaded = false;
		
		//Add global name of window somewhere here??? or is it already set... ?
		
		if(isMain){
			this.win = this.window = self;
			this.document = document;
			self.main = this;
		}
		else{
			if(this.type == "modal") return this.openWindow(userdata);
			this.window = this.win = this.openWindow();
			
			//Popup killer
			if(!this.win || !this.win.document){
				if(_Window.onpopupkiller) _Window.onpopupkiller();
				return false;
			}
		
			this.document = this.win.document;
			
			this.document.open();
			this.document.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n" + ORIGINALHTML + (userdata ? "<body></body><script>" + 'userdata = window.opener._Window.userdata[' + (_Window.userdata.push(userdata)-1) + "]</script>" : ""));//this.parentWindow.
			this.document.close();
			
			this.win.windowName = this.name;
			
			this.loaded = true;
			this.loading = false;
			
			return true;
		}
		
		this.initWindow(isMain);
	}

	this.initWindow = function(isMain){
		if(this.loaded) return;
		this.loaded = true;
		this.loading = false;
		
		//[LATER] Show Loading Message
		//LoadMessage();...
		this.win.focus();

		//Set up Global Variables
		//if(!isMain) _Window.loadGlobals(this);
		
		//Inherit Local Form
		//this.inherit(this.win.LocalForm);

		if(isMain){
			me = new LocalForm();
			me.loadForm(isMain, this);
		}
	}
}

function LocalForm(){
	Kernel.register(this, "LocalForm", NOGUI_NODE);
	this.Kernel = Kernel;
	this.splitters = [];
	
	this.toString = function(){
		return "[Javeline Component : " + (this.name || "") + " (LocalForm)]";
	}
	
	this.getActionTracker = function(){return ActionTracker}
	
	this.destroy = function(){
		ActionTracker = this.ActionTracker = null;
		
		if(self.XMLDatabase){
			XMLDatabase.unbind(this);
			XMLDatabase = null;
		}
		if(self.Kernel){
			Kernel.destroy(this);
			Kernel = null;
		}
		
		_Window.destroy(this);
		_Window = null;
		
		this.win = this.window = this.document = null;
		
		window.onfocus = null;
		window.onerror = null;
		window.onunload = null;
		window.onbeforeunload = null;
		window.onblur = null;
		
		document.body.innerHTML = "";
	}
	
	this.loadForm = function(isMain, frm){
		//Copy Properties
		this.document = frm.document;
		this.win = this.window = frm.win;
		this.parentWindow = frm.parentWindow;
		
		this.jml = (frm.name == "main") ? frm.jml : frm.jml.cloneNode(true);
		this.name = frm.name;
		this.title = frm.title;
		this.icon = frm.icon;
		this.type = frm.type;
		this.code = frm.code;
		this.mode = frm.mode;
		this.modeChoice = frm.modeChoice;
		
		//Set up window
		//if(!this.title) this.title = "Javeline Framework Application";
		//this.setTitle(this.title);
		
		this.setIcon(this.icon ? this.icon : 100);

		//this.document.onmousedown = function(e){return false}
		//this.document.onmouseup = function(){return true}

		window.onbeforeunload = function(){
			var returnValue;
			if(HAS_DESKRUN) 
				window.external.shell.RegSet(Application.drRegName + "/window",window.external.left + "," + window.external.top + "," + window.external.width + "," + window.external.height);
			
			if(me.onexit) returnValue = me.onexit();
			if(me.isActive()) Kernel.getRoot().activeWindow = null;
			
			return returnValue;
		}
		if(HAS_DESKRUN) window.external.onbeforeunload = window.onbeforeunload;
		
		window.onunload = function(){
			me.isExiting = true;
			me.destroy();
			
			//if(HAS_DESKRUN)
				//window.external.shell.RegSet(Application.drRegName + "/window",window.external.left + "," + window.external.top + "," + window.external.width + "," + window.external.height);
		}
		
		window.onfocus = function(){
			/*var k = Kernel.getRoot();
			//if(k.wtimer) clearTimeout(k.wtimer);
			k.activeWindow = self;*/
			
			if(me.onfocus) me.onfocus();
		}
		
		window.onblur = function(){
			//if(document.activeElement != document.body)
				//Kernel.getRoot().wtimer = setTimeout("Kernel.getRoot().activeWindow = null;", 100);
			
			if(me.onblur) me.onblur();
		}
		
		//Set Main ActionTracker
		ActionTracker = this.__ActionTracker = new _ActionTracker();
		
		//Load Form Contents
		if(self.main){
			Application.loadSubNode(this.jml, this.document.body);//, this);
			
			//Set location based on state http://url#state
			var loc = location.href.split("?")[0].split("#")[1];
			if(loc && StateServer.locs[loc])
				StateServer.locs[loc].activate();
			
			LayoutServer.activateRules();
		}

		if(Kernel.all.length < 2){
			throw new Error(1026, Kernel.formErrorString(1026, null, "Initialization", "No user interface element found. Please check your JML document."))
		}

		//Hide Loader...
		if(this.document.getElementById("hider"))
			this.document.getElementById("hider").style.display = "none";

		//if(!isMain){
			//Set Position
			//this.window.moveTo((screen.width-document.body.offsetWidth)/2, (screen.height-document.body.offsetHeight)/2);
		//}
		
		//Init Databinding - timeout ivm. draw
		if(this.name == "main") setTimeout('Application.processDatabinding();', 1);

		if(this.type != "modal" && this.code) this.loadCodeFile(this.code);
	}
	
	/************************
			API
	************************/
	
	this.loadCodeFile = function(url){
		
		//if(IS_SAFARI) return;
		if(this.win[url]) importClass(this.win[url], true, this.win);
		else include(url);//, this.document);
		
	}

	/*
	this.loadCodeFile = function(url){
		include(url, this.document);
	}*/
	
	this.flash = function(){
		if(this.useDeskRun){
			this.deskrun.Flash();
		}
	}
	
	this.show = function(){
		if(this.useDeskRun){
			this.deskrun.Show();
		}
	}
	
	this.hide = function(){
		if(this.useDeskRun){
			this.deskrun.Hide();
		}
		else{
			this.loaded = false;
			if(this.win) this.win.close();
		}
	}
	
	this.focus = function(){
		if(this.useDeskRun){
			this.deskrun.SetFocus();
		}
		else{
			this.win.focus();
		}
	}
	
	this.isActive = function(){
		var root = Kernel.getRoot();
		return (root ? root.activeWindow == self : false);
	}
	
	this.setIcon = function(url){
		if(this.useDeskRun){
			this.deskrun.icon = parseInt(url) == url ? parseInt(url) : url;
		}
	}
	
	this.setTitle = function(value){
		this.title = value || "";
		
		if(this.useDeskRun){
			this.deskrun.caption = value;
		}
		else{
			if(this.win && this.win.document) this.win.document.title = (value || "");
		}
	},
	
	/********* FOCUS METHODS *********
		Methods handling focus in
		the form object.
	*********************************/
	this.__f = Array();
	
	this.__focus = function(o, norun){
		//CHANGE THIS FUNCTION TO DETECT IF OBJECT IS VISIBLE
		if(this.__fObject == o) return;
		if(this.__fObject) this.__fObject.blur(true);
		//if(this.__fObject) this.__fObject.oExt.style.border = "2px solid black";
		(this.__fObject = o).focus(true);
		//if(o.oExt) o.oExt.style.border = "2px solid red";

		if(this.onmovefocus) this.onmovefocus(this.__fObject);
	}
	
	this.__blur = function(o){
		//NOT A GOOD SOLUTION
		if(this.__fObject == o) this.__fObject = null;
		if(this.onmovefocus) this.onmovefocus(this.__fObject);
	}
	
	this.isFocussed = function(o){return this.__fObject == o;}
	this.getFocussedObject = function(){return this.__fObject;}
	
	this.__removeFocus = function(o){
		this.__f[o.tabIndex] = null;
		delete this.__f[o.tabIndex];
	}
	
	this.__addFocus = function(o, tabIndex){
		if(o.__FID == null) o.__FID = tabIndex !== null ? tabIndex : this.__f.length;
		
		var cComp = this.__f[o.__FID];
		if(cComp && cComp.jml && !cComp.jml.getAttribute("tabseq")){
			//cComp.setTabIndex(this.__f.length);
			this.__f[o.__FID] = null;
			cComp.__FID = this.__f.push(cComp) - 1;
			
		}
		
		if(this.__f[o.__FID] && this.__f[o.__FID] != o) throw new Error(1027, Kernel.formErrorString(1027, null, "Tab switching", "TabIndex Already in use: '" + o.__FID + "' for " + o.toString() + ".\n It's in use by " + cComp.toString()));
		
		this.__f[o.__FID] = o;
		o.tabIndex = tabIndex;
	}
	
	this.moveNext = function(shiftKey){
		var next = null, o = me.__fObject, start = o ? o.__FID : me.__f.length;

		if(me.__f.length < 2) return;
		
		do{
			next = (o ? parseInt(o.__FID) + (shiftKey ? -1 : 1) : (next != null ? next + (shiftKey ? -1 : 1) : 0));
			
			if(start == next) return; //No visible enabled element was found
			
			if(next >= me.__f.length) next = 0;
			else if(next < 0) next = me.__f.length-1;
			
			o = me.__f[next];
			
		}while(!o || o.disabled || o == me.__fObject || (o.oExt && !o.oExt.offsetHeight) || !o.focussable);
		
		me.__focus(o);
	}
}


/*FILEHEAD(/in/Core/Node.js)SIZE(16617)TIME(1188383718500)*/
__JMLNODE__ = 1<<15;
__VALIDATION__ = 1<<6;


function JmlNode(){
	this.toString = function(){
		return "[Javeline Component : " + (this.name || "") + " (" + this.tagName + ")]";
	}
	
	this.__regbase = this.__regbase|__JMLNODE__;
	
	/************************
		BASIC METHODS
	************************/
	
	this.setWidth = function(value, diff){this.oExt.style.width = Math.max(0, (value - (!diff && diff!==0 ? Kernel.compat.getWidthDiff(this.oExt) : diff))) + "px";}
	this.setHeight = function(value, diff){ this.oExt.style.height = Math.max(0, (value - (!diff && diff!==0 ? Kernel.compat.getHeightDiff(this.oExt) : diff))) + "px";}
	this.setLeft = function(value){this.oExt.style.position = "absolute";this.oExt.style.left = value + "px"}
	this.setTop = function(value){this.oExt.style.position = "absolute";this.oExt.style.top = value + "px"}
	
	this.setZIndex = function(value){this.setProperty("zindex", value);}
	this.enable = function(){this.setProperty("disabled", false);}
	this.disable = function(){this.setProperty("disabled", true);}

	var noAlignUpdate = false;
	if(!this.show) this.show = function(s){noAlignUpdate = s;this.setProperty("visible", true);noAlignUpdate = false;};
	if(!this.hide) this.hide = function(s){noAlignUpdate = s;this.setProperty("visible", false);noAlignUpdate = false;};
	
	this.getWidth = function(){return this.oExt ? this.oExt.offsetWidth : null}
	this.getHeight = function(){return this.oExt ? this.oExt.offsetHeight : null}
	this.getLeft = function(){return this.oExt ? this.oExt.offsetLeft : null}
	this.getTop = function(){return this.oExt ? this.oExt.offsetTop : null}
	this.getZIndex = function(){return this.oExt ? Kernel.compat.getStyle(this.oExt, "zIndex") : null}
	
	this.isVisible = function(value){return this.oExt ? this.oExt.style.display != "none" : null;}
	
	/************************
		JML
	************************/
	this.loadJML = function(x, pJmlNode, ignoreBindclass, id){
		this.name = x.getAttribute("id");
		
		if(x){
			if(!this.parentNode) this.parentNode = pJmlNode;
			
			this.jml = x;
		}
		else x = this.jml;
		
		var attr = x.attributes;
		for(var i=0;i<attr.length;i++){
			if(attr[i].nodeName.substr(0,2) == "on") this.addEventListener(attr[i].nodeName, new Function(attr[i].nodeValue));
		}
		
		//Drawing
		if(this.nodeType != NOGUI_NODE){
			this.inherit(JmlDomAPI);
			
			
			this.inherit(MultiLang);
			
			if(this.loadSkin) this.loadSkin();
			
			//Draw
			this.draw();
			
			if(id) this.oExt.setAttribute("id", id);
			this.__initLayout(x);
			
			this.drawed = true;
			this.dispatchEvent("ondraw");
		}
		
		if(this.nodeType == GUI_NODE){
			if(self.DEBUG && !HAS_DESKRUN && !HAS_WEBRUN) this.oExt.setAttribute("uniqueId", this.uniqueId);
		}
		
		//Load subJML
		if(Kernel.TelePort.hasLoadRule(x))// || x.getAttribute("src")) - Find a better solution for this (hack/should)
			this.insertJML(x);

		if(!ignoreBindclass){
			if(!this.hasFeature(__DATABINDING__) && x.getAttribute("smartbinding")){
				this.inherit(DataBinding);
				this.__xmlUpdate = this.__load = function(){}
			}
		}
		
		/*************************
			Read JML and set a collection of commonly used settings
		*************************/
		
		if(x.getAttribute("actiontracker")){
			if(x.getAttribute("actiontracker") == "new")
				this.__ActionTracker = new _ActionTracker(this);
			else if(self[x.getAttribute("actiontracker")])
				this.__ActionTracker = Application.getActionTracker(x.getAttribute("actiontracker"));
		}

		// Widget specific
		if(this.__loadJML) this.__loadJML(x);
		
		this.dispatchEvent("onloadjml"); //Stupid IE crashes silently when this is put at the end of the function
		
		//Process JML Handlers
		for(var i=this.__jmlLoaders.length-1;i>=0;i--)
			this.__jmlLoaders[i].call(this, x);
		//this.__jmlLoaders = undefined; // Why was this here?
		
		//if(this.nodeType == NOGUI_NODE) return; //Dynamic properties shouldnt be added for nongui nodes.
		
		//Dynamic Properties
		if(!this.__supportedProperties) this.__supportedProperties = [];
		if(this.nodeType != NOGUI_NODE){
			//Default Dynamic Properties for NONGUI NODES
			this.__supportedProperties.push("focussable", "zindex", "visible", "disabled", "disable-keyboard");
			if(this.visible === null) this.visible = true; //default value;
		}
		
		for(var i=this.__supportedProperties.length-1;i>=0;--i){
			var pValue = x.getAttribute(this.__supportedProperties[i]);
			if(!pValue) continue;
			
			Application.stateStack.push([this, this.__supportedProperties[i], pValue]);
		}
		
		//Set focussable if needed
		if(this.focussable) this.handlePropSet("focussable", true);
	}
	
	this.handlePropSet = function(prop, value, force){
		if(!force && this.XMLRoot && this.bindingRules && this.bindingRules[prop.uCaseFirst()])
			return XMLDatabase.setNodeValue(this.getNodeFromRule(prop.uCaseFirst(), this.XMLRoot, null, null, true), value, true);
		
		this[prop] = value;
		
		/***** TODO:
		- Fix width/height/left/top/right/bottom with integration in anchoring en alignment
		**********/

		// this code sufferes from a little overhead from unrequired execution at init
		switch(prop){
			case "focussable":
				this.focussable = !isFalse(value);
				if(this.focussable) me.__addFocus(this, this.tabIndex || this.jml.getAttribute("tabseq"));
				else me.__removeFocus(this);
			break;
			case "zindex":
				this.oExt.style.zIndex = value;
			break;
			case "visible":
				if(isFalse(value)){
					this.oExt.style.display = "none";
			
					if(!noAlignUpdate && this.hasFeature(__ALIGNMENT__)){
						this.disableAlignment();
						//this.purgeAlignment();
						//setTimeout("window.onresize();"); //doesnt work always.. this should be optimized in Layout
						var jmlNode = this;
						LayoutServer.activateRules(this.pHtmlNode);
						//setTimeout(function(){LayoutServer.activateRules(jmlNode.pHtmlNode);})// same
					}
					
					if(me.isFocussed(this)) me.moveNext();
					
					if(!noAlignUpdate && this.hasFeature(__ANCHORING__)) this.disableAnchoring(Application.loaded);
				}
				else{
					this.oExt.style.display = "";
			
					if(!noAlignUpdate && this.hasFeature(__ANCHORING__)) this.enableAnchoring(Application.loaded);
					
					if(!noAlignUpdate && this.hasFeature(__ALIGNMENT__)){
						this.enableAlignment();
						//this.purgeAlignment();
						//setTimeout("window.onresize();"); //doesnt work always.. this should be optimized in Layout
						var jmlNode = this;
						LayoutServer.activateRules(this.pHtmlNode);
						//setTimeout(function(){LayoutServer.activateRules(jmlNode.pHtmlNode);})// same
					}
					
					/*if(this.jml.getAttribute("render-status") == "withheld"){
						this.loadJML(this.jml);
						this.jml.setAttribute("render-status", "rendered");
					}*/
				}
			break;
			case "disabled":
				if(isTrue(value)){
					this.disabled = false;
					if(this.hasFeature(__PRESENTATION__)) 
						this.__setStyleClass(this.oExt, this.baseCSSname + "Disabled");
					
					if(this.__disable) this.__disable();
					this.disabled = true;
				}
				else{
					if(this.hasFeature(__DATABINDING__) && Application.autoDisable & !this.isBoundComplete()) return false;
					this.disabled = false;
					
					if(this.hasFeature(__PRESENTATION__))
						this.__setStyleClass(this.oExt, null, [this.baseCSSname + "Disabled"]);
					
					if(this.__enable) this.__enable();
				}
			break;
			case "disable-keyboard":
				this.disableKeyboard = isTrue(value);
			break;
			case "width":
				this.setWidth(value);
			break;
			case "height":
				this.setHeight(value);
			break;
		}
		
		if(this.__handlePropSet){
			this.__handlePropSet(prop, value)
		}
	}
	
	this.__insertJML = function(xmlRPCNode, oInt, oIntJML, isHidden){
		setStatus("Loading sub jml from external source");
		
		var jmlNode = this;
		Kernel.TelePort.callMethodFromNode(xmlRPCNode, null, function(data, state, extra){
			if(state != __HTTP_SUCCESS__){
				if(state == __HTTP_TIMEOUT__ && extra.retries < MAX_JAV_RETRIES) return extra.tpModule.retry(extra.id);
				else throw new Error(1019, Kernel.formErrorString(1019, jmlNode, "Loading extra jml from datasource", "Could not load JML from remote resource \n\n" + extra.message));
			}
			
			jmlNode.insertJML(data, oIntJML, oInt, isHidden);
		});
	}
	
	this.insertJML = function(data, oIntJML, oInt, isHidden){
		setStatus("Runtime inserting jml");

		// Clean JML
		Kernel.TelePort.removeLoadRule(JML);
		
		var JML = oIntJML || this.jml;
		/*
			This only works when Application was found inside the 
			html tag (instead of in a seperate file). Add conditional
			to use xmlImport
		*/
		JML.insertAdjacentHTML(JML.getAttribute("insert") || "beforeend", data.length ? data[0] : data);
		Application.loadSubNode(JML, oInt || this.oInt, null, null, isHidden && (oInt || this.oInt).style.offsetHeight ? true : false);

		if(data.length && JML.getAttribute("load-data")){
			var objLD = self[JML.getAttribute("load-data")];
			
			if(!objLD) throw new Error(1020, Kernel.formErrorString(1020, this, "Inserting new jml", "Could not find load-data object '" + JML.getAttribute("load-data") + "' for " + this.tagName + " component with the name : '" + this.name + "'"));
			
			objLD.load(data[1]);
		}
		
		Application.processDatabinding();
	}
	
	this.setTabIndex = function(tabIndex){
		me.__removeFocus(this);
		me.__addFocus(this, tabIndex);
	}
	
	//Alignment
	this.__initLayout = function(x){
		if(this.nodeType != GUI_NODE) return;
		
		//Alignment activation function
		if(!this.enableAlignment){
			this.enableAlignment = function(){
				this.inherit(Alignment);
				this.enableAlignment();
			}
		}
		
		//Anchoring activation function
		if(!this.enableAnchoring){
			this.enableAnchoring = function(){
				this.inherit(Anchoring);
				this.enableAnchoring();
			}
		}

		if(x.getAttribute("align") || x.getAttribute("align-position")){
			this.inherit(Alignment);
			this.enableAlignment();
		}
		else
		
		if(x.getAttribute("right") || x.getAttribute("bottom") || x.getAttribute("anchoring") == "true"){
			if(!this.hasFeature(__ANCHORING__)) this.inherit(Anchoring);
			this.enableAnchoring();
		}
		else
		{
			var diff = Kernel.compat.getDiff(this.oExt);
			
			if(x.getAttribute("left")) this.setLeft(x.getAttribute("left"));
			if(x.getAttribute("top")) this.setTop(x.getAttribute("top"));
			if(x.getAttribute("width")) this.setWidth(x.getAttribute("width"), diff[0]);
			if(x.getAttribute("height")) this.setHeight(x.getAttribute("height"), diff[1]);
		}
	}
	
	/************************
		FOCUS
	************************/
	
	if(this.focussable){
		this.focus = function(noset){
			this.__focus(this);
			if(!noset) me.__focus(this);
			
			this.dispatchEvent("onfocus");
		}
		
		this.blur = function(noset){
			this.__blur(this);
			if(!noset) me.__blur(this);
			
			this.dispatchEvent("onblur");
		}
		
		this.isFocussed = function(){
			return me.isFocussed(this);
		}
	}
	else this.focussable = false;

	if(this.hasFeature(__DATABINDING__) && !this.hasFeature(__MULTISELECT__) && !this.Change){
		/************************
				Change Action
		************************/
		this.Change = function(value){
			
			if(!this.errBox && this.form) this.errBox = this.form.getErrorBox(this.name);
			if(this.errBox && this.errBox.isVisible() && this.isValid()){
				this.clearError();
				if(this.validgroup && this.errBox.host == this) this.errBox.hide();
			}
			
			var node = this.getNodeFromRule(this.mainBind, this.XMLRoot, null, null, true);
			if(!node){
				if(this.dispatchEvent("onbeforechange", value) === false) return;
				this.setProperty("value", value);
				return this.dispatchEvent("onafterchange", value);
			}
			
			if(XMLDatabase.getNodeValue(node) == value) return;
			
			var atAction = node.nodeType == 1 || node.nodeType == 3 || node.nodeType == 4 ? "setTextNode" : "setAttribute";
			var args = node.nodeType == 1 ? [node, value] : (node.nodeType == 3 || node.nodeType == 4 ? [node.parentNode, value] : [node.ownerElement || node.selectSingleNode(".."), node.nodeName, value]);
	
			//Use Action Tracker
			this.executeAction(atAction, args, "Change", this.XMLRoot);
		}	
	}
	
	//this.getNodeFromRule = function(){return false}
	if(this.setValue && !this.clear) this.clear = function(nomsg){
		if(this.__setClearMessage){
			if(!nomsg) this.__setClearMessage(this.msg);
			else if(this.__removeClearMessage) this.__removeClearMessage();
		}
		
		//this.setValue("")
		this.value = -99999; //force resetting
		this.__handlePropSet ? this.__handlePropSet("value", "") : this.setValue("");
	}
}

/******************************
	KEYBOARD & FOCUS HANDLING
******************************/

document.oncontextmenu = function(){
	//search host and call event
}

document.onmousedown = function(e){
	if(!e) e = event;
	var o = Kernel.findHost(IS_IE ? e.srcElement : e.target);
	if(self.me && me.__f.contains(o)&& !o.disabled && o.focussable) me.__focus(o);
	else if(self.me && me.__fObject){
		//Especially for focussing elements
		me.__fObject.blur(true);
		//me.__fObject.focus(true);
		me.__fObject = null;
	}
	
	//Hide current menu
	if(self.currentMenu) currentMenu.hideMenu(true)
	
	if(self.Application && !self.Application.allowSelect) //Non IE
		return false
}

document.onselectstart = function(){
	if(self.Application && !self.Application.allowSelect) //IE
		return false
}

document.onkeyup = function(e){
	if(!e) e = event;
	
	//KEYBOARD FORWARDING TO FOCUSSED OBJECT
	if(self.me && me.__fObject && !me.__fObject.disableKeyboard && me.__fObject.keyUpHandler && me.__fObject.keyUpHandler(e.keyCode, e.ctrlKey, e.shiftKey, e.altkey, e) == false){
		return false;
	}
}



document.onkeydown = function(e){
	if(!e) e = event;

	
	if(Application.disableF5 && e.keyCode == 116){
		e.keyCode = 0;
		return false;
	}
	
	if(self.currentMenu && e.keyCode == "27") 
		currentMenu.hideMenu(true);


	//HOTKEY
	if(Kernel.onhotkey && Kernel.onhotkey(e.keyCode, e.ctrlKey, e.shiftKey, e.altKey, e) == false){
		e.returnValue = false;e.cancelBubble = true; if(IS_IE) e.keyCode = 0;
		return false;
	}
	
	//HOTKEY QUICKFIX.. please fix using addeventlistener
	if(Kernel.ondebugkey && Kernel.ondebugkey(e.keyCode, e.ctrlKey, e.shiftKey, e.altKey, e) == false){
		e.returnValue = false;e.cancelBubble = true; if(IS_IE) try{e.keyCode = 0;}catch(e){}
		return false;
	}
	
	
	if(!self.me) return false;
	
	//DRAG & DROP
	if(me.dragging && e.keyCode == 27){
		if(document.body.lastHost && document.body.lastHost.dragOut) document.body.lastHost.dragOut(Kernel.dragHost); 
		return DragServer.stopdrag();
	}
	
	//KEYBOARD FORWARDING TO FOCUSSED OBJECT
	if(self.me && me.__fObject && !me.__fObject.disableKeyboard && me.__fObject.keyHandler && me.__fObject.keyHandler(e.keyCode, e.ctrlKey, e.shiftKey, e.altkey, e) == false){
		e.returnValue = false;e.cancelBubble = true; try{if(IS_IE)e.keyCode = 0;}catch(e){}
		return false;
	}
	
	//FOCUS HANDLING
	else if(e.keyCode == 9 && me.__f.length > 1){
		me.moveNext(e.shiftKey);
		e.returnValue = false;
		return false;
	}
	
	if(e.keyCode == 27){ //or up down right left pageup pagedown home end unless body is selected
		return false;
	}
	
}

/*FILEHEAD(/in/Core/Application.js)SIZE(24115)TIME(1188383718500)*/

Application = {
	xml : null,
	xmlForms : null,
	
	sbInit : {},
	r : [],
	
	stateStack : [],

	/********* INIT ***********
		Initialize Application
	
		INTERFACE:
		this.Init();
	****************************/
	Init : function(jml){
		setStatus("Start parsing main application");
		Profiler.start();
		this.xml = jml;
		
		if(!this.xml) return;
		
		if(!this.xml.childNodes.length) throw new Error(1014, Kernel.formErrorString(1014, null, "Application", "Init\nMessage : Got invalid JML"));
		
		//THIS NEED OPTIMIZATION
		this.preLoadNonRef(jml);
		for(var i=0;i<IncludeStack.length;i++) if(IncludeStack[i].nodeType) this.preLoadNonRef(IncludeStack[i]);
		this.preLoadRef(jml);
		for(var i=0;i<IncludeStack.length;i++) if(IncludeStack[i].nodeType) this.preLoadRef(IncludeStack[i]);


		//Init Forms
		var forms = $("window", this.xml, "j", IS_IE && this.xml.xml);
		if(forms) for(var i=0;i<forms.length;i++) if(forms[i].nodeType == 1) _Window.addForm(forms[i]);
		
		//_Window.Init();
		var winName = !Kernel.root ? self.windowName || "main" : "main";
		var mainWin = _Window.getForm(winName);
		
		if(!mainWin)
			throw new Error(1015, Kernel.formErrorString(1015, null, "Application init", "Missing window description. Please check your JML.", jml))

		mainWin.init(true);
		//throw new Error(0, "DEBUG");
		
		LayoutServer.activateGrid();
		
		//Settings hack to force it to set defaults
		if(!this.foundSettings) this.handler.settings(mainWin.jml);
		
		
		if(this.oninit) this.oninit();
		this.inited = true;
		
		//Profiler.end();
		//setStatus("[TIME] Total load time: " + Profiler.totalTime + "ms");
		//Profiler.start(true);
	},
	
	preLoadNonRef : function(xmlNode){
		//BUG: IE document handling bugs
		if(IS_IE){
			if(xmlNode.style) return;
			xmlNode.ownerDocument.setProperty("SelectionNamespaces", "xmlns:j='http://www.javeline.net/j'");
		}
		
		setStatus("Preloading Non Referencing nodes...");
		
		//Hack to support non NS defined documents - there must be a better way
		try{
			var nodes = XMLDatabase.selectNodes("//teleport|//j:teleport|//presentation|//j:presentation|//settings|//j:settings|//skin|//j:skin|//bindings[@id]|//actions[@id]|//dragdrop[@id]|//j:bindings[@id]|//j:actions[@id]|//j:dragdrop[@id]", xmlNode);
		}
		catch(e){
			var nodes = xmlNode.selectNodes("//teleport|//presentation|//settings|//skin|//bindings[@id]|//actions[@id]|//dragdrop[@id]");
		}

		this.preLoadNodes(nodes);
	},
	
	preLoadRef : function(xmlNode){
		setStatus("Preloading Referencing nodes...");
		
		//Hack to support non NS defined documents - there must be a better way
		try{
			var nodes = XMLDatabase.selectNodes("//style|//j:style|//model[@id]|//smartbinding[@id]|//j:smartbinding[@id]|//j:model[@id]", xmlNode);
		}
		catch(e){
			var nodes = xmlNode.selectNodes("//style|//model[@id]");
		}
		
		this.preLoadNodes(nodes);
	},
	
	preLoadNodes : function(nodes){
		//for(var i=nodes.length-1;i>=0;i--){
		for(var i=0;i<nodes.length;i++){

			if(this.handler[nodes[i][TAGNAME]]){
				setStatus("Processing [preload] '" + nodes[i][TAGNAME] + "' node");
				
				this.handler[nodes[i][TAGNAME]](nodes[i]);
			}
				
			if(nodes[i][TAGNAME] != "presentation" && nodes[i].parentNode)
				nodes[i].parentNode.removeChild(nodes[i]);
		}
	},

	loadIncludeFile : function(filename){
		//loadJMLInclude(null, new Http(), false, getAbsolutePath(HOST_PATH, filename));
	},
	

	/********* LOADSUBNODE ***********
		Load Sub Nodes of Parent JML Node
	
		INTERFACE:
		this.loadSubNode(x, pnode, win, frm);
	****************************/
	loadSubNode : function(x, pHtmlNode, jmlParent, checkRender, noImpliedParent){
		//setStatus("Parsing children of node '" + x.tagName + "'");
		if(!Profiler.isStarted) Profiler.start();
		
		//if(!pHtmlNode) pHtmlNode = document.body;
		
		// Check for delayed rendering flag
		if(checkRender && jmlParent.hasFeature(__DELAYEDRENDER__) && jmlParent.__checkDelay(x)){
			setStatus("Delaying rendering of children");
			
			return pHtmlNode;
		}
		if(jmlParent) jmlParent.isRendered = true;

		// Dynamicaly load JML
		if(Kernel.TelePort.hasLoadRule(x) || x.getAttribute("url"))
			return jmlParent.insertJML(x, pHtmlNode, x, true);
		
		//Loop through Nodes
		for(var oCount=0,i=0;i<x.childNodes.length;i++){
			var q = x.childNodes[i];
			if(q.nodeType == 8) continue;

			// Text nodes and comments
			if(q.nodeType != 1){
				if(!pHtmlNode) continue;
				
				if(q.nodeType == 3 || pHtmlNode.style && q.nodeType == 4)
					pHtmlNode.appendChild(pHtmlNode.ownerDocument.createTextNode(q.nodeValue));
				else if(q.nodeType == 4)
					pHtmlNode.appendChild(pHtmlNode.ownerDocument.createCDataSection(q.nodeValue));
				//pHtmlNode.appendChild(q);
				//XMLDatabase.htmlImport(q, pHtmlNode); 
				
				KeywordServer.addElement(q.nodeValue.replace(/^\$(.*)\$$/, "$1"), {htmlNode : pHtmlNode});
				continue;
			}
			
			var tagName = q.tagName.replace(/^j\:/, "");

			// Includes
			if(tagName == "include"){
				setStatus("Switching to include context");
				
				var xmlNode = IncludeStack[q.getAttribute("iid")];
				if(!xmlNode) return issueWarning(0, "No include file found");
				
				this.loadSubNode(xmlNode, pHtmlNode, jmlParent, null, true);
			}

			// Handler
			else if(this.handler[tagName]){
				setStatus("Processing '" + tagName + "' node");
				
				this.handler[tagName](q, noImpliedParent ? null : jmlParent);
			}
			
			//Javeline or HTML Object
			else if(pHtmlNode){
				var o = this.createElement(q, pHtmlNode, jmlParent);
			}
		}
		
		if(pHtmlNode){
			// Grid layout support
			var gridCols = x.getAttribute("grid");
			if(gridCols) LayoutServer.addGrid("var o = Kernel.lookup(" + jmlParent.uniqueId + ");if(o.oExt.offsetHeight) Kernel.compat.gridPlace(o)", pHtmlNode);
	
			//Calculate Alignment and Anchoring
			LayoutServer.compile(pHtmlNode);
			
			//LayoutServer.activateRules(pHtmlNode);
		}
		
		return pHtmlNode;
	},
	
	
	handler : {
		"script" : function(q){
			//if(IS_SAFARI) return;
			if(q.getAttribute("src")){
				//temp solution
				if(IS_OPERA) setTimeout(function(){me.loadCodeFile(HOST_PATH + q.getAttribute("src"));},1000);
				else me.loadCodeFile(HOST_PATH + q.getAttribute("src"));
			}
			else if(q.firstChild){
				var scode = q.firstChild.nodeValue;// + ";\nvar __LoadedScript = true;"
				if(IS_IE) 
					window.execScript(scode);
				else if(IS_GECKO)
					document.body.insertAdjacentHTML("beforeend", "<script>" + scode + "</script>");
				else
					eval(scode);
					
				//if(!__LoadedScript)
				//	throw new Error(0, Kernel.formErrorString(0, null, "Inserting Code Block", "An Error has occurred inserting the javascript code block", q));
			}
		},
		
		"style" : function(q){
			Kernel.importCssString(document, q.firstChild.nodeValue);
		},
		
		"comment" : function (q){
			//do nothing
		},
		
		"presentation" : function(q){
			var name = "skin" + Math.round(Math.random()*100000);
			q.parentNode.setAttribute("skin", name);
			PresentationServer.skins[name] = {name:name,templates:{}}
			var t = q.parentNode[TAGNAME];
			var skin = q.ownerDocument.createElement("skin"); skin.appendChild(q);
			PresentationServer.skins[name].templates[t] = skin;
		},
		
		"skin" : function(q, jmlParent){
			if(jmlParent){
				var name = "skin" + Math.round(Math.random()*100000);
				q.parentNode.setAttribute("skin", name);
				PresentationServer.skins[name] = {name:name,templates:{}}
				PresentationServer.skins[name].templates[q.parentNode[TAGNAME]] = q;
			}
			else if(q.childNodes.length){
				PresentationServer.Init(q);
			}
			else{
				var path = q.getAttribute("src") ? 
					getAbsolutePath(HOST_PATH, q.getAttribute("src")) : 
					getAbsolutePath(HOST_PATH, q.getAttribute("name")) + "/index.xml";
				
				loadJMLInclude(q, new HTTP(), true, path);
			}
		},
		
		"model" : function(q, jmlParent){
			if(jmlParent && !jmlParent.hasFeature(__DATABINDING__)) jmlParent = null;
			
			//Model
			var modelId, m = new Model().register(jmlParent).parse(q);
			if(jmlParent){
				modelId = "model" + this.uniqueId;
				jmlParent.jml.setAttribute("model", modelId);
			}
			else modelId = q.getAttribute("id")
			
			return modelId ? Kernel.setReference(modelId, NameServer.register("model", modelId, m)) : m;
		},
		
		"smartbinding" : function(q, jmlParent){
			var bc = new SmartBinding(q.getAttribute("id"), q);
			if(q.getAttribute("id")) NameServer.register("bindclass", q.getAttribute("id"), bc)
			if(jmlParent) Application.addToSbStack(jmlParent.uniqueId, bc);
		},
		//getFromSbStack
		"bind" : function(q, jmlParent){
			var bc = Application.getFromSbStack(jmlParent.uniqueId) || Application.addToSbStack(jmlParent.uniqueId, new SmartBinding());
			bc.addBindRule(q, jmlParent);
		}, //not referencable
		
		"bindings" : function(q, jmlParent){
			var rules = Kernel.getRules(q);
			if(q.getAttribute("id")) NameServer.register("bindings", q.getAttribute("id"), rules);
			if(jmlParent){
				var bc = Application.getFromSbStack(jmlParent.uniqueId) || Application.addToSbStack(jmlParent.uniqueId, new SmartBinding());
				bc.addBindings(rules, q);
			}
		},
		
		"action" : function(q, jmlParent){
			var bc = Application.getFromSbStack(jmlParent.uniqueId) || Application.addToSbStack(jmlParent.uniqueId, new SmartBinding());
			bc.addActionRule(q, jmlParent);
		}, //not referencable
		
		"actions" : function(q, jmlParent){
			var rules = Kernel.getRules(q);
			if(q.getAttribute("id")) NameServer.register("actions", q.getAttribute("id"), rules);
			if(jmlParent){
				var bc = Application.getFromSbStack(jmlParent.uniqueId) || Application.addToSbStack(jmlParent.uniqueId, new SmartBinding());
				bc.addActions(rules, q);
			}
		},
		
		"actiontracker" : function(q, jmlParent){
			var at;
			
			if(q.getAttribute("id")) 
				at = Kernel.setReference(q.getAttribute("id"), NameServer.register("actiontracker", q.getAttribute("id"), new _ActionTracker()));
			if(jmlParent) jmlParent.__ActionTracker = at || new _ActionTracker(jmlParent);
			
			if(!q.getAttribute("id") && !jmlParent){
				throw new Error(1016, Kernel.formErrorString(1016, null, "ActionTracker", "Could not create ActionTracker without an id specified"));
			}
		},
		
		"allow-drag" : function(q, jmlParent){
			var bc = Application.getFromSbStack(jmlParent.uniqueId) || Application.addToSbStack(jmlParent.uniqueId, new SmartBinding());
			bc.addDragRule(q, jmlParent);
		},  //not referencable
		
		"allow-drop" : function(q, jmlParent){
			var bc = Application.getFromSbStack(jmlParent.uniqueId) || Application.addToSbStack(jmlParent.uniqueId, new SmartBinding());
			bc.addDropRule(q, jmlParent);
		},  //not referencable
		
		"dragdrop" : function(q, jmlParent){
			var rules = Kernel.getRules(q);
			if(q.getAttribute("id")) NameServer.register("dragdrop", q.getAttribute("id"), rules);
			if(jmlParent){
				var bc = Application.getFromSbStack(jmlParent.uniqueId) || Application.addToSbStack(jmlParent.uniqueId, new SmartBinding());
				bc.addDragDrop(rules, q);
			}
		},
			
		"socket" : function(q){
			var o = new Socket();
			Kernel.setReference(x.getAttribute("id"), o);
			o.load(q);
		},

		"poll" : function(q){
			Kernel.setReference(x.getAttribute("id"), new Poll().load(q));
		},
		
		//problem:
		"teleport" : function(q){
			//Initialize Communication Component
			//Kernel.setReference(x.getAttribute("id"), new CommBaseClass(x));
			Kernel.TelePort.load(q);
		},
		
		
		"remotesmartbindings" : function(q){
			//Remote Smart Bindings
			XMLDatabase.loadRDB(q);
		},
		
		"settings" : function(q, jmlParent){
			Application.foundSettings = true;
			Application.lastSettings = q;
			
			//if(!jmlParent.tagName == "Window")
			//	throw new Error(0, Kernel.formErrorString(0, null, "Initialization", "Could not apply settings to window"));
			
			//Set Globals
			//this.iconPath = q.getAttribute("icon-path") || "Icons/";
			//this.mediaPath = q.getAttribute("media-path") || "images/";
			SKIN_PATH = q.getAttribute("skin-path") || "Skins/";
			if(!self.DEBUG) DEBUG = isTrue(q.getAttribute("debug"));
			if(q.getAttribute("debug-type")) DEBUG_TYPE = q.getAttribute("debug-type");
			//if(q.getAttribute("debug-filter")) 
			DEBUG_FILTER = isTrue(q.getAttribute("debug-teleport")) ? "" : "!teleport";
			
			if(!isTrue(q.getAttribute("enable-rightclick")))
				document.oncontextmenu = function(){return false;}
			
			Application.allowSelect = isTrue(q.getAttribute("allow-select"));
				
			Application.autoDisableActions = isTrue(q.getAttribute("auto-disable-actions"));
			Application.autoDisable = !isFalse(q.getAttribute("auto-disable"));
			Application.disableF5 = isTrue(q.getAttribute("disable-f5"));
			
			if(HAS_DESKRUN && Application.disableF5) shell.norefresh = true;
			
			//_Window.getForm(jmlParent.tagName == "Window" ? jmlParent.getAttribute("id") : "main").loadSettings(q);
		}
		
		, "deskrun" : function(q){
			if(!HAS_DESKRUN) return;
			
			var jdwin = window.external, jdshell = jdwin.shell;
			jdwin.style = q.getAttribute("style") || "ismain|taskbar|btn-close|btn-max|btn-min|resizable";

			Application.drRegName = q.getAttribute("record");
			if(q.getAttribute("min-width")) jdwin.setMin(q.getAttribute("min-width"), q.getAttribute("min-height"));
			if(q.getAttribute("record")&& jdshell.RegGet(Application.drRegName + "/window")){
				var winpos = jdshell.RegGet(Application.drRegName + "/window");
				if(winpos){
					winpos = winpos.split(",");
					window.external.width = Math.max(q.getAttribute("min-width"), Math.min(parseInt(winpos[2]),window.external.shell.GetSysValue("deskwidth")));
					window.external.height = Math.max(q.getAttribute("min-height"), Math.min(parseInt(winpos[3]),window.external.shell.GetSysValue("deskheight")));
					window.external.left = Math.max(0,Math.min(parseInt(winpos[0]),screen.width - window.external.width));
					window.external.top = Math.max(0,Math.min(parseInt(winpos[1]),screen.height - window.external.height));
				}
			}
			else{
				jdwin.left = q.getAttribute("left") || 200;
				jdwin.top = q.getAttribute("top") || 200;
				jdwin.width = q.getAttribute("width") || 800;
				jdwin.height = q.getAttribute("height") || 600;
			}
			
			jdwin.caption = q.getAttribute("caption") || "Javeline DeskRun";
			jdwin.icon = q.getAttribute("icon") || 100;

			var ct = $j(q, "context");		
			if(ct.length){
				ct = ct[0];
				if(!Application.tray) Application.tray = window.external.CreateWidget("trayicon")
				var tray = Application.tray;

				tray.icon = q.getAttribute("tray") || 100;
				tray.tip = q.getAttribute("tooltip") || "Javeline DeskRun";
				tray.PopupClear();
				tray.PopupItemAdd("Exit", 3);
				tray.PopupItemAdd("SEP", function(){});
				
				var nodes = ct.childNodes;
				for(var i=nodes.length-1;i>=0;i--){
					if(nodes[i].nodeType != 1) continue;
					
					if(nodes[i][TAGNAME] == "divider"){
						tray.PopupItemAdd("SEP", function(){});
					}
					else{
						tray.PopupItemAdd(getXMLValue(nodes[i], "."), nodes[i].getAttribute("href") ? new Function("window.open('" + nodes[i].getAttribute("href") + "')") : new Function(nodes[i].getAttribute("onclick")));
					}
				}
			}

			jdwin.shell.debug = DEBUG ? 7 : 0;
			jdwin.Show();
			jdwin.SetFocus();
		}
		
		, "window" : function(q){
			_Window.addForm(q);
		},
		
		"loader" : function(q){
			//ignore, handled elsewhere
		}
	},
	
	getBindClass : function(id){return NameServer.get("bindclass", id)},

	getActionTracker : function(id){
		var at = NameServer.get("actiontracker", id);
		if(at) return at;
		if(self[id]) return self[id].getActionTracker();
	},
	
	replaceNode : function(newNode, oldNode){
		var nodes = oldNode.childNodes;
		for(var i=nodes.length-1;i>=0;i--) 
			newNode.insertBefore(nodes[i], newNode.firstChild);
			
		newNode.onresize = oldNode.onresize;
		
		return newNode;
	},
	
	
	/********* createElement ***********
		Create Javeline GUI Element
	
		INTERFACE:
		this.createElement(x, p, win, ro);
	****************************/
	createElement : function(x, p, jmlParent, ro){
		setStatus("Creating Element " + x.tagName + "[" + (x.getAttribute("id") || '') + "]");

		//JML
		if(IS_OPERA) x.scopeName = x.tagName.replace(/^j\:/, "") != x.tagName ? "j" : "";
		if(IS_SAFARI_OLD) x.scopeName = !x.namespaceURI || x.namespaceURI.indexOf("http://www.w3.org/") != -1 ? "" : "j";
		//if(!IS_IE && !self.NAMESPACE) NAMESPACE = "prefix";//x.scopeName == undefined ? "prefix" : "scopeName";
		
		var o;
		if((x.prefix || x.scopeName) == "j"){
			var objectName = x.tagName.replace(/^j\:/, "");
			
			if(!self[objectName] || typeof self[objectName] != "function") throw new Error(1017, Kernel.formErrorString(1017, null, "Initialization", "Could not find Class Definition '" + objectName + "'.", x));
			if(!self[objectName]) throw new Error(0, "Could not find class " + objectName);
			
			//Check if Class is loaded in current Window
			//if(!self[objectName]) main.window.importClass(main.window[objectName], false, window);
	
			//Create Object en Reference
			o = new self[objectName](p);
			if(x.getAttribute("id")) Kernel.setReference(x.getAttribute("id"), o);

			//Process JML
			if(o.loadJML) o.loadJML(x, jmlParent);
		}
		//HTML
		else{
			// Move all this to the respective browser libs in a wrapper function
			if(IS_IE){
				o = x.ownerDocument == p.ownerDocument ? p.appendChild(x.cloneNode(false)) : XMLDatabase.htmlImport(x.cloneNode(x.tagName.toLowerCase() == "table"), p);
			}

			//SAFARI importing cloned node kills safari.. temp workaround in place
			else if(IS_SAFARI){
				//o = p.appendChild(p.ownerDocument.importNode(x));//.cloneNode(false)
				o = x.ownerDocument == p.ownerDocument ? p.appendChild(x) : XMLDatabase.htmlImport(x.cloneNode(x.tagName.toLowerCase() == "table"), p);
			}
			else{
				o = x.ownerDocument == p.ownerDocument ? p.appendChild(x.cloneNode(false)) : XMLDatabase.htmlImport(x.cloneNode(false), p);
				//o = p.appendChild(p.ownerDocument.importNode(x.cloneNode(false), false));	
			}
			
			if(!IS_IE || x.tagName.toLowerCase() != "table")
				this.loadSubNode(x, o, jmlParent);
			else{
				issueWarning(0, "Not parsing children of table, ignoring all Javeline Platform Elements.");
			}
			
		}

		return o;
	},
	
	
	/********* PROCESSDATABINDING ***********
		Process Databinding Rules of all objects set
	
		INTERFACE:
		this.processDatabinding();
	****************************/
	processDatabinding : function(){
		
		
		setStatus("Processing SmartBinding hooks");
		
		/*
			All these component dependant things might
			be suited better to be in a component generation
			called event
		*/
		
		// Initialize state bindings
		for(var i=0;i<this.stateStack.length;i++){
			this.stateStack[i][0].setDynamicProperty(this.stateStack[i][1], this.stateStack[i][2]);
		}

		//Initialize Databinding for all GUI Elements in Form
		for(var uniqueId in this.sbInit){
			if(parseInt(uniqueId) != uniqueId) continue;

			//Retrieve Jml Node
			var jNode = Kernel.lookup(uniqueId);

			//Set Main bindclass
			if(this.sbInit[uniqueId][0]) jNode.setBindClass(this.sbInit[uniqueId][0]);
			
			//Set selection bindclass if any
			if(this.sbInit[uniqueId][1]) jNode.setSelectionBindClass(this.sbInit[uniqueId][1]);
		}
		
		//Initialize Models
		for(var data,i=0;i<this.modelInit.length;i++){
			data = this.modelInit[i][1];
			
			if(!eval(data[0]))
				throw new Error(1067, Kernel.formErrorString(1067, this, "connect", "Could not find component to connect to : " + data[0], x));
			
			eval(data[0]).connect(this.modelInit[i][0], null, data[2], data[1] || "select");
		}
		
		//Call the onload event
		if(this.onload){
			this.onload();
			this.onload = null;
		}
		
		if(!this.loaded){
			if(me.useDeskRun) me.deskrun.Show();
			
			// Set the default selected element
			me.moveNext();
			
			this.loaded = true;
		}

		this.sbInit = {};
		this.modelInit = [];
		this.stateStack = [];
		// END OF ENTIRE APPLICATION STARTUP
		
		setStatus("Initialization finished");
		Profiler.end();
		setStatus("[TIME] Total time for SmartBindings: " + Profiler.totalTime + "ms");
	}
	
	
	, addToSbStack : function(uniqueId, sNode, nr){
		if(!this.sbInit[uniqueId]) this.sbInit[uniqueId] = [];
		this.sbInit[uniqueId][nr||0] = sNode;
		return sNode;
	},
	
	getFromSbStack : function(uniqueId, nr){
		return this.sbInit[uniqueId] ? this.sbInit[uniqueId][nr || 0] : null;
	},
	
	stackHasBindings : function(uniqueId){
		return this.sbInit[uniqueId] && this.sbInit[uniqueId][0] && this.sbInit[uniqueId][0].bindings;
	},
	
	modelInit : [],
	addToModelStack : function(o, data){
		this.modelInit.push([o, data]);
	}
	
}


Init.run('Application');
/*FILEHEAD(/in/Core/Highlighter/shCore.uncompressed.js)SIZE(19068)TIME(1166375348945)*/

/**
 * Code Syntax Highlighter.
 * Version 1.3.0
 * Copyright (C) 2004 Alex Gorbatchev.
 * http://www.dreamprojections.com/syntaxhighlighter/
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General 
 * Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more 
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to 
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

//
// create namespaces
//
var dp = {
	sh :
	{
		Toolbar : {},
		Utils	: {},
		RegexLib: {},
		Brushes	: {},
		Strings : {},
		Version : '1.4.1'
	}
};

dp.sh.Strings = {
	AboutDialog : '<html><head><title>About...</title></head><body class="dp-about"><table cellspacing="0"><tr><td class="copy"><p class="title">dp.SyntaxHighlighter</div><div class="para">Version: {V}</p><p><a href="http://www.dreamprojections.com/syntaxhighlighter/?ref=about" target="_blank">http://www.dreamprojections.com/SyntaxHighlighter</a></p>&copy;2004-2005 Alex Gorbatchev. All right reserved.</td></tr><tr><td class="footer"><input type="button" class="close" value="OK" onClick="window.close()"/></td></tr></table></body></html>'
};

dp.SyntaxHighlighter = dp.sh;

//
// Toolbar functions
//

dp.sh.Toolbar.Commands = {
	ExpandSource: {
		label: '+ expand source',
		check: function(highlighter) { return highlighter.collapse; },
		func: function(sender, highlighter)
		{
			sender.parentNode.removeChild(sender);
			highlighter.div.className = highlighter.div.className.replace('collapsed', '');
		}
	},
	
	// opens a new windows and puts the original unformatted source code inside.
	ViewSource: {
		label: 'view plain',
		func: function(sender, highlighter)
		{
			var code = highlighter.originalCode.replace(/</g, '&lt;');
			var wnd = window.open('', '_blank', 'width=750, height=400, location=0, resizable=1, menubar=0, scrollbars=1');
			wnd.document.write('<textarea style="width:99%;height:99%">' + code + '</textarea>');
			wnd.document.close();
		}
	},
	
	// copies the original source code in to the clipboard (IE only)
	CopyToClipboard: {
		label: 'copy to clipboard',
		check: function() { return window.clipboardData != null; },
		func: function(sender, highlighter)
		{
			window.clipboardData.setData('text', highlighter.originalCode);
			alert('The code is in your clipboard now');
		}
	},
	
	// creates an invisible iframe, puts the original source code inside and prints it
	PrintSource: {
		label: 'print',
		func: function(sender, highlighter)
		{
			var iframe = document.createElement('IFRAME');
			var doc = null;

			// this hides the iframe
			iframe.style.cssText = 'position:absolute;width:0px;height:0px;left:-500px;top:-500px;';
			
			document.body.appendChild(iframe);
			doc = iframe.contentWindow.document;

			dp.sh.Utils.CopyStyles(doc, window.document);
			doc.write('<div class="' + highlighter.div.className.replace('collapsed', '') + ' printing">' + highlighter.div.innerHTML + '</div>');
			doc.close();

			iframe.contentWindow.focus();
			iframe.contentWindow.print();
			
			alert('Printing...');
			
			document.body.removeChild(iframe);
		}
	},
	
	About: {
		label: '?',
		func: function(highlighter)
		{
			var wnd	= window.open('', '_blank', 'dialog,width=300,height=150,scrollbars=0');
			var doc	= wnd.document;

			dp.sh.Utils.CopyStyles(doc, window.document);
			
			doc.write(dp.sh.Strings.AboutDialog.replace('{V}', dp.sh.Version));
			doc.close();
			wnd.focus();
		}
	}
};

// creates a <div /> with all toolbar links
dp.sh.Toolbar.Create = function(highlighter)
{
	var div = document.createElement('DIV');
	
	div.className = 'tools';
	
	for(var name in dp.sh.Toolbar.Commands)
	{
		var cmd = dp.sh.Toolbar.Commands[name];
		
		if(cmd.check != null && !cmd.check(highlighter))
			continue;
		
		div.innerHTML += '<a href="#" onclick="dp.sh.Toolbar.Command(\'' + name + '\',this);return false;">' + cmd.label + '</a>';
	}
	
	return div;
}

// executes toolbar command by name
dp.sh.Toolbar.Command = function(name, sender)
{
	var n = sender;
	
	while(n != null && n.className.indexOf('dp-highlighter') == -1)
		n = n.parentNode;
	
	if(n != null)
		dp.sh.Toolbar.Commands[name].func(sender, n.highlighter);
}

// copies all <link rel="stylesheet" /> from 'target' window to 'dest'
dp.sh.Utils.CopyStyles = function(destDoc, sourceDoc)
{
	var links = sourceDoc.getElementsByTagName('link');

	for(var i = 0; i < links.length; i++)
		if(links[i].rel.toLowerCase() == 'stylesheet')
			destDoc.write('<link type="text/css" rel="stylesheet" href="' + links[i].href + '"></link>');
}

//
// Common reusable regular expressions
//
dp.sh.RegexLib = {
	MultiLineCComments : new RegExp('/\\*[\\s\\S]*?\\*/', 'gm'),
	SingleLineCComments : new RegExp('//.*$', 'gm'),
	SingleLinePerlComments : new RegExp('#.*$', 'gm'),
	DoubleQuotedString : new RegExp('"(?:\\.|(\\\\\\")|[^\\""])*"','g'),
	SingleQuotedString : new RegExp("'(?:\\.|(\\\\\\')|[^\\''])*'", 'g')
};

//
// Match object
//
dp.sh.Match = function(value, index, css)
{
	this.value = value;
	this.index = index;
	this.length = value.length;
	this.css = css;
}

//
// Highlighter object
//
dp.sh.Highlighter = function()
{
	this.noGutter = false;
	this.addControls = true;
	this.collapse = false;
	this.tabsToSpaces = true;
	this.wrapColumn = 80;
	this.showColumns = true;
}

// static callback for the match sorting
dp.sh.Highlighter.SortCallback = function(m1, m2)
{
	// sort matches by index first
	if(m1.index < m2.index)
		return -1;
	else if(m1.index > m2.index)
		return 1;
	else
	{
		// if index is the same, sort by length
		if(m1.length < m2.length)
			return -1;
		else if(m1.length > m2.length)
			return 1;
	}
	return 0;
}

dp.sh.Highlighter.prototype.CreateElement = function(name)
{
	var result = document.createElement(name);
	result.highlighter = this;
	return result;
}

// gets a list of all matches for a given regular expression
dp.sh.Highlighter.prototype.GetMatches = function(regex, css)
{
	var index = 0;
	var match = null;

	while((match = regex.exec(this.code)) != null)
		this.matches[this.matches.length] = new dp.sh.Match(match[0], match.index, css);
}

dp.sh.Highlighter.prototype.AddBit = function(str, css)
{
	if(str == null || str.length == 0)
		return;

	var span = this.CreateElement('SPAN');
	
	str = str.replace(/&/g, '&amp;');
	str = str.replace(/ /g, '&nbsp;');
	str = str.replace(/</g, '&lt;');
	str = str.replace(/\n/gm, '&nbsp;<br>');

	// when adding a piece of code, check to see if it has line breaks in it 
	// and if it does, wrap individual line breaks with span tags
	if(css != null)
	{
		var regex = new RegExp('<br>', 'gi');
		
		if(regex.test(str))
		{
			var lines = str.split('&nbsp;<br>');
			
			str = '';
			
			for(var i = 0; i < lines.length; i++)
			{
				span = this.CreateElement('SPAN');
				span.className = css;
				span.innerHTML = lines[i];
				
				this.div.appendChild(span);
				
				// don't add a <BR> for the last line
				if(i + 1 < lines.length)
					this.div.appendChild(this.CreateElement('BR'));
			}
		}
		else
		{
			span.className = css;
			span.innerHTML = str;
			this.div.appendChild(span);
		}
	}
	else
	{
		span.innerHTML = str;
		this.div.appendChild(span);
	}
}

// checks if one match is inside any other match
dp.sh.Highlighter.prototype.IsInside = function(match)
{
	if(match == null || match.length == 0)
		return false;
	
	for(var i = 0; i < this.matches.length; i++)
	{
		var c = this.matches[i];
		
		if(c == null)
			continue;

		if((match.index > c.index) && (match.index < c.index + c.length))
			return true;
	}
	
	return false;
}

dp.sh.Highlighter.prototype.ProcessRegexList = function()
{
	for(var i = 0; i < this.regexList.length; i++)
		this.GetMatches(this.regexList[i].regex, this.regexList[i].css);
}

dp.sh.Highlighter.prototype.ProcessSmartTabs = function(code)
{
	var lines	= code.split('\n');
	var result	= '';
	var tabSize	= 4;
	var tab		= '\t';

	// This function inserts specified amount of spaces in the string
	// where a tab is while removing that given tab. 
	function InsertSpaces(line, pos, count)
	{
		var left	= line.substr(0, pos);
		var right	= line.substr(pos + 1, line.length);	// pos + 1 will get rid of the tab
		var spaces	= '';
		
		for(var i = 0; i < count; i++)
			spaces += ' ';
		
		return left + spaces + right;
	}

	// This function process one line for 'smart tabs'
	function ProcessLine(line, tabSize)
	{
		if(line.indexOf(tab) == -1)
			return line;

		var pos = 0;

		while((pos = line.indexOf(tab)) != -1)
		{
			// This is pretty much all there is to the 'smart tabs' logic.
			// Based on the position within the line and size of a tab, 
			// calculate the amount of spaces we need to insert.
			var spaces = tabSize - pos % tabSize;
			
			line = InsertSpaces(line, pos, spaces);
		}
		
		return line;
	}

	// Go through all the lines and do the 'smart tabs' magic.
	for(var i = 0; i < lines.length; i++)
		result += ProcessLine(lines[i], tabSize) + '\n';
	
	return result;
}

dp.sh.Highlighter.prototype.SwitchToList = function()
{
	// thanks to Lachlan Donald from SitePoint.com for this <br/> tag fix.
	var html = this.div.innerHTML.replace(/<(br)\/?>/gi, '\n');
	var lines = html.split('\n');
	
	if(this.addControls == true)
		this.bar.appendChild(dp.sh.Toolbar.Create(this));

	// add columns ruler
	if(this.showColumns)
	{
		var div = this.CreateElement('div');
		var columns = this.CreateElement('div');
		var showEvery = 10;
		var i = 1;
		
		while(i <= 150)
		{
			if(i % showEvery == 0)
			{
				div.innerHTML += i;
				i += (i + '').length;
			}
			else
			{
				div.innerHTML += '&middot;';
				i++;
			}
		}
		
		columns.className = 'columns';
		columns.appendChild(div);
		this.bar.appendChild(columns);
	}

	for(var i = 0, lineIndex = this.firstLine; i < lines.length - 1; i++, lineIndex++)
	{
		var li = this.CreateElement('LI');
		var span = this.CreateElement('SPAN');
		
		// uses .line1 and .line2 css styles for alternating lines
		li.className = (i % 2 == 0) ? 'alt' : '';
		span.innerHTML = lines[i] + '&nbsp;';

		li.appendChild(span);
		this.ol.appendChild(li);
	}
	
	this.div.innerHTML	= '';
}

dp.sh.Highlighter.prototype.Highlight = function(code)
{
	function Trim(str)
	{
		return str.replace(/^\s*(.*?)[\s\n]*$/g, '$1');
	}
	
	function Chop(str)
	{
		return str.replace(/\n*$/, '').replace(/^\n*/, '');
	}

	function Unindent(str)
	{
		var lines = str.split('\n');
		var indents = new Array();
		var regex = new RegExp('^\\s*', 'g');
		var min = 1000;

		// go through every line and check for common number of indents
		for(var i = 0; i < lines.length && min > 0; i++)
		{
			if(Trim(lines[i]).length == 0)
				continue;
				
			var matches = regex.exec(lines[i]);

			if(matches != null && matches.length > 0)
				min = Math.min(matches[0].length, min);
		}

		// trim minimum common number of white space from the begining of every line
		if(min > 0)
			for(var i = 0; i < lines.length; i++)
				lines[i] = lines[i].substr(min);

		return lines.join('\n');
	}
	
	// This function returns a portions of the string from pos1 to pos2 inclusive
	function Copy(string, pos1, pos2)
	{
		return string.substr(pos1, pos2 - pos1);
	}

	var pos	= 0;
	
	this.originalCode = code;
	this.code = Chop(Unindent(code));
	this.div = this.CreateElement('DIV');
	this.bar = this.CreateElement('DIV');
	this.ol = this.CreateElement('OL');
	this.matches = new Array();

	this.div.className = 'dp-highlighter';
	this.div.highlighter = this;
	
	this.bar.className = 'bar';
	
	// set the first line
	this.ol.start = this.firstLine;

	if(this.CssClass != null)
		this.ol.className = this.CssClass;

	if(this.collapse)
		this.div.className += ' collapsed';
	
	if(this.noGutter)
		this.div.className += ' nogutter';

	// replace tabs with spaces
	if(this.tabsToSpaces == true)
		this.code = this.ProcessSmartTabs(this.code);

	this.ProcessRegexList();	

	// if no matches found, add entire code as plain text
	if(this.matches.length == 0)
	{
		this.AddBit(this.code, null);
		this.SwitchToList();
		this.div.appendChild(this.ol);
		return;
	}

	// sort the matches
	this.matches = this.matches.sort(dp.sh.Highlighter.SortCallback);

	// The following loop checks to see if any of the matches are inside
	// of other matches. This process would get rid of highligted strings
	// inside comments, keywords inside strings and so on.
	for(var i = 0; i < this.matches.length; i++)
		if(this.IsInside(this.matches[i]))
			this.matches[i] = null;

	// Finally, go through the final list of matches and pull the all
	// together adding everything in between that isn't a match.
	for(var i = 0; i < this.matches.length; i++)
	{
		var match = this.matches[i];

		if(match == null || match.length == 0)
			continue;

		this.AddBit(Copy(this.code, pos, match.index), null);
		this.AddBit(match.value, match.css);

		pos = match.index + match.length;
	}
	
	this.AddBit(this.code.substr(pos), null);

	this.SwitchToList();
	//this.div.appendChild(this.bar);
	this.div.appendChild(this.ol);
}

dp.sh.Highlighter.prototype.GetKeywords = function(str) 
{
	return '\\b' + str.replace(/ /g, '\\b|\\b') + '\\b';
}

// highlightes all elements identified by name and gets source code from specified property
dp.sh.HighlightAll = function(name, showGutter /* optional */, showControls /* optional */, collapseAll /* optional */, firstLine /* optional */, showColumns /* optional */)
{
	function FindValue()
	{
		var a = arguments;
		
		for(var i = 0; i < a.length; i++)
		{
			if(a[i] == null)
				continue;
				
			if(typeof(a[i]) == 'string' && a[i] != '')
				return a[i] + '';
		
			if(typeof(a[i]) == 'object' && a[i].value != '')
				return a[i].value + '';
		}
		
		return null;
	}
	
	function IsOptionSet(value, list)
	{
		for(var i = 0; i < list.length; i++)
			if(list[i] == value)
				return true;
		
		return false;
	}
	
	function GetOptionValue(name, list, defaultValue)
	{
		var regex = new RegExp('^' + name + '\\[(\\w+)\\]$', 'gi');
		var matches = null;

		for(var i = 0; i < list.length; i++)
			if((matches = regex.exec(list[i])) != null)
				return matches[1];
		
		return defaultValue;
	}

	var elements = document.getElementsByName(name);
	var highlighter = null;
	var registered = new Object();
	var propertyName = 'value';
	
	// if no code blocks found, leave
	if(elements == null)
		return;

	// register all brushes
	for(var brush in dp.sh.Brushes)
	{
		var aliases = dp.sh.Brushes[brush].Aliases;

		if(aliases == null)
			continue;
		
		for(var i = 0; i < aliases.length; i++)
			registered[aliases[i]] = brush;
	}

	for(var i = 0; i < elements.length; i++)
	{
		var element = elements[i];
		var options = FindValue(
				element.attributes['class'], element.className, 
				element.attributes['language'], element.language
				);
		var language = '';
		
		if(options == null)
			continue;
		
		options = options.split(':');
		
		language = options[0].toLowerCase();

		if(registered[language] == null)
			continue;
		
		// instantiate a brush
		highlighter = new dp.sh.Brushes[registered[language]]();
		
		// hide the original element
		element.style.display = 'none';

		highlighter.noGutter = (showGutter == null) ? IsOptionSet('nogutter', options) : !showGutter;
		highlighter.addControls = (showControls == null) ? !IsOptionSet('nocontrols', options) : showControls;
		highlighter.collapse = (collapseAll == null) ? IsOptionSet('collapse', options) : collapseAll;
		highlighter.showColumns = (showColumns == null) ? IsOptionSet('showcolumns', options) : showColumns;
		
		// first line idea comes from Andrew Collington, thanks!
		highlighter.firstLine = (firstLine == null) ? parseInt(GetOptionValue('firstline', options, 1)) : firstLine;

		highlighter.Highlight(element[propertyName]);

		element.parentNode.insertBefore(highlighter.div, element);
	}	
}

// highlightes all elements identified by name and gets source code from specified property
dp.sh.HighlightString = function(strCode, showGutter /* optional */, showControls /* optional */, collapseAll /* optional */, firstLine /* optional */, showColumns /* optional */)
{
	function FindValue()
	{
		var a = arguments;
		
		for(var i = 0; i < a.length; i++)
		{
			if(a[i] == null)
				continue;
				
			if(typeof(a[i]) == 'string' && a[i] != '')
				return a[i] + '';
		
			if(typeof(a[i]) == 'object' && a[i].value != '')
				return a[i].value + '';
		}
		
		return null;
	}
	
	function IsOptionSet(value, list)
	{
		for(var i = 0; i < list.length; i++)
			if(list[i] == value)
				return true;
		
		return false;
	}
	
	function GetOptionValue(name, list, defaultValue)
	{
		var regex = new RegExp('^' + name + '\\[(\\w+)\\]$', 'gi');
		var matches = null;

		for(var i = 0; i < list.length; i++)
			if((matches = regex.exec(list[i])) != null)
				return matches[1];
		
		return defaultValue;
	}

	var highlighter = null;
	var registered = new Object();
	var propertyName = 'value';
	
	// register all brushes
	for(var brush in dp.sh.Brushes)
	{
		var aliases = dp.sh.Brushes[brush].Aliases;

		if(aliases == null)
			continue;
		
		for(var i = 0; i < aliases.length; i++)
			registered[aliases[i]] = brush;
	}

	var options = "";
	var language = "js";

	if(registered[language] == null)
		return;
	
	// instantiate a brush
	highlighter = new dp.sh.Brushes[registered[language]]();
	
	highlighter.noGutter = (showGutter == null) ? IsOptionSet('nogutter', options) : !showGutter;
	highlighter.addControls = (showControls == null) ? !IsOptionSet('nocontrols', options) : showControls;
	highlighter.collapse = (collapseAll == null) ? IsOptionSet('collapse', options) : collapseAll;
	highlighter.showColumns = (showColumns == null) ? IsOptionSet('showcolumns', options) : showColumns;
	
	// first line idea comes from Andrew Collington, thanks!
	highlighter.firstLine = (firstLine == null) ? parseInt(GetOptionValue('firstline', options, 1)) : firstLine;

	highlighter.Highlight(strCode);

	return highlighter.div;
}



/*FILEHEAD(/in/Core/Highlighter/shBrushJScript.js)SIZE(1316)TIME(1166375348945)*/

dp.sh.Brushes.JScript = function()
{
	var keywords =	'abstract boolean break byte case catch char class const continue debugger ' +
					'default delete do double else enum export extends false final finally float ' +
					'for function goto if implements import in instanceof int interface long native ' +
					'new null package private protected public return short static super switch ' +
					'synchronized this throw throws transient true try typeof var void volatile while with';

	this.regexList = [
		{ regex: dp.sh.RegexLib.SingleLineCComments,				css: 'comment' },			// one line comments
		{ regex: dp.sh.RegexLib.MultiLineCComments,					css: 'comment' },			// multiline comments
		{ regex: dp.sh.RegexLib.DoubleQuotedString,					css: 'string' },			// double quoted strings
		{ regex: dp.sh.RegexLib.SingleQuotedString,					css: 'string' },			// single quoted strings
		{ regex: new RegExp('^\\s*#.*', 'gm'),						css: 'preprocessor' },		// preprocessor tags like #region and #endregion
		{ regex: new RegExp(this.GetKeywords(keywords), 'gm'),		css: 'keyword' }			// keywords
		];

	this.CssClass = 'dp-c';
}

dp.sh.Brushes.JScript.prototype	= new dp.sh.Highlighter();
dp.sh.Brushes.JScript.Aliases	= ['js', 'jscript', 'javascript'];


/*FILEHEAD(/in/Core/Highlighter/SyntaxHighlighter.css.js)SIZE(4449)TIME(1166375348945)*/

var SyntaxHighlighterCSS = '.dp-highlighter{	font-family: "Courier New" , Courier, mono;	font-size: 12px;	border: 1px solid #CCCCCC;	background-color: #fff;	overflow: auto;	max-height : 400px;	white-space : nowrap;}.dp-highlighter .bar{	padding-left: 45px;}.dp-highlighter.collapsed .bar, .dp-highlighter.nogutter .bar{	padding-left: 0px;}.dp-highlighter ol{	margin: 0px 0px 1px 45px; 	padding: 0px;	color: #2B91AF;}.dp-highlighter.nogutter ol{	list-style-type: none;	margin-left: 0px;}.dp-highlighter ol li, .dp-highlighter .columns div{	border-left: 3px solid #6CE26C;	background-color: #fff;	padding-left: 10px;	line-height: 14px;}.dp-highlighter.nogutter ol li, .dp-highlighter.nogutter .columns div{	border: 0;}.dp-highlighter .columns{	color: gray;	overflow: hidden;	width: 100%;}.dp-highlighter .columns div{	padding-bottom: 5px;}.dp-highlighter ol li.alt{	background-color: #f8f8f8;}.dp-highlighter ol li span{	color: Black;}.dp-highlighter.collapsed ol{	margin: 0px;}.dp-highlighter.collapsed ol li{	display: none;}.dp-highlighter.printing {	border: none;}.dp-highlighter.printing .tools{	display: none !important;}.dp-highlighter.printing li{	display: list-item !important;}.dp-highlighter .tools{	padding: 3px 8px 3px 10px;	border-bottom: 1px solid #2B91AF;	font: 9px Verdana, Geneva, Arial, Helvetica, sans-serif;	color: silver;}.dp-highlighter.collapsed .tools{	border-bottom: 0;}.dp-highlighter .tools a{	font-size: 9px;	color: gray;	text-decoration: none;	margin-right: 10px;}.dp-highlighter .tools a:hover{	color: red;	text-decoration: underline;}.dp-about { background-color: #fff; margin: 0px; padding: 0px; }.dp-about table { width: 100%; height: 100%; font-size: 11px; font-family: Tahoma, Verdana, Arial, sans-serif !important; }.dp-about td { padding: 10px; vertical-align: top; }.dp-about .copy { border-bottom: 1px solid #ACA899; height: 95%; }.dp-about .title { color: red; font-weight: bold; }.dp-about .para { margin: 0 0 4px 0; }.dp-about .footer { background-color: #ECEADB; border-top: 1px solid #fff; text-align: right; }.dp-about .close { font-size: 11px; font-family: Tahoma, Verdana, Arial, sans-serif !important; background-color: #ECEADB; width: 60px; height: 22px; }.dp-c {}.dp-c .comment { color: green; }.dp-c .string { color: blue; }.dp-c .preprocessor { color: gray; }.dp-c .keyword { color: blue; }.dp-c .vars { color: #d00; }.dp-vb {}.dp-vb .comment { color: green; }.dp-vb .string { color: blue; }.dp-vb .preprocessor { color: gray; }.dp-vb .keyword { color: blue; }.dp-sql {}.dp-sql .comment { color: green; }.dp-sql .string { color: red; }.dp-sql .keyword { color: blue; }.dp-sql .func { color: #ff1493; }.dp-sql .op { color: #808080; }.dp-xml {}.dp-xml .cdata { color: #ff1493; }.dp-xml .comments { color: green; }.dp-xml .tag { font-weight: bold; color: blue; }.dp-xml .tag-name { color: black; font-weight: bold; }.dp-xml .attribute { color: red; }.dp-xml .attribute-value { color: blue; }.dp-delphi {}.dp-delphi .comment { color: #008200; font-style: italic; }.dp-delphi .string { color: blue; }.dp-delphi .number { color: blue; }.dp-delphi .directive { color: #008284; }.dp-delphi .keyword { font-weight: bold; color: navy; }.dp-delphi .vars { color: #000; }.dp-py {}.dp-py .comment { color: green; }.dp-py .string { color: red; }.dp-py .docstring { color: green; }.dp-py .keyword { color: blue; font-weight: bold;}.dp-py .builtins { color: #ff1493; }.dp-py .magicmethods { color: #808080; }.dp-py .exceptions { color: brown; }.dp-py .types { color: brown; font-style: italic; }.dp-py .commonlibs { color: #8A2BE2; font-style: italic; }.dp-rb {}.dp-rb .comment { color: #c00; }.dp-rb .string  { color: #f0c; }.dp-rb .symbol  { color: #02b902; }.dp-rb .keyword { color: #069; }.dp-rb .variable { color: #6cf; }.dp-css {}.dp-css .comment { color: green; }.dp-css .string { color: red; }.dp-css .keyword { color: blue; }.dp-css .colors { color: darkred; }.dp-css .vars { color: #d00; }.dp-j {}.dp-j .comment { color: rgb(63,127,95); }.dp-j .string { color: rgb(42,0,255); }.dp-j .keyword { color: rgb(127,0,85); font-weight: bold }.dp-j .annotation { color: #646464; }.dp-j .number { color: #C00000; }.dp-cpp {}.dp-cpp .comment { color: #e00; }.dp-cpp .string { color: red; }.dp-cpp .preprocessor { color: #CD00CD; font-weight: bold; }.dp-cpp .keyword { color: #5697D9; font-weight: bold; }.dp-cpp .datatypes { color: #2E8B57; font-weight: bold; }';


/*FILEHEAD(/in/Core/Kernel/browsers/isOpera.js)SIZE(5252)TIME(1182723583203)*/

/*FILEHEAD(/in/Core/Kernel/Class.js)SIZE(8917)TIME(1182726961382)*/

function Class(){
	this.__jmlLoaders = [];
	this.__addJmlLoader = function(func){
		if(!this.__jmlLoaders) func.call(this, this.jml);
		else this.__jmlLoaders.push(func);
	}
	
	this.__jmlDestroyers = [];
	this.__addJmlDestroyer = function(func){this.__jmlDestroyers.push(func);}
	
	this.__regbase = 0;
	this.hasFeature = function(test){return this.__regbase&test}

	/************************
		PROPERTY BINDING
	************************/
	
	
	var boundObjects = {};
	var myBoundPlaces = {}
	
	/*for(var i=0;i<this.__supportedProperties.length;i++){
		var p = uCaseFirst(this.__supportedProperties[i]);
		this["set" + p] = function(prop){return function(value){
			this.setProperty(prop, value);
		}}(this.__supportedProperties[i]);
		
		this["get" + p] = function(prop){return function(){
			return this.getProperty(prop);
		}}(this.__supportedProperties[i]);
	}*/
	
	this.bindProperty = function(myProp, bObject, bProp, strDynamicProp){
		//#--ifdef 1
		if(!boundObjects[myProp]) boundObjects[myProp] = {};
		if(!boundObjects[myProp][bObject.uniqueId]) boundObjects[myProp][bObject.uniqueId] = [];
		
		if(boundObjects[myProp][bObject.uniqueId].contains(bProp)){
			throw new Error(0, Kernel.formErrorString(0, this, "Property-binding", "Already bound " + bObject.name + "." + bProp + " to " + myProp));
		}
		
		if(strDynamicProp) boundObjects[myProp][bObject.uniqueId].push([bProp, strDynamicProp]);
		else boundObjects[myProp][bObject.uniqueId].pushUnique([bProp]); //The new array is always unique... or what?
		/* #--else
		
		if(!boundObjects[myProp]) boundObjects[myProp] = [];
		boundObjects[myProp].push([bObject, bProp, strDynamicProp]);
		
		#--endif */
		
		bObject.handlePropSet(bProp, strDynamicProp ? eval(strDynamicProp) : this[myProp]);
	}
	
	this.unbindProperty = function(myProp, bObject, bProp){
		//#--ifdef 1
		boundObjects[myProp][bObject.uniqueId].remove(bProp);
		/* #--else
		
		if(!boundObjects[myProp]) return;
		for(var i=0;i<boundObjects[myProp].length;i++){
			if(boundObjects[myProp][0] == bObject && boundObjects[myProp][1] == bProp){
				return boundObjects[myProp].removeIndex(i);
			}
		}
		
		#--endif */
	}
	
	this.unbindAllProperties = function(){
		var prop;
		for(prop in myBoundPlaces){
			//Remove any bounds if relevant
			if(myBoundPlaces[prop] && typeof myBoundPlaces[prop] != "function"){
				for(var i=0;i<myBoundPlaces[prop].length;i++){
					if(!self[myBoundPlaces[prop][i][0]]) continue;
					self[myBoundPlaces[prop][i][0]].unbindProperty(myBoundPlaces[prop][i][1], this, prop);
				}
			}
		}
	}
	
	this.getAvailableProperties = function(){
		return this.__supportedProperties.copy();
	}
	
	this.setDynamicProperty = function(prop, pValue){
		//pValue.match(/^([{\[])(.*)[}\]]$/); // Find dynamic or calculated property
		var pStart = pValue.substr(0,1);

		var y = pValue.substr(pValue.length-1,1);
		if(pStart == "[" && y != "]" || pStart == "{" && y != "}" ){
			throw new Error(0, Kernel.formErrorString(0, this, "Dynamic Property Binding", "Invalid binding found: " + pValue));	
		}
		
		//Remove any bounds if relevant
		if(myBoundPlaces[prop]){
			for(var i=0;i<myBoundPlaces[prop].length;i++){
				self[myBoundPlaces[prop][i][0]].unbindProperty(myBoundPlaces[prop][i][1], this, prop);
			}
		}

		//Two Way property binds
		if(pStart == "["){
			var p = pValue.substr(1,pValue.length-2).split(".");
			if(!self[p[0]]) return; 
			if(!p[1]) p[1] = self[p[0]].__supportedProperties[0]; // Default state property
			
			//Two way property binding
			self[p[0]].bindProperty(p[1], this, prop); myBoundPlaces[prop] = [p];
			this.bindProperty(prop, self[p[0]], p[1]);
		}
		
		//One Way Dynamic Properties
		else if(pStart == "{"){
			var p, matches = {}, pValue = pValue.substr(1,pValue.length-2);
			pValue.replace(/["'](?:\\.|[^"']+)*["']|\/(?:\\.|[^\/\\]+)*\/|(?:\W|^)([a-z]\w+\.\w+)(?!\()(?:\W|$)/g, function(m, m1){if(m1) matches[m1] = true;});
			pValue = pValue.replace(/\Wand\W/g, "&&").replace(/\Wor\W/g, "||");//.replace(/\!\=|(\=)/g, function(m, m1){if(!m1) return m; return m1+"="})
			myBoundPlaces[prop] = [];
			for(p in matches){
				if(typeof matches[p] == "function") continue;
				
				var o = p.split(".");
				if(!self[o[0]] || !self[o[0]].bindProperty) continue;  //return
				
				self[o[0]].bindProperty(o[1], this, prop, pValue); myBoundPlaces[prop].push(o); 
			}
			
		}
		else this.handlePropSet(prop, pValue);
	}
	
	
	this.setProperty = function(prop, value, reqValue, forceOnMe){
		if(reqValue && !value) return;

		if(this[prop] !== value)
			this.handlePropSet(prop, value, forceOnMe);
		
		
		var nodes = boundObjects[prop];
		if(!nodes) return;

		//#--ifdef 1
		var id, ovalue = value;
		for(id in nodes){
			if(IS_SAFARI && (typeof nodes[id] != "object" || !nodes[id])) continue;
			
			for(var o=Kernel.lookup(id),i=nodes[id].length-1;i>=0;--i){
				try{
					value = nodes[id][i][1] ? eval(nodes[id][i][1]) : ovalue;
				}catch(e){
					throw new Error(0, Kernel.formErrorString(0, this, "Property-binding", "Could not execute binding test: " + nodes[id][i][1]));
				}

				if(o[nodes[id][i][0]] != value)
					o.setProperty(nodes[id][i][0], value);//__handlePropSet
			}
		}
		/* #--else
		
		for(var i=0;i<nodes.length;i++){
			try{
				nodes[i][0].handlePropSet(nodes[i][1], nodes[i][2] ? eval(nodes[i][2]) : value);
			}catch(e){}
		}
		#--endif */
		
	}
	
	this.getProperty = function(prop){
		return this[prop];
	}
	
	/************************
		EVENT HANDLING
	************************/
	
	var events_stack = {};
	this.dispatchEvent = function(eventName){
		if(this.disabled) return false;
		
		
		var result, arr = events_stack[eventName];
		if((!arr || !arr.length) && !this[eventName]) return;
		
		for(var args=[],i=1;i<arguments.length;i++) args.push(arguments[i]);
		if(this[eventName]) result = this[eventName].apply(this, args); //Backwards compatibility
		if(!arr) return result;
		
		for(var retValue, i=0;i<arr.length;i++){
			retValue = arr[i].apply(this, args);
			if(retValue != undefined) result = retValue;
		}
		
		return result;
	}
	this.addEventListener = function(eventName, func){
		if(!events_stack[eventName]) events_stack[eventName] = [];
		events_stack[eventName].pushUnique(func);
	}
	this.removeEventListener = function(eventName, func){
		if(events_stack[eventName]) events_stack[eventName].remove(func);
	}
	this.hasEventListener = function(eventName){
		return events_stack[eventName] && events_stack[eventName].length > 0;
	}
	
	this.destroy = function(){
		if(!this.uniqueId) return;
		
		if(this.__destroy) this.__destroy();
		
		for(var i=this.__jmlDestroyers.length-1;i>=0;i--)
			this.__jmlDestroyers[i].call(this);
		this.__jmlDestroyers = undefined;
		
		if(this.oExt && !this.oExt.isNative && this.oExt.nodeType == 1) this.oExt.host = null;
		if(this.oInt && !this.oExt.isNative && this.oInt.nodeType == 1) this.oInt.host = null;
		
		this.jml = null;
		
		// Remove from Kernel.all
		Kernel.all[this.uniqueId] = null;
		this.uniqueId = null;
	}
	
	
	this.destroySelf = function(){
		if(!this.hasFeature) return;
		
		//Update JMLDOMApi as well
		
		// Remove id from global js space
		if(this.name) self[this.name] = null;
	
		// Remove from window.onresize - Should be in Anchoring or Alignment
		if(this.hasFeature(__ANCHORING__)) this.disableAnchoring();
		if(this.hasFeature(__ALIGNMENT__)) this.disableAlignment();
		
		// Remove dynamic properties - Should be in Class (clear events???)
		this.unbindAllProperties();
		
		// Remove data connections - Should be in DataBinding
		if(this.dataParent) this.dataParent.parent.disconnect(this);
		if(this.hasFeature(__DATABINDING__)){
			this.unloadBindings();
			this.unloadActions();
		}
		if(this.hasFeature(__DRAGDROP__))
			this.unloadDragDrop();
		
		// Remove from focus list - Should be in JmlNode
		if(this.focussable) me.__removeFocus(this);
		
		// Remove from multilang list listener (also on skin switching) - Should be in MultiLang
		if(this.hasFeature(__MULTILANG__)) this.__removeEditable();
		
		//Remove all cached Items - Should be in Cache
		if(this.hasFeature(__CACHE__)) this.clearAllCache();
		
		if(this.childNodes){
			for(var i=0;i<this.childNodes.length;i++){
				if(this.childNodes[i].destroySelf)
					this.childNodes[i].destroySelf();
				else
					Kernel.removeNode(this.childNodes[i].oExt);
			}
		}
		
		if(this.destroy) this.destroy();
	}
}

/*FILEHEAD(/in/Core/Kernel/Print.js)SIZE(2501)TIME(1168308019160)*/

PrintServer = {
	lastContent : "",
	inited : false,
	
	init : function(){
		this.inited = true;
		this.contentShower = document.body.appendChild(document.createElement("DIV"));
		this.contentShower.id = "print_content"
		
		//LATER REPLACE THIS BY A SKIN
		with(this.contentShower.style){
			/*position = "absolute";
			left = "0px";
			top = "0px";*/
			width = "100%";
			height = "100%";
			backgroundColor = "white";
			zIndex = 100000000;
			//if(IS_IE) display = "none";
		}
		
		//if(!IS_IE){
			Kernel.importCssString(document, "#print_content{display:none}");
			Kernel.importCssString(document, "body #print_content, body #print_content *{display:block} body *{display:none}", "print");
			
			/*styleElement = document.createElement('style');
			styleElement.type = 'text/css';
			styleElement.media = 'print';
			styleElement.appendChild(document.createTextNode("#print_content {display:block}"));
			document.getElementsByTagName('head').item(0).appendChild(styleElement);*/
		//}
	},
	
	printContent : function(v){
		this.setContent(v);
		this.print();
	},
	
	setContent : function(v){
		if(!this.inited) this.init();
		this.lastContent = v;
		//if(!IS_IE) 
		this.contentShower.innerHTML = v;
	},
	
	print : function(){
		window.print();
	}
}
/*
window.onbeforeprint = function(){
	if(!PrintServer.lastContent && PrintServer.onbeforeprint) PrintServer.onbeforeprint();

	if(PrintServer.lastContent){
		PrintServer.contentShower.innerHTML = PrintServer.lastContent;
		PrintServer.lastContent = false;
		
		this.hidden = [];
		for(var i=0;i<document.body.childNodes.length;i++){
			if(document.body.childNodes[i].nodeType != 1) continue;
			
			if(document.body.childNodes[i].style.display == "none") 
				this.hidden.push(document.body.childNodes[i])
			document.body.childNodes[i].style.display = "none";
		}
		PrintServer.contentShower.style.display = "block";
	}
}

window.onafterprint = function(){
	if(PrintServer.inited){
		for(var i=0;i<document.body.childNodes.length;i++) {
			if(document.body.childNodes[i].nodeType != 1) continue;
			
			document.body.childNodes[i].style.display = "block";
		}
			
		for(var i=0;i<this.hidden.length;i++) 
			this.hidden[i].style.display = "none";
		
		PrintServer.contentShower.style.display = "none";
		if(self.hider) hider.style.display = "none";
		
		if(PrintServer.onafterprint) PrintServer.onafterprint();
	}
}*/


/*FILEHEAD(/in/Core/Kernel/Sort.js)SIZE(6362)TIME(1179307594016)*/

//<Traverse select="" sort="@blah" data-type={"string" | "number" | "date"} date-format="" sort-method="" order={"ascending" | "descending"} case-order={"upper-first" | "lower-first"} />
/*
	<Traverse select="group|contact" sort="self::group/@name|self::contact/screen/text()" order="ascending" case-order="upper-first" />
	<Traverse select="group|contact" sort="@date" date-format="DD-MM-YYYY" order="descending"/>
	<Traverse select="group|contact" sort-method="compare" />
*/
function Sort(xmlNode){
	var sort_intmask = ["", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "00000000000", "000000000000", "0000000000000", "00000000000000" ];
	var isAscending, xpath, type, method, getNodes, dateFormat, dateReplace, sort_dateFmtStr, getValue;

	//use this function to parse the traverse node
	this.parseXml = function(xmlNode){
		isAscending = xmlNode.getAttribute("order") != "descending";
		xpath = xmlNode.getAttribute("sort");
		getNodes = self[xmlNode.getAttribute("nodes-method")];
		getValue = function(item){return getXMLValue(item, xpath);}
		
		if(xmlNode.getAttribute("type")) method = eval("sort_" + xmlNode.getAttribute("type"));
		if(xmlNode.getAttribute("sort-method")) method = self[xmlNode.getAttribute("sort-method")];
		if(!method) method = sort_alpha;
		
		var str = xmlNode.getAttribute("date-format"); 
		if(str){
			sort_dateFmtStr = str;
			var result = str.match(/(D+|Y+|M+|h+|m+|s+)/g);
			if(result) {
				for(var pos={},i=0;i<result.length;i++) pos[result[i].substr(0,1)] = i+1;
				dateFormat = new RegExp(str.replace(/[^\sDYMhms]/g,'\\$1').replace(/YYYY/, "(\\d\\d\\d\\d)").replace(/(DD|YY|MM|hh|mm|ss)/g, "(\\d\\d)"));
				dateReplace = "$" + pos["M"] + "/$" + pos["D"] + "/$" + pos["Y"];
				if(pos["h"]) dateReplace += " - $"+pos["h"]+":$"+pos["m"]+":$"+pos["s"];
			}
		}
	}
	if(xmlNode) this.parseXml(xmlNode);
	
	this.set = function(struct){
		var prop, x;
		for(prop in struct){
			x = struct[prop];
			eval(prop + " = x;");
		}

		if(struct["type"]) method = eval("sort_" + struct["type"]);
		if(struct["method"]) method = struct["method"];
		if(!method) method = sort_alpha;
	}
	
	//use this function in __xmlUpdate [this function isnt done yet]
	this.findSortSibling = function(pNode, xmlNode){
		var nodes = getNodes ? getNodes(pNode, xmlNode) : this.getTraverseNodes(pNode);

		for(var i=0;i<nodes.length;i++)
			if(!compare(xmlNode, nodes[i], true, sortSettings))
				return nodes[i];
	
		return null;
	}
	
	// Sorting methods for sort()
  	function sort_alpha(n)  { return n.toString().toLowerCase() }
	function sort_number(t){
	  	return (t.length < sort_intmask.length ? sort_intmask[sort_intmask.length - t.length] : "") + t;
	}
	function sort_date(t,args){
		if(!sort_dateFormat || (args && sort_dateFmtStr!=args[0])) sort_dateFmt(args? args[0] : "*");
		
		var d;
		if(sort_dateFmtStr == '*') d = Date.parse(t);
		else d = (new Date(t.replace(sort_dateFormat, sort_dateReplace))).getTime();
		t = ""+parseInt(d); if(t=="NaN")t="0";
		return (t.length < sort_intmask.length ? sort_intmask[sort_intmask.length - t.length] : "") + t;
	}
	
	/*
		sort(xpath, sort_xpath, sort_alpha, boolDesc, from, len)
		jsort(n,f,p,ps,sm,desc,sp,ep)
	*/
	
	//var isAscending, xpath, type, method, getNodes, dateFormat, dateReplace, sort_dateFmtStr, getValue;
	this.apply = function(n, args, func, start, len){
		var sa = [], i = n.length;

		// build string-sortable list with sort method
		while(i--){
			var v = getValue(n[i]);
			if(n) sa[sa.length] = {toString:function(){return this.v;}, pn:n[i], v:method(v, args)};
		}
		
		// sort it
		sa.sort();
		
		//iterate like foreach
		end = len ? Math.min(sa.length, start+len) : sa.length;
		if(!start) start = 0;
		
		if(func){
			if(isAscending) for(i = start;i<end;i++) f(i,end,sa[i].pn,sa[i].v);
			else for(i = end-1;i>=start;i--) f(end-i-1,end,sa[i].pn,sa[i].v);
		}
		else{
			//this could be optimized by reusing n... time it later
			var res = [];
			if(isAscending) for(i = start;i<end;i++) res[res.length] = sa[i].pn;
			else for(i = end-1;i>=start;i--) res[res.length] = sa[i].pn;
			return res;
		}
	}
	
	/*Implement this api for JSON support
	function jsort(n,f,p,ps,sm,desc,sp,ep){
		sm = sm ? sm : sort_alpha;
		var sa = [], t = n.selectNodes(p), i = t.length, args = null;
		if(typeof sm != "function"){var m = sm.shift();args = sm; sm = m;}		

		// build string-sortable list with sort method
		while(i--){
			var n = getValue(t[i]);
			if(n) sa[sa.length] = {toString:function(){return this.v;}, pn:t[i], v:sm(n,args)};
		}
		// sort it
		sa.sort();
		
		//iterate like foreach
		var end = ep==null?sa.length:Math.min(sa.length,(sp+ep));
		var start = (sp==null)?0:sp;
		if(desc){
			for(var i = end-1;i>=start;i--)f(end-i-1,end,sa[i].pn,sa[i].v);
		}else{
			for(var i = start;i<end;i++)f(i,end,sa[i].pn,sa[i].v);
		}
	}*/
}

/*

	//ebuddy sorting
	function compare(xmlNode1, xmlNode2, testEqual){
		//if(testEqual) return n1>=n2;
		//return (n1>n2);
	
		if(!xmlNode1) return true;
		if(!xmlNode2) return false;
		if(xmlNode1.tagName == "group"){
			var str1 = xmlNode1.getAttribute("name").toLowerCase();
			var str2 = xmlNode2.getAttribute("name").toLowerCase();
		}
		else{
			var str3 = xmlNode1.selectSingleNode("status/text()").nodeValue;
			var str4 = xmlNode2.selectSingleNode("status/text()").nodeValue;
			if(str3 == "FLN" && str4 != "FLN") return true;
			if(str3 != "FLN" && str4 == "FLN") return false;
		
			var str1 = xmlNode1.selectSingleNode("screen/text()").nodeValue.toLowerCase();
			var str2 = xmlNode2.selectSingleNode("screen/text()").nodeValue.toLowerCase();
		}
	
		if(testEqual && str1 == str2) return true;
	
		var len = Math.max(str1.length, str2.length);
		for(var i=0;i<len;i++) if(str1.charCodeAt(i) != str2.charCodeAt(i)){
			if(!str1.charCodeAt(i)) return true;
			return str1.charCodeAt(i) > str2.charCodeAt(i);
		}
	
		return false;
	}
	
	//ebuddy
	function getNodes(pNode, xmlNode){
		return doGroup ?
			pNode.selectNodes("group[@name]") :
			pNode.selectNodes("contact[" + (getXMLValue(xmlNode, "status/text()") == "FLN" ? "status/text()='FLN'" : "not(status/text()='FLN')") + "]");
	}
	
*/

/*FILEHEAD(/in/Core/Kernel/Debug.js)SIZE(18714)TIME(1184600970722)*/

function issueWarning(nr, msg){
	if(!self.DEBUG) return;
	
	//needs implementation
	if(Kernel.warnings[msg]) return;

	//var seeAgain = confirm("Javelin Notification\nA warning has been issued\n\nNumber: " + nr + "\nWarning: " + msg + "\n\nPress OK to see this warning again.");
	//if(!seeAgain) Kernel.warnings[msg] = true;
	
	setStatus("[Warning - " + nr + "]:<br />" + msg.replace(/\n/g, "<br />") + "<br />");
	Kernel.warnings[msg] = true;
}

function vardump(obj, depth, recur){
	if(!obj) return obj + "";
	if(!depth) depth = 0;

	switch(obj.dataType){
		case "string":	return "\"" + obj + "\"";
		case "number":	return obj;
		case "boolean": return obj ? "true" : "false";
		case "date": return "Date[" + new Date() + "]";
		case "array":
			var str = "{\n";
			for(var i=0;i<obj.length;i++){
				str += "     ".repeat(depth+1) + i + " => " + (!recur && depth > 0 ? typeof obj[i] : vardump(obj[i], depth+1, !recur)) + "\n";
			}
			str += "     ".repeat(depth) + "}";
			
			return str;
		default:
			if(typeof obj == "function") return "function";
			if(obj.xml) return depth==0 ? "[ " + obj.xml + " ]" : "XML Element";
			if(!recur && depth>0) return "object";
		
			//((typeof obj[prop]).match(/(function|object)/) ? RegExp.$1 : obj[prop])
			var str = "{\n";
			for(prop in obj){
				try{
					str += "     ".repeat(depth+1) + prop + " => " + (!recur && depth > 0? typeof obj[prop] : vardump(obj[prop], depth+1, !recur)) + "\n";
				}catch(e){
					str += "     ".repeat(depth+1) + prop + " => [ERROR]\n";
				}
			}
			str += "     ".repeat(depth) + "}";
			
			return str;
	}
}

function alert_r(obj, recur){
	alert(vardump(obj, null, !recur));
}

Profiler = {
	totalTime : 0,
	start : function(clear){
		if(clear) this.totalTime = 0;
		this.startTime = new Date();
		
		this.isStarted = true;
	},
	end : function(){
		if(!this.startTime) return;
		var startTime = this.startTime;
		var endTime = new Date();
		this.totalTime += (endTime.getMinutes()-startTime.getMinutes())*60000+(endTime.getSeconds()-startTime.getSeconds())*1000+(endTime.getMilliseconds()-startTime.getMilliseconds());
		
		this.isStarted = false;
	},
	addPoint : function(msg){
		this.end();
		setStatus("[TIME] " + msg + ": " + this.totalTime + "ms");
		this.start(true);
	}
}
         
var DEBUG_SCREEN;
function setDebug(value){
	if(!DEBUG_SCREEN){
		DEBUG_SCREEN = top.document.body.appendChild(document.createElement("DIV"));
		with(DEBUG_SCREEN.style){
			backgroundColor = "white";
			fontFamily = "Arial";
			fontSize  = "8pt";
			color = "black";
			border = "2px inset white";
			width = "500px";
			height = "200px";
			overflow = "auto";
			position = "absolute";
			left = "0px";
			bottom = "0px";
			zIndex = 100000;
		}  
	}     
	      
	DEBUG_SCREEN.innerHTML = value.replace(/\n/, "<br>");
}        
         
function analyzeObject(o){
	str = "<table>";
	for(prop in o) str += "<tr><td vAlign='top' style='font-family:Arial;font-size:8pt'>" + prop + "</td><td style='font-family:Arial;font-size:8pt'>" + (typeof o[prop] == "function" ? "<b>function</b>" : (prop == "innerHTML" || prop == "outerHTML" || prop == "innerText" || prop == "outerText" || prop == "altHTML"  ? "<b>CONTENTS</b>" : o[prop])) + "</td></tr>";
	setDebug(str + "</table>");
}

/**************** DEBUGGER ********************/

TYPE_OBJECT = "object";
TYPE_NUMBER = "number";
TYPE_STRING = "string";
TYPE_ARRAY = "array";
TYPE_DATE = "date";
TYPE_REGEXP = "regexp";
TYPE_BOOLEAN = "boolean";
TYPE_FUNCTION = "function";
TYPE_DOMNODE = "dom node";
TYPE_JAVNODE = "Javeline Component";

STATE_UNDEFINED = "undefined";
STATE_NULL = "null";
STATE_NAN = "nan";
STATE_INFINITE = "infinite";

function getType(variable){
	if(variable === null) return STATE_NULL;
	if(variable === undefined) return STATE_UNDEFINED;
	if(typeof variable == "number" && isNaN(variable)) return STATE_NAN;
	if(typeof variable == "number" && !isFinite(variable)) return STATE_INFINITE;

	if(typeof variable == "object"){
		if(variable.hasFeature) return TYPE_JAVNODE;
		if(variable.tagName || variable.nodeValue) return TYPE_DOMNODE;
	}
	
	if(variable.dataType == undefined) return TYPE_OBJECT;
	
	return variable.dataType;
}

function isType(variable){
	if(variable == null) return false;
	if(variable == undefined) return false;
	if(variable.type == TYPE_NUMBER && isNaN(variable)) return false;
	
	return true;
}

var DebugInfoStack = [];
Function.prototype.toHTMLNode = function(highlight){
	var code, line1, line2;
	
	//anonymous
	code = this.toString();
	endLine1 = code.indexOf("\n"); 
	line1 = code.slice(0, endLine1);
	line2 = code.slice(endLine1+1);
	
	res = /^function(\s+(.*?)\s*|\s*?)\((.*)\)(.*)$/.exec(line1);
	if(res){
		var name = res[1];
		var args = res[3];
		var last = res[4];

		if(this.arguments){
			var argName, namedArgs = args.split(",");
			args = [];

			for(i=0;i<this.arguments.length;i++){
				//if(i != 0 && arr[i]) args += ", ";
				argName = (namedArgs[i].trim() || "__NOT_NAMED__");// args += "<b>" + arr[i] + "</b>";
				
				var info = ["Name: " + argName];
				var id = DebugInfoStack.push(info) - 1;
				
				args.push("<a href='javascript:void(0)' onclick='alert(DebugInfoStack[" + id + "].join(\"\\n\"));event.cancelBubble=true;'>" + argName + "</a>");
				info.push("Type: " + getType(this.arguments[i]));
				info.push("Value: " + vardump(this.arguments[i], null, true));
			}	
		}

		line2 = line2.replace(/\{/ , "");
		line2 = line2.substr(0, line2.length-2);

		if(!highlight){
			line2 = line2.replace(/ /g, "&nbsp;");
			line2 = line2.replace(/\t/g, "&nbsp;&nbsp;&nbsp;");
			line2 = line2.replace(/\n/g, "</nobr><br><nobr>&nbsp;&nbsp;&nbsp;");
			line2 = "{<br><nobr>&nbsp;&nbsp;&nbsp;" + line2 + "</nobr><br>}";
		}
		else{
			line2 = "{\n" + line2 + "\n}\n";
			var div = dp.SyntaxHighlighter.HighlightString(line2, false, false);
		}
		
		var d = document.createElement("div");
		res = "<div><div style='padding:0px 0px 2px 0px;cursor:default;' onclick='obj = this.lastChild.style;if(obj.display == \"block\"){obj.display = \"none\";this.firstChild.firstChild.src=\"images/debug_arrow_right.gif\"}else{obj.display = \"block\";this.firstChild.firstChild.src=\"images/debug_arrow_down.gif\"};event.cancelBubble=true'><nobr><img width='9' height='9' src='images/debug_arrow_right.gif' style='margin:0 3px 0 2px;' />"+(name.trim()||"function")+"("+args.join(", ")+")&nbsp;</nobr><div onclick='event.cancelBubble=true' onselectstart='event.cancelBubble=true' style='cursor:text;display:none;padding:0px;background-color:#EAEAEA;color:#222222;overflow:auto;margin-top:2px;'><blockquote></blockquote></div></div></div>";
		d.innerHTML = res;
		var b = d.getElementsByTagName("blockquote")[0];
		
		if(highlight){
			b.replaceNode(div);
		}
		else{
			b.insertAdjacentHTML("beforeBegin", line2);
			b.parentNode.removeChild(b);
		}

		return d.firstChild;
	}
	else{
		return this.toString();
	}
}

/******************
** Error Handler **
******************/
if(getcookie("highlight") != "false" && self.BASEPATH){
	//<script class="javascript" src="../Library/Core/Highlighter/shCore.uncompressed.js"></script>
	//<script class="javascript" src="../Library/Core/Highlighter/shBrushJScript.js"></script>
	include(BASEPATH + "Library/Core/Highlighter/shCore.uncompressed.js");	
	include(BASEPATH + "Library/Core/Highlighter/shBrushJScript.js");	
	//<link type="text/css" rel="stylesheet" href="../Library/Core/Highlighter/SyntaxHighlighter.css" />
	Kernel.loadStylesheet(BASEPATH + "Library/Core/Highlighter/SyntaxHighlighter.css");
}
else if(self.SyntaxHighlighterCSS){
	Kernel.importCssString(document, SyntaxHighlighterCSS);	
}
else{
	setcookie("highlight", false)
}

function __DEBUGERR(e, filename, linenr){
	var list = [], seen = {};
	
	//Opera doesnt support caller... weird...
	try{
		var loop = end = IS_IE ? __DEBUGERR.caller.caller : __DEBUGERR.caller.caller ? __DEBUGERR.caller.caller.caller : __DEBUGERR.caller.caller;
		if(loop){
			try{
				do{
					if(seen[loop.toString()]) break; //recursion checker
					seen[loop.toString()] = true;
					//str += loop.toHTML();
					list.push(loop.toHTMLNode(getcookie("highlight") != "false"));
					loop = loop.caller;
				}while(list.length < 30 && loop && loop.caller && loop.caller.caller != loop);
			}catch(a){
				list=[];	
			}
		}
	}
	catch(e){}
	
	errorInfo = "Exception caught on line " + linenr + " in file " + filename + "<br>Message: " + e.message;
		
	e.lineNr = linenr;
	e.fileName = filename;

	__JavDispError(e, list, errorInfo);//str
	
	//window.onerror = function(){window.onerror=null;return true}
	//throw new Error(0, "Stopping Error Prosecution");
}

var winError, USE_DEBUGGER = getcookie("debugger") == "true";
function __JavDispError(e, stackTrace, errorInfo){;
	if(!winError){
		var elError = document.getElementById("javerror");
		if(!elError){
			if(document.body){
				elError = document.body.appendChild(document.createElement("div"));
				elError.id = "javerror";
			}
			else{
				document.write("<div id='javerror'></div>");
				elError = document.getElementById("javerror");
			}
			
			elError.style.position = "absolute";
	 		elError.style.zIndex = 10000000;
			elError.style.right = "10px";
			elError.style.top = "10px";
			elError.style.border = "2px outset";
			elError.style.MozBorderBottomColors = "black gray";
			elError.style.MozBorderRightColors = "black gray";
			elError.style.MozBorderTopColors = "#C0C0C0 #FFFFFF";
			elError.style.MozBorderLeftColors = "#C0C0C0 #FFFFFF";
			elError.style.padding = "10px";
			elError.style.width = "600px";
			elError.style.background = "#D4D0C8 url(images/appbg.gif)";
		}
		
		document.body.style.display = "block";
		
		elError.style.display = "block";
		var parse = e.message.split(/\n===\n/);
		var errorMessage = parse[0].replace(/---- Javeline Error ----\n/g, "").replace(/</g, "&lt;").replace(/Message: \[(\d+)\]/g, "Message: [<a title='Visit the manual on error code $1' style='color:blue;text-decoration:none;' target='_blank' href='http://developer.javeline.net/projects/platform/wiki/ErrorCodes#$1'>$1</a>]").replace(/(\n|^)([\w ]+:)/gm, "$1<strong>$2</strong>").replace(/\n/g, "<br />");
		var jmlContext = formatXML(parse[1] ? parse[1].trim(true) : "").replace(/</g, "&lt;").replace(/\n/g, "<br />").replace(/\t/g, "&nbsp;&nbsp;&nbsp;");;

		elError.innerHTML = 
			"<span onclick='this.parentNode.style.display=\"none\"' style='cursor:hand;cursor:pointer;float:right;margin:0px;font-size:8pt;font-family:Verdana;width:14px;text-align:center;height:14px;overflow:hidden;border:1px solid gray;color:gray;background-color:#EEEEEE;padding:0'>X</span><h1 style='font-size:14pt;font-family:Arial;margin-bottom:10px;margin-top:0;color:black;'><strong>An error has occurred in this application:</strong></h1>" +
			"<div onselectstart='event.cancelBubble=true' style='border:1px solid black;padding:4px;font-family:Arial;font-size:10pt;background-color:white;margin-bottom:5px;'>" + errorMessage + "</div>" + 
			(jmlContext ? "<div style='cursor:default;border:1px solid gray;padding:4px;font-family:MS Sans Serif;font-size:8pt;background-color:#DDDDDD;margin-bottom:1px;' onclick='obj = this.lastChild.style;if(obj.display == \"block\"){obj.display = \"none\";this.firstChild.src=\"images/debug_arrow_right.gif\"}else{obj.display = \"block\";this.firstChild.src=\"images/debug_arrow_down.gif\"}'><img width='9' height='9' src='images/debug_arrow_down.gif' />&nbsp;<strong>Javeline Markup Language</strong><br /><div onclick='event.cancelBubble=true' onselectstart='event.cancelBubble=true' style='border:1px solid red;cursor:text;background-color:white;padding:4px 4px 20px 4px;font-size:9pt;font-family:Courier New;margin:3px;border:1px solid gray;max-height:200px;white-space:nowrap;overflow:auto;'>" + jmlContext + "</div></div>" : "") +
			"<div style='cursor:default;border:1px solid gray;padding:4px;font-family:MS Sans Serif;font-size:8pt;background-color:#DDDDDD;margin-bottom:1px;' onclick='obj = this.lastChild.style;if(obj.display == \"block\"){obj.display = \"none\";this.firstChild.src=\"images/debug_arrow_right.gif\"}else{obj.display = \"block\";this.firstChild.src=\"images/debug_arrow_down.gif\"};'><div style='margin-right:5px;float:right;margin-top:-4px;'><input id='cbHighlight' type='checkbox' onclick='toggleHighlighting(this.checked);event.cancelBubble = true;' " + (getcookie("highlight") != "false" ? "checked='checked'" : "") + "/><label for='cbHighlight' style='top:-2px;position:relative;' onclick='event.cancelBubble=true'>Enable Syntax Coloring</label></div><img width='9' height='9' src='images/debug_arrow_right.gif' />&nbsp;<strong>Stack Trace</strong><br /><div style='display:none;background-color:white;padding:4px;font-size:9pt;font-family:Courier New;margin:3px;border:1px solid gray;'><blockquote></blockquote></div></div>" +
			"<div style='cursor:default;border:1px solid gray;padding:4px;font-family:MS Sans Serif;font-size:8pt;background-color:#DDDDDD;margin-bottom:1px;' onclick='obj = this.lastChild.style;if(obj.display == \"block\"){obj.display = \"none\";this.firstChild.nextSibling.src=\"images/debug_arrow_right.gif\"}else{obj.display = \"block\";this.firstChild.nextSibling.src=\"images/debug_arrow_down.gif\";this.lastChild.scrollTop=this.lastChild.scrollHeight};'><div style='margin-right:5px;float:right;margin-top:-4px;'><input id='cbTW' type='checkbox' onclick='toggleLogInWindow(this.checked);event.cancelBubble = true;' " + (getcookie("viewinwindow") == "true" ? "checked='checked'" : "") + "/><label for='cbTW' style='top:-2px;position:relative;' onclick='event.cancelBubble=true'>View in window</label></div><img width='9' height='9' src='images/debug_arrow_right.gif' />&nbsp;<strong>Log Viewer</strong><br /><div id='jvlnviewlog' onclick='event.cancelBubble=true' onselectstart='event.cancelBubble=true' style='display:none;height:150px;overflow:auto;cursor:text;background-color:white;padding:4px;font-size:9pt;font-family:Courier New;margin:3px;border:1px solid gray;'>" + Kernel.DEBUG_INFO.replace(/\n/g, "<br />") + "</div></div>" +
			"<div style='cursor:default;border:1px solid gray;padding:4px;font-family:MS Sans Serif;font-size:8pt;background-color:#DDDDDD;margin-bottom:1px;' onclick='obj = this.lastChild.style;if(obj.display == \"block\"){obj.display = \"none\";this.firstChild.src=\"images/debug_arrow_right.gif\"}else{obj.display = \"block\";this.firstChild.src=\"images/debug_arrow_down.gif\";this.lastChild.firstChild.focus()};'><img width='9' height='9' src='images/debug_arrow_right.gif' />&nbsp;<strong>Javascript console</strong><br /><div style='display:none' onclick='event.cancelBubble=true'><textarea onkeydown='if(event.keyCode == 9){this.nextSibling.focus();event.cancelBubble=true;return false;}' onselectstart='event.cancelBubble=true' style='background-color:white;padding:4px;font-size:9pt;font-family:Courier New;margin:3px;border:1px solid gray;width:575px;height:100px;'>" + getcookie("jsexec") + "</textarea><button onclick='jRunCode(this.previousSibling.value)' style='font-family:MS Sans Serif;font-size:8pt;margin:0 0 0 3px;' onkeydown='if(event.shiftKey && event.keyCode == 9){this.previousSibling.focus();event.cancelBubble=true;return false;}'>Execute</button></div></div>" +
			"<br style='line-height:5px'/><input id='toggledebug' type='checkbox' onclick='toggleDebugger(this.checked)' /><label for='toggledebug' style='font-family:MS Sans Serif;font-size:8pt;'>Use browser's debugger</label>"
		var b = elError.getElementsByTagName("blockquote")[0];
		//" || "No stacktrace possible").replace(/\n/g, "<br />") + "
		if(stackTrace.length){
			for(var i=0;i<stackTrace.length;i++)
				b.parentNode.insertBefore(stackTrace[i], b);
			b.parentNode.removeChild(b);
		}
		else b.replaceNode(document.createTextNode("No stacktrace possible"));
		
		Kernel.ondebug = function(str){
			var logView = document.getElementById("jvlnviewlog");
			if(!logView) return;
			
			logView.insertAdjacentHTML("beforeend", str);
			logView.style.display = "block";
			logView.scrollTop = logView.scrollHeight;
		}
		
		clearInterval(Init.interval);
		ERROR_HAS_OCCURRED = true;
	}
}

function jRunCode(code){
	setcookie("jsexec", code);
	
	if(USE_DEBUGGER){
		var x = eval(code) || "";
		try{setStatus(x.toString().replace(/</g, "&lt;").replace(/\n/g, "<br />"));}catch(e){setStatus(x ? "Could not serialize object" : x)}
	}
	else{
		try{
			var x = eval(code) || "";
			try{setStatus(x.toString().replace(/</g, "&lt;").replace(/\n/g, "<br />"));}catch(e){setStatus(x ? "Could not serialize object" : x)}
		}
		catch(e){setStatus("[ERROR] " + e.message)}
	}
}

function toggleLogInWindow(checked){
	if(checked){
		DEBUG_TYPE = "window";
		Kernel.win = window.open("", "debug");
		Kernel.win.document.write(Kernel.DEBUG_INFO);
	}
	else DEBUG_TYPE = "memory";
	
	if(self.setcookie) setcookie("viewinwindow", checked)
}
DEBUG_TYPE = "memory";//getcookie("viewinwindow") == "true" ? "window" : "memory";

function toggleHighlighting(checked){
	setcookie("highlight", checked);
}

function toggleDebugger(checked){
	USE_DEBUGGER = checked;

	if(self.setcookie) setcookie("debugger", checked)
	
	if(!checked) window.onerror = __ErrorHandler;
	else window.onerror = null; 
}

function __ErrorHandler(message, filename, linenr){
	if(!message) message = "";
	e = {
		message : "js file: [line: " + linenr + "] " + removePathContext(HOST_PATH, filename) + "\n" + message
	}
	
	setStatus("[ERROR on line " + linenr + "]:<br />" + message.split(/\n\n===\n/)[0].replace(/</g, "&lt;").replace(/\n/g, "<br />") + "<br />");
	__DEBUGERR(e, filename, linenr);
	return true;
}
if(!USE_DEBUGGER) window.onerror = __ErrorHandler

if(!USE_DEBUGGER && (IS_OPERA || IS_SAFARI)){
	Error = function(nr, msg){
		__ErrorHandler(msg, location.href, 0);
	}
}

Kernel.ondebugkey = function(keyCode, ctrlKey, shiftKey, altKey){
	//ctrlKey && keyCode == 71 || ctrlKey && altKey && keyCode == 68
	if(keyCode == 120 || ctrlKey && altKey && keyCode == 68){
		toggleDebugger(false);

		if(document.getElementById("javerror")) document.getElementById("javerror").style.display = "block";
		else __ErrorHandler("User initiated error", location.href, 0);//setTimeout('throw new Error(0, "User initiated error");');
	}
}

/**************** END DEBUGGER ********************/


/*FILEHEAD(/in/Core/Kernel/Patches.js)SIZE(14146)TIME(1188900006250)*/

Kernel.compat = {
	maxWidth : 0,
	maxHeight : 0,
	
	getNumber : function(pos){
		return (/^\d+/.exec(pos) ? parseInt(RegExp.$1) : 0)
	},
	
	getBox : function(value){
		if(value == null || (!parseInt(value) && parseInt(value) != 0)) return [0,0,0,0];

		var x = value.split(" ");
		for(var i=0;i<x.length;i++) x[i]=parseInt(x[i]) || 0;
		switch(x.length){
			case 1:x[1]=x[0];x[2]=x[0];x[3]=x[0];break;
			case 2:x[2]=x[0];x[3]=x[1];break;
			case 3:x[3]=x[1];break;
		}

		return x;
	},
	
	getFirstElement : function(xmlNode){
		try{xmlNode.firstChild.nodeType == 1 ? xmlNode.firstChild : xmlNode.firstChild.nextSibling}catch(e){
			throw new Error(1052, Kernel.formErrorString(1052, null, "Skinning Engine", "Could not find first element for skin:\n" + (xmlNode ? xmlNode.xml : "null")));
		}

		return xmlNode.firstChild.nodeType == 1 ? xmlNode.firstChild : xmlNode.firstChild.nextSibling;
	},

	getLastElement : function(xmlNode){
		try{xmlNode.lastChild.nodeType == 1 ? xmlNode.lastChild : xmlNode.lastChild.nextSibling}catch(e){
			throw new Error(1053, Kernel.formErrorString(1053, null, "Skinning Engine", "Could not find last element for skin:\n" + (xmlNode ? xmlNode.xml : "null")));
		}

		return xmlNode.lastChild.nodeType == 1 ? xmlNode.lastChild : xmlNode.lastChild.previousSibling;
	},

	/*
	HTMLElement.prototype.__defineGetter__("runtimeStyle", function() {
		return document.defaultView.getComputedStyle(this, null);
	});
	*/
	getStyle : function(el, prop) {
		if(
			typeof document.defaultView != "undefined" && 
			typeof document.defaultView.getComputedStyle != "undefined"
		){
			var cStyle = document.defaultView.getComputedStyle(el,'');
			return !cStyle ? "" : cStyle.getPropertyValue(prop);
		}
			
		return el.currentStyle[prop];
	},
	
	isInRect : function(oHtml, x, y){
		var pos = this.getAbsolutePosition(oHtml);
		if(x < pos[0] || y < pos[1] || x > oHtml.offsetWidth + pos[0] - 10 || y > oHtml.offsetHeight + pos[1] - 10) return false;
		return true;
	},
	
	getWidthDiff : function(oHtml){
		return IS_IE ? 
			Math.max(0, (parseInt(Kernel.compat.getStyle(oHtml, "paddingLeft"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "paddingRight"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "borderLeftWidth"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "borderRightWidth"))||0)) :
			Math.max(0, oHtml.offsetWidth - parseInt(Kernel.compat.getStyle(oHtml, "width")));
	},
	
	getHeightDiff : function(oHtml){
		return IS_IE ? 
			Math.max(0, (parseInt(Kernel.compat.getStyle(oHtml, "paddingTop"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "paddingBottom"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "borderTopWidth"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "borderBottomWidth"))||0)) :
			Math.max(0, oHtml.offsetHeight - parseInt(Kernel.compat.getStyle(oHtml, "height")));
	},
	
	getDiff : function(oHtml){
		if(!IS_IE && oHtml.tagName == "INPUT") return [6,6];
		
		var pNode;
		if(!oHtml.offsetHeight){
			pNode = oHtml.parentNode; var nSibling = oHtml.nextSibling;
			document.body.appendChild(oHtml);
		}

		var diff = IS_IE ? 
			[
				Math.max(0, (parseInt(Kernel.compat.getStyle(oHtml, "paddingLeft"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "paddingRight"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "borderLeftWidth"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "borderRightWidth"))||0)),
				Math.max(0, (parseInt(Kernel.compat.getStyle(oHtml, "paddingTop"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "paddingBottom"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "borderTopWidth"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "borderBottomWidth"))||0))
			] :
			[
				Math.max(0, oHtml.offsetWidth - parseInt(Kernel.compat.getStyle(oHtml, "width"))),
				Math.max(0, oHtml.offsetHeight - parseInt(Kernel.compat.getStyle(oHtml, "height")))
			];
		
		if(pNode) pNode.insertBefore(oHtml, nSibling);
		
		return diff;
	},
	
	getOverflowParent : function(o){
		//not sure if this is the correct way. should be tested
		
		var o = o.offsetParent;
		while(o && o.tagName.toLowerCase() != "body" && this.getStyle(o, "overflow") != "hidden"){
			o = o.offsetParent;
		}
		return o || document.documentElement;
	},
	
	getAbsolutePosition : function(o, refParent, inclSelf){
		var s, wt = inclSelf ? 0 : o.offsetLeft, ht = inclSelf ? 0 : o.offsetTop;
		var o = inclSelf ? o : o.offsetParent;
		while(o && o.tagName.toLowerCase() != "body" && o != refParent){
			wt += (IS_OPERA ? 0 : parseInt(this.getStyle(o, IS_IE ? "borderLeftWidth" : "border-left-width")) || 0) + o.offsetLeft;
			ht += (IS_OPERA ? 0 : parseInt(this.getStyle(o, IS_IE ? "borderTopWidth" : "border-top-width")) || 0) + o.offsetTop;
			
			if(o.tagName.toLowerCase() == "table"){
				ht -= parseInt(o.border || 0) + parseInt(o.cellSpacing || 0);
				wt -= parseInt(o.border || 0) + parseInt(o.cellSpacing || 0)*2;
			}
			else if(o.tagName.toLowerCase() == "tr"){
				ht -= (cp = parseInt(o.parentNode.parentNode.cellSpacing));
				while(o.previousSibling)
					ht -= (o = o.previousSibling).offsetHeight + cp;
			}
	
			o = o.offsetParent;
		}

		return [wt, ht];
	},
	
	gridPlace : function(jmlNode){
		var jNodes = jmlNode.childNodes;
		for(var nodes=[],i=0;i<jNodes.length;i++) {
			if(jNodes[i].jml.getAttribute("left") || jNodes[i].jml.getAttribute("top") || jNodes[i].jml.getAttribute("right") || jNodes[i].jml.getAttribute("bottom")) continue;
			nodes.push(jNodes[i].oExt);
		}
		
		if (nodes.length == 0)
			return;

		var parentnode = jmlNode.jml;
		var rowheight = parseInt(parentnode.getAttribute("cell-height")) || 0;
		var between = parseInt(parentnode.getAttribute("cell-padding")) || 0;
		var columns = parentnode.getAttribute("grid").split(/\s*,\s*/);

		var margin = parentnode.getAttribute("margin") ? parentnode.getAttribute("margin").split(",") : [0,0,0,0];
		for (var i=0;i<margin.length;i++)
			if (typeof margin[i] == "string")
				margin[i] = parseInt(margin[i]);			

		// Calculate column widths
		var parentWidth = nodes[0].parentNode.offsetWidth;
		if (!parentWidth) 
			return; // Do nothing of the sort.

		var colWidths = new Array();
		var nColumns = columns.length;
		var totalWidth = 0;
		var assignedColumns = 0;
		var clientWidth = parentWidth - ((nColumns-1)*between + margin[3] + margin[1]);
		for (var x=0; x<nColumns; x++)
		{
			if(typeof columns[x] == "number")
				colWidths[x] = columns[x];
			else if(typeof columns[x] == "string")
			{
				if (columns[x].indexOf("%") > -1)
				{
					colWidths[x] = Math.floor((parseInt(columns[x]) * clientWidth) / 100);
				}
				else colWidths[x] = parseInt(columns[x]); // And if this is undefined, we'll catch it later.
			}
			
			if (colWidths[x])
			{
				assignedColumns++;
				totalWidth += colWidths[x];
			}
		}

		// Distribute whatever is left of the parent over the undefined columns.
		if (assignedColumns < nColumns)
		{
			var leftOver = Math.floor((parentWidth - totalWidth - ((nColumns-1)*between + margin[1] + margin[3]	)) / (nColumns-assignedColumns));
			for (var x=0; x<nColumns; x++)
				if (!colWidths[x] && colWidths[x] !== 0)
					colWidths[x] = leftOver;
		}
		
		var nTop = margin[0];
		var iNode = 0; // Node eye-terator.

		for(var y=0;y<nodes.length;y+=nColumns)
		{
			if (y) nTop += between;
			var maxHeight = rowheight;
			var nLeft = margin[3];
			for(var x=0;x<nColumns;x++)
			{
				if(!nodes[iNode]) 
					break; // Done, break.
	
				nodes[iNode].style.position = "absolute";
				nodes[iNode].style.top = nTop + "px";
				nodes[iNode].style.left = nLeft + "px";
				
				var diff = Kernel.compat.getDiff(nodes[iNode]);

				if (jNodes[iNode].jml.getAttribute("width") == null) // Only if not directly specified.
					nodes[iNode].style.width = Math.max(colWidths[x] - (diff[0] || 0), 0) + "px";

				if (jNodes[iNode].jml.getAttribute("height") == null){ // Only if not directly specified.
					nodes[iNode].style.height = Math.max(0,(rowheight - (diff[1] || 0))) + "px";//Math.max(rowheight - (diff[1] || 0), IS_IE ? nodes[iNode].scrollHeight : 0) + "px";
				}
				
				maxHeight = Math.max(maxHeight, nodes[iNode].offsetHeight);

				nLeft += Math.max(colWidths[x], 0) + between; // Equal to nodes[iNode].offsetWidth + between.
				iNode++;
			}
			nTop += maxHeight;
		}
		
		// Resize the parent, if necessary - This should be optional...
		if (jmlNode.jml.getAttribute("height") == null && jmlNode.jml.getAttribute("autosize") != "false")
			jmlNode.oExt.style.height = Math.max(nTop+margin[2], 0) + "px";
	},
	
	getIframe : function(jmlNode, strHtml, oParent){
		
	},
	
	initializeIframe : function(id, strInit){
		var doc = self.frames[id].document;
		
		doc.open();
		doc.write(strInit || "<html><head><style>BODY{margin:0px;border:thin;} DIV{display : inline;} *{-moz-box-sizing: border-box;}</style></head><body></body></html>");
		doc.close();
		
		if(!IS_IE) importClass(MozillaCompat, true, self.frames[id]);
		
		doc.body.obj = D.getElementById(id);
		doc.body.win = doc.win = self.frames[id];
		if(!IS_IE50) doc.body.obj.doc = doc;
		//this is not 100% but good enough for now...
		doc.body.obj.onresize = function(){this.doc.body.ll = null;}
		
		doc.onkeydown = function(e){
			if(!e) e = this.win.event;
			if(document.onkeydown) D.onkeydown(e);
			return false;
		}
		
		doc.onmousedown = function(e){
			if(!e) e = this.win.event;
			if(document.body.onmousedown) D.body.onmousedown(e);
			if(document.onmousedown) D.onmousedown(e);
		}
		
		doc.onmouseup = function(e){
			if(!e) e = this.win.event;
			if(document.body.onmouseup) D.body.onmouseup(e);
			if(document.onmouseup) D.onmouseup(e);
		}
		
		doc.onclick = function(e){
			if(!e) e = this.win.event;
			if(document.body.onclick) D.body.onclick(e);
			if(document.onclick) D.onclick(e);
		}
		
		//all these events should actually be piped to the events of the container....
		doc.body.oncontextmenu = function(e){
			if(!e) e = this.win.event;
			if(!this.ll) this.ll = Kernel.compat.getAbsolutePosition(this.obj);
			var s = this.ll;
			
			q = {
				offsetX : e.offsetX,
				offsetY : e.offsetY,
				x : e.x + s[0],
				y : e.y + s[1],
				button : e.button,
				clientX : e.x + s[0],
				clientY : e.y + s[1],
				srcElement : e.srcElement,
				target : e.target,
				targetElement : e.targetElement
			}

			if(this.host && this.host.oncontextmenu) this.host.oncontextmenu(q);
			if(document.body.oncontextmenu) D.body.oncontextmenu(q);
			if(document.oncontextmenu) D.oncontextmenu(q);
			
			return false;
		}

		doc.body.onmouseover = function(e){
			this.ll = Kernel.compat.getAbsolutePosition(this.obj);
		}

		doc.body.onmousemove = function(e){
			if(!e) e = this.win.event;
			if(!this.ll) this.ll = Kernel.compat.getAbsolutePosition(this.obj);
			var s = this.ll;
		
			q = {
				offsetX : e.offsetX,
				offsetY : e.offsetY,
				x : e.x + s[0] - 4,
				y : e.y + s[1] - 4,
				button : e.button,
				clientX : e.x + s[0] - 4,
				clientY : e.y + s[1] - 4,
				srcElement : e.srcElement,
				target : e.target,
				targetElement : e.targetElement
			}

			if(this.obj.onmousemove) this.obj.onmousemove(q);
			if(document.body.onmousemove) D.body.onmousemove(q);			
			if(document.onmousemove) D.onmousemove(q);
			
			return e.returnValue;
		}
		
		return self.frames[id];
	}
}


	/*this.setAnchor = function(left, top, right, bottom, width, height){
		if(!this.oExt.host) return;
		
		if(left || top || right || bottom) this.oExt.style.position = "absolute";
		if(left != null) this.oExt.style.left = left + "px";
		if(top != null) this.oExt.style.top = top + "px";
		
		var id = 'Kernel.lookup(' + this.uniqueId + ').oExt';
		var ids = [];
		
		var pNode = this.oExt.parentNode; var nSibling = this.oExt.nextSibling;
		document.body.appendChild(this.oExt);

		var hordiff = Math.max(0, this.oExt.offsetWidth - parseInt(Kernel.compat.getStyle(this.oExt, "width")) || 0);
		var verdiff = Math.max(0, this.oExt.offsetHeight - parseInt(Kernel.compat.getStyle(this.oExt, "height")) || 0);
		//if(this.jml.getAttribute("id") == "btnSearch") alert(verdiff);

		pNode.insertBefore(this.oExt, nSibling);

		var pWidth = this.parentNode == document.body ? (document.all ? 'document.documentElement.offsetWidth' : 'window.innerWidth'): id + '.parentNode.offsetWidth';
		var pHeight = this.parentNode == document.body ? (document.all ? 'document.documentElement.offsetHeight' : 'window.innerHeight') : id + '.parentNode.offsetHeight';
		
		if(right != null && left != null){
			if(!this.parentNode.RULES) this.parentNode.RULES = new Array();//" + parentNode + ".offsetWidth
			ids.push(this.parentNode.RULES.push(id + ".style.width = (" +  pWidth + " - " + right + " - " + id + ".offsetLeft - " + hordiff + ") + 'px'")-1);
		}
		else{
			if(right != null){
				if(!this.parentNode.RULES) this.parentNode.RULES = new Array();
				ids.push(this.parentNode.RULES.push(id + ".style.left = (" +  pWidth + " - " + right + " - " + id + ".offsetWidth) + 'px'")-1);
			}
			if(width != null) this.oExt.style.width = (width-hordiff) + "px";
		}
		
		if(bottom != null && top != null){
			if(!this.parentNode.RULES) this.parentNode.RULES = new Array();
			ids.push(this.parentNode.RULES.push(id + ".style.height = (" +  pHeight + " - " + bottom + " - " + id + ".offsetTop - " + verdiff + ") + 'px'")-1);
		}
		else{
			if(bottom != null){
				if(!this.parentNode.RULES) this.parentNode.RULES = new Array();
				ids.push(this.parentNode.RULES.push(id + ".style.top = (" +  pHeight + " - " + bottom + " - " + id + ".offsetHeight) + 'px'")-1);
			}
			if(height != null) this.oExt.style.height = (height-verdiff) + "px";
		}
		*/
		/*if(this.anchorIds){
			for(var i=0;i<this.anchorIds.length;i++){
				this.parentNode.RULES[this.anchorIds[i]] = "";
			}
			
		}*/
		/*
		this.anchorIds = ids;
	}*/


/*FILEHEAD(/in/Core/Kernel/ECMAext.js)SIZE(8087)TIME(1184319058819)*/
/********* OBJECT EXTENSIONS *********
	Fix Browser Incompatibility and
	implement extra functionalities
	like inheritence etc
*************************************/

/*Function.prototype.inherit = function(classRef){
	this.prototype = (classRef instanceof Function ? new classRef() : classRef);
}*/

function parseUri(sourceUri){
    var uriPartNames = ["source","protocol","authority","domain","port","path","directoryPath","fileName","query","anchor"];
    var uriParts = new RegExp("^(?:([^:/?#.]+):)?(?://)?(([^:/?#]*)(?::(\\d*))?)?((/(?:[^?#](?![^?#/]*\\.[^?#/.]+(?:[\\?#]|$)))*/?)?([^?#/]*))?(?:\\?([^#]*))?(?:#(.*))?").exec(sourceUri);
    var uri = {};
    
    for(var i = 0; i < 10; i++){
        uri[uriPartNames[i]] = (uriParts[i] ? uriParts[i] : "");
    }
    
    // Always end directoryPath with a trailing backslash if a path was present in the source URI
    // Note that a trailing backslash is NOT automatically inserted within or appended to the "path" key
    if(uri.directoryPath.length > 0){
        uri.directoryPath = uri.directoryPath.replace(/\/?$/, "/");
    }
    
    return uri;
}

function extend(dest){
	for(var i=1;i<arguments.length;i++){
		var src = arguments[i];
		for(var prop in src) dest[prop] = src[prop];
	}
	return dest;
}

/*function serialize(data){
	return new JSON().getSerialized("test", data)
}*/

function unserialize(str){
	if(!str) return str;
	eval("var data = " + str);
	return data;
}


function isNull(value){
	if(value) return false;
	return (value == null || !String(value).length);
}

function isArray(o){
	return (o && typeof o == "object" && o.length);
}

function isTrue(c){
	return c === true || c === "true" || c === "on" || typeof c == "number" && c > 0 || c === "1";
}

function isFalse(c){
	return c === false || c === "false" || c === "off" || c === 0 || c === "0";
}

function isNot(c){
	// a var that is null, false, undefined, Infinity, NaN and c isn't a string
	return (!c && typeof c != "string" && c !== 0 || (typeof c == "number" && !isFinite(c)));
}

if(!self.isFinite){
	function isFinite(val){
		return val+1!=val;
	}
}

function copyObject(o){
	var rv = new Object();
	for(prop in o) rv[prop] = o[prop];
	return rv;
}

Array.prototype.copy = function(){
	var ar = new Array();
	for(var i=0;i<this.length;i++)
		ar[i] = this[i] && this[i].copy ? this[i].copy() : this[i];

	return ar;
}

function copyArray(ar, Type){
	if(!ar) return ar;
	for(var car=[], i=0;i<ar.length;i++)
		car[i] = Type ? new Type(ar[i]) : ar[i];

	return car;
}

Array.prototype.arrayAdd = function(){
	var s = this.copy();
	for(var i=0;i<arguments.length;i++){
		for(var j=0;j<s.length;j++){
			s[j] += arguments[i][j];
		}
	}

	return s;
}

//equals??
Array.prototype.isEqual = function(obj){
	for(var i=0;i<this.length;i++) if(this[i] != obj[i]) return false;
	return true;
}

Array.prototype.makeUnique = function(){
	var newArr = [];
	for(var i=0;i<this.length;i++)
		if(!newArr.contains(this[i])) newArr.push(this[i]);

	this.length = 0;
	for(var i=0;i<newArr.length;i++)
		this.push(newArr[i]);
}

Array.prototype.makeUnique = function(){
	var newArr = [];
	for(var i=0;i<this.length;i++)
		if(!newArr.contains(this[i])) newArr.push(this[i]);

	this.length = 0;
	for(var i=0;i<newArr.length;i++)
		this.push(newArr[i]);
}

Array.prototype.contains = function(obj){
	for(var i=0;i<this.length;i++) if(this[i] == obj) return true;
	return false;
}

Array.prototype.indexOf = function(obj){
	for(var i=0;i<this.length;i++) if(this[i] == obj) return i;
	return -1;
}

Array.prototype.pushUnique = function(item){
	if(!this.contains(item)) this.push(item);
}

Array.prototype.search = function(){
	for(var i=0;i<arguments.length;i++){
		if(typeof this[i] != "array") continue;
		for(var j=0;j<arguments.length;j++){
			if(this[i][j] != arguments[j]) break;
			else if(j == arguments.length-1) return this[i];
		}
	}
}

//Mac workaround...
if(!Function.prototype.call){
	Function.prototype.call = function(obj, arg1, arg2, arg3){
		obj.tf = this;
		var rv = obj.tf(arg1, arg2, arg3);
		obj.tf = null;
		return rv;
	}
}

/*Object.prototype.runEvent = function(eventname, arg1, arg2, arg3){
	if(this[eventname]) this[eventname](arg1, arg2, arg3);
}*/

Array.prototype.remove = function(obj){
	for(var i=0;i<this.length;i++){
		if(this[i] != obj) continue;

		for(var j=i;j<this.length;j++)
			this[j] = this[j+1];
		this.length--;
		i--;
	}
}

Array.prototype.removeIndex = function(i){
	for(var j=i;j<this.length;j++)
		this[j] = this[j+1];
	this.length--;
}

Array.prototype.insertIndex = function(obj, i){
	for(var j=this.length;j>=i;j--)
		this[j] = this[j-1];
	
	this[i] = obj;
}

Array.prototype.invert = function(){
	var l = this.length-1;
	for(var temp,i=0;i<Math.ceil(0.5*l);i++){
		temp = this[i];
		this[i] = this[l-i]
		this[l-i] = temp;
	}
	
	return this;
}

if(!Array.prototype.push){
	Array.prototype.push = function(item){
		this[this.length] = item;
		return this.length;
	}
}

if(!Array.prototype.pop){
	Array.prototype.pop = function(item){
		var item = this[this.length-1];
		delete this[this.length-1];
		this.length--;
		return item;
	}
}

if(!Array.prototype.shift){
	Array.prototype.shift = function(){
		var item = this[0];
		for(var i=0;i<this.length;i++) this[i] = this[i+1];
		this.length--;
		return item;
	}
}

if(!Array.prototype.join){
	Array.prototype.join = function(connect){
		for (var str = "", i=0;i<this.length;i++)
			str += this[i] + (i < this.length-1 ? connect : "");
		return str;
	}
}

Math.hexlist = "0123456789ABCDEF";
Math.decToHex = function(value){
	var hex = this.floor(value/16);
	hex = (hex >15 ? this.decToHex(hex) : this.hexlist.charAt(hex));

	return hex + "" + this.hexlist.charAt(this.floor(value%16));
}
Math.hexToDec = function(value){
	if(!/(.)(.)/.exec(value.toUpperCase())) return false;
	return this.hexlist.indexOf(RegExp.$1) * 16 + this.hexlist.indexOf(RegExp.$2);
}

String.prototype.uCaseFirst = function (str){return this.substr(0,1).toUpperCase() + this.substr(1)};
String.prototype.trim = function (){return this.replace(/\s*$/, "").replace(/^\s*/, "");}
String.prototype.repeat = function (times){for(var out="",i=0;i<times;i++) out += this;return out;}
String.prototype.count = function(str){return this.split(str).length-1;}
String.prototype.pad = function(l, s, t){
	return s || (s = " "), (l -= this.length) > 0 ? (s = new Array(Math.ceil(l / s.length)
		+ 1).join(s)).substr(0, t = !t ? l : t == 1 ? 0 : Math.ceil(l / 2))
		+ this + s.substr(0, l - t) : this;
};
PAD_LEFT = 0;
PAD_RIGHT = 1;
PAD_BOTH = 2;

function trim(str){return str.replace(/^\s*(.*)\s*$/, "$1");}
function repeat(str, times){for(var out="",i=0;i<times;i++) out += str;return out;}
function formatXML(output){
	output = trim(output);

	var lines = output.split("\n");
	for(var i=0;i<lines.length;i++) lines[i] = trim(lines[i]);
	lines = lines.join("\n").replace(/\>\r\n/g, ">").replace(/\>/g, ">\n").replace(/\n\</g, "<").replace(/\</g, "\n<").split("\n");
	lines.remove(0);//test if this is actually always fine
	lines.remove(lines.length);
	
	for(var depth=0,i=0;i<lines.length;i++)
		lines[i] = repeat("\t", (lines[i].match(/^\s*\<\//) ? --depth :  (lines[i].match(/^\s*\<[^\?][^>]+[^\/]\>/) ? depth++ : depth))) + lines[i];

	return lines.join("\n");
}

function formatJS(x){
	var d=0;
	return x.replace(/;+/g,';').replace(/;}/g,'}').replace(/{;/g,'{').replace(/({)|(})|(;)/g,function(m,a,b,c){
		if(a)d++;if(b)d--;
		var o='';for(var i=0;i<d;i++)o+='\t\t';
		if(a)return '{\n'+o; if(b)return '\n'+o+'}';if(c)return ';\n'+o;
	}).replace(/\>/g,'&gt;').replace(/\</g,'&lt;');
}

function pasteWindow(str){
	var win = window.open("about:blank");	
	win.document.write(str);
}

function htmlentities(str){
	return str.replace(/</g, "&lt;");
}

function html_entity_decode(str){
	return str.replace(/&lt;/g, "<").replace(/&gt;/g, ">").replace(/&amp;/g, "&").replace(/&nbsp;/g, " ");
}

function htmlentitiesdecode(str){
	str = str.replace(/\&\#38;/g, "&");
	return str;
}


/*FILEHEAD(/in/Core/Kernel/BackButton.js)SIZE(3651)TIME(1168308019160)*/

var History = {
	past : [],
	future : [],
	current : null,
	length : 0,
	initString : "<style>BODY, HTML{margin : 0;}h1{height : 100px;margin : 0;padding : 0;}</style><body><h1 id='a0'>0</h1></body><script>var lastURL = -1;if(document.all){document.body.onscroll = checkUrl;}else{setInterval('checkUrl()', 200);}function checkUrl(){top.History.hasChanged((document.all ? document.body : document.documentElement).scrollTop/100);lastURL = document.body.scrollTop;}checkUrl();</script>",
	isSupported : IS_GECKO||IS_IE,
	
	Init : function(){
		if(!this.isSupported) return;
		
		if(IS_IE){
			var str = this.initString;
			if(top == self){
				document.body.insertAdjacentHTML("beforeend","<iframe name='nav' style2='position:absolute;left:10px;top:10px;height:100px;width:100px;z-index:1000' style='width:1px;height:1px;' src='about:blank'></iframe>");
				document.frames["nav"].document.open();
				document.frames["nav"].document.write(str);
				document.frames["nav"].document.close();
			}
			
			this.iframe = document.frames["nav"];// : document.getElementById("nav").contentWindow;
		}
		else{
			History.lastUrl = location.href;
			this.timer = setInterval(function(){
				if(History.lastUrl == location.href) return;
				
				History.lastUrl = location.href;
				var page = location.href.match(/^.*(\d+)$/, "$1")
				History.hasChanged(parseInt(page ? page[1] : 0));
			}, 20);
		}
	},
	
	addPoint : function(callback, userdata){
		if(!this.isSupported) return;
		
		if(this.future.length) this.future = [];
		this.future.push({callback:callback,userdata:userdata});
		
		if(this.past.length+1 > this.length){
			this.length++;
			
			if(IS_IE){
				//var h = (IS_IE ? this.iframe.document:document).body.appendChild((IS_IE ? this.iframe.document:document).createElement('span'));
				var h = this.iframe.document.body.appendChild(this.iframe.document.createElement('h1'));
				h.id = 'page' + this.length;
				h.innerHTML = this.length;
			};
		}

		this.goForward(true);
	},
	
	goForward : function(isInitial){
		if(!this.future.length || !this.isSupported) return;
		if(this.current) this.past.push(this.current);
		this.current = this.future.pop();

		(IS_IE ? this.iframe : window).location.href = "#page" + (this.past.length);
		if(!IS_IE) History.lastUrl = location.href;
		
		this.current.callback(isInitial ? "initial" : "forward", this.current.userdata);
	},
	
	goBack : function(){
		if(!this.past.length || !this.isSupported) return;
		if(this.current) this.future.push(this.current);
		this.current = this.past.pop();
		
		(IS_IE ? this.iframe : window).location.href = "#page" + (this.past.length);
		
		this.current.callback("back", this.current.userdata);
	},
	
	clear : function(){
		this.past = [];
		this.future = [];
		this.current = null;
		this.length = 0;
		
		if(IS_IE){
			this.iframe.location.href = "about:blank";
			this.iframe.document.write(this.initString);
		}
	},
	
	hasChanged : function(page){
		if(this.past.length == page) return; //current
		if(page < this.past.length){
			this.future.push(this.current);
			/* UNSUPPORTED for(var i=this.past.length-1;i>page;i--){
				this.future.push(this.past.pop());
			}*/
			this.current = this.past.pop();
			
			var action = "back";
		}
		if(page > this.past.length){
			this.past.push(this.current);
			/* UNSUPPORTED var diff = page - (this.past.length-1)
			for(var i=this.future.length-1;i>diff;i--){
				this.past.push(this.future.pop());
			}*/
			this.current = this.future.pop();
			var action = "forward";
		}


		if(this.current) this.current.callback(action, this.current.userdata);
	}
}

/*FILEHEAD(/in/Core/Kernel/Animation.js)SIZE(4861)TIME(1182723583203)*/

Animate = {
	sequences : [],
	register : function(o){
		return this.sequences.push(o) - 1;
	},
	destroy : function(id){
		this.sequences[id] = null;
	},
	findSeq : function(id){
		return this.sequences[id];
	},
	
	//Animation Modules
	left : function(oHTML, value){oHTML.style.left = value + "px";},
	right : function(oHTML, value){oHTML.style.right = value + "px";},
	top : function(oHTML, value){oHTML.style.top = value + "px";},
	width : function(oHTML, value, center){oHTML.style.width = value + "px";},
	height : function(oHTML, value, center){oHTML.style.height = value + "px";},
	scrollTop : function(oHTML, value, center){oHTML.scrollTop = value;},
	"height-rsz" : function(oHTML, value, center){oHTML.style.height = value + "px";if(!IS_IE) window.onresize();},
	
	mleft : function(oHTML, value){oHTML.style.marginLeft = value + "px";},
	
	scrollwidth : function(oHTML, value){
		oHTML.style.width = value + "px";
		oHTML.scrollLeft = oHTML.scrollWidth;
	},
	
	scrollheight_old : function(oHTML, value){
		try{
			oHTML.style.height = value + "px";
			oHTML.scrollTop = oHTML.scrollHeight;
		}catch(e){alert(value)}
	},
	
	scrollheight : function(oHTML, value){
		oHTML.style.height = value + "px";
		oHTML.scrollTop = oHTML.scrollHeight - oHTML.offsetHeight;
	},
	
	scrolltop : function(oHTML, value){
		oHTML.style.height = value + "px";
		oHTML.style.top = (-1 * value - 2) + "px";
		oHTML.scrollTop = 0;//oHTML.scrollHeight - oHTML.offsetHeight;
	},
	
	clipright : function(oHTML, value, center){
		oHTML.style.clip = "rect(auto, auto, auto, " + value + "px)";
		oHTML.style.marginLeft = (-1*value) + "px";
	},
	
	fade : function(oHTML, value){
		if(IS_IE) oHTML.style.filter = "alpha(opacity=" + parseInt(value*100) + ")";
		else if(false && IS_GECKO) oHTML.style.MozOpacity = value-0.000001;
		else oHTML.style.opacity = value;
	}
}

function GuiAnimation(oHTML, type, fromValue, toValue, animtype, frames, interval, onfinish, userdata){
	this.uniqueId = Animate.register(this);
	this.method = Animate[type];

	this.oHTML = oHTML;
	this.onfinish = onfinish;
	this.userdata = userdata;
	this.interval = interval;
	this.frames = frames;
	
	//Compile steps
	this.steps = [fromValue];
	this.step = 0;
	
	var steps = parseInt(frames);
	var scalex = (toValue - fromValue)/((Math.pow(steps,2)+2*steps+1)/(4*steps));
	for(var i=0;i<frames;i++){
		if(animtype == 0 && !value) var value = (toValue - fromValue)/frames; 
		else if(animtype == 1) var value = scalex*Math.pow(((steps-i))/steps,3); 
		else if(animtype == 2) var value = scalex * Math.pow(i/frames, 3); 

		this.steps.push(Math.max(0, this.steps[this.steps.length-1] + value - (i==0?1:0)));
	}
	this.steps[this.steps.length-1] = Math.max(1, toValue-1);

	//Stop
	this.stop = function(){
		clearTimeout(this.timer);
		Animate.destroy(this.uniqueId);
	}

	//Play
	AnimateStep(0, this.uniqueId);
}

function AnimateStep(step, uniqueId){
	var o = Animate.findSeq(uniqueId);
	if(!o) return;
	
	try{o.method(o.oHTML, o.steps[step]);}catch(e){}

	if(step < o.frames) o.timer = setTimeout('AnimateStep(' + (step+1) + ', ' + uniqueId + ')', o.interval);
	else if(o.onfinish) o.onfinish(o.oHTML, o.userdata);
}


/*******************/

function isFading(oDiv){
	return (oDiv.style.visibility == "hidden" && oDiv.filters.blendTrans && oDiv.filters.blendTrans.status == 2);
}

function fadeIn(oDiv, time){
	//BEWARE!!! THIS FILTER TAKES 2 MEGABYTES OF MEMORY
	
	//if(isMinIE55 || isMinIE6){
		oDiv.style.filter = "blendTrans(duration=" + time || 1 + ")";
		oDiv.style.visibility = "hidden";
		
		//if(oDiv.filters.blendTrans.status != 2){
		  oDiv.filters.blendTrans.apply();
		  oDiv.style.visibility = "visible";
		  oDiv.filters.blendTrans.play();
		//}
	/*}
	else{
   	oDiv.style.visibility = "visible";
   }*/
   FADING_OBJ = oDiv;
   setTimeout('stopFade(FADING_OBJ)', time * 1000);
}

function stopFade(o){
	o.filters.blendTrans.stop();
	o.style.visibility = "visible";
}

function fadeOut(oDiv, time){
	//BEWARE!!! THIS FILTER TAKES 2 MEGABYTES OF MEMORY
	
	if(oDiv.length){
		for(var i=0;i<oDiv.length;i++){
			oDiv[i].style.filter = "blendTrans(duration=" + time || 1 + ")";
	    	oDiv[i].style.visibility = "visible";
	    	
	    	oDiv[i].filters.blendTrans.apply();
      	oDiv[i].style.visibility = "hidden";
		}
		
		for(var i=0;i<oDiv.length;i++){
			oDiv[i].filters.blendTrans.play();
		}
		
		return
	}
	
	//if(isMinIE55 || isMinIE6){
	    oDiv.style.filter = "blendTrans(duration=" + time || 1 + ")";
	    oDiv.style.visibility = "visible";
	    
	    //if(oDiv.filters.blendTrans.status != 2){
	        oDiv.filters.blendTrans.apply();
	        oDiv.style.visibility = "hidden";
	        oDiv.filters.blendTrans.play();
	    //}
	/*}
   else{
   	oDiv.style.visibility = "hidden";
   }*/
}

/*FILEHEAD(/in/Core/Kernel/browsers/XPath.js)SIZE(14413)TIME(1182726961382)*/

/*FILEHEAD(/in/Core/Kernel/browsers/XSLT.js)SIZE(7917)TIME(1182723583203)*/

/*FILEHEAD(/in/Core/Kernel/browsers/JSLT.js)SIZE(17731)TIME(1187010157128)*/

function _JSLT(){

	//------------------------------------------------------------------------------------
	// compile functions
	function isString() {
		if (typeof arguments[0] == 'string') return true;
		if (typeof arguments[0] == 'object' && arguments[0].constructor) return (arguments[0].constructor.toString().match(/string/i) != null);
		return false;
	}
	function jesc(s,esc){
		if(!esc)return s; if(!s)return '';
		if(esc.toLowerCase()=='q')return s.replace(/\'/g,"\\\'").replace(/\"/g,"\\\"");
		return s;
	}
	function jcpy(s,n,p){if(!n)return;if(p){var t = n.selectNodes(p);if(!t || t.length==0)return;for(var i = 0;i<t.length;i++)s[s.length]=t[i].xml;}else s[s.length]=n.xml;}
	function jxml(n,p){if(!n)return;if(p){var o = [];var t = n.selectNodes(p);if(!t || t.length==0)return;for(var i = 0;i<t.length;i++)o[o.length]=t[i].xml;}else return n.xml;return o.join('');}
	function jval(n,p){
		if(!n)return '';if(p)n = n.selectSingleNode(p);if(!n)return '';if(n.nodeType == 1) n=n.firstChild;
		return n?n.nodeValue:'';
	}
	function jloc(n,f,p){if(!n)return;n = isString(p)?n.selectSingleNode(p):p;if(!n)return;f(n);};
	function jdbg(a){setStatus(a)};
	function jnod(n,p){if(!n)return '';if(p)n = n.selectSingleNode(p);if(!n)return null;return n;}
	function jnds(n,p){if(!n)return '';if(p)n = n.selectNodes(p);if(!n)return null;return n;}
	function jexs(n,p){if(!n)return false;if(p)n = n.selectSingleNode(p);return n!=null;}
	function jemp(n,p){if(!n)return false;if(p)n = n.selectSingleNode(p);if(!n)return true;if(n.nodeType == 1) n=n.firstChild;return (n?n.nodeValue:'').match(/^[\s\r\n\t]*$/)!=null;}
	function jcnt(n,p){if(!n)return 0; var t= n.selectNodes(p);return t?t.length:0;}
	function jpak(n,f,p){
		var s=[];f(s,n);return s.join('');
	}
	function jstore(n,pk,f,p){
		if(!p)p='def';
		if(!pk[p])pk[p]=[];
		f(pk[p],n);return;
	}
	function jfetch(pk,p){
		if(!p)p='def';
		if(pk[p])return pk[p].join('');
		return '';
	}
	
	function jfra(f,t,sp,ep){if(!t)return;var end = ep==null?t.length:Math.min(t.length,(sp+ep));for(var i = (sp==null)?0:sp;i<end;i++)f(i,end,t[i]);}
	function jvls(n,p){
		var r=[];
		if(!n)return r; var t = n.selectNodes(p);if(!t)return r;
		for(var i = 0;i<t.length;i++){ 
			n = t[i];if(n.nodeType == 1) n=n.firstChild;r[i]=n?n.nodeValue:'';
		}
		return r;
	}
	function jpar(f,str){var n = parseXML(str).documentElement;f(n);}
	function jfor(n,f,p,sp,ep){
		if(!n)return;
		var t = n.selectNodes(p);
		var end = ep==null?t.length:Math.min(t.length,(sp+ep));
		for(var i = (sp==null)?0:sp;i<end;i++)f(i,end,t[i]);
	}
	
	// Sorting helpers
	var sort_intmask = ["", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "00000000000", "000000000000", "0000000000000", "00000000000000" ];
	var sort_dateFmtStr;
	var sort_dateFormat;
	var sort_dateReplace; 
	function sort_dateFmt(str){
		sort_dateFmtStr = str;
		var result = str.match(/(D+|Y+|M+|h+|m+|s+)/g);
		if(!result)return;
		for(var pos={},i=0;i<result.length;i++) pos[result[i].substr(0,1)] = i+1;
		sort_dateFormat = new RegExp(str.replace(/[^\sDYMhms]/g,'\\$1').replace(/YYYY/, "(\\d\\d\\d\\d)").replace(/(DD|YY|MM|hh|mm|ss)/g, "(\\d\\d)"));
		sort_dateReplace = "$" + pos["M"] + "/$" + pos["D"] + "/$" + pos["Y"];
		if(pos["h"])sort_dateReplace += " - $"+pos["h"]+":$"+pos["m"]+":$"+pos["s"];
	}

	// Sorting methods for sort()
  	function sort_alpha(n)  { if(!n)return '';if(n.nodeType == 1) n=n.firstChild;return n?n.nodeValue:''; }
	function sort_number(n){
		var t = sort_alpha(n);
	  	return (t.length < sort_intmask.length ? sort_intmask[sort_intmask.length - t.length] : "") + t;
	}
	function sort_date(n,args){
		if(!sort_dateFormat || (args && sort_dateFmtStr!=args[0]))sort_dateFmt(args?args[0]:"*");
		var t = sort_alpha(n),d;
		if(sort_dateFmtStr=='*')d = Date.parse(t);
		else d = (new Date(t.replace(sort_dateFormat, sort_dateReplace))).getTime();
		t = ""+parseInt(d); if(t=="NaN")t="0";
		return (t.length < sort_intmask.length ? sort_intmask[sort_intmask.length - t.length] : "") + t;
	}
	
	function jsort(n,f,p,ps,sm,desc,sp,ep){
		sm = sm?sm:sort_alpha;
		var sa = [], t = n.selectNodes(p), i = t.length, args = null;
		if(typeof sm != "function"){var m = sm.shift();args = sm; sm = m;}		

		// build string-sortable list with sort method
		while(i--){
			var n = t[i].selectSingleNode(ps);
			if(n) sa[sa.length] = {toString:function(){return this.v;}, pn:t[i], v:sm(n,args)};
			else  sa[sa.length] = {toString:function(){return this.v;}, pn:t[i], v:''};
		}
		// sort it
		sa.sort();
		
		//iterate like foreach
		var end = ep==null?sa.length:Math.min(sa.length,(sp+ep));
		var start = (sp==null)?0:sp;
		if(desc){
			for(var i = end-1;i>=start;i--)f(end-i-1,end,sa[i].pn,sa[i].v);
		}else{
			for(var i = start;i<end;i++)f(i,end,sa[i].pn,sa[i].v);
		}
	}
	
	
	function japl(s,n,ma,p){
		if(!n)return;
		var m = n.selectNodes(p||'node()');
		for(var i=0;i<m.length;i++){
			var n = m[i];
			var f = ma[0][n.tagName];
			if(f)f(s,n);
			else{
				for(var k=1;k<ma.length;k++){
					var sn = n.selectSingleNode(ma[k][0]);
					if(sn){ma[k][1](s,sn);break;}
				}
			}
		}
	}
	
	function jmat(ma,f,p){	
		var s = p.split(/\|/), all = true;
		for(var i = 0;i<s.length;i++){
			if(!s[i].match(/^[\w_]+$/))all=false;
			ma[0][s[i]]=f;
		}
		if(!all){
			p = "self::"+p.replace(/\|/g,"|self::");
			ma[ma.length]=[p,f];
		}
	}
	

	//------------------------------------------------------------------------------------

	var types=['[','{','(','text','xpath','word','sep','ws','semi','sh','op','col','str','regex'];
	var closes=[']','}',')'];

	var func={'last':[0,'(i==len-1)'],
			    'first':[0,'(i==0)'],
				 'out':[0,'s[s.length]'],
				 'apply':[1,';japl(s,n,ma,',');'],
				 'copy':[1,';jcpy(s,n,',');'],
				 'xml':[1,'jxml(n,',')'],
				 'value':[1,'jval(n,',')'],
				 'exists':[1,'jexs(n,',')'],
				 'empty':[1,'jemp(n,',')'],
				 'values':[1,'jvls(n,',')'],
				 'node':[1,'jnod(n,',')'],
				 'nodes':[1,'jnds(n,',')'],
				 'count':[1,'jcnt(n,',')'],
				 'context':[1,'(n=n.selectSingleNode(','))'],
				 'foreach':[2,';jfor(n,function(i,len,n){','},',');'],
				 'sort':[2,';jsort(n,function(i,len,n,sv){','},',');'],
				 'local':[2,';jloc(n,function(n){','},',');'],	
				 'match':[2,';jmat(ma,function(s,n){','},',');'],
				 'pack':[2,'jpak(n,function(s,n){','},',')'],
				 'store':[2,'jstore(n,os,function(s,n){','},',');'],
				 'fetch':[1,'jfetch(os,',')'],

				 'parse':[2,'jpar(function(n){','},',');'],
				 'forarray':[3],
				 'macro':[4],
				 'pragma':[5],
				 '_':[6]};
	// s,n,i,len
		
	var short_0={'%':'s[s.length]='};
	var short_1={'$':['jval(n,',')'],
					 '&':['jnod(n,',')'],
					 '@':['(n=n.selectSingleNode(','))'],
					 '~':['jexs(n,',')'],
					 '!':['!jexs(n,',')'],
					 '#':['jcnt(n,',')'],
					 '^':[';japl(s,n,ma,',');']};
	var short_2={'*':[';jfor(n,function(i,len,n){','},',')']};
	
	//------------------------------------------------------------------------------------
	
	function dump_tree(n,s,w){
		for(var i =0;i<n.length;i++){
			var m=n[i], t  = m[0];
			if(t<3){
				s.push(w+types[t]);dump_tree(m[1],s,'&nbsp;&nbsp;'+w);s.push(closes[t]);s.push('\n');
			}else{
				s.push(w+types[t]+': '+m[1]+'\n');					
			}
		}
	}
				
	this.compile =function(str, trim_startspace){

		var err		=[];	// error list
		var tree		=[];  // parse tree
		var stack	=[];  // scopestack
		var node 	= tree;
		var blevel=0, tpos=0;
		var istr = 0, icc = 0;
		var lm = 0;
		var macros={};
		//tokenize
		str = str.replace(/\/\*[\s\S]*?\*\//gm,"");
		str.replace(/([\w_\.]+)|([\s]*,[\s]*)|([\s]*;[\s]*)|((?:[\s]*)[\$\@\#\%\^\&\*\?\!](?:[\s]*))|([\s]*[\+\-\<\>\|\=]+[\s]*)|(\s*\:\s*)|(\s+)|(\\[\\\{\}\[\]\"\'\/])|(\[)|(\])|([\s]*\([\s]*)|([\s]*\)[\s]*)|([\s]*\{[\s]*)|([\s]*\}[\s]*)|(\')|(\")|(\/)/g,function(m,word,sep,semi,sh,op,col,ws,bs1,bo,bc,po,pc,co,cc,q1,q2,re,pos){
			// stack helper functions
			function add_track(t)		{
				var txt = trim_startspace?str.substr( tpos, pos-tpos).replace(/[\r\n]\s*/,'').replace(/^\s*[\r\n]/,'').replace(/\\s/g,' ').replace(/[\r\n\t]/g,''):str.substr( tpos, pos-tpos).replace(/[\r\n\t]/g,'');
				if(txt.length>0){ node[node.length]=[t,txt,tpos,pos];}
			}
			function add_node(t,data)	{node[node.length]=[t,data,pos];}
			function add_sub(t)			{var n = [];node[node.length]=[t,n,pos];stack[stack.length] = node;node = n;}
			function pop_sub(t)			{if(stack.length==0){err[err.length] = ["extra "+closes[t],pos];}else{node = stack.pop();var ot = node[node.length-1][0];if(ot!=t){err[err.length]=["scope mismatch "+types[ot]+" with "+types[t],pos];}}}

			// are we in textmode or entering textmode?
			if(blevel==0 || (bc && blevel==1 && !istr )){
				if(icc==0){
					if(bo){add_track(3);blevel++;} // begin codeblock
					if(bc){if(blevel==0)err[err.length] = ["extra ]",pos];else {blevel--;tpos = pos+1;}} // end codeblock
				}
				if(co){add_track(3);tpos = pos+1;icc++;} // add last text chunk
				if(cc){add_track(4);tpos = pos+1;icc--;if(icc<0)err[err.length]=["extra }",pos];} // xpath chunk
			}else{
				if(!istr){
					if(word){add_node(5,m);if(m=='macro')lm=1;else if(lm)macros[m]=1,lm=0;}
					if(sep)add_node(6,',');
					if(ws)add_node(7,m);
					if(semi)add_node(8,m);
					if(sh)add_node(9,m);
					if(op)add_node(10,m);
					if(col)add_node(11,m);
					if(bo){blevel++;add_sub(0);}
					if(bc){blevel--;pop_sub(0);}
					if(co)add_sub(1);
					if(cc)pop_sub(1);
					if(po)add_sub(2);
					if(pc)pop_sub(2);
				}		
				if(q1){ if(istr==0){istr=1;tpos=pos;}else if(istr==1){istr=0;pos+=1;add_track(12);} }	
				if(q2){ if(istr==0){istr=2;tpos=pos;}else if(istr==2){istr=0;pos+=1;add_track(12);} }
				if(re){ 
					if(istr==0){
						// only allow regex mode if we have no previous siblings or we have a , before us
						if(node.length==0 || node[node.length-1][0]==6){
							istr=3;tpos=pos;
						}else add_node(10,m);
					}
					else if(istr==3){istr=0;pos+=1;add_track(13);}
				}
			}
			return m;
		});
		if(blevel==0){
			var txt = str.substr( tpos, str.length-tpos).replace(/[\r\n\t]/g,'');
			if(txt.length>0){ node[node.length]=[3,txt,tpos,str.length];}}
		if( stack.length > 0 )for(var i = stack.length-1;i>=0;i--){
			var j = stack[i][stack[i].length-1];
			err[err.length] = ["unclosed tag "+types[j[0]],j[2]]; 
		}

		var s		=['var s=[],ma=[{}],os={};'];				
		
		var pragma_trace = 0;
		function line_pos(cpos){
			var l=0;str.replace(/\n/g,function(m,pos){if(pos<cpos)l++;return m;});
			return l;
		}
		
		//recursive compile
		function compile_recur(s,n,offset){

			var k=n.length;
			var d,e;
		//	var lt=14;
			for(var i = ((offset==null)?0:offset);i<k;i++){
				var t = n[i][0];
				// function expansion
				if(t==5){
					var nt1=(i<k-1)?n[i+1][0]:-1,nt2=(i<k-2)?n[i+2][0]:-1;
					var m = n[i][1];
					var d = func[m];
					// also dont insert ;'s
					if(d){
						
						switch(d[0]){
							case 0: s[s.length] = d[1]; break;
							case 1: // () type function
								if(nt1!=2){
									err[err.length]=["Function "+m+" syntax error",n[i][2]];	
								}else{
									s[s.length] = d[1];if(!compile_recur(s,n[i+1][1]))s[s.length]='null';s[s.length] = d[2];
									i++;
								}
								break; 
							case 2: // () {} type function
								if(nt1!=2 || nt2!=1){
									err[err.length]=["Function "+m+" syntax error",n[i][2]];	
								}else{							
									s[s.length] = d[1];compile_recur(s,n[i+2][1]);s[s.length] = d[2];
									if( !compile_recur(s, n[i+1][1] ) )s[s.length]='null';
									s[s.length] = d[3];
									i+=2;		
								}
								break;
							case 3://forarray
								//we should have ( word ws in .... , .. , ..  ) {}
								var o,ok;
								if( i>k-3 || n[i+1][0]!=2 || n[i+2][0]!=1 || (o=n[i+1][1])[0][0]!=5 ||
									(ok=o.length)<5 || o[1][0]!=7 || o[2][0]!=5 || o[2][1]!='in' ){
									err[err.length]=["forarray syntax error",n[i][2]];	
								}else{
									s[s.length]=';jfra(function(i,len,'+o[0][1]+'){';
									compile_recur(s,n[i+2][1]);
									s[s.length]='},';
									compile_recur(s,o, 3);
									s[s.length]=');';i+=2;
								}break; 
							case 4://macro
								//we should have ws, word, quote, code
								if( i>=k-4 || n[i+1][0]!=7 || n[i+2][0]!=5 || n[i+3][0]!=2 || n[i+4][0] != 1){
									err[err.length]=["macro syntax error at",n[0][2]];
								}else{	
									s[s.length] = 'function '+n[i+2][1]+'(s,n,';
									if(!compile_recur(s,n[i+3][1]))s[s.length]='null';
									s[s.length]='){';compile_recur(s,n[i+4][1]);s[s.length]='}';
									i+=4;
								}
								break;
							case 5://pragma
							{
								if( i>=k-3 || n[i+1][0]!=7 || n[i+2][0]!=5 || n[i+3][0]!=2){
									err[err.length]=["macro syntax error at",n[0][2]];
								}else{	
									switch(n[i+2][1]){
										case 'trace':{
											var ts =[];
											compile_recur(ts,n[i+3][1]);
											pragma_trace = eval(ts.join(''));
										}break;
									}
								}
								i+=3;
							}
							case 6://trace
							{
								s[s.length]=';alert("Trace: '+line_pos(n[i][2])+'");';
							}
						}							
					}else{
						if(macros[m] && nt1 == 2){
							s[s.length] = m+'(s,n,';if(!compile_recur(s,n[i+1][1]))s[s.length]='null';s[s.length] = ')';
							i++;
						}else s[s.length] = m;
					}
					// check our type
				}
				//shorthand expansion
				else if(t==9){
					var nt1=(i<k-1)?n[i+1][0]:-1,nt2=(i<k-2)?n[i+2][0]:-1;
					var m = n[i][1];
					
					if(nt1==12){
						if(nt2==1){
							if(d=short_2[m]){
								s[s.length] = d[0];compile_recur(s,n[i+2][1]);s[s.length] = d[1]+n[i+1][1]+d[2];
								i+=2;lt=1;
							}
							else s[s.length]=m;
						}
						else{
							if(d=short_1[m]){
								if(nt2==11)s[s.length]=m;
								else{
									s[s.length] = d[0]+n[i+1][1]+d[1];
									i++;
								}
							}
							else {
								if( d=short_0[m] )s[s.length]=d;
								else s[s.length]=m;
							}		
						}	
					}else{
						if( d=short_0[m] )s[s.length]=d;
						else s[s.length]=m;
					}		
				}
				// normal add
				else{
					if(t<3){
						s[s.length] = types[t];compile_recur(s,n[i][1]);s[s.length]=closes[t];

						// ; insertion code
						if( (t==1 && i<k-1 && n[i+1][0]==5 && n[i+1][1]!='else') ||  // }word
							 ( t==2 && i<k-1 && n[i+1][0]==5 && !n[i+1][1].match(/^\./) && // )word
							   (i==0 || n[i-1][0]!=5 || !n[i-1][1].match(/^(if|for)$/) ) ) )
						{
							s[s.length] = ';';
						}

					}
					else{
						
						if(t==3)s[s.length]=';s[s.length]="'+n[i][1].replace(/\"/g,"\\\"").replace(/\n/g,"\\n")+'";';
						else if(t==4){
							var m = n[i][1].match(/^\^([\w])\s?/);
							if(m){
								s[s.length]=';s[s.length]=jesc(jval(n,"'+n[i][1].substr(2).replace(/"/g,"\\\"")+'"),"'+m[1]+'");';
							}else{
								s[s.length]=';s[s.length]=jval(n,"'+n[i][1].replace(/"/g,"\\\"")+'");';
							}
						}
						else s[s.length]=n[i][1];
					}
				}
				//lt = n[i][0];
			}
			return k;
		}	
		if(err.length==0)compile_recur(s,tree);
						
		// return all parse errors
		if(err.length>0){
			var e=[];
			for(var i = 0;i<err.length;i++){
				e[e.length]='Parse error('+line_pos(err[i][1])+'): '+err[i][0]+'\n';


			}
			// lets spit out our parse tree

			//var out=[];
			//dump_tree(tree,out,'');
						
			throw new Error(0, "Could not parse JSLT with: " + e.join('') +"\n" );
		}

		s[s.length]=";return s.join('');";
		var strJS = s.join('');

		try{eval("var f = function(n){" + strJS + "};");}catch(e){
			//var treedump=[];
			//dump_tree(tree,treedump,'');	
			setStatus(formatJS(strJS));
			throw new Error(0, "Could not parse JSLT with: " + e.message /*+ "\n" + treedump.join('')*/);
		}
	
		return [f, strJS];
	};
	
	/************************************************
		//you can interchange nodes and strings
		apply(jsltStr, xmlStr);
		apply(jsltNode, xmlNode);
		
		returns string or false
	************************************************/
	this.cache = [];
	
	this.apply = function(jsltNode, xmlNode){
		var jsltFunc, cacheId, jsltStr, doTest;
		
		//Type detection xmlNode
		var xmlNode = XMLDatabase.getBindXmlNode(xmlNode);
		
		//Type detection jsltNode
		if(typeof jsltNode == "object"){
			
			//check the jslt node for cache setting
			cacheId = jsltNode.getAttribute("cache");
			jsltFunc = this.cache[cacheId];
			if(!jsltFunc) jsltStr = jsltNode.selectSingleNode('text()').nodeValue
		}
		else{
			cacheId = jsltNode;
			jsltFunc = this.cache[cacheId];
			if(!jsltFunc) jsltStr = jsltNode;
		}
		
		//Compile string
		if(!jsltFunc)
			jsltFunc = this.compile(jsltStr);
		
		this.lastJslt = jsltStr;
		this.lastJs = jsltFunc[0]; //if it crashes here there is something seriously wrong
		
		//Invalid code - Syntax Error
		if(!jsltFunc[0]) return false;
		
		//Caching
		if(!cacheId){
			if(typeof jsltNode == "object"){
				cacheId = this.cache.push(jsltFunc) - 1
				jsltNode.setAttribute("cache", cacheId);
			}
			else this.cache[jsltStr] = jsltFunc;
		}
		
		//Execute JSLT
		try{
			if(!xmlNode) return '';
			
			return jsltFunc[0](xmlNode);
		}
		catch(e){
			setStatus(formatJS(jsltFunc[1]));
			throw new Error(0, Kernel.formErrorString(0, null, "JSLT parsing", "Could not execute JSLT with: " + e.message));
		}
	}
}
var JSLT = new _JSLT();
/*FILEHEAD(/in/Core/Kernel/browsers/nonIE.js)SIZE(17188)TIME(1182795805263)*/

/*FILEHEAD(/in/Core/Kernel/browsers/isIE.js)SIZE(8312)TIME(1188383718500)*/

/*FILEHEAD(/in/Core/Kernel/browsers/isSafari.js)SIZE(3538)TIME(1182723583203)*/

/*FILEHEAD(/in/Core/Kernel/browsers/isGecko.js)SIZE(4587)TIME(1170043381799)*/

/*FILEHEAD(/in/Core/Kernel/browsers/isBrowser.js)SIZE(1200)TIME(1182726961382)*/
function runIE(){
	
/********* XML Compatibility ************************************************
	Extensions to the XMLDatabase
****************************************************************************/

var hasIE7Security = hasIESecurity = false;
if(IS_IE7) try{new XLMHttpRequest()}catch(e){hasIE7Security=true}
try{new ActiveXObject("microsoft.XMLHTTP")}catch(e){hasIESecurity=true}

function fixIESecurity(){
	__CONTENT_IFRAME
}
if(hasIESecurity) importClass(fixIESecurity, true, self);

Kernel.getObject = hasIESecurity ? 
function(type, message, no_error, isDataIsland){
	if(type == "HTTP"){
		if(Kernel.availHTTP.length) return Kernel.availHTTP.pop();
		//if((HAS_DESKRUN||HAS_WEBRUN) && !self.USENATIVEHTTP) return jdshell.CreateComponent("XMLHTTP");
		
		return new XMLHttpRequest();
	}
	else if(type == "XMLDOM"){
		xmlParser = getDOMParser(message, no_error);
		return xmlParser;
	}
} :
function(type, message, no_error, isDataIsland){
	if(type == "HTTP"){
		if(Kernel.availHTTP.length) return Kernel.availHTTP.pop();
		//if((HAS_DESKRUN||HAS_WEBRUN) && !self.USENATIVEHTTP) return jdshell.CreateComponent("XMLHTTP");

		//if(IS_IE7 && !hasIE7Security) return new XMLHttpRequest();
		return new ActiveXObject("microsoft.XMLHTTP");
	}
	else if(type == "XMLDOM"){
		xmlParser = new ActiveXObject("microsoft.XMLDOM");
		
		xmlParser.setProperty("SelectionLanguage", "XPath");
		//xmlParser.setProperty("SelectionNamespaces", "xmlns:j='http://www.javeline.nl/j'");
		
		//if(!isDataIsland) xmlParser.preserveWhiteSpace = true;
		if(message){
			if(IS_IE50) message = message.replace(/\] \]/g, "] ]").replace(/^<\?[^>]*\?>/, "");//replace xml definition <?xml .* ?> for IE5.0 
			
			xmlParser.loadXML(message);
		}
		if(!no_error) this.xmlParseError(xmlParser);
		
		return xmlParser;
	}
};

Kernel.xmlParseError = function(xml){
	var xmlParseError = xml.parseError;
	if(xmlParseError != 0){
		/*
			http://msdn.microsoft.com/library/en-us/xmlsdk30/htm/xmobjpmexmldomparseerror.asp?frame=true
		
			errorCode 	Contains the error code of the last parse error. Read-only. 
			filepos 		Contains the absolute file position where the error occurred. Read-only. 
			line 			Specifies the line number that contains the error. Read-only. 
			linepos 		Contains the character position within the line where the error occurred. Read-only. 
			reason 		Explains the reason for the error. Read-only. 
			srcText 		Returns the full text of the line containing the error. Read-only. 
			url 			Contains the URL of the XML document containing the last error. Read-only. 
		*/
		
		throw new Error(1050, Kernel.formErrorString(1050, null, "XML Parse error on line " +  xmlParseError.line, xmlParseError.reason + "Source Text:\n" + xmlParseError.srcText.replace(/\t/gi, " ")));
	}
	
	return xml;
}

function extendXmlDb(){

_XMLDatabase.prototype.htmlImport = function(xmlNode, htmlNode, beforeNode){
	if(xmlNode.length != null && !xmlNode.nodeType){
		for(var str='',i=0;i<xmlNode.length;i++) str += xmlNode[i].xml;
		var str = html_entity_decode(str).replace(/style="background-image:([^"]*)"/g, "find='$1' style='background-image:$1'");
		try{(beforeNode || htmlNode).insertAdjacentHTML(beforeNode ? "beforebegin" : "beforeend", str);}
		catch(e){
			//IE table hack
			document.body.insertAdjacentHTML("beforeend", "<table><tr>" + str + "</tr></table>");
			var x = document.body.lastChild.firstChild.firstChild;
			for(var i=x.childNodes.length-1;i>=0;i--) htmlNode.appendChild(x.childNodes[IS_IE7 ? 0 : i]);
		}

		//Fix IE image loading bug
		if(!this.nodes) this.nodes = [];
		var id = this.nodes.push(htmlNode.getElementsByTagName("*")) - 1;
		setTimeout('XMLDatabase.doNodes(' + id + ')');

		return;
	}
	
	//== ??? OR !=
	if(htmlNode.ownerDocument && htmlNode.ownerDocument != document && xmlNode.ownerDocument == htmlNode.ownerDocument) 
		return htmlNode.insertBefore(xmlNode, beforeNode);
	//if(htmlNode.ownerDocument && htmlNode.ownerDocument != document) return htmlNode.insertBefore(xmlNode, beforeNode);

	var strHTML = html_entity_decode(xmlNode.outerHTML || xmlNode.xml || xmlNode.nodeValue);
	var pNode = (beforeNode || htmlNode);
	if(pNode.nodeType == 11){
		var id = xmlNode.getAttribute("id");
		if(!id) throw new Error(1049, Kernel.formErrorString(1049, null, "XMLDatabase", "Inserting Cache Item in Document Fragment without an ID"));
		
		document.body.insertAdjacentHTML(beforeNode ? "beforebegin" : "beforeend", strHTML);
		pNode.appendChild(document.getElementById(id));
	}
	else pNode.insertAdjacentHTML(beforeNode ? "beforebegin" : "beforeend", strHTML);
	
	return beforeNode ? beforeNode.previousSibling : htmlNode.lastChild;
}

_XMLDatabase.prototype.doNodes = function(id){
	var nodes = this.nodes[id];
	for(var i=0;i<nodes.length;i++){
		if(nodes[i].getAttribute("find")) nodes[i].style.backgroundImage = nodes[i].getAttribute("find");
	}
	this.nodes[id] = null;
}

//Initialize XMLDatabase
XMLDatabase = new _XMLDatabase();

}

Init.addConditional(extendXmlDb, self, '_XMLDatabase');
if(!hasIESecurity) Init.run('XMLDatabase');


//IE5.5 compat
function getOwnerDocument(node){
	o = node;
	while(o.parentNode && o.nodeType != 9) o = o.parentNode;
	//node.ownerDocument = o;
	return o;
}

if(!document.createDocumentFragment){
	function DocFrag(){
		this.childNodes = [];
		
		this.appendChild = function(childNode){
			this.childNodes.push(childNode);
		}
		
		this.reinsert = function(parent){
			for(var i=0;i<this.childNodes.length;i++){
				parent.appendChild(this.childNodes[i]);
			}
		}
	}
}



if(self.USEPOPUP){
	Kernel.Popup = {
		cache : {},
		setContent : function(cacheId, content, style, width, height){
			if(!this.popup) this.init();
	
			this.cache[cacheId] = {
				content : content,
				style : style,
				width : width,
				height : height
			};
			if(content.parentNode) content.parentNode.removeChild(content);
			if(style) Kernel.importCssString(this.popup.document, style);
			
			return this.popup.document;
		},
		removeContent : function(cacheId){
			this.cache[cacheId] = null;
			delete this.cache[cacheId];
		},
		init : function(){
			this.popup = window.createPopup();
			
			this.popup.document.write('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html xmlns="http://www.w3.org/1999/xhtml" xmlns:j="http://www.javeline.net/j" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"><head><script>var Kernel = {all:[],lookup:function(uniqueId){return this.all[uniqueId]||{__setStyleClass:function(){}};}};function destroy(){Kernel.all=null;}</script><style>HTML{border:0;overflow:hidden;margin:0}BODY{margin:0}</style></head><body onmouseover="if(!self.Kernel) return;if(this.c){Kernel.all = this.c.all;this.c.Popup.parentDoc=self;}"></body></html>');
			
			var c = Kernel;
			this.popup.document.body.onmousemove = function(){this.c = c}
		},
		show : function(cacheId, x, y, animate, ref, width, height, callback){
			if(!this.popup) this.init();
			var o = this.cache[cacheId];
			//if(this.last != cacheId) 
			this.popup.document.body.innerHTML = o.content.outerHTML;
	
			if(animate){
				var iVal, steps = 7, i = 0, popup = this.popup;
				iVal = setInterval(function(){
					var value = ++i*((height || o.height)/steps);
					popup.show(x, y, width || o.width, value, ref);
					popup.document.body.firstChild.style.marginTop = (i-steps-1)*((height || o.height)/steps);
					if(i > steps){
						clearInterval(iVal)
						callback(popup.document.body.firstChild);
					}
				}, 10);
			}
			else{
				this.popup.show(x, y, width || o.width, height || o.height, ref);
			}
	
			this.last = cacheId;
		},
		hide : function(){
			if(this.popup) this.popup.hide();
		},
		forceHide : function(){
			if(this.last) Kernel.lookup(this.last).dispatchEvent("onpopuphide");
		},
		destroy : function(){
			if(!this.popup) return;
			this.popup.document.body.c = null;
			this.popup.document.body.onmouseover = null;
		}
	}
}

	
	importClass(runXpath, true, self);
}

function runSafari(){
	setTimeoutSafari = setTimeout;
lookupSafariCall = [];
setTimeout = function(call, time){
	if(typeof call == "string") return setTimeoutSafari(call, time);
	return setTimeoutSafari("lookupSafariCall[" + (lookupSafariCall.push(call)-1) + "]()", time);
}

if(IS_SAFARI_OLD){
	HTMLHtmlElement = document.createElement("html").constructor;
	Node = HTMLElement = {};
	HTMLElement.prototype = HTMLHtmlElement.__proto__.__proto__;
	HTMLDocument = Document = document.constructor;
	var x = new DOMParser();
	XMLDocument = x.constructor;
	Element = x.parseFromString("<Single />", "text/xml").documentElement.constructor;
	x = null;
}

/****************************************************************************
	XML Serialization
****************************************************************************/

//XMLDocument.xml
Document.prototype.serialize = 
Node.prototype.serialize = 
XMLDocument.prototype.serialize = function(){
	return (new XMLSerializer()).serializeToString(this);
}
//Node.xml
/*Node.prototype.serialize = function(){
	return (new XMLSerializer()).serializeToString(this);
}*/
//Node.xml


if(IS_SAFARI_OLD || IS_SAFARI){
	//XMLDocument.selectNodes
	HTMLDocument.prototype.selectNodes = 
	XMLDocument.prototype.selectNodes = function(sExpr, contextNode){
		return XPath.selectNodes(sExpr, contextNode || this);
	}
	
	//Element.selectNodes
	Element.prototype.selectNodes = function(sExpr, contextNode){
		return XPath.selectNodes(sExpr, contextNode || this);
	};
	
	//XMLDocument.selectSingleNode
	HTMLDocument.prototype.selectSingleNode = 
	XMLDocument.prototype.selectSingleNode = function(sExpr, contextNode){
		return XPath.selectNodes(sExpr, contextNode || this)[0];
	}
	
	//Element.selectSingleNode
	Element.prototype.selectSingleNode = function(sExpr, contextNode){
		return XPath.selectNodes(sExpr, contextNode || this)[0];
	};
	
	importClass(runXpath, true, self);
	importClass(runXslt, true, self);
}
/*else{
	//XMLDocument.selectNodes
	HTMLDocument.prototype.selectNodes = 
	XMLDocument.prototype.selectNodes = function(sExpr, contextNode){
		var oResult = this.evaluate(sExpr, (contextNode?contextNode:this), this.createNSResolver(this.documentElement), XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
		var nodeList = new Array(oResult.snapshotLength);
		nodeList.expr = sExpr;
		for(i=0;i<nodeList.length;i++) nodeList[i] = oResult.snapshotItem(i);
		return nodeList;
	
	}
	
	//Element.selectNodes
	Element.prototype.selectNodes = function(sExpr){
		var doc = this.ownerDocument;
		if(doc.selectNodes)
			return doc.selectNodes(sExpr, this);
		else
			throw new Error(1047, Kernel.formErrorString(1047, null, "xPath selection", "Method selectNodes is only supported by XML Nodes"));
	};
	
	//XMLDocument.selectSingleNode
	HTMLDocument.prototype.selectSingleNode = 
	XMLDocument.prototype.selectSingleNode = function(sExpr, contextNode){
		var nodeList = this.selectNodes(sExpr + "[1]", contextNode?contextNode:null);
		return nodeList.length > 0 ? nodeList[0] : null;
	}
	
	//Element.selectSingleNode
	Element.prototype.selectSingleNode = function(sExpr){
		var doc = this.ownerDocument;
		if(doc.selectSingleNode)
			return doc.selectSingleNode(sExpr, this);
		else
			throw new Error(1048, Kernel.formErrorString(1048, null, "XPath Selection", "Method selectSingleNode is only supported by XML Nodes. \nInfo : " + e));
	};
}*/



	importClass(runNonIe, true, self);
}

function runGecko(){
	importClass(runNonIe, true, self);
	
DocumentFragment.prototype.getElementById = function(id){
	return this.childNodes.length ? this.childNodes[0].ownerDocument.getElementById(id) : null;
}

/****************************************************************************
	XML Serialization
****************************************************************************/

//XMLDocument.xml
XMLDocument.prototype.__defineGetter__("xml", function(){
	return (new XMLSerializer()).serializeToString(this);
});
XMLDocument.prototype.__defineSetter__("xml", function(){
	throw new Error(1042, Kernel.formErrorString(1042, null, "XML serializer", "Invalid assignment on read-only property 'xml'."));
});

//Node.xml
Node.prototype.__defineGetter__("xml", function(){
	if(this.nodeType == 3 || this.nodeType == 4 || this.nodeType == 2) return this.nodeValue;
	return (new XMLSerializer()).serializeToString(this);
});

//Node.xml
Element.prototype.__defineGetter__("xml", function(){
	return (new XMLSerializer()).serializeToString(this);
});

/****************************************************************************
	XSLT
****************************************************************************/


//XMLDocument.selectNodes
HTMLDocument.prototype.selectNodes = 
XMLDocument.prototype.selectNodes = function(sExpr, contextNode){
	var oResult = this.evaluate(sExpr, (contextNode?contextNode:this), this.createNSResolver(this.documentElement), XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
	var nodeList = new Array(oResult.snapshotLength);
	nodeList.expr = sExpr;
	for(i=0;i<nodeList.length;i++) nodeList[i] = oResult.snapshotItem(i);
	return nodeList;
}

//Element.selectNodes
Element.prototype.selectNodes = function(sExpr){
	var doc = this.ownerDocument;
	if(doc.selectNodes)
		return doc.selectNodes(sExpr, this);
	else
		throw new Error(1047, Kernel.formErrorString(1047, null, "xPath selection", "Method selectNodes is only supported by XML Nodes"));
};

//XMLDocument.selectSingleNode
HTMLDocument.prototype.selectSingleNode = 
XMLDocument.prototype.selectSingleNode = function(sExpr, contextNode){
	var nodeList = this.selectNodes(sExpr + "[1]", contextNode?contextNode:null);
	return nodeList.length > 0 ? nodeList[0] : null;
}

//Element.selectSingleNode
Element.prototype.selectSingleNode = function(sExpr){
	var doc = this.ownerDocument;
	if(doc.selectSingleNode)
		return doc.selectSingleNode(sExpr, this);
	else
		throw new Error(1048, Kernel.formErrorString(1048, null, "XPath Selection", "Method selectSingleNode is only supported by XML Nodes. \nInfo : " + e));
};


/********* Error Compatibility **********************************************
	Error Object like IE
****************************************************************************/

function Error(nr, msg){
	if(!USE_DEBUGGER) __ErrorHandler(msg, "", 0);
	
	this.message = msg;
	this.nr = nr;
}

/********* XML Compatibility ************************************************
	Extensions to the XMLDatabase
****************************************************************************/

if(self._XMLDatabase){
	_XMLDatabase.prototype.htmlImport = function(xmlNode, htmlNode, beforeNode, test){
		if(!htmlNode) alert(this.htmlImport.caller);
		
		if(xmlNode.length != null && !xmlNode.nodeType){
			for(var str='',i=0;i<xmlNode.length;i++) str += xmlNode[i].xml;
			var str = str.replace(/&lt;/g, "<").replace(/&gt;/g, ">").replace(/<([^>]+)\/>/g, "<$1></$1>");
			(beforeNode || htmlNode).insertAdjacentHTML(beforeNode ? "beforebegin" : "beforeend", str);

			return;
		}
		
		if(htmlNode.ownerDocument != document) return htmlNode.insertBefore(xmlNode, beforeNode);
		
		var strHTML = (xmlNode.outerHTML || (xmlNode.nodeType == 1 ? xmlNode.xml : xmlNode.nodeValue)).replace(/&lt;/g, "<").replace(/&gt;/g, ">");
		var pNode = (beforeNode || htmlNode);
		if(pNode.nodeType == 11){
			var id = xmlNode.getAttribute("id");
			if(!id) throw new Error(1049, Kernel.formErrorString(1049, null, "XMLDatabase", "Inserting Cache Item in Document Fragment without an ID"));
			
			document.body.insertAdjacentHTML(beforeNode ? "beforebegin" : "beforeend", strHTML);
			pNode.appendChild(document.getElementById(id));
		}
		else{
			pNode.insertAdjacentHTML(beforeNode ? "beforebegin" : "beforeend", strHTML);
		}
		
		return beforeNode ? beforeNode.previousSibling : htmlNode.lastChild;
	}
}


}

function runOpera(){
	setTimeoutOpera = setTimeout;
lookupOperaCall = [];
setTimeout = function(call, time){
	if(typeof call == "string") return setTimeoutOpera(call, time);
	return setTimeoutOpera("lookupOperaCall[" + (lookupOperaCall.push(call)-1) + "]()", time);
}

//HTMLHtmlElement = document.createElement("html").constructor;
//HTMLElement = {};
//HTMLElement.prototype = HTMLHtmlElement.__proto__.__proto__;
//HTMLDocument = Document = document.constructor;
var x = new DOMParser();
XMLDocument = DOMParser.constructor;
//Element = x.parseFromString("<Single />", "text/xml").documentElement.constructor;
x = null;

/****************************************************************************
	XML Serialization
****************************************************************************/

//XMLDocument.xml

//Node.xml
/*Node.prototype.serialize = function(){
	return (new XMLSerializer()).serializeToString(this);
}*/
//Node.xml

Node.prototype.serialize = 
XMLDocument.prototype.serialize = 
Element.prototype.serialize = function(){
	return (new XMLSerializer()).serializeToString(this);
}


//XMLDocument.selectNodes
Document.prototype.selectNodes = 
XMLDocument.prototype.selectNodes = 
HTMLDocument.prototype.selectNodes = function(sExpr, contextNode){
	var oResult = this.evaluate(sExpr, (contextNode?contextNode:this), this.createNSResolver(this.documentElement), XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
	var nodeList = new Array(oResult.snapshotLength);
	nodeList.expr = sExpr;
	for(i=0;i<nodeList.length;i++) nodeList[i] = oResult.snapshotItem(i);
	return nodeList;
}

//Element.selectNodes
Element.prototype.selectNodes = function(sExpr){
	var doc = this.ownerDocument;
	if(!doc.selectSingleNode){
		doc.selectSingleNode = HTMLDocument.prototype.selectSingleNode;
		doc.selectNodes = HTMLDocument.prototype.selectNodes;
	}
	
	if(doc.selectNodes)
		return doc.selectNodes(sExpr, this);
	else
		throw new Error(1047, Kernel.formErrorString(1047, null, "XPath Selection", "Method selectNodes is only supported by XML Nodes"));
};

//XMLDocument.selectSingleNode
Document.prototype.selectSingleNode = 
XMLDocument.prototype.selectSingleNode = 
HTMLDocument.prototype.selectSingleNode = function(sExpr, contextNode){
	var nodeList = this.selectNodes(sExpr + "[1]", contextNode?contextNode:null);
	return nodeList.length > 0 ? nodeList[0] : null;
}

//Element.selectSingleNode
Element.prototype.selectSingleNode = function(sExpr){
	var doc = this.ownerDocument;
	if(!doc.selectSingleNode){
		doc.selectSingleNode = HTMLDocument.prototype.selectSingleNode;
		doc.selectNodes = HTMLDocument.prototype.selectNodes;
	}
	
	if(doc.selectSingleNode)
		return doc.selectSingleNode(sExpr, this);
	else
		throw new Error(1048, Kernel.formErrorString(1048, null, "XPath Selection", "Method selectSingleNode is only supported by XML Nodes. \nInfo : " + e));
};



Kernel.compat.getWidthDiff = function(oHtml){
	return Math.max(0, (parseInt(Kernel.compat.getStyle(oHtml, "padding-left"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "padding-right"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "border-left-width"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "border-right-width"))||0));
}

Kernel.compat.getHeightDiff = function(oHtml){
	return Math.max(0, (parseInt(Kernel.compat.getStyle(oHtml, "padding-top"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "padding-bottom"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "border-top-width"))||0) + (parseInt(Kernel.compat.getStyle(oHtml, "border-bottom-width"))||0));
}

Kernel.compat.getDiff = function(oHtml){
	var pNode = oHtml.parentNode; var nSibling = oHtml.nextSibling;
	if(!oHtml.offsetHeight) document.body.appendChild(oHtml);

	/*
	alert(
		Kernel.compat.getStyle(oHtml, "padding") + ":" + Kernel.compat.getStyle(oHtml, "border-width") + ":" + oHtml.offsetWidth + ":" + Kernel.compat.getStyle(oHtml, "width") + ":" + oHtml.clientWidth + ":" + oHtml.currentStyle.width + "\n" +
		Kernel.compat.getStyle(oHtml, "padding") + ":" + Kernel.compat.getStyle(oHtml, "border-width") + ":" + oHtml.offsetHeight + ":" + Kernel.compat.getStyle(oHtml, "height") + ":" + oHtml.clientHeight + ":" + oHtml.currentStyle.height + "\n" +
		diff
	);
	*/
	
	var diff = [
		Math.max(0, parseInt(Kernel.compat.getStyle(oHtml, "padding-left")) + parseInt(oHtml.currentStyle.paddingRight) + parseInt(Kernel.compat.getStyle(oHtml, "border-left-width")) + parseInt(Kernel.compat.getStyle(oHtml, "border-right-width")) || 0),
		Math.max(0, parseInt(Kernel.compat.getStyle(oHtml, "padding-top")) + parseInt(oHtml.currentStyle.paddingBottom) + parseInt(Kernel.compat.getStyle(oHtml, "border-top-width")) + parseInt(Kernel.compat.getStyle(oHtml, "border-bottom-width")) || 0)
	];
	if(oHtml.tagName.match(/frame/i)) alert(diff);
	//alert(parseInt(oHtml.currentStyle.paddingLeft) + ":" +  parseInt(oHtml.currentStyle.paddingRight) + ":" +  parseInt(oHtml.currentStyle.borderLeftWidth) + ":" +  parseInt(oHtml.currentStyle.borderRightWidth));

	pNode.insertBefore(oHtml, nSibling);
	
	return diff;
}



	importClass(runNonIe, true, self);
}

function runNonIe(){
	

/********* HTML Interfaces **************************************************
	insertAdjacentHTML(), insertAdjacentText() and insertAdjacentElement()
****************************************************************************/
if(typeof HTMLElement!="undefined"){
	if(!HTMLElement.prototype.insertAdjacentElement){
		HTMLElement.prototype.insertAdjacentElement = function(where,parsedNode){
			switch(where.toLowerCase()){
				case "beforebegin":
					this.parentNode.insertBefore(parsedNode,this);
					break;
				case "afterbegin":
					this.insertBefore(parsedNode,this.firstChild);
					break;
				case "beforeend":
					this.appendChild(parsedNode);
					break;
				case "afterend":
					if (this.nextSibling) this.parentNode.insertBefore(parsedNode,this.nextSibling);
					else this.parentNode.appendChild(parsedNode);
					break;
			}
		};
	}

	if(!HTMLElement.prototype.insertAdjacentHTML){
		HTMLElement.prototype.insertAdjacentHTML = function(where,htmlStr){
			var r = this.ownerDocument.createRange();
			r.setStartBefore(IS_SAFARI ? document.body : this);
			var parsedHTML = r.createContextualFragment(htmlStr);
			this.insertAdjacentElement(where,parsedHTML);
		}
	}

	if(!HTMLElement.prototype.insertAdjacentText){
		HTMLElement.prototype.insertAdjacentText = function(where,txtStr){
			var parsedText = document.createTextNode(txtStr);
			this.insertAdjacentElement(where,parsedText);
		}
	}
	
	//HTMLElement.removeNode
	HTMLElement.prototype.removeNode = function(){
		if(!this.parentNode) return;
		this.parentNode.removeChild(this);
	}
	
	//Currently only supported by Gecko
	if(HTMLElement.prototype.__defineSetter__){
		//HTMLElement.innerText
		HTMLElement.prototype.__defineSetter__("innerText", function(sText){
			var s = "" + sText;
			this.innerHTML = s.replace(/\&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
		});
	
		HTMLElement.prototype.__defineGetter__("innerText", function(){
			return this.innerHTML.replace(/<[^>]+>/g,"").replace(/\s\s+/g, " ").replace(/^\s*|\s*$/g, " ")
		});
		
		HTMLElement.prototype.__defineGetter__("outerHTML", function(){
			return (new XMLSerializer()).serializeToString(this);
		});
	}
}

/********* XML Compatibility ************************************************
	Giving the Mozilla XML Parser the same interface as IE's Parser
****************************************************************************/
var IEPREFIX4XSLPARAM = "";
var ASYNCNOTSUPPORTED = false;

//Test if Async is supported
try{
	XMLDocument.prototype.async = true;
	ASYNCNOTSUPPORTED = true;
}catch(e){/*trap*/} 

Document.prototype.onreadystatechange = null;
Document.prototype.parseError = 0;

Array.prototype.item = function(i){return this[i];};
Array.prototype.expr = "";

XMLDocument.prototype.readyState = 0;

XMLDocument.prototype.__clearDOM = function(){
	while(this.hasChildNodes())
		this.removeChild(this.firstChild);
}

XMLDocument.prototype.__copyDOM = function(oDoc){
	this.__clearDOM();
	
	if(oDoc.nodeType == 9 || oDoc.nodeType == 11){
	   var oNodes = oDoc.childNodes;

	   for(i=0;i<oNodes.length;i++)
			this.appendChild(this.importNode(oNodes[i], true));
	}
	else if(oDoc.nodeType == 1)
   	this.appendChild(this.importNode(oDoc, true));
}

//XMLDocument.loadXML();
XMLDocument.prototype.loadXML = function(strXML){
	XMLDatabase.setReadyState(this, 1);
	var sOldXML = this.xml || this.serialize();
	var oDoc = (new DOMParser()).parseFromString(strXML, "text/xml");
	XMLDatabase.setReadyState(this, 2);
	this.__copyDOM(oDoc);
	XMLDatabase.setReadyState(this, 3);
	XMLDatabase.loadHandler(this);
	return sOldXML;
};

Node.prototype.getElementById = function(id){}

HTMLElement.prototype.replaceNode = 
Element.prototype.replaceNode = function(xmlNode){
	if(!this.parentNode) return;
	this.parentNode.insertBefore(xmlNode, this);
	this.parentNode.removeChild(this);
}

//XMLDocument.load
XMLDocument.prototype.__load = XMLDocument.prototype.load;
XMLDocument.prototype.load = function(sURI){
	var oDoc = document.implementation.createDocument("", "", null);
	oDoc.__copyDOM(this);
	this.parseError = 0;
	XMLDatabase.setReadyState(this, 1);

	try{
		if(this.async == false && ASYNCNOTSUPPORTED){
			var tmp = new XMLHttpRequest();
			tmp.open("GET", sURI, false);
			tmp.overrideMimeType("text/xml");
			tmp.send(null);
			XMLDatabase.setReadyState(this, 2);
			this.__copyDOM(tmp.responseXML);
			XMLDatabase.setReadyState(this, 3);
		}
		else this.__load(sURI);
	}
	catch(objException){this.parseError = -1;}
	finally{XMLDatabase.loadHandler(this);}

	return oDoc;
}



//Element.transformNodeToObject
Element.prototype.transformNodeToObject = function(xslDoc, oResult){
	var oDoc = document.implementation.createDocument("", "", null);
	oDoc.__copyDOM(this);
	oDoc.transformNodeToObject(xslDoc, oResult);
}

//Document.transformNodeToObject
Document.prototype.transformNodeToObject = function(xslDoc, oResult){
	var xsltProcessor = null;
	
	try{
		xsltProcessor = new XSLTProcessor();
		
		if(xsltProcessor.reset){
			// new nsIXSLTProcessor is available
			var xslDoc = Kernel.getObject("XMLDOM", xslDoc.xml || xslDoc.serialize());
			xsltProcessor.importStylesheet(xslDoc);
			var newFragment = xsltProcessor.transformToFragment(this, oResult);
			oResult.__copyDOM(newFragment);
		}
		else{
		    // only nsIXSLTProcessorObsolete is available
		    xsltProcessor.transformDocument(this, xslDoc, oResult, null);
		}
	}
	catch(e){
		if(xslDoc && oResult)
			throw new Error(1043, Kernel.formErrorString(1043, null, "XSLT Transformation", "Failed to transform document. \nInfo : " + e));
		else if(!xslDoc)
			throw new Error(1044, Kernel.formErrorString(1044, null, "XSLT Transformation", "No Stylesheet Document was provided. \nInfo : " + e));
		else if(!oResult)
			throw new Error(1045, Kernel.formErrorString(1045, null, "XSLT Transformation", "No Result Document was provided. \nInfo : " + e));
		else if(xsltProcessor == null)
			throw new Error(1046, Kernel.formErrorString(1046, null, "XSLT Transformation", "Could not instantiate an XSLTProcessor object. \nInfo : " + e));
		else
			throw e;
	}
};

//Element.transformNode
Element.prototype.transformNode = function(xslDoc){
	return Kernel.getObject("XMLDOM", this.xml || this.serialize()).transformNode(xslDoc);
}

//Document.transformNode
Document.prototype.transformNode = function(xslDoc){
	var xsltProcessor = new XSLTProcessor();
	var xslDoc = Kernel.getObject("XMLDOM", xslDoc.xml || xslDoc.serialize());
	xsltProcessor.importStylesheet(xslDoc);
	var newFragment = xsltProcessor.transformToFragment(this, document.implementation.createDocument("", "", null));

	return newFragment.xml || newFragment.serialize()
	
	/*try{
		var serializer = new XMLSerializer();
		str = serializer.serializeToString(out);
	}
	catch(e){
		throw new Error(0, "---- Javeline Error ----\nProcess : XSLT Transformation\nMessage : Failed to serialize result document. \nInfo : " + e);
	}
	
	return str;*/
}



//XMLDocument.setProperty
HTMLDocument.prototype.setProperty = 
XMLDocument.prototype.setProperty = function(x,y){};

/********* XML Compatibility ************************************************
	Extensions to the XMLDatabase
****************************************************************************/
Kernel.getObject = function(type, message, no_error){
	if(type == "HTTP"){
		if(Kernel.availHTTP.length) return Kernel.availHTTP.pop();
		return new XMLHttpRequest();
	}
	else if(type == "XMLDOM"){
		xmlParser = new DOMParser();
		if(message) xmlParser = xmlParser.parseFromString(message, "text/xml");
		if(!no_error) this.xmlParseError(xmlParser);
		return xmlParser;
	}
}

Kernel.xmlParseError = function(xml){
	if(xml.documentElement.tagName == "parsererror"){
		var str = xml.documentElement.firstChild.nodeValue.split("\n");
		var linenr = str[2].match(/\w+ (\d+)/)[1];
		var message = str[0].replace(/\w+ \w+ \w+: (.*)/, "$1");
		
		var srcText = xml.documentElement.lastChild.firstChild.nodeValue.split("\n")[0];
		throw new Error(1050, Kernel.formErrorString(1050, null, "XML Parse Error on line " +  linenr, message + "\nSource Text : " + srcText.replace(/\t/gi, " ")));
	}
	
	return xml;
}

if(self._XMLDatabase){
	_XMLDatabase.prototype.htmlImport = function(xmlNode, htmlNode, beforeNode, test){
		if(!htmlNode) alert("No HTML node given in htmlImport:" + this.htmlImport.caller);
		
		if(xmlNode.length != null && !xmlNode.nodeType){
			for(var str='',i=0;i<xmlNode.length;i++) str += xmlNode[i].serialize();
			var str = str.replace(/&lt;/g, "<").replace(/&gt;/g, ">").replace(/<([^>]+)\/>/g, "<$1></$1>");
			(beforeNode || htmlNode).insertAdjacentHTML(beforeNode ? "beforebegin" : "beforeend", str);

			return;
		}

		if(htmlNode.ownerDocument != document) return htmlNode.insertBefore(xmlNode, beforeNode);
		
		var strHTML = (xmlNode.outerHTML || (xmlNode.nodeType == 1 ? xmlNode.serialize() : xmlNode.nodeValue)).replace(/&lt;/g, "<").replace(/&gt;/g, ">");
		var pNode = (beforeNode || htmlNode);
		if(pNode.nodeType == 11){
			var id = xmlNode.getAttribute("id");
			if(!id) throw new Error(1049, Kernel.formErrorString(1049, null, "XMLDatabase", "Inserting Cache Item in Document Fragment without an ID"));
			
			document.body.insertAdjacentHTML(beforeNode ? "beforebegin" : "beforeend", strHTML);
			pNode.appendChild(document.getElementById(id));
		}
		else pNode.insertAdjacentHTML(beforeNode ? "beforebegin" : "beforeend", strHTML);
		
		return beforeNode ? beforeNode.previousSibling : htmlNode.lastChild;
	}
	
	_XMLDatabase.prototype.setReadyState = function(oDoc, iReadyState) {
		oDoc.readyState = iReadyState;
		if(oDoc.onreadystatechange != null && typeof oDoc.onreadystatechange == "function")
			oDoc.onreadystatechange();
	}
	
	_XMLDatabase.prototype.loadHandler = function(oDoc){
		if(!oDoc.documentElement || oDoc.documentElement.tagName == "parsererror")
			oDoc.parseError = -1;
		
		XMLDatabase.setReadyState(oDoc, 4);
	}
	
	//Initialize XMLDatabase
	XMLDatabase = new _XMLDatabase();
}

//Fix XML Data-Island Support Problem with Form Tag
Init.add(function(){
	var nodes = document.getElementsByTagName("form");
	for(var i=0;i<nodes.length;i++) nodes[i].removeNode();
	var nodes = document.getElementsByTagName("xml");
	for(var i=0;i<nodes.length;i++) nodes[i].removeNode();
	nodes = null;
});

//IE Like Error Handling
MAXMSG = 3;
ERROR_COUNT = 0;

/*window.onerror = function(message, filename, linenr){
	if(++ERROR_COUNT > MAXMSG) return;
	filename = filename ? filename.match(/\/([^\/]*)$/)[1] : "[Mozilla Library]";
	new Error(0, "---- Javeline Error ----\nProcess : Javascript code in '" + filename +  "'\nLine : " + linenr + "\nMessage : " + message);
	return false;
}*/

if(document.body) document.body.focus = function(){}

/*
//CurIndex = 0;
//CurValue is []
//FoundValue is []
//FoundNode is null
//Loop through childNodes
//if(Child is position absolute/relative and overflow == "hidden" && !inSpace) continue;

//if (Child is position absolute/relative and has zIndex) or overflow == "hidden"
	//if(!is position absolute/relative) zIndex = 0
	//if zIndex >= FoundValue[CurIndex] 
		//if zIndex > CurValue[CurIndex];
			//clear all CurValue values after CurIndex
			//set CurValue[CurIndex] = zIndex
		//CurIndex++
		//if(inSpace && CurIndex >= FoundValue.length)
			//Set FoundNode is currentNode
			//Set FoundValue is CurValue
	//else continue; //Ignore this treedepth
//else if CurValue[CurIndex] continue; //Ignore this treedepth

//loop through childnodes recursively
*/

if(!document.elementFromPoint){
	Document.prototype.elementFromPointRemove = function(el){
		if(!this.RegElements) return;
		this.RegElements.remove(el);
	}
	
	Document.prototype.elementFromPointAdd = function(el){
		if(!this.RegElements) this.RegElements = [];
		this.RegElements.push(el);
	}
	
	Document.prototype.elementFromPointReset = function(RegElements){
		//define globals
		FoundValue = [];
		FoundNode = null;
		LastFoundAbs = document.documentElement;
	}
	
	Document.prototype.elementFromPoint = function(x, y){
		// Optimization, Keeping last found node makes it ignore all lower levels 
		// when there is no possibility of changing positions and zIndexes
		/*if(self.FoundNode){
			var sx = getElementPosX(FoundNode); 
			var sy = getElementPosY(FoundNode);
			var ex = sx + FoundNode.offsetWidth; var ey = sy + FoundNode.offsetHeight;
		}
		if(!self.FoundNode || !(x > sx && x < ex && y > sy && y < ey))*/
			document.elementFromPointReset();
	
		// Optimization only looking at registered nodes
		if(this.RegElements){
			for(var calc_z=-1,calc,i=0;i<this.RegElements.length;i++){
				var n = this.RegElements[i];
				if(getStyle(n, "display") == "none") continue;
	
				var sx = getElementPosX(n); 
				var sy = getElementPosY(n);
				var ex = sx + n.offsetWidth; var ey = sy + n.offsetHeight;
				
				if(x > sx && x < ex && y > sy && y < ey){
					var z = getElementZindex(n);
					if(z > calc_z){ //equal z-indexes not supported
						calc = [n, x, y, sx, sy];
						calc_z = z;
					}
				}
			}
			
			if(calc){
				efpi(calc[0], calc[1], calc[2], 0, FoundValue, calc[3], calc[4]);
				if(!FoundNode){
					FoundNode = calc[0];
					LastFoundAbs = calc[0];
					FoundValue = [calc_z];
				}
			}
		}
		
		if(!this.RegElements || !this.RegElements.length)
			efpi(document.body, x, y, 0, [], getElementPosX(document.body), getElementPosY(document.body));
			
		return FoundNode;
	}
	
	function getStyle(el, prop) {
		return document.defaultView.getComputedStyle(el,'').getPropertyValue(prop);
	}
	
	function efpi(from, x, y, CurIndex, CurValue, px, py){
		var StartValue = CurValue;
		var StartIndex = CurIndex;
		
		//Loop through childNodes
		var nodes = from.childNodes;
		for(var n,i=0;i<from.childNodes.length;i++){
			n = from.childNodes[i];
			if( n.nodeType != Node.TEXT_NODE && getStyle(n, 'display') != 'none' ){
				var sx = px + n.offsetLeft - (IS_GECKO ? n.offsetParent.scrollLeft : 0);//getElementPosX(n); 
				var sy = py + n.offsetTop - (IS_GECKO ? n.offsetParent.scrollTop : 0);//getElementPosY(n);
				var ex = sx + n.offsetWidth; var ey = sy + n.offsetHeight;
				
				//if(Child is position absolute/relative and overflow == "hidden" && !inSpace) continue;
				var isAbs = getStyle(n, "position");
				isAbs = isAbs == "absolute" || isAbs == "relative";
				var isHidden = getStyle(n, "overflow") == "hidden";
				var inSpace = (x > sx && x < ex && y > sy && y < ey);
				if(isAbs && isHidden && !inSpace) continue;
		
				CurIndex = StartIndex;
				CurValue = StartValue.copy();
		
				//if (Child is position absolute/relative and has zIndex) or overflow == "hidden"
				var z = parseInt(getStyle(n, "z-index"));
				if(isAbs && (z || z == 0) || isHidden){
					//if(!is position absolute/relative) zIndex = 0
					if(!isAbs) z = 0;
					
					//if zIndex >= FoundValue[CurIndex] 
					if(z >= (FoundValue[CurIndex] || 0)){
						//if zIndex > CurValue[CurIndex];
						if(z > (CurValue[CurIndex] || 0)){
							//CurValue = StartValue.copy();
							
							//set CurValue[CurIndex] = zIndex
							CurValue[CurIndex] = z;
						}
						
						CurIndex++
						
						//if(inSpace && CurIndex >= FoundValue.length)
						if(inSpace && CurIndex >= FoundValue.length){
							//Set FoundNode is currentNode
							FoundNode = n;
							//Set FoundValue is CurValue
							FoundValue = CurValue;//.copy();
							
							LastFoundAbs = n;
						}
					}
					//else continue; //Ignore this treedepth
					else continue;
				}
				//else if CurValue[CurIndex] continue; //Ignore this treedepth
				//else if(CurValue[CurIndex]) continue;
				else if(inSpace && CurIndex >= FoundValue.length){
					//Set FoundNode is currentNode
					FoundNode = n;
					//Set FoundValue is CurValue
					FoundValue = CurValue;//.copy();
				}
				
				//loop through childnodes recursively
				efpi(n, x, y, CurIndex, CurValue, isAbs ? sx : px, isAbs ? sy : py)
			}
		}
	}
	
	function getElementPosY(myObj){return myObj.offsetTop + parseInt(Kernel.compat.getStyle(myObj, "border-top-width")) + (myObj.offsetParent ? getElementPosY(myObj.offsetParent) : 0)}
	function getElementPosX(myObj){return myObj.offsetLeft + parseInt(Kernel.compat.getStyle(myObj, "border-left-width")) + (myObj.offsetParent ? getElementPosX(myObj.offsetParent) : 0)}
	function getElementZindex(myObj){
		//This is not quite sufficient and should be changed
		var z = 0, n, p = myObj;
		while(p && p.nodeType == 1){
			z = Math.max(z, parseInt(getStyle(p, "z-index")) || -1);
			p = p.parentNode;
		}
		return z;
	}
}

Init.run('XMLDatabase');


}

function runXpath(){
	
/********* IE XPath Object ************************************************
	Workaround for the lack of having an XPath parser on safari
	It works on Safari's document and XMLDocument object.
	
	It doesn't support the full XPath spec, but just enought for
	the skinning engine which needs XPath on the HTML document.
	
	Supports:
	- Compilation of xpath statements
	- Caching of XPath statements
****************************************************************************/
XPath = {
	cache : {},
	
	getChildNode : function(htmlNode, tagName, info, count, num, sResult){
		var numfound = 0, result = null, data = info[count];

		var nodes = htmlNode.childNodes;
		if(!nodes) return; //Weird bug in Safari
		for(var i=0;i<nodes.length;i++){
			if(tagName && (nodes[i].style ? nodes[i].tagName.toLowerCase() : nodes[i].tagName) != tagName) continue;// || numsearch && ++numfound != numsearch

			if(data) data[0](nodes[i], data[1], info, count+1, numfound++ , sResult);
			else sResult.push(nodes[i]);
		}
		
		//commented out :  && (!numsearch || numsearch == numfound)
	},
	
	doQuery : function(htmlNode, qData, info, count, num, sResult){
		var result = null, data = info[count];
		var query = qData[0];
		var returnResult = qData[1];
		try{var qResult = eval(query);}catch(e){return;}
		
		if(returnResult) return sResult.push(qResult);
		if(!qResult) return;
		
		if(data) data[0](htmlNode, data[1], info, count+1, 0, sResult);
		else sResult.push(htmlNode);
	},
	
	getTextNode : function(htmlNode, empty, info, count, num, sResult){
		var result = null, data = info[count];

		var nodes = htmlNode.childNodes;
		for(var i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 3 && nodes[i].nodeType != 4) continue;
			
			if(data) data[0](nodes[i], data[1], info, count+1, i, sResult);
			else sResult.push(nodes[i]);
		}
	},
	
	getAnyNode : function(htmlNode, empty, info, count, num, sResult){
		var result = null, data = info[count];

		var sel = [], nodes = htmlNode.childNodes;
		for(var i=0;i<nodes.length;i++){
			if(data) data[0](nodes[i], data[1], info, count+1, i, sResult);
			else sResult.push(nodes[i]);
		}
	},
	
	getAttributeNode : function(htmlNode, attrName, info, count, num, sResult){
		if(!htmlNode || htmlNode.nodeType != 1) return;
		
		var result = null, data = info[count];
		var value = htmlNode.getAttributeNode(attrName);//htmlNode.attributes[attrName];//

		if(data) data[0](value, data[1], info, count+1, 0, sResult);
		else if(value) sResult.push(value);
	},
	
	getAllNodes : function(htmlNode, x, info, count, num, sResult){
		var result = null, data = info[count];
		var tagName = x[0];
		var inclSelf = x[1];
		var prefix = x[2];

		if(inclSelf && (htmlNode.tagName == tagName || tagName == "*")){
			if(data) data[0](htmlNode, data[1], info, count+1, 0, sResult);
			else sResult.push(htmlNode);
		}

		var nodes = $(tagName, htmlNode, tagName==prefix?"":prefix);//htmlNode.getElementsByTagName(tagName);
		for(var i=0;i<nodes.length;i++){
			if(data) data[0](nodes[i], data[1], info, count+1, i, sResult);
			else sResult.push(nodes[i]);
		}
	},
	
	getAllAncestorNodes : function(htmlNode, x, info, count, num, sResult){
		var result = null, data = info[count];
		var tagName = x[0];
		var inclSelf = x[1];
		var prefix = x[2];
		
		var i = 0, s = inclSelf ? htmlNode : htmlNode.parentNode;
		while(s && s.nodeType == 1){
			if(s.tagName == tagName || tagName == "*" || tagName == "node()"){
				if(data) data[0](s, data[1], info, count+1, ++i, sResult);
				else sResult.push(s);
			}
			s = s.parentNode
		}
	},
	
	getParentNode : function(htmlNode, empty, info, count, num, sResult){
		var result = null, data = info[count];
		var node = htmlNode.parentNode;
		
		if(data) data[0](node, data[1], info, count+1, 0, sResult);
		else if(node) sResult.push(node);
	},
	
	//precsiblg[3] might not be conform spec
	getPrecedingSibling : function(htmlNode, tagName, info, count, num, sResult){
		var result = null, data = info[count];
		
		var node = htmlNode.previousSibling;
		while(node){
			if(tagName != "node()" && (node.style ? node.tagName.toLowerCase() : node.tagName) != tagName){
				node = node.previousSibling;
				continue;
			}
			
			if(data) data[0](node, data[1], info, count+1, 0, sResult);
			else if(node){
				sResult.push(node);
				break;
			}
		}
	},
	
	//flwsiblg[3] might not be conform spec
	getFollowingSibling : function(htmlNode, tagName, info, count, num, sResult){
		var result = null, data = info[count];
		
		var node = htmlNode.nextSibling;
		while(node){
			if(tagName != "node()" && (node.style ? node.tagName.toLowerCase() : node.tagName) != tagName){
				node = node.nextSibling;
				continue;
			}
			
			if(data) data[0](node, data[1], info, count+1, 0, sResult);
			else if(node){
				sResult.push(node);
				break;
			}
		}
	},
	
	multiXpaths : function(contextNode, list, info, count, num, sResult){
		for(var i=0;i<list.length;i++){
			var info = list[i][0];
			var rootNode = (info[3] ? contextNode.ownerDocument.documentElement : contextNode);//document.body
			info[0](rootNode, info[1], list[i], 1, 0, sResult);
		}
		
		sResult.makeUnique();
	},
	
	compile : function(sExpr){
		sExpr = sExpr.replace(/\[(\d+)\]/g, "/##$1");
		sExpr = sExpr.replace(/\|\|(\d+)\|\|\d+/g, "##$1");
		sExpr = sExpr.replace(/\.\|\|\d+/g, ".");
		sExpr = sExpr.replace(/\[([^\]]*)\]/g, function(match, m1){
			return "/##" + m1.replace(/\|/g, "_@_");
		}); //wrong assumption think of |

		if(sExpr == "/" || sExpr == ".") return sExpr;
		
		//Mark // elements
		//sExpr = sExpr.replace(/\/\//g, "/[]/self::");
		sExpr = sExpr.replace(/\/\//g, "descendant::");
		
		//Check if this is an absolute query
		return this.processXpath(sExpr);
	},
	
	processXpath : function(sExpr){
		var results = new Array();
		sExpr = sExpr.replace(/('[^']*)\|([^']*')/g, "$1_@_$2");
		sExpr = sExpr.split("\|");
		for(var i=0;i<sExpr.length;i++)
			sExpr[i] = sExpr[i].replace(/_\@\_/g, "|");//replace(/('[^']*)\_\@\_([^']*')/g, "$1|$2");
		
		if(sExpr.length == 1) sExpr = sExpr[0];
		else{
			for(var i=0;i<sExpr.length;i++) sExpr[i] = this.processXpath(sExpr[i]);
			results.push([this.multiXpaths, sExpr]);
			return results;
		}
		
		var isAbsolute = sExpr.match(/^\/[^\/]/);
		var sections = sExpr.split("/");
		for(var i=0;i<sections.length;i++){
			if(sections[i] == "." || sections[i] == "") continue;
			else if(sections[i].match(/^[\w-_\.]+(?:\:[\w-_\.]+){0,1}$/)) results.push([this.getChildNode, sections[i]]);//.toUpperCase()
			else if(sections[i].match(/^\#\#(\d+)$/)) results.push([this.doQuery, ["num+1 == " + parseInt(RegExp.$1)]]);
			else if(sections[i].match(/^\#\#(.*)$/)){
				
				//FIX THIS CODE
				var query = RegExp.$1;
				var m = [query.match(/\(/g), query.match(/\)/g)];
				if(m[0] || m[1]){
					while(!m[0] && m[1] || m[0] && !m[1] || m[0].length != m[1].length){
						if(!sections[++i]) break;
						query += "/" + sections[i];
						m = [query.match(/\(/g), query.match(/\)/g)];
					}
				}
				
				results.push([this.doQuery, [this.compileQuery(query)]]);
			}
			else if(sections[i] == "*") results.push([this.getChildNode, null]); //FIX - put in def function
			else if(sections[i].substr(0,2) == "[]") results.push([this.getAllNodes, ["*", false]]);//sections[i].substr(2) || 
			else if(sections[i].match(/descendant-or-self::node\(\)$/)) results.push([this.getAllNodes, ["*", true]]);
			else if(sections[i].match(/descendant-or-self::([^\:]*)(?:\:(.*)){0,1}$/)) results.push([this.getAllNodes, [RegExp.$2 || RegExp.$1, true, RegExp.$1]]);
			else if(sections[i].match(/descendant::([^\:]*)(?:\:(.*)){0,1}$/)) results.push([this.getAllNodes, [RegExp.$2 || RegExp.$1, false, RegExp.$1]]);
			else if(sections[i].match(/ancestor-or-self::([^\:]*)(?:\:(.*)){0,1}$/)) results.push([this.getAllAncestorNodes, [RegExp.$2 || RegExp.$1, true, RegExp.$1]]);
			else if(sections[i].match(/ancestor::([^\:]*)(?:\:(.*)){0,1}$/)) results.push([this.getAllAncestorNodes, [RegExp.$2 || RegExp.$1, false, RegExp.$1]]);
			else if(sections[i].match(/^\@(.*)$/)) results.push([this.getAttributeNode, RegExp.$1]);
			else if(sections[i] == "text()") results.push([this.getTextNode, null]);
			else if(sections[i] == "node()") results.push([this.getAnyNode, null]);//FIX - put in def function
			else if(sections[i] == "..") results.push([this.getParentNode, null]);
			else if(sections[i].match(/following-sibling::(.*)$/)) results.push([this.getFollowingSibling, RegExp.$1.toLowerCase()]);
			else if(sections[i].match(/preceding-sibling::(.*)$/)) results.push([this.getPrecedingSibling, RegExp.$1.toLowerCase()]);
			else if(sections[i].match(/self::(.*)$/)) results.push([this.doQuery, ["XPath.doXpathFunc('local-name', htmlNode) == '" + RegExp.$1 + "'"]]);
			else{
				var query = sections[i];
			
				//FIX THIS CODE
				//add some checking here
				var m = [query.match(/\(/g), query.match(/\)/g)];
				if(m[0] || m[1]){
					while(!m[0] && m[1] || m[0] && !m[1] || m[0].length != m[1].length){
						if(!sections[++i]) break;
						query += "/" + sections[i];
						m = [query.match(/\(/g), query.match(/\)/g)];
					}
				}

				results.push([this.doQuery, [this.compileQuery(query), true]])
			
				//throw new Error(1503, "---- Javeline Error ----\nMessage : Could not match XPath statement: '" + sections[i] + "' in '" + sExpr + "'");
			}
		}

		results[0][3] = isAbsolute;
		return results;
	},
	
	compileQuery : function(code){
		var c = new CodeCompilation(code);
		return c.compile();
	},
	
	doXpathFunc : function(type, arg1, arg2, arg3){
		switch(type){
			case "not": return !arg1;
			case "position()": return num == arg1;
			case "format-number": return new String(Math.round(parseFloat(arg1)*100)/100).replace(/(\.\d?\d?)$/, function(m1){return m1.pad(3, "0", PAD_RIGHT)});; //this should actually do something
			case "floor": return Math.floor(arg1);
			case "ceiling": return Math.ceil(arg1);
			case "starts-with": return arg1 ? arg1.substr(0, arg2.length) == arg2 : false;
			case "string-length": return arg1 ? arg1.length : 0;
			case "count": return arg1 ? arg1.length : 0;
			case "last": return arg1 ? arg1[arg1.length-1] : null;
			case "local-name": return arg1 ? arg1.tagName : "";//[TAGNAME]
			case "substring": return arg1 && arg2 ? arg1.substring(arg2, arg3 || 0) : "";
			case "contains": return arg1 && arg2 ? arg1.indexOf(arg2) > -1 : false;
			case "concat": 
				for(var str="",i=1;i<arguments.length;i++){
					if(typeof arguments[i] == "object"){
						str += getNodeValue(arguments[i][0]);
						continue;
					}
					str += arguments[i];
				}
			return str;
		}
	},
	
	selectNodeExtended : function(sExpr, contextNode, match){
		var sResult = this.selectNodes(sExpr, contextNode);

		if(sResult.length == 0) return null;
		if(!match) return sResult[0];
		
		for(var i=0;i<sResult.length;i++){
			if(getNodeValue(sResult[i]) == match) return sResult[i];
		}
		
		return null;
	},
	
	selectNodes : function(sExpr, contextNode){
		if(!this.cache[sExpr]) this.cache[sExpr] = this.compile(sExpr);
		
		//setStatus("Processing custom XPath: " + sExpr + ":" + contextNode.serialize().replace(/</g, "&lt;"));
		
		if(typeof this.cache[sExpr] == "string"){
			if(this.cache[sExpr] == ".") return [contextNode];
			if(this.cache[sExpr] == "/") return [contextNode.nodeType == 9 ? contextNode : contextNode.ownerDocument.documentElement];
		}

		if(typeof this.cache[sExpr] == "string" && this.cache[sExpr] == ".") return [contextNode];
		
		var info = this.cache[sExpr][0];
		var rootNode = (info[3] && !contextNode.nodeType == 9 ? contextNode.ownerDocument.documentElement : contextNode);//document.body
		var sResult = [];

		info[0](rootNode, info[1], this.cache[sExpr], 1, 0, sResult);
		
		return sResult;
	}
}

function getNodeValue(sResult){
	if(sResult.nodeType == 1) return sResult.firstChild ? sResult.firstChild.nodeValue : "";
	if(sResult.nodeType > 1 || sResult.nodeType < 5) return sResult.nodeValue;
	return sResult;
}

function CodeCompilation(code){
	this.data = {
		F : [],
		S : [],
		I : [],
		X : []
	};
	
	this.compile = function(){
		code = code.replace(/ or /g, " || ");
		code = code.replace(/ and /g, " && ");
		code = code.replace(/!=/g, "{}");
		code = code.replace(/=/g, "==");
		code = code.replace(/\{\}/g, "!=");
		
		// Tokenize
		this.tokenize();
		
		// Insert
		this.insert();

		return code;
	}
	
	this.tokenize = function(){
		//Functions
		var data = this.data.F;
		code = code.replace(/(format-number|contains|substring|local-name|last|node|position|round|starts-with|string|string-length|sum|floor|ceiling|concat|count|not)\s*\(/g, function(d, match){return (data.push(match) - 1) + "F_";});

		//Strings
		var data = this.data.S;
		code = code.replace(/'([^']*)'/g, function(d, match){return (data.push(match) - 1) + "S_";});
		code = code.replace(/"([^"]*)"/g, function(d, match){return (data.push(match) - 1) + "S_";});

		//Xpath
		var data = this.data.X;
		code = code.replace(/(^|\W|\_)([\@\.\/A-Za-z][\.\@\/\w]*(?:\(\)){0,1})/g, function(d, m1, m2){return m1 + (data.push(m2) - 1) + "X_";});
		code = code.replace(/(\.[\.\@\/\w]*)/g, function(d, m1, m2){return (data.push(m1) - 1) + "X_";});
		
		//Ints
		var data = this.data.I; 
		code = code.replace(/(\d+)(\W)/g, function(d, m1, m2){return (data.push(m1) - 1) + "I_" + m2;});
	}
	
	this.insert = function(){
		var data = this.data;
		code = code.replace(/(\d+)X_\s*==\s*(\d+S_)/g, function(d, nr, str){
			return "XPath.selectNodeExtended('" +  data.X[nr].replace(/'/g, "\\'") + "', htmlNode, " + str + ")";
		});
		
		code = code.replace(/(\d+)([FISX])_/g, function(d, nr, type){
			var value = data[type][nr];
			
			if(type == "F"){
				return "XPath.doXpathFunc('" + value + "', ";
			}
			else if(type == "S"){
				return "'" + value + "'";	
			}
			else if(type == "I"){
				return value;
			}
			else if(type == "X"){
				return "XPath.selectNodeExtended('" + value.replace(/'/g, "\\'") + "', htmlNode)";
			}
		});
	}
}

self.XPath = XPath;


}

function runXslt(){
	
function XSLTProcessor(){
	this.templates = {};
	this.p = {
		"value-of" : function(context, xslNode, childStack, result){
			var xmlNode = XPath.selectNodes(xslNode.getAttribute("select"), context)[0];// + "[0]"

			if(!xmlNode) value = "";
			else if(xmlNode.nodeType == 1) value = xmlNode.firstChild ? xmlNode.firstChild.nodeValue : "";
			else value = typeof xmlNode == "object" ? xmlNode.nodeValue : xmlNode;
			
			result.appendChild(this.xmlDoc.createTextNode(value));
		},
		
		"copy-of" : function(context, xslNode, childStack, result){
			var xmlNode = XPath.selectNodes(xslNode.getAttribute("select"), context)[0];// + "[0]"
			if(xmlNode) result.appendChild(!IS_IE ? result.ownerDocument.importNode(xmlNode, true) : xmlNode.cloneNode(true));
		},
		
		"if" : function(context, xslNode, childStack, result){
			if(XPath.selectNodes(xslNode.getAttribute("test"), context)[0]){// + "[0]"
				this.parseChildren(context, xslNode, childStack, result);
			}
		},
		
		"for-each" : function(context, xslNode, childStack, result){
			var nodes = XPath.selectNodes(xslNode.getAttribute("select"), context);
			for(var i=0;i<nodes.length;i++){
				this.parseChildren(nodes[i], xslNode, childStack, result);
			}
		},
		
		"choose" : function(context, xslNode, childStack, result){
			var nodes = xslNode.childNodes;
			for(var i=0;i<nodes.length;i++){
				if(!nodes[i].tagName) continue;
				
				if(nodes[i][TAGNAME] == "otherwise" || nodes[i][TAGNAME] == "when" && XPath.selectNodes(nodes[i].getAttribute("test"), context)[0])
					return this.parseChildren(context, nodes[i], childStack[i][2], result);
			}
		},
		
		"output" : function(context, xslNode, childStack, result){
			
		},
		
		"param" : function(context, xslNode, childStack, result){
			
		},
		
		"attribute" : function(context, xslNode, childStack, result){
			var nres = this.xmlDoc.createDocumentFragment();
			this.parseChildren(context, xslNode, childStack, nres);
			
			result.setAttribute(xslNode.getAttribute("name"), nres.xml);
		},
		
		"apply-templates" : function(context, xslNode, childStack, result){
			if(!xslNode){
				var t = this.templates["/"] || this.templates[context.tagName];
				if(t) this.p["apply-templates"].call(this, context, t[0], t[1], result);
			}
			else if(xslNode.getAttribute("select")){
				var t = this.templates[xslNode.getAttribute("select")];
				if(t){
					if(xslNode.getAttribute("select") == "/") return alert("Something went wrong. The / template was executed as a normal template");
					
					var nodes = context.selectNodes(xslNode.getAttribute("select"));
					for(var i=0;i<nodes.length;i++){
						this.parseChildren(nodes[i], t[0], t[1], result);
					}
				}
			}
			//Named templates should be in a different hash
			else if(xslNode.getAttribute("name")){
				var t = this.templates[xslNode.getAttribute("name")];
				if(t) this.parseChildren(context, t[0], t[1], result);
			}
			else{
				//Copy context
				var ncontext = context.cloneNode(true); //importnode here??
				var nres = this.xmlDoc.createDocumentFragment();
				
				var nodes = ncontext.childNodes;
				for(var tName, i=nodes.length-1;i>=0;i--){
					if(nodes[i].nodeType == 3 || nodes[i].nodeType == 4){
						//result.appendChild(this.xmlDoc.createTextNode(nodes[i].nodeValue));
						continue;
					}
					if(!nodes[i].nodeType == 1) continue;
					var n = nodes[i];

					//Loop through all templates
					for(tName in this.templates){
						if(tName == "/") continue;
						var t = this.templates[tName];
						
						var snodes = n.selectNodes("self::" + tName);
						for(var j=snodes.length-1;j>=0;j--){
							var s = snodes[j], p = s.parentNode;
							this.parseChildren(s, t[0], t[1], nres);
							if(nres.childNodes){
								for(var k=nres.childNodes.length-1;k>=0;k--){
									p.insertBefore(nres.childNodes[k], s);
								}
							}
							p.removeChild(s);
						}
					}
					
					if(n.parentNode){
						var p = n.parentNode;
						this.p["apply-templates"].call(this, n, xslNode, childStack, nres);
						if(nres.childNodes){
							for(var k=nres.childNodes.length-1;k>=0;k--){
								p.insertBefore(nres.childNodes[k], n);
							}
						}
						p.removeChild(n);
					}
				}
				
				for(var i=ncontext.childNodes.length-1;i>=0;i--){
					result.insertBefore(ncontext.childNodes[i], result.firstChild);
				}
			}
		},
		
		cache : {},
		"import" : function(context, xslNode, childStack, result){
			var file = xslNode.getAttribute("href");
			if(!this.cache[file]){
				var data = new HTTP().get(file, false, true);
				this.cache[file] = data;
			}
			
			//compile
			//parseChildren
		},
		
		"include" : function(context, xslNode, childStack, result){
			
		},
		
		"when" : function(){},
		"otherwise" : function(){},
		
		"copy-clone" : function(context, xslNode, childStack, result){
			result = result.appendChild(!IS_IE ? result.ownerDocument.importNode(xslNode, false) : xslNode.cloneNode(false));
			if(result.nodeType == 1){
				for(var i=0;i<result.attributes.length;i++){
					var blah = result.attributes[i].nodeValue; //stupid Safari shit

					if(!IS_SAFARI_OLD && result.attributes[i].nodeName.match(/^xmlns/)) continue;
					result.attributes[i].nodeValue = result.attributes[i].nodeValue.replace(/\{([^\}]+)\}/g, function(m, xpath){
						var xmlNode = XPath.selectNodes(xpath, context)[0];
						
						if(!xmlNode) value = "";
						else if(xmlNode.nodeType == 1) value = xmlNode.firstChild ? xmlNode.firstChild.nodeValue : "";
						else value = typeof xmlNode == "object" ? xmlNode.nodeValue : xmlNode;
						
						return value;
					});
					
					result.attributes[i].nodeValue; //stupid Safari shit
				}
			}
			
			this.parseChildren(context, xslNode, childStack, result);
		}
	}
	
	this.parseChildren = function(context, xslNode, childStack, result){
		if(!childStack) return;
		for(var i=0;i<childStack.length;i++){
			childStack[i][0].call(this, context, childStack[i][1], childStack[i][2], result);
		}
	}
	
	this.compile = function(xslNode){
		var nodes = xslNode.childNodes;
		for(var stack=[],i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1 && nodes[i].nodeType != 3 && nodes[i].nodeType != 4) continue;
			
			if(nodes[i][TAGNAME] == "template"){
				this.templates[nodes[i].getAttribute("match") || nodes[i].getAttribute("name")] = [nodes[i], this.compile(nodes[i])];
			}
			else if(nodes[i][TAGNAME] == "stylesheet"){
				this.compile(nodes[i])
			}
			else if(nodes[i].prefix == "xsl"){
				var func = this.p[nodes[i][TAGNAME]];
				if(!func) alert("xsl:" + nodes[i][TAGNAME] + " is not supported at this time on this platform");
				else stack.push([func, nodes[i], this.compile(nodes[i])]);
			}
			else{
				stack.push([this.p["copy-clone"], nodes[i], this.compile(nodes[i])]);
			}
		}
		return stack;
	}
	
	this.importStylesheet = function(xslDoc){
		this.xslDoc = xslDoc.nodeType == 9 ? xslDoc.documentElement : xslDoc;
		xslStack = this.compile(xslDoc);

		//var t = this.templates["/"] ? "/" : false;
		//if(!t) for(t in this.templates) if(typeof this.templates[t] == "array") break;
		this.xslStack = [[this.p["apply-templates"], null]];//{getAttribute : function(n){if(n=="name") return t}
	}
	
	//return nodes
	this.transformToFragment = function(doc, newDoc){
		this.xmlDoc = newDoc.nodeType != 9 ? newDoc.ownerDocument : newDoc;//new DOMParser().parseFromString("<xsltresult></xsltresult>", "text/xml");//
		var docfrag = this.xmlDoc.createDocumentFragment();

		if(!IS_SAFARI_OLD && doc.nodeType == 9) doc = doc.documentElement;
		var result = this.parseChildren(doc, this.xslDoc, this.xslStack, docfrag);
		return docfrag;
	}
}

self.XSLTProcessor = XSLTProcessor;


}

if(IS_IE) importClass(runIE, true, self);

if(IS_SAFARI) importClass(runSafari, true, self);

if(IS_OPERA) importClass(runOpera, true, self);

if(IS_GECKO || !IS_IE && !IS_SAFARI && !IS_OPERA) importClass(runGecko, true, self);

/*FILEHEAD(/in/Core/Node/Alignment.js)SIZE(2028)TIME(1182088294453)*/
__ALIGNMENT__ = 1<<12;

function Alignment(){
	this.__regbase = this.__regbase|__ALIGNMENT__;
	
	this.setAlignProperty = function(prop, value, recalc){
		this.jml.setAttribute(prop, value);
		if(recalc) this.activateAlignment();
	}
	
	this.disableAlignment = function(){
		return LayoutServer.removeControl(LayoutServer.get(this.pHtmlNode), this.uniqueId);
	}
	
	this.enableAlignment = 
	this.activateAlignment = function(){
		var x = this.jml;
		var layout = LayoutServer.get(this.pHtmlNode, (x.parentNode.getAttribute("margin") || "").split(/,\s*/)); // might be optimized by splitting only once
	
		var aData = {};
		if(x.getAttribute("align")) aData.template = x.getAttribute("align");
		if(x.getAttribute("align-lean")) aData.isBottom = x.getAttribute("align-lean").match(/bottom/);
		if(x.getAttribute("align-lean")) aData.isRight = x.getAttribute("align-lean").match(/right/);
		if(x.getAttribute("align-position")){
			x.getAttribute("align-position").match(/\((\d+),(\d+)\)/);
			aData.vpos = parseInt(RegExp.$1);
			aData.hpos = parseInt(RegExp.$2);
			aData.template = undefined;
		}
		if(x.getAttribute("align-margin")) aData.edgeMargin = x.getAttribute("align-margin");
		if(x.getAttribute("align-span")) aData.span = x.getAttribute("align-span");
		if(x.getAttribute("align-splitter") || x.getAttribute("align-edge") == "splitter") aData.splitter = x.getAttribute("align-splitter") || (x.getAttribute("align-edge") == "splitter" ? 3 : false);
		if(x.getAttribute("width")) aData.fwidth = x.getAttribute("width");
		if(x.getAttribute("height")) aData.fheight = x.getAttribute("height");
		if(x.getAttribute("min-width")) aData.minwidth = x.getAttribute("min-width");
		if(x.getAttribute("min-height")) aData.minheight = x.getAttribute("min-height");
		
		aData.oHtml = this.oExt;
		
		LayoutServer.addControl(layout, this.uniqueId, aData);
	}
	
	this.purgeAlignment = function(){
		LayoutServer.compile(this.pHtmlNode);
		LayoutServer.activateRules(this.pHtmlNode);
	}
}

/*FILEHEAD(/in/Core/Node/Anchoring.js)SIZE(5099)TIME(1184254307389)*/
__ANCHORING__ = 1<<13;


function Anchoring(){
	this.__regbase = this.__regbase|__ANCHORING__;
	
	if(!this.oExt.getAttribute("id")) Kernel.setUniqueHtmlId(this.oExt);
	var oHtmlDiff;
	
	this.disableAnchoring = function(activate){
		LayoutServer.removeRule(this.pHtmlNode, this.uniqueId + "h");
		LayoutServer.removeRule(this.pHtmlNode, this.uniqueId + "v");
		
		if(activate) this.purgeAnchoring();
	}
	
	this.enableAnchoring = function(activate){
		oHtmlDiff = Kernel.compat.getDiff(this.oExt);
		
		var x = this.jml;
		this.setHorizontal(x.getAttribute("left"),x.getAttribute("right"),x.getAttribute("width"));
		this.setVertical(x.getAttribute("top"),x.getAttribute("bottom"),x.getAttribute("height"));
		
		if(activate) this.purgeAnchoring();
	}
	
	this.moveAnchoringRules = function(newPNode, updateNow){
		var rules = [LayoutServer.getRules(this.pHtmlNode, this.uniqueId + "h"), LayoutServer.getRules(this.pHtmlNode, this.uniqueId + "v")];
		
		this.disableAnchoring();
		if(updateNow) LayoutServer.activateRules(this.pHtmlNode);
		
		LayoutServer.setRules(newPNode, this.uniqueId + "h", rules[0]);
		LayoutServer.setRules(newPNode, this.uniqueId + "v", rules[1]);
		if(updateNow) LayoutServer.activateRules(newPNode);
	}
	
	function setPercentage(value, pValue){
		return (typeof value == "string" ? value.replace(/(\d+)\%/g, "((" + pValue + " * $1)/100)") : value);
	}
	
	this.setHorizontal = function(left, right, width, apply){
		var rules = [];
		
		var id = this.oExt.getAttribute("id");
		if(IS_GECKO) id = "document.getElementById('" + id + "')";
		var pWidth = (this.oExt.parentNode == this.pHtmlDoc.body ? (IS_IE ? "document.documentElement.offsetWidth" : "window.innerWidth") : id + ".parentNode.offsetWidth");
		var hordiff = oHtmlDiff[0];
		
		left = setPercentage(left, pWidth);
		right = setPercentage(right, pWidth);
		width = setPercentage(width, pWidth);
		
		if(left){
			if(parseInt(left) != left) rules.push(id + ".style.left = (" + left + ") + 'px'");
			else this.oExt.style.left = left + "px";
		}
		if(!left && right){
			if(parseInt(right) != right) rules.push(id + ".style.right = (" + right + ") + 'px'");
			else this.oExt.style.right = right + "px";
		}
		if(width){
			if(parseInt(width) != width) rules.push(id + ".style.width = (" + width + " - " + hordiff + ") + 'px'");
			else this.oExt.style.width = (width-hordiff) + "px";
		}

		if(right != null && left != null)
			rules.push(id + ".style.width = (" +  pWidth + " - (" + right + ") - (" + left + ") - " + hordiff + ") + 'px'");
		else if(right == null && left == null)
			rules.push(id + ".style.left = ((" + pWidth + " - " + (width || id + ".offsetWidth") + ")/2) + 'px'");
		else if(right != null)
			rules.push(id + ".style.left = (" +  pWidth + " - " + right + " - " + (width || id + ".offsetWidth") + ") + 'px'");
		
		this.oExt.style.position = "absolute";

		rules = 'try{' + rules.join(';}catch(e){};try{') + ';}catch(e){};';
		LayoutServer.setRules(this.pHtmlNode, this.uniqueId + "h", rules, true);
		
		if(apply){
			eval(rules);
			LayoutServer.activateRules(this.pHtmlNode, true);
		}
	}
	
	this.setVertical = function(top, bottom, height, apply){
		var rules = [];
		
		var id = this.oExt.getAttribute("id");
		if(IS_GECKO) id = "document.getElementById('" + id + "')";
		var pHeight = (this.oExt.parentNode == this.pHtmlDoc.body ? (IS_IE ? "document.documentElement.offsetHeight" : "window.innerHeight") : id + ".parentNode.offsetHeight");
		var verdiff = oHtmlDiff[1];
		
		top = setPercentage(top, pHeight);
		bottom = setPercentage(bottom, pHeight);
		height = setPercentage(height, pHeight);
		
		if(top){
			if(parseInt(top) != top) rules.push(id + ".style.top = (" + top + ") + 'px'");
			else this.oExt.style.top = top + "px";
		}
		if(!top && bottom){
			if(parseInt(bottom) != bottom) rules.push(id + ".style.bottom = (" + bottom + ") + 'px'");
			else this.oExt.style.bottom = bottom + "px";
		}
		if(height){
			if(parseInt(height) != height) rules.push(id + ".style.height = (" + height + " - " + verdiff + ") + 'px'");
			else this.oExt.style.height = (height-verdiff) + "px";
		}
		
		if(bottom != null && top != null)
			rules.push(id + ".style.height = (" +  pHeight + " - (" + bottom + ") - (" + top + ") - " + verdiff + ") + 'px'");
		else if(bottom == null && top == null)
			rules.push(id + ".style.top = ((" + pHeight + " - " + (height || id + ".offsetHeight") + ")/2) + 'px'");
		else if(bottom != null)
			rules.push(id + ".style.top = (" +  pHeight + " - " + bottom + " - " + (height || id + ".offsetHeight") + ") + 'px'");
		
		this.oExt.style.position = "absolute";
		
		var rules = 'try{' + rules.join(';}catch(e){};try{') + ';}catch(e){};';
		LayoutServer.setRules(this.pHtmlNode, this.uniqueId + "v", rules, true);
		
		if(apply){
			eval(rules);
			LayoutServer.activateRules(this.pHtmlNode, true);
		}
	}
	
	this.purgeAnchoring = function(){
		LayoutServer.activateRules(this.pHtmlNode);
	}
}


/*FILEHEAD(/in/Core/Node/Cache.js)SIZE(5994)TIME(1182723583203)*/
__CACHE__ = 1<<2;


function Cache(){
	/***********************
		INTERFACE REQUIRED
		
		this.__getCurrentFragment()
		this.__setCurrentFragment(fragment);
		this.__findNode(cacheNode, id);
		this.__setClearMessage();
		
		this.cacheID => set by this.load(...);
		this.documentId => set by this.load(...);
	***********************/
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	var cache = {};
	this.caching = true; 
	
	this.__regbase = this.__regbase|__CACHE__;
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	/********* GETCACHE ***********
		Reinsert Cached Fragment
	
		INTERFACE:
		this.getCache(id);
	****************************/
	this.getCache = function(id){
		//Checking Current
		if(id == this.cacheID) return false;

		//Checking Cache...
		if(!cache[id]) return false;

		//Removing previous
		if(this.cacheID) this.clear(true);

		//Get Fragment and clear Cache Item
		var fragment = cache[id];

		this.documentId = fragment.documentId;
		this.cacheID = id;
		this.XMLRoot = fragment.XMLRoot;
		
		this.clearCacheItem(id);

		this.__setCurrentFragment(fragment);

		return true;
	}
	
	/********* SETCACHE ***********
		Cache Fragment
	
		INTERFACE:
		this.setCache(id, fragment);
	****************************/
	this.setCache = function(id, fragment){
		if(!this.caching) return;

		cache[id] = fragment;
	}
	
	/********* GETNODEFROMCACHE ***********
		Retrieves Node from Cache
	
		INTERFACE:
		this.getNodeFromCache(id);
	****************************/
	this.getNodeFromCache = function(id){
		//looks into the cache to find the node with the requested id

		var node = this.__findNode(null, id);
		if(node) return node;
		
		for(prop in cache){
			if(cache[prop] && cache[prop].nodeType){
				var node = this.__findNode(cache[prop], id);
				if(node) return node;
		 	}
		}
		
		return null;
	}
	
	/********* GETCACHEITEMBYHTMLID ***********
		Retrieves Cache Fragment by xmlNode
	
		INTERFACE:
		this.getCacheItemByHtmlId(id);
	****************************/
	this.getCacheItemByHtmlId = function(id){
		var node = this.__findNode(null, id);
		if(node) return this.oInt;
		
		for(prop in cache){
			if(cache[prop] && cache[prop].nodeType){
				var node = this.__findNode(cache[prop], id);
				if(node) return cache[prop];
		 	}
		}
		
		return null;
	}
	
	/********* CLEAR ***********
		Clear current view
	
		INTERFACE:
		this.clear(nomsg);
	****************************/
	this.clear = function(nomsg, do_event){
		if(this.clearSelection) this.clearSelection(null, !do_event);

		if(this.caching){
			var fragment = this.__getCurrentFragment();
			if(!fragment) return;//this.__setClearMessage(this.msg);
			fragment.documentId = this.documentId;
			fragment.XMLRoot = this.XMLRoot;
		}
		else this.oInt.innerHTML = "";

		if(!nomsg) this.__setClearMessage(this.msg);
		else if(this.__removeClearMessage) this.__removeClearMessage();
		
		if(this.caching && (this.cacheID || this.XMLRoot)) 
			this.setCache(this.cacheID || this.XMLRoot.getAttribute(XMLDatabase.xmlIdTag) || "doc" + this.XMLRoot.getAttribute(XMLDatabase.xmlDocTag), fragment);

		this.documentId = null;
		this.XMLRoot = null;
		this.cacheID = null;
		this.dataset = {set:{},seq:[]};
	}
	
	/********* CLEARCACHEITEM ***********
		Remove Fragment from cache
	
		INTERFACE:
		this.clearCacheItem(id);
	****************************/
	this.clearCacheItem = function(id, remove){
		cache[id].documentId = null;
		cache[id].cacheID = null;
		cache[id].XMLRoot = null;
		
		if(remove) Kernel.removeNode(cache[id]);
		
		cache[id] = null;
	}
	
	this.clearAllCache = function(){
		for(prop in cache){
			if(cache[prop]) this.clearCacheItem(prop, true);
		}
	}
	
	/********* GETCACHEITEM ***********
		Return Fragment from cache
	
		INTERFACE:
		this.getCacheItem(id);
	****************************/
	this.getCacheItem = function(id){
		return cache[id];
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/
	
	// Caching
	this.__addJmlLoader(function(x){
		this.caching = x.getAttribute("caching") != "false";
	});
	
	if(this.hasFeature(__MULTISELECT__)) this.inherit(MultiselectCache);
}

function MultiselectCache(){
	this.__getCurrentFragment = function(){
		var fragment = IS_IE55 ? new DocFrag() : document.createDocumentFragment(); //IE55
		
		while(this.oInt.childNodes.length){
			fragment.appendChild(this.oInt.childNodes[0]);
		}
		fragment.dataset = this.dataset;

		return fragment;
	}
	
	this.__setCurrentFragment = function(fragment){
		IS_IE55 ? fragment.reinsert(this.oInt) : this.oInt.appendChild(fragment); //IE55
		this.dataset = fragment.dataset;
		if(!me.isFocussed(this)) this.blur();
	}

	this.__findNode = function(cacheNode, id){
		if(!cacheNode) return this.pHtmlDoc.getElementById(id);
		return cacheNode.getElementById(id);
	}
	
	this.__setClearMessage = function(msg){
		var xmlEmpty = this.__getLayoutNode("Empty");
		if(!xmlEmpty) return;
		
		var oEmpty = XMLDatabase.htmlImport(xmlEmpty, this.oInt);
		var empty = this.__getLayoutNode("Empty", "caption", oEmpty);
		if(empty) empty.nodeValue = msg;
		if(oEmpty) oEmpty.setAttribute("id", "empty" + this.uniqueId);
	}
	
	this.__removeClearMessage = function(){
		var oEmpty = document.getElementById("empty" + this.uniqueId);
		if(oEmpty) oEmpty.parentNode.removeChild(oEmpty);
		//else this.oInt.innerHTML = ""; //clear if no empty message is supported
	}
}


/*FILEHEAD(/in/Core/Node/DataBinding.js)SIZE(55190)TIME(1186739541653)*/
/** 
* @projectDescription 	Javeline Platform
*
* @author	Ruben Daniels ruben@javeline.nl
* @version	1.0
*/

__DATABINDING__ = 1<<1;


/**
* @moduleDescription {BaseClass} DataBinding functionality for JML Components
* @jmlattribute		{String} 	bind	Sets the xpath to the choosen model to bind the main value on
*/
function DataBinding(){
	/***********************
		INTERFACE REQUIRED

		this.__xmlUpdate(action, xmlNode, listenNode);
		this.__load(XMLRoot, doc	this.disconnect = function(o, type){umentId);
		this.__add(xmlNode, parent);
	***********************/

	/*********************************************************************
										PROPERTIES
	*********************************************************************/

	var loadqueue;
	var __XMLOnload = [];
	var __XMLSelect = [];
	var __XMLChoice = [];

	this.__regbase = this.__regbase|__DATABINDING__;
	this.mainBind = "Value";

	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/

	/**
	* This method returns a string representation of the object
	* @param {Object}	fooName	Name of the foo to retrieve.
	* @return {Object}	Returns a new foo.
	* @exception	{GeneralShapeException}	Throws a general shape exception if the object is not a shape.
	* @memberOf fooBar
	* @method
	* @deprecated
	*/
	//<Traverse select="" sort="@blah" data-type={"text" | "number" | "date"} sort-method="" order={"ascending" | "descending"} case-order={"upper-first" | "lower-first"} />
	var sortObj;
	this.parseTraverse = function (xmlNode){
		this.ruleTraverse = xmlNode.getAttribute("select");
		sortObj = xmlNode.getAttribute("sort") ? new Sort(xmlNode) : null;
	}
	
	this.getTraverseNodes = function(xmlNode){
		if(sortObj){
			var nodes = XMLDatabase.getArrayFromNodelist((xmlNode || this.XMLRoot).selectNodes(this.ruleTraverse));
			return sortObj.apply(nodes);
		}
		
		return (xmlNode || this.XMLRoot).selectNodes(this.ruleTraverse);
	}
	
	this.getFirstTraverseNode = function(xmlNode){
		return (xmlNode || this.XMLRoot).selectSingleNode(this.ruleTraverse);
	}
	
	this.getLastTraverseNode = function(xmlNode){
		var nodes = this.getTraverseNodes(xmlNode || this.XMLRoot);//.selectNodes(this.ruleTraverse);
		return nodes[nodes.length-1];
	}

	this.isTraverseNode = function(xmlNode){
		var nodes = this.getTraverseNodes(this.getTraverseParent(xmlNode) || this.XMLRoot);// || this.XMLRoot : this.XMLRoot .selectNodes(this.ruleTraverse);
		for(var i=0;i<nodes.length;i++){
			if(nodes[i] == xmlNode) return true;
		}

		return false;
	}

	this.getNextTraverseSelected = function(xmlNode, up, count){
		if(!xmlNode) var xmlNode = this.value;
		if(!count) count = 1;

		var i=0, nodes = this.getTraverseNodes(this.getTraverseParent(xmlNode) || this.XMLRoot);//.selectNodes(this.ruleTraverse);
		while(nodes[i] && nodes[i] != xmlNode) i++;
		var node = up == null ? nodes[i+count] || nodes[i-count] : (up ? nodes[i+count] : nodes[i-count]);
		return node || arguments[2] && (i < count || (i+1) > Math.floor(nodes.length/count)*count) ? node : (up ? nodes[nodes.length-1] : nodes[0]);
	}

	this.getNextTraverse = function(xmlNode, up, count){
		if(!count) count = 1;
		if(!xmlNode) xmlNode = this.value;
		var i=0, nodes = this.getTraverseNodes(this.getTraverseParent(xmlNode) || this.XMLRoot);//.selectNodes(this.ruleTraverse);
		while(nodes[i] && nodes[i] != xmlNode) i++;
		return nodes[i+(up ? -1 * count : count)];
	}

	this.getTraverseParent = function(xmlNode){
		if(!xmlNode.parentNode || xmlNode == this.XMLRoot) return false;
		
		var id = xmlNode.getAttribute(XMLDatabase.xmlIdTag);
		if(!id) return false;

		/*do{
			xmlNode = xmlNode.parentNode;
			if(xmlNode == this.XMLRoot) return false;
			if(this.isTraverseNode(xmlNode)) return xmlNode;
		}while(xmlNode.parentNode);*/
		
		//This is not 100% correct, but good enough for now
		
		//temp untill I fixed the XPath implementation
		if(IS_SAFARI){
			var y = this.ruleTraverse.split("\|");
			for(var i=0;i<y.length;i++){
				var x = xmlNode.selectSingleNode("ancestor::node()[(" + y[i] + "/@j_id='" + id + "')]");
				if(x) return x;
			}
		}
		else return xmlNode.selectSingleNode("ancestor::node()[((" + this.ruleTraverse + ")/@j_id)='" + id + "']");
	}
	
	this.getMainBindXpath = function(){
		if(this.hasFeature(__MULTIBINDING__)) return this.getSelectionBindClass().getMainBindXpath();
		var m = this.getModel(true);
		return (m && m.connect ? m.connect.select + "/" : (this.dataParent ? this.dataParent.xpath + "/" : "")) + this.smartBinding.bindings[this.mainBind][0].getAttribute("select");
	}
	
	this.isBoundComplete = function(){
		if(!this.XMLRoot) return false;
		if(this.hasFeature(__MULTIBINDING__) && !this.getSelectionBindClass().XMLRoot) return false;
		return true;
	}
	
	/********* TRAVERSENODE ***********
		Check if node should be traversed based on XPath Traverse Rule

		- This method might be optimized by only using an XPath Statement

		INTERFACE:
		this.traverseNode(node);
	****************************/
	this.traverseNode = function(node){
		var nodes = node.parentNode.selectNodes(this.ruleTraverse);
		for(var i=0;i<nodes.length;i++) if(nodes[i] == node) return true;
		return false;
	}
	
	/********* loadBindings ***********
		Initializes Databinding based on JML Definition

		INTERFACE:
		this.loadBindings(node);
	****************************/
	this.loadBindings = function(rules, node){
		if(this.bindingRules) this.unloadBindings();
		this.bindingRules = rules;
		
		setStatus("Initializing Bindings for " + this.tagName + "[" + (this.name || '') + "]");
		
		if(this.bindingRules["Traverse"])
			this.parseTraverse(this.bindingRules["Traverse"][0]);

		if(this.__loaddatabinding) this.__loaddatabinding();

		// Load from queued load request
		if(loadqueue){
			this.load(loadqueue[0], loadqueue[1]);
			loadqueue = null;
		}
	}

	/********* UNloadBindings ***********
		Disconnect all databinding connections

		INTERFACE:
		this.unloadBindings();
	****************************/
	this.unloadBindings = function(){
		if(this.__unloaddatabinding) this.__unloaddatabinding();
		
		var node = this.xmlBindings;//this.jml.selectSingleNode("Bindings");
		if(!node || !node.getAttribute("connect")) return;

		//Fails if parent window is closing...
		try{
			var o = eval(node.getAttribute("connect"));
			o.disconnect(this, node.getAttribute("type"));

		}catch(e){}//ignore that case

		this.bindingRules = null;

		return this.uniqueId;
	}

	/********* LOADACTIONS ***********
		Set Actions handling based on JML Definition

		INTERFACE:
		this.loadActions(node, mNode);
	****************************/
	this.loadActions = function(rules, node){
		if(this.actionRules) this.unloadActions();
		this.actionRules = rules;
		
		setStatus("Initializing Actions for " + this.tagName + "[" + (this.name || '') + "]");

		if(node && node.getAttribute("data-update") == "deferred"){
			if(!this.hasFeature(__DEFERREDUPDATE__)) this.inherit(DeferredUpdate);
			
			//Load ActionTracker & XMLDatabase
			if(!this.__ActionTracker) this.__ActionTracker = new _ActionTracker(this);
			//XMLDatabase = this.parentWindow ? this.parentWindow.XMLDatabase : main.window.XMLDatabase;
			
			this.__ActionTracker.realtime = node.getAttribute("rpc-mode") == "realtime";
			this.defaultMode = node.getAttribute("defer-default") || "update";
			
			//Turn caching off, it collides with rendering views on copies of data with the same id's
			this.caching = false;
		
			//When is this called?
			//this.XMLDatabase = new _XMLDatabase().Init(main.window.XMLDatabase, this.XMLRoot);
			//this.XMLRoot = XMLDatabase.root;
		}
	}
	
	this.getActionTracker = function(ignoreMe){
		if(!self.JmlDomAPI) return ActionTracker;
		
		var pNode = this, tracker = ignoreMe ? null : this.__ActionTracker;
		if(!tracker && this.connectId) tracker = self[this.connectId].__ActionTracker;
		
		//XMLDatabase.getInheritedAttribute(this.jml, "actiontracker");
		while(!tracker){
			//if(!pNode.parentNode) throw new Error(1055, Kernel.formErrorString(1055, this, "ActionTracker lookup", "Could not find ActionTracker by traversing upwards"));
			if(!pNode.parentNode) return ActionTracker;
			
			tracker = (pNode = pNode.parentNode).__ActionTracker;
		}
		return tracker;
	}
	
	this.unloadActions = function(){
		this.xmlActions = null;
		this.actionRules = null;
		
		if(this.__ActionTracker){
			if(this.__ActionTracker.stackDone.length) issueWarning(0, "Component : " + this.name + " [" + this.tagName + "]\nMessage : ActionTracker still have undo stack filled with " + this.ActionTracker.stackDone.length + " items.")
		
			this.__ActionTracker = null;
		}
	}
	
	
	/********* EXECUTEACTION ***********
		Execute Action based on Rule and Run event if defined

		INTERFACE:
		this.executeAction(atAction, args, action, xmlNode);
	****************************/
	this.executeAction = function(atAction, args, action, xmlNode, noevent, contextNode){
		if(this.disabled) return; //hack

		setStatus("Executing action '" + action + "' for " + this.tagName + " [" + (this.name || "") + "]");

		//Get Rules from Array
		var rules = this.actionRules ? this.actionRules[action] : (!action.match(/Change|Select/) && Application.autoDisableActions ? false : []);
		if(!rules) return false;

		for(var node=null,i=0;i<(rules.length || 1);i++){
			if(
				!rules[i] || !rules[i].getAttribute("select") || 
				xmlNode.selectSingleNode(rules[i].getAttribute("select"))
			){
				//Call Event and cancel if it returns false
				if(!noevent){
					var eventres;
					//var evntres = this[evnt] ? this[evnt](args) : true;
					//if(typeof evntres == "boolean" && !evntres) 
					if((evntres = this.dispatchEvent("onbefore" + action.toLowerCase(), args)) === false) return false;
					if(typeof evntres == "object" || typeof evntres == "array"){
						atAction = evntres[0];
						args = evntres[1];
					}
				}

				//Call ActionTracker and return ID of Action in Tracker
				var id = this.getActionTracker().execute(atAction, args, rules[i], this, contextNode);

				//Call After Event
				this.dispatchEvent("onafter" + action.toLowerCase());

				return id;
			}
		}

		//Action not executed
		return false;
	}

	/********* CONNECT ***********
		Connect Databound object to other object via an event

		INTERFACE:
		this.connect(o, dataOnly, xpath, type);
	****************************/
	this.connect = function(o, dataOnly, xpath, type, noselect){
		if(o.dataParent) o.dataParent.parent.disconnect(o);
		
		if(!this.signalXmlUpdate) this.signalXmlUpdate = {};
		o.dataParent = {parent : this, xpath : xpath};
		
		//Onload - check if problem when doing setConnections to early
		if(dataOnly){
			if(!xpath && !this.value){throw new Error(1056, Kernel.formErrorString(1056, null, "Connecting", "Illegal XPATH statement specified: '" + xpath + "'"))}

			if(__XMLOnload) return __XMLOnload.push([o, xpath]);
			else return o.load(xpath ? this.XMLRoot.selectSingleNode(xpath) : this.value);//(this.value || this.XMLRoot)
		}

		//DEBUG Message
		//alert(this.tagName + ":" + o.tagName + " - " + type + "["+dataOnly+"]");

		//User action - Select || Choice
		if(!dataOnly) !type || type == "select" ? __XMLSelect.push({o:o,xpath:xpath}) : __XMLChoice.push({o:o,xpath:xpath});

		//Load Default
		if(type != "choice" && !noselect){
			if(this.value || !this.ruleTraverse && this.XMLRoot){
				var xmlNode = this.value || this.XMLRoot;
				if(xpath){
					xmlNode = xmlNode.selectSingleNode(xpath);
					if(!xmlNode){
						//Hack!!
						this.addEventListener("onxmlupdate", function(){
							this.connect(o, false, xpath, type);
							this.removeEventListener("onxmlupdate", arguments.callee);
						});
					}
				}
				
				if(xmlNode) o.load(xmlNode);
			}
			else{
				if(o.clear && !o.hasFeature(__MULTIBINDING__)) o.clear(); //adding o.hasFeature(__MULTIBINDING__) is a quick fix. should be only with the bind="" level
				if(o.disable) o.disable();
			}
		}
	}

	/********* DISCONNECT ***********
		Connect Databound object to other object via an event

		INTERFACE:
		this.disconnect();
	****************************/
	this.disconnect = function(o, type){
		//User action - Select || Choice
		var ar = !type || type == "select" ? __XMLSelect : __XMLChoice; //This should be both when there is no arg set

		this.signalXmlUpdate[o.uniqueId] = null;
		delete this.signalXmlUpdate[o.uniqueId];
		o.dataParent = null;

		//CAN BE OPTIMIZED IF NEEDED TO ONLY SET TO null
		for(var i=0;i<ar.length;i++){
			if(ar[i].o != o) continue;
	
			for(var j=i;j<ar.length;j++)
				ar[j] = ar[j+1];
			ar.length--;
			i--;
		}
	}

	/********* SETCONNECTIONS ***********
		Initialize connections

		INTERFACE:
		this.setConnections(xmlNode, type);
	****************************/
	this.setConnections = function(xmlNode, type){
		var a = type == "both" ? __XMLChoice.concat(__XMLSelect) : (type == "choice" ? __XMLChoice : __XMLSelect);

		//Call Load of objects
		for(var i=0;i<a.length;i++){
			a[i].o.load(a[i].xpath && xmlNode ? xmlNode.selectSingleNode(a[i].xpath) : xmlNode);
		}

		//Set Onload Connections only Once
		if(!__XMLOnload) return;

		for(var i=0;i<__XMLOnload.length;i++)
			__XMLOnload[i][0].load(__XMLOnload[i][1] ? this.XMLRoot.selectSingleNode(__XMLOnload[i][1]) : this.value);//(this.value || this.XMLRoot)

		__XMLOnload = null;
	}
	
	this.importConnections = function(x){
		__XMLSelect = x;
	}
	
	this.getConnections = function(){
		return __XMLSelect;
	}
	
	this.removeConnections = function(){
		__XMLSelect = [];
	}

	/********* APPLYRULESETONNODE ***********
		Get Information from Node based on XPath Rule set in Databinding Definition

		INTERFACE:
		this.applyRuleSetOnNode(setname, cnode, def);
	****************************/
	this.applyRuleSetOnNode = function(setname, cnode, def){
		if(!cnode) return "";

		//Get Rules from Array
		var ruleset = this.bindingRules;
		if(ruleset) var rules = ruleset[setname];

		if(!rules && !def) issueWarning(10001, "Component : " + this.name + " [" + this.tagName + "]\nMessage : Could not find a SmartBindings rule for property '" + setname + "'.")

		if(!rules) return def ? cnode.selectSingleNode(def) : false;
		//if(setname == "From") alert(value);

		for(var node=null,i=0;i<rules.length;i++){
			//if(self.gridFile && gridFile == this && setname == "Load") alert(rules[i].xml + ":\n" + cnode.xml);
			//if(!rules[i].getAttribute("select")) issueWarning(1057, Kernel.formErrorString(1057, this, "Transforming data", "Missing XPath Select statement in Rule: \n" + rules[i].xml));//throw new Error

			var sel = (rules[i].getAttribute("select-eval") ? eval(rules[i].getAttribute("select-eval")) : rules[i].getAttribute("select")) || ".";
			var o = cnode.selectSingleNode(sel);

			if(o){
				this.lastRule = rules[i];
				//this.lastXMLNode = cnode;

				//Return Node if rule contains RPC definition
				if(rules[i].getAttribute("rpc")) return rules[i];

				//Check for Default Value
				else if(rules[i].getAttribute("default")) return rules[i].getAttribute("default");

				//Process XSLT/JSLT Stylesheet if needed
				
				else if(rules[i].getElementsByTagName(Kernel.XSLTPrefix + "stylesheet").length){
					var XSLT = rules[i].getElementsByTagName(Kernel.XSLTPrefix + "stylesheet")[0];
					var o = o.transformNode(XSLT).replace(/^<\?xml version="1\.0" encoding="UTF-16"\?>/, "").replace(/\&lt\;/g, "<").replace(/\&gt\;/g, ">").replace(/\&amp\;/g, "&");
					
					if(rules[i].getAttribute("method"))
						try{eval(rules[i].getAttribute("method"))}catch(e){return false;//throw new Error(0, "---- Javeline Error ----\nMessage : Could not find method '" + rules[i].getAttribute("method") + "' referenced in XML.")
					}

					return rules[i].getAttribute("method") ? self[rules[i].getAttribute("method")](o, this) : o;
				}
				
				else if(rules[i].childNodes.length){
					if(!rules[i].getAttribute("type") || rules[i].getAttribute("type") == "jslt"){
						return JSLT.apply(rules[i], o);
					}
				
					if(!rules[i].getAttribute("type") || rules[i].getAttribute("type") == "xslt"){
						var wNode = (o.nodeType == 1 ? o : o.ownerElement || o.parentNode || o.selectSingleNode(".."));
	
						var str = '<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"><xsl:template match="' + wNode.tagName + '">'
								  + (rules[i].xml || rules[i].serialize()).replace(/^<[^>]*>/, "").replace(/<\/[^>]*>$/, "").replace(/<(\/?)j\:/g, "<$1xsl:")
								  + '</xsl:template></xsl:stylesheet>'
						var XSLT = Kernel.getObject("XMLDOM", str).documentElement;//rules[i].getElementsByTagName(Kernel.XSLTPrefix + "stylesheet")[0];
						var o = wNode.transformNode(XSLT).replace(/^\<\?xml version="1\.0" encoding="UTF-16"\?>/, "").replace(/\&lt\;/g, "<").replace(/\&gt\;/g, ">").replace(/\&amp\;/g, "&");
						
						if(rules[i].getAttribute("method"))
							try{eval(rules[i].getAttribute("method"))}catch(e){return false;//throw new Error(0, "---- Javeline Error ----\nMessage : Could not find method '" + rules[i].getAttribute("method") + "' referenced in XML.")
						}
	
						return rules[i].getAttribute("method") ? self[rules[i].getAttribute("method")](o, this) : o;
					}
				}

				//Execute Callback if any
				else if(rules[i].getAttribute("method")){
					try{eval(rules[i].getAttribute("method"))}catch(e){throw new Error(1058, Kernel.formErrorString(1058, this, "Transforming data", "Could not find method '" + rules[i].getAttribute("method") + "' referenced in XML."))}

					return self[rules[i].getAttribute("method")](o, this);
					//if(!res) continue;
					//else return res;
				}
				
				//Execute Expression
				else if(rules[i].getAttribute("eval")){
					var func = new Function('xmlNode', 'control', "return " + rules[i].getAttribute("eval"));
					var value = func.call(this, o, this);
					if(!value) continue;
					return value;
				}

				//Process XMLElement
				else{
					if(o.nodeType == 1){
						if(!o.firstChild || o.firstChild.nodeType == 1 || o.firstChild.nodeType > 4) return "";
						//(!o.firstChild || o.firstChild.nodeType == 1 && o.firstChild.nodeType > 4) ? o.appendChild(o.ownerDocument.createTextNode("")) : 
						
						o = o.firstChild;
					}
	
					//Return TextValue of Attribute | Text Node | CDATA Section
					//else if(o.nodeType == 2 || o.nodeType == 3 || o.nodeType == 4){
					var value;
					if(o.nodeType == 2){
						try{value = decodeURI(o.nodeValue);}catch(e){value = o.nodeValue}
						value = unescape(value);
					}
					else value = o.nodeValue;

					//Mask Support
					if(rules[i].getAttribute("mask")){
						if(value.match(/^(?:true|false)$/)) value = value=="true"?1:0;
						return rules[i].getAttribute("mask").split(";")[value];
					}
					else return value;
					//}
					//else return true;
				}

				//return (rules[i].getAttribute("default") || decodeURI(o.nodeValue));//(o.nodeType == 3 ? o.nodeValue : o)
			}
		}

		issueWarning(10002, "Component : " + this.name + " [" + this.tagName + "]\nMessage : Could not find a SmartBindings rule for property '" + setname + "' which matches any data.")

		//Applying failed
		return false;
	}

	/********* SETTYPE ***********
		Set the type of the SmartBindings

		INTERFACE:
		this.setBindClass(strName);
	****************************/
	this.setBindClass = function(sb, part){
		if(typeof sb == "string") sb = Application.getBindClass(sb);
		if(!sb) throw new Error(1059, Kernel.formErrorString(1059, this, "setBindClass Method", "No BindClass was found."));
		this.smartBinding = sb;
		this.smartBinding.initialize(this);
		
		this.dispatchEvent("onsetsmartbinding");
	}
	
	this.removeBindClass = function(){
		if(this.smartBinding)
			this.smartBinding.deinitialize(this);
	}
	
	this.getBindClass = function(){
		return this.smartBinding;
	}
	
	this.setBind = function(bindXPath){
		//bind="" or select-bind=""
		//This function doesnt change the model (for now)
		//It also fucks with other tags like bindings and actions dragdrop.. which it ignores
		//It doesnt work with select-bind (yet)
		
		var sb = new SmartBinding();
		var sModelId = bindHandler.call(this, this.jml, bindXPath, false, sb);
		if(sModelId) modelHandler.call(this, this.jml, sModelId, false);
		
		this.removeBindClass();
		this.setBindClass(sb);
	}
	
	this.getModel = function(do_recur){
		if(do_recur && !this.model)
			return this.dataParent ? this.dataParent.parent.getModel(true) : null;
		
		return this.model;
	}
	
	this.setModel = function(model, xpath){
		if(typeof model == "string") model = NameServer.get("model", model);
		model.register(this, xpath);
	}
	
	/********* GETNODEFROMRULE ***********
		Retrieves Node from Rule

		- this method could be used by applyRuleSet...

		INTERFACE:
		this.getNodeFromRule(setname, cnode);
	****************************/
	this.getNodeFromRule = function(setname, cnode, isAction, getRule, createNode){
		//Get Rules from Array
		var ruleset = isAction ? this.actionRules : this.bindingRules;
		if(ruleset) var rules = ruleset[setname];
		if(!rules) return false;

		for(var i=0;i<rules.length;i++){
			var sel = (rules[i].getAttribute("select-eval") ? eval(rules[i].getAttribute("select-eval")) : rules[i].getAttribute("select"));
			if(!sel) return getRule ? rules[i] : false;
			if(!cnode) return false;
			
			var o = cnode.selectSingleNode(sel);
			if(o) return getRule ? rules[i] : o;
			
			if(createNode || rules[i].getAttribute("create") == "true"){
				var o = XMLDatabase.createNodeFromXpath(cnode, sel);
				return getRule ? rules[i] : o;
			}
		}

		//Retrieving Failed
		return false;
	}

	/********* GETBINDRULE ***********
		Returns bind rule

		INTERFACE:
		this.getBindRule(setname, id);
	****************************/
	this.getBindRule = function(setname, id){
		var rule = false, rules = this.bindingRules ? this.bindingRules[setname] : null;
		if(!rules) return false;
		
		if(setname == "Traverse") return rules[0];

		if(typeof id == "number") rule = rules[id];
		else if(typeof id == "object") rule = id;
		else{
			for(var i=0;i<rules.length;i++){
				if(rules[i].getAttribute("id") == id){
					rule = rules[i];
					break;
				}
			}
		}

		return rule;
	}
	
	/********* ADDBINDRULE ***********
		Add Bind Rule : rule = {rpc:"comm;somefunc",arguments="xpath:@blah;xpath:@iets"}

		INTERFACE:
		this.setBindRule(type, id, select, rule);
	****************************/
	this.setBindRule = function(type, id, attributes){
		var el;
		if(id || type == "Traverse"){
			var rules = this.bindingRules ? this.bindingRules[type] : null;
			for(var i=0;rules&&i<rules.length;i++){
				if(rules[i].getAttribute("id") == id){
					el = rules[i]
					break;
				}
			}
		}
		if(!el)
			el = this.xmlBindings.appendChild(this.xmlBindings.ownerDocument.createElement(type));
		
		for(prop in attributes)
			if(typeof attributes[prop] == "string")
				el.setAttribute(prop, attributes[prop]);
		
		if(type == "Traverse") this.parseTraverse(el);
	}

	/********* REMOVEBINDRULE ***********
		Set Bind Rule to something different

		INTERFACE:
		this.removeBindRule(setname, id);
		this.removeBindRule(setname, nr);
		this.removeBindRule(setname, ruleNode);
	****************************/
	this.removeBindRule = function(setname, id){
		var rule = this.getBindRule(setname, id);
		if(!rule) return false;

		rule.parentNode.removeChild(rule);
	}

	/********* RELOAD ***********
		Reloads the current XML Data

		INTERFACE:
		this.reload();
	****************************/
	this.reload = function(){
		this.load(this.XMLRoot, this.cacheID, true);
	}

	/********* LOAD *************
		Loads data from a DOM Node Reference

		INTERFACE:
		this.load(xmlRootNode, cacheID);
		this.load(xmlString, cacheID);
	****************************/
	this.load = function(xmlRootNode, cacheID, forceNoCache){
		setStatus("Loading XML data in " + this.tagName + "[" + (this.name || '') + "]");
		
		Kernel.Popup.forceHide(); //This should be put in a more general position
		
		// If control hasn't loaded databinding yet, buffer the call
		if(!this.bindingRules && this.jml && (!this.smartBinding || Application.stackHasBindings(this.uniqueId))) //(this.jml.getAttribute("smartbinding") || this.jml.getAttribute("bindings"))) 
			return loadqueue = [xmlRootNode, cacheID];
		
		// Convert first argument to an xmlNode we can use;
		if(xmlRootNode) xmlRootNode = XMLDatabase.getBindXmlNode(xmlRootNode);
		
		// If no xmlRootNode is given we clear the control, disable it and return
		if(this.dataParent && this.dataParent.xpath) this.dataParent.parent.signalXmlUpdate[this.uniqueId] = !xmlRootNode;
		if(!xmlRootNode){
			this.clear(null, true);
			if(Application.autoDisable) this.disable();
			this.setConnections();
			return;
		}
		this.disabled = false;
		
		//Run onload event
		if(this.dispatchEvent("onbeforeload", xmlRootNode) === false) return false;
		
		// If reloading current document, and caching is disabled, exit
		if(this.caching && !forceNoCache && xmlRootNode == this.XMLRoot) return;
		
		// retrieve the cacheId
		if(!cacheID){
			cacheID = xmlRootNode.getAttribute(XMLDatabase.xmlIdTag) ||
				XMLDatabase.nodeConnect(XMLDatabase.getXmlDocId(xmlRootNode), xmlRootNode);
		}

		// Remove message notifying user the control is without data
		if(this.__removeClearMessage) this.__removeClearMessage();
		
		// Retrieve cached version of document if available
		if(this.caching && !forceNoCache && this.getCache(cacheID)){
			if(!this.hasFeature(__MULTISELECT__)) this.setConnections(this.XMLRoot, "select");
			else{
				var nodes = this.getTraverseNodes();
				
				//Information needs to be passed to the followers... even when cached...
				if(nodes.length && this.autoselect) this.select(nodes[0], null, null, null, true);
				else this.setConnections();
			}
			
			this.dispatchEvent('onafterload', xmlRootNode);
			return;
		}
		else this.clear(true);

		//Set usefull vars
		this.documentId = XMLDatabase.getXmlDocId(xmlRootNode);
		this.cacheID = cacheID;
		this.XMLRoot = xmlRootNode;

		// Draw Object & Load Content
		this.__load(xmlRootNode);

		// Check if subtree should be loaded
		this.__loadSubData(xmlRootNode);
		
		this.disabled = true; //force enabling
		this.enable();

		// Check Connections
		if(!this.hasFeature(__MULTISELECT__)) this.setConnections(this.XMLRoot);

		// Run onafteronload event
		this.dispatchEvent('onafterload', xmlRootNode);
	}
	
	this.__loadSubData = function(xmlRootNode){
		if(this.hasLoadStatus(xmlRootNode)) return;
			
		//var loadNode = this.applyRuleSetOnNode("Load", xmlRootNode);
		var loadNode, rule = this.getNodeFromRule("Load", xmlRootNode, false, true);

		if(rule && (loadNode = xmlRootNode.selectSingleNode(rule.getAttribute("select")))){
			this.setLoadStatus(xmlRootNode, "loading");
			
			//||XMLDatabase.findModel(xmlRootNode)
			var mdl = this.getModel(true);
			if(!mdl) throw new Error(0, "Coult not find model");

			if(mdl.extend(rule, this, loadNode) === false){
				this.clear(true);
				if(Application.autoDisable) this.disable();
				this.setConnections(null, "select"); //causes strange behaviour
			}
		}
	}

	//Loading
	this.setLoadStatus = function(xmlNode, state){
		//remove old status if any
		var ostatus = xmlNode.getAttribute("_loaded");
		ostatus = ostatus ? ostatus.replace(new RegExp("\\|\\w+\\:" + this.uniqueId + "\\|", "g"), "") : "";
		ostatus += "|" + state + ":" + this.uniqueId + "|";
		xmlNode.setAttribute("_loaded", ostatus);
	}
	
	this.removeLoadStatus = function(xmlNode){
		var attr = xmlNode.getAttributeNode("_loaded");
		if(attr) xmlNode.removeAttributeNode(attr);
	}

	this.hasLoadStatus = function(xmlNode, state){
		var ostatus = xmlNode.getAttribute("_loaded");
		if(!ostatus) return false;

		return (ostatus.indexOf((state || "") + ":" + this.uniqueId + "|") != -1)
	}

	/********* INSERT ***********
		Inserts data into object and reparse

		INTERFACE:
		this.insert(XMLRoot, parentXMLNode);
		this.insert(XMLString, parentXMLNode);
	****************************/
	this.insert = function(XMLRoot, parentXMLNode){
		if(typeof XMLRoot != "object") XMLRoot = Kernel.getObject("XMLDOM", XMLRoot).documentElement;
		if(!parentXMLNode) parentXMLNode = this.XMLRoot;
		
		if(this.dispatchEvent("onbeforeinsert", parentXMLNode) === false) return false;

		//Integrate XMLTree with parentNode
		var newNode = XMLDatabase.integrate(XMLRoot, parentXMLNode, true);

		//Call __XMLUpdate on all listeners
		XMLDatabase.applyChanges("insert", parentXMLNode);

		//Select or propagate new data
		if(this.selectable && this.autoselect){
			if(this.XMLRoot == newNode)
				newNode = this.XMLRoot.selectSingleNode(this.ruleTraverse);
			if(newNode) this.select(newNode);
		}
		else if(this.XMLRoot == newNode)
			this.setConnections(this.XMLRoot, "select");
		
		if(this.hasLoadStatus(XMLRoot, "loading"))
			this.setLoadStatus(XMLRoot, "loaded");

		this.dispatchEvent("onafterinsert");
	
		//Check Connections
		//this one shouldn't be called because they are listeners anyway...(else they will load twice)
		//if(this.value) this.setConnections(this.value, "select");
	}

	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/
	this.inherit(this.hasFeature(__MULTISELECT__) ? MultiselectBinding : StandardBinding);
	
	function findModel(x, isSelection){
		return x.getAttribute((isSelection ? "select-" : "") + "model") || XMLDatabase.getInheritedAttribute(x, null, function(xmlNode){
			if(isSelection && x == xmlNode) return false;
			if(xmlNode.getAttribute("model")){
				/*var isCompRef = xmlNode.getAttribute("model").substr(0,1) == "#";
				if(xmlNode.getAttribute("id") && self[xmlNode.getAttribute("id")].hasFeature(__DATABINDING__)){
					var data = xmlNode.getAttribute("model").split(":", 3);
					return "#" + xmlNode.getAttribute("id") + ((isCompRef ? data[2] : data[1]) || "");
				}*/
				return xmlNode.getAttribute("model");
			}
			if(xmlNode.getAttribute("smartbinding")){
				var bclass = x.getAttribute("smartbinding").split(" ")[0];
				if(NameServer.get("model", bclass)) return bclass + ":select";
			}
			return false
		});
	}

	function bindHandler(x, strBindRef, isSelection, sb){
		var strBind = [];
		
		// Check bind tag
		//if(x.getAttribute("bind") && (!bclasses || bclasses.length < 2)){
			
		// Define model
		var modelId = findModel(x, isSelection);
		
		var xsltURL = x.getAttribute("xslt"), bindRoot, bindMethod = x.getAttribute("bind-method"), bindWay = XMLDatabase.getInheritedAttribute(x, "bind-attach") || "value"; // | value
		if(!modelId) throw new Error(1062, Kernel.formErrorString(1062, this, "init", "Could not find model to connect to for inline SmartBinding", x));
		
		if(bindWay == "value"){
			strBindRef.match(/^(.*?)((?:\@[\w-_\:]+|text\(\))(\[.*?\])?|[\w-_\:]+\[.*?\])?$/);
			var valuePath = RegExp.$1;
			if(!valuePath && valuePath !== "") throw new Error(1063, Kernel.formErrorString(1063, this, "init SmartBindings", "Could not find xpath to determine XMLRoot: " + strBindRef, x));
			
			var modelIdParts = modelId.split(":", 3);
			var valueSelect = RegExp.$2 || ".";
			
			//Rebuild model string
			modelId = modelIdParts.shift();
			if(modelId.substr(0,1) == "#") modelId += (modelIdParts[0] ? ":" + modelIdParts.shift() : ":select")
			if(modelIdParts[0] || valuePath) modelId += ":" + ((modelIdParts[0] ? modelIdParts[0] + "/" : "") + (valuePath || ".")).replace(/\/$/, "").replace(/\/\/+/, "/");
		}
		strBind.push("<bindings>");
		
		strBind.push("<" + (this.mainBind || "Value") + " select=\"" + (bindWay == "value" ? valueSelect + "\" " : strBindRef.replace(/\"/g, '\\"') + "\" ") + "create=\"true\" ");
		if(bindMethod) strBind.push("method='" + bindMethod + "'");
		if(xsltURL) strBind.push("/><include src='" + xsltURL + "' ");
		if(isSelection && x.getAttribute("select-caption")) strBind.push("/><Caption select='" + x.getAttribute("select-caption") + "' "); //hack!
		strBind.push("/></bindings>");

		var sb;
		if(strBind.length){
			strBind.unshift("<smartbinding>");
			strBind.push("</smartbinding>");

			var sNode = Kernel.getObject("XMLDOM", strBind.join("")).documentElement;
			loadJMLIncludes(sNode, new HTTP(), true);
			
			if(sb) sb.construct(sNode);
			else Application.addToSbStack(this.uniqueId, new SmartBinding(null, sNode), isSelection ? 1 : 0);
		}
		
		return modelId;
	}
	
	/**
	 * @jmlattribute 		{String} 	model	Sets the model from which the component gets it's data.
	 * - model="id:xpath"
	 * - model="#component"
	 * - model="#component:select"
	 * - model="#component:select:xpath"
	 * - model="#component"
	 * - model="#component:choose"
	 * - model="#component:choose:xpath"
	 * - [WISHLIST] model="#component::xpath"
	 * - model="::xpath"
	 * - model="file:http://asasda.com"
	 * - model="rpc:obj.call:arg1;arg2;arg3"
	 */
	function modelHandler(x, strModelRef, isSelection){
		//Application.getFromSbStack(this.uniqueId)
		if(!strModelRef) return;

		var data = strModelRef.split(":", 3);

		if(data[0] == "file"){
			data.shift()
			this.setModel(new Model().parse(null, data.join(":")));
			//x.setAttribute((isSelection ? "select-" : "") + "model", "#" + this.name + (data.length ? ":" + data.join(":") : ""));
		}
		else if(data[0] == "rpc"){
			alert("Unsupported: " + x.getAttribute("model"));
			//this.setModel(new Model().parse(null, data[1]));
		}
		else if(data[0].substr(0,1) == "#"){
			data[0] = data[0].substr(1);
			
			if(isSelection){
				var sb2 = Application.getFromSbStack(this.uniqueId, 1);
				if(sb2) sb2.model = new Model().parse(null, null, data[0], data[1] || "select", data[2])
			}
			else if(!self[data[0]] || !Application.inited){
				Application.addToModelStack(this, data)
			}
			else{
				eval(data[0]).connect(this, null, data[2], data[1] || "select");
			}
			
			this.connectId = data[0];
		}
		else{
			var model = NameServer.get("model", data[0]);
			
			if(!model)
				throw new Error(1068, Kernel.formErrorString(1068, this, "Finding model", "Could not find model by name: " + data[0], x));
			
			if(isSelection){
				var sb2 = Application.getFromSbStack(this.uniqueId, 1);
				if(sb2){
					sb2.model = model;
					sb2.modelXpath[this.uniqueId] = data[1];
				}
			}
			else this.setModel(model, data[1]);
		}
	}
	
	this.__addJmlLoader(function(x){
		var modelId, bclasses;
		if(x.getAttribute("smartbinding")){
			bclasses = x.getAttribute("smartbinding").split(" ");

			if(bclasses.length > 2) issueWarning(0, "Component : " + this.name + " [" + this.tagName + "]\nMessage : Found more than two bindclasses, using only the first two.")
			
			for(var i=0;i<Math.min(2,bclasses.length);i++){
				var sNode = Application.getBindClass(bclasses[i]);
	
				if(!sNode) throw new Error(1061, Kernel.formErrorString(1061, this, "Jml Loader", "Could not find SmartBindings type set for " + this.tagName + " component with the name : '" + x.getAttribute("smartbinding") + "'"));
			
				Application.addToSbStack(this.uniqueId, sNode);
			}
		}
		
		
		if((x.getAttribute("bind") || x.getAttribute("select-bind")) && bclasses && bclasses.length > 1) issueWarning(0, "Component : " + this.name + " [" + this.tagName + "]\nMessage : Found more than one bindclass and an inline bindings rule, ignoring the bindings rule.")
		
		if(x.getAttribute("select-bind")){
			var sModelId = bindHandler.call(this, x, x.getAttribute("select-bind"), true)
			if(sModelId) modelHandler.call(this, x, sModelId, true);
		}
		
		var strBind = [];
		
		//DragDrop
		if(this.hasFeature(__DRAGDROP__) && (x.getAttribute("dragEnabled") || x.getAttribute("dropEnabled"))){
			/*
			dragEnabled, dropEnabled dragMoveEnabled
			
			<j:allow-drag select="self::Item" />
			<j:allow-drop select="self::Item" target="self::Items" operation="list-append" />
			<j:allow-drop select="self::Item" target="self::Item" operation="insert-before" />
			*/

			strBind = ["<dragdrop>"];
			if(x.getAttribute("dragEnabled") == "true") strBind.push('<allow-drag select="." copy-condition="' + (x.getAttribute("dragMoveEnabled") == "true" ? "event.ctrlKey" : "true") + '"/>');
			if(x.getAttribute("dropEnabled")){
				var sel = x.getAttribute("dropEnabled") != "true" ? "select='" + x.getAttribute("dropEnabled") + "'" : (this.hasFeature(__MULTISELECT__) ? "select-eval=\"'self::' + this.ruleTraverse.split('|').join('|self::')\"" : "select='.'");
				
				strBind.push(
					'<allow-drop ' + sel + ' operation="list-append" copy-condition="' + (x.getAttribute("dragMoveEnabled") == "true" ? "event.ctrlKey" : "true") + '"/>',
					'<allow-drop ' + sel + ' target="." operation="insert-before" copy-condition="' + (x.getAttribute("dragMoveEnabled") == "true" ? "event.ctrlKey" : "true") + '"/>'
				);
			}
			strBind.push("</dragdrop>");
			
			var sNode = Kernel.getObject("XMLDOM", strBind.join("")).documentElement;
			(Application.getFromSbStack(this.uniqueId) || Application.addToSbStack(this.uniqueId, new SmartBinding())).addDragDrop(Kernel.getRules(sNode));
		}
		
		//Bindings
		if(x.getAttribute("bindings")){
			var sb = Application.getFromSbStack(this.uniqueId) || Application.addToSbStack(this.uniqueId, new SmartBinding());

			if(!NameServer.get("bindings", x.getAttribute("bindings")))
				throw new Error(1064, Kernel.formErrorString(1064, this, "Connecting bindings", "Could not find bindings by name '" + x.getAttribute("bindings") + "'", x));
			
			sb.addBindings(NameServer.get("bindings", x.getAttribute("bindings")));
		}
		
		//Actions
		if(x.getAttribute("actions")){
			var sb = Application.getFromSbStack(this.uniqueId) || Application.addToSbStack(this.uniqueId, new SmartBinding());
			
			if(!NameServer.get("actions", x.getAttribute("actions")))
				throw new Error(1065, Kernel.formErrorString(1065, this, "Connecting bindings", "Could not find actions by name '" + x.getAttribute("actions") + "'", x));
			
			sb.addActions(NameServer.get("actions", x.getAttribute("actions")));
		}
		
		//DragDrop
		if(x.getAttribute("dragdrop") && typeof x.getAttribute("dragdrop") == "string"){ //Strange IE behaviour
			var sb = Application.getFromSbStack(this.uniqueId) || Application.addToSbStack(this.uniqueId, new SmartBinding());
			
			if(!NameServer.get("dragdrop", x.getAttribute("dragdrop")))
				throw new Error(1066, Kernel.formErrorString(1066, this, "Connecting dragdrop", "Could not find dragdrop by name '" + x.getAttribute("dragdrop") + "'", x));
			
			sb.addDragDrop(NameServer.get("dragdrop", x.getAttribute("dragdrop")));
		}

		if(x.getAttribute("bind")){
			modelId = x.getAttribute("select-bind") ? null : bindHandler.call(this, x, x.getAttribute("bind"), false);
		}
		else{
			var sb = Application.getFromSbStack(this.uniqueId);
			if(sb && !sb.model) modelId = findModel(x);
			//!this.hasFeature(__POTENTIAL_MULTIBINDING__) && 
		}

		if(x.getAttribute("empty")) this.msg = x.getAttribute("empty");
		
		if(!this.model && modelId) modelHandler.call(this, x, modelId, false);
		
		//handle defer update here...
		
	});

	//Trigger Databinding Connections
	this.addEventListener("onbeforeselect", function(valueList){
		var combinedvalue = null;
		
		if(this.indicator == this.value || valueList && valueList.length > 1 && this.getConnections().length){
			//Multiselect databinding handling... [experimental]
			if(valueList && valueList.length > 1 && this.getConnections().length){
				var oEl = this.XMLRoot.ownerDocument.createElement(this.value.tagName);
				var attr = {};
				
				//Fill basic nodes
				var nodes = valueList[0].attributes;
				for(var j=0;j<nodes.length;j++) attr[nodes[j].nodeName] = nodes[j].nodeValue;
				
				//Remove nodes
				for(var i=1;i<valueList.length;i++){
					for(prop in attr){
						if(typeof attr[prop] != "string") continue;
						
						if(!valueList[i].getAttributeNode(prop)) attr[prop] = undefined;
						else if(valueList[i].getAttribute(prop) != attr[prop]) attr[prop] = "";
					}
				}
				
				//Set attributes
				for(prop in attr){
					if(typeof attr[prop] != "string") continue;
					oEl.setAttribute(prop, attr[prop]);
				}
				
				//missing is childnodes... will implement later when needed...
				
				oEl.setAttribute(XMLDatabase.xmlIdTag, this.uniqueId);
				MultiSelectServer.register(oEl.getAttribute(XMLDatabase.xmlIdTag), oEl, valueList, this);
				XMLDatabase.addNodeListener(oEl, MultiSelectServer);
				
				combinedvalue = oEl;
			}
		}
		
		var jNode = this;
		setTimeout(function(){jNode.setConnections(combinedvalue || jNode.value);}, 10);
	});
	
	this.addEventListener("onafterdeselect", function(){
		//this.setConnections(this.value);
		setTimeout('var o = Kernel.lookup(' + this.uniqueId + ');o.setConnections(null);', 10);
	});
}

function StandardBinding(){
	if(!this.defaultValue) this.defaultValue = "";

	/********* __LOAD ***********
		initializes properties of control

		INTERFACE:
		this.__load(XMLRoot);
	****************************/
	this.__load = function(XMLRoot){
		//Add listener to XMLRoot Node
		XMLDatabase.addNodeListener(XMLRoot, this);

		//Set Properties
		
		
		this.setProperty("value", this.applyRuleSetOnNode(this.mainBind, this.XMLRoot) || this.defaultValue, null, true);
		
		
		//Think should be set in the event by the Validation Class
		if(this.errBox && this.isValid()){
			this.clearError(); 
			if(this.errBox.isVisible() && this.validgroup && this.errBox.host == this) 
				this.errBox.hide();
		}
	}

	/********* __XMLUPDATE ***********
		Set properties of control

		INTERFACE:
		this.__xmlUpdate(action, xmlNode [, listenNode [, UndoObj]] );
	****************************/
	this.__xmlUpdate = function(action, xmlNode, listenNode, UndoObj){
		//Action Tracker Support
		if(UndoObj) UndoObj.xmlNode = this.XMLRoot;

		//Set Properties
	

		var value = this.applyRuleSetOnNode(this.mainBind, this.XMLRoot) || this.defaultValue;
		if(this.value != value) this.setProperty("value", value, null, true);
		
		
		//Think should be set in the event by the Validation Class
		if(this.errBox && this.isValid()){
			this.clearError(); 
			if(this.errBox.isVisible() && this.validgroup && this.errBox.host == this) 
				this.errBox.hide();
		}
	}
}

function MultiselectBinding(){
	/********* __LOAD ***********
		Set listeners, calls HTML creation methods and
		initializes select and focus states of object.

		INTERFACE:
		this.__load(XMLRoot);
	****************************/
	this.__load = function(XMLRoot){
		//Add listener to XMLRoot Node
		XMLDatabase.addNodeListener(XMLRoot, this);

		//Traverse through XMLTree
		var nodes = this.__addNodes(XMLRoot);

		//Build HTML
		this.__fill(nodes);

		//Select First Child
		if(this.selectable){
			if(this.autoselect){
				if(nodes.length) this.__selectDefault(XMLRoot);
				else this.setConnections();
			}
			else{
				this.clearSelection(null, true);
				this.setConnections(null, "both");
			}
		}
		if(this.focussable) me.isFocussed(this) ? this.__focus() : this.__blur();
	}

	/********* __XMLUPDATE ***********
		Loops through parents of changed node to find the first
		connected node. Based on the action it will change, remove
		or update the representation of the data.

		INTERFACE:
		this.__xmlUpdate(action, xmlNode [, listenNode [, UndoObj]] );
	****************************/
	this.__xmlUpdate = function(action, xmlNode, listenNode, UndoObj, lastParent){
		var result, startNode = xmlNode;
		if(!listenNode) listenNode = this.XMLRoot;

		//Get First ParentNode connected
		do{
			if(action == "add" && this.isTraverseNode(xmlNode)) break; //Might want to comment this out for adding nodes under a traversed node
			if(xmlNode.getAttribute(XMLDatabase.xmlIdTag)){
				var htmlNode = this.getNodeFromCache(xmlNode.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId);
				//if(!htmlNode) alert(xmlNode.getAttribute("id")+"|"+this.uniqueId);

				if(startNode != xmlNode && action.match(/add|remove|insert|synchronize|add/)) action = "update";
				if(xmlNode == listenNode) break;

				if(htmlNode && !action.match(/insert|add|remove|synchronize/) && !this.isTraverseNode(xmlNode))
					action = "remove";
					//break???

				if(!htmlNode && !action.match(/insert|remove|synchronize|move/) && this.isTraverseNode(xmlNode)){
					action = "add";
					break;
				}

				if(htmlNode  || action == "move") break;
			}
			else if(!action.match(/insert|add|remove|synchronize|move-away|move/) && this.isTraverseNode(xmlNode)){
				action = "add";
				break;
			}
			if(xmlNode == listenNode) break;
			xmlNode = xmlNode.parentNode;
		}while(xmlNode && xmlNode.nodeType != 9)

		//if(xmlNode == listenNode && !action.match(/add|synchronize|insert/)) return; //deleting nodes in parentData of object

		var foundNode = xmlNode;
		if(xmlNode && xmlNode.nodeType == 9) xmlNode = startNode;
		
		if(action == "replacechild" && (UndoObj ? UndoObj.args[0] == this.XMLRoot : !this.XMLRoot.parentNode)){
			return this.load(UndoObj ? UndoObj.args[1] : listenNode); //Highly doubtfull this is exactly right...
		}

		//Action Tracker Support - && xmlNode correct here??? - UndoObj.xmlNode works but fishy....
		if(UndoObj && xmlNode && !UndoObj.xmlNode) UndoObj.xmlNode = xmlNode;

		//Check Move -- if value node isn't the node that was moved then only perform a normal update
		if(action == "move" && foundNode == startNode){
			//if(!htmlNode) alert(xmlNode.getAttribute("id")+"|"+this.uniqueId);
			var isInThis = XMLDatabase.isChildOf(this.XMLRoot, xmlNode.parentNode, true);
			var wasInThis = XMLDatabase.isChildOf(this.XMLRoot, UndoObj.pNode, true);

			//Move if both previous and current position is within this object
			if(isInThis && wasInThis) this.__moveNode(xmlNode, htmlNode);

			//Add if only current position is within this object
			else if(isInThis) action = "add";

			//Remove if only previous position is within this object
			else if(wasInThis) action = "remove";
		}
		else if(action == "move-away"){
			var goesToThis = XMLDatabase.isChildOf(this.XMLRoot, UndoObj.toPnode, true);
			if(!goesToThis) action = "remove";
		}

		//Check Insert
		if(action == "insert" && (this.isTreeArch || xmlNode == this.XMLRoot)){
			if(this.hasLoadStatus(xmlNode) && this.__removeLoading) this.__removeLoading(htmlNode);
			result = this.__addNodes(xmlNode, (this.__getParentNode ? this.__getParentNode(htmlNode) : htmlNode), true, false);//this.isTreeArch??
			this.__fill(result);

			if(this.selectable && !this.XMLRoot.selectSingleNode(this.ruleTraverse)) issueWarning(1106, "---- Javeline Error ----\nMessage : No traversable nodes were found for " + this.name + " [" + this.tagName + "]\nTraverse Rule : " + this.ruleTraverse);// + "\nXML string : " + this.XMLRoot.xml)
			if(this.selectable && !this.XMLRoot.selectSingleNode(this.ruleTraverse)) return;

			if(this.selectable && this.autoselect) this.select(this.value || this.XMLRoot.selectSingleNode(this.ruleTraverse));
		}

		//Check Add
		else if(action == "add"){// || !htmlNode
			//var parentHTMLNode = this.getCacheItemByHtmlId(xmlNode.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId);
			//xmlNode.parentNode == this.XMLRoot ? this.oInt : 
			var parentHTMLNode = xmlNode.parentNode == this.XMLRoot ? this.oInt : this.getCacheItem(xmlNode.parentNode.getAttribute(XMLDatabase.xmlIdTag)) || this.getNodeFromCache(xmlNode.parentNode.getAttribute(XMLDatabase.xmlIdTag) + "|" + this.uniqueId);
			//This should be moved into a function (used in setCache as well)
			if(!parentHTMLNode) parentHTMLNode = this.getCacheItem(xmlNode.parentNode.getAttribute(XMLDatabase.xmlIdTag) || (xmlNode.parentNode.getAttribute(XMLDatabase.xmlDocTag) ? "doc" + xmlNode.parentNode.getAttribute(XMLDatabase.xmlDocTag) : false) ) || this.oInt;

			//Only update if node is in current representation or in cache
			if(parentHTMLNode || XMLDatabase.isChildOf(this.XMLRoot, xmlNode)){
				parentHTMLNode = (this.__findContainer && parentHTMLNode ? this.__findContainer(parentHTMLNode) : parentHTMLNode) || this.oInt;

				var beforeXMLNode = this.getNextTraverse(xmlNode);
				var beforeHTMLNode = beforeXMLNode ? this.getNodeFromCache(beforeXMLNode.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId) : null;

				result = this.__addNodes(xmlNode, parentHTMLNode, true, true, beforeHTMLNode);//&& this.isTreeArch

				if(parentHTMLNode) this.__fill(result);
			}
		}

		//Check Remove
		else if((action == "remove") && foundNode == xmlNode && xmlNode.parentNode){
			
			//Remove HTML Node
			if(htmlNode) this.__deInitNode(xmlNode, htmlNode);
			else if(xmlNode == this.XMLRoot) return this.load(null);
		}

		else if(htmlNode){
			this.__updateNode(xmlNode, htmlNode);
			
			//UpdateDefer 'niceties'
			if(action == "replacechild" && this.hasFeature(__MULTISELECT__) && this.value && xmlNode.getAttribute(XMLDatabase.xmlIdTag) == this.value.getAttribute(XMLDatabase.xmlIdTag)){
				this.value = xmlNode;
			}

			if(action == "synchronize" && this.autoselect) this.reselect();
		}

		var pNode = xmlNode ? xmlNode.parentNode : lastParent;
		if(pNode && this.isTreeArch){
			do{
				var htmlNode = this.getNodeFromCache(pNode.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId);
				if(htmlNode) this.__updateNode(pNode, htmlNode);
			}while(pNode = this.getTraverseParent(pNode));
		}
		
		if(this.signalXmlUpdate && action.match(/^(?:synchronize|add|insert)$/)){
			var uniqueId;
			for(uniqueId in this.signalXmlUpdate){
				var o = Kernel.lookup(uniqueId);
				if(!this.value) continue;
				var xmlNode = this.value.selectSingleNode(o.dataParent.xpath);
				if(!xmlNode) continue;
				o.load(xmlNode);
			}
		}

		this.dispatchEvent("onxmlupdate", action, xmlNode, result);
	}

	/********* __ADDNODES ***********
		Loop through NodeList of selected Traverse Nodes
		and check if it has representation. If it doesn't
		representation is created via __add().

		TODO:
		<Traverse select="" sort="@blah" data-type={"text" | "number" | "script"} method="" order={"ascending" | "descending"} case-order={"upper-first" | "lower-first"} />
		- Also: inserts (auto-sort) see e-messenger behaviour

		INTERFACE:
		this.__addNodes(xmlNode, HTMLParent, checkChildren);
	****************************/
	this.__addNodes = function(xmlNode, parent, checkChildren, isChild, insertBefore){
		if(!this.ruleTraverse){
			throw new Error(1060, Kernel.formErrorString(1060, this, "adding Nodes for load", "No traverse SmartBinding rule was specified. This rule is required for a " + this.tagName + " component.", this.jml));
		}

		var isChild = isChild && this.isTraverseNode(xmlNode);
		var htmlNode, lastNode, nodes = isChild ? [xmlNode] : this.getTraverseNodes(xmlNode);//.selectNodes(this.ruleTraverse);
		var loadChildren = nodes.length && this.bindingRules["Insert"] ? this.applyRuleSetOnNode("Insert", xmlNode) : false;

		for(var i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1) continue;

			if(checkChildren) htmlNode = this.getNodeFromCache(nodes[i].getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId);

			if(!htmlNode){
				//Retrieve DataBind ID
				var Lid = XMLDatabase.nodeConnect(this.documentId, nodes[i], null, this);

				//Add Children
				var beforeNode = isChild ? insertBefore : (lastNode ? lastNode.nextSibling : (parent || this.oInt).firstChild);
				var parentNode = this.__add(nodes[i], Lid, isChild ? xmlNode.parentNode : xmlNode, beforeNode ? parent || this.oInt : parent, beforeNode, !beforeNode && i==nodes.length-1);//Should use getTraverParent
				
				//Exit if component tells us its done with rendering
				if(parentNode === false){
					//Tag all needed xmlNodes for future reference
					for(i=i;i<nodes.length;i++) XMLDatabase.nodeConnect(this.documentId, nodes[i], null, this);
					break;
				}

				//Parse Children Recursively -> optimize: don't check children that can't exist
				//if(this.isTreeArch) this.__addNodes(nodes[i], parentNode, checkChildren);
			}

			if(checkChildren) lastNode = htmlNode;// ? htmlNode.parentNode.parentNode : null;
		}

		return nodes;
	}
			
}


/*FILEHEAD(/in/Core/Node/DeferredUpdate.js)SIZE(3770)TIME(1186794342407)*/
__DEFERREDUPDATE__ = 1<<3;


function DeferredUpdate(){
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	this.__regbase = this.__regbase|__DEFERREDUPDATE__;
	
	/*********************************************************************
										ACTIONS
	*********************************************************************/
	
	this.AddDefer = function(xmlNode){
		if(!xmlNode) xmlNode = this.XMLRoot;
		
		var o = this.__atReset();
		
		//Use ActionTracker :: this.xmlData.selectSingleNode("DataBinding/@select") ? o.XMLRoot : o.value
		this.executeAction("appendChildNode", [o.getTraverseParent(o.value) || o.XMLRoot, xmlNode], "AddDefer", xmlNode);//o.value || 
	}
	
	this.UpdateDefer = function(xmlNode){
		if(!xmlNode) xmlNode = this.XMLRoot;
		
		//if(!this.__ActionTracker.hasChanged) return this.Cancel();
		
		var o = this.__atReset();
		
		//Use ActionTracker
		//getTraverseParent(o.value) || o.XMLRoot
		var at = this.__ActionTracker; this.__ActionTracker = self[this.jml.getAttribute("actiontracker")];//this.dataParent.parent.getActionTracker();
		this.executeAction("replaceNode", [o, xmlNode], "UpdateDefer", xmlNode);
		this.__ActionTracker = at;

		this.load(xmlNode);
	}
	
	this.Cancel = function(){
		if(this.rpcMode == "realtime")
			this.__ActionTracker.undo(-1);
		
		if(this.__ActionTracker) this.__ActionTracker.reset();
		//this.XMLDatabase.reset();

		if(!this.XMLRoot.parentNode) this.load(this.oldRoot);
		var o = this.oldRoot;
		this.oldRoot = null;
	}

	/*********************************************************************
										PRIVATE
	*********************************************************************/
	
	this.fork = function(){
		if(this.oldRoot) this.Cancel();
		
		var addXmlNode;

		if(this.defaultMode == "add"){
			//Determine addXmlNode
			var node = this.actionRules["AddDefer"];
			if(!node || !node[0]) throw new Error(0, "Could not get Node for Action");
	
			//Hard Coded XML
			if(node.firstChild) 
				addXmlNode = node.firstChild.cloneNode(true);
			//Execute Client Side Response
			else if(node.getAttribute("object"))
				addXmlNode = self[node.getAttribute("object")][node.getAttribute("method")]();
			else if(node.getAttribute("method"))
				addXmlNode = self[node.getAttribute("method")]();
			else if(node.getAttribute("eval"))
				addXmlNode = eval(node.getAttribute("eval"));
	
			if(addXmlNode && typeof addXmlNode != "object") 
				addXmlNode = Kernel.getObject("XMLDOM", addXmlNode).documentElement;
		}
		
		if(addXmlNode) this.load(addXmlNode);
		else{
			this.oldRoot = this.XMLRoot;
			var xmlNode = this.XMLRoot.cloneNode(true);//XMLDatabase.clearConnections(this.XMLRoot.cloneNode(true));
			//xmlNode.removeAttribute(XMLDatabase.xmlIdTag);
			
			//rename listening attributes
			
			this.load(xmlNode);
		}
	}
	
	this.__atReset = function(){
		//Integrate in ActionTracker one level down !?! -> (or execute rpc calls)
		this.__ActionTracker.purge();//true
		
		//rename listening attributes back
		
		//Integrate XMLRoot with oldRoot

		var o = this.oldRoot;
		this.oldRoot = null;
		
		//Implement XML from XMLDatabase Router
		//this.XMLDatabase.synchronize();
		//this.XMLDatabase.reset();
		
		//try{!this.dataParent}catch(e){throw new Error(1069, Kernel.formErrorString(1069, this, "Defer Update", "Could not find object reference to connect databinding: '" + this.xmlData.selectSingleNode("Data").getAttribute("connect") + "'\n" + this.xmlData.selectSingleNode("Data").xml))}
		
		//var o = this.dataParent.parent;
		//o.XMLRoot.appendChild(xmlNode);
		
		return o;
	}
}

/*FILEHEAD(/in/Core/Node/DelayedRender.js)SIZE(1581)TIME(1182088294453)*/
__DELAYEDRENDER__ = 1<<11


function DelayedRender(){
	this.__regbase = this.__regbase|__DELAYEDRENDER__;
	this.isRendered = false;
	
	var withheld = false;
	
	this.__checkDelay = function(x){
		if(x.getAttribute("render") == "runtime"){
			x.setAttribute("render-status", "withheld");
			if(!Application.renderWithheld) Application.renderWithheld = [];
			Application.renderWithheld.push(this);
			
			withheld = true;
			return true;
		}
		
		this.isRendered = true;
		return false;
	}
	
	this.render = function(usedelay){
		if(this.isRendered || this.jml.getAttribute("render-status") != "withheld") return;
		this.dispatchEvent("onbeforerender");
		
		if(isNull(this.usedelay)) 
			this.usedelay = XMLDatabase.getInheritedAttribute(this.jml, "use-render-delay") == "true";

		if(this.usedelay || usedelay) setTimeout("Kernel.lookup(" + this.uniqueId + ").__render()", 10);
		else this.__render();
	}

	this.__render = function(){
		Application.loadSubNode(this.jml, this.oInt, this);
		
		LayoutServer.activateGrid();
		LayoutServer.activateRules();//document.body
		
		Profiler.end();
		setStatus("[TIME] Total load time: " + Profiler.totalTime + "ms");
		Profiler.start(true);
		
		Application.processDatabinding();
		//setTimeout("Application.processDatabinding();");

		this.jml.setAttribute("render-status", "done");
		this.isRendered = true;
		withheld = false;
		
		this.dispatchEvent("onafterrender");
	}
}


/*FILEHEAD(/in/Core/Node/DragDrop.js)SIZE(13139)TIME(1188900006250)*/
__DRAGDROP__ = 1<<5;


//Add to node keyhandler
//if(this.dragging) return; //or accept esc to disable

function DragDrop(){
	/***********************
		INTERFACE REQUIRED
		
		htmlNode = this.__showDragIndicator(selection);
					  this.__hideDragIndicator();
					  this.__dragout();
					  this.__dragover(el, selection);
					  this.__dragdrop(el, selection);
	***********************/
	this.__regbase = this.__regbase|__DRAGDROP__;
	
	/***********************
			Actions	
	***********************/
	
	this.Copy = function(pnode, xmlNode, beforeNode){
		var xmlNode = xmlNode.cloneNode(true);

		//Use Action Tracker
		var exec = this.executeAction("appendChildNode", [pnode, xmlNode, beforeNode], "Copy", xmlNode);
		if(exec !== false) return xmlNode;

	}
	
	this.Move = function(pnode, xmlNode, beforeNode){
		//Use Action Tracker
		var exec = this.executeAction("moveNode", [pnode, xmlNode, beforeNode], "Move", xmlNode);
		if(exec !== false) return xmlNode;

	}
	
	/***********************
		JML Integration
	***********************/
	/*
		<Actions>
			<Move select="" rpc="" arguments="" />
			<Copy select="" rpc="" arguments="" />
		</Actions>
		<dragdrop allowed="allow.cur" denied="deny.cur">
			<allow-drag select="Person" copy-condition="event.ctrlKey" />
			<allow-drop select="self::Person" target="Company|Office" action="list-append" copy-condition="event.ctrlKey" />
			<allow-drop select="self::Offer" target="Person" action="tree-append" copy-condition="event.ctrlKey" />
		</dragdrop>
	*/
	
	this.isDragAllowed = function(x){
		if(!this.dragdropRules || this.disabled) return false;
		var rules = this.dragdropRules["allow-drag"];
		if(!rules || !rules.length) return false;
		if(!x) return false;
		
		for(var i=0;i<rules.length;i++){
			if(x.selectSingleNode(rules[i].getAttribute("select-eval") ? eval(rules[i].getAttribute("select-eval")) : rules[i].getAttribute("select"))) return rules[i];//"self::" + 
		}
		
		return false;
	}
	
	this.isDropAllowed = function(x, target){
		if(!this.dragdropRules || this.disabled) return false;
		var rules = this.dragdropRules["allow-drop"];
		if(!rules || !rules.length) return false;
		if(!target) return false;//throw new Error(0, "What now?");
		
		for(var i=0;i<rules.length;i++){
			var data = x.selectSingleNode(rules[i].getAttribute("select-eval") ? eval(rules[i].getAttribute("select-eval")) : rules[i].getAttribute("select"));//"self::" + 
			
			if(!rules[i].getAttribute("target")) var tgt = target == this.XMLRoot ? target : null;
			else var tgt = target.selectSingleNode(rules[i].getAttribute("target"));//"self::" + 
			
			if(data && tgt && !XMLDatabase.isChildOf(data, tgt, true))
				return [tgt, rules[i]];
		}
		
		return false;
	}
	
	this.__dragDrop = function(xmlReceiver, xmlNode, rule, defaction, isParent, srcRule, event){
		if(action == "tree-append" && isParent) return false;
		
		/*
			Possibilities:
			
			tree-append [default]: xmlNode.appendChild(movedNode);
			list-append          : xmlNode.parentNode.appendChild(movedNode);
			insert-before        : xmlNode.parentNode.insertBefore(movedNode, xmlNode);
		*/
		var action = rule.getAttribute("operation") || defaction;
		var ifcopy = rule.getAttribute("copy-condition") ? eval(rule.getAttribute("copy-condition")) : false;
		if(!ifcopy) ifcopy = srcRule.getAttribute("copy-condition") ? eval(srcRule.getAttribute("copy-condition")) : false;
		var actRule = ifcopy ? 'Copy' : 'Move';

		switch(action){
			case "list-append":
				var sNode = this[actRule](isParent ? xmlReceiver : xmlReceiver.parentNode, xmlNode);
			break;
			case "insert-before":
				var sNode = isParent ? 
					this[actRule](xmlReceiver, xmlNode) :
					this[actRule](xmlReceiver.parentNode, xmlNode, xmlReceiver); 
			break;
			case "tree-append":
				var sNode = this[actRule](xmlReceiver, xmlNode);
			break;
		}

		if(this.selectable && sNode) this.select(sNode);
		
		return sNode;
	}
	
	/***********************
			Init
	***********************/

	var drag_inited;
	this.loadDragDrop = function(rules){
		setStatus("Initializing Drag&Drop for " + this.tagName + "[" + (this.name || '') + "]");
		
		if(rules){
			if(this.dragdropRules) this.unloadDragDrop();

			//Set Properties
			this.dragdropRules = rules;
		}

		//Set cursors
		//SHOULD come from skin
		this.icoAllowed = "";//this.xmlDragDrop.getAttribute("allowed");
		this.icoDenied = "";//this.xmlDragDrop.getAttribute("denied");

		//Setup External Object
		this.oExt.dragdrop = false;

		this.oExt.onmousedown = function(e){
			if(!e) e = event;
			var fEl, srcEl = e.originalTarget || e.srcElement;
			if(this.host.hasFeature(__MULTISELECT__) && srcEl == this.host.oInt) return;
			this.host.dragging = 0;
			
			var srcElement = IS_IE ? e.srcElement : e.target;
			if(this.host.allowDeselect && (srcElement == this || srcElement.getAttribute(XMLDatabase.htmlIdTag)))
				return this.host.clearSelection(); //hacky
			
			//MultiSelect must have carret behaviour AND deselect at clicking white
			//for(prop in e) if(prop.match(/x/i)) str += prop + "\n";
			//alert(str);
			if(this.host.findValueNode) fEl = this.host.findValueNode(srcEl);
			var el = (fEl ? XMLDatabase.getNode(fEl) : XMLDatabase.findXMLNode(srcEl));
			if(this.selectable && (!this.host.value || el == this.host.XMLRoot) || !el) return;

			if(this.host.isDragAllowed(this.selectable ? this.host.value : el)){
				this.host.dragging = 1;

				DragServer.coordinates = {
					srcElement : srcEl, 
					offsetX : e.layerX ? e.layerX - srcEl.offsetLeft : e.offsetX, 
					offsetY : e.layerY ? e.layerY - srcEl.offsetTop : e.offsetY,
					clientX : e.clientX,
					clientY : e.clientY
				};
				
				DragServer.start(this.host);
			}
			
			//e.cancelBubble = true;
		}

		this.oExt.onmousemove = function(e){
			if(!e) e = event;
			if(this.host.dragging != 1) return;//e.button != 1 || 
			//if(Math.abs(DragServer.coordinates.offsetX - (e.layerX ? e.layerX - DragServer.coordinates.srcElement.offsetLeft : e.offsetX)) < 6 && Math.abs(DragServer.coordinates.offsetY - (e.layerX ? e.layerY - DragServer.coordinates.srcElement.offsetTop : e.offsetY)) < 6)
				//return;

			//DragServer.start(this.host);
		}
		
		this.oExt.onmouseup = function(){
			this.host.dragging = 0;
		}
		
		this.oExt.ondragmove = 
		this.oExt.ondragstart = function(){return false}
		
		if(document.elementFromPointAdd)
			document.elementFromPointAdd(this.oExt);

		if(this.__initDragDrop && (!rules || !drag_inited)) this.__initDragDrop();
		drag_inited = true;
	}
	this.addEventListener("onskinchange", this.loadDragDrop);
	
	this.unloadDragDrop = function(){
		this.xmlDragDrop = null;
		this.dragdropRules = null;
		this.icoAllowed = null;
		this.icoDenied = null;
		this.oExt.dragdrop = null;
		this.oExt.onmousedown = null;
		this.oExt.onmousemove = null;
		this.oExt.onmouseup = null;
		this.oExt.ondragmove = null;
		this.oExt.ondragstart = null;
		
		if(document.elementFromPointRemove)
			document.elementFromPointRemove(this.oExt);
	}
}

DragServer = {
	Init : function(){
		Kernel.DragMode.defineMode("dragdrop", this);
	},
	
	/***********************
			API
	***********************/
	
	start : function(host){
		if(document.elementFromPointReset) document.elementFromPointReset();
		
		//Create Drag Object
		var selection = host.selectable ? host.getSelection()[0] : host.XMLRoot; //currently only a single item is supported
		
		var srcRule = host.isDragAllowed(selection);
		if(!srcRule) return;
		var data = selection.selectSingleNode(srcRule.getAttribute("select"));//"self::" + 
		
		if(host.hasEventListener("ondragdata"))
			data = host.dispatchEvent("ondragdata", data);

		this.dragdata = {
			selection : selection, 
			data : data,
			indicator : host.__showDragIndicator(selection, this.coordinates),
			host : host
		};

		//EVENT - cancellable: ondragstart
		if(host.dispatchEvent("ondragstart", this.dragdata) === false) return false;//(this.host.tempsel ? select(this.host.tempsel) : false);
		host.dragging = 2;

		Kernel.DragMode.setMode("dragdrop");
	},
	
	stop : function(runEvent){
		if(this.last) this.dragout();
		
		//Reset Objects
		this.dragdata.host.dragging = 0;
		this.dragdata.host.__hideDragIndicator();
		
		//????EVENT: ondragstop
		//if(runEvent && this.dragdata.host.ondragstop) this.dragdata.host.ondragstop();
		
		Kernel.DragMode.clear();
		this.dragdata = null;
	},
	
	m_out : function(){this.style.cursor="default";if(this.__onmouseout) this.__onmouseout();this.onmouseout=this.__onmouseout || null;},
	
	dragover : function(o, el, e){
		if(!e) e = event;
		var fEl;
		if(o.findValueNode) fEl = o.findValueNode(el);
		//if(!fEl) return;
	
		//Check Permission
		var elSel = (fEl ? XMLDatabase.getNode(fEl) : XMLDatabase.findXMLNode(el));
		var candrop = o.isDropAllowed ? o.isDropAllowed(this.dragdata.selection, elSel) : false; 
		//EVENT - cancellable: ondragover
		if(o.dispatchEvent("ondragover") === false) candrop = false;
		
		//Set Cursor
		var srcEl = e.originalTarget || e.srcElement;
		srcEl.style.cursor = (candrop ? o.icoAllowed : o.icoDenied);
		if(srcEl.onmouseout != this.m_out){
			srcEl.__onmouseout = srcEl.onmouseout;
			srcEl.onmouseout = this.m_out;
		}
		//o.oExt.style.cursor = (candrop ? o.icoAllowed : o.icoDenied);
		
		//REQUIRED INTERFACE: __dragover()
		if(o && o.__dragover) o.__dragover(el, this.dragdata, candrop);
		
		this.last = o;
	},
	
	dragout : function(o){
		if(this.last == o) return false;
		
		//EVENT: ondragout
		if(o) o.dispatchEvent("ondragout");
		
		//REQUIRED INTERFACE: __dragout()
		if(this.last && this.last.__dragout) this.last.__dragout(null, this.dragdata);
		
		//Reset Cursor
		//o.oExt.style.cursor = "default";
		
		this.last = null;
	},
	
	dragdrop : function(o, el, srcO, e){
		//Check Permission
		var elSel = (o.findValueNode ? XMLDatabase.getNode(o.findValueNode(el)) : XMLDatabase.findXMLNode(el));
		var candrop = elSel && o.isDropAllowed ? o.isDropAllowed(this.dragdata.data, elSel) : false; 

		//EVENT - cancellable: ondragdrop
		if(candrop){
			if(o.dispatchEvent("ondragdrop", this.dragdata, candrop) === false) candrop = false;
			else{
				var action = candrop[1].getAttribute("operation") || "list-append";
				if(action == "list-append" && o == this.dragdata.host) candrop = false;
			}
		}

		//Exit if not allowed
		if(!candrop){
			this.dragout(o);
			return false;
		}
		
		//Move XML
		var rNode = o.__dragDrop(candrop[0], this.dragdata.data, candrop[1], action, candrop[0] == o.XMLRoot, srcO.isDragAllowed(this.dragdata.selection), e);
		this.dragdata.resultNode = rNode;
		
		//REQUIRED INTERFACE: __dragdrop()
		if(o && o.__dragdrop) o.__dragdrop(el, this.dragdata, candrop);
		
		//Reset Cursor
		//o.oExt.style.cursor = "default";
		this.last = null;
	},
	
	/***********************
		Mouse Movements
	***********************/
	
	onmousemove : function(e){
		if(!DragServer.dragdata) return;
		if(!e) e = event;
		var dragdata = DragServer.dragdata;
		
		if(Math.abs(DragServer.coordinates.clientX - e.clientX) < 6 && Math.abs(DragServer.coordinates.clientY - e.clientY) < 6) 
			return;
		
		if(!dragdata.started){
			if(dragdata.host.__dragstart) dragdata.host.__dragstart(null, dragdata);
			dragdata.started = true;
		}
			
		//get Element at x, y
		dragdata.indicator.style.display = "block";
		if(dragdata.indicator) dragdata.indicator.style.top = "10000px";

		DragServer.dragdata.x = e.clientX+document.documentElement.scrollLeft;
		DragServer.dragdata.y = e.clientY+document.documentElement.scrollTop;
		var el = document.elementFromPoint(DragServer.dragdata.x, DragServer.dragdata.y);
		
		//Set Indicator
		dragdata.host.__moveDragIndicator(e);

		//get Node and call events
		var receiver = Kernel.findHost(el);
		
		//Run Events
		DragServer.dragout(receiver);
		if(receiver)
			DragServer.dragover(receiver, el, e);
		
		DragServer.lastTime = new Date().getTime();
	},
	
	onmouseup : function(e){
		if(!e) e = event;
		
		//get Element at x, y
		var indicator = DragServer.dragdata.indicator;
		if(indicator) indicator.style.top = "10000px";
		
		DragServer.dragdata.x = e.clientX+document.documentElement.scrollLeft;
		DragServer.dragdata.y = e.clientY+document.documentElement.scrollTop;
		var el = document.elementFromPoint(DragServer.dragdata.x, DragServer.dragdata.y);
		
		//get Node and call events
		var host = Kernel.findHost(el);
		
		//Run Events
		if(host != DragServer.host) DragServer.dragout(host);
		DragServer.dragdrop(host, el, DragServer.dragdata.host, e);
		DragServer.stop(true)
		
		//Clear Selection
		if(Kernel.isNS){
			var selObj = window.getSelection();
			if(selObj) selObj.collapseToEnd();
		}
	}
}

Init.addConditional(function(){DragServer.Init();}, null, 'Kernel');


/*FILEHEAD(/in/Core/Node/EditMode.js)SIZE(9711)TIME(1181930247549)*/
__EDITMODE__ = 1<<15;
__MULTILANG__ = 1<<16;


KeywordServer = {
	automatch : false,
	prefix : "sub.main.",
	words : {},
	texts : {},
	elements : {},
	count : 0,
	
	setWordListXml : function(xmlNode, prefix){
		if(typeof xmlNode == "string") xmlNode = Kernel.getObject("XMLDOM", xmlNode).documentElement;
		this.parseSection(xmlNode, prefix);
	},
	
	parseSection : function(xmlNode, prefix){
		if(!prefix) prefix = "";
		
		if(xmlNode.tagName == "key"){
			prefix += "." + xmlNode.getAttribute("id");
			this.updateWordList(prefix, xmlNode.firstChild ? xmlNode.firstChild.nodeValue : "");
			return;
		}
		
		//if(xmlNode.tagName == "lang") prefix = xmlNode.getAttribute("id");
		if(xmlNode.tagName == "group") prefix += (prefix ? "." : "") + xmlNode.getAttribute("id");
		
		var nodes = xmlNode.childNodes;
		for(var i=0;i<nodes.length;i++) this.parseSection(nodes[i], prefix);
	},
	
	updateWordList : function(key, value){
		this.words[key] = value;
		if(!this.elements[key]) return;
		
		for(var i=0;i<this.elements[key].length;i++){
			if(this.elements[key][i].htmlNode.nodeType == 1)
				this.elements[key][i].htmlNode.innerHTML = value;
			else 
				this.elements[key][i].htmlNode.nodeValue = value;
		}
	},
	
	
	addElement : function(key, oEl){
		if(!this.elements[key]) this.elements[key] = [];
		return this.elements[key].push(oEl) -1;
	},
	
	removeElement : function(key, id){
		this.elements[key].removeIndex(id);
	},
	
	getWord : function(key){
		return this.words[key];
	}
}




function MultiLang(){
	this.__regbase = this.__regbase|__MULTILANG__;
	
	var reggedItems = [];
	this.__makeEditable = function(type, htmlNode, jmlNode){
		if(jmlNode.prefix != "j") return;//using a non-xml format is unsupported
		
		var config = this.editableParts[type];
		for(var i=0;i<config.length;i++){
			var subNode = this.__getLayoutNode(type, config[i][0], htmlNode);
			if(!subNode) continue;
			
			var xmlNode = config ? XMLDatabase.selectSingleNode(config[i][1], jmlNode) : XMLDatabase.getTextNode(jmlNode);
			if(!xmlNode) xmlNode = XMLDatabase.createNodeFromXpath(jmlNode, config[i][1]);
			var key = xmlNode.nodeValue.match(/^\$(.*)\$$/); // is this not conflicting?
			
			if(key){
				subNode = subNode.nodeType == 1 ? subNode : (subNode.nodeType == 3 || subNode.nodeType == 4 ? subNode.parentNode : subNode); //subNode.ownerElement || subNode.selectSinglesubNode("..")
				reggedItems.push([key[1], KeywordServer.addElement(key[1], {htmlNode : subNode})]);
			}
		}
	}
	
	this.__removeEditable = function(){
		for(var i=0;i<reggedItems.length;i++){
			KeywordServer.removeElement(reggedItems[i][0], reggedItems[i][1]);
		}
		
		reggedItems = null;
	}
}

//setTimeout('alert("Switch");KeywordServer.setWordListXml("<group id=\'main\'><key id=\'0\'>aaaaaaa</key></group>", "sub");', 1000);


/*FILEHEAD(/in/Core/Node/FormElement.js)SIZE(12311)TIME(1185218551171)*/
__VALIDATION__ = 1<<6;


function Validation(){
	this.isActive = true;
	this.__regbase = this.__regbase|__VALIDATION__;
	
	//These should be moved to inside the form
	this.isValid = function(checkRequired){
		if(checkRequired && this.required){
			var value = this.getValue();
			if(!value || value.toString().length == 0) return false;
		}
		
		//for(var i=0;i<vRules.length;i++) if(!eval(vRules[i])) return false;
		if(this.vRules.length) return eval("(" + this.vRules.join(") && (") + ")");
		return true;
	}
	
	this.showMe = function(){
		var p = this.parentNode;
		while(p){
			p.show();
			p = p.parentNode;
		}
	}
	
	this.validate = function(force){
		if(!this.form && !this.validgroup) return;
		if(!this.errBox && this.form) this.errBox = this.form.getErrorBox(this.name);

		var hasError = false;
		if(!this.isValid() || force){
			this.setError();
			if(this.errBox){
				if(!(this.form || this.validgroup).allowMultipleErrors)
					(this.form || this.validgroup).hideAllErrors();
				
				this.errBox.setMessage(this.invalidmsg);
				this.showMe();
				if(this.validgroup){
					this.oExt.parentNode.insertBefore(this.errBox.oExt, this.oExt.nextSibling);
					//this.errBox.oExt.style.marginLeft = (-1 * (this.oExt.offsetWidth-10)) + "px"; //HACK sdu
					this.errBox.oExt.style.width = "230px";
					this.errBox.oExt.style.height = "44px";
					
					if(Kernel.getStyle(this.oExt, "position") == "absolute"){
						this.errBox.oExt.style.left = this.oExt.offsetLeft + "px";
						this.errBox.oExt.style.top = this.oExt.offsetTop + "px";
					}
					this.errBox.host = this;
				}
				this.errBox.show();
			}
			hasError = true;
		}
		else{
			this.clearError();
			if(this.errBox && this.errBox.host == this) this.errBox.hide();
		}
		
		//Drawing Bug fix (ughhh) hack!
		if(IS_GECKO && this.errBox){
			if(this.errBox.pHtmlNode.style.height == "100%")
				this.errBox.pHtmlNode.style.height = "";
			else
				this.errBox.pHtmlNode.style.height = "100%";
		}
		
		return !hasError;
	}
	
	this.setError = function(value){
		if(this.__setStyleClass)
			this.__setStyleClass(this.oExt, this.baseCSSname + "Error");
	}
	
	this.clearError = function(value){
		if(this.__setStyleClass)
			this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Error"]);
	}
	
	this.setActive = function(){
		this.isActive = true;
		if(this.nodeType == GUI_NODE) this.show();
		if(this.labelEl) this.labelEl.show();
		this.dispatchEvent("onactivate");
	}
	
	this.setInactive = function(noChange){
		this.isActive = false;
		if(this.nodeType == GUI_NODE) this.hide();
		if(this.clearSelection) this.clearSelection(null, true);
		if(this.labelEl) this.labelEl.hide();
		if(this.errBox) this.errBox.hide();
		
		if(!noChange){
			/*
			if(this.hasFeature(__MULTISELECT__))
				this.clearSelection();
			else this.Change("");
			*/
			if(this.hasFeature(__MULTISELECT__))
				XMLDatabase.clearBoundValue(this.getSelectionBindClass(), null, true);
			else 
				XMLDatabase.clearBoundValue(this, null, true);
		}
		
		if(this.tagName == "Radiogroup" && this.current)
			this.current.uncheck();

		this.dispatchEvent("ondeactivate");
	}

	function onafterchange(){
		if(!this.form) return;
		
		this.form.processValueChange(this);

		if(this.form.depends[this.name]){
			var dep = this.form.depends[this.name];
			var action = this.getValue() == 1 ? "setActive" : "setInactive";
			for(var i=0;i<dep.length;i++){
				dep[i][action]();
				if(action == "setActive") dep[i].focus();
			}
		}
		
		// Next Question Support
		if(this.form.nQuest && (this.nextEl || this.prevEl) && this.isValid(true)){
			var xmlCommNode = this.form.nQuest;
			if(!Kernel.TelePort.hasLoadRule(xmlCommNode)) return;
			
			this.form.showLoader();
			setTimeout("Kernel.lookup(" + this.uniqueId + ").loadNextQuestion();", 10);
		}
	}
	
	this.loadNextQuestion = function(){
		var xmlCommNode = this.form.nQuest;
		
		//Process basedon arguments
		var arr, arg = xmlCommNode.getAttribute(Kernel.TelePort.lastRuleFound.args);
		arg = arg ? arg.split(";") : [];
		
		var struct = this.getAllPreviousStruct();
		this.deActivateAllNext();
		
		arg[xmlCommNode.getAttribute("arg-array")] = struct;
		Kernel.TelePort.callMethodFromNode(xmlCommNode, this.XMLRoot, Function('data', 'state', 'extra', 'var o = Kernel.lookup(' + this.form.uniqueId + ');o.loadNextElement(data, state, extra, this)'), null, null, arg);
	}
	
	this.getAllPreviousStruct = function(){
		this.setActive(); //there is prolly a good reason why this is here.. it shouldn't
		
		//Get struct of all elements before this one
		var struct = {}, lastObj, tObj = this;
		do{
			if(tObj.isActive && tObj.isValid(true)) 
				struct[tObj.name] = tObj.getValue();

			lastObj = tObj;
			tObj = tObj.prevEl;
		}while(tObj);
		
		var frm = this.form;
		XMLDatabase.getAllNodesBefore(this.form.jml, ".//node()[@checknext='true']", lastObj.jml, function(node){
			if(node.getAttribute("id") && node.getAttribute("bind")){
				var xmlNode = frm.XMLRoot.selectSingleNode(node.getAttribute("bind"));
				if(xmlNode)
					struct[node.getAttribute("id")] = XMLDatabase.getNodeValue(xmlNode);
			}
		});
		
		return struct;
	}
	
	this.deActivateAllNext = function(){
		//Deactivate all following elements
		var tObj = this;
		while(tObj && tObj.nextEl){
			tObj = tObj.nextEl;
			// && tObj.jml.getAttribute("show") != "true"
			if(tObj.isActive){
				tObj.setInactive(); //THIS CAN BE OPTIMIZED BY DOING XMLDB UPDATE ONLY ONCE (solve by doing a purge on xmldb after restricting it)
			}
		}
		
		var frm = this.form;
		XMLDatabase.getAllNodesAfter(this.form.jml, ".//node()[@checknext='true']", tObj.jml, function(node){
			if(node.getAttribute("bind")){
				var xmlNode = frm.XMLRoot.selectSingleNode(node.getAttribute("bind"));
				if(xmlNode) XMLDatabase.setNodeValue(xmlNode, "");
			}
		});
		
		if(this.form.nQuest){
			var el = this.form.nQuest.getAttribute("final");
			if(self[el]) self[el].setInactive();
			else{
				var jmlNode = XMLDatabase.selectSingleNode(".//node()[@id='" + el + "']", this.form.jml);
				XMLDatabase.clearBoundValue(jmlNode, this.form.XMLRoot);
			}
			
			var xmlNode = this.form.xmlActions.selectSingleNode("LoadValue[@element='" + el + "']");
			if(xmlNode) 
				this.form.dispatchEvent("onclearloadvalue", xmlNode); //hmm i'm guessing there is an abstraction error... no event should be called outside it's class.. reconsider this entire structure
		}
		
		XMLDatabase.applyChanges("synchronize", this.form.XMLRoot);
	}
	
	this.__addJmlDestroyer(function(){
		if(this.validgroup) this.validgroup.remove(this);
	});
	
	this.__addJmlLoader(function(x){
		this.addEventListener(this.hasFeature(__MULTISELECT__) ? "onafterselect" : "onafterchange", onafterchange);
		this.addEventListener("onbeforechange", function(){
			if(XMLDatabase.getBoundValue(this) === this.getValue()) return false;
		});

		// Submitform
		if(!this.form){
			//Set Form
			var y = this.jml;
			do{
				y = y.parentNode;
			}while(y && y.tagName && !y.tagName.match(/Submitform$/) && y.parentNode && y.parentNode.nodeType != 9);
			
			if(y && y.tagName && y.tagName.match(/Submitform$/)){
				if(!y.tagName.match(/Submitform$/)) throw new Error(1070, Kernel.formErrorString(1070, this, this.tagName, "Could not find Form element whilst trying to bind to it's Data."));
				if(!y.getAttribute("id")) throw new Error(1071, Kernel.formErrorString(1071, this, this.tagName, "Found Form element but the id attribute is empty or missing."));
				
				this.form = eval(y.getAttribute("id"));
				this.form.addInput(this);
			}
		}
		
		if(!this.form){
			var vgroup = x.getAttribute("validgroup") || XMLDatabase.getInheritedAttribute(x, "validgroup");
			if(vgroup){
				this.validgroup = self[vgroup] || Kernel.setReference(vgroup, new ValidationGroup());
				this.validgroup.add(this);
			}
		}

		if(this.form || this.validgroup){
			this.addEventListener("onblur", function(){this.validate();})
			
			this.vRules = [];
			this.addValidationRule = function(rule){
				this.vRules.push(rule);
			}

			if(x.getAttribute("required") == "true"){
				if(this.form) this.form.addRequired(this);
				this.required = true;
			}

			if(x.getAttribute("validation")){
				var vRule;
				var validation = x.getAttribute("validation");
				
				if(KNOWN[validation]){
					if(typeof KNOWN[validation] == "string") vRule = KNOWN[validation];
					else this.reValidation = KNOWN[validation];
				}
				else if(validation.match(/^\/.*\/(?:[gim]+)?$/)) this.reValidation = eval(validation);
				if(this.reValidation) vRule = "this.getValue().match(this.reValidation)";
				
				if(!vRule) vRule = "(" + validation + ")";
				this.addValidationRule("!this.getValue() || " + vRule);
			}
			if(x.getAttribute("min-value"))
				this.addValidationRule("parseInt(this.getValue()) >= " + x.getAttribute("min-value"));
			if(x.getAttribute("max-value"))
				this.addValidationRule("parseInt(this.getValue()) <= " + x.getAttribute("max-value"));
			if(x.getAttribute("max-length"))
				this.addValidationRule("this.getValue().toString().length <= " + x.getAttribute("max-length"));
			if(x.getAttribute("min-length"))
				this.addValidationRule("this.getValue().toString().length >= " + x.getAttribute("min-length"));
			if(x.getAttribute("notnull") == "true")
				this.addValidationRule("this.getValue() && this.getValue().toString().length > 0");
			//if(x.getAttribute("required") == "true")
				//this.addValidationRule("new String(this.getValue()).length != 0");
			if(x.getAttribute("check-equal"))
				this.addValidationRule(x.getAttribute("check-equal") + ".getValue() == this.getValue()");
				
			this.invalidmsg = x.getAttribute("invalidmsg");
			if(this.invalidmsg){
				if(this.validgroup) this.errBox = this.validgroup.getErrorBox(this);
				else{
					var o = new Errorbox();
					o.pHtmlNode = this.oExt.parentNode;
					o.loadJML(x);
					this.errBox = o;
				}
				if(this.form) this.form.registerErrorBox(this.name, o); //stupid name requirement
			}
		}
	});	
}

function ValidationGroup(){
	Kernel.makeClass(this);
	
	this.validateVisibleOnly = false;
	this.allowMultipleErrors = false;
	
	this.childNodes = [];
	this.add = function(o){this.childNodes.push(o);}
	this.remove = function(o){this.childNodes.remove(o);}
	
	this.toString = function(){
		return "[Javeline Validation Group]";
	}
	
	var errbox;
	this.getErrorBox = function(o){
		if(!errbox){
			errbox = new Errorbox();
			errbox.pHtmlNode = o.oExt.parentNode;
			var cNode = o.jml.ownerDocument.createElement("Errorbox");
			errbox.loadJML(cNode);
		}
		return errbox;
	}
	
	this.hideAllErrors = function(){
		for(var i=0;i<this.childNodes.length;i++){
			if(this.childNodes[i].errBox)
				this.childNodes[i].errBox.hide();
		}
	}
	
	this.getJsonObject = function(){
		var data = {};
		
		for(var i=0;i<this.childNodes;i++){
			var name = this.childNodes[i].jml.getAttribute("name") || this.childNodes[i].name;
			if(name) data[name] = this.childNodes[i].getValue();
		}
		
		return data;
	}
	
	function checkValidChildren(oParent, ignoreReq, nosetError){
		var found;
		
		//Per Element
		for(var i=0;i<oParent.childNodes.length;i++){
			var oEl = oParent.childNodes[i];

			if(!oEl) continue;
			//if(oEl.oContainer) oEl = oEl.oContainer; //hack for radiobuttons
			if(
				!oEl.disabled && 
				(!this.validateVisibleOnly && oEl.visible || !oEl.oExt || oEl.oExt.offsetHeight) && 
				(
					oEl.hasFeature(__VALIDATION__) && oEl.isValid && !oEl.isValid() ||
					!ignoreReq && oEl.required && new String(oEl.getValue()).length == 0
				)
			){
				if(!nosetError){
					if(!found){
						oEl.validate(true);
						found = true;
					}
					else if(oEl.errBox && oEl.errBox.host == oEl) oEl.errBox.hide();
				}
				else return true;
			}
			if(oEl.childNodes.length) found = checkValidChildren(oEl, !ignoreReq, nosetError) || found;
		}
		
		return found;
	}
	
	this.isValid = function(ignoreReq, nosetError){
		var found = checkValidChildren(this, ignoreReq, nosetError);
		
		//Global Rules
		//
		if(!found) found = this.dispatchEvent("onvalidation");
		
		return !found;
	}
}


/*FILEHEAD(/in/Core/Node/JmlDom.js)SIZE(2983)TIME(1181922744090)*/
__JMLDOM__ = 1<<14;

function JmlDomAPI(){
	this.__regbase = this.__regbase|__JMLDOM__;
	this.childNodes = [];
	
	this.appendChild = function(jmlNode, noAlignUpdate){
		jmlNode.removeNode(true);
		
		if(jmlNode.hasFeature(__ALIGNMENT__)){
			var isDisabled = jmlNode.disableAlignment();
			if(isDisabled && !noAlignUpdate) jmlNode.purgeAlignment();
		}
		
		if(jmlNode.hasFeature(__ANCHORING__)) jmlNode.moveAnchoringRules(this.oInt, !noAlignUpdate);
		
		this.childNodes.push(jmlNode);
		jmlNode.parentNode = this;
		
		if(!this.oInt) return;
		this.oInt.appendChild(jmlNode.oExt);
		jmlNode.pHtmlNode = this.oInt;
		
		if(jmlNode.hasFeature(__ALIGNMENT__) && isDisabled){
			jmlNode.enableAlignment();
			if(!noAlignUpdate) jmlNode.purgeAlignment();
		}
	}
	
	this.insertBefore = function(jmlNode, beforeNode, noAlignUpdate){
		jmlNode.removeNode(true);
		
		if(jmlNode.hasFeature(__ALIGNMENT__)){
			var isDisabled = jmlNode.disableAlignment();
			if(isDisabled && !noAlignUpdate) jmlNode.purgeAlignment();
		}
		
		var index = this.childNodes.indexOf(beforeNode);
		if(index < 0) throw new Error(1072, Kernel.formErrorString(1072, this, "Insert before DOM operation", "could not insert jmlNode, beforeNode could not be found"));
		
		if(jmlNode.hasFeature(__ANCHORING__)) this.moveAnchoringRules(this.oInt, !noAlignUpdate);
		
		this.childNodes = this.childNodes.slice(0, index).concat(jmlNode, this.childNodes.slice(index));
		jmlNode.parentNode = this;
		
		if(!this.oInt) return;
		this.oInt.insertBefore(jmlNode.oExt, beforeNode.oExt);
		jmlNode.pHtmlNode = this.oInt;
		
		if(jmlNode.hasFeature(__ALIGNMENT__) && isDisabled){
			jmlNode.enableAlignment();
			if(!noAlignUpdate) jmlNode.purgeAlignment();
		}
	}
	
	this.removeNode = function(isAdmin){
		if(!this.parentNode) return;
		
		this.parentNode.childNodes.remove(this);
		this.oExt.parentNode.removeChild(this.oExt);
		
		if(isAdmin) return;
		
		this.destroy();
		
		if(this.hasFeature(__ANCHORING__)) this.disableAnchoring(this.oInt);
	}
	
	this.getElementsByTagName = function(tagName, norecur){
		for(var result=[],i=0;i<this.childNodes.length;i++){
			if(this.childNodes[i].tagName == tagName) result.push(this.childNodes[i]);
			if(!norecur) result = result.concat(this.childNodes[i].getElementsByTagName(tagName));
		}
		return result;
	}
	
	//Clone itself same skin, data, bindings connections etc
	this.cloneNode = function(deep){}
	
	if(this.parentNode && this.parentNode.hasFeature && this.parentNode.hasFeature(__JMLNODE__)){
		//can be optimized by recording the ID here.. but i doubt there will be a lot of reparenting actions
		this.parentNode.childNodes.push(this);
	}
}
/*FILEHEAD(/in/Core/Node/MultiLevelBinding.js)SIZE(7944)TIME(1188383718500)*/
__MULTIBINDING__ = 1<<7;


/*
<BindClass>
	<Data connect="" select="" />
	<Bindings>
		<Value select="" />
	</Bindings>
	<Actions>
		<SelectAdd select="." />
		<SelectRemove select="." />
		<Change select="." />
	</Actions>
</BindClass>
*/

function MultiLevelBinding(jmlNode){
	this.uniqueId = Kernel.all.push(this) - 1;
	this.nodeType = NOGUI_NODE;
	this.tagName = "MultiBinding";
	this.name = jmlNode.name + "_multibinding";
	
	jmlNode.__regbase = jmlNode.__regbase|__MULTIBINDING__;
	
	Kernel.makeClass(this);
	this.inherit(DataBinding);
	this.findXmlNodeByValue = jmlNode.findXmlNodeByValue; // me no like code in >1 places
	
	this.getActionTracker = function(ignoreMe){
		return jmlNode.getActionTracker(ignoreMe);
	}
	
	this.getHost = function(){return jmlNode;}
	
	this.SelectAddGroup = 
	this.SelectAdd = function(value){
		var node = this.getNodeFromRule(this.mainBind, this.XMLValueRoot);
		if(value == undefined) var value = this.value ? this.applyRuleSetOnNode("Value", this.value) : "";
		if(!node){
			if(this.dispatchEvent('onbeforeselectadd', value) !== false) this.setValue(value, true);
			this.dispatchEvent('onafterselectadd', value);
			return;
		}

		var atAction = node.nodeType == 1 || node.nodeType == 3 || node.nodeType == 4 ? "setTextNode" : "setAttribute";
		var args = node.nodeType == 1 ? [node, value] : (node.nodeType == 3 || node.nodeType == 4 ? [node.parentNode, value] : [node.selectSingleNode(".."), node.nodeName, value]);

		//Use Action Tracker
		this.executeAction("appendChildNode", [pNode || this.XMLRoot, addXmlNode, beforeNode], "SelectAdd", addXmlNode);
	}
	
	this.SelectRemoveGroup = 
	this.SelectRemove = function(xmlNode){
		if(xmlNode.nodeType) return this.executeAction("removeNode", [xmlNode], "SelectRemove", xmlNode);
		else{
			var sel = xmlNode || this.getSelection();
			if(this.actionRules["SelectRemoveGroup"])
				return this.executeAction("removeNodeList", [sel], "SelectRemoveGroup", sel);
			else 
				for(var i=0;i<sel.length;i++){
					var result = this.executeAction("removeNode", [sel[i]], "SelectRemove", sel[i]);
					if(result === false) return false;
				}
		}
		
		return 1;
	}
	
	this.Change = function(value){
		var node = this.getNodeFromRule(this.mainBind, this.XMLRoot, null, null, true);
		if(value === undefined) value = this.value ? this.applyRuleSetOnNode("Value", this.value) : "";
		if(!node) return;

		var atAction = node.nodeType == 1 || node.nodeType == 3 || node.nodeType == 4 ? "setTextNode" : "setAttribute";
		var args = node.nodeType == 1 ? [node, value] : (node.nodeType == 3 || node.nodeType == 4 ? [node.parentNode, value] : [node.ownerElement || node.selectSingleNode(".."), node.nodeName, value]);

		//Use Action Tracker
		this.executeAction(atAction, args, "Change", this.XMLRoot);
	}

	if(jmlNode.hasFeature(__VALIDATION__)){
		this.addEventListener("onbeforechange", function(){jmlNode.dispatchEvent("onbeforechange")});
		this.addEventListener("onafterchange", function(){jmlNode.dispatchEvent("onafterchange")});
	}
	
	this.clear = function(nomsg, do_event){
		if(jmlNode.__showSelection) jmlNode.__showSelection("");
	}
	this.disable = function(){jmlNode.disable();this.disabled=true}
	this.enable = function(){jmlNode.enable();this.disabled=false}
	
	this.__xmlUpdate = function(action, xmlNode, listenNode, UndoObj){
		if(UndoObj) UndoObj.xmlNode = this.XMLRoot;
		this.__updateSelection();
		
		this.dispatchEvent("onxmlupdate", action, xmlNode, listenNode);
	}

	this.__load = function(XMLRoot){
		//if(jmlNode.name == "refSMArt_Situatie") debugger;
		//Add listener to XMLRoot Node
		XMLDatabase.addNodeListener(XMLRoot, this);
		this.__updateSelection();
	}
	
	this.__updateSelection = function(){
		if(jmlNode.multiselect){
			var nodes = jmlNode.getTraverseNodes();
			for(var selList=[],i=0;i<nodes.length;i++){
				if(nodes[i].getAttribute("j_selection")) throw new Error(1073, Kernel.formErrorString(1073, this, "load selection", "A selection bind on this node already exists."));
				nodes[i].setAttribute("j_selection", this.uniqueId);
				
				var xmlNode = jmlNode.findXmlNodeByValue(this.applyRuleSetOnNode(this.mainBind, nodes[i]));
				
				// Appearantly the node has dissapeared, maybe deleted or a new dataset is loaded in the control
				if(!xmlNode) XMLDatabase.removeNode(nodes[i]); // Remove node without ActionTracker, because selection cannot be made
				
				//Select node as one of many
				else selList.push(xmlNode);
			}
			
			jmlNode.selectList(selList);
		}
		else{
			if(!jmlNode.XMLRoot){
				//Selection is maintained and visualized, but no Nodes are selected
				if(jmlNode.__showSelection) jmlNode.__showSelection();
				return;
			}

			var xmlNode = jmlNode.findXmlNodeByValue(this.applyRuleSetOnNode(this.mainBind, this.XMLRoot));
			if(xmlNode){
				if(jmlNode.__showSelection) jmlNode.__showSelection();
				if(jmlNode.value != xmlNode){
					jmlNode.select(xmlNode, null, null, null, null, true);
					jmlNode.dispatchEvent("onupdateselect");
					jmlNode.setConnections(xmlNode);
				}
			}
			else if(jmlNode.clearOnNoSelection) jmlNode.clearSelection(null, true);
		}
	}

	var mlNode = this;
	jmlNode.addEventListener("onafterselect", function (list, xmlNode){
		if(!mlNode.XMLRoot) return;
		
		if(this.multiselect){
			var nodes = mlNode.getTraverseRule();
			for(var removeList=[],xmlNode, i=0;i<nodes.length;i++){
				xmlNode = this.findXmlNodeByValue(mlNode.applyRuleSetOnNode(mlNode.mainBind, nodes[i]));
				if(!list.contains(xmlNode)) removeList.push(xmlNode);
			}
			
			for(var addList=[],xmlNode, i=0;i<list.length;i++){
				xmlNode = mlNode.findXmlNodeByValue(this.applyRuleSetOnNode(this.mainBind, list[i]));
				if(!xmlNode) addList.push(xmlNode);
			}
			
			//Remove nodes using ActionTracker
			if(removeList.length) mlNode.SelectRemove(removeList);
			//Add nodes using ActionTracker
			if(addList.length) mlNode.SelectAdd(addList);
		}
		else{
			mlNode.Change(this.applyRuleSetOnNode(this.mainBind, xmlNode));
		}
	});
	
	//jmlNode.addEventListener("onxmlupdate", function(action, xmlNode){updateSelection.call(this, null, this.value)});
	jmlNode.addEventListener("onafterload", function(xmlNode){
		if(this.multiselect){
			
		}
		else{
			var xmlNode = this.findXmlNodeByValue(mlNode.applyRuleSetOnNode(mlNode.mainBind, mlNode.XMLRoot));
			if(xmlNode) jmlNode.select(xmlNode, null, null, null, null, true);
			else if(jmlNode.clearOnNoSelection){
				//This seems cumbersome... check abstraction
				var xmlNode = mlNode.getNodeFromRule(mlNode.mainBind, mlNode.XMLRoot, null, null, true);
				XMLDatabase.setNodeValue(xmlNode, "");
				if(this.__updateOtherBindings) this.__updateOtherBindings();
				if(this.__showSelection) this.__showSelection();
			}
		}
	});

	jmlNode.addEventListener("onafterdeselect", function(sel){
		if(!mlNode.XMLRoot) return;
		
		//Remove sel nodes
		if(this.multiselect){
			//Translate sel to a list of nodes in this xml space
			for(var removeList=[],xmlNode, value, i=0;i<sel.length;i++){
				xmlNode = mlNode.findXmlNodeByValue(this.applyRuleSetOnNode(this.mainBind, sel[i]));
				//Node to be unselected (removed) cannot be found. This should not happen.
				if(!xmlNode) continue;
				removeList.push(xmlNode);
			}
			
			//Remove node using ActionTracker
			if(removeList.length) mlNode.SelectRemove(removeList);
		}
		//Set value to ""
		else if(jmlNode.clearOnNoSelection){
			this.__updateOtherBindings();
			//mlNode.Change("");
			
			//This should be researched better....
			XMLDatabase.setNodeValue(XMLDatabase.createNodeFromXpath(mlNode.XMLRoot, mlNode.bindingRules[mlNode.mainBind][0].getAttribute("select")), "", true);
		}
	});
}


/*FILEHEAD(/in/Core/Node/MultiSelect.js)SIZE(19092)TIME(1188383718500)*/
__MULTISELECT__ = 1<<8;


function MultiSelect(){
	/***********************
		INTERFACE REQUIRED
		
		htmlNode = this.__select(htmlNode);
		htmlNode = this.__deselect(htmlNode);
		htmlNode = this.__indicate(htmlNode);
		range 	= this.__calcSelectRange(xmlStartNode, xmlEndNode);
	***********************/
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	this.value = null;
	this.selected = null;
	this.indicator = null;
	
	var selBindClass;
	var valueList = [];
	var selectedList = [];
	
	this.__regbase = this.__regbase|__MULTISELECT__;
	
	this.autoselect = true;
	this.selectable = true;
	this.multiselect = true;
	this.useindicator = true;
	
	/************************
				ACTIONS
	************************/
	
	this.RemoveGroup = 
	this.Remove = function(xmlNode, do_select){
		if(!xmlNode) xmlNode = valueList;
		if(!xmlNode) return;
		if(!xmlNode.nodeType){
			sel = xmlNode;
			xmlNode = sel[0];
		}
		var rValue;
		
		// Determine next selection
		if(do_select){
			var i=0, nextNode = xmlNode||this.value, ln = this.getSelectCount();
			do{nextNode = this.getDefaultNext(nextNode); i++
			}while(nextNode && this.isSelected(nextNode) && i < ln);
		}
		
		// Remove node(s)
		if(xmlNode && xmlNode.nodeType){
			// Determine next selection
			rValue = this.executeAction("removeNode", [xmlNode], "Remove", xmlNode);
		}
		else{
			if(this.actionRules && this.actionRules["RemoveGroup"])
				rValue = this.executeAction("removeNodeList", [sel], "RemoveGroup", sel);
			else{
				for(var i=0;i<sel.length;i++){
					var rValue = this.executeAction("removeNode", [sel[i]], "Remove", sel[i]);
					if(rValue === false) return false;
				}
			}
		}
		
		// do Selection
		if(do_select && rValue !== false){
			this.clearSelection();
			if(nextNode) this.select(nextNode);
		}
		
		return rValue;
	}
	
	this.Add = function(xmlNode, beforeNode, pNode){
		//XML from Argument
		if(!xmlNode){
			var addXmlNode, node = this.actionRules["Add"][0];
			if(!node) throw new Error(0, "Could not get Node for Action");
	
			//Hard Coded XML
			if(node.firstChild) 
				addXmlNode = node.firstChild.cloneNode(true);
			//Execute Client Side Response
			else if(node.getAttribute("method"))
				addXmlNode = self[node.getAttribute("method")]();
			else if(node.getAttribute("eval"))
				addXmlNode = eval(node.getAttribute("eval"));
		}
		else addXmlNode = xmlNode;
		
		if(typeof addXmlNode != "object") addXmlNode = Kernel.getObject("XMLDOM", addXmlNode).documentElement;
		if(addXmlNode.getAttribute(XMLDatabase.xmlIdTag)) addXmlNode.setAttribute(XMLDatabase.xmlIdTag, "");
		
		var actionNode = this.getNodeFromRule("Add", this.isTreeArch ? this.value : this.XMLRoot, true, true);
		if(!pNode && actionNode && actionNode.getAttribute("parent")) pNode = this.XMLRoot.selectSingleNode(actionNode.getAttribute("parent"));
		
		if(this.executeAction("appendChildNode", [pNode || this.XMLRoot, addXmlNode, beforeNode], "Add", addXmlNode) !== false)
			this.select(addXmlNode);
		
		return addXmlNode;
	}
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	if(!this.setValue){
		this.setValue = function(value, no_event){
			if(!this.bindingRules) return;
			
			if(!this.bindingRules[this.mainBind]) throw new Error(1074, Kernel.formErrorString(1074, this, "setValue Method", "Could not find default value bind rule for this control."))
			
			if(isNot(value)) return this.clearSelection(null, no_event);
			
			var xmlNode = this.findXmlNodeByValue(value);
			if(xmlNode) this.select(xmlNode, null, null, null, null, no_event);
			else return this.clearSelection(null, no_event);
		}
	}
 	
	this.findXmlNodeByValue = function(value){
		var nodes = this.getTraverseNodes();
		for(var i=0;i<nodes.length;i++){
			if(this.applyRuleSetOnNode(this.mainBind, nodes[i]) === value){
				return nodes[i];
			}
		}
	}
	
	if(!this.getValue){
		this.getValue = function(){
			if(!this.bindingRules) return false;
			
			if(!this.bindingRules[this.mainBind]) throw new Error(1074, Kernel.formErrorString(1074, this, "getValue Method", "Could not find default value bind rule for this control."))
			
			if(!this.multiselect && !this.XMLRoot && selBindClass && selBindClass.XMLRoot) 
				return selBindClass.applyRuleSetOnNode(selBindClass.mainBind, selBindClass.XMLRoot, null, true);
			
			return this.applyRuleSetOnNode(this.mainBind, this.value, null, true);
		}
	}
	
	this.setSelectionBindClass = function(bindclass, part){
		if(!selBindClass) selBindClass = new MultiLevelBinding(this);
		selBindClass.setBindClass(bindclass, part);
		
		this.dispatchEvent("oninitselbind", selBindClass);
	}
	
	this.getSelectionBindClass = function(){
		return selBindClass;
	}
	
	
	this.reselect = function(){
		if(this.value) this.select(this.value, null, null, null, true);//no support for multiselect currently.
	}
	
	var buffered = null;
	/********* SELECT ***********
		Selects Node(-Range) by reference or ID and based on keyboard control
	
		INTERFACE:
		this.select(htmlNode, ctrlKey, shiftKey);
		this.select(xmlNode, ctrlKey, shiftKey);
		this.select(xmlID, ctrlKey, shiftKey);
	****************************/
	this.select = function(xmlNode, ctrlKey, shiftKey, fakeselect, force, no_event){
		if(!this.selectable || this.disabled) return;
		
		if(this.ctrlSelect && !shiftKey) ctrlKey = true;
		
		// Selection buffering (for async compatibility)
		if(!this.XMLRoot){
			buffered = [arguments, this.autoselect];
			this.autoselect = true;
			return;
		}
		
		if(buffered){
			var x = buffered;
			buffered = null;
			if(this.autoselect) this.autoselect = x[1];
			return this.select.apply(this, x[0]);
		}
		
		var htmlNode;

		/***** Type Detection *****/
		//if(!this.XMLRoot) throw new Error(0, Kernel.formErrorString(0, this, "select Method", "Cannot select on empty dataset.")); //warning?
		if(!xmlNode) throw new Error(1075, Kernel.formErrorString(1075, this, "select Method", "Missing xmlNode reference"))

		if(typeof xmlNode != "object"){
			var str = xmlNode;
			xmlNode = XMLDatabase.getNodeById(xmlNode);
			
			//Select based on the value of the xml node
			if(!xmlNode){
				var sel = str.split("\|");
				var rule = (this.getBindRule("Value") || this.getBindRule("Caption"));
				if(!rule) throw new Error(0, Kernel.formErrorString(0, this, "select Method", "Could not find rule to select by string with"))
				rule = rule.getAttribute("select");
				
				for(var i=0;i<(this.multiselect ? 1 : sel.length);i++){
					sel[i] = "node()[" + rule + "='" + sel[i].replace(/'/g, "\\'") + "']";
				}
				var xpath = sel.join("\|");
				
				var nodes = this.XMLRoot.selectNodes(xpath);
				for(var i=0;i<nodes.length;i++) this.select(nodes[i]);
				return;
			}
		}
		if(!xmlNode.style) htmlNode = this.caching ? this.getNodeFromCache(xmlNode.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId) : document.getElementById(xmlNode.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId); //IE55
		else{
			var id = (htmlNode = xmlNode).getAttribute(XMLDatabase.htmlIdTag);
			while(!id && htmlNode.parentNode)
				var id = (htmlNode = htmlNode.parentNode).getAttribute(XMLDatabase.htmlIdTag);
			
			xmlNode = XMLDatabase.getNodeById(id, this.XMLRoot);
		}

		if(!no_event && this.dispatchEvent('onbeforeselect', xmlNode, htmlNode) === false) return false;

		/***** Selection *****/
		var lastIndicator = this.indicator;
		this.indicator = xmlNode;

		//Multiselect with SHIFT Key.
		if(shiftKey && this.multiselect){
			var range = this.__calcSelectRange(valueList[0] || lastIndicator, xmlNode);

			this.selectList(range);
			if(this.selected) this.__deindicate(this.selected);
			this.selected = this.__indicate(htmlNode);
		}
		
		//Multiselect with CTRL Key.
		else if(ctrlKey && this.multiselect){
			
			//Node will be unselected
			if(valueList.contains(xmlNode)){
				if(!fakeselect){
					selectedList.remove(htmlNode);
					valueList.remove(xmlNode);
				}
				
				if(this.value == xmlNode){
					this.clearSelection(true, true);
					
					if(valueList.length && !fakeselect){
						//this.selected = selectedList[0];
						this.value = valueList[0];
					}
				}
				else this.__deselect(htmlNode, xmlNode);
				
				this.selected = this.__indicate(htmlNode);
				if(htmlNode != this.selindicator){
					this.__deindicate(this.selindicator);
					this.selindicator = htmlNode;
				}
			}
			
			//Node will be selected 
			else{
				if(this.selected) this.__deindicate(this.selected);
				this.__indicate(htmlNode);
				this.selindicator = htmlNode;
				
				this.selected = this.__select(htmlNode);
				this.value = xmlNode;
			
				if(!fakeselect){
					selectedList.push(htmlNode);
					valueList.push(xmlNode);
				}
			}
		}
		
		//Return if selected Node is htmlNode during a fake select
		else if(htmlNode && selectedList.contains(htmlNode) && fakeselect) return;
		
		//Normal Selection
		else{
			if(!force && htmlNode && this.selected == htmlNode && valueList.length <= 1 && !this.reselectable && selectedList.contains(htmlNode)) return;
			if(this.value) this.clearSelection(null, true);

			this.selected = this.__indicate(htmlNode, xmlNode);
			this.selected = this.__select(htmlNode, xmlNode);
			this.value = xmlNode;
			
			selectedList.push(htmlNode);
			valueList.push(xmlNode);
		}

		// Does this destroy something?
		//if(!no_event) 
		var jNode = this;
		if(!no_event) setTimeout(function(){
			jNode.dispatchEvent("onafterselect", valueList, xmlNode);
		}, 10);
		//if(!no_event) this.dispatchEvent("onselect");
		
		return true;
	}
	
	this.choose = function(xmlNode){
		if(!this.selectable || this.disabled) return;
		
		if(this.dispatchEvent("onbeforechoose", xmlNode) === false) return false;
		
		if(xmlNode && !xmlNode.style) this.select(xmlNode);
		
		if(this.hasFeature(__DATABINDING__) && this.dispatchEvent("onafterchoose", this.value) !== false)
			this.setConnections(this.value, "choice");
	}
	
	/********* CLEARSELECTION ***********
		deselects one or all selected items
	
		INTERFACE:
		this.clearSelection(singleNode);
	************************************/
	this.clearSelection = function(singleNode, no_event){
		if(!this.selectable || this.disabled) return;
		
		var clSel = singleNode ? this.value : valueList;
		if(!no_event && this.dispatchEvent("onbeforedeselect", clSel) === false) return false;
		
		if(this.value){
			var htmlNode = this.caching ? this.getNodeFromCache(this.value.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId) : document.getElementById(this.value.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId); //IE55
			this.__deselect(htmlNode);
		}
		
		//if(this.selected) this.__deselect(this.selected);
		this.selected = this.value = null;
		
		if(!singleNode){
			for(var i=valueList.length-1;i>=0;i--){
				var htmlNode = this.caching ? this.getNodeFromCache(valueList[i].getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId) : document.getElementById(valueList[i].getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId); //IE55
				this.__deselect(htmlNode);
			}
			//for(var i=selectedList.length-1;i>=0;i--) this.__deselect(selectedList[i]);
			selectedList = [];
			valueList = [];
		}
		
		if(this.indicator){
			var htmlNode = this.caching ? this.getNodeFromCache(this.indicator.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId) : document.getElementById(this.indicator.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId); //IE55
			this.selected = this.__indicate(htmlNode);
		}
		
		if(!no_event) this.dispatchEvent("onafterdeselect", clSel);
	}
	
	/********* SELECTLIST ***********
		Select List of references/id's
	
		INTERFACE:
		this.selectList(htmlNodeList);
		this.selectList(xmlNodeList);
		this.selectList(xmlIDList);
	********************************/
	this.selectList = function(xmlNodeList){
		if(!this.selectable || this.disabled) return;
		this.clearSelection(null, true);

		for(var i=0;i<xmlNodeList.length;i++){
			if(xmlNodeList[i].nodeType != 1) continue;
			var xmlNode = xmlNodeList[i];

			//Type Detection
			if(typeof xmlNode != "object") xmlNode = XMLDatabase.getNodeById(xmlNode);
			if(!xmlNode.style) htmlNode = this.__findNode(null, xmlNode.getAttribute(XMLDatabase.xmlIdTag) + "|" + this.uniqueId); //IE55
			else{
				htmlNode = xmlNode;
				xmlNode = XMLDatabase.getNodeById(htmlNode.getAttribute(XMLDatabase.htmlIdTag));
			}
			
			if(!xmlNode){
				issueWarning(0, "Component : " + this.name + " [" + this.tagName + "]\nMessage : xmlNode whilst selecting a list of xmlNodes could not be found. Ignoring.")
				continue;
			}

			//Select Node
			if(htmlNode){
				this.__select(htmlNode);
				selectedList.push(htmlNode);
			}
			valueList.push(xmlNode);
		}
		
		this.selected = selectedList[0];
		this.value = valueList[0];
	}
	
	/********* SETINDICATOR ***********
		Set Indicator to position
	
		INTERFACE:
		this.setIndicator(htmlNode);
		this.setIndicator(xmlNode);
		this.setIndicator(xmlID);
	********************************/
	this.setIndicator = function(xmlNode){
		/***** Type Detection *****/
		if(!xmlNode) throw new Error(1075, Kernel.formErrorString(1075, this, "select Method", "Missing xmlNode reference"));

		if(typeof xmlNode != "object") xmlNode = XMLDatabase.getNodeById(xmlNode);
		if(!xmlNode.style) htmlNode = this.caching ? this.getNodeFromCache(xmlNode.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId) : document.getElementById(xmlNode.getAttribute(XMLDatabase.xmlIdTag)+"|"+this.uniqueId); //IE55
		else{
			var id = (htmlNode = xmlNode).getAttribute(XMLDatabase.htmlIdTag);
			while(!id && htmlNode.parentNode)
				var id = (htmlNode = htmlNode.parentNode).getAttribute(XMLDatabase.htmlIdTag);

			xmlNode = XMLDatabase.getNodeById(id);
		}

		if(this.selected) this.__deindicate(this.selected);
		this.indicator = xmlNode;
		this.selected = this.__indicate(htmlNode);
	}
	
	/********* SELECTALL ***********
		Selects All Nodes
	
		INTERFACE:
		this.selectAll();
	********************************/
	this.selectAll = function(){
		if(!this.selectable || this.disabled || !this.selected) return;
		var nodes = this.getTraverseNodes();
		//this.select(nodes[0]);
		//this.select(nodes[nodes.length-1], null, true);
		this.selectList(nodes);
	}
	
	/********* GETSELECTION ***********
		Returns Node List of selected XMLNodes
	
		INTERFACE:
		this.getSelection();
	********************************/
	this.getSelection = function(xmldoc){
		if(xmldoc){
			var r = this.XMLRoot ? this.XMLRoot.ownerDocument.createDocumentFragment() : Kernel.getObject("XMLDOM").createDocumentFragment();
			for(var i=0;i<valueList.length;i++) XMLDatabase.clearConnections(r.appendChild(valueList[i].cloneNode(true)));
		}
		else for(var r=[],i=0;i<valueList.length;i++) r.push(valueList[i]);

		return r;
	}
	
	this.getSelectedNodes = function(){
		return valueList;
	}
	
	/********* DEFAULTSELECTNEXT ***********
		Select another node than this one
	
		INTERFACE:
		this.defaultSelectNext(xmlNode, isTree);
	***************************************/
	this.defaultSelectNext = function(xmlNode, isTree){
		var next = this.getNextTraverseSelected(xmlNode);
		//if(!next && xmlNode == this.XMLRoot) return;

		if(next || !isTree) this.select(next ? next : this.getTraverseParent(xmlNode));
		else this.clearSelection(null, true);
	}
	
	this.selectNext = function(){
		var xmlNode = this.getNextTraverse();
		if(xmlNode) this.select(xmlNode);
	}
	
	this.selectPrevious = function(){
		var xmlNode = this.getNextTraverse(null, -1);
		if(xmlNode) this.select(xmlNode);	
	}
	
	/********* GETDEFAULTNEXT ***********
		Get another node than this one to select
	
		INTERFACE:
		this.getDefaultNext(xmlNode, isTree);
	***************************************/
	this.getDefaultNext = function(xmlNode, isTree){
		var next = this.getNextTraverseSelected(xmlNode);
		//if(!next && xmlNode == this.XMLRoot) return;

		return next && next != xmlNode ? next : (isTree ? this.getTraverseParent(xmlNode) : false);
	}
	
	this.getSelectCount = function(){
		return valueList.length;
	}
	
	this.isSelected = function(xmlNode){
		if(!xmlNode) return false;
		
		for(var i=0;i<valueList.length;i++){
			if(valueList[i] == xmlNode) return true;
		}
		
		return false;
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/
	
	// Multiselect
	this.__addJmlLoader(function(x){
		if(x.getAttribute("multiselect")) this.multiselect = x.getAttribute("multiselect") != "false";
		if(x.getAttribute("autoselect")) this.autoselect = x.getAttribute("autoselect") != "false";
		if(x.getAttribute("selectable")) this.selectable = x.getAttribute("selectable") != "false";
		if(x.getAttribute("ctrl-select")) this.ctrlSelect = x.getAttribute("ctrl-select") == "true";
		this.allowDeselect = x.getAttribute("allow-deselect") != "false";
		this.reselectable = x.getAttribute("reselectable") != "true";
		
		if(x.getAttribute("autoselect") == "all" && this.multiselect){
			this.addEventListener("onafterload", function(){
				this.selectAll();
			});
		}
		
		if(x.getAttributeNode("selected")){
			this.autoselect = true;
			this.selectXpath(x.getAttribute("selected"));
		}
	});
	
	// Select Bind class
	this.addEventListener("onbeforeselect", function(xmlNode){
		if(this.applyRuleSetOnNode("Select", xmlNode, ".") === false) return false;
	});
}

MultiSelectServer = {
	objects : {},
	
	register : function(xmlId, xmlNode, selList, jNode){
		if(!this.uniqueId) this.uniqueId = Kernel.all.push(this) - 1;
		
		this.objects[xmlId] = {
			xml : xmlNode,
			list : selList,
			jNode : jNode
		}
	},
	
	__xmlUpdate : function(action, xmlNode, listenNode, UndoObj){
		if(action != "attribute") return;
		var data = this.objects[xmlNode.getAttribute(XMLDatabase.xmlIdTag)];
		if(!data) return;
		var nodes = xmlNode.attributes;

		for(var j=0;j<data.list.length;j++){
			//data[j].setAttribute(UndoObj.name, xmlNode.getAttribute(UndoObj.name));
			XMLDatabase.setAttribute(data.list[j], UndoObj.name, xmlNode.getAttribute(UndoObj.name));
		}
		
		//XMLDatabase.synchronize();
	}
}


/*FILEHEAD(/in/Core/Node/Presentation.js)SIZE(11392)TIME(1188900006250)*/
__PRESENTATION__ = 1<<9;


/*
<Root>
	<include src="src/blah.xml />
	<List>
		<style><![CDATA ]]></style>
		<Presentation>
		
		</Presentation>
	</List>
	<Datagrid>
		<style src="" />
		<Presentation>
		
		</Presentation>
	</Datagrid>
</Root>
*/

PresentationServer = {
	skins : {},
	css : [],

	/************
		Init
	************/

	Init : function(xmlNode, refNode, path){
		/*
			get data from refNode || xmlNode
			- name
			- icon-path
			- media-path
			
			all paths of the xmlNode are relative to the src attribute of refNode
			all paths of the refNode are relative to the index.html
			images/ is replaced if there is a refNode to the relative path from index to the skin + /images/
		*/
		var name = (refNode ? refNode.getAttribute("name") : null) || xmlNode.getAttribute("name");
		var base = (refNode && refNode.getAttribute("src").match(/\//) || path) ? (path||refNode.getAttribute("src")).replace(/\/[^\/]*$/, "") + "/" : null;
		var mediaPath = (xmlNode.getAttribute("media-path") ? getAbsolutePath(base || HOST_PATH, xmlNode.getAttribute("media-path")) : (refNode ? refNode.getAttribute("media-path") : null));
		var iconPath = (xmlNode.getAttribute("icon-path") ? getAbsolutePath(base || HOST_PATH, xmlNode.getAttribute("icon-path")) : (refNode ? refNode.getAttribute("icon-path") : null));
		if(!name) name = "default";
		
		if(xmlNode.getAttribute("name")) document.body.className += " " + xmlNode.getAttribute("name");

		if(!this.skins[name]){
			this.skins[name] = {
				base : base,
				name : name,
				iconPath : iconPath || "icons/",
				mediaPath : mediaPath || "images/",
				templates : {}
			}
		}
		if(!this.skins["default"]) this.skins["default"] = this.skins[name];

		var nodes = xmlNode.childNodes;
		for(var i=nodes.length-1;i>=0;i--){
			if(nodes[i].nodeType != 1) continue;

			//this.templates[nodes[i].tagName] = nodes[i];
			this.skins[name].templates[nodes[i][TAGNAME]] = nodes[i];
			if(nodes[i].ownerDocument)
				this.importSkinDef(nodes[i], base);
		}
		
		this.purgeCSS(mediaPath || base + "images/", iconPath || base + "icons/");
	},

	/************
		Import
	************/

	importSkinDef : function(xmlNode, basepath){
		var nodes = xmlNode.selectNodes("style");
		for(var i=0;i<nodes.length;i++){
			if(nodes[i].getAttribute("src"))Kernel.loadStylesheet(nodes[i].getAttribute("src").replace(/src/,basepath + "/src"));
			else if(nodes[i].getAttribute("condition")){
				try{var test = eval(nodes[i].getAttribute("condition"));}catch(e){test=false;}
				if(test) this.css.push(nodes[i].firstChild.nodeValue);
			}
			else if(nodes[i].firstChild) this.css.push(nodes[i].firstChild.nodeValue);
		}
	},

	purgeCSS : function(imagepath, iconpath){
		if(!this.css.length) return;

		var cssString = this.css.join("\n").replace(/images\//g, imagepath).replace(/icons\//g, iconpath);
		Kernel.importCssString(document, cssString);
		
		this.css = [];
	},

	/************
		Retrieve
	************/
	
	setSkinPaths : function(skinName, jmlNode){
		skinName = skinName.split(":");
		var name = skinName[0], type = skinName[1];
		
		if(!this.skins[name]){
			throw new Error(1076, Kernel.formErrorString(1076, null, "Retrieving Skin", "Could not find skin '" + name + "'", jmlNode.jml));
		}
		
		jmlNode.iconPath = this.skins[name].iconPath;
		jmlNode.mediaPath = this.skins[name].mediaPath;
	},

	getTemplate : function(skinName, cJml){
		skinName = skinName.split(":");
		var name = skinName[0], type = skinName[1];

		if(!this.skins[name]){
			throw new Error(1076, Kernel.formErrorString(1076, null, "Retrieving Template", "Could not find skin '" + name + "'", cJml));
		}
		
		if(this.skins[name].templates[type])
			return this.skins[name].templates[type];
	}
}

function Presentation(){
	/***********************
		INTERFACE REQUIRED

		...
	***********************/

	/*********************************************************************
										PROPERTIES
	*********************************************************************/

	var pNodes;

	this.__regbase = this.__regbase|__PRESENTATION__;
	this.skinName = null;
	
	//var cachedExts = {};

	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/

	this.changeSkin = function(skinName){
		if(this.skinName == skinName) return;

		if(this.selectable)
			var valueList = this.getSelection();//valueList;
		//cachedExts[this.cacheID] = this.oExt;

		this.baseCSSname = null;
		this.skinName = skinName.indexOf(":") > -1 ? skinName : skinName + ":" + this.tagName;
		/*var cacheID = new String(this.cacheID).split("\|");
		cacheID = (this.baseSkin == this.skinName ? "" : this.skinName + "|") + (cacheID[1] || cacheID[0]);

		if(cachedExts[cacheID]){
			this.oExt.parentNode.replaceChild(cachedExts[cacheID], this.oExt);
			this.oExt = cachedExts[cacheID];
			return;
		}
		else */
			this.pHtmlNode = this.oExt.parentNode;
			var beforeNode = this.oExt.nextSibling;
			this.oExt.parentNode.removeChild(this.oExt);
			var id = this.oExt.getAttribute("id");

		//Load the new skin
		if(this.loadSkin) this.loadSkin();

		//Drawing
		this.draw();
		if(id) this.oExt.setAttribute("id", id);
		if(beforeNode) this.oExt.parentNode.insertBefore(this.oExt, beforeNode);
		this.__initLayout(this.jml);

		// Widget specific
		if(this.__loadJML) this.__loadJML(this.jml);
		
		//Process JML Handlers
		//for(var i=this.__jmlLoaders.length-1;i>=0;i--)
		//	this.__jmlLoaders[i].call(this, this.jml);
		
		//Process databinding
		Application.processDatabinding();

		//Reload data
		if(this.hasFeature(__DATABINDING__) && this.XMLRoot) 
			this.load(this.XMLRoot, this.cacheID, true);
		
		//Dispatch event
		this.dispatchEvent("onskinchange");
		
		//Set Properties
		if(this.selectable) this.selectList(valueList);
		if(this.disabled) this.disable();
		if(this.focussable && this.isFocussed()) this.focus();
		
		//More properties of the dynamic kind
		for(var i=this.__supportedProperties.length-1;i>=0;--i){
			var pValue = this[this.__supportedProperties[i]];
			if(!pValue) continue;
			
			this.handlePropSet(this.__supportedProperties[i], pValue, true);
		}
		
		//Anchoring
		if(this.hasFeature(__ANCHORING__)) this.purgeAnchoring();
		
		//Layout server
		LayoutServer.activateRules(this.oExt.parentNode);
		LayoutServer.forceResize(this.oExt.parentNode);
	}

	this.loadSkin = function(skinName){
		if(!skinName) skinName = this.jml.getAttribute("skin");
		if(!this.baseSkin) this.baseSkin = (skinName ? (skinName.indexOf(":") > -1 ? skinName : skinName + ":" + this.tagName) : null) || (PresentationServer.defaultSkin || "default") + ":" + this.tagName;
		if(!this.skinName) this.skinName = this.baseSkin;

		this.skin = PresentationServer.getTemplate(this.skinName, this.jml);
		if(!this.skin){
			this.baseName = this.skinName = "default:" + this.tagName;
			this.skin = PresentationServer.getTemplate(this.skinName, this.jml);
			
			if(!this.skin) throw new Error(1077, Kernel.formErrorString(1077, this, "Presentation", "Could not load skin: " + this.skinName, this.jml));
		}
		if(this.skin) PresentationServer.setSkinPaths(this.skinName, this);

		pNodes = {}; //reset the pNodes array
		var nodes = this.skin.selectNodes("Presentation/node()");
		
		for(var i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1) continue;
			pNodes[nodes[i].tagName] = nodes[i];
		}
	}

	this.__getNewContext = function(type, jmlNode){
		pNodes[type] = this.skin.selectSingleNode("node()/" + type).cloneNode(true);
	}

	this.__hasLayoutNode = function(type){
		return pNodes[type] ? true : false;
	}

	this.__getLayoutNode = function(type, section, htmlNode){
		var node = pNodes[type];
		if(!node) return false;
		if(!section) return Kernel.compat.getFirstElement(node);

		var textNode = node.selectSingleNode("@" + section);

		//if(textNode) try{(htmlNode ? XMLDatabase.selectSingleNode(textNode.nodeValue, htmlNode) : getFirstElement(node).selectSingleNode(textNode.nodeValue))}catch(e){throw new Error(0, "---- Javeline Error ----\nMessage : Could not find Presentation Skin Item (" + e.message + "): '" + section + " -> " + textNode.nodeValue + "'\n" + node.xml)}
		
		if(!textNode) return null;
		return (htmlNode ? XMLDatabase.selectSingleNode(textNode.nodeValue, htmlNode) : Kernel.compat.getFirstElement(node).selectSingleNode(textNode.nodeValue));
	}

	this.__getOption = function(type, section){
		var node = pNodes[type];
		if(!section) return Kernel.compat.getFirstElement(node);
		var option = node.selectSingleNode("@" + section);

		return option ? option.nodeValue : "";
	}
	
	this.__getExternal = function(tag, pNode, func, jml){
		if(!pNode) pNode = this.pHtmlNode;
		if(!tag) tag = "Main";
		if(!jml) jml = this.jml;
		
		this.__getNewContext(tag);
		var oExt = this.__getLayoutNode(tag);
		if(jml.getAttributeNode("css")) oExt.setAttribute("style", jml.getAttribute("css"));
		if(jml.getAttributeNode("cssclass")) this.__setStyleClass(oExt, jml.getAttribute("cssclass"));
		if(func) func.call(this, oExt);

		oExt = XMLDatabase.htmlImport(oExt, pNode);
		oExt.host = this;
		if(jml.getAttribute("bgimage")) oExt.style.backgroundImage = "url(" + getAbsolutePath(this.mediaPath, jml.getAttribute("bgimage")) + ")";
		
		if(!this.baseCSSname) this.baseCSSname = oExt.className.trim().split(" ")[0];
		
		return oExt;
	}
	
	/************************
				Focus
	************************/

	this.__focus = function(){
		if(!this.oExt) return;
		this.__setStyleClass(this.oExt, this.baseCSSname + "Focus");
	}

	this.__blur = function(){
		if(!this.oExt) return;
		this.__setStyleClass(this.oExt, "", [this.baseCSSname + "Focus"]);
	}

	/************************
				SELECT
	************************/

	if(this.hasFeature(__MULTISELECT__)){
		this.__select = function(o){
			if(!o || !o.style) return;
			return this.__setStyleClass(o, "selected");
		}
	
		this.__deselect = function(o){
			if(!o) return;
			return this.__setStyleClass(o, "", ["selected", "indicate"]);
		}
		
		this.__indicate = function(o){
			if(!o) return;
			return this.__setStyleClass(o, "indicate");
		}
	
		this.__deindicate = function(o){
			if(!o) return;
			return this.__setStyleClass(o, "", ["indicate"]);
		}
	}
	
	/************************
			  CACHING
	************************/

	this.__setEmptyMessage = function(msg){

	}

	this.__removeEmptyMessage = function(){

	}

	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/

	this.__setStyleClass = function(oEl, className, exclusion){
		if(!oEl || this.disabled) return;
		if(!exclusion) exclusion = new Array();
		exclusion.push(className);

		//Remove defined classes
		var re = new RegExp("(?:(^| +)" + exclusion.join("|") + "($| +))", "gi");

		//Set new class
		oEl.className != null ?
			(oEl.className = oEl.className.replace(re, " ") + " " + className) :
			oEl.setAttribute("class", (oEl.getAttribute("class") || "").replace(re, " ") + " " + className);

		return oEl;
	}
}

/*FILEHEAD(/in/Core/Node/Rename.js)SIZE(5847)TIME(1182726961382)*/
__RENAME__ = 1<<10;


function Rename(){
	/***********************
		INTERFACE REQUIRED
		
		[none]
	***********************/
	
	/*********************************************************************
										PROPERTIES
	*********************************************************************/
	
	this.__regbase = this.__regbase|__RENAME__;
	this.rename = true;
	
	/*********************************************************************
										PUBLIC METHODS
	*********************************************************************/
	
	/********* RENAME ***********
		Renames current node or selects by xmlNode
	
		INTERFACE:
		this.Rename(htmlNode);
		this.Rename(xmlNode);
		this.Rename(xmlID);
	****************************/
	this.Rename = function(xmlNode, value){
		if(xmlNode) this.select(xmlNode);

		var node = this.getNodeFromRule("Caption", this.value);//, null, null, true);
		if(!node) return;

		var atAction = node.nodeType == 1 || node.nodeType == 3 ? "setTextNode" : "setAttribute";
		var args = node.nodeType == 1 || node.nodeType == 3 ? 
			[node.nodeType == 1 ? node : node.parentNode, value] : [node.ownerElement || node.selectSingleNode(".."), node.nodeName, value];

		//Use Action Tracker
		this.executeAction(atAction, args, "Rename", this.value);
	}
	
	/*********************************************************************
										PRIVATE METHODS
	*********************************************************************/
	
	this.startDelayedRename = function(e){
		if(e.button == 2) return;
		clearTimeout(this.renameTimer);
		this.renameTimer = setTimeout('Kernel.lookup(' + this.uniqueId + ').startRename()', 400);
	}
	
	this.startRename = function(){
		if(this.actionRules && !this.getNodeFromRule("Rename", this.value, true) || this.disabled || !this.rename) return false;

		clearTimeout(this.renameTimer);
		if(this.dispatchEvent("onrenamestart") === false) return false;

		this.renaming = true;
		var o = this.__getCaptionElement ? this.__getCaptionElement() : this.selected;
		o.style.cursor = "text";
		
		var p = o.parentNode;
		o.parentNode.replaceChild(this.oTxt, o);
		
		this.replacedNode = o;
		var xmlNode = this.getNodeFromRule("Caption", this.value);
		this.oTxt[Kernel.hasContentEditable ? "innerHTML" : "value"] = (xmlNode.nodeType == 2 ? unescape(decodeURI(xmlNode.nodeValue)) : XMLDatabase.getNodeValue(xmlNode)) || "";//o.innerHTML;
		this.oTxt.unselectable = "Off";
		this.oTxt.host = this;

		//this.oTxt.focus();
		this.oTxt.select();
	}
	
	this.cancelRename = function(nocheck){
		clearTimeout(this.renameTimer);
		if(!this.renaming) return;
		
		this.renaming = false;
		var o = this.oTxt;
		if(o.parentNode) o.parentNode.replaceChild(this.replacedNode, o);
		this.replacedNode.style.cursor = "default";
		
		return true;
	}
	
	this.stopRename = function(){
		//this.selected.innerHTML = this.oTxt.innerHTML;
		this.Rename(null, this.oTxt[Kernel.hasContentEditable ? "innerHTML" : "value"].replace(/<.*?nobr>/gi, ""));
		
		return false;
	}
	
	/*********************************************************************
										HOOKS
	*********************************************************************/
	
	if(this.__deselect) this.__rdeselect = this.__deselect;
	if(this.__blur) this.__rdblur = this.__blur;
		
	this.__deselect = function(o){
		if(this.renaming){
			//Check if this is the same is the node to be renamed...
			if(this.selected.parentNode.nodeType == 11) node = this.selected;
			
			if(!this.cancelRename()) return o;
			this.stopRename();
		}
		
		return this.__rdeselect ? this.__rdeselect(o) : o;
	}
	
	this.__blur = function(){
		if(this.renaming){
			if(!this.cancelRename()) return;
			this.stopRename();
		}
		
		if(this.__rdblur) this.__rdblur();
	}
	
	if(this.keyHandler) this.__keyHandler = this.keyHandler;
	
	this.keyHandler = function(key, ctrlKey, shiftKey, altKey){
		if(this.renaming){
			if(key == 27 || key == 13){
				this.cancelRename();
				if(key == 13) this.stopRename();
			}
			
			return;
		}

		//F2
		if(key == 113){
			this.startRename();
			return false;
		}
		else if(this.__keyHandler) //Normal KeyHandler
			return this.__keyHandler(key, ctrlKey, shiftKey, altKey);
	}
	
	/*********************************************************************
									EDIT FIELD
	*********************************************************************/
	if(!(this.oTxt = this.pHtmlDoc.getElementsByTagName("txt_rename")[0])){
		if(Kernel.hasContentEditable){
			this.oTxt = document.createElement("DIV");
			this.oTxt.contentEditable = true;
			if(IS_IE6) this.oTxt.style.width = "1px";
			//this.oTxt.canHaveHTML = false;
		}
		else{
			this.oTxt = document.createElement("INPUT");
			this.oTxt.setAttribute("id", "txt_rename");
			//this.oTxt.style.width = "100%";
			this.oTxt.autocomplete = false;
	
		}
		this.oTxt.id = "txt_rename";
		this.oTxt.style.whiteSpace = "nowrap";
		this.oTxt.onselectstart = function(e){(e || event).cancelBubble = true};
		//this.oTxt.host = this;
		
		this.oTxt.onmouseover = this.oTxt.onmouseout = this.oTxt.oncontextmenu = 
		this.oTxt.onmousedown = function(e){(e || event).cancelBubble = true}
		
		this.oTxt.select = function(){
			if(!IS_IE) return this.focus();
			var r = document.selection.createRange();
			//r.moveEnd("character", this.oExt.innerText.length);
			try{r.moveToElementText(this);}catch(e){} //BUG!!!!
			r.select();
		}
		
		this.oTxt.onblur = function(){
			if(IS_GECKO) return; //bug in firefox calling onblur too much
			this.host.cancelRename();
			this.host.stopRename();
		}
		
		this.__addJmlDestroyer(function(){
			this.oTxt.host = null;
			this.oTxt.onmouseover = null;
			this.oTxt.onmousedown = null;
			this.oTxt.select = null;
		});
	}

	this.__addJmlLoader(function(x){
		this.rename = x.getAttribute("rename") != "false";
	});
}

/*FILEHEAD(/in/Core/Application/ActionTracker.js)SIZE(13690)TIME(1188900006250)*/

function _ActionTracker(context){
	this.realtime = true;
	this.hasChanged = false;
	//this.root = (me == self.main);
	//if(!this.root) 
	
	this.getParentAT = function(){
		if(context) return context.getActionTracker(true);
		else return self.ActionTracker && self.ActionTracker != this ? self.ActionTracker : null;//me.parentWindow ? me.parentWindow.ActionTracker : 
	}
	
	this.actions = {};
	this.stackDone = new Array();
	this.stackUndone = new Array();
	this.stackRPC = new Array();
	
	/*********************************************************************
										API
	*********************************************************************/
	
	this.define = function(action, func){
		this.actions[action] = func;
	}

	this.execute = function(action, args, xmlActionNode, jmlNode, selNode){
		this.hasChanged = true;
		if(this.onchange && this.onchange() === false) return;
		
		//Execute action
		var UndoObj = new UndoData(action, xmlActionNode, args, jmlNode, selNode);
		if(action) this.actions[action](UndoObj, false, this);
		
		//Add action to stack
		var id = UndoObj.id = this.stackDone.push(UndoObj)-1;
		this.lastId = id;

		//Respond
		if(xmlActionNode) this.doResponse(UndoObj, null);
		else UndoObj.callRPC(null, null, this); //Possibly make RDB call
		
		//Reset Redo Stack
		this.stackUndone.length = 0;

		//return stack id of action
		return id;
	}
	
	this.doResponse = function(UndoObj, undo){
		var bindNode = UndoObj.getActionXmlNode(undo);
		if(!bindNode) return;
		
		var xmlNode = UndoObj.selNode;
		var jmlNode = UndoObj.jmlNode;

		//Execute Client Side Response
		if(bindNode.getAttribute("object"))
			self[bindNode.getAttribute("object")][bindNode.getAttribute("method")](xmlNode);
		else if(bindNode.getAttribute("method"))
			self[bindNode.getAttribute("method")]();
		else if(bindNode.getAttribute("eval"))
			eval(bindNode.getAttribute("eval"));
		
		//OR Make RPC Call
		else if(this.realtime) UndoObj.callRPC(undo, null, this);
		//OR Add RPC Call from stack	
		else this.stackRPC.push(UndoObj);
	}
	
	this.addActionGroup = function(done, rpc){
		var UndoObj = new UndoData("group", null, [copyArray(done, UndoData), copyArray(rpc, UndoData)]);
		this.stackDone.push(UndoObj);
		
		this.hasChanged = true;
		if(this.onchange) this.onchange();
	}
	
	this.purge = function(nogrouping, forcegrouping){
		var prnt = this.getParentAT();
		
		if(nogrouping && prnt){
		//if(!forcegrouping && this.parent){
			var hash = {}, ids = [];
			
			//Execute RPC calls through multicall or queued calling
			for(var i=0;i<this.stackRPC.length;i++){
				var o = this.stackRPC[i].callRPC(null, true, this);
				hash[o.uniqueId] = o;
				ids.push(this.stackRPC[i].id);
			}
			
			//Purge & Remove Multicall Force
			for(prop in hash){
				if(typeof prop == "number"){
					hash[prop].purge(receive, ids);
					hash[prop].force_multicall = false;
				}
			}
			
			//Also Execute the Socket Calls Connected to the Actions if any
			if(XMLDatabase.socket) XMLDatabase.socket.purge();
		}
		else if(prnt){
		//else if(!nogrouping){
			//Copy Stacked Actions as a single grouped action to parent ActionTracker
			prnt.addActionGroup(this.stackDone, this.stackRPC);
		}
		
		//Reset Stacks
		this.reset();
	}
	
	this.reset = function(){
		//Reset Stacks
		this.stackDone.length = 0;
		this.stackUndone.length = 0;
		this.stackRPC.length = 0;
		
		this.hasChanged = false;
		if(this.onchange) this.onchange(true);
		/* could set start of changed to x and check if different above */
	}
	
	//TODO: merge undo and redo
	this.undo = function(id, single, stackDone, stackUndone, rollBack){
		if(!stackDone) stackDone = this.stackDone;
		if(!stackUndone) stackUndone = this.stackUndone;
		
		if(!stackDone.length) return;
		
		if(single){
			var UndoObj = stackDone[id];
			if(!UndoObj) return;
			
			//Workaround for calls coming in late...
			if(id == stackDone.length-1) stackDone.length--;
			else stackDone[id] = null;
			
			//Undo Client Side Action
			if(UndoObj.action) this.actions[UndoObj.action](UndoObj, true, this);
			
			//Respond - REMOVED.. shouldn't be called during undo
			if(!rollBack) this.doResponse(UndoObj, true); // WHY NOT??? seems the right place....
			
			//Set Changed Value
			if(!stackDone.length) this.hasChanged = false; //doesn't matter for recursion (up)
			
			return UndoObj;
		}
		
		setStatus("Executing undo");

		//Undo the last X places - where X = id;
		var i = 0;
		if(id == -1) id = stackDone.length;
		if(!id) id = 1;
		
		while(i < id && stackDone.length > 0){
			if(!stackDone[stackDone.length-1]) stackDone.length--;
			else{
				stackUndone.push(this.undo(stackDone.length-1, true, stackDone, stackUndone));
				i++;
			}
		}
		
		if(this.onchange) this.onchange(true);
	}
	
	this.redo = function(id, single, stackDone, stackUndone, rollBack){
		if(!stackDone) stackDone = this.stackDone;
		if(!stackUndone) stackUndone = this.stackUndone;
		
		if(!stackUndone.length) return;
		if(single){
			//var UndoObj = stackUndone.pop();
			//if(!UndoObj) return;
			
			var UndoObj = stackUndone[id];
			if(!UndoObj) return;
			
			//Workaround for calls coming in late... (prolly not needed for redo)
			if(id == stackUndone.length-1) stackUndone.length--;
			else stackUndone[id] = null;
			
			//Undo Client Side Action
			if(UndoObj.action) this.actions[UndoObj.action](UndoObj, false, this);
			
			//Respond - REMOVED.. shouldn't be called during redo
			if(!rollBack) this.doResponse(UndoObj); // WHY NOT??? seems the right place....
			
			//this.stackDone.push(UndoObj);
			this.hasChanged = true;
			
			return UndoObj;
		}
		
		setStatus("Executing redo");
		
		//Redo the last X places - where X = id;
		var i = 0;
		if(id == -1) id = stackUndone.length;
		if(!id) id = 1;
		
		while(i < id && stackUndone.length > 0){
			if(!stackUndone[stackUndone.length-1]) stackUndone.length--;
			else{
				stackDone.push(this.redo(stackUndone.length-1, true, stackDone, stackUndone));
				i++;
			}
		}
		
		if(this.onchange) this.onchange();
	}
	
	/*********************************************************************
										OTHER
	*********************************************************************/
	
	this.receive = function(data, state, extra, ids){
		if(state != __HTTP_SUCCESS__){
			if(state == __HTTP_TIMEOUT__ && extra.retries < MAX_JAV_RETRIES) return extra.tpModule.retry(extra.id);
			else throw new Error(1028, Kernel.formErrorString(1028, null, "ActionTracker", "Could not sent Action RPC request for control " + this.name + "[" + this.tagName + "] \n\n" + extra.message))
		}
		
		//hack!!
		if(data && data.nodeType && data.selectSingleNode("//undo")){
			//datheon more hacking
			var msg = getXMLValue(data, "//undo/reason") + "\n";
			var nodes = data.selectNodes("//undo/object");
			for(var i=0;i<nodes.length;i++){
				msg += "- " + nodes[i].getAttribute("name") + "\n";
			}
			data = msg;
		}
		else return;
		
		/*if(data){
			//Get Undo Node
			var UndoObj = this.stackDone[ids];
			var xmlActionNode = UndoObj.getActionXmlNode();
			
			//Get Result Node
			if(xmlActionNode.getAttribute("result")){
				var rNode = UndoObj.xmlNode.selectSingleNode(xmlActionNode.getAttribute("result"));

				//Attribute Node - fill
				if(rNode.nodeType == 2) rNode.nodeValue = data;
				
				//Other Node - replace
				else{
					xmlNode = Kernel.getObject("XMLDOM", data).documentElement.firstChild;
					rNode.parentNode.replaceChild(xmlNode ,rNode);
				}
				
				XMLDatabase.applyChanges("synchronize", UndoObj.xmlNode);
			}
			
			return;
		}*/
		if(typeof ids == "number") return this.doError(data, ids);
		
		for(var i=0;i<ids.length;i++) this.doError(data[i], ids[i]);
	}
	
	this.doError = function(data, id){
		//Alert reason for denying access
		if(data) alert(data);
		
		//Undo failed actions
		//this.undo(id, true);
		this.undo(id, true, null, null, true);
	}
	
	/*********************************************************************
									BUILD-IN ACTIONS
	*********************************************************************/
	
	
	this.define("setTextNode", 
		function(UndoObj, undo){
			var q = UndoObj.args;
			
			//Set Text Node
			if(!undo) XMLDatabase.setTextNode(q[0], q[1], q[2], UndoObj);
			//Undo Text Node Setting
			else XMLDatabase.setTextNode(q[0], UndoObj.oldValue, q[2]);
		}
	);
	
	this.define("setAttribute", 
		function(UndoObj, undo){
			var q = UndoObj.args;
			
			//Set Attribute
			if(!undo){
				//Set undo info
				UndoObj.name = q[1];
				UndoObj.oldValue = q[0].getAttribute(q[1]);
				
				XMLDatabase.setAttribute(q[0], q[1], q[2], q[3], UndoObj);
			}
			//Undo Attribute Setting
			else XMLDatabase.setAttribute(q[0], q[1], UndoObj.oldValue, q[3]);
		}
	);
	
	this.define("setAttributes", 
		function(UndoObj, undo){
			var prop, q = UndoObj.args;
			
			//Set Attribute
			if(!undo){
				//Set undo info
				var oldValues = {};
				for(prop in q[1]){
					oldValues[prop] = q[0].getAttribute(prop);
					q[0].setAttribute(prop, q[1][prop]);
				}
				UndoObj.oldValues = oldValues;
				
				XMLDatabase.applyChanges("attribute", q[0], UndoObj);
			}
			//Undo Attribute Setting
			else{
				for(prop in UndoObj.oldValues){
					if(!UndoObj.oldValues[prop]) q[0].removeAttribute(prop);
					else q[0].setAttribute(prop, UndoObj.oldValues[prop]);
				}
				XMLDatabase.applyChanges("attribute", q[0], UndoObj);
			}
		}
	);
	
	this.define("replaceNode", 
		function(UndoObj, undo){
			var q = UndoObj.args;
			
			//Set Attribute
			if(!undo) XMLDatabase.replaceNode(q[0], q[1], q[2], UndoObj);
			//Undo Attribute Setting
			else XMLDatabase.replaceNode(q[1], q[0], q[2]);
		}
	);
		
	this.define("addChildNode", 
		function(UndoObj, undo){
			var q = UndoObj.args;
			
			//Add Child Node
			if(!undo) XMLDatabase.addChildNode(q[0], q[1], q[2], q[3], q[4], UndoObj);
			//Remove Child Node
			else XMLDatabase.removeNode(UndoObj.addedNode);
		}
	);
	
	this.define("appendChildNode", 
		function(UndoObj, undo){
			var q = UndoObj.args;
			
			//Append Child Node
			if(!undo) XMLDatabase.appendChildNode(q[0], q[1], q[2], q[3], q[4], UndoObj);
			//Remove Child Node
			else XMLDatabase.removeNode(q[1]);
		}
	);
	
	this.define("moveNode", 
		function(UndoObj, undo){
			var q = UndoObj.args;

			//Move Node
			if(!undo) XMLDatabase.moveNode(q[0], q[1], q[2], q[3], UndoObj);
			//Move Node to previous position
			else XMLDatabase.moveNode(UndoObj.pNode, q[1], UndoObj.beforeNode, q[3]);
		}
	);
	
	this.define("removeNode", 
		function(UndoObj, undo){
			var q = UndoObj.args;

			//Remove Node
			if(!undo) XMLDatabase.removeNode(q[0], q[1], UndoObj);
			//Append Child Node
			else XMLDatabase.appendChildNode(UndoObj.pNode, UndoObj.removedNode, UndoObj.beforeNode);
		}
	);
	
	this.define("removeNodeList",
		function(UndoObj, undo){
			if(undo){
				var d = UndoObj.rData;
				for(var i=0;i<d.length;i++){
					XMLDatabase.appendChildNode(d[i].pNode, d[i].removedNode, d[i].beforeNode, UndoObj);
				}
			}
			else XMLDatabase.removeNodeList(UndoObj.args);
			
		}
	);
	
	this.define("setUndoObject", 
		function(UndoObj, undo){
			var q = UndoObj.args;
			UndoObj.xmlNode = q[0];
		}
	);
	
	this.define("group", 
		function(UndoObj, undo, ActionTracker){
			if(!UndoObj.stackDone){
				var done = UndoObj.args[0];
				UndoObj.stackDone = done;
				UndoObj.stackUndone = [];
			}
			
			ActionTracker[undo ? "undo" : "redo"](UndoObj.stackDone.length, false, UndoObj.stackDone, UndoObj.stackUndone);
		}
	);
	
}

function UndoData(action, xmlActionNode, args, jmlNode, selNode){
	this.tagName = "UndoData";
	
	//Copy Constructor
	if(action && action.tagName == "UndoData"){
		this.action = action.action;
		this.xmlActionNode = action.xmlActionNode;
		this.xmlNode = action.xmlNode;
		this.args = copyArray(action.args);
		this.rdb_args = copyArray(action.rdb_args);
		this.jmlNode = jmlNode;
		this.selNode = action.selNode;
	}
	//Constructor
	else{
		this.action = action;
		this.xmlActionNode = xmlActionNode;
		this.args = args;
		this.jmlNode = jmlNode;
		
		//HACK! Please check the requirement for this and how to solve this. Goes wrong with multiselected actions!
		this.selNode = selNode || (action == "removeNode" ? args[0] : (jmlNode ? jmlNode.value : null)); 
	}
	
	this.getActionXmlNode = function(undo){
		if(!this.xmlActionNode) return false;
		if(!undo) return this.xmlActionNode;
		
		var xmlNode = this.xmlActionNode.selectSingleNode("Undo");
		if(!xmlNode) xmlNode = this.xmlActionNode;
		
		return xmlNode;
	}
	
	//If no undo is defined the do rpc request is expected
	this.callRPC = function(undo, multicall, at){
		//Grouped undo/redo support
		if(this.action == "group"){
			var rpcNodes = this.args[1];
			for(var i=0;i<rpcNodes.length;i++) rpcNodes[i].callRPC(undo, multicall, at);
			return;
		}
		
		if(this.rdb_args){
			//Send RDB Data..
			multicall ?
				XMLDatabase.socket.sendMulti("rdb", this.rdb_args) : 
				XMLDatabase.socket.send("rdb", this.rdb_args);
		}
		
		var id = this.id, xmlActionNode = this.getActionXmlNode(undo);
		if(!xmlActionNode) return;
		
		//Do RPC Call - Currently only 1 ActionTracker PER Form is supported - UndoData NEEDS id
		if(Kernel.TelePort.hasLoadRule(xmlActionNode))
			return Kernel.TelePort.callMethodFromNode(xmlActionNode, this.selNode, function(data, state, extra){at.receive(data, state, extra, id);}, multicall);//main.win

		return;
	}
}

/*FILEHEAD(/in/Core/Application/DeskRun.js)SIZE(3302)TIME(1187087508069)*/
DeskRun = {
	widgets : [],
	
	register : function(widget){
		widget.show = function(dontset){
			if(!this.posInited){
				var pos = Kernel.compat.getAbsolutePosition(this.pHtmlNode);
				
				//lp.write("DT",this.name);
				//alert((pos[0] + parseInt(this.jml.getAttribute("left"))) + ":" + (pos[1] + parseInt(this.jml.getAttribute("top"))));
				//if(this.name!='sldMCamKey')
				this.oExt.moveTo(pos[0] + parseInt(this.jml.getAttribute("left"))+2, pos[1] + parseInt(this.jml.getAttribute("top"))+2);
				//if(this.name!='sldMCamKey')
				this.oExt.show();
				this.posInited = true;
				if(!dontset) this.isVisible = true;
			}
			else{
				this.oExt.show();
				if(!dontset) this.isVisible = true;
			}
		}
		
		widget.hide = function(dontset){
			this.oExt.hide();
			if(!dontset) this.isVisible = false;
		}
		
		this.widgets.push(widget);
	},
	
	hideAll : function(){
		window.external.shell.update();
		
		for(var i=0;i<this.widgets.length;i++){
			this.widgets[i].hide(true);
			window.external.shell.update();
		}
	},
	
	showAll : function(){
		window.external.shell.update();
		
		for(var i=0;i<this.widgets.length;i++){
			if(this.widgets[i].pHtmlNode.offsetHeight && this.widgets[i].isVisible) 
				this.widgets[i].show(true);
			shell.update();
		}
	},
	
	fixShow : function(){
		window.external.shell.update();
		
		for(var i=0;i<this.widgets.length;i++){
			//if(this.widgets[i].tagName == "MFSlider") alert(this.widgets[i].parentNode.tagName + ":" + this.widgets[i].parentNode.outerHTML + ":" + this.widgets[i].parentNode.offsetHeight);
			if(this.widgets[i].pHtmlNode.offsetHeight && this.widgets[i].isVisible) 
				this.widgets[i].show(true);
			else{
				this.widgets[i].hide(true);
			}
			window.external.shell.update();
		}
	}
}

/*if(HAS_DESKRUN){
	window.onerror = function(){
		window.external.show();
	}
}*/


/*
this.doOptimize = function(left, top, width, height, right, bottom, align, no_optimize){
	//if(!self.JDepWindow) 
	return; //temporarily disabled
	
	var addParent = this.parentNode == document.body;
	if(addParent) alert(addParent);
	var left = parseInt(this.oExt.style.left) || parseInt(this.jml.getAttribute("left")) + (addParent ? parseInt(this.parentNode.style.left) : null);
	var top = parseInt(this.oExt.style.top) || parseInt(this.jml.getAttribute("top")) + (addParent ? parseInt(this.parentNode.style.top) : null);
	var width = parseInt(this.oExt.style.width) || parseInt(this.jml.getAttribute("width"));
	var height = parseInt(this.oExt.style.height) || parseInt(this.jml.getAttribute("height"));
	
	if(!left) return;

	var div = document.body.appendChild(document.createElement("div"));
	div.style.zIndex = 10000;
	div.style.border = "1px solid red";
	div.style.left = left;
	div.style.top = top;
	div.style.width = width;
	div.style.height = height;
	div.style.position = "absolute";
	
	//x.getAttribute("left"), x.getAttribute("top"), x.getAttribute("width"), x.getAttribute("height"), x.getAttribute("right"), x.getAttribute("bottom"), x.getAttribute("align"), 
	
	JDepWindow.MouseOptimize(
		parseInt(left) || 0,
		parseInt(top) || 0,
		parseInt(width) || 0,
		parseInt(height) || 0,
		no_optimize ? 1 : 0
	);
}
*/
/*FILEHEAD(/in/Core/Application/Layout.js)SIZE(23942)TIME(1188383718500)*/
/*
	align="{align:left,edge:splitter,edge-margin:10,splitter-size:3,exec:single}"
	
	align='bottom'
	align-position='0-0';
	align-edge='sizer'
	align-margin='10'
	align-sizer='3'
	width='x'
	height='y'
	min-height='x'
	min-width='y'
	
	align-exec='single'
*/


LayoutServer = {
	hasSingleRszEvent : !IS_IE,
	
	layouts : {},
	
	addParent : function(oHtml, pMargin){
		if(!oHtml.getAttribute("id")) Kernel.setUniqueHtmlId(oHtml);
		return this.layouts[oHtml.getAttribute("id")] = {
			layout : new Layout(oHtml, pMargin),
			controls : []
		}
	},
	
	
	G : [],
	addGrid : function(str, pHtmlNode){
		this.G.push([str, pHtmlNode]);
	},
	activateGrid : function(){
		if(!this.G.length) return;

		//var rsz = this.G.join("\n");
		//LayoutServer.setRules(document.body, "grid", rsz, true);
		//LayoutServer.activateRules(document.body);
		for(var i=0;i<this.G.length;i++){
			LayoutServer.setRules(this.G[i][1], "grid", this.G[i][0], true);
			LayoutServer.activateRules(this.G[i][1]);
		}
	},
	
	
	removeControl : function(layout, id){var ret = layout.controls[id]?true:false;layout.controls[id] = null;return ret;},
	addControl : function(layout, id, aData){
		layout.controls[id] = aData;
		aData.hid = id;
	},
	
	get : function(oHtml, pMargin){
		var layout = this.layouts[oHtml.getAttribute("id")];
		if(!layout) layout = this.addParent(oHtml, pMargin);
		return layout;
	},
	
	compile : function(oHtml){
		var l = this.layouts[oHtml.getAttribute("id")];
		if(!l) return false;
		
		var seq = {"top":0, "left":1, "middle":2, "right":3, "bottom":4};
		var arr = l.controls.copy().sort(function(node1, node2){
			if(!node2) return -1; if(!node1) return 1;
			if(seq[node1.template] == seq[node2.template]) return node1.hid > node2.hid ? 1 : -1;
			if(!node2.template || seq[node1.template] == seq[node2.template]) return 0;
			return node1.template && seq[node1.template] < seq[node2.template] ? -1 : 1;
		});
		for(var i=0;i<arr.length;i++){
			if(arr[i]){
				if(arr[i].oHtml.ownerDocument != document) 
					arr[i].oHtml = document.getElementById(arr[i].oHtml.getAttribute("id"));
				l.layout.align(arr[i].oHtml, arr[i]);
			}
		}

		l.layout.compile();
		l.layout.reset();
	},
	
	rules : {},
	
	getHtmlId : function(oHtml){
		if(this.hasSingleRszEvent) return 1;
		else return oHtml.getAttribute("id");
	},
	
	setRules : function(oHtml, id, rules, overwrite){
		if(!this.getHtmlId(oHtml)) Kernel.setUniqueHtmlId(oHtml);
		if(!this.rules[this.getHtmlId(oHtml)]) this.rules[this.getHtmlId(oHtml)] = {};
		
		var ruleset = this.rules[this.getHtmlId(oHtml)][id];
		if(!overwrite && ruleset)
			this.rules[this.getHtmlId(oHtml)][id] = ruleset.concat(rules);
		else this.rules[this.getHtmlId(oHtml)][id] = rules;
	},
	
	getRules : function(oHtml, id){
		return id ? this.rules[this.getHtmlId(oHtml)][id] : this.rules[this.getHtmlId(oHtml)];
	},
	
	removeRule : function(oHtml, id){
		if(!this.rules[this.getHtmlId(oHtml)]) return;
		
		var ret = this.rules[this.getHtmlId(oHtml)][id] ? true : false;
		delete this.rules[this.getHtmlId(oHtml)][id];
		
		var prop;
		for(prop in this.rules[this.getHtmlId(oHtml)]){}
		if(!prop) delete this.rules[this.getHtmlId(oHtml)]
		
		return ret;
	},
	
	activateRules : function(oHtml, no_exec){
		if(!this.hasSingleRszEvent && !oHtml){
			var prop;
			for(prop in this.rules){
				if(document.getElementById(prop).onresize) continue;
				this.activateRules(document.getElementById(prop));
			}
			return;
		}
		
		var strRules = [], rules = this.rules[this.getHtmlId(oHtml)];
		if(!rules) return false;
		
		for(id in rules){ //might need optimization using join()
			if(typeof rules[id] != "string") continue;
			strRules.push(rules[id]);
		}
		
		if(!this.hasSingleRszEvent){
			var rsz = new Function(strRules.join("\n"));
			oHtml.onresize = rsz;
			if(!no_exec) rsz();
		}
		else{
			//A hack.. should build a dep tree, but actually FF should just implement onresize on any HTML element.
			window.onresize = new Function(strRules.reverse().join("\n") + "\n" + strRules.join("\n"));
			if(!no_exec) window.onresize();
		}
	},
	
	forceResize : function(oHtml){
		if((!this.hasSingleRszEvent ? oHtml : window).onresize)
			(!this.hasSingleRszEvent ? oHtml : window).onresize();
	}
};



function Layout(parentNode, pMargin){
	var pMargin = pMargin && pMargin.length == 4 ? pMargin : [0, 0, 0, 0];
	var matrix = [];
	this.RULES = [];
	this.parentNode = parentNode;
	var knownVars = {};
	var minWidth = 0;
	var minHeight = 0;
	
	//backward compatibility (ease of use)
	var defaults = {
		curlevel : 0,
		curcolumn : 0,
		
		top : {fwidth : "100%"},
		bottom : {isBottom : false, vpos : 2, fwidth : "100%"},
		left : {vpos : 1},
		middle : {vpos : 1, hpos : 0},
		right : {isRight : false, vpos : 1, hpos : 0}
	};
	
	this.setMargin = function(sMargin){
		pMargin = sMargin;
	}

	this.align = function(o, data, structOnly){
		if(!o.getAttribute("id")) Kernel.setUniqueHtmlId(o);
		if(o.style) o.style.position = "absolute";
		//o.innerHTML += "|" + o.id;

		//Check for template and parse it(defaults)
		if(data.template){
			var t = data.template.split("-");
			data.template = t[0];
			data.splitter = t[1] == "splitter" ? t[2] : false;
			
			if(defaults[data.template]){
				if(data.template == "left"){
					defaults.middle.hpos = 1;
					defaults.right.hpos = 1;
				}
				if(data.template == "middle") defaults.right.hpos = defaults.middle.hpos+1;
				
				
				if(this.lastType != "top" && data.template == "bottom") defaults.curlevel = Math.max(matrix.length || defaults.curlevel+1);
				extend(data, defaults[data.template]).vpos = defaults.curlevel;
				//alert(data.template + ":" + (matrix.length || defaults.curlevel+1));
				if(data.template == "top") defaults.curlevel++;// = Math.max(matrix.length || defaults.curlevel+1);
			}
		}
		
		this.lastType = data.template;
	
		//Set config structure
		var struct = extend({
			id : o.getAttribute("id"), object : o, isRight : false, isBottom : false, edgeMargin : 0, splitter : false,
			fwidth : null, fheight : null, minwidth : 0, minheight : 0, span : 1, vpos : 0, hpos : 0
		}, data);
		
		var vpos = struct.vpos;
		var hpos = struct.hpos;

		//Build matrix
		if(!matrix[vpos]) matrix[vpos] = [];
		if(!matrix[vpos][hpos]) matrix[vpos][hpos] = [];
		
		struct.stackId = matrix[vpos][hpos].push(struct) - 1;
		struct.column = matrix[vpos][hpos];
		struct.matrix = matrix;
		
		return struct;
	}
	
	this.remove = function(struct){
		matrix[struct.vpos][struct.hpos].remove(struct);
	}
	
	this.reset = function(){
		this.RULES = [];
		matrix = [];
		defaults.curlevel = 0;
		defaults.left.hpos = 0;
		defaults.middle.hpos = 0;
		defaults.right.hpos = 0;
		knownVars = {};
		this.lastType = null;
	}
	
	this.isFixed = function(arr, prop){
		for(var i=0;i<arr.length;i++){
			if(arr[i].length){
				if(!this.isFixed(arr[i], prop)) return false;
			}
			else if(!arr[i][prop]) return false;
		}
		return true;
	}
	
	this.check = function(){
		var levelOne = [[]];
		var levelTwo = [[]];
		var levelThree = [[]];
		var curLevelOne = levelOne[0];
		var curLevelTwo = levelTwo[0];
		var curLevelThree = levelThree[0];

		//Check 
		var diffLevelOne = 0;
		for(var i=0;i<matrix.length;i++){
			while(!matrix[i] && i < matrix.length) matrix.removeIndex(i);
			if(!matrix[i]) break;

			for(var j=0;j<matrix[i].length;j++){
				while(!matrix[i][j] && j < matrix[i].length) matrix[i].removeIndex(j);
				if(!matrix[i][j]) break;
				
				for(var k=0;k<matrix[i][j].length;k++){
					while(!matrix[i][j][k] && k < matrix[i][j].length) matrix[i][j].removeIndex(k);
					if(!matrix[i][j][k]) break;
					
					matrix[i][j][k].vpos = i;
					matrix[i][j][k].hpos = j;
					
					if(!matrix[i][j][k].fheight) curLevelThree.push(matrix[i][j][k]);
					else (curLevelThree.nwheight || (curLevelThree.nwheight = [])).push(matrix[i][j][k]);
				}
				curLevelThree.level = i;
				levelThree.push(curLevelThree = []);
				if(!matrix[i][j][0].fwidth) curLevelTwo.push(matrix[i][j][0]);
				else (curLevelTwo.nwwidth || (curLevelTwo.nwwidth = [])).push(matrix[i][j][0]);
			}

			levelTwo.push(curLevelTwo = []);
			if(!this.isFixed(matrix[i], "fheight")) curLevelOne.push(matrix[i][0][0]);
			else (curLevelOne.nwheight || (curLevelOne.nwheight = [])).push(matrix[i][0][0]);
		}

		for(var i=0;i<levelTwo.length;i++){
			var size = levelTwo[i].length;
			if(size == 0 || size == 1 && matrix[levelTwo[i][0].vpos].length == 1) continue;

			var rule = ["(WT - ", pMargin[3]];
			var nwwidth = levelTwo[i].nwwidth;

			if(nwwidth) for(var j=0;j<nwwidth.length;j++) rule.push(" - ", nwwidth[j].id, ".offsetWidth - ", nwwidth[j].edgeMargin || 0);
			else rule.push(" - ", pMargin[1]);
			
			//alter code to not include the last of the stack if found to be so
			//EXPERIMENTAL size-1
			for(var j=0;j<size-1;j++) if(!levelTwo[i][j].isRight && levelTwo[i][j].edgeMargin) rule.push(" - ", levelTwo[i][j].edgeMargin);
			rule.push(") / ", size);

			//there might be edge problems.. because the span check isn't done untill below

			for(var j=0;j<Math.max(1, size-1);j++){//size - 1; maybe need to do an atleast once check
				if(levelTwo[i][j].span > 1){
					levelTwo[i][j] = matrix[levelTwo[i][j].vpos][levelTwo[i][j].hpos][levelTwo[i][j].stackId+1];
					if(!levelTwo[i][j]) continue;
				}
				if(typeof rule != "string"){
					levelTwo[i][j].fwidth = rule.join("");
					rule = levelTwo[i][j].id + ".offsetWidth";
				}
				else levelTwo[i][j].fwidth = rule;
			}
		}

		for(var i=0;i<levelOne.length;i++){
			var size = levelOne[i].length;
			if(size == 0) continue;

			var rule = ["(HT - ", pMargin[0]];
			var nwheight = levelOne[i].nwheight;
			if(nwheight) for(var j=0;j<nwheight.length;j++) rule.push(" - ", nwheight[j].id, ".offsetHeight - ", nwheight[j].isBottom ? 0 : nwheight[j].edgeMargin || 0);
			
			rule.push(")");
			
			matrix.resultSpace = rule.join("");
			for(var j=0;j<size;j++){
				matrix[levelOne[i][j].vpos].levelSize = 1/size;
			}
		}
		
		for(var i=0;i<levelThree.length;i++){
			var size = levelThree[i].length;
			if(size == 0 || size == 1 && matrix[levelThree[i][0].vpos].length == 1) continue;
			
			var levelHeight = ["dimNulSize * ", matrix[levelThree[i][0].vpos].levelSize];

			var rule = ["((" + levelHeight.join("") + ")"];
			var nwheight = levelThree[i].nwheight;
			if(nwheight){
				for(var j=0;j<nwheight.length;j++){
					rule.push(" - ", nwheight[j].id, ".offsetHeight");
					if(nwheight[j].stackId == 0) continue;
					rule.push(" - ", nwheight[j].edgeMargin || 0);
				}
			}

			if(matrix[levelThree[i][0].vpos+1] && matrix[levelThree[i][0].vpos+1][0][0].edgeMargin)
				rule.push(" - ", matrix[levelThree[i][0].vpos+1][0][0].edgeMargin);
			
			var structSpan = seekNoSpan(matrix[levelThree[i][0].vpos][levelThree[i][0].hpos-1] || []);
			if(structSpan.topSpan) rule.push(" - ", structSpan.topSpan.id, ".offsetHeight - ", structSpan.topSpan.edgeMargin);
			if(structSpan.bottomSpan) rule.push(" - ", structSpan.bottomSpan.id, ".offsetHeight - ", structSpan.bottomSpan.edgeMargin);

			for(var j=0;j<size;j++)
				if(levelThree[i][j].stackId != 0 && levelThree[i][j].edgeMargin) rule.push(" - ", levelThree[i][j].edgeMargin)
			rule.push(") / ", size);

			levelThree[i][0].fheight = rule.join("");
			for(var j=1;j<size;j++) levelThree[i][j].fheight = levelThree[i][0].id + ".offsetHeight";
		}
		
		return false;
	}

	this.compile = function(noapply){
		// var start = new Date().getMilliseconds();
		
		if(!this.parentNode.getAttribute("id")) Kernel.setUniqueHtmlId(this.parentNode);
		
		var hordiff = 0, verdiff = 0;
		if(this.parentNode.tagName.toLowerCase() != "body"){
			var diff = Kernel.compat.getDiff(this.parentNode);
			var verdiff = diff[0];
			var hordiff = diff[1];
		}
		
		var checkResult = this.check();
		if(checkResult) return checkResult;
		
		//start = new Date().getMilliseconds();
		//Loop through matrix
		this.RULES.push("var dimNulSize = " + matrix.resultSpace);
		
		for(var i=0;i<matrix.length;i++){
			for(var j=0;j<matrix[i].length;j++){
				for(var k=0;k<matrix[i][j].length;k++){
					if(matrix[i][j][k]) this.handlePosition(matrix[i][j][k], matrix[i].levelSize);
				}
			}
		}
	
		//if(confirm("debug?")) throw new Error();
		//alert(this.RULES.join("\n"));
		//Sort by checking dependency structure
		this.RULES = new DepTree().calc(this.RULES);
		//alert(this.RULES.join("\n"));
		
		var str = ("try{" + this.RULES.join("}catch(e){}\ntry{") + "}catch(e){}\n").replace(/([^=]+\.style[^=]+) = (.*?)\}/g, "$1 = ($2) + 'px'}");
		str = str.replace(/([\w|]+)\.(offset|style)/g, 'document.getElementById("$1").$2');

		var strParentNodeWidth = (this.parentNode.tagName.toLowerCase() == "body" ? (IS_IE ? "document.documentElement.offsetWidth" : "window.innerWidth") : "document.getElementById('" + this.parentNode.id + "').offsetWidth");
		var strParentNodeHeight = (this.parentNode.tagName.toLowerCase() == "body" ? (IS_IE ? "document.documentElement.offsetHeight" : "window.innerHeight") : "document.getElementById('" + this.parentNode.id + "').offsetHeight");

		str = "var WT = Math.max(" + minWidth + ", " + strParentNodeWidth + " - " + (pMargin[1]) + " - " + hordiff + ");\n"
			 + "var HT = Math.max(" + minHeight + ", " + strParentNodeHeight + " - " + (pMargin[2]) + " - " + verdiff + ");\n"
			 //+ "if(WT == 813) throw new Error();\n"
			 + str;			 
			 //+ "try{" + this.RULES.join("}catch(e){}\ntry{") + "}catch(e){}";

		if(this.parentNode != document.body)
			"if(document.getElementById('" + this.parentNode.id + "').offsetHeight){" + str + "};";

		//Lines below should be straightened out

		//alert(str);
		
		// alert(new Date().getMilliseconds() - start);

		if(!noapply) LayoutServer.setRules(this.parentNode, "layout", str);
		//Set resize function and call it
		/*window.onresize = new Function(str);
		window.onresize();
		alert(str);*/

		return false;
	}
	
	this.addRule = function(rule){
		this.RULES.push(rule);
	}
	
	function seekNoSpan(oStack){
		var info = {};
		for(var i=0;i<oStack.length;i++){
			if(info.noSpan == undefined && oStack[i].span == 1) info.noSpan = oStack[i];
			else if(i == 0 && oStack[i].span == 2) info.topSpan = oStack[i];
			else if(i == oStack.length-1 && oStack[i].span == 2) info.bottomSpan = oStack[i];
			
			else if(oStack[i].span > 2){
				throw new Error(1029, Kernel.formErrorString(1029, null, "Alignment", "Spanning element across more than 2 columns is currently unsupported."));
			}
			
			else if(oStack[i].span > 1){
				throw new Error(1030, Kernel.formErrorString(1030, null, "Alignment", "Spanning element in middle of column is unsupported at this time."));
			}
		}
		
		return info;
	}
	
	this.handlePosition = function(oItem, levelsize){
		var oEl = document.getElementById(oItem.id);

		//Calc horizontal and vertical difference
		var diff = Kernel.compat.getDiff(oEl);
		var verdiff = diff[1];
		var hordiff = diff[0];
		
		var vtop = [oItem.id, ".style.top = "];
		var vleft = [oItem.id, ".style.left = "];
		var vwidth = [oItem.id, ".style.width = -" + hordiff + " + Math.max( "];
		var vheight = [oItem.id, ".style.height = -" + verdiff + " + Math.max( "];
		var oLastSame = oItem.column[oItem.stackId - 1];
		var oNextSame = oItem.column[oItem.stackId + 1];
		var oFirstLeft, oFirstBottom, oFirstTop, oLeftStack = oItem.hpos == 0 ? false : oItem.matrix[oItem.vpos][oItem.hpos-1];
		if(oLeftStack){
			var info = seekNoSpan(oLeftStack);
			oFirstLeft = info.noSpan;
			oFirstTop = info.topSpan;
			oFirstBottom = info.bottomSpan;
		}
		
		if(!oFirstTop) oFirstTop = oItem.vpos == 0 ? false : oItem.matrix[oItem.vpos-1][0][oItem.matrix[oItem.vpos-1][0].length-1];
		if(!oFirstBottom) oFirstBottom = oNextSame ? oNextSame : (oItem.vpos == oItem.matrix.length-1 ? false : oItem.matrix[oItem.vpos+1][0][0]);
		var oFirstRight = oItem.hpos == oItem.matrix[oItem.vpos].length - oItem.span ? false : oItem.matrix[oItem.vpos][oItem.hpos+parseInt(oItem.span)][0];
		var hasTop = oLastSame || oFirstTop || oItem.isBottom ? true : false;
		var hasLeft = oFirstLeft || oItem.isRight && oItem.fwidth || oLastSame ? true : false;
		
		//TOP
		if(hasTop){
			//Optimization: set top of last fixed height item based on bottom
			//[THIS MAY BE REMOVED]
			//if(!oNextSame && oLastSame && !oLastSame.fheight && oItem.fheight && !oItem.isBottom) vtop.push(oFirstBottom ? oFirstBottom.id + ".offsetTop" : "HT", " - ", oItem.id, ".offsetHeight - ", oItem.edgeMargin);
			
			//else 
			
			//this is not good because of alignment (bottom vs top)
			//n.b. could be used for optimization by comparing .isBottom
			//if(!oLastSame && oFirstLeft) vtop.push(oFirstLeft.id, ".offsetTop");
			//else 

			//Set top based on stacked sibling (previous)
			if(oLastSame && !oItem.isBottom) vtop.push(oLastSame.id, ".offsetTop + ", oLastSame.id, ".offsetHeight", " + ", oItem.edgeMargin);
			
			//Bottom attachment
			else if(oItem.isBottom ){//|| (oFirstTop && !oFirstTop.fheight)){
				if(oFirstBottom) vtop.push(oFirstBottom.id, ".offsetTop - ", oFirstBottom.edgeMargin, " - ", oItem.id, ".offsetHeight");
				else vtop.push("HT - ", oItem.id, ".offsetHeight");
			}
			
			//Set top based on the bottom of last level
			else if(oFirstTop){
				vtop.push(oFirstTop.id, ".offsetTop + ", oFirstTop.id, ".offsetHeight + ", oFirstTop.edgeMargin);
			}
		}
		//Top most row of widgets (+ margin)
		else oEl.style.top = (pMargin[0] || 0) + "px";
		
		//HEIGHT
		if(!oItem.fheight){
			//Set height based on next stacked and set top
			if(oNextSame) vheight.push(oNextSame.id, ".offsetTop - ", oItem.id, ".offsetTop - ", oNextSame.edgeMargin);
			
			else{
				//Set the difficult point of edgemargin...
				vheight.push("dimNulSize * ", levelsize, " - ", !oFirstRight && !oFirstLeft && oFirstBottom ? oFirstBottom.edgeMargin : (oFirstLeft && oFirstBottom ? oFirstBottom.edgeMargin || oItem.edgeMargin : 0));
			}
		}
		//Set fixed height
		else{
			if(oItem.fheight.match(/\%/)) vheight.push("(HT - ", pMargin[0], ") * ", (parseFloat(oItem.fheight)/100));
			else if(parseInt(oItem.fheight) != oItem.fheight) vheight.push(oItem.fheight);
			else oEl.style.height = Math.max(0, oItem.fheight - verdiff) + "px";
		}
	
		//LEFT	
		if(hasLeft){
			//Right attachment
			if(oItem.isRight){
				// || (oFirstLeft && !oFirstLeft.fwidth)){
				if(oFirstRight) vleft.push(oFirstRight.id, ".offsetLeft - ", oFirstRight.edgeMargin, " - ", oItem.id, ".offsetWidth");
				else vleft.push("WT - ", oItem.id, ".offsetWidth", null);
			}
			
			else if(oLastSame) vleft.push(oLastSame.id, ".offsetLeft");
			
			else if(oFirstLeft) vleft.push(oFirstLeft.id, ".offsetLeft + ", oFirstLeft.id, ".offsetWidth + ", oFirstLeft.edgeMargin);
		}
		else oEl.style.left = (pMargin[3] || 0) + "px";
		
		//WIDTH
		if(!oItem.fwidth){
			//if(oLastSame && oItem.span == 1 && oLastSame.span == 1) vwidth.push(oLastSame.id, ".offsetWidth");
			
			//Set width based on current left and right object
			//else 
			
			if(oFirstRight) vwidth.push(oFirstRight.id, ".offsetLeft - ", oItem.id, ".offsetLeft - ", oItem.edgeMargin || oFirstRight.edgeMargin);
			
			//Set width based on left object and edge
			else if(oFirstLeft) vwidth.push("WT - ", oFirstLeft.id, ".offsetWidth - ", oFirstLeft.id, ".offsetLeft - ", oItem.edgeMargin || oFirstLeft.edgeMargin);//oItem.isRight && oFirstLeft ? oFirstLeft.edgeMargin : 
			
			//Set width to the full right
			else vwidth.push("WT - ", oItem.id, ".offsetLeft");
		}
		//Set fixed width
		else{
			if(oItem.fwidth.match(/\%/)) vwidth.push("(WT - ", pMargin[1], ") * ", (parseFloat(oItem.fwidth)/100));
			else if(parseInt(oItem.fwidth) != oItem.fwidth) vwidth.push(oItem.fwidth);
			else oEl.style.width = Math.max(0, oItem.fwidth - hordiff) + "px";
		}
		
		/*** Record Rules ***/
		if(vleft.length > 2) this.addRule(vleft.join(""));
		if(vtop.length > 2) this.addRule(vtop.join(""));
		if(vwidth.length > 2){
			vwidth.push(" , ", oItem.minwidth, ")");
			this.addRule(vwidth.join(""));
		}
		if(vheight.length > 2){
			vheight.push(" , ", oItem.minheight, ")");
			this.addRule(vheight.join(""));
		}
	}
	
	function DepTree(){
		this.parselookup = {};
		this.nRules = [];
		this.doneRules = {};
	
		this.maskText = function(str, m1, m2, m3){
			return m1 + ".offset" + m2.toUpperCase();
		}
		
		this.handleVar = function(match, m1, m2, m3){
			var vname = "a" + m1.replace(/\|/g, "_") + "_style_" + m2.toLowerCase();
			return knownVars[vname] ? vname : match;
		}
		
		this.parseRule = function(rule){
			var aRule = rule.split(" = ");
			var id = aRule[0].replace(/^([_\w\d\|]+)\.style\.(\w)/, this.maskText);
			var vname = "a" + aRule[0].replace(/[\.\|]/g, "_");
			knownVars[vname] = true;
	
			var depsearch = aRule[1].split(/[ \(\)]/);// " "
			var deps = [];
			for(var i=0;i<depsearch.length;i++){
				if(depsearch[i].match(/^([_\w\d\|]+)\.offset(\w+)$/) && !depsearch[i].match(/PNODE/)){
					deps.push(depsearch[i]);
				}
			}

			if(vname.match(/width|height/i)){
				aRule[1] = aRule[1].replace(/^(\s*[\-\d]+[\s\-\+]+)/, "");
				ruleB = aRule[0] + " = " + RegExp.$1 + vname;
			}
			else ruleB = aRule[0] + " = " + vname;

			return {
				id : id,
				rule_p1 : "var " + vname + " = ",
				rule_p2 : aRule[1],
				ruleb	: ruleB,
				deps : deps,
				processed : false
			};
		}
		
		this.calc = function(aRules){
			var str = "";
			for(var i=0;i<aRules.length;i++){
				if(aRules[i].match(/^var/)){
					this.nRules.push(aRules[i]);
					continue;
				}
				var o = this.parseRule(aRules[i], i);
				this.parselookup[o.id] = o;
			}

			//build tree
			for(prop in this.parselookup){
				if(
					typeof prop != "string" || 
					!this.parselookup[prop] || 
					typeof this.parselookup[prop] == "boolean" || 
					typeof this.parselookup[prop] == "function"
				) continue;
				
				this.processNode(this.parselookup[prop]);
			}
			
			//Walk Tree
			for(prop in this.parselookup){
				if(
					typeof prop != "string" || 
					!this.parselookup[prop] || 
					typeof this.parselookup[prop] == "boolean" || 
					typeof this.parselookup[prop] == "function"
				) continue;
				var root = this.parselookup[prop];
				//if(root.processed) continue;
				this.walkRules(root);
			}

			//Set last rules
			for(prop in this.parselookup){
				if(
					typeof prop != "string" || 
					!this.parselookup[prop] || 
					typeof this.parselookup[prop] == "boolean" || 
					typeof this.parselookup[prop] == "function"
				) continue;
				
				this.nRules.push(this.parselookup[prop].ruleb);
			}

			return this.nRules;
		}
		
		this.str = "";
		this.walkRules = function(root){
			if(this.doneRules[root.id]) return;

			for(var i=0;i<root.deps.length;i++){
				if(root.deps[i] && !root.deps[i].walked && !this.doneRules[root.deps[i].id]){
					root.deps[i].walked = true;
					this.walkRules(root.deps[i]);
				}
			}
	
			this.doneRules[root.id] = true;
			this.nRules.push(root.rule_p1 + root.rule_p2.replace(/([_\w\d\|]+)\.offset(\w+)/g, this.handleVar));
		}
		
		this.processNode = function(o){
			for(var i=0;i<o.deps.length;i++){
				var l = typeof o.deps[i] == "string" ? this.parselookup[o.deps[i]] : o.deps[i];
				if(!l){
					o.deps[i] = null;
					continue;
				}

				o.deps[i] = l;//.copy();
				if(!l.processed){
					l.processed = true;
					this.processNode(l);
				}
			}
		}
	}
}
/*FILEHEAD(/in/Core/Application/Model.js)SIZE(10724)TIME(1186393727279)*/

function Model(data, caching){
	Kernel.makeClass(this);
	this.data = data;

	this.caching = caching;
	this.cache = {};
	
	setStatus("Creating Model");
	
	var jmlNodes = {};
	this.register = function(jmlNode, xpath){
		if(!jmlNode) return this;
		jmlNodes[jmlNode.uniqueId] = [jmlNode, xpath];
		jmlNode.model = this;
		//if(!jmlNode.smartBinding) return this; //Setting model too soon causes object not to have XMLRoot which is incorrect
		
		if(this.connect){
			//This model is a connect proxy
			if(this.connect.type) this.connect.node.connect(jmlNode, null, this.connect.select, this.connect.type);
			else this.connect.node.connect(jmlNode, true, this.connect.select);
		}
		else{
			jmlNode.model = this;
			if(this.data) jmlNode.load(xpath ? this.data.selectSingleNode(xpath) : this.data);
		}
		
		return this;
	}
	this.unregister = function(jmlNode){
		if(this.connect)
			this.connect.node.disconnect(jmlNode);
		
		delete jmlNodes[jmlNode.uniqueId]
	}
	
	//Only when model is a connect proxy
	this.setConnection = function(jmlNode, type, select){
		var uniqueId, oldNode = this.connect.node;
		
		this.connect.type = type;
		this.connect.node = node;
		this.connect.select = select;
		
		for(uniqueId in jmlNodes){
			oldNode.disconnect(jmlNodes[uniqueId][0]);
			this.register(jmlNodes[uniqueId][0]);
		}
	}
	
	this.toString = function(){
		return this.data ? formatXML(XMLDatabase.clearConnections(this.data.cloneNode(true)).xml) : "Model has no data.";
	}
	
	this.getXml = function(){
		return this.data ? XMLDatabase.clearConnections(this.data.cloneNode(true)) : false;
	}
	
	/******* PARSE ***********/
	var lastDataNode;
	this.parse = function(dataNode, file, connect, type, select, saveoriginal){
		/*
			- <j:Model file="" />
			- <j:Model rpc="" arguments="" />
			- <j:Model connect="component" type="select" xpath="" />
			- <j:Model><Data /></j:Model>
		*/
		
		lastDataNode = dataNode;
		
		if(saveoriginal || dataNode && dataNode.getAttribute("save-original") == "true")
			this.keepCopy = true;
		
		if(dataNode && dataNode.getAttribute("onreceive")) 
			this.onreceive = new Function(dataNode.getAttribute("onreceive"));
		
		//Load from File
		if(file || dataNode && dataNode.getAttribute("file"))
			this.loadFile(file || dataNode.getAttribute("file"));

		//Connect to existing client side source
		else if(connect || dataNode && dataNode.getAttribute("connect")){
			try{eval(connect || dataNode.getAttribute("connect")).test}catch(e){
				throw new Error(1031, Kernel.formErrorString(1031, null, "Model Creation", "Could not find object reference to connect databinding: '" + (connect || dataNode.getAttribute("connect")) + "'", dataNode))
			}

			this.connect = {
				node : eval(connect || dataNode && dataNode.getAttribute("connect")),
				type : type || dataNode && dataNode.getAttribute("type"),
				select : select || dataNode && dataNode.getAttribute("select")
			};
		}
		
		else if(dataNode && dataNode.getAttribute("eval")){
			this.load(eval(dataNode.getAttribute("eval")));
		}

		else{
			//Communication modules
			if(dataNode.getAttribute("initrpc") != "false" && Kernel.TelePort.hasLoadRule(dataNode))
				this.loadComm(dataNode, null);

			//Connect from JML defined source
			if(dataNode.childNodes.length)
				this.load((dataNode.xml || dataNode.serialize()).replace(/^<(?:j:){0,1}model[^>]*>/, "").replace(/<\/(?:j:){0,1}model[^>]*>$/, ""));
		}
		
		return this;
	}
	
	this.initComm = function(){
		if(Kernel.TelePort.hasLoadRule(lastDataNode))
			this.loadComm(lastDataNode, null);
	}
	
	/********* LOADRPC ***********
		Loads data via an RPC call

		INTERFACE:
		this.loadComm(obj, method, args, cacheID);
	****************************/
	this.loadComm = function(xmlRPCNode, xmlNode){
		var oModel = this;
		this.dispatchEvent("onbeforecomm");
		
		Kernel.TelePort.callMethodFromNode(xmlRPCNode, xmlNode, function(xmlData, state, extra){
			oModel.dispatchEvent("onaftercomm");
			
			if(state != __HTTP_SUCCESS__){
				if(state == __HTTP_TIMEOUT__ && extra.retries < MAX_JAV_RETRIES) return extra.tpModule.retry(extra.id);
				else throw new Error(1032, Kernel.formErrorString(1032, null, "Loading xml Data", "Could not load data using RPC for model " + oModel.name + " [Model] \nUrl: " + extra.url + "\nInfo: " + extra.message, xmlRPCNode))
			}
			
			oModel.load(xmlData);
			if(oModel.onreceive) oModel.onreceive(xmlData);
		});
	}

	/********* LOADFILE ***********
		Loads data from a file

		INTERFACE:
		this.loadFile(filename);
	****************************/
	this.loadFile = function(filename){
		var oModel = this;
		new HTTP().get(filename, function(xmlData, state, extra){
			if(state != __HTTP_SUCCESS__){
				if(state == __HTTP_TIMEOUT__ && extra.retries < MAX_JAV_RETRIES) return extra.tpModule.retry(extra.id);
				else throw new Error(1033, Kernel.formErrorString(1033, null, "Load xml data", "Could not load data using HTTP for control " + oModel.name + " [Model] \nUrl: " + extra.url + "\nInfo: " + extra.message));
			}
			
			oModel.load(xmlData);
			if(oModel.onreceive) oModel.onreceive(xmlData);
		});
	}

	this.setByXPath = function( xpath, value ){
		var node = this.data.selectSingleNode(xpath); if(!node)return null;
		XMLDatabase.setTextNode(node,value);
		return node;
	}
	
	this.getByXPath = function (xpath ){
		return getXMLValue(this.data, xpath );
	}
	
	this.getNodeByXpath = function(xpath, single){
		return single ? this.data.selectSingleNode(xpath) : this.data.selectNodes(xpath);
	}

	/********* LOADJAV ***********
		Loads data from a javeline resource jav://

		INTERFACE:
		this.loadJav(resource_path);
	****************************/
	this.loadJav = function(filename, jmlNode){
		var fsNode = jdfs.getChild(filename);
		if(!fsNode) throw new Error(0, "Resource does not exists: " + filename);

		//redo this
		this.load(fsNode.data);
	}
	
	this.clear = function(){
		this.load(null);
	}
	
	this.load = function(xmlNode, nocopy){
		if(this.dispatchEvent("onbeforeload") === false) return false;
		
		if(typeof xmlNode == "string")
			var xmlNode = Kernel.getObject("XMLDOM", xmlNode).documentElement;
			
		if(xmlNode){
			XMLDatabase.nodeConnect(XMLDatabase.getXmlDocId(xmlNode, this), xmlNode, null, this);
			if(!nocopy && this.keepCopy) this.copy = xmlNode.cloneNode(true);
		}
		this.data = xmlNode;
		
		var uniqueId;
		for(uniqueId in jmlNodes){
			if(!jmlNodes[uniqueId] || !jmlNodes[uniqueId][0]) continue;

			var xmlNode = this.data ? (jmlNodes[uniqueId][1] ? this.data.selectSingleNode(jmlNodes[uniqueId][1]) : this.data) : null;
			jmlNodes[uniqueId][0].load(xmlNode);
		}
		
		this.dispatchEvent("onafterload");
	}
	
	this.reloadJmlNode = function(uniqueId){
		if(!this.data) return;
		var xmlNode = jmlNodes[uniqueId][1] ? this.data.selectSingleNode(jmlNodes[uniqueId][1]) : this.data;
		jmlNodes[uniqueId][0].load(xmlNode);
	}
	
	this.reset = function(){
		this.load(this.copy);
	}
	
	this.savePoint = function(){
		this.copy = this.data.cloneNode(true);
	}
	
	this.extend = function(rule, jmlNode, loadNode){
		var iOptions = [rule.getAttribute("result-select"), rule.getAttribute("result-clean") == "true"];
		
		if(rule.getAttribute("file")){
			var url, xmlNode = loadNode;

			if(rule.getAttribute("method")) url = self[rule.getAttribute("method")](loadNode);
			if(rule.getAttribute("eval")) url = eval(rule.getAttribute("eval"));
			else url = rule.getAttribute("file");

			if(url) this.insertFile(url, xmlNode, null, iOptions);
			else return false;
		}
		else if(rule.getAttribute("method"))
			this.insert(self[rule.getAttribute("method")](loadNode), loadNode);

		// Communication
		else if(Kernel.TelePort.hasLoadRule(rule))
			this.insertComm(rule, loadNode, loadNode, null, iOptions);
	}
	
	/********* INSERTRPC ***********
		Load XMLTree from RPC Source and Integrate into existing Tree

		INTERFACE:
		this.insertComm(obj, method, args, parentXMLNode);
	****************************/
	this.insertRPC = 
	this.insertComm = function(xmlCommNode, xmlNode, parentXMLNode, jmlNode, iOptions){
		var oModel = this;
		this.dispatchEvent("onbeforecomm");

		Kernel.TelePort.callMethodFromNode(xmlCommNode, xmlNode, function(xmlData, state, extra){
			oModel.dispatchEvent("onaftercomm");
			
			if(state != __HTTP_SUCCESS__){
				if(state == __HTTP_TIMEOUT__ && extra.retries < MAX_JAV_RETRIES) return extra.tpModule.retry(extra.id);
				else throw new Error(1032, Kernel.formErrorString(1032, null, "Loading xml data", "Could not insert data using RPC for control " + this.name + "[" + this.tagName + "] \nUrl: " + extra.url + "\nInfo: " + extra.message + "\n\n" + xmlData));
			}
			
			(jmlNode || oModel).insert(xmlData, parentXMLNode, iOptions);
		});
	}

	/********* INSERTFILE ***********
		Load XMLTree from HTTP Source and Integrate into existing Tree

		INTERFACE:
		this.insertFile(filename, parentXMLNode);
	****************************/
	this.insertFile = function(filename, parentXMLNode, jmlNode, iOptions){
		var oModel = this;
		
		new HTTP().get(filename, function(xmlData, state, extra){
			if(state != __HTTP_SUCCESS__){
				if(state == __HTTP_TIMEOUT__ && extra.retries < MAX_JAV_RETRIES) return extra.tpModule.retry(extra.id);
				else throw new Error(1034, Kernel.formErrorString(1034, null, "Loading xml data", "Could not insert data from http resource for control " + this.name + "[" + this.tagName + "] \nUrl: " + extra.url + "\nInfo: " + extra.message));
			}
			
			(jmlNode || oModel).insert(xmlData, parentXMLNode, iOptions);
		});
	}
	
	this.insert = function(XMLRoot, parentXMLNode, iOptions){
		if(typeof XMLRoot != "object") XMLRoot = Kernel.getObject("XMLDOM", XMLRoot).documentElement;
		if(!parentXMLNode) parentXMLNode = this.data;
		if(iOptions[0]) XMLRoot = XMLRoot.selectSingleNode(iOptions[0]);
		if(iOptions[1]){
			//clean parent
			var nodes = parentXMLNode.childNodes;
			for(var i=nodes.length-1;i>=0;i--) parentXMLNode.removeChild(nodes[i]);
		}
				
		//if(this.dispatchEvent("onbeforeinsert", parentXMLNode) === false) return false;
		
		//Integrate XMLTree with parentNode
		var newNode = XMLDatabase.integrate(XMLRoot, parentXMLNode, true);

		//Call __XMLUpdate on all listeners
		XMLDatabase.applyChanges("insert", parentXMLNode);
		
		//this.dispatchEvent("onafterinsert");
		
		return XMLRoot;
	}
}



/*FILEHEAD(/in/Core/Application/Scrollbar.js)SIZE(6987)TIME(1182723583203)*/

function Scrollbar(){
	var SCROLLVALUE = 0;
	var STEPVALUE = 0.03;
	var BIGSTEPVALUE = 0.1;
	var CURVALUE = 0;
	var TIMER = null;
	var SCROLLWAIT;
	var SLIDEMAXHEIGHT;
	
	var offsetName = IS_IE ? "offset" : "layer";
	
	//Init Class
	var uniqueId = this.uniqueId = Kernel.all.push(this) - 1;
	Kernel.makeClass(this);
	
	//Init Skin
	this.inherit(Presentation);
	if(this.loadSkin) this.loadSkin("default:Scrollbar");
	
	//Init DragDrop mode
	Kernel.DragMode.defineMode("scrollbar" + this.uniqueId, this);
	
	//Build Skin
	this.__getNewContext("Main");
	this.oExt = XMLDatabase.htmlImport(this.__getLayoutNode("Main"), document.body);
	this.oExt.host = this;
	this.oExt.style.display = "none";
	
	var MAIN = this.oExt;
	var INDICATOR = this.__getLayoutNode("Main", "indicator", this.oExt);
	var SLIDEFAST = this.__getLayoutNode("Main", "slidefast", this.oExt);
	var BTNUP = BTN = this.__getLayoutNode("Main", "btnup", this.oExt)
	var BTNDOWN = this.__getLayoutNode("Main", "btndown", this.oExt);
	var STARTPOS = false;
	var TIMER;
	
	INDICATOR.ondragstart = function(){return false}
	
	//document.getElementById('btnup').ondblclick = 
	BTNUP.onmousedown = function(e){
		if(!e) e = event;
		this.className = "btnup btnupdown";
		clearTimeout(TIMER);
		
		CURVALUE -= STEPVALUE;
		setScroll();
		e.cancelBubble = true;
		
		TIMER = setTimeout(function(){
			TIMER = setInterval(function(){
				CURVALUE -= STEPVALUE;
				Kernel.lookup(uniqueId).setScroll();
			}, 20);
		}, 300);
	}
	
	//document.getElementById('btndown').ondblclick = 
	BTNDOWN.onmousedown = function(e){
		if(!e) e = event;
		this.className = "btndown btndowndown";
		clearTimeout(TIMER);

		CURVALUE += STEPVALUE;
		setScroll();
		e.cancelBubble = true;
		
		TIMER = setTimeout(function(){
			TIMER = setInterval(function(){
				CURVALUE += STEPVALUE;
				Kernel.lookup(uniqueId).setScroll();
			}, 20);
		}, 300);
	}
	
	BTNUP.onmouseout = 
	BTNUP.onmouseup = function(){
		this.className = "btnup";
		clearInterval(TIMER);
	}
	
	BTNDOWN.onmouseout = 
	BTNDOWN.onmouseup = function(){
		this.className = "btndown";
		clearInterval(TIMER);
	}
	
	INDICATOR.onmousedown = function(e){
		if(!e) e = event;
		STARTPOS = [e[offsetName + "X"], e[offsetName + "Y"] + BTN.offsetHeight];
		
		Kernel.DragMode.setMode("scrollbar" + uniqueId);
		
		e.cancelBubble = true;
		return false;
	}
	
	MAIN.onmousedown = function(e){
		if(!e) e = event;
		clearInterval(TIMER);

		if(e[offsetName + "Y"] > INDICATOR.offsetTop + INDICATOR.offsetHeight){
			CURVALUE += BIGSTEPVALUE;
			setScroll();
			
			SLIDEFAST.style.display = "block";
			SLIDEFAST.style.top = (INDICATOR.offsetTop + INDICATOR.offsetHeight) + "px";
			SLIDEFAST.style.height = (MAIN.offsetHeight - SLIDEFAST.offsetTop - BTN.offsetHeight) + "px";
			
			var offset = e[offsetName + "Y"];
			TIMER = setTimeout(function(){
				TIMER = setInterval(function(){
					Kernel.lookup(uniqueId).scrollDown(offset);
				}, 20);
			}, 300);
		}
		else if(e[offsetName + "Y"] < INDICATOR.offsetTop){
			CURVALUE -= BIGSTEPVALUE;
			setScroll();
			
			SLIDEFAST.style.display = "block";
			SLIDEFAST.style.top = BTN.offsetHeight + "px";
			SLIDEFAST.style.height = (INDICATOR.offsetTop - BTN.offsetHeight) + "px";
			
			var offset = e[offsetName + "Y"];
			TIMER = setTimeout(function(){
				TIMER = setInterval(function(){
					Kernel.lookup(uniqueId).scrollUp(offset);
				}, 20);
			}, 300);
		}
	}
	
	MAIN.onmouseup = function(){
		clearInterval(TIMER);
		SLIDEFAST.style.display = "none";
	}
	
	this.onmousemove = function(e){
		if(!e) e = event;
		//if(e.button != 1) return this.onmouseup();
		if(!STARTPOS) return false;
		
		var next = BTN.offsetHeight + (e.clientY - STARTPOS[1] - Kernel.compat.getAbsolutePosition(MAIN)[1] - BTN.offsetHeight/3);
		var min = BTN.offsetHeight;
		if(next < min) next = min;
		var max = (MAIN.offsetHeight - (BTN.offsetHeight) - INDICATOR.offsetHeight);
		if(next > max) next = max;
		//INDICATOR.style.top = next + "px"
		
		CURVALUE = (next-min) / (max - min);
		setTimeout(function(){setScroll(true);});
	}
	
	this.onmouseup = function(){
		STARTPOS = false;
		Kernel.DragMode.clear();
	}
	
	var LIST, onscroll, viewheight, scrollheight;
	this.attach = function(o, v, s, scroll_func){
		LIST = o;
		onscroll = scroll_func;
		viewheight = v;
		scrollheight = s;
		
		o.parentNode.appendChild(this.oExt);
		this.oExt.style.display = "block";
		
		this.oExt.style.left = "166px";//(o.offsetLeft + o.offsetWidth) + "px";
		this.oExt.style.top = "24px";//o.offsetTop + "px";
		this.oExt.style.height = "160px";//o.offsetHeight + "px";
		
		LIST.onmousewheel = function(e){
			if(!e) e = event;
			CURVALUE += ((IS_OPERA ? 1 : -1) * (e.wheelDelta/120) * STEPVALUE);
			setScroll(true);
		}
		
		SCROLLWAIT = 0;//(LIST.len * COLS)/2;
		SLIDEMAXHEIGHT = MAIN.offsetHeight - BTNDOWN.offsetHeight - BTNUP.offsetHeight;
		STEPVALUE = (viewheight/scrollheight)/5;
		BIGSTEPVALUE = STEPVALUE * 3;
		
		INDICATOR.style.height = Math.max(5, ((viewheight/scrollheight) * SLIDEMAXHEIGHT)) + "px";
		if(INDICATOR.offsetHeight-4 == SLIDEMAXHEIGHT) MAIN.style.display = "none";
	}
	
	function onscroll(timed, perc){
		LIST.scrollTop = (LIST.scrollHeight-LIST.offsetHeight+4) * CURVALUE;
		/*var now = new Date().getTime();
		if(timed && now - LIST.last < (timed ? SCROLLWAIT : 0)) return;
		LIST.last = now;
		
		var value = parseInt((DATA.length-LIST.len+1) * CURVALUE);
		showData(value);*/
	}
	
	var jmlNode = this;
	function setScroll(timed, no_event){
		if(CURVALUE > 1) CURVALUE = 1;
		if(CURVALUE < 0) CURVALUE = 0;
		INDICATOR.style.top = (BTN.offsetHeight + (MAIN.offsetHeight - (BTN.offsetHeight*2) - INDICATOR.offsetHeight) * CURVALUE) + "px";
		
		//status = CURVALUE;
		jmlNode.pos = CURVALUE;//(INDICATOR.offsetTop-BTNUP.offsetHeight)/(SLIDEMAXHEIGHT-INDICATOR.offsetHeight);
		if(!no_event) onscroll(timed, jmlNode.pos);
	}
	this.setScroll = setScroll;
	
	function scrollUp(v){
		if(v > INDICATOR.offsetTop) return MAIN.onmouseup();
		CURVALUE -= BIGSTEPVALUE;setScroll();
		
		SLIDEFAST.style.height = Math.max(1, INDICATOR.offsetTop - BTN.offsetHeight) + "px";
		SLIDEFAST.style.top = BTN.offsetHeight + "px";
	}
	this.scrollUp = scrollUp;
	
	function scrollDown(v){
		if(v < INDICATOR.offsetTop + INDICATOR.offsetHeight) return MAIN.onmouseup();
		CURVALUE += BIGSTEPVALUE;setScroll();
		
		SLIDEFAST.style.top = (INDICATOR.offsetTop + INDICATOR.offsetHeight) + "px";
		SLIDEFAST.style.height = Math.max(1, MAIN.offsetHeight - SLIDEFAST.offsetTop - BTN.offsetHeight) + "px";
	}
	this.scrollDown = scrollDown;
	
	this.getPosition = function(){
		return this.pos;
	}
	
	this.setPosition = function(pos, no_event){
		CURVALUE = pos;
		setScroll(null, no_event);
	}
}


/*FILEHEAD(/in/Core/Application/SmartBinding.js)SIZE(6307)TIME(1177277319193)*/

NameServer = {
	lookup : {},
	register : function(type, id, xmlNode){
		if(!this.lookup[type]) this.lookup[type] = {};
		this.lookup[type][id] = xmlNode;
		
		return xmlNode;
	},
	get : function(type, id){
		return this.lookup[type] ? this.lookup[type][id] : null;
	}
}

function SmartBinding(name, xmlNode){
	this.xmlbindings = null;
	this.xmlactions = null;
	this.xmldragdrop = null;
	this.bindings = null;
	this.actions = null;
	this.dragdrop = null;

	this.jmlNodes = {};
	this.modelXpath = {};
	this.name = name;

	var parts = {bindings:'loadBindings',actions:'loadActions',dragdrop:'loadDragDrop'}
	
	setStatus(name ? "Creating SmartBinding [" + name + "]" : "Creating implicitly assigned SmartBinding");
	
	this.load = function(xmlNode){
		var uniqueId;
		this.model = XMLDatabase.getBindXmlNode(xmlNode);//xmlNode;//unserialize here
		
		for(uniqueId in this.jmlNodes){
			this.jmlNodes[uniqueId].load(this.model);
		}
	}
	
	this.initialize = function(jmlNode, part){
		//register element
		this.jmlNodes[jmlNode.uniqueId] = jmlNode;
		
		if(part)
			return jmlNode[parts[part]](this[part], this["xml" + part]);
		
		if(jmlNode.jml && this.name) 
			jmlNode.jml.setAttribute("smartbinding", this.name);
		
		for(part in parts){
			if(typeof parts[part] != "string") continue;
			if(!this[part]) continue;

			if(!jmlNode[parts[part]]) throw new Error(1035, Kernel.formErrorString(1035, jmlNode, "initialize method in SmartBindings object", "Could not find handler for '" + part + "'."));
			jmlNode[parts[part]](this[part], this["xml" + part]);
		}
		
		if(this.model)
			this.model.register(jmlNode, this.modelXpath[jmlNode.getHost ? jmlNode.getHost().uniqueId : jmlNode.uniqueId] || this.modelBaseXpath); //this is a hack.. by making MOdels with links to other models possible, this should not be needed
		else if(jmlNode.model)
			jmlNode.model.reloadJmlNode(jmlNode.uniqueId);//.load(jmlNode.model.data.selectSingleNode("Accounts/Account[1]"));
	}
	
	this.deinitialize = function(jmlNode){
		//unregister element
		this.jmlNodes[jmlNode.uniqueId] = null;
		delete this.jmlNodes[jmlNode.uniqueId];
		
		if(this.model)
			this.model.unregister(jmlNode);
	}
	
	this.addBindRule = function(xmlNode, jmlParent){
		var str = xmlNode[TAGNAME] == "bind" ? jmlParent ? jmlParent.mainBind : "Value" : xmlNode.tagName;
		if(!this.bindings) this.bindings = {};
		if(!this.bindings[str]) this.bindings[str] = [xmlNode];
		else this.bindings[str].push(xmlNode);
	}
	
	this.addBindings = function(rules){
		this.bindings = rules;//Kernel.getRules(xmlNode);
		this.xmlbindings = xmlNode;
	}
	
	this.addActionRule = function(xmlNode){
		var str = xmlNode[TAGNAME] == "action" ? "Change" : xmlNode.tagName;
		if(!this.actions) this.actions = {};
		if(!this.actions[str]) this.actions[str] = [xmlNode];
		else this.actions[str].push(xmlNode);
	}
	
	this.addActions = function(rules, xmlNode){
		this.actions = rules;//Kernel.getRules(xmlNode);
		this.xmlactions = xmlNode;
	}
	
	this.addDropRule = 
	this.addDragRule = function(xmlNode){
		if(!this.dragdrop) this.dragdrop = {};
		if(!this.dragdrop[xmlNode[TAGNAME]]) this.dragdrop[xmlNode[TAGNAME]] = [xmlNode];
		else this.dragdrop[xmlNode[TAGNAME]].push(xmlNode);
	}
	
	this.addDragDrop = function(rules, xmlNode){
		this.dragdrop = rules;//Kernel.getRules(xmlNode);
		this.xmldragdrop = xmlNode;
	}
	
	this.construct = function(xmlNode){
		//Bindings
		if(xmlNode.getAttribute("bindings")){
			if(!NameServer.get("bindings", xmlNode.getAttribute("bindings")))
				throw new Error(1036, Kernel.formErrorString(1036, this, "Connecting bindings", "Could not find bindings by name '" + xmlNode.getAttribute("bindings") + "'"));
			
			var cNode = NameServer.get("bindings", xmlNode.getAttribute("bindings"));
			this.addBindings(Kernel.getRules(cNode), cNode);
		}
		
		//Actions
		if(xmlNode.getAttribute("actions")){
			if(!NameServer.get("actions", xmlNode.getAttribute("actions")))
				throw new Error(1037, Kernel.formErrorString(1037, this, "Connecting bindings", "Could not find actions by name '" + xmlNode.getAttribute("actions") + "'"));
			
			var cNode = NameServer.get("actions", xmlNode.getAttribute("actions"));
			this.addActions(Kernel.getRules(cNode), cNode);
		}
		
		//DragDrop
		if(xmlNode.getAttribute("dragdrop")){
			if(!NameServer.get("dragdrop", xmlNode.getAttribute("dragdrop")))
				throw new Error(1038, Kernel.formErrorString(1038, this, "Connecting dragdrop", "Could not find dragdrop by name '" + xmlNode.getAttribute("dragdrop") + "'"));
			
			var cNode = NameServer.get("dragdrop", xmlNode.getAttribute("dragdrop"));
			this.addDragDrop(Kernel.getRules(cNode), cNode);
		}
		
		var data_node, nodes = xmlNode.childNodes;
		for(var i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1) continue;
	
			switch(nodes[i][TAGNAME]){ //tagName fireFox???
				case "model": data_node = nodes[i]; break;
				case "bindings": this.addBindings(Kernel.getRules(nodes[i]), nodes[i]); break;
				case "actions": this.addActions(Kernel.getRules(nodes[i]), nodes[i]); break;
				case "dragdrop": this.addDragDrop(Kernel.getRules(nodes[i]), nodes[i]); break;
				case "bind": this.addBindRule(nodes[i]); break;
				case "action": this.addActionRule(nodes[i]); break;
				default:
					//throw new Error(1039, Kernel.formErrorString(1039, this, "setBindClass Method", "Could not find handler for '" + nodes[i].tagName + "' node."));
					//when an unknown found assume that this is an implicit bindings node
					this.addBindings(Kernel.getRules(xmlNode)); 
					break;
			}
		}
		
		if(data_node)
			this.model = NameServer.register("model", xmlNode.getAttribute("id"), new Model().parse(data_node));
		else if(xmlNode.getAttribute("model")){ //this section should be made complete
			var m = xmlNode.getAttribute("model").split(":");
			this.modelBaseXpath = m[1];
			this.model = NameServer.get("model", m[0]);
		}
	}
	
	if(xmlNode) this.construct(xmlNode);
}


/*FILEHEAD(/in/Core/Application/Splitter.js)SIZE(7470)TIME(1154797277419)*/
function Splitter(type, O1, O2, pnode, min, max, change){
	Kernel.Plane.init();
	GUI_NODE = 1;
		this.nodeType = GUI_NODE;
	//this.uniqueId = Kernel.all.push(this) - 1;
	this.tagName = "Resizer";

	this.change = change;
	this.min = min || 0;
	this.max = max || 1000000;
	
	this.normalize = function(o){
		if(!o) return;
		if(o.style) return o;
		if(o.length != null) for(var i=0;i<o.length;i++) o[i] = this.normalize(o[i]);
		else o = o.parentNode || o.oExt;
		
		return o;
	}

	type = type.split("-");
	this.type = type[0];
	this.size = parseInt(type[1]) || 3;
	this.O1 = this.normalize(O1);
	this.O2 = this.normalize(O2);
	
	this.oExt = this.e = (pnode || document.body).appendChild(document.createElement("DIV"));
	this.oExt.style.background = "url(SkinData/spacer.gif)";
	this.e.host = this;
	
	var O1 = this.O1[0] || this.O1;
	if(O1.parentNode && O1.parentNode != this.e.parentNode) O1.parentNode.appendChild(this.e);

	this.getTopPos = function(o){return Kernel.getStyle(o, "top") == "auto" ? 0 : parseInt(Kernel.getStyle(o, "top"));}
	this.getLeftPos = function(o){return Kernel.getStyle(o, "left") == "auto" ? 0 : parseInt(Kernel.getStyle(o, "left"));}
	
	this.getHeight = function(o){
		if(o.length)
			return (o[o.length-1].offsetTop + o[o.length-1].offsetHeight) - o[0].offsetTop;
		else
			return o.offsetHeight;
	}
	
	this.getWidth = function(o){
		if(o.length){
			return (o[o.length-1].offsetLeft + o[o.length-1].offsetWidth) - o[0].offsetLeft;
		}
		else
			return o.offsetWidth;
	}
	
	this.setPosition = function(){
		var q = (this.O1[0] || this.O1);
		
		//Ignore Resize Errors
		try{
			if(this.type == "horizontal"){
				this.e.style.top = (q.offsetTop + q.offsetHeight) + "px";
				this.e.style.left = q.offsetLeft + "px";
				this.e.style.width = this.getWidth(this.O1) + "px";
			}
			else{
				this.e.style.top = q.offsetTop + "px";
				this.e.style.left = (q.offsetLeft + q.offsetWidth) + "px";
				this.e.style.height = this.getHeight(this.O1) + "px";
			}
		}catch(e){}
	}
	
	this.set = function(){
		//q.hordiff = q.object.offsetWidth - parseInt(Kernel.compat.getStyle(q.object, "width"));
		//q.verdiff = q.object.offsetHeight - parseInt(Kernel.compat.getStyle(q.object, "height"));
		
		if(this.type == "vertical"){
			if(this.change == 2){
				var t = this.getLeftPos(this.e) + this.size;
				var deltaT = (this.O2[0] || this.O2).offsetLeft - t;
				var h = (this.O2[0] || this.O2).offsetWidth + deltaT;
				
				if(this.O2.length){
					for(var i=0;i<this.O2.length;i++){
						this.O2[i].style.left = t + "px";
						this.O2[i].style.width = (h - (this.O2[i].offsetWidth - parseInt(Kernel.compat.getStyle(this.O2[i], "width")))) + "px";
					}
				}
				else{
					this.O2.style.left = t + "px";
					this.O2.style.width = (h - (this.O2.offsetWidth - parseInt(Kernel.compat.getStyle(this.O2.object, "width")))) + "px";
				}
			}
			else{
				if(this.O1){
					if(this.O1.length) for(var i=0;i<this.O1.length;i++)
						this.O1[i].style.width = (this.getLeftPos(this.e) - this.O1[i].offsetLeft - (this.O1[i].offsetWidth - parseInt(Kernel.compat.getStyle(this.O1[i], "width")))) + "px";
					else this.O1.style.width = (this.getLeftPos(this.e) - this.O1.offsetLeft - (this.O1.offsetWidth - parseInt(Kernel.compat.getStyle(this.O1, "width")))) + "px";
				}
				
				if(this.O2){
					if(this.O2.length) for(var i=0;i<this.O2.length;i++)
						this.O2[i].style.left = (this.getLeftPos(this.e) + this.size) + "px";
					else this.O2.style.left = (this.getLeftPos(this.e) + this.size) + "px";
				}
			}
		}
		else{
			if(this.change == 2){
				var t = this.getTopPos(this.e) + this.size;
				var deltaT = (this.O2[0] || this.O2).offsetTop - t;
				var h = (this.O2[0] || this.O2).offsetHeight + deltaT;

				if(this.O2.length){
					for(var i=0;i<this.O2.length;i++){
						this.O2[i].style.top = t + "px";
						this.O2[i].style.height = (h - (this.O2[i].offsetHeight - parseInt(Kernel.compat.getStyle(this.O2[i], "height")))) + "px";
					}
				}
				else{
					this.O2.style.top = t + "px";
					this.O2.style.height = (h - (this.O2.offsetHeight - parseInt(Kernel.compat.getStyle(this.O2, "height")))) + "px";
				}
			}
			else{
				if(this.O2){
					var t = this.getTopPos(this.e) + this.size;
					var deltaT = (this.O2[0] || this.O2).offsetTop - t;
					var h = (this.O2[0] || this.O2).offsetHeight + deltaT;
					
					if(this.O2.length) for(var i=0;i<this.O2.length;i++)
						this.O2[i].style.top = t + "px";
					else this.O2.style.top = t + "px";
					
					/*if(this.O2.length) for(var i=0;i<this.O2.length;i++)
						this.O2[i].style.height = h;
					else this.O2.style.height = h;*/
				}
				
				if(this.O1){
					if(this.O1.length) for(var i=0;i<this.O1.length;i++)
						this.O1[i].style.height = (this.getTopPos(this.e) - this.O1[i].offsetTop - (this.O1[i].offsetHeight - parseInt(Kernel.compat.getStyle(this.O1[i], "height")))) + "px";
					else this.O1.style.height = (this.getTopPos(this.e) - this.O1.offsetTop - (this.O1.offsetHeight - parseInt(Kernel.compat.getStyle(this.O1, "height")))) + "px";
				}
			}
		}

		if(this.e.parentNode.onresize || window.onresize) (this.e.parentNode.onresize || window.onresize)();
		//TALIGN.recalc();
	}
	
	this.docMouseUp = function(){
		if(this.dragobject){
			this.dragobject.style.background = "url(SkinData/spacer.gif)";
			Kernel.Plane.hide();
			
			this.dragobject.host.set();
			this.dragobject = null;
			this.body.style.cursor = "default";
		}
	}
	
	this.docMouseMove = function(e){
		if(this.dragobject){
			if(!e) e = event;

			if(this.dragobject.host.type == "vertical"){
				if(e.clientX >= 0){
					this.dragobject.style.left = (Math.min(this.dragobject.host.max, Math.max(this.dragobject.host.min, e.clientX - this.dragobject.host.tx))) + "px";
				}
			}
			else{
				if(e.clientY >= 0){
					this.dragobject.style.top = (Math.min(this.dragobject.host.max, Math.max(this.dragobject.host.min, e.clientY - this.dragobject.host.ty))) + "px";
				}
			}
			
			e.returnValue = false;
			e.cancelBubble = true;
		}
	}

	this.setEvents = function(){
		this.e.onmousedown = function(e){
			if(!e) e = event;
			
			if(this.host.type == "vertical")
				this.host.tx = e.clientX - this.host.getLeftPos(this);
			else
				this.host.ty = e.clientY - this.host.getTopPos(this);
			
			e.returnValue = false;
			e.cancelBubble = true;
			
			document.dragobject = this;
			Kernel.Plane.show(document.dragobject);
			document.dragobject.style.backgroundColor = "gray";
			
			document.body.style.cursor = (this.host.type == "vertical" ? "w-resize" : "n-resize");
			
			document.onmouseup = this.host.docMouseUp;
			document.onmousemove = this.host.docMouseMove;
		}
	}
	
	this.draw = function(){
		with(this.e.style){
			position = "absolute";
			zIndex = 100;
			//backgroundColor = "green";
			overflow = "hidden";
			
			if(this.type == "vertical"){
				left = ((this.O1[0] || this.O1).offsetLeft + (this.O1[0] || this.O1).offsetWidth - 1) + "px";
				top = (this.O1[0] || this.O1).offsetTop + "px";
				width = this.size + "px";
				height = this.getHeight(this.O1) + "px";
				cursor = "w-resize";
			}
			else{
				left = (this.O1[0] || this.O1).offsetLeft + "px";
				top = ((this.O1[0] || this.O1).offsetTop + (this.O1[0] || this.O1).offsetHeight - 1) + "px";
				width = this.getWidth(this.O1) + "px";
				height = this.size + "px";
				cursor = "n-resize";
			}
		}
		
		this.setEvents();
	}
	this.draw();
}
/*FILEHEAD(/in/Core/Application/XMLDatabase.js)SIZE(29537)TIME(1188900006250)*/

function _XMLDatabase(){
	this.xmlDocTag = "j_doc";
	this.xmlIdTag = "j_id";
	this.xmlListenTag = "j_listen";
	this.htmlIdTag = "id";
	
	var xmlDocLut = [];
	
	/*************************************************************
							REMOTE Data-Binding
	*************************************************************/
	
	this.rdb = false;
	this.RDBHash = {};
	this.RDBChoices = [];
	
	//Remote Databinding
	this.loadRDB = function(x){
		this.rdb = true;
		this.socket = self[x.getAttribute("socket")];
		this.socket.onreceive = function(module, data){
			//module should be "rdb"
			XMLDatabase.receiveRDB(data);
		}

		var q = x.childNodes;
		for(var i=0;i<q.length;i++){
			if(q[i].nodeType != 1) continue;
			
			if(q[i].getAttribute("select")) 
				this.RDBChoices.push(q[i].getAttribute("select"), q[i].getAttribute("unique"));
			else this.RDBHash[q[i].tagName] = q[i].getAttribute("unique");
		}
	}
	
	/*************************************************************
							Lookup
	*************************************************************/
	this.getElementById = function(id, doc){
		if(!doc) doc = xmlDocLut[id.split("\|")[0]];
		if(!doc) return false;
		return doc.selectSingleNode("descendant-or-self::node()[@" + this.xmlIdTag + "='" + id + "']");
	}

	this.getNode = function(htmlNode){
		if(!htmlNode || !htmlNode.getAttribute(this.htmlIdTag)) return false;
		return this.getElementById(htmlNode.getAttribute(this.htmlIdTag).split("\|", 2).join("|"));
	}
	
	this.getNodeById = function(id, doc){
		var q = id.split("\|");q.pop();
		return this.getElementById(q.join("|"), doc);//id.split("\|", 2).join("|")
	}

	this.getDocumentById = function(id){
		return xmlDocLut[id];
	}

	this.getDocument = function(node){
		return xmlDocLut[node.getAttribute(this.xmlIdTag).split("\|")[0]];
	}
	
	this.getChildNumber = function(node){
		var p = node.parentNode;
		for(var i=0;i<p.childNodes.length;i++) if(p.childNodes[i] == node) return i;
	}
	
	this.isChildOf = function(pnode, childnode, orItself){
		if(!pnode || !childnode) return false;
		if(orItself && pnode == childnode) return true;
		
		var nodes = pnode.getElementsByTagName("*");
		for(var i=0;i<nodes.length;i++) if(nodes[i] == childnode) return true;
		return false;
	}
	
	this.findHTMLNode = function(xmlNode, oComp){
		do{
			if(xmlNode.getAttribute(this.xmlIdTag)){
				return oComp.getNodeFromCache(xmlNode.getAttribute(this.xmlIdTag)+"|"+oComp.uniqueId);
			}
			if(xmlNode == oComp.XMLRoot) return null;
			xmlNode = xmlNode.parentNode;
		}while(xmlNode && xmlNode.nodeType != 9)
		
		return null;
	}
	
	this.findXMLNode = function(htmlNode){
		if(!htmlNode) return false;

		while(htmlNode && htmlNode.nodeType == 1 && htmlNode.tagName.toLowerCase() != "body" && !htmlNode.getAttribute("id") || htmlNode && htmlNode.nodeType == 1 && htmlNode.getAttribute(this.htmlIdTag) && htmlNode.getAttribute(this.htmlIdTag).match(/^q/)){
			if(htmlNode.host && htmlNode.host.oExt == htmlNode) return htmlNode.host.XMLRoot;
			htmlNode = htmlNode.parentNode;
		}
		if(!htmlNode || htmlNode.nodeType != 1) return false;
		
		if(htmlNode.tagName.toLowerCase() == "body") return false;

		return this.getNode(htmlNode);
	}
	
	this.getElement = function(parent, nr){
		var nodes = parent.childNodes;
		for(var j=0,i=0;i<nodes.length;i++){
			if(nodes[i].nodeType != 1) continue;
			if(j++ == nr) return nodes[i];
		}
	}
	
	this.getID = function(xmlNode, o){
		return xmlNode.getAttribute(this.xmlIdTag) + "|" + o.uniqueId;
	}
	
	this.getModel = function(name){
		return NameServer.get("model", name);
	}
	
	this.setModel = function(model){
		NameServer.register("model", model.data.ownerDocument.documentElement.getAttribute(this.xmlDocTag), model);
	}
	
	this.findModel = function(xmlNode){
		return this.getModel(xmlNode.ownerDocument.documentElement.getAttribute(this.xmlDocTag));
	}
	
	this.getXml = function(strXml, no_error){
		return Kernel.getObject("XMLDOM", strXml, no_error).documentElement;
	}

	/*************************************************************
							Data-Binding - ADMIN
	*************************************************************/
	this.nodeCount = {};

	/********* NODECONNECT ***********
		Connect an HTML Node to an XML Data Node
	
		INTERFACE:
		this.nodeConnect(documentId, xmlNode, htmlNode, o);
	****************************/
	this.nodeConnect = function(documentId, xmlNode, htmlNode, o){
		if(!this.nodeCount[documentId]) this.nodeCount[documentId] = 0;

		var xmlID = xmlNode.getAttribute(this.xmlIdTag) || documentId + "|" + ++this.nodeCount[documentId];
		xmlNode.setAttribute(this.xmlIdTag, xmlID);
		if(!o) return xmlID;
		
		var htmlID = xmlID + "|" + o.uniqueId;
		if(htmlNode) htmlNode.setAttribute(this.htmlIdTag, htmlID);

		return htmlID;
	}

	/********* ADDNODELISTENER ***********
		Adds a listener to an XML Data Node, listening for changes beneath that Node
		
		- might be an idea to add a depth argument
		
		INTERFACE:
		this.addNodeListener(xmlNode, o);
	****************************/
	this.addNodeListener = function(xmlNode, o){
		if(!o.__xmlUpdate) throw new Error(1040, Kernel.formErrorString(1040, null, "Adding Node listener", "Cannot attach this listener because it doesn't support the correct interface (__xmlUpdate)."));

		var listen = xmlNode.getAttribute(this.xmlListenTag);
		var nodes = (listen ? listen.split(";") : []);
		
		if(!nodes.contains(o.uniqueId)) nodes.push(o.uniqueId);
		xmlNode.setAttribute(this.xmlListenTag, nodes.join(";"));
	}

	/********* INTEGRATE ***********
		Integrates nodes as children beneath a parentnode 
		(optionally including attributes)
		
		INTERFACE:
		this.integrate(xmlNode, id, copyAttributes);
		this.integrate(xmlNode, parentXMLNode, copyAttributes);
	****************************/	
	this.integrate = function(XMLRoot, parentNode, copyAttributes){
		if(typeof parentNode != "object") parentNode = getElementById(parentNode);
		
		var ln = XMLRoot.childNodes.length;
		for(var i=0;i<ln;i++) parentNode.appendChild(XMLRoot.childNodes[0]);
		
		if(copyAttributes){
			var attr = XMLRoot.attributes;
			for(var i=0;i<attr.length;i++) if(attr[i].nodeName != this.xmlIdTag) parentNode.setAttribute(attr[i].nodeName, attr[i].nodeValue);
		}
		
		return parentNode;
	}

	/********* SYNCHRONIZE ***********
		Integrates current XMLDatabase with parent XMLDatabase
		
		- assuming transparency of XMLDOM elements cross windows
		  with no performence loss.
		
		INTERFACE:
		this.synchronize();
	****************************/	
	this.synchronize = function(){
		this.forkRoot.parentNode.replaceChild(this.root, this.forkRoot);
		this.parent.applyChanges("synchronize", this.root);
	}
	
	this.copyNode = function(xmlNode){
		return this.clearConnections(xmlNode.cloneNode(true));
	}

	/*************************************************************
							Data-Binding - EXEC
	*************************************************************/
	
	this.setNodeValue = function(xmlNode, nodeValue, applyChanges){
		if(xmlNode.nodeType == 1){
			if(!xmlNode.firstChild) xmlNode.appendChild(xmlNode.ownerDocument.createTextNode("-"));
			xmlNode.firstChild.nodeValue = isNot(nodeValue) ? "" : nodeValue;
			
			if(applyChanges) XMLDatabase.applyChanges("synchronize", xmlNode);
		}
		else{
			xmlNode.nodeValue = isNot(nodeValue) ? "" : nodeValue;
			if(applyChanges) XMLDatabase.applyChanges("synchronize", xmlNode.parentNode || xmlNode.selectSingleNode(".."));
		}
	}
	
	this.getNodeValue = function(xmlNode){
		if(!xmlNode) return "";
		return xmlNode.nodeType == 1 ? (!xmlNode.firstChild ? "" : xmlNode.firstChild.nodeValue) : xmlNode.nodeValue;
	}
	
	/********* GETINHERITEDATTRIBUTE ***********
		Returns inherited connect id if any

		INTERFACE:
		this.getInheritedAttribute(XMLNode);
	****************************/
	this.getInheritedAttribute = function(x, attr, func){
		var result, y = x;
		while(y && y.nodeType != 11 && y.nodeType != 9 && !(result = attr && y.getAttribute(attr) || func && func(y))){
			y = y.parentNode;
		}
		
		if(!result && attr && Application.lastSettings) 
			result = Application.lastSettings.getAttribute(attr);
		return result;
	}
	
	/********* SETTEXTNODE ***********
		Set nodeValue of Text Node. If Node doesn't exist it is created.
		Optionally xpath statement is executed to identify textnode.
		
		INTERFACE:
		this.setTextNode(pnode, value, [xpath]);
	****************************/	
	this.setTextNode = function(pnode, value, xpath, UndoObj){
		if(xpath){
			var tNode = pnode.selectSingleNode(xpath);
			if(!tNode) return;
			pnode = tNode.nodeType == 1 ? tNode : null;
		}
		if(pnode || !tNode){
			if(!pnode.firstChild) var tNode = pnode.appendChild(pnode.ownerDocument.createTextNode(""));//createCDATASection
			else var tNode = pnode.firstChild;
		}
		
		//Action Tracker Support
		if(UndoObj) UndoObj.oldValue = tNode.nodeValue;
		
		//Apply Changes
		tNode.nodeValue = value;
		
		this.applyChanges("text", tNode.parentNode, UndoObj);
		
		this.applyRDB("setTextNode", pnode, value, xpath, UndoObj);
	}

	/********* SETATTRIBUTE ***********
		Sets attribute of node.
		Optionally xpath statement is executed to identify attribute node
		
		INTERFACE:
		this.setAttribute(xmlNode, name, value, [xpath]);
	****************************/
	this.setAttribute = function(xmlNode, name, value, xpath, UndoObj){
		//if(xmlNode.nodeType != 1) xmlNode.nodeValue = value;
		
		//Apply Changes
		(xpath ? xmlNode.selectSingleNode(xpath) : xmlNode).setAttribute(name, value);
		this.applyChanges("attribute", xmlNode, UndoObj);
		
		this.applyRDB("setAttribute", xmlNode, name, value, xpath, UndoObj);
	}
	
	/********* REMOVEATTRIBUTE ***********
		Removes attribute of node.
		Optionally xpath statement is executed to identify attribute node
		
		INTERFACE:
		this.removeAttribute(xmlNode, name, [xpath]);
	****************************/
	this.removeAttribute = function(xmlNode, name, xpath, UndoObj){
		//if(xmlNode.nodeType != 1) xmlNode.nodeValue = value;
		
		//Action Tracker Support
		if(UndoObj) UndoObj.name = name;

		//Apply Changes
		(xpath ? xmlNode.selectSingleNode(xpath) : xmlNode).removeAttribute(name);
		this.applyChanges("attribute", xmlNode, UndoObj);
		
		this.applyRDB("removeAttribute", xmlNode, name, xpath, UndoObj);
	}
	
	/********* REPLACENODE ***********
		Replace one node with another
		Optionally xpath statement is executed to identify attribute node
		
		INTERFACE:
		this.replaceNode(oldNode, newNode, [xpath]);
	****************************/
	this.replaceNode = function(oldNode, newNode, xpath, UndoObj){
		//if(xmlNode.nodeType != 1) xmlNode.nodeValue = value;
		
		//Apply Changes
		if(xpath) oldNode = oldNode.selectSingleNode(xpath);
		
		//Action Tracker Support
		if(UndoObj) UndoObj.oldNode = oldNode;
		
		oldNode.parentNode.replaceChild(newNode, oldNode);
		this.copyConnections(oldNode, newNode);
		
		this.applyChanges("replacechild", newNode, UndoObj);
		
		this.applyRDB("replaceChild", oldNode, newNode, xpath, UndoObj);
	}

	/********* ADDCHILDNODE ***********
		Creates a new node under pnode before beforeNode or as last node.
		Optionally xpath statement is executed to identify parentNode node
		
		INTERFACE:
		this.addChildNode(pnode, tagName, attr, [afterNode], [xpath]);
	****************************/
	this.addChildNode = function(pnode, tagName, attr, beforeNode, xpath, UndoObj){
		//Create New Node
		var xmlNode = pnode.insertBefore(pnode.ownerDocument.createElement(tagName), beforeNode);

		//Set Attributes
		for(var i=0;i<attr.length;i++) xmlNode.setAttribute(attr[i][0], attr[i][1]);
		
		//Action Tracker Support
		if(UndoObj) UndoObj.addedNode = xmlNode;
		
		this.applyChanges("add", xmlNode, UndoObj);
		
		this.applyRDB("addChildNode", pnode, tagName, attr, beforeNode, xpath, UndoObj);
		
		return xmlNode;
	}

	/********* APPENDCHILDNODE ***********
		Appends xmlNode to pnode and before beforeNode or as last node
		Optionally set bool unique to make sure node is unique under parent
		Optionally xpath statement is executed to identify parentNode node
		
		INTERFACE:
		this.appendChildNode(pnode, xmlNode, [afterNode], [unique], [xpath]);
	****************************/
	this.appendChildNode = function(pnode, xmlNode, beforeNode, unique, xpath, UndoObj){
		if(unique && pnode.selectSingleNode(xmlNode.tagName)) return false;
		
		if(UndoObj) this.clearConnections(xmlNode);
		
		//Add xmlNode to parent pnode or one selected by xpath statement
		(xpath ? pnode.selectSingleNode(xpath) : pnode).insertBefore(xmlNode, beforeNode);
		
		//detect if xmlNode should be removed somewhere else
		//- [17-2-2004] changed pnode (2nd arg applychange) into xmlNode

		this.applyChanges("add", xmlNode, UndoObj);
		
		this.applyRDB("appendChildNode", pnode, xmlNode.xml, beforeNode, unique, xpath, UndoObj);
		
		return xmlNode;
	}
	
	this.copyConnections = function(fromNode, toNode){
		//This should copy recursive
		try{
			toNode.setAttribute(this.xmlListenTag, fromNode.getAttribute(this.xmlListenTag));
			toNode.setAttribute(this.xmlIdTag, fromNode.getAttribute(this.xmlIdTag));
		}catch(e){}
	}
	
	this.clearConnections = function(xmlNode){
		try{
			var nodes = xmlNode.selectNodes("descendant-or-self::node()[@" + this.xmlListenTag + "]");
			for(var i=nodes.length-1;i>=0;i--) nodes[i].removeAttributeNode(nodes[i].getAttributeNode(this.xmlListenTag));
			var nodes = xmlNode.selectNodes("descendant-or-self::node()[@" + this.xmlIdTag + "]");
			for(var i=nodes.length-1;i>=0;i--) nodes[i].removeAttributeNode(nodes[i].getAttributeNode(this.xmlIdTag));
			var nodes = xmlNode.selectNodes("descendant-or-self::node()[@" + this.xmlDocTag + "]");
			for(var i=nodes.length-1;i>=0;i--) nodes[i].removeAttributeNode(nodes[i].getAttributeNode(this.xmlDocTag));
			var nodes = xmlNode.selectNodes("descendant-or-self::node()[@_loaded]");
			for(var i=nodes.length-1;i>=0;i--) nodes[i].removeAttributeNode(nodes[i].getAttributeNode("_loaded"));
			var nodes = xmlNode.selectNodes("descendant-or-self::node()[@j_selection]");
			for(var i=nodes.length-1;i>=0;i--) nodes[i].removeAttributeNode(nodes[i].getAttributeNode("j_selection"));
		}catch(e){}
		
		return xmlNode;
	}
	
	this.serializeNode = function(xmlNode){
		return this.clearConnections(xmlNode.cloneNode(true)).xml;
	}
	
	/********* MOVENODE ***********
		Moves xmlNode to pnode and before beforeNode or as last node
		
		INTERFACE:
		this.moveNode(pnode, xmlNode, [beforeNode], [xpath]);
	****************************/
	this.moveNode = function(pnode, xmlNode, beforeNode, xpath, UndoObj){
		//Action Tracker Support
		if(!UndoObj) UndoObj = {};
		UndoObj.pNode = xmlNode.parentNode;
		UndoObj.beforeNode = xmlNode.nextSibling;
		UndoObj.toPnode = (xpath ? pnode.selectSingleNode(xpath) : pnode);

		this.applyChanges("move-away", xmlNode, UndoObj);
		
		//Set new id if the node change document (for safari this should be fixed)
		if(!IS_SAFARI && XMLDatabase.getXmlDocId(xmlNode) != XMLDatabase.getXmlDocId(pnode)){
			xmlNode.removeAttributeNode(xmlNode.getAttributeNode(this.xmlIdTag));
			this.nodeConnect(XMLDatabase.getXmlDocId(pnode), xmlNode);
		}

		if(IS_SAFARI && pnode.ownerDocument != xmlNode.ownerDocument) xmlNode = pnode.ownerDocument.importNode(xmlNode, true); //Safari issue not auto importing nodes
		UndoObj.toPnode.insertBefore(xmlNode, beforeNode);
		this.applyChanges("move", xmlNode, UndoObj);
		
		this.applyRDB("moveNode", pnode, xmlNode, beforeNode, xpath, UndoObj);
	}

	/********* REMOVENODE ***********
		Removes xmlNode from xmlTree
		Optional xpath statement identifies xmlNode
		
		INTERFACE:
		this.removeNode(xmlNode, [xpath]);
	****************************/
	this.removeNode = function(xmlNode, xpath, UndoObj){
		if(xpath) xmlNode = xmlNode.selectSingleNode(xpath);
		
		//ActionTracker Support
		if(UndoObj){
			UndoObj.pNode = xmlNode.parentNode;
			UndoObj.removedNode = xmlNode;
			UndoObj.beforeNode = xmlNode.nextSibling;
		}
		
		//Apply Changes
		this.applyChanges("remove", xmlNode, UndoObj);
		var p = xmlNode.parentNode; p.removeChild(xmlNode);
		this.applyChanges("redo-remove", xmlNode, null, p);//UndoObj
		
		this.applyRDB("removeNode", xmlNode, xpath, UndoObj);
	}

	/********* REMOVENODELIST ***********
		Removes xmlNodeList from xmlTree
		
		INTERFACE:
		this.removeNodeList(xmlNodeList);
	************************************/
	this.removeNodeList = function(xmlNodeList, UndoObj){
		//if(xpath) xmlNode = xmlNode.selectSingleNode(xpath);
		
		for(var rData=[],i=0;i<xmlNodeList.length;i++){ //This can be optimized by looping nearer to xmlUpdate
			//ActionTracker Support
			if(UndoObj){
				rData.push({
					pNode : xmlNodeList[i].parentNode,
					removedNode : xmlNodeList[i],
					beforeNode : xmlNodeList[i].nextSibling
				});
			}
			
			//Apply Changes
			this.applyChanges("remove", xmlNodeList[i], UndoObj);
			var p = xmlNodeList[i].parentNode; p.removeChild(xmlNodeList[i]);
			this.applyChanges("redo-remove", xmlNodeList[i], null, p);//UndoObj
		}
		if(UndoObj) UndoObj.removeList = rData;
		
		this.applyRDB("removeNodeList", xmlNodeList, null, UndoObj);
	}
	
	/*************************************************************
						Data-Binding: Applying Changes
	*************************************************************/
	
	/********* APPLYCHANGES  ***********
		Looks for listeners and execute their __xmlUpdate methods
		
		INTERFACE:
		this.applyChanges(xmlNode);
	****************************/
	this.applyChanges = function(action, xmlNode, UndoObj, nextloop){
		//Set Variables
		var oParent = nextloop, loopNode = (xmlNode.nodeType == 1 ? xmlNode : xmlNode.parentNode), hash = {};

		while(loopNode && loopNode.nodeType != 9){
			//Get List of Node listeners ID's
			var listen = loopNode.getAttribute(this.xmlListenTag);

			if(listen){
				var ids = listen.split(";");

				//Loop through ID List and call for xmlUpdate
				for(var i=0;i<ids.length;i++){
					if(hash[ids[i]]) continue; hash[ids[i]] = true;

					//Only Local Objects [LATER: or those of parentWindows]
					var o = Kernel.localLookup(ids[i]);
					if(o) o.__xmlUpdate(action, xmlNode, loopNode, UndoObj, oParent);
				}
			}
			
			//Go one level up
			loopNode = loopNode.parentNode || nextloop;
			if(loopNode == nextloop) nextloop = null;
		}
		
		if(UndoObj) UndoObj.xmlNode = xmlNode;
		//if(UndoObj) alert(UndoObj.xmlNode.xml);
	}
	
	this.notifyListeners = function(xmlNode){
		//This should be done recursive
		var listen = xmlNode.getAttribute(XMLDatabase.xmlListenTag);
		if(listen){
			listen = listen.split(";");
			for(var j=0;j<listen.length;j++){
				Kernel.lookup(listen[j]).__xmlUpdate("synchronize", xmlNode, xmlNode);
				//load(xmlNode);
			}
		}
	}

	/********* APPLYRDB  ***********
		Sents Message through socket to tell remote databound listeners
		that data has been changed
		
		INTERFACE:
		this.applyRDB([...], [UndoObj]);
	****************************/
	this.applyRDB = function(){
		//To optimize below line can move upwards | Disable if receiving RDB Message
		if(!this.rdb || this.rcvrdb) return false;
		
		var UndoObj, args = [], q = arguments;
		for(var i=0;i<q.length;i++){
			if(q[i] && q[i].tagName == "UndoData") UndoObj = q[i];
			else args.push(q[i] && q[i].nodeType ? this.serializeXmlToXpath(q[i]) : q[i]);
		}

		//ActionTracker Support
		if(UndoObj) UndoObj.rdb_args = args;
		//Or sent Socket call
		else this.socket.send("rdb", args);
	}

	/********* RECEIVERDB ***********
		Receive RDB Message for data it has in cache
		
		INTERFACE:
		this.receiveRDB(data);
	****************************/
	this.receiveRDB = function(q){
		var xmlNode = this.unSerializeXmlToXpath(q[1]);
		if(!xmlNode) return;
		
		this.rcvrdb = true;
		switch(q[0]){
			case "setTextNode": this.setTextNode(xmlNode, q[2], q[3]);break;
			case "setAttribute": this.setAttribute(xmlNode, q[2], q[3], q[4]);break;
			case "addChildNode": this.addChildNode(xmlNode, q[2], q[3], this.unSerializeXmlToXpath(q[4]), q[5]);break;
			case "appendChildNode": 
				var beforeNode = (q[3] ? this.unSerializeXmlToXpath(q[3]) : null);
				this.appendChildNode(xmlNode, this.clearConnections(q[2]), beforeNode, q[4], q[5]);
			break;
			case "moveNode": 
				var beforeNode = (q[3] ? this.unSerializeXmlToXpath(q[3]) : null);
				var sNode = this.unSerializeXmlToXpath(q[2]);
				this.appendChildNode(xmlNode, sNode, beforeNode, q[4], q[5]);
			break;
			case "removeNode": this.removeNode(xmlNode, q[2]);break;
		}
		this.rcvrdb = false;
	}

	/********* UNBIND ***********
		Unbind all Javeline Elements from a certain Form
		
		INTERFACE:
		this.unbind(frm);
	****************************/
	this.unbind = function(frm){
		//Loop through objects of local Kernel
		for(var lookup={},i=0;i<frm.Kernel.local.length;i++)
			if(frm.Kernel.local[i].unloadBindings)
				lookup[frm.Kernel.local[i].unloadBindings()] = true;

		//Remove Listen Nodes
		for(var k=0;k<xmlDocLut.length;k++){
			if(!xmlDocLut[k]) continue;
			
			var Nodes = xmlDocLut[k].selectNodes("//self::node()[@" + this.xmlListenTag + "]");
	
			//Loop through Nodes and rebuild listen array
			for(var i=0;i<Nodes.length;i++){
				var listen = Nodes[i].getAttribute(this.xmlListenTag).split(";");
				for(var nListen=[],j=0;j<listen.length;j++)
					if(!lookup[listen[j]]) nListen.push(listen[j]);
	
				//Optimization??
				if(nListen.length != listen.length)
					Nodes[i].setAttribute(this.xmlListenTag, nListen.join(";"));
			}
		}
	}
	
	/*************************************************************
							Skin-Binding - EXEC
	*************************************************************/
	
	//Currently only supports a single node
	this.selectNodes = function(sExpr, contextNode){
		if(!IS_IE || !contextNode.style) return contextNode.selectNodes(sExpr); //IE55
		//if(contextNode.ownerDocument != document) return contextNode.selectNodes(sExpr);
		
		return XPath.selectNodes(sExpr, contextNode)
	}
	
	this.selectSingleNode = function(sExpr, contextNode){
		if(!IS_IE || !contextNode.style) return contextNode.selectSingleNode(sExpr); //IE55
		//if(contextNode.ownerDocument != document) return contextNode.selectSingleNode(sExpr);
		
		var nodeList = this.selectNodes(sExpr + (IS_IE ? "" : "[1]"), contextNode ? contextNode : null);
		return nodeList.length > 0 ? nodeList[0] : null;
	}

	/*************************************************************
							General XML Handling
	*************************************************************/
	
	//for RDB: xmlNode --> Xpath statement
	this.serializeXmlToXpath = function(xmlNode){
		var def = this.RDBHash[xmlNode.tagName];
		if(def){
			//unique should not have ' in it... -- can be fixed...
			var unique = xmlNode.selectSingleNode(def).nodeValue;
			return "//" + xmlNode.tagName + "[" + def + "='" + unique + "']";
		}

		for(var i=0;i<this.RDBChoices.length;i++){
			if(xmlNode.selectSingleNode(this.RDBChoices[i][0])){
				var unique = xmlNode.selectSingleNode(this.RDBChoices[i][1]).nodeValue;
				return "//" + this.RDBChoices[i][0] + "[" + this.RDBChoices[i][1] + "='" + unique + "']";
			}
		}

		//THIS SHOULD BE THE COMPLETE PATH
		return "//" + xmlNode.parentNode.tagName + "/" + xmlNode.tagName + "[" + (this.getChildNumber(xmlNode)+1) + "]";
	}

	//for RDB: Xpath statement --> xmlNode
	this.unSerializeXmlToXpath = function(str){
		for(var xmlNode=null,i=0;i<xmlDocLut.length;i++)
			if(xmlNode = xmlDocLut[i].selectSingleNode(str)) return xmlNode;
		
		return false;
	}
	
	this.createNodeFromXpath = function(contextNode, xPath){
		var xmlNode, foundpath = "", paths = xPath.split("/");
		if(xmlNode = contextNode.selectSingleNode(xPath)) return xmlNode;
		
		for(var isAdding=false,i=0;i<paths.length-1;i++){
			if(!isAdding && contextNode.selectSingleNode(foundpath + (i != 0 ? "/" : "") + paths[i])){
				foundpath += (i != 0 ? "/" : "") + paths[i];
				continue;
			}
			
			if(paths[i].match(/\@|\[.*\]|\(.*\)/)) throw new Error(1041, Kernel.formErrorString(1041, this, "Select via xPath", "Could not use xPath to create xmlNode: " + xPath));
			if(paths[i].match(/\/\//)) throw new Error(1041, Kernel.formErrorString(1041, this, "Select via xPath", "Could not use xPath to create xmlNode: " + xPath));
			
			isAdding = true;
			contextNode.selectSingleNode(foundpath).appendChild(contextNode.ownerDocument.createElement(paths[i]));
			foundpath += paths[i] + "/";
		}
		if(!foundpath) foundpath = ".";
		
		var lastpath = paths[paths.length-1];
		if(lastpath.match(/^\@(.*)$/)){
			var attrNode = contextNode.ownerDocument.createAttribute(RegExp.$1);
			contextNode.selectSingleNode(foundpath).setAttributeNode(attrNode);
			return attrNode;
		}
		else if(lastpath.trim() == "text()") return contextNode.selectSingleNode(foundpath).appendChild(contextNode.ownerDocument.createTextNode(""));
		else return contextNode.selectSingleNode(foundpath).appendChild(contextNode.ownerDocument.createElement(lastpath));
	}

	this.getXmlDocId = function(xmlNode, model){
		var docId = (xmlNode.ownerDocument.documentElement || xmlNode).getAttribute(this.xmlDocTag) || xmlDocLut.indexOf(xmlNode.ownerDocument);
		if(docId && docId > -1) return docId;
		
		docId = xmlDocLut.push(xmlNode.ownerDocument.documentElement || xmlNode.ownerDocument || xmlNode)-1;
		if(xmlNode.ownerDocument.documentElement) xmlNode.ownerDocument.documentElement.setAttribute(this.xmlDocTag, docId);
		if(model) NameServer.register("model", docId, model);

		return xmlDocLut.length-1;
	}
	
	this.getBindXmlNode = function(xmlRootNode){
		if(typeof xmlRootNode != "object") xmlRootNode = Kernel.getObject("XMLDOM", xmlRootNode);
		if(xmlRootNode.nodeType == 9) xmlRootNode = xmlRootNode.documentElement;
		if(xmlRootNode.nodeType == 3 || xmlRootNode.nodeType == 4) xmlRootNode = xmlRootNode.parentNode;
		if(xmlRootNode.nodeType == 2) xmlRootNode = xmlRootNode.selectSingleNode("..");
		
		return xmlRootNode;
	}
	
	this.getTextNode = function(x){
		for(var i=0;i<x.childNodes.length;i++){
			if(x.childNodes[i].nodeType == 3 || x.childNodes[i].nodeType == 4)
				return x.childNodes[i];
		}
		return false;
	}
	
	this.getAllNodesBefore = function(pNode, xpath, xmlNode, func){
		var nodes = XMLDatabase.selectNodes(xpath, pNode);
		for(var found=false,result=[],i=nodes.length-1;i>=0;i--){
			if(!found && nodes[i] == xmlNode){
				found = true;
				continue;
			}
			if(!found) continue;
			result.push(nodes[i]);
			if(func) func(nodes[i]);
		}
		return result;
	}
	
	this.getAllNodesAfter = function(pNode, xpath, xmlNode, func){
		var nodes = XMLDatabase.selectNodes(xpath, pNode);
		for(var found=false,result=[],i=0;i<nodes.length;i++){
			if(!found && nodes[i] == xmlNode){
				found = true;
				continue;
			}
			if(!found) continue;
			result.push(nodes[i]);
			if(func) func(nodes[i]);
		}
		return result;
	}
	
	this.clearBoundValue = function(jmlNode, xmlRoot, applyChanges){
		var xmlNode = (jmlNode.nodeType == 1) ?
			xmlRoot.selectSingleNode(jmlNode.getAttribute("bind")) :
			jmlNode.getNodeFromRule("Value", jmlNode.XMLRoot);
		
		if(xmlNode) this.setNodeValue(xmlNode, "", applyChanges);
	}
	
	this.getBoundValue = function(jmlNode, xmlRoot, applyChanges){
		var xmlNode = (jmlNode.nodeType == 1) ?
			xmlRoot.selectSingleNode(jmlNode.getAttribute("bind")) :
			jmlNode.getNodeFromRule("Value", jmlNode.XMLRoot);
		
		return xmlNode ? this.getNodeValue(xmlNode) : "";
	}
	
	this.getArrayFromNodelist = function(nodelist){
		for(var nodes=[],j=0;j<nodelist.length;j++) nodes.push(nodelist[j]);
		return nodes;
	}

	this.getDataIsland = function(x){
		//Retrieve XML from External Source
		if(x.getAttribute("src")){
			var xml = HTTP.getXML(x.getAttribute("src"));
		}
		//Make use of XML Data Island - IE
		else if(IS_IE){
			var xml = x.XMLDocument; x.removeNode(true);
			xml.setProperty("SelectionLanguage", "XPath");
		}
		//Make use of XML Data Island - Mozilla workaround
		else{
			//var str = HTTP.getString(location.href);
			var str = x.parentNode.xml;
			var data = str.match(/<xml.*>\s*((?:.|\n|\r)*)\s*<\/xml>/);
			var xml = Kernel.getObject("XMLDOM", data[1]);
		}
		
		//Check for Parse Errors
		Kernel.xmlParseError(xml);
		
		return xml;
	}
}

Init.run('_XMLDatabase');


/*FILEHEAD(/in/Core/Crypt/base64.js)SIZE(1203)TIME(1154551076863)*/

/*FILEHEAD(/in/Core/Crypt/blowfish.js)SIZE(22123)TIME(1154551076863)*/

/*FILEHEAD(/in/Core/Crypt/md4.js)SIZE(7274)TIME(1154551076863)*/

/*FILEHEAD(/in/Core/Crypt/md5.js)SIZE(8861)TIME(1154551076863)*/

/*FILEHEAD(/in/Core/Crypt/sha1.js)SIZE(5788)TIME(1154551076863)*/

/*FILEHEAD(/in/TelePort/DeskRun.js)SIZE(6820)TIME(1170043381799)*/

/*FILEHEAD(/in/TelePort/HTTP.js)SIZE(14850)TIME(1188383718500)*/

function HTTP(){
	this.queue = [null];
	this.callbacks = {};
	this.cache = {};
	this.timeout = 10000; //default 10 seconds
	if(!this.uniqueId) this.uniqueId = Kernel.all.push(this) - 1;
	
	// Register Communication Module
	this.SmartBindingHook = ["http", "variables"]
	Kernel.TelePort.register(this);
	
	if(!this.toString){
		this.toString = function(){
			return "[Javeline TelePort Component : (HTTP)]";
		}
	}
	
	
	this.loadCache = function(name){
			var strResult = this.get(CWD + name + ".txt");
			
		setStatus("[HTTP] Loading HTTP Cache", "steleport");
		
		if(!strResult) return false;

		eval("var data = " + strResult);
		this.cache = data.params;
		
		return true;
	}

	this.getXML = function(url, receive, async, userdata, nocache){
		return this.get(url, receive, async, userdata, nocache, "", true);
	}

	this.getString = function(url, receive, async, userdata, nocache){
		return this.get(url, receive, async, userdata, nocache, "");
	}

	this.get = function(url, receive, async, userdata, nocache, data, useXML, id, autoroute, useXSLT, caching){
		var tpModule = this;
		
		if(IS_OPERA) async = true; //opera doesnt support sync calls
		
		if(IS_SAFARI) url = htmlentitiesdecode(url);
		
		if(isNot(id)){
			//Caching
			if(this.cache[url] && this.cache[url][data]){
				 var http = {
				 	responseText : this.cache[url][data],
				 	responseXML : {},
				 	status : 200,
				 	isCaching : true
				 }
			}
			else
				var http = Kernel.getObject("HTTP");
			
			id = this.queue.push([http, receive, null, null, userdata, null, [url, async, data, nocache, useXSLT, caching], useXML, 0])-1;
			
			if(http.isCaching){
				if(async) return setTimeout("Kernel.lookup(" + this.uniqueId + ").receive(" + id + ");", 50);//Math.round(Math.random()*200));
				else return this.receive(id);
			}
		}
		else{
			var http = this.queue[id][0];
			if(http.isCaching) http = Kernel.getObject("HTTP");
			else 
				http.abort();
		}

		if(async){
			if(IS_IE50){
				this.queue[id][3] = new Date();
				this.queue[id][2] = function(){
					var dt = new Date(new Date().getTime() - tpModule.queue[id][3].getTime());
					var diff = parseInt(dt.getSeconds()*1000 + dt.getMilliseconds());
					if(diff > tpModule.timeout){
						tpModule.dotimeout(id); 
						return
					};
					
					if(tpModule.queue[id][0].readyState == 4){
						tpModule.queue[id][0].onreadystatechange = function(){};
						tpModule.receive(id);
					}
				};
				this.queue[id][5] = setInterval(function(){tpModule.queue[id][2]()}, 20);
			}
			else{
				http.onreadystatechange = function(){
					if(!tpModule.queue[id] || http.readyState != 4) return;
					tpModule.receive(id);
				}
			}
		}

		if(!autoroute) autoroute = this.shouldAutoroute;
		if(this.autoroute && IS_OPERA) autoroute = true; //Bug in opera
		var srv = autoroute ? this.routeServer : url;

		Kernel.debugMsg("<strong>Making request[" + id + "] to " + url + (autoroute ? "<br /><span style='color:green'>[via: " + srv + (nocache ? (srv.match(/(\.asp|\.aspx|\.ashx)$/) ? "/" : (srv.match(/\?/) ? "&" : "?")) + Math.random() : "") + "]</span>" : "") + "</strong> with data:<br />" + new String(data && data.xml ? data.xml : data).replace(/\&/g, "&amp;").replace(/</g, "&lt;") + "<hr />", "teleport");
		
		setStatus("[HTTP] Making request[" + id + "] url: " + url, "steleport");

		try{
			//if(srv.match(/(\.asp|\.aspx|\.ashx)$/)) nocache = false;
			http.open(this.protocol || "GET", srv + (nocache ? (srv.match(/\?/) ? "&" : "?") + Math.random() : ""), async);
			
			//OPERA ERROR's here... on retry
			http.setRequestHeader("User-Agent", "Javeline TelePort 1.0.0");
			http.setRequestHeader("Content-type", this.contentType || (this.useXML || useXML ? "text/xml" : "text/plain"));
			
			if(autoroute){
				http.setRequestHeader("X-Route-Request", url);
				http.setRequestHeader("X-Proxy-Request", url);
				http.setRequestHeader("X-Compress-Response", "gzip");
			}
		}catch(e){
			var useOtherXH = false;
			
			if(self.XMLHttpRequestUnSafe){
				try{
					http = new XMLHttpRequestUnSafe();
					http.onreadystatechange = function(){
						if(!tpModule.queue[id] || http.readyState != 4) return;
						tpModule.receive(id);
					}
					http.open(this.protocol || "GET", srv + (nocache ? (srv.match(/\?/) ? "&" : "?") + Math.random() : ""), async);
					this.queue[id][0] = http;
					async = true; //force async
					useOtherXH = true;
				}
				catch(e){}
			}
			
			// Retry request by routing it
			if(!useOtherXH && this.autoroute && !autoroute){
				if(!isNot(id)){
					clearInterval(this.queue[id][5]);
					//this.queue[id] = null;
				}
				this.shouldAutoroute = true;
				return this.get(url, receive, async, userdata, nocache, data, useXML, id, true, useXSLT);
			}
			
			if(!useOtherXH){
				//Routing didn't work either... Throwing error
				var noClear = receive ? receive(null, __RPC_ERROR__, {
					userdata : userdata,
					http : http,
					url : url,
					tpModule : this,
					id : id,
					message : "Permission denied accessing remote resource: " + url
				}) : false;
				if(!noClear) this.clearQueueItem(id);
				
				return;
			}
		}

		if(this.__HeaderHook) this.__HeaderHook(http);

			http.send(data);

		if(!async) return this.receive(id);
	}

	this.receive = function(id){
		if(!this.queue[id]) return false;

		clearInterval(this.queue[id][5]);

		var data, message;
		var http = this.queue[id][0];

		// Test if HTTP object is ready
		try{if(http.status){}}catch(e){return setTimeout('Kernel.lookup(' + this.uniqueId + ').receive(' + id + ')', 10);}

		var callback = this.queue[id][1];
		var useXML = this.queue[id][7];
		var userdata = this.queue[id][4];
		var retries = this.queue[id][8];
		
		var a = this.queue[id][6];
		var from_url = a[0];
		var useXSLT = a[4];
		
		Kernel.debugMsg("<strong>Receiving [" + id + "]" + (http.isCaching ? "[<span style='color:orange'>cached</span>]" : "") + " from " + from_url + "<br /></strong>" + http.responseText.replace(/\&/g, "&amp;").replace(/\</g, "&lt;").replace(/\n/g, "<br />") + "<hr />", "teleport");
		
		setStatus("[HTTP] Receiving [" + id + "]" + (http.isCaching ? "[caching]" : "") + " from " + from_url, "steleport");

		try{
			var msg = "";

			// Check HTTP Status
			if(http.status != 200 && http.status != 0){
				if(this.isRPC && this.checkPermissions && this.checkPermissions(message, {id:id, http:http, tpModule:this, retries:retries}) === true) return;
				throw new Error(0, "HTTP error [" + id + "]:" + http.status + "\n" + http.responseText);
			}

			// Check for XML Errors
			if(useXML || this.useXML){
				if(http.responseText.replace(/^[\s\n\r]+|[\s\n\r]+$/g, "") == "") throw new Error("Empty Document");
				
				msg = "Received invalid XML\n\n";
				//var lines = http.responseText.split("\n");
				//if(lines[22] && lines[22].match(/Cafco /)) lines[22] = "";
				//lines.join("\n")
				var xmlDoc = http.responseXML && http.responseXML.documentElement ? Kernel.xmlParseError(http.responseXML) : Kernel.getObject("XMLDOM", http.responseText);
				if(IS_IE) xmlDoc.setProperty("SelectionLanguage", "XPath");
				var xmlNode = xmlDoc.documentElement;
			}

			// Get content
			var data = useXML || this.useXML ? xmlNode : http.responseText;

			// Check RPC specific Error messages
			if(this.isRPC){
				msg = "RPC result did not validate: ";
				message = this.checkErrors(data, http, {id:id, http:http, tpModule:this});
				if(this.checkPermissions && this.checkPermissions(message, {id:id, http:http, tpModule:this, retries:retries}) === true) return;
				data = this.unserialize(message);
			}
			
			//Use XSLT to transform xml node if needed
			if(useXML && useXSLT){
				var xmlNode = data;
				this.getXML(useXSLT, function(data, state, extra){
					if(state != __HTTP_SUCCESS__){
						if(state == __HTTP_TIMEOUT__ && extra.retries < MAX_JAV_RETRIES) return extra.tpModule.retry(extra.id);
						else{
							extra.userdata.message = "Could not load XSLT from external resource :\n\n" + extra.message;
							extra.userdata.callback(data, state, extra.userdata);
						}
					}

					var result = xmlNode.transformNode(data);
					
					var noClear = extra.userdata.callback ? extra.userdata.callback([result, xmlNode], __RPC_SUCCESS__, extra.userdata) : false;
					if(!noClear) extra.tpModule.queue[id] = null;
				}, true, {
					callback : callback,
					userdata : userdata,
					http : http,
					url : from_url,
					tpModule : this,
					id : id,
					retries : retries
				});
				
				return;
			}
		}
		catch(e){
			// Send callback error state
			var noClear = callback ? callback(data, __RPC_ERROR__, {
				userdata : userdata,
				http : http,
				url : from_url,
				tpModule : this,
				id : id,
				message : msg + e.message,
				retries : retries
			}) : false;
			if(!noClear){
				http.abort();
				this.clearQueueItem(id);
			}

			return;
		}
		
		//Caching
		if(a[5]){
			if(!this.cache[from_url]) this.cache[from_url] = {};
			this.cache[from_url][a[2]] = http.responseText;
		}

		var noClear = callback ? callback(data, __RPC_SUCCESS__, {
			userdata : userdata,
			http : http,
			url : from_url,
			tpModule : this,
			id : id,
			retries : retries
		}) : false;
		if(!noClear) this.clearQueueItem(id);

		return data;
	}

	this.dotimeout = function(id){
		if(!this.queue[id]) return false;

		clearInterval(this.queue[id][5]);
		var http = this.queue[id][0];

		// Test if HTTP object is ready
		try{if(http.status){}}catch(e){return setTimeout('HTTP.dotimeout(' + id + ')', 10);}

		var callback = this.queue[id][1];
		var useXML = this.queue[id][7];
		var userdata = this.queue[id][4];

		http.abort();

		Kernel.debugMsg("<strong>HTTP Timeout [" + id + "]<br /></strong><hr />", "teleport");
		
		setStatus("[HTTP] Timeout [" + id + "]", "steleport");

		var noClear = callback ? callback(null, __RPC_TIMEOUT__, {
			userdata : userdata,
			http : http,
			url : this.queue[id][6][0],
			tpModule : this,
			id : id,
			message : "HTTP Call timed out",
			retries : this.queue[id][8]
		}) : false;
		if(!noClear) this.clearQueueItem(id);
	}
	
	this.clearQueueItem = function(id){
		if(!this.queue[id]) return false;
		
		if(IS_IE50) clearInterval(this.queue[id][5]);
		Kernel.releaseHTTP(this.queue[id][0]);
		this.queue[id] = null;
		delete this.queue[id];
		
		return true;
	}

	this.retry = function(id){
		if(!this.queue[id]) return false;

		clearInterval(this.queue[id][5]);
		var q = this.queue[id];
		var a = q[6];

		Kernel.debugMsg("<strong>Retrying request...<br /></strong><hr />", "teleport");
		
		setStatus("[HTTP] Retrying request [" + id + "]", "steleport");

		q[8]++;
		this.get(a[0], q[1], a[1], q[4], a[3], a[2], q[7], id, null, null, a[5]);
		
		return true;
	}

	this.cancel = function(id){
		if(id === null) id = this.queue.length-1;
		if(!this.queue[id]) return false;
		
		//this.queue[id][0].abort();
		this.clearQueueItem(id);
	}

	if(!this.load){
		this.load = function(x){
			var receive = x.getAttribute("receive");
			
			for(var i=0;i<x.childNodes.length;i++){
				if(x.childNodes[i].nodeType != 1) continue;
				
				var useXML = x.childNodes[i].getAttribute("type") == "XML";
				var url = x.childNodes[i].getAttribute("url");
				var receive = x.childNodes[i].getAttribute("receive") || receive;
				var async = x.childNodes[i].getAttribute("async") != "false";
				
				this[x.childNodes[i].getAttribute("name")] = function(data, userdata){
					return this.get(url, self[receive], async, userdata, false, data, useXML);
				}
			}
		}
		
		this.instantiate = function(x){
			var url = x.getAttribute("src");
			var useXSLT = x.getAttribute("xslt");
			var async = x.getAttribute("async") != "false";

			this.getURL = function(data, userdata){
				return this.get(url, this.callbacks.getURL, async, userdata, false, data, true, null, null, useXSLT);
			}
			
			var name = "http" + Math.round(Math.random()*100000);
			Kernel.setReference(name, this);
			
			return name + ";getURL";
		}
		
		this.call = function(method, args){
			this[method].call(this, args);
		}
	}
}

//Init.addConditional(function(){Kernel.Comm.register("http", "variables", HTTP);}, null, ['Kernel']);
Init.run('HTTP');

/*FILEHEAD(/in/TelePort/IFRAME.js)SIZE(3140)TIME(1170043381799)*/
Init.run('XMLDatabase');
/*FILEHEAD(/in/TelePort/Poll.js)SIZE(3527)TIME(1157592830432)*/

/*FILEHEAD(/in/TelePort/RPC/HEADER.js)SIZE(1508)TIME(1169033503857)*/

function HEADER(){
	this.supportMulticall = false;
	this.protocol = "GET";
	this.vartype = "header";
	this.isXML = true;
	this.namedArguments = true;

	// Register Communication Module
	this.SmartBindingHook = ["rpc", "arguments"];
	Kernel.TelePort.register(this);

	// Stand Alone
	if(!this.uniqueId){
		Kernel.makeClass(this);
		this.inherit(CommBaseClass);
		this.inherit(HTTP);
		this.inherit(RPC);
	}

	this.unserialize = function(str){
		return str;
	}

	// Create message to send
	this.serialize = function(functionName, args){
		for(var hFunc=[],i=0;i<args.length;i++){
	   	if(!args[i][0] || !args[i][1]) continue;

			Kernel.debugMsg("<strong>" + args[i][0] + ":</strong> " + args[i][1] + "<br />", "teleport");

   		http.setRequestHeader(args[i][0], args[i][1]);
	   }
	   
	   this.__HeaderHook = new Function('http', hFunc.join("\n"));

		return "";
	}

	// Check Received Data for errors
	this.checkErrors = function(data, http){
		return data;
	}

	this.__load = function(x){
		if(x.getAttribute("method-name")){
			var mName = x.getAttribute("method-name");
			var nodes = x.childNodes;

			for(var i=0;i<nodes.length;i++){
				var y = nodes[i];
				var v = y.insertBefore(x.ownerDocument.createElement("variable"), y.firstChild);
				v.setAttribute("name", mName);
				v.setAttribute("value", y.getAttribute("name"));
			}
		}
	}
}


/*FILEHEAD(/in/TelePort/RPC/JPHP.js)SIZE(3080)TIME(1175629500155)*/

function JPHP(){
	this.supportMulticall = true;
	this.multicall = false;
	this.mcallname = "multicall";
	this.protocol = "POST";
	this.useXML = true;
	this.namedArguments = false;

	// Register Communication Module
	this.SmartBindingHook = ["rpc", "arguments"]
	Kernel.TelePort.register(this);

	// Stand Alone
	if(!this.uniqueId){
		Kernel.makeClass(this);
		this.inherit(CommBaseClass);
		this.inherit(HTTP);
		this.inherit(RPC);
	}

	// Serialize Objects
	var serialize = {
		host : this,
		
		object : function(ob){
			var ob = ob.valueOf();

			var length = 0, x = "";
			for(prop in ob){
				if(typeof this[prop] != "function"){
					length++;
					//WEIRD FUCKED UP INTERNET EXPLORER BUG
					var r = prop;
					x += this.host.doSerialize(r) + ";" + this.host.doSerialize(ob[r]) + (typeof ob[r] == "object" || typeof ob[r] == "array" ? "" : ";");
				}
			}

			if(ob.className) return "O:" + ob.className.length + ":\"" + ob.className + "\":" + length + ":{" + x.substr(0, x.length) + "}";
			return "a:" + length + ":{" + x.substr(0, x.length) + "}";
		},

		string : function(str){
			var str = str.replace(/[\r]/g, "");
			str = str.replace(/\]\]/g, "\]-\]-\]").replace(/\]\]/g, "\]-\]-\]");
			return "s:" + str.length + ":\"" + str + "\"";
		},

		number : function(nr){
			if(nr == parseInt(nr))
				return "i:" + nr;
			else if(nr == parseFloat(nr))
				return "d:" + nr;
			else
				return this["boolean"](false);
		},

		"boolean" : function(b){
			return "b:" + (b == true ? 1 : 0);
		},

		array : function(ar){
			var x = "a:" + ar.length + ":{";
			for(var i=0;i<ar.length;i++)
				x += "i:" + i + ";" + this.host.doSerialize(ar[i]) + (i < ar.length && typeof ar[i] != "object" && typeof ar[i] != "array" ? ";" : "");

			return x + "}";
		}
	}

	this.unserialize = function(str){
		return eval(str.replace(/\|-\|-\|/g, "]]").replace(/\|\|\|/g, "\\n"));
	}

	this.doSerialize = function(args){
		if(typeof args == "function"){
			throw new Error(0, "Cannot Parse functions");
		}
		else if(isNot(args))
			return serialize["boolean"](false);

		return serialize[args.dataType || "object"](args);
	}

	// Create message to send
	this.serialize = function(functionName, args){
  		//Construct the XML-RPC message
  		var message = "<?xml version='1.0' encoding='UTF-16'?><run m='" + functionName + "'><![CDATA[";
  		//for(i=0;i<args.length;i++){
  			message += this.doSerialize(args);
  		//}

  		return message + "]]></run>";
  	}

	// Check Received Data for errors
	this.checkErrors = function(data, http){
   	//handle method result
      if(data && data.tagName == "data"){
      	data = data.firstChild.nodeValue;

			//error handling
			if(data && data[0] == "error") throw new Error(10, data[1]);
		}
		else throw new Error(1083, Kernel.formErrorString(1083, null, "Checking for errors", "Malformed RPC Message: Parse Error\n\n:'" + http.responseText + "'"));

		return data;
	}
}


/*FILEHEAD(/in/TelePort/RPC/JSON.js)SIZE(2497)TIME(1175629500155)*/

// Serialize Objects
var __JSONSerialize = {
	object : function(o){
		var str = [];
		for(var prop in o){
			str.push('"' + prop.replace(/(["\\])/g, '\\$1') + '": ' + serialize(o[prop]));
		}

		return "{" + str.join(", ") + "}";
	},

	string : function(s){
		s = '"' + s.replace(/(["\\])/g, '\\$1') + '"';
		return s.replace(/(\n)/g, "\\n").replace(/\r/g, "");
	},

	number : function(i){
		return i.toString();
	},

	"boolean" : function(b){
		return b.toString();
	},

	date : function(d){
		var padd = function(s, p){
			s=p+s;
			return s.substring(s.length - p.length);
		};
		var y = padd(d.getUTCFullYear(), "0000");
		var m = padd(d.getUTCMonth() + 1, "00");
		var d = padd(d.getUTCDate(), "00");
		var h = padd(d.getUTCHours(), "00");
		var min = padd(d.getUTCMinutes(), "00");
		var s = padd(d.getUTCSeconds(), "00");

		var isodate = y +  m  + d + "T" + h +  ":" + min + ":" + s;

		return '{"jsonclass":["sys.ISODate", ["' + isodate + '"]]}';
	},

	array : function(a){
		for(var q=[],i=0;i<a.length;i++)
			q.push(serialize(a[i]));

		return "[" + q.join(", ") + "]";
	}
}

function serialize(args){
	if(typeof args == "function" || isNot(args))
		return "null";
	return __JSONSerialize[args.dataType || "object"](args);
}

function JSON(){
	this.supportMulticall = false;
	this.multicall = false;

	this.protocol = "POST";
	this.useXML = false;
	this.id = 0;
	this.namedArguments = false;

	// Register Communication Module
	this.SmartBindingHook = ["rpc", "arguments"]
	Kernel.TelePort.register(this);

	// Stand Alone
	if(!this.uniqueId){
		Kernel.makeClass(this);
		this.inherit(CommBaseClass);
		this.inherit(HTTP);
		this.inherit(RPC);
	}
	
	this.getSingleCall = function(name, args, obj){
		obj.push({method: name, params: args});
	}

	// Create message to send
	this.serialize = function(functionName, args){
		this.fName = functionName;
		this.id++;

  		//Construct the XML-RPC message
  		var message = '{"method":"' + functionName + '","params":' + serialize(args) + ',"id":' + this.id + '}';
  		return message;
  	}

  	this.__HeaderHook = function(http){
  		http.setRequestHeader('X-JSON-RPC', this.fName);
  	}

	this.unserialize = function(str){
		var obj = eval('obj=' + str);
		return obj.result;
	}

	// Check Received Data for errors
	this.checkErrors = function(data, http){
		return data;
	}
}


/*FILEHEAD(/in/TelePort/RPC/JSOP.js)SIZE(1616)TIME(1182088294453)*/

function JSOP(){
	this.supportMulticall = false;
	this.multicall = false;
	this.mcallname = "system.multicall";
	this.protocol = "POST";
	this.useXML = false;
	this.id = 0;
	this.namedArguments = true;

	// Register Communication Module
	this.SmartBindingHook = ["rpc", "arguments"]
	Kernel.TelePort.register(this);

	// Stand Alone
	if(!this.uniqueId){
		Kernel.makeClass(this);
		this.inherit(CommBaseClass);
		this.inherit(HTTP);
		this.inherit(RPC);
	}
	
	this.getSingleCall = function(name, args, obj){
		var o = {};
		o[name] = args;//vars;
		obj.push(o);
	}

	// Create message to send
	this.serialize = function(functionName, args){
		this.fName = functionName;
		this.id++;
		
		//Construct the XML-RPC message
		if(this.multicall){
			return serialize(args[0]);
		}
		else{
			var o = {};
			o[functionName] = args;
			return serialize(o);
		}
  	}

  	this.__HeaderHook = function(http){
  		http.setRequestHeader('Accept', 'text/javascript, text/html, application/xml, text/xml, */*');
  		http.setRequestHeader('x-requested-with', 'XMLHttpRequest');
  		http.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
  		//http.setRequestHeader('X-JSON-RPC', this.fName);
  	}

	this.unserialize = function(str){
		return str;
		var obj = eval('obj=' + str);
		return obj.result;
	}

	// Check Received Data for errors
	// Check Received Data for errors
	this.checkErrors = function(data, http, extra){
		return XMLDatabase.getXml(data, true);
	}
}


/*FILEHEAD(/in/TelePort/RPC/POST.js)SIZE(3704)TIME(1186862612725)*/

function POST(){
	this.supportMulticall = true;
	this.mcallname = "multicall";
	this.multicall = false;
	this.protocol = "POST";
	this.vartype = "cgi";
	this.isXML = true;
	this.namedArguments = true;
	this.contentType = "application/x-www-form-urlencoded";

	// Register Communication Module
	this.SmartBindingHook = ["rpc", "arguments"];
	Kernel.TelePort.register(this);

	// Stand Alone
	if(!this.uniqueId){
		Kernel.makeClass(this);
		this.inherit(CommBaseClass);
		this.inherit(HTTP);
		this.inherit(RPC);
	}

	this.unserialize = function(str){
		return str;
	}
	
	this.__HeaderHook = function(http){
	}
	
	this.getSingleCall = function(name, args, obj){
		//var args2={};for(var i = 0;i<args.length;i++)args2[args[i][0]]=args[i][1];
		obj.push(args);
	}
	
	// Create message to send
	this.serialize = function(functionName, args){
		if(functionName == 'postform' && postVars){
			var v = postVars; postVars = null;
			this.URL = this.urls[functionName];
			return v;
		}
		
		var vars = [];

		function recur(o,stack){
			if(isArray(o)){
				for(var j=0;j<o.length;j++) recur(o[j],stack+"%5B"+j+"%5D");
			}
			else if(typeof o == "object"){
				for(prop in o){
					if(typeof o[prop] == "function") continue;
					recur(o[prop],stack+"%5B" + encodeURIComponent(prop) + "%5D");	
				}
			}
			else vars.push(stack+"="+o);
		};

		if(this.multicall){
			vars.push("func="+this.mcallname);
			for(var i=0; i < args[0].length; i++ )
				recur( args[0][i], "f%5B"+i+"%5D" );
		}
		else{
			for(prop in args)
				recur(args[prop], prop);
		}
				
		if( !this.BaseURL ) this.BaseURL = this.URL;
		this.URL = this.urls[functionName] ? this.urls[functionName] : this.BaseURL;

		return vars.join("&");
	}

	// Check Received Data for errors
	this.checkErrors = function(data, http){
		return data;
	}

	this.__load = function(x){
		if(x.getAttribute("method-name")){
			var mName = x.getAttribute("method-name");
			var nodes = x.childNodes;

			for(var i=0;i<nodes.length;i++){
				if(nodes[i].nodeType != 1) continue;
				var y = nodes[i];
				var v = y.insertBefore(x.ownerDocument.createElement("variable"), y.firstChild);
				v.setAttribute("name", mName);
				v.setAttribute("value", y.getAttribute("name"));
			}
		}
	}
	
    /**
     * Submit a form with ajax (POST)
     *
     * @param form     form
     * @param function callback  Called when http result is received
     */
    var postVars;
    this.submitForm = function(form, callback){
        if(!this['postform']) this.addMethod('postform', callback);

        var args = [];
        for (var i=0; i<form.elements.length; i++) {
            if (!form.elements[i].name) continue;
            if (form.elements[i].tagname = 'input' && (form.elements[i].type == 'checkbox' || form.elements[i].type == 'radio') && !form.elements[i].checked) continue;
            
            if (form.elements[i].tagname = 'select' && form.elements[i].multiple) {
                for (j=0; j<form.elements[i].options.length; j++) {
                    if (form.elements[i].options[j].selected) 
                    	args.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].options[j].value));
                }
            }
            else {
                args.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].value));
            }
        }
        
        this.urls['postform'] = form.action || location.href;
        postVars = args.join("&");
        this['postform'].call(this);
        
        return false;
    }
}


/*FILEHEAD(/in/TelePort/RPC/REST.js)SIZE(3533)TIME(1186862612725)*/

function REST(){
	this.supportMulticall = false;
	this.protocol = "GET";
	this.vartype = "cgi";
	this.isXML = true;
	this.namedArguments = true;

	// Register Communication Module
	this.SmartBindingHook = ["rpc", "arguments"];
	Kernel.TelePort.register(this);

	// Stand Alone
	if(!this.uniqueId){
		Kernel.makeClass(this);
		this.inherit(CommBaseClass);
		this.inherit(HTTP);
		this.inherit(RPC);
	}

	this.unserialize = function(str){
		return str;
	}

	this.getSingleCall = function(name, args, obj){
		//var args2={};for(var i = 0;i<args.length;i++)args2[args[i][0]]=args[i][1];
		obj.push(args);
	}
	
	// Create message to send
	this.serialize = function(functionName, args){
		if(functionName == 'postform'){
			this.URL = this.urls[functionName];
			return "";
		}
		
		var vars = [];

		function recur(o,stack){
			if(isArray(o)){
				for(var j=0;j<o.length;j++) recur(o[j],stack+"%5B"+j+"%5D");
			}
			else if(typeof o == "object"){
				for(prop in o){
					if(typeof o[prop] == "function") continue;
					recur(o[prop],stack+"%5B" + encodeURIComponent(prop) + "%5D");	
				}
			}
			else vars.push(stack+"="+o);
		};

		if(this.multicall){
			vars.push("func="+this.mcallname);
			for(var i=0; i < args[0].length; i++ )
				recur( args[0][i], "f%5B"+i+"%5D" );
		}
		else{
			for(prop in args)
				recur(args[prop], prop);
		}
				
		if(!this.BaseURL) this.BaseURL = this.URL;
		var nUrl = this.urls[functionName] ? this.urls[functionName] : this.BaseURL;
		this.URL = nUrl + (nUrl.match(/\?/) ? "&" : "?") + vars.join("&");

		return "";
	}

	// Check Received Data for errors
	this.checkErrors = function(data, http){
		return data;
	}

	this.__load = function(x){
		if(x.getAttribute("method-name")){
			var mName = x.getAttribute("method-name");
			var nodes = x.childNodes;

			for(var i=0;i<nodes.length;i++){
				var y = nodes[i];
				var v = y.insertBefore(x.ownerDocument.createElement("variable"), y.firstChild);
				v.setAttribute("name", mName);
				v.setAttribute("value", y.getAttribute("name"));
			}
		}
	}
	
    /**
     * Submit a form with ajax (GET)
     *
     * @param form     form
     * @param function callback  Called when http result is received
     */
    this.submitForm = function(form, callback){
        if(!this['postform']) this.addMethod('postform', callback);

        var args = [];       
        for (var i=0; i<form.elements.length; i++) {
            if (!form.elements[i].name) continue;
            if (form.elements[i].tagname = 'input' && (form.elements[i].type == 'checkbox' || form.elements[i].type == 'radio') && !form.elements[i].checked) continue;
           
            if (form.elements[i].tagname = 'select' && form.elements[i].multiple) {
                for (j=0; j<form.elements[i].options.length; j++) {
                    if (form.elements[i].options[j].selected) 
                    	args.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].options[j].value));
                }
            }
            else{
                args.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].value));
            }
        }
       
        var loc = (form.action || location.href);
        this.urls['postform'] = loc + (loc.indexOf("?") > -1 ? "&" : "?") + args.join("&");
        this['postform'].call(this);
       
        return false;
    }
}


/*FILEHEAD(/in/TelePort/RPC/SOAP.js)SIZE(6946)TIME(1175629500155)*/

function SOAP(){
	this.supportMulticall = false;
	this.protocol = "POST";
	this.useXML = true;

	this.nsName = "m";
	this.nsURL = "http://www.javeline.org";
	
	this.namedArguments = true;

	// Register Communication Module
	this.SmartBindingHook = ["rpc", "arguments"]
	Kernel.TelePort.register(this);

	// Stand Alone
	if(!this.uniqueId){
		Kernel.makeClass(this);
		this.inherit(CommBaseClass);
		this.inherit(HTTP);
		this.inherit(RPC);
	}

	// Serialize Objects
	var serialize = {
		host : this,

		object : function(o){
			var wo = o.valueOf();

			for(prop in wo){
				if(typeof wo[prop] != "function" && prop != "type"){
					retstr += this.host.doSerialize(wo[prop], prop);
				}
			}

			return retstr;
		},

		string : function(s){
			return s.replace(/\]\]/g, "] ]");//"<![CDATA[" + s.replace(/\]\]/g, "] ]") + "]]>";
		},

		number : function(i){
			return i;
		},

		"boolean" : function(b){
			return b == true ? 1 : 0;
		},

		date : function(d){
			//Could build in possibilities to express dates
			//in weeks or other iso8601 possibillities
			//hmmmm ????
			//19980717T14:08:55
			return doYear(d.getUTCYear()) + doZero(d.getMonth()) + doZero(d.getUTCDate()) + "T" + doZero(d.getHours()) + ":" + doZero(d.getMinutes()) + ":" + doZero(d.getSeconds());

			function doZero(nr) {
				nr = String("0" + nr);
				return nr.substr(nr.length-2, 2);
			}

			function doYear(year) {
				if(year > 9999 || year < 0)
					XMLRPC.handleError(new Error("Unsupported year: " + year));

				year = String("0000" + year)
				return year.substr(year.length-4, 4);
			}
		},

		array : function(a){
			var retstr = "";
			for(var i=0;i<a.length;i++)
				retstr += this.host.doSerialize(a[i], "item");

			return retstr;
		}
	}

	this.doSerialize = function(args, name){
		var c = name ? args : args[1];
		var name = name ? name : args[0];

		if(typeof c == "function") throw new Error(0, "Cannot Parse functions");

		if(c === false)
			return '<' + name + ' xsi:null="1"/>';
		else
			return '<' + name + ' ' + this.getXSIType(c) + '>' + serialize[c.dataType || "object"](c) + '</' + name + '>';
	}

	// get xsi:type
	this.getXSIType = function(c){
		if(!c.dataType) return '';
		else if(c.dataType == "array")
			return 'xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="xsd:ur-type[' + c.length + ']"';
		else if(c.dataType == "number")
			return 'xsi:type="' + (parseInt(c) == c ? "xsd:int" : "xsd:float") + '"';
		else if(c.dataType == "data")
			return 'xsi:type="xsd:timeInstant"';
		else
			return 'xsi:type="xsd:' + c.dataType + '"';
	}

	// Create message to send
	this.serialize = function(functionName, args){
  		//Construct the SOAP message

  		var message = '<?xml version="1.0"?>' +
		'<SOAP-ENV:Envelope SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/" xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/" xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsd="http://www.w3.org/1999/XMLSchema" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance">' +
		'<SOAP-ENV:Body>' +
		'<' + this.nsName + ':' + functionName + ' xmlns:' + this.nsName + '="' + this.nsURL + '">'

   	for(i=0;i<args.length;i++){
   		message += this.doSerialize(args[i]);
		}

		message += '</' + this.nsName + ':' + functionName + '></SOAP-ENV:Body></SOAP-ENV:Envelope>';

  		return message;
  	}

  	this.__HeaderHook = function(http){
  		http.setRequestHeader('SOAPAction', '"' + this.URL.replace(/http:\/\/.*\/([^\/]*)$/, "$1") + '"');
  	}

	this.unserialize = function(data){
		return data;
		var ret, i;

		//xsi:type
		var type = data.getAttribute("xsi:type");
		switch(type){
			case "xsd:string":
				return (data.firstChild) ? new String(data.firstChild.nodeValue) : "";
			break;
			case "xsd:int":
			case "xsd:double":
			case "xsd:float":
				return (data.firstChild) ? new Number(data.firstChild.nodeValue) : 0;
			break;
			case "xsd:timeInstant":
				/*
				Have to read the spec to be able to completely
				parse all the possibilities in iso8601
				07-17-1998 14:08:55
				19980717T14:08:55
				*/

				var sn = (IS_IE) ? "-" : "/";

				if(/^(\d{4})(\d{2})(\d{2})T(\d{2}):(\d{2}):(\d{2})/.test(data.firstChild.nodeValue)){;//data.text)){
	      		return new Date(RegExp.$2 + sn + RegExp.$3 + sn +
	      							RegExp.$1 + " " + RegExp.$4 + ":" +
	      							RegExp.$5 + ":" + RegExp.$6);
	      	}
	    		else{
	    			return new Date();
	    		}

			break;
			case "xsd:boolean":
				return Boolean(isNaN(parseInt(data.firstChild.nodeValue)) ? (data.firstChild.nodeValue == "true") : parseInt(data.firstChild.nodeValue))

			break;
			case "SOAP-ENC:base64":
				return Kernel.decodeBase64(data.firstChild.nodeValue);
			break;
			case "SOAP-ENC:Array":
				var nodes = data.childNodes;

				ret = new Array();
				for(var i=0;i<nodes.length;i++){
					if(nodes[i].nodeType != 1) continue;
     				ret.push(this.unserialize(nodes[i]));
     			}

				return ret;

			break;
			default:
				//Custom Type
				if(type && !self[type]) throw new Error(1084, Kernel.formErrorString(1084, null, "SOAP", "Invalid Object Specified in SOAP message: " + type));

				var nodes = data.childNodes;
				var o = type ? new self[type] : {};

				ret = new Array();
				for(var i=0;i<nodes.length;i++){
					if(nodes[i].nodeType != 1) continue;
     				ret[nodes[i].tagName] = this.unserialize(nodes[i]);
     			}

				return ret;
			break;
		}
	}

	// Check Received Data for errors
	this.checkErrors = function(data, http){
		/*var fault = data.selectSingleNode("Fault");
		if(fault){
			var nr = fault.selectSingleNode("faultcode/text()").nodeValue;
			var msg = "\n" + fault.selectSingleNode("faultstring/text()").nodeValue;
			throw new Error(nr, msg);
		}

		else if(data.getElementsByTagName("Errors")){
			var fault = data.getElementsByTagName("Errors")[0];
			var nr = fault.selectSingleNode("node()/node()/text()").nodeValue;
			var msg = "\n" + fault.selectSingleNode("node()/node()[2]/text()").nodeValue;
			throw new Error(nr, msg);
		}*/

		// IE Hack
		if(IS_IE)
			data.ownerDocument.setProperty("SelectionNamespaces", "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:xds='http://www.w3.org/2001/XMLSchema' xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/'");

		rvalue = data.getElementsByTagName("SOAP-ENV:Body")[0];///node()/node()[2]
		if(!rvalue && data.getElementsByTagNameNS) rvalue = data.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body")[0]

		return rvalue;
	}

	this.__load = function(x){
		if(x.getAttribute("ns-name")) this.nsName = x.getAttribute("ns-name");
		if(x.getAttribute("ns-url")) this.nsURL = x.getAttribute("ns-url");
	}
}


/*FILEHEAD(/in/TelePort/RPC/XMLP.js)SIZE(1682)TIME(1186393727279)*/

function XMLP(){
	this.supportMulticall = false;
	this.multicall = false;
	this.mcallname = "system.multicall";
	this.protocol = "POST";
	this.useXML = false;
	this.id = 0;
	this.namedArguments = false;

	// Register Communication Module
	this.SmartBindingHook = ["rpc", "arguments"]
	Kernel.TelePort.register(this);

	// Stand Alone
	if(!this.uniqueId){
		Kernel.makeClass(this);
		this.inherit(CommBaseClass);
		this.inherit(HTTP);
		this.inherit(RPC);
	}
	
	this.getSingleCall = function(name, args, obj){
		obj.push("<" + name + ">" + (args[0] ? (typeof args[0] == "string" ? args[0] : args[0].xml.replace(/^<[^>]*>/,"").replace(/<[^>]*>$/,"")) : "") + "</" + name + ">");
		return obj;
	}

	// Create message to send
	this.serialize = function(functionName, args){
		this.fName = functionName;
		this.id++;
		
		//Construct the XML-RPC message
		if(this.multicall){
			return "<Nbd>" + args[0].join("") + "</Nbd>";
		}
		else{
			return "<Nbd>" + this.getSingleCall(functionName, args, [])[0] + "</Nbd>";
		}
  	}

  	this.__HeaderHook = function(http){
  		http.setRequestHeader('Accept', 'text/javascript, text/html, application/xml, text/xml, */*');
  		http.setRequestHeader('x-requested-with', 'XMLHttpRequest');
  		http.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
  		//http.setRequestHeader('X-JSON-RPC', this.fName);
  	}

	this.unserialize = function(str){
		return str;
	}

	// Check Received Data for errors
	this.checkErrors = function(data, http, extra){
		return XMLDatabase.getXml(data, true);
	}
}


/*FILEHEAD(/in/TelePort/RPC/XMLRPC.js)SIZE(7299)TIME(1182723583203)*/

function XMLRPC(){
	this.supportMulticall = true;
	this.multicall = false;
	this.mcallname = "system.multicall";
	this.protocol = "POST";
	this.useXML = true;
	
	this.namedArguments = false;

	// Register Communication Module
	this.SmartBindingHook = ["rpc", "arguments"]
	Kernel.TelePort.register(this);

	// Stand Alone
	if(!this.uniqueId){
		Kernel.makeClass(this);
		this.inherit(CommBaseClass);
		this.inherit(HTTP);
		this.inherit(RPC);
	}

	// Serialize Objects
	var serialize = {
		host : this,

		object : function(o){
			var wo = o.valueOf();

			retstr = "<struct>";

			for(prop in wo){
				if(typeof wo[prop] != "function" && prop != "type"){
					retstr += "<member><name>" + prop + "</name><value>" + this.host.doSerialize(wo[prop]) + "</value></member>";
				}
			}
			retstr += "</struct>";

			return retstr;
		},

		string : function(s){
			//<![CDATA[***your text here***]]>
			//return "<string><![CDATA[" + s.replace(/\]\]\>/g, "").replace(/\<\!\[\CDATA\[/g, "") + "]]></string>";//.replace(/</g, "&lt;").replace(/&/g, "&amp;")
			return "<string><![CDATA[" + s.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;") + "]]></string>";
			//var str = "<string>" + s.replace(/\&/g, "&amp;").replace(/\</g, "&lt;").replace(/\>/g, "&gt;") + "</string>";//.replace(/</g, "&lt;").replace(/&/g, "&amp;")
			return str;
		},

		number : function(i){
			if(i == parseInt(i)){
				return "<int>" + i + "</int>";
			}
			else if(i == parseFloat(i)){
				return "<double>" + i + "</double>";
			}
			else{
				return this["boolean"](false);
			}
		},

		"boolean" : function(b){
			if(b == true) return "<boolean>1</boolean>";
			else return "<boolean>0</boolean>";
		},

		date : function(d){
			//Could build in possibilities to express dates
			//in weeks or other iso8601 possibillities
			//hmmmm ????
			//19980717T14:08:55
			return "<dateTime.iso8601>" + doYear(d.getUTCYear()) + doZero(d.getMonth()) + doZero(d.getUTCDate()) + "T" + doZero(d.getHours()) + ":" + doZero(d.getMinutes()) + ":" + doZero(d.getSeconds()) + "</dateTime.iso8601>";

			function doZero(nr) {
				nr = String("0" + nr);
				return nr.substr(nr.length-2, 2);
			}

			function doYear(year) {
				if(year > 9999 || year < 0)
					XMLRPC.handleError(new Error(1085, Kernel.formErrorString(1085, null, "XMLRPC serialization", "Unsupported year: " + year)));

				year = String("0000" + year)
				return year.substr(year.length-4, 4);
			}
		},

		array : function(a){
			var retstr = "<array><data>";
			for(var i=0;i<a.length;i++){
				retstr += "<value>";
				retstr += this.host.doSerialize(a[i])
				retstr += "</value>";
			}
			return retstr + "</data></array>";
		}
	}

	this.getSingleCall = function(name, args, obj){
		obj.push({m: name, p: args});
	}

	this.doSerialize = function(args){
		if(typeof args == "function"){
			throw new Error(1086, Kernel.formErrorString(1086, null, "XMLRPC serialization", "Cannot Parse functions"));
		}
		else if(isNot(args))
			return serialize["boolean"](false);

		return serialize[args.dataType || "object"](args);
	}

	// Create message to send
	this.serialize = function(functionName, args){
  		//Construct the XML-RPC message
		var message = '<?xml version="1.0" encoding=\"UTF-8\"?><methodCall><methodName>' + functionName + '</methodName><params>';
   		for(i=0;i<args.length;i++){
   			message += '<param><value>' + this.doSerialize(args[i]) + '</value></param>';
		}
		message += '</params></methodCall>';

  		return message;
  	}

  	// Needs revision (still from vcXMLRPC)
	this.getNode = function(data, tree){
		var nc = 0;//nodeCount

		//node = 1
		if(data != null){
			for(i=0;i<data.childNodes.length;i++){
				if(data.childNodes[i].nodeType == 1){
					if(nc == tree[0]){
						data = data.childNodes[i];
						if(tree.length > 1){
							tree.shift();
							data = this.getNode(data, tree);
						}
						return data;
					}
					nc++
				}
			}
		}

		return false;
	}

	this.unserialize = function(data){
		var ret, i;

		switch(data.tagName){
			case "string":
				if(IS_GECKO){
					data = (new XMLSerializer()).serializeToString(data);
					data = data.replace(/^\<string\>/,'');
					data = data.replace(/\<\/string\>$/,'');
					data = data.replace(/\&lt;/g, "<");
					data = data.replace(/\&gt;/g, ">");

					return data;
				}

				return (data.firstChild) ? data.firstChild.nodeValue : "";
				break;
			case "int":
			case "i4":
			case "double":
				return (data.firstChild) ? new Number(data.firstChild.nodeValue) : 0;
				break;
			case "dateTime.iso8601":
				/*
				Have to read the spec to be able to completely
				parse all the possibilities in iso8601
				07-17-1998 14:08:55
				19980717T14:08:55
				*/

				var sn = (IS_IE) ? "-" : "/";

				if(/^(\d{4})(\d{2})(\d{2})T(\d{2}):(\d{2}):(\d{2})/.test(data.firstChild.nodeValue)){;//data.text)){
	      		return new Date(RegExp.$2 + sn + RegExp.$3 + sn +
	      							RegExp.$1 + " " + RegExp.$4 + ":" +
	      							RegExp.$5 + ":" + RegExp.$6);
	      	}
	    		else{
	    			return new Date();
	    		}

				break;
			case "array":
				data = this.getNode(data, [0]);

				if(data && data.tagName == "data"){
					ret = new Array();

					var i = 0;
					while(child = this.getNode(data, [i++])){
      				ret.push(this.unserialize(child));
					}

					return ret;
				}
				else{
					this.handleError(new Error(1087, Kernel.formErrorString(1087, null, "", "Malformed XMLRPC Message")));
					return false;
				}
				break;
			case "struct":
				ret = {};

				var i = 0;
				while(child = this.getNode(data, [i++])){
					if(child.tagName == "member"){
						ret[this.getNode(child, [0]).firstChild.nodeValue] = this.unserialize(this.getNode(child, [1]));
					}
					else{
						this.handleError(new Error(1087, Kernel.formErrorString(1087, null, "", "Malformed XMLRPC Message2")));
						return false;
					}
				}

				return ret;
				break;
			case "boolean":
				return Boolean(isNaN(parseInt(data.firstChild.nodeValue)) ? (data.firstChild.nodeValue == "true") : parseInt(data.firstChild.nodeValue))

				break;
			case "base64":
				return Kernel.decodeBase64(data.firstChild.nodeValue);
				break;
			case "value":
				child = this.getNode(data, [0]);
				return (!child) ? ((data.firstChild) ? new String(data.firstChild.nodeValue) : "") : this.unserialize(child);

				break;
			default:
				throw new Error(1088, Kernel.formErrorString(1088, null, "", "Malformed XMLRPC Message: " + data.tagName));
				return false;
				break;
		}
	}

	// Check Received Data for errors
	this.checkErrors = function(data, http){
		if(this.getNode(data, [0]).tagName == "fault"){
			if(!Kernel.isSafari){
				var nr = data.selectSingleNode("//member[name/text()='faultCode']/value/int/text()").nodeValue;
				var msg = "\n" + data.selectSingleNode("//member[name/text()='faultString']/value/string/text()").nodeValue;
			}else{nr = msg = ""}

			throw new Error(nr, msg);
		}

		data = this.getNode(data, [0,0,0]);

		return data;
	}
}


/*FILEHEAD(/in/TelePort/RPC.js)SIZE(7604)TIME(1188383718500)*/

function RPC(){
	if(!this.supportMulticall) this.multicall = false;

	this.stack = {};
	this.globals = {};
	this.names = {};
	this.urls = {};

	this.isRPC = true;
	this.useHTTP = true;
	this.TelePortModule = true;

	this.routeServer = HOST + "/cgi-bin/rpcproxy.cgi";
	this.autoroute = false;

	this.namedArguments = false;

	/* ADD METHODS */

	this.addMethod = function(name, receive, names, async, vexport, is_global, global_name, global_lookup, caching){
		if(is_global) this.callbacks[name] = new Function('data', 'status', 'extra', 'Kernel.lookup(' + this.uniqueId + ').setGlobalVar("' + global_name + '"' + ', data, extra.http, "' + global_lookup + '", "' + receive + '", extra, status)');
		else if(receive) this.callbacks[name] = receive;

		this.setName(name, names);
		if(vexport) this.vexport = vexport;
		this[name] = new Function('return this.call("' + name + '"' + ', this.fArgs(arguments, this.names["' + name + '"], ' + (this.vartype != "cgi" && this.vexport == "cgi") + '));');
		this[name].async = async;
		this[name].caching = caching;

		return true;
	}

	this.setName = function(name, names){
		this.names[name] = names;
	}

	this.setCallback = function(name, func){
		this.callbacks[name] = func;
	}

	this.fArgs = function(a, nodes, no_globals){
		var args = this.namedArguments ? {} : [];
		if(!no_globals) for(var i=0;i<this.globals.length;i++) args[this.globals[i][0]] = this.globals[i][1];
		
		if(nodes && nodes.length){
			for(var value, j=0,i=0;i<nodes.length;i++){
				// Determine value
				var name = nodes[i].getAttribute("name");
				if(nodes[i].getAttribute("value")) value = nodes[i].getAttribute("value");
				else if(nodes[i].getAttribute("method")) value = self[nodes[i].getAttribute("method")](args);
				else{
					//Fugly Rik Hack				
					if ( a.length==1 && typeof a[0]=='object'){
					    //typeof(a[0][name]) != "undefined";
						value = a[0][name];
					}else{
						value = a[j];
						j++;
					}
					if(isNot(value)) value = nodes[i].getAttribute("default");
				}

				//Encode string optionally
				value = nodes[i].getAttribute("encoded") == "true" ? encodeURIComponent(value) : value;

				//Set arguments
				this.namedArguments ? (args[name] = value) : (args.push(value)); //isn't this only called for namedArguments = true (should)
			}
		}
		else
			for(var i=0;i<a.length;i++) args.push(a[i]);
		
		return args;
	}

	/* GLOBALS */

	this.setGlobalVar = function(name, data, http, lookup, receive, extra, status){
		if(status != __RPC_SUCCESS__){
			Kernel.debugMsg("Could not get Global Variable<br />", "teleport");

			if(receive) self[receive](data, status, extra);
			return;
		}

		if(this.vartype == "header" && lookup && http) data = http.getResponseHeader(lookup);
		if(lookup.split("\:", 2)[0] == "xpath"){

			try{
				var doc = Kernel.getObject("XMLDOM", data).documentElement;
			}
			catch(e){
				throw new Error(1083, Kernel.formErrorString(1083, null, "Receiving global", "Returned value is not XML (for global variable lookup with name '" + name + "')"));
			}

			var xmlNode = doc.selectSingleNode(lookup.split("\:", 2)[1]);
			var data = xmlNode.nodeValue();
		}

		for(var found=false,i=0;i<this.globals.length;i++){
			if(this.globals[i][0] == name){
				this.globals[i][1] = data;
				found = true;
			}
		}
		if(!found) this.globals.push([name, data]);

		if(receive) self[receive](data, __RPC_SUCCESS__, extra);
	}

	/* CALL */

	this.call = function(name, args){
		if(this.workOffline) return;
		
		if(this.oncall) this.oncall(name, args);

		var receive = typeof this.callbacks[name] == "string" ? self[this.callbacks[name]] : this.callbacks[name];
		if(!receive) receive = function(){}
		//if(!receive){throw new Error(1602, "---- Javeline Error ----\nProcess :  RPC Send\nMessage : Callback method is not declared: '" + this.callbacks[name] + "'")}

		// Set up multicall
		if(this.multicall){
			if(!this.stack[this.URL]) this.stack[this.URL] = this.getMulticallObject ? this.getMulticallObject() : new Array();
			//this.stack[this.URL].push();
			this.getSingleCall(name, args, this.stack[this.URL])
			return true;
		}

		// Get Data
		var data = this.serialize(name, args); //function of module

		// Sent the request
		var info = this.get(this.URL, receive, this[name].async, this[name].userdata, true, data, false, null, null, null, this[name].caching);

		return info;
	}

	/* PURGE MULTICALL */

	this.purge = function(receive, userdata, sync){
		if(!this.stack[this.URL] || !this.stack[this.URL].length) throw new Error(0, Kernel.formErrorString(0, null, "Executing a multicall", "No RPC calls where executed before calling purge()."));
		
		// Get Data
		var data = this.serialize("multicall", [this.stack[this.URL]]); //function of module

		info = this.get(this.URL, receive, !sync, userdata, true, data, false);
		this.stack[this.URL] = this.getMulticallObject ? this.getMulticallObject() : [];

		//return info[1];
	}

	this.revert = function(modConst){
		this.stack[modConst.URL] = this.getMulticallObject ? this.getMulticallObject() : [];
	}

	/* Load XML Definitions */

	this.load = function(x){
		this.jml = x;
		this.timeout = parseInt(x.getAttribute("timeout")) || this.timeout;
		this.URL = x.getAttribute("url-eval") ? eval(x.getAttribute("url-eval")) : x.getAttribute("url");
		if(this.URL) this.server = this.URL.replace(/^(.*\/\/[^\/]*)\/.*$/, "$1") + "/";
		this.multicall = x.getAttribute("multicall") == "true";
		this.autoroute = x.getAttribute("autoroute") == "true";
		this.workOffline = x.getAttribute("offline") == "true";

		if(this.__load) this.__load(x);

		var q = x.childNodes;
		for(var url, i=0;i<q.length;i++){
			if(q[i].nodeType != 1) continue;

			if(q[i].tagName == "global"){
				this.globals.push([q[i].getAttribute("name"), q[i].getAttribute("value")]);
				continue;
			}

			if(IS_IE) var nodes = q[i].getElementsByTagName("j:variable|variable");
			else{
				var nodes = q[i].getElementsByTagNameNS("http://javeline.nl/j", "variable");
				if(!nodes.length) nodes = q[i].getElementsByTagName("variable");
			}

			url =q[i].getAttribute("url-eval") ? eval(q[i].getAttribute("url-eval")) : q[i].getAttribute("url");
			if(url) this.urls[q[i].getAttribute("name")] = url;

			//Add Method
			this.addMethod(
				q[i].getAttribute("name"),
				q[i].getAttribute("receive") || x.getAttribute("receive"),
				nodes,
				(q[i].getAttribute("async") == "false" ? false : true),
				q[i].getAttribute("export"),
				q[i].getAttribute("type") == "global",
				q[i].getAttribute("variable"),
				q[i].getAttribute("lookup"),
				q[i].getAttribute("caching") == "true"
			);
		}
	}
	
	/**
	 * Post a form with ajax
 	 *
 	 * @param form     form
 	 * @param function callback  Called when http result is received
	this.submitForm = function(form, callback, callName) {
		this.addMethod('postform', callback);
		this.urls['postform'] = form.action;

		var args = [];
		for (var i=0; i < form.elements.length; i++) {
			var name = form.elements[i].name.split("[");
			for(var j=0;j<name.length;j++){
				//Hmm problem with sequence of names... have to get that from the variable sequence...
			}
			args[] = form.elements[i].value;  
		}
		
		this['postform'].apply(this, args);
	}*/
}

/*FILEHEAD(/in/TelePort/Socket.js)SIZE(3545)TIME(1165185609774)*/

//Depends on implementation of Javeline HTTP Socket on Server Side
function Socket(){
	this.uniqueId = Kernel.all.push(this) - 1;
	this.server = null;
	this.timeout = 10000;
	
	this.TelePortModule = true;
	
	/*************************************************************
				Receiving - Permanent Connection (HTTP-PUSH)
	*************************************************************/
	this.init = function(){
		this.iframe = document.createElement("IFRAME");
		document.body.appendChild(this.iframe);
		this.iframe.style.position = "absolute";

		//if(!IS_IE) importClass(MozillaCompat, true, this.iframe.contentWindow);
		
		/*if(self.DEBUG){
			this.iframe.style.left = "0px";
			this.iframe.style.top = "0px";
			this.iframe.style.zIndex = 100;
		}
		else */
		this.iframe.style.display = "none";
		this.timer = setInterval("var o = Kernel.lookup(" + this.uniqueId + ");if(o.iframe.contentWindow.document.readyState == 'complete') o.reconnect()", 1000);
		
		this.inited = true;
	}

	this.socketConnect = function(vars){
		if(!this.inited) this.init();
		
		if(!vars) vars = [["date", new Date().getTime()]];
		else vars.push(["date", new Date().getTime()]);

		for(var str="",i=0;i<vars.length;i++)
			vars[i] = vars[i][0] + "=" + escape(vars[i][1])

		this.iframe.src = this.server + "?connection_id=" + this.uniqueId + "&" + vars.join("&");
		return this;
	}

	this.reconnect = function(){
		this.iframe.contentWindow.location.reload();
	}

	this.socketDisconnect = function(){
		clearInterval(this.timer);
		this.iframe.src = "blank.html";this.iframe.src = "blank.html";
	}

	this.setConnectionId = function(listenId){
		this.connectionId = listenId;
	}

	this.receive = function(module, strdata){
		Kernel.debugMsg("<strong>HTTP Socket RCV: [" + module + "] - " + strdata.replace(/</g, "&lt;") + "</strong><hr />", "teleport");

		if(module == "LISTENER_ID") this.listenerId = strdata;
		else{
			var o = eval(strdata.replace(/\]-\]-\]/g, "]]").replace(/\|\|\|/g, "\\n"));
			//if(this.onreceive) this.onreceive(module, o);
			if(this.onreceive) self[this.onreceive](module, o);
		}
	}

	/*************************************************************
						Forward Communication (RPC)
	*************************************************************/

	this.send = function(module, data){
		Kernel.debugMsg("<strong>HTTP Socket SND: [" + module + "] - " + data.toString().replace(/</g, "&lt;") + "</strong><hr />", "teleport");

		this.forward.send(this.connectionId, module, data);
	}

	this.purge = function(){
		this.forward.purge();
	}

	this.load = function(x){
		this.server = x.getAttribute("url-eval") ? eval(x.getAttribute("url-eval")) : x.getAttribute("url");
		
		var fName = x.getAttribute("f-type") || "JPHP";
		
		this.forward = new self[fName]();
		this.forward.addMethod("send", null, null, true)
		
		this.forward.timeout = parseInt(x.getAttribute("timeout")) || this.timeout;
		this.forward.URL = this.server;
		this.forward.server = this.server.replace(/^(.*\/\/[^\/]*)\/.*$/, "$1") + "/";
		if(x.getAttribute("var-type")) this.forward.vartype = x.getAttribute("var-type");
		this.forward.multicall = x.getAttribute("multicall") == "true";
		
		if(x.getAttribute("mode") != "manual") this.socketConnect();
		if(x.getAttribute("receive")) this.onreceive = x.getAttribute("receive");
	}
}


/*FILEHEAD(/in/jpack_end.js)SIZE(8509)TIME(1185049651181)*/
function loadIncludes(docElement){
	//Subwindow
	if(false && window.opener && window.opener.Application){
		if(document.all) document.body.innerHTML = window.opener.Application.xml.outerHTML;
		LoadData["interface"] = [window.opener.Application.xmlClass, document.all ? document.getElementsByTagName("Application")[0] : window.opener.Application.xml];
		
		/*if(LoadData[1].getElementsByTagName("LoadScreen").length){
			if(!document.all) document.body.innerHTML = "";
			loadScreen = XMLDatabase.htmlImport(Kernel.getElement(LoadData[1].getElementsByTagName("LoadScreen")[0], 0), document.body);
		}*/

		document.body.style.display = "block";
		return;
	}

	//Load current HTML document as 'second DOM'
	
	
	if((!IS_IE || document.body.getAttribute("mode") == "xml") && !docElement){
		return new HTTP().getString((document.body.getAttribute("xml-url") || location.href).split(/#/)[0], function(xmlString, status, extra){
			if(status != __HTTP_SUCCESS__) throw new Error(extra.message);
			
			var str = xmlString.replace(/\<\!DOCTYPE[^>]*>/, "").replace(/&nbsp;/g, " ").replace(/xmlns\=\"[^"]*\"/g, "").replace(/&\w+;/, "").replace(/^[\r\n\s]*/, ""); 
			//var str = xmlString.replace(/xmlns\=\"[^"]*\"/g, "").split("\n"); str.shift(); str = str.join("\n");//.replace(/\<(\/?)j\:/g, "<$1").split("\n"); str.shift(); str = str.join("\n");
			var xmlNode = Kernel.getObject("XMLDOM", str);
			if(Kernel.xmlParseError) Kernel.xmlParseError(xmlNode);
			
			if(IS_IE) document.body.innerHTML ="";
	
			//Clear Body
			if(IS_IE) document.body.innerHTML ="";
			else{
				var nodes = document.body.childNodes;
				for(var i=nodes.length-1;i>=0;i--) nodes[i].parentNode.removeChild(nodes[i]);
			}
			
			return loadIncludes(xmlNode);
		}, true);
	}
	else if(!docElement) docElement = document;
	
	//Check for docType

	//Parse the second DOM (add includes)
	
	AppData = IS_SAFARI ? docElement.createElementNS("http://www.javeline.net", "j:application") : docElement.createElement("j:application");
	var win = AppData.appendChild(IS_SAFARI ? docElement.createElementNS("http://www.javeline.net", "j:window") : docElement.createElement("j:window"));
	win.setAttribute("id", "main");

	var nodes = (docElement.body ? docElement.body : docElement.selectSingleNode("/html/body")).childNodes;
	for(var i=nodes.length-1;i>=0;i--) win.insertBefore(nodes[i], win.firstChild);
	docElement.documentElement.appendChild(AppData); //Firefox fix for selectNode insertion need...
	

	loadJMLIncludes(AppData);
	
	
	if($j(AppData, "loader").length){
		if(IS_GECKO || IS_SAFARI) document.body.innerHTML = "";
		if(IS_SAFARI_OLD){
			var q = Kernel.getElement($("loader", AppData, "j")[0], 0).serialize();
			document.body.insertAdjacentHTML("beforeend", q);
			loadScreen = document.body.lastChild;
		}
		else{
			var htmlNode = Kernel.getElement($j(AppData, "loader")[0], 0);
			
			//if(IS_SAFARI) loadScreen = document.body.appendChild(document.importNode(htmlNode, true));
			if(htmlNode.ownerDocument == document) loadScreen = document.body.appendChild(htmlNode.cloneNode(true));
			else{
				document.body.insertAdjacentHTML("beforeend", htmlNode.xml || htmlNode.serialize());
				loadScreen = document.body.lastChild;
			}
		}
	}
	
	document.body.style.display = "block";
	
	
	if(!self.ERROR_HAS_OCCURRED)
		Init.interval = setInterval('if(checkLoaded()) initialize()', 20);
}

function loadJMLIncludes(xmlNode, oHttp, doSync){
	
	if(xmlNode.ownerDocument.documentElement[TAGNAME] == "application"){
		var nodes = xmlNode.ownerDocument.documentElement.attributes;
		for(var found="",i=0;i<nodes.length;i++){
			if(IS_SAFARI && nodes[i].nodeName == "j" || nodes[i].nodeName == "xmlns:j"){
				found = nodes[i].nodeValue;
			}
		}

		if (found != "http://www.javeline.net/j"){
			throw new Error(0, Kernel.formErrorString(0, null, "Loading includes", (found ? "Invalid namespace found '" + found + "'" : "No namespace definition found") + ". Expecting xmlns:j='http://www.javeline.net/j'\nFile : " + (xmlNode.ownerDocument.documentElement.getAttribute("filename") || location.href), xmlNode.ownerDocument.documentElement));
		}
	}
	
	var nodes = $j(xmlNode, "include");
	if(!nodes.length){
		xmlNode.setAttribute("loading", "done");
		return false;
	}
	if(!oHttp) oHttp = new HTTP();
	xmlNode.setAttribute("loading", "loading");

	for(var i=nodes.length-1;i>=0;i--){
		if(!nodes[i].getAttribute("src")) 
			throw new Error(0, Kernel.formErrorString(0, null, "Loading includes", "Could not load Include file " + nodes[i].xml + ":\nCould not find the src attribute."))
		
		loadJMLInclude(nodes[i], oHttp, doSync);
	}
	
	var nodes = $j(xmlNode, "skin");
	if(nodes.length && !nodes[0].childNodes.length){
		var path = nodes[0].getAttribute("src") ? 
			getAbsolutePath(HOST_PATH, nodes[0].getAttribute("src")) : 
			getAbsolutePath(HOST_PATH, nodes[0].getAttribute("name")) + "/index.xml";
			
		loadJMLInclude(nodes[0], oHttp, doSync, path);
	}
	
	return true;
}

function loadJMLInclude(node, oHttp, doSync, path){
	setStatus("Loading include file: " + (path || getAbsolutePath(HOST_PATH, node.getAttribute("src"))));
	
	oHttp.getXML(path || getAbsolutePath(HOST_PATH, node.getAttribute("src")), function(xmlNode, state, extra){
		if(state != __HTTP_SUCCESS__){
			if(state == __HTTP_TIMEOUT__ && extra.retries < MAX_JAV_RETRIES) return extra.tpModule.retry(extra.id);
			else throw new Error(1007, Kernel.formErrorString(1007, null, "Loading Includes", "Could not load Include file '" + (path || extra.userdata[0].getAttribute("src")) + "'\nReason: " + extra.message, node));
		}
		if(xmlNode[TAGNAME].toLowerCase() == "skin"){
			PresentationServer.Init(xmlNode, node, path);
			IncludeStack[extra.userdata[1]] = true;
			if(extra.userdata[0].parentNode) //for opera...
				extra.userdata[0].parentNode.removeChild(extra.userdata[0]);
		}
		else if(xmlNode[TAGNAME].toLowerCase() == "application"){
			IncludeStack[extra.userdata[1]] = xmlNode;//extra.userdata[0].parentNode.appendChild(xmlNode, extra.userdata[0]);
			extra.userdata[0].setAttribute("iid", extra.userdata[1]);
			xmlNode.setAttribute("filename", extra.url);
		}
		else{
			throw new Error(0, Kernel.formErrorString(0, null, "Loading Includes", "Could not find handler to parse include file for '" + xmlNode[TAGNAME] + "' expected 'skin' or 'application'", node));
		}
		
		setStatus("Loading of " + xmlNode[TAGNAME].toLowerCase() + " include done from file: " + extra.url);
		
		loadJMLIncludes(xmlNode); //check for includes in the include (NOT recursive save)
		
	}, !doSync, [node, IncludeStack.push(false) - 1]);
	
}

// Load user defined includes
var AppData, IncludeStack = [];
//loadIncludes();
Init.addConditional(loadIncludes, null, ['BODY', 'HTTP', 'XMLDatabase', 'TelePort']);

function checkLoaded(){
	for(var i=0;i<IncludeStack.length;i++){
		if(!IncludeStack[i]){
			setStatus("Waiting for: [" + i + "] " + IncludeStack[i]);
			return false;
		}
	}
	
	if(!document.body) return false;
	
	setStatus("Dependencies loaded");
	
	return true;
}

var isInitialized = false;
function initialize(){
	if(isInitialized) return;
	isInitialized = true;
	
	setStatus("Initializing...");
	clearInterval(Init.interval);
	
	//Initialize Form
	if(self._Window) _Window.Init();

	// Boot kernel
	if(Kernel.Init) Kernel.Init();

	// Run Init
	Init.run();

	// Start application
	if(self.Application) Application.Init(AppData);

	if(self.loadScreen) loadScreen.style.display = "none";
}

function getAbsolutePath(base, src){
	return src.match(/^\w+\:\/\//) ? src : base + src;
}

function removePathContext(base, src){
	if(!src) return "";
	if(src.indexOf(base) > -1) return src.substr(base.length);
	return src;
}

if(document.body) Init.run('BODY');
else window.onload = function(){Init.run('BODY');}
/*FILEHEAD(/temp/jfw_debug.map)SIZE(0)TIME(1188902783781)*/

/*FILEHEAD(/cwd/jfwsym.txt)SIZE(0)TIME(0)*/
