set feedback off
set define off
prompt Loading REPOSITORY_OPTIONS...
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('COMPRESS', null, 'TRUE', 'If TRUE, compress all objects data in the repository to save disk space');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('ENCRYPT', null, 'FALSE', 'If TRUE, encrypt all objects data in the repository');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('SYSTEM_GENERATED', null, 'FALSE', 'If TRUE, select indexes or triggers even if they are system-generated. If FALSE, omit system-generated indexes or triggers. Defaults to FALSE');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('COMPRESS_QUALITY', null, '6', 'Speed versus efficiency of resulting compressed output. Valid values are the range 1..9, with a default value of 6. 1=fastest compression, 9=slowest compression and best compressed size');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('INDEX_SEGMENT_ATTRIBUTES', null, 'TRUE', 'If TRUE, emit segment attributes (physical attributes, storage attributes, tablespace, logging');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('INDEX_STORAGE', null, 'TRUE', 'If TRUE, emit storage clause. (Ignored if INDEX_SEGMENT_ATTRIBUTES is FALSE.)');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('INDEX_TABLESPACE', null, 'TRUE', 'If TRUE, emit tablespace. (Ignored if INDEX_SEGMENT_ATTRIBUTES is FALSE.)');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('TYPE_OID', null, 'FALSE', 'If TRUE, emit the OID clause');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('VIEW_FORCE', null, 'TRUE', 'If TRUE, use the FORCE keyword in the CREATE VIEW statement');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('SEQ_IGNORE_NEXTVAL', null, 'TRUE', 'if TRUE, ignore last sequence value (NEXTVAL)');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('TABLE_SEGMENT_ATTRIBUTES', null, 'TRUE', 'If TRUE, emit segment attributes (physical attributes, storage attributes, tablespace, logging');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('TABLE_STORAGE', null, 'TRUE', 'If TRUE, emit storage clause. (Ignored if TABLE_SEGMENT_ATTRIBUTES is FALSE.)');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('TABLE_CONSTRAINTS', null, 'TRUE', 'If TRUE, emit all non-referential table constraints');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('TABLE_REF_CONSTRAINTS', null, 'TRUE', 'If TRUE, emit all referential constraints (foreign keys)');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('TABLE_OID', null, 'FALSE', 'If TRUE, emit the OID clause for object tables');
insert into SVCO.REPOSITORY_OPTIONS (R_OPTION, R_VALUE, R_DEFAULT_VALUE, COMMENTS)
values ('TABLE_TABLESPACE', null, 'TRUE', 'If TRUE, emit tablespace. (Ignored if TABLE_SEGMENT_ATTRIBUTES is FALSE.)');
commit;
prompt Loading SCHEMA_OBJECTS...
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('LIBRARY', null, '10.1.0.2.0', '1.0.0', 100, 1, 'N', 'DROP LIBRARY "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('TYPE', 'TYPE_SPEC', '10.1.0.2.0', '1.0.0', 300, 1, 'N', 'DROP TYPE "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('TYPE BODY', 'TYPE_BODY', '10.1.0.2.0', '1.0.0', 400, 1, 'N', 'DROP TYPE BODY "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('DB_LINK', null, '10.1.0.2.0', '1.0.0', 500, 1, 'N', 'DROP DATABASE LINK "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('CLUSTER', null, '10.1.0.2.0', '1.0.0', 700, 1, 'N', 'DROP CLUSTER "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('TABLE', null, '10.1.0.2.0', '1.0.0', 800, 1, 'N', 'DROP TABLE "[1]"."[2]" CASCADE CONSTRAINTS');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('TRIGGER', null, '10.1.0.2.0', '1.0.0', 900, 1, 'ND', 'DROP TRIGGER "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('INDEX', null, '10.1.0.2.0', '1.0.0', 1000, 1, 'ND', 'DROP INDEX "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('INDEXTYPE', null, '10.1.0.2.0', '1.0.0', 1100, 1, 'N', 'DROP INDEXTYPE "[1]"."[2]" FORCE');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('FUNCTION', null, '10.1.0.2.0', '1.0.0', 1400, 1, 'N', 'DROP FUNCTION "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('PROCEDURE', null, '10.1.0.2.0', '1.0.0', 1500, 1, 'N', 'DROP PROCEDURE "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('VIEW', null, '10.1.0.2.0', '1.0.0', 1600, 1, 'N', 'DROP VIEW "[1]"."[2]" CASCADE CONSTRAINTS');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('MATERIALIZED VIEW', 'MATERIALIZED_VIEW', '10.1.0.2.0', '1.0.0', 1700, 1, 'N', 'DROP MATERIALIZED VIEW "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('MATERIALIZED_VIEW_LOG', null, '10.1.0.2.0', '1.0.0', 1800, 1, 'ND', 'DROP MATERIALIZED VIEW LOG ON "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('SEQUENCE', null, '10.1.0.2.0', '1.0.0', 600, 1, 'N', 'DROP SEQUENCE "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('SYNONYM', null, '10.1.0.2.0', '1.0.0', 200, 1, 'N', 'DROP SYNONYM "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('PACKAGE', 'PACKAGE_SPEC', '10.1.0.2.0', '1.0.0', 1200, 1, 'N', 'DROP PACKAGE "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('PACKAGE BODY', 'PACKAGE_BODY', '10.1.0.2.0', '1.0.0', 1300, 1, 'N', 'DROP PACKAGE BODY "[1]"."[2]"');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('COMMENT', null, '10.1.0.2.0', '1.0.0', 1900, 1, 'D', '-- Not Applicable');
insert into SVCO.SCHEMA_OBJECTS (OBJECT_TYPE, META_TYPE, ORA_VERSION, SVCO_VERSION, SEQ_NO, ENABLED, ATTR, DROP_QUERY)
values ('OBJECT_GRANT', null, '10.1.0.2.0', '1.0.0', 2000, 1, 'D', 'REVOKE [1] ON "[2]"."[3]" FROM "[4]"');
commit;
set feedback on
set define on
