CREATE TABLE SVCO.LICENSE_KEY
(
    LKEY  RAW(48) NOT NULL,
    LDATE DATE    NOT NULL
)
TABLESPACE &tabtbs
/
----------------------------------------------------
CREATE TABLE SVCO.REPOSITORY_OPTIONS
(
    R_OPTION        VARCHAR2(30)  NOT NULL,
    R_VALUE         VARCHAR2(61)      NULL,
    R_DEFAULT_VALUE VARCHAR2(61)  NOT NULL,
    COMMENTS        VARCHAR2(512)     NULL
)
TABLESPACE &tabtbs
/
COMMENT ON COLUMN SVCO.REPOSITORY_OPTIONS.R_OPTION
  IS 'Repository option name'
/
COMMENT ON COLUMN SVCO.REPOSITORY_OPTIONS.R_VALUE
  IS 'Repository option value'
/
COMMENT ON COLUMN SVCO.REPOSITORY_OPTIONS.R_DEFAULT_VALUE
  IS 'Repository option default value'
/
COMMENT ON COLUMN SVCO.REPOSITORY_OPTIONS.COMMENTS
  IS 'Repository option comments'
/
----------------------------------------------------
CREATE TABLE SVCO.SCHEMA_OBJECTS
(
    OBJECT_TYPE  VARCHAR2(30)   NOT NULL,
    META_TYPE    VARCHAR2(30)       NULL,
    ORA_VERSION  VARCHAR2(64)   NOT NULL,
    SVCO_VERSION VARCHAR2(8)    NOT NULL,
    SEQ_NO       NUMBER(4)      NOT NULL,
    ENABLED      NUMBER(1)      DEFAULT 1 NOT NULL,
    ATTR         VARCHAR2(3)    NOT NULL,
    DROP_QUERY   VARCHAR2(1000) NOT NULL
)
TABLESPACE &tabtbs
/
ALTER TABLE SVCO.SCHEMA_OBJECTS
    ADD CONSTRAINT PK_SCHEMA_OBJECTS
    PRIMARY KEY (OBJECT_TYPE)
    USING INDEX COMPUTE STATISTICS TABLESPACE &idxtbs
    ENABLE
/
COMMENT ON COLUMN SVCO.SCHEMA_OBJECTS.SVCO_VERSION IS
'x.y.z'
/
COMMENT ON COLUMN SVCO.SCHEMA_OBJECTS.ENABLED
  IS '1 - Object type is enabled'
/
COMMENT ON COLUMN SVCO.SCHEMA_OBJECTS.ATTR IS
'''N'' represents a named object, ''D'' represents a dependent object'
/
----------------------------------------------------
CREATE TABLE SVCO.VERSION_LOG
(
    INTERNAL_ID NUMBER         NOT NULL,
    DB_NAME     VARCHAR2(30)   NOT NULL,
    OWNER_NAME  VARCHAR2(30)   NOT NULL,
    REV_NUM     NUMBER         NOT NULL,
    EXT_VERS    VARCHAR2(20)       NULL,
    CREATED     DATE           NOT NULL,
    COMMENTS    VARCHAR2(2048)     NULL
)
TABLESPACE &tabtbs
/
ALTER TABLE SVCO.VERSION_LOG
    ADD CONSTRAINT PK_VERSION_LOG
    PRIMARY KEY (INTERNAL_ID)
    USING INDEX COMPUTE STATISTICS TABLESPACE &idxtbs
    ENABLE
/
ALTER TABLE SVCO.VERSION_LOG
    ADD CONSTRAINT UNQ_VERSION_LOG
    UNIQUE (DB_NAME,OWNER_NAME,REV_NUM)
    USING INDEX COMPUTE STATISTICS TABLESPACE &idxtbs
    ENABLE
/
COMMENT ON COLUMN SVCO.VERSION_LOG.REV_NUM IS
'Internal Revision Number'
/
COMMENT ON COLUMN SVCO.VERSION_LOG.EXT_VERS IS
'External Version'
/
----------------------------------------------------
CREATE TABLE SVCO.VERSION_OBJECTS
(
    VERSION_OBJECTS_ID        NUMBER        NOT NULL,
    VERSION_LOG_ID            NUMBER        NOT NULL,
    OBJECT_TYPE               VARCHAR2(30)  NOT NULL,
    OBJECT_NAME               VARCHAR2(255) NOT NULL,
    OBJECT_STATUS             CHAR(1)       NOT NULL,
    PARENT_VERSION_OBJECTS_ID NUMBER            NULL,
    BASE_OBJECT_NAME          VARCHAR2(255)     NULL,
    CONSTRAINT FK_VERSION_LOG
    FOREIGN KEY (VERSION_LOG_ID)
    REFERENCES SVCO.VERSION_LOG (INTERNAL_ID)
    ON DELETE CASCADE
    ENABLE
)
TABLESPACE &tabtbs
/
ALTER TABLE SVCO.VERSION_OBJECTS
    ADD CONSTRAINT PK_VERSION_OBJECTS
    PRIMARY KEY (VERSION_OBJECTS_ID)
    USING INDEX COMPUTE STATISTICS TABLESPACE &idxtbs
    ENABLE
/
ALTER TABLE SVCO.VERSION_OBJECTS
    ADD CONSTRAINT UNQ_VERSION_OBJECTS
    UNIQUE (VERSION_LOG_ID,OBJECT_TYPE,OBJECT_NAME)
    USING INDEX COMPUTE STATISTICS TABLESPACE &idxtbs
    ENABLE
/
ALTER TABLE SVCO.VERSION_OBJECTS 
    ADD CONSTRAINT SELF_VERSION_OBJECTS
FOREIGN KEY (PARENT_VERSION_OBJECTS_ID)
REFERENCES SVCO.VERSION_OBJECTS (VERSION_OBJECTS_ID)
ON DELETE CASCADE
ENABLE
/
CREATE INDEX SVCO.I_PARENT_VERSION_OBJECTS_ID
    ON SVCO.VERSION_OBJECTS(PARENT_VERSION_OBJECTS_ID)
COMPUTE STATISTICS TABLESPACE &idxtbs
/
COMMENT ON COLUMN SVCO.VERSION_OBJECTS.OBJECT_STATUS IS
'I - New; U - Changed; D - Deleted; R - Referenced'
/
----------------------------------------------------
CREATE TABLE SVCO.VERSION_OBJECTS_SRC
(
    VERSION_OBJECT_ID NUMBER         NOT NULL,
    OBJECT_SRC        CLOB               NULL,
    QUERY_DEBUG       VARCHAR2(4000)     NULL,
    OBJECT_SRC_BLOB   BLOB               NULL,
    SAVED_OPT         NUMBER(4)      NOT NULL,
    CONSTRAINT FK_VERSION_OBJECTS
    FOREIGN KEY (VERSION_OBJECT_ID)
    REFERENCES SVCO.VERSION_OBJECTS (VERSION_OBJECTS_ID)
    ON DELETE CASCADE
    ENABLE
)
LOB(OBJECT_SRC) STORE AS
(
    TABLESPACE &tabtbs
    ENABLE STORAGE IN ROW
)
LOB(OBJECT_SRC_BLOB) STORE AS
(
    TABLESPACE &tabtbs
    ENABLE STORAGE IN ROW
)
TABLESPACE &tabtbs
/
ALTER TABLE SVCO.VERSION_OBJECTS_SRC
    ADD CONSTRAINT PK_VERSION_OBJECTS_SRC
    PRIMARY KEY (VERSION_OBJECT_ID)
    USING INDEX COMPUTE STATISTICS TABLESPACE &idxtbs
    ENABLE
/
----------------------------------------------------
CREATE GLOBAL TEMPORARY TABLE SVCO.PLUGIN_DATA
(
    ID   NUMBER NOT NULL,
    DATA CLOB   NOT NULL
) ON COMMIT PRESERVE ROWS
/
ALTER TABLE SVCO.PLUGIN_DATA
    ADD CONSTRAINT PK_PLUGIN_DATA
    PRIMARY KEY (ID)
    ENABLE
    VALIDATE
/
