using System;
using System.Collections;
using System.Text;
using System.IO;

using NI.Email.Mime.Message;
using NI.Email.Mime.Field;
using NI.Email.Mime.Util;

namespace NI.Mime4Net.Samples.ComposeMhtml {
	
	public class Program {

		static void Main(string[] args) {

			Multipart multi = new Multipart();

			// text part
			BodyPart bodyFirst = new BodyPart();
			Header bodyFirstHeader = new Header();
			bodyFirstHeader.AddField(MimeField.Parse(@"Content-Type: text/html; charset=""US-ASCII"""));
			bodyFirstHeader.AddField(MimeField.Parse(@"Content-ID: <main_part@mhtmltest.mime4net>"));

			bodyFirst.Header = bodyFirstHeader;
			bodyFirst.Body = new MemoryTextBody( 
					new MemoryStream( Encoding.ASCII.GetBytes(@"Sample HTML body: <img src=""cid:image_part@mhtmltest.mime4net"" alt=""MIME4Net"" border=""0"">") ) );
			multi.AddBodyPart(bodyFirst);

			// m4n logo part
			Stream logoImgStream = typeof(Program).Assembly.GetManifestResourceStream( "NI.Mime4Net.Samples.ComposeMhtml.logo.gif" );
			multi.AddRelatedBinaryPart( logoImgStream, "image_part@mhtmltest.mime4net", "image/gif", "mhtml_test_m4nlogo.gif");

			//composing main msg
			MimeMessage msg = new MimeMessage();

			Header msgHeader = new Header();
			msgHeader.AddField(MimeField.Parse(@"From: from@mime4.net"));
			msgHeader.AddField(MimeField.Parse(@"To: to@mime4.net"));
			msgHeader.AddField(MimeField.Parse(@"Subject: MHTML sample"));
			msgHeader.AddField(MimeField.Parse(@"Mime-Version: 1.0"));
			string ctype = "Content-Type: multipart/related; boundary=";
			ctype += @"MY_BOUNDARY;";
			ctype += @" type=""text/html"";";
			ctype += @" start=""<main_part@mhtmltest.mime4net>""";
			msgHeader.AddField(MimeField.Parse(ctype));
			msg.Header = msgHeader;

			msg.Body = multi;
			
			MemoryStream memStream = new MemoryStream();
			msg.WriteTo( memStream );
			Console.WriteLine( Encoding.ASCII.GetString(memStream.ToArray()) );

		}
	}
}
