/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.jexcel.format;

import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.automation.types.BStr;
import com.jniwrapper.win32.automation.types.Variant;
import com.jniwrapper.win32.excel.XlUnderlineStyle;
import java.awt.Color;

public class Font {
    private String e;
    private double f;
    private Color b;
    private boolean g;
    private boolean h;
    private boolean d;
    private UnderlineStyle c;
    private Alignment a;

    public Font() {
        this.setName("Arial");
        this.setSize(10.0);
        this.setColor(Color.BLACK);
        this.setBold(false);
        this.setItalic(false);
        this.setStrikethrough(false);
        this.setUnderlineStyle(UnderlineStyle.NONE);
        this.setAlignment(Alignment.NORMAL);
    }

    public Font(java.awt.Font font) {
        this();
        this.setName(font.getName());
        this.setSize(font.getSize());
        this.setBold(font.isBold());
        this.setItalic(font.isItalic());
    }

    public Font(String string, double d2) {
        this();
        this.setName(string);
        this.setSize(d2);
    }

    public Font(com.jniwrapper.win32.excel.Font font) {
        this.setName(font.getName().getBstrVal().getValue());
        this.setSize(font.getSize().getDblVal().getValue());
        this.setColor(this.a(new Color((int)font.getColor().getDblVal().getValue())));
        this.setBold(font.getBold().getBoolVal().getBooleanValue());
        this.setItalic(font.getItalic().getBoolVal().getBooleanValue());
        this.setStrikethrough(font.getStrikethrough().getBoolVal().getBooleanValue());
        this.setUnderlineStyle(new UnderlineStyle(font.getUnderline().getLVal().getValue()));
        if (font.getSubscript().getBoolVal().getBooleanValue()) {
            this.setAlignment(Alignment.SUBSCRIPT);
        } else if (font.getSuperscript().getBoolVal().getBooleanValue()) {
            this.setAlignment(Alignment.SUPERSCRIPT);
        } else {
            this.setAlignment(Alignment.NORMAL);
        }
    }

    public void toExcelFont(com.jniwrapper.win32.excel.Font font) {
        font.setName(new Variant((Object)new BStr(this.getName())));
        font.setSize(new Variant(this.getSize()));
        font.setColor(new Variant(this.a(this.getColor()).getRGB()));
        font.setBold(new Variant(this.isBold()));
        font.setItalic(new Variant(this.isItalic()));
        font.setStrikethrough(new Variant(this.isStrikethrough()));
        font.setUnderline(new Variant((Object)this.getUnderlineStyle().a()));
        if (this.getAlignment().equals((Object)Alignment.NORMAL)) {
            font.setSubscript(new Variant(false));
            font.setSuperscript(new Variant(false));
        } else if (this.getAlignment().equals((Object)Alignment.SUBSCRIPT)) {
            font.setSubscript(new Variant(true));
            font.setSuperscript(new Variant(false));
        } else {
            font.setSubscript(new Variant(false));
            font.setSuperscript(new Variant(true));
        }
    }

    public String getName() {
        return this.e;
    }

    public void setName(String string) {
        this.e = string;
    }

    public double getSize() {
        return this.f;
    }

    public void setSize(double d2) {
        this.f = d2;
    }

    public Color getColor() {
        return this.b;
    }

    public void setColor(Color color) {
        this.b = color;
    }

    public boolean isBold() {
        return this.g;
    }

    public void setBold(boolean bl) {
        this.g = bl;
    }

    public boolean isItalic() {
        return this.h;
    }

    public void setItalic(boolean bl) {
        this.h = bl;
    }

    public boolean isStrikethrough() {
        return this.d;
    }

    public void setStrikethrough(boolean bl) {
        this.d = bl;
    }

    public UnderlineStyle getUnderlineStyle() {
        return this.c;
    }

    public void setUnderlineStyle(UnderlineStyle underlineStyle) {
        this.c = underlineStyle;
    }

    public Alignment getAlignment() {
        return this.a;
    }

    public void setAlignment(Alignment alignment) {
        this.a = alignment;
    }

    private Color a(Color color) {
        int n2 = color.getBlue();
        int n3 = color.getGreen();
        int n4 = color.getRed();
        int n5 = color.getAlpha();
        return new Color(n2, n3, n4, n5);
    }

    public static class UnderlineStyle
    extends EnumItem {
        public static final UnderlineStyle NONE = new UnderlineStyle(4294963154L);
        public static final UnderlineStyle SINGLE = new UnderlineStyle(2L);
        public static final UnderlineStyle SINGLEACCOUNTING = new UnderlineStyle(4L);
        public static final UnderlineStyle DOUBLE = new UnderlineStyle(0xFFFFEFE9L);
        public static final UnderlineStyle DOUBLEACCOUNTING = new UnderlineStyle(5L);

        UnderlineStyle(long l2) {
            super(l2);
        }

        XlUnderlineStyle a() {
            return new XlUnderlineStyle(this.getLongValue());
        }

        public String toString() {
            switch (this.getValue()) {
                case -4142: {
                    return "None";
                }
                case 2: {
                    return "Single";
                }
                case 4: {
                    return "Single Accounting";
                }
                case -4119: {
                    return "Double";
                }
                case 5: {
                    return "Double Accounting";
                }
            }
            return super.toString();
        }
    }

    public static class Alignment
    extends EnumItem {
        public static final Alignment NORMAL = new Alignment(0);
        public static final Alignment SUBSCRIPT = new Alignment(1);
        public static final Alignment SUPERSCRIPT = new Alignment(2);

        private Alignment(int n2) {
            super(n2);
        }

        public String toString() {
            switch (this.getValue()) {
                case 0: {
                    return "Normal";
                }
                case 1: {
                    return "Subscript";
                }
                case 2: {
                    return "Superscript";
                }
            }
            return super.toString();
        }
    }
}

