/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.gdi.Bitmap;
import com.jniwrapper.win32.gdi.ColorRef;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.LogBrush;
import com.jniwrapper.win32.ui.User32;

public class Brush
extends GdiObject {
    private static final String FUNCTION_CREATE_BRUSH_INDIRECT = "CreateBrushIndirect";
    private static final String FUNCTION_CREATE_HATCH_BRUSH = "CreateHatchBrush";
    private static final String FUNCTION_CREATE_PATTERN_BRUSH = "CreatePatternBrush";
    private static final String FUNCTION_CREATE_SOLID_BRUSH = "CreateSolidBrush";
    private static final String FUNCTION_GET_BRUSH_ORG_EX = "GetBrushOrgEx";
    private static final String FUNCTION_GET_SYS_COLOR_BRUSH = "GetSysColorBrush";
    private static final String FUNCTION_SET_BRUSH_ORG_EX = "SetBrushOrgEx";

    public Brush() {
    }

    public Brush(long handle) {
        super(handle);
    }

    public Brush(BrushStyle style) {
        super(style.getValue());
    }

    public static Brush getStockObject(StockBrush object) {
        if (object.getValue() < StockBrush.WHITE_BRUSH.getValue() || object.getValue() > StockBrush.HOLLOW_BRUSH.getValue()) {
            throw new IllegalArgumentException("Unknown stock brush kind: " + (Object)((Object)object));
        }
        Handle handle = Gdi32.getStockObject(object.getValue());
        return new Brush(handle.getValue());
    }

    public static Brush createBrushIndirect(LogBrush lb) {
        Brush result = new Brush();
        Function function = Gdi32.get(FUNCTION_CREATE_BRUSH_INDIRECT);
        function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)lb));
        return result;
    }

    public static Brush createHatchBrush(HatchStyle style, ColorRef colorRef) {
        Brush result = new Brush();
        Function function = Gdi32.get(FUNCTION_CREATE_HATCH_BRUSH);
        function.invoke((Parameter)result, (Parameter)new Int((long)style.getValue()), (Parameter)colorRef);
        return result;
    }

    public static Brush createPatternBrush(Bitmap bitmap) {
        Brush result = new Brush();
        Function function = Gdi32.get(FUNCTION_CREATE_PATTERN_BRUSH);
        function.invoke((Parameter)result, (Parameter)bitmap);
        return result;
    }

    public static Brush createSolidBrush(ColorRef colorRef) {
        Brush result = new Brush();
        Function function = Gdi32.get(FUNCTION_CREATE_SOLID_BRUSH);
        function.invoke((Parameter)result, (Parameter)colorRef);
        return result;
    }

    public static Point getBrushOrigin(DC hDC) {
        Int result = new Int();
        Point origin = new Point();
        Function function = Gdi32.get(FUNCTION_GET_BRUSH_ORG_EX);
        function.invoke((Parameter)result, (Parameter)hDC, (Parameter)new Pointer((Parameter)origin));
        if (result.getValue() > 0L) {
            return new Point(origin.getX(), origin.getY());
        }
        return null;
    }

    public static Brush getSysColorBrush(int index) {
        Brush result = new Brush();
        Function function = User32.getInstance().getFunction(FUNCTION_GET_SYS_COLOR_BRUSH);
        function.invoke((Parameter)result, (Parameter)new Int((long)index));
        return result;
    }

    public static Point setBrushOrigin(DC hDC, int xOrg, int yOrg) {
        Int result = new Int();
        Point prevOrig = new Point();
        Function function = Gdi32.get(FUNCTION_SET_BRUSH_ORG_EX);
        function.invoke((Parameter)result, (Parameter)hDC, (Parameter)new Int((long)xOrg), (Parameter)new Int((long)yOrg), (Parameter)new Pointer((Parameter)prevOrig));
        if (result.getValue() > 0L) {
            return new Point(prevOrig.getX(), prevOrig.getY());
        }
        return null;
    }

    public static class StockBrush
    extends EnumItem {
        public static final StockBrush WHITE_BRUSH = new StockBrush(0);
        public static final StockBrush LTGRAY_BRUSH = new StockBrush(1);
        public static final StockBrush GRAY_BRUSH = new StockBrush(2);
        public static final StockBrush DKGRAY_BRUSH = new StockBrush(3);
        public static final StockBrush BLACK_BRUSH = new StockBrush(4);
        public static final StockBrush NULL_BRUSH;
        public static final StockBrush HOLLOW_BRUSH;

        private StockBrush(int value) {
            super(value);
        }

        static {
            HOLLOW_BRUSH = NULL_BRUSH = new StockBrush(5);
        }
    }

    public static class HatchStyle
    extends EnumItem {
        public static final HatchStyle BDIAGONAL = new HatchStyle(3);
        public static final HatchStyle CROSS = new HatchStyle(4);
        public static final HatchStyle DIAGCROSS = new HatchStyle(5);
        public static final HatchStyle FDIAGONAL = new HatchStyle(2);
        public static final HatchStyle VERTICAL = new HatchStyle(1);
        public static final HatchStyle HORIZONTAL = new HatchStyle(0);

        private HatchStyle(int value) {
            super(value);
        }
    }

    public static class BrushStyle
    extends EnumItem {
        public static final BrushStyle SOLID = new BrushStyle(0);
        public static final BrushStyle NULL;
        public static final BrushStyle HOLLOW;
        public static final BrushStyle HATCHED;
        public static final BrushStyle PATTERN;
        public static final BrushStyle DIBPATTERN;
        public static final BrushStyle DIBPATTERNPT;
        public static final BrushStyle PATTERN8X8;
        public static final BrushStyle DIBPATTERN8X8;

        private BrushStyle(int value) {
            super(value);
        }

        static {
            HOLLOW = NULL = new BrushStyle(1);
            HATCHED = new BrushStyle(2);
            PATTERN = new BrushStyle(3);
            DIBPATTERN = new BrushStyle(5);
            DIBPATTERNPT = new BrushStyle(6);
            PATTERN8X8 = new BrushStyle(7);
            DIBPATTERN8X8 = new BrushStyle(8);
        }
    }
}

