/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.AnsiString;
import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.system.Kernel32;

public class VersionInfo
extends Structure {
    static final String FUNCTION_GET_VERSIONEX = "GetVersionExA";
    public static final int VER_PLATFORM_WIN32s = 0;
    public static final int VER_PLATFORM_WIN32_WINDOWS = 1;
    public static final int VER_PLATFORM_WIN32_NT = 2;
    public static final int VER_PLATFORM_WIN32_CE = 3;
    private UInt32 _dwOSVersionInfoSize = new UInt32();
    private UInt32 _dwMajorVersion = new UInt32();
    private UInt32 _dwMinorVersion = new UInt32();
    private UInt32 _dwBuildNumber = new UInt32();
    private UInt32 _dwPlatformId = new UInt32();
    private AnsiString _szCSDVersion = new AnsiString(128);

    public VersionInfo() {
        this.init(new Parameter[]{this._dwOSVersionInfoSize, this._dwMajorVersion, this._dwMinorVersion, this._dwBuildNumber, this._dwPlatformId, this._szCSDVersion});
        this._dwOSVersionInfoSize.setValue((long)this.getLength());
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GET_VERSIONEX);
        Bool result = new Bool();
        function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)this));
    }

    public VersionInfo(VersionInfo that) {
        super((Structure)that);
    }

    public long getBuildNumber() {
        long result = this._dwBuildNumber.getValue();
        if (this.isNT()) {
            return result;
        }
        return result & 0xFFFFL;
    }

    public long getMajor() {
        return this._dwMajorVersion.getValue();
    }

    public long getMinor() {
        return this._dwMinorVersion.getValue();
    }

    public long getPlatformId() {
        return this._dwPlatformId.getValue();
    }

    public String getServicePack() {
        return this._szCSDVersion.getValue();
    }

    public boolean isNT() {
        return this.getPlatformId() == 2L;
    }

    public boolean isWin9x() {
        return this.getPlatformId() == 1L;
    }

    public boolean isWin2k() {
        return this.getMajor() >= 5L & this.getPlatformId() == 2L;
    }

    public boolean isWinMe() {
        return this.getPlatformId() == 1L & (this.getMajor() > 4L || this.getMajor() == 4L && this.getMinor() >= 90L);
    }

    public boolean isWinXP() {
        return this.getMajor() >= 5L & this.getMinor() == 1L & this.getPlatformId() == 2L;
    }

    public boolean isWin2003() {
        return this.getMajor() >= 5L & this.getMinor() == 2L & this.getPlatformId() == 2L;
    }

    public Object clone() {
        return new VersionInfo(this);
    }
}

