/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.security.AccessToken;
import com.jniwrapper.win32.ui.User32;

public class WindowsSession {
    private static final String FUNCTION_EXIT_WINDOWS_EX = "ExitWindowsEx";

    private WindowsSession() {
    }

    public static boolean logoff(boolean isNotify) {
        return WindowsSession.exitWindows(Action.LOGOFF, isNotify);
    }

    public static boolean shutdown(boolean isNotify) {
        return WindowsSession.exitWindows(Action.SHUTDOWN, isNotify);
    }

    public static boolean powerOff(boolean isNotify) {
        return WindowsSession.exitWindows(Action.POWEROFF, isNotify);
    }

    public static boolean reboot(boolean isNotify) {
        return WindowsSession.exitWindows(Action.REBOOT, isNotify);
    }

    private static boolean exitWindowsEx(Action action, NotifyMode notify) {
        Function func = User32.getInstance().getFunction(FUNCTION_EXIT_WINDOWS_EX);
        Bool result = new Bool();
        func.invoke((Parameter)result, new Parameter[]{new UInt((long)action.getValue()), new UInt32((long)notify.getValue())});
        return result.getValue();
    }

    private static boolean exitWindows(Action action, boolean isNotify) {
        if (action.getValue() != Action.LOGOFF.getValue() && !WindowsSession.adjustToken()) {
            return false;
        }
        NotifyMode notifyMode = isNotify ? NotifyMode.FORCEIFHUNG : NotifyMode.FORCE;
        return WindowsSession.exitWindowsEx(action, notifyMode);
    }

    private static boolean adjustToken() {
        AccessToken token = new AccessToken();
        return token.enablePrivelege("SeShutdownPrivilege");
    }

    private static class NotifyMode
    extends EnumItem {
        public static final NotifyMode FORCE = new NotifyMode(4);
        public static final NotifyMode FORCEIFHUNG = new NotifyMode(16);

        private NotifyMode(int value) {
            super(value);
        }
    }

    private static class Action
    extends EnumItem {
        public static final Action LOGOFF = new Action(0);
        public static final Action POWEROFF = new Action(8);
        public static final Action REBOOT = new Action(2);
        public static final Action SHUTDOWN = new Action(1);

        private Action(int value) {
            super(value);
        }
    }
}

