/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.IntPtr;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.ui.User32;
import com.jniwrapper.win32.ui.WindowMessage;
import com.jniwrapper.win32.ui.WindowMessageListener;
import com.jniwrapper.win32.ui.WindowMessageListenerEx;
import com.jniwrapper.win32.ui.Wnd;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WindowProc
extends Callback {
    private static final FunctionName FUNCTION_DEF_WINDOW_PROC = new FunctionName("DefWindowProc");
    protected Wnd _wnd = new Wnd();
    protected UInt _msg = new UInt();
    protected IntPtr _wParam = new IntPtr();
    protected IntPtr _lParam = new IntPtr();
    protected IntPtr _lResult = new IntPtr();
    private Function _defWindowProc;
    private boolean _substituted = false;
    private Handle _wndProc;
    private List _messageListeners = new LinkedList();

    public WindowProc(Wnd wnd) {
        this();
        this.setWnd(wnd);
    }

    public WindowProc() {
        this.init(new Parameter[]{this._wnd, this._msg, this._wParam, this._lParam}, (Parameter)this._lResult);
        this._defWindowProc = WindowProc.getDefWindowProc();
    }

    public void callback() {
        if (this.isSubstituted()) {
            boolean isCallWindowProc = this.notifyListeners(true);
            if (isCallWindowProc) {
                this._lResult.setValue(Wnd.callWindowProc(this._wndProc, this._wnd, this._msg, this._wParam, this._lParam));
            }
            this.notifyListeners(false);
        } else {
            this._defWindowProc.invoke((Parameter)this._lResult, (Parameter)this._wnd, (Parameter)this._msg, (Parameter)this._wParam, (Parameter)this._lParam);
        }
    }

    private boolean notifyListeners(boolean beforeWndProc) {
        boolean result = true;
        WindowMessage message = new WindowMessage((Object)this, (int)this._msg.getValue(), this._wParam.getValue(), this._lParam.getValue());
        Iterator i = this._messageListeners.iterator();
        while (i.hasNext()) {
            WindowMessageListener listener = (WindowMessageListener)i.next();
            if (listener.canHandle(message, beforeWndProc)) {
                this._lResult.setValue(listener.handle(message));
                this._msg.setValue((long)message.getMsg());
                this._wParam.setValue(message.getWParam());
                this._lParam.setValue(message.getLParam());
            }
            if (!(listener instanceof WindowMessageListenerEx)) continue;
            boolean isCallWindowProc = ((WindowMessageListenerEx)listener).isCallWindowProc(message);
            result = result && isCallWindowProc;
        }
        return result;
    }

    private static Function getDefWindowProc() {
        Function function = User32.getInstance().getFunction(FUNCTION_DEF_WINDOW_PROC.toString());
        return function;
    }

    public void addMessageListener(WindowMessageListener listener) {
        if (!this._messageListeners.contains(listener)) {
            this._messageListeners.add(listener);
        }
    }

    public void removeMessageListener(WindowMessageListener listener) {
        this._messageListeners.remove(listener);
    }

    public void substitute() {
        this._wndProc = new Handle(this._wnd.getWindowLong(-4));
        try {
            long result = this._wnd.setWindowLong(-4, (Parameter)this);
            if (result != 0L) {
                this._substituted = true;
            }
        }
        catch (LastErrorException e) {
            throw new LastErrorException("Failed to substitute the window procedure for the specified window.", (Throwable)e);
        }
    }

    public void restoreNative() {
        if (this._wndProc == null || this._wndProc.isNull()) {
            throw new IllegalStateException();
        }
        this._wnd.setWindowLong(-4, (Parameter)this._wndProc);
        this._substituted = false;
    }

    public boolean isSubstituted() {
        return this._substituted;
    }

    public Wnd getWnd() {
        return this._wnd;
    }

    public void setWnd(Wnd wnd) {
        if (wnd == null || wnd.isNull()) {
            throw new IllegalArgumentException();
        }
        boolean wasSubstituted = this.isSubstituted();
        if (wasSubstituted) {
            this.restoreNative();
        }
        this._wnd.setValue(wnd.getValue());
        if (wasSubstituted) {
            this.substitute();
        }
    }
}

