/*
 * Copyright (c) 2002-2005 DevTeam Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.jniwrapper.com/pages/jexcel/license
 */
package com.jniwrapper.win32.jexcel.samples.demo;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;

/**
 * @author Vladimir Kondrashchenko
 */
class AboutDialog extends JDialog
{
    private JLabel _text;
    private JButton _closeButton;

    public AboutDialog(Frame owner, String title, String message, ImageIcon icon)
    {
        super(owner, title, true);
        _text = new JLabel()
        {
            public void paint(Graphics g)
            {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paint(g);
            }
        };
        _closeButton = new JButton(new AbstractAction("  OK  ")
        {
            public void actionPerformed(ActionEvent e)
            {
                setVisible(false);
            }
        });
        _closeButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
        Container contentPane = getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBackground(Color.WHITE);

        _text.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        _text.setText(message);
        _text.setIcon(icon);

        JPanel buttonsPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        buttonsPanel.setOpaque(false);
        buttonsPanel.add(_closeButton);
        contentPane.add(_text, BorderLayout.CENTER);
        contentPane.add(buttonsPanel, BorderLayout.SOUTH);

        setResizable(false);
        pack();
        setLocationRelativeTo(null);
    }
};
