/*
 * Copyright (c) 2002-2005 DevTeam Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.jniwrapper.com/pages/jexcel/license
 */
package basics;

import com.jniwrapper.win32.jexcel.Application;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * This sample runs a new Microsoft Excel application and prints the list of recently opened files.
 *
 * @author Vladimir Kondrashchenko
 */
public class ApplicationSample
{
    public static void main(String[] args) throws Exception
    {
        Application application = new Application();
        
        if (!application.isVisible())
        {
            application.setVisible(true);
        }

        printRecentFiles(application);

        System.out.println("Press <Enter> to close application...");
        try
        {
            System.in.read();
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }

        application.close();
    }

    public static void printRecentFiles(Application application)
    {
        List files = application.getRecentFiles();
        for (int i = 0; i < files.size(); i++)
        {
            File file = (File)files.get(i);
            System.out.println(file.getAbsolutePath());
        }
    }
}
