/*
 * Copyright (c) 2002-2005 DevTeam Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.jniwrapper.com/pages/jexcel/license
 */
package basics;

import com.jniwrapper.win32.jexcel.*;

import java.util.List;
import java.io.IOException;

/**
 * This sample demonstrates how to use workbook and worksheet event handlers.
 * 
 *
 * @author Vladimir Kondrashchenko
 */
public class EventHandlersSample
{
    public static void main(String[] args) throws ExcelException
    {
        Application application = new Application();
        GenericWorkbook workbook = application.createWorkbook(null);

        setupEventHandlers(workbook);

        application.setVisible(true);

        System.out.println("Press <Enter> to close application...");
        try
        {
            System.in.read();
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }

        application.close();
    }

    private static void setupEventHandlers(GenericWorkbook workbook)
    {
        WorkbookEventHandler workbookEventHandler = new WorkbookHandler();
        WorksheetEventHandler worksheetEventHandler = new WorksheetHandler();

        workbook.setEventHandler(workbookEventHandler);

        List worksheets = workbook.getWorksheets();
        for (int i = 0; i < worksheets.size(); i++)
        {
            Worksheet worksheet = (Worksheet)worksheets.get(i);
            worksheet.setEventHandler(worksheetEventHandler);
        }
    }

    public static class WorkbookHandler implements WorkbookEventHandler
    {
        public boolean beforeClose(WorkbookEventObject source)
        {
            //Allow closing any workbooks
            return true;
        }

        public boolean beforeSave(WorkbookEventObject source)
        {
            //Forbid saving any workbooks
            return false;
        }
    }

    public static class WorksheetHandler implements WorksheetEventHandler
    {
        public boolean beforeDoubleClick(WorksheetEventObject eventObject)
        {
            //Forbid double-clicking on "A1" cell
            if (eventObject.getCell().equals(eventObject.getWorksheet().getCell("A1")))
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        public boolean beforeRightClick(WorksheetEventObject eventObject)
        {
            //Allow right-clicking only on "A1" cell
            if (eventObject.getRange().equals(eventObject.getWorksheet().getRange("A1")))
            {
                return true;
            }
            else
            {
                return false;
            }
        }
    }
}
