/*
 * Copyright (c) 2002-2005 DevTeam Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.jniwrapper.com/pages/jexcel/license
 */
package basics;

import com.jniwrapper.win32.jexcel.Application;
import com.jniwrapper.win32.jexcel.FileFormat;
import com.jniwrapper.win32.jexcel.GenericWorkbook;
import com.jniwrapper.win32.jexcel.Workbook;

import java.io.File;

/**
 * This sample opens the specified workbook and outputs workbook additional information.
 *
 * @author Vladimir Kondrashchenko
 */
public class WorkbookSample
{
    public static void main(String[] args) throws Exception
    {
        Application application = new Application();

        Workbook workbook = application.createWorkbook("Custom title");

        printWorkbookAttributes(workbook);

        modifyWorkbookAttributes(workbook);

        File newFile = new File("Workbook.xls");
        workbook.saveAs(newFile, FileFormat.WORKBOOKNORMAL, true);

        File workbookCopy = new File("WorkbookCopy.xls");
        workbook.saveCopyAs(workbookCopy);

        workbook.close(true);

        //Reopening the workbook
        workbook = application.openWorkbook(newFile, true, "xxx001");

        printWorkbookAttributes(workbook);

        application.close();
    }

    public static void printWorkbookAttributes(GenericWorkbook workbook)
    {
        String fileName = workbook.getFile().getAbsolutePath();
        String name = workbook.getWorkbookName();
        String title = workbook.getTitle();
        String author = workbook.getAuthor();

        System.out.println("\n[Workbook Addition Information]");
        System.out.println("File path: " + fileName);
        System.out.println("Name: " + name);
        System.out.println("Title: " + title);
        System.out.println("Author: " + author);

        if (workbook.hasPassword())
        {
            System.out.println("The workbook is protected with a password");
        }
        else
        {
            System.out.println("The workbook is not protected with a password");
        }
        if (workbook.isReadOnly())
        {
            System.out.println("Read only mode");
        }
    }

    public static void modifyWorkbookAttributes(GenericWorkbook workbook)
    {
        workbook.setTitle("New title");
        workbook.setPassword("xxx001");
        workbook.setAuthor("John Smith");
    }
}
