/*
 * Copyright (c) 2002-2005 DevTeam Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.jniwrapper.com/pages/jexcel/license
 */
package cell;

import com.jniwrapper.win32.jexcel.*;

/**
 * This sample demonstraites how to work with named cells.
 *
 * @author Vladimir Kondrashchenko
 */
public class NamedCellsSample
{
    public static void main(String[] args) throws ExcelException
    {
        Application application = new Application();
        GenericWorkbook workbook = application.createWorkbook(null);
        Worksheet worksheet = workbook.getWorksheet(1);

        //Obtaining a cell by its address
        Cell cell = worksheet.getCell("A1");

        //Obtaining a the forth cell in the third row
        Cell cell2 = worksheet.getCell(3, 4);

        //Printing cell name
        printCellName(cell);

        //Changing cell name
        cell.setName("New_Name");

        //Printing new cell name
        printCellName(cell);

        //Accessing a cell by its name
        cell = worksheet.getCell("New_Name");
        cell.setValue("String value");
        String value = cell.getString();
        System.out.println("\"" + cell.getName() + "\" cell value: " + value);

        application.close();
    }

    public static void printCellName(Cell cell)
    {
        if (cell.getName() == null)
        {
            System.out.println(cell.getAddress() + " name is not set up.");
        }
        else
        {
            System.out.println(cell.getAddress() + " name is \"" + cell.getName() + "\"");
        }
    }
}
