/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ie.samples.demo;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DOMNodeTreeNode
extends DefaultMutableTreeNode {
    private static final String INNER_HTML = "innerHTML";
    private static final String ELEMENT_TITLE = "TITLE";
    private static final String ELEMENT_STYLE = "STYLE";
    private static final String ELEMENT_SCRIPT = "SCRIPT";
    private Node _browserNode;
    private List _children;
    private String _text;
    private static final String NAME_TEXT = "#text";

    private DOMNodeTreeNode(String text) {
        this._text = text;
    }

    public DOMNodeTreeNode(Node browserNode) {
        this._browserNode = browserNode;
    }

    public Node getBrowserNode() {
        return this._browserNode;
    }

    public String getText() {
        return this._text;
    }

    private TreeNode[] getChildNodes() {
        if (this._browserNode == null) {
            return new TreeNode[0];
        }
        if (this._children == null) {
            String nodeName;
            if (this._text == null) {
                NodeList childNodes = this._browserNode.getChildNodes();
                int length = childNodes.getLength();
                this._children = new ArrayList(length);
                for (int i = 0; i < length; ++i) {
                    this._children.add(new DOMNodeTreeNode(childNodes.item(i)));
                }
            } else {
                this._children = new ArrayList(0);
            }
            if (this._browserNode != null && ((nodeName = this._browserNode.getNodeName()).equalsIgnoreCase(ELEMENT_TITLE) || nodeName.equalsIgnoreCase(ELEMENT_STYLE) || nodeName.equalsIgnoreCase(ELEMENT_SCRIPT))) {
                Element element = (Element)this._browserNode;
                String attributeValue = element.getAttribute(INNER_HTML);
                DOMNodeTreeNode node = new DOMNodeTreeNode(attributeValue);
                this._children.add(node);
            }
        }
        TreeNode[] result = new TreeNode[this._children.size()];
        this._children.toArray(result);
        return result;
    }

    public TreeNode getChildAt(int index) {
        return this.getChildNodes()[index];
    }

    public int getChildCount() {
        return this.getChildNodes().length;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public String toString() {
        if (this._browserNode == null) {
            if (this._text != null) {
                return NAME_TEXT;
            }
            return "";
        }
        return this._browserNode.getNodeName();
    }
}

