/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ie.samples.demo;

import com.jniwrapper.win32.ie.samples.demo.DOMAttributeTableModel;
import com.jniwrapper.win32.ie.samples.demo.DOMNodeTreeModel;
import com.jniwrapper.win32.ie.samples.demo.DOMNodeTreeNode;
import com.jniwrapper.win32.ie.samples.demo.NodeDetailsTableModel;
import com.jniwrapper.win32.ie.samples.demo.TreeCellRenderer;
import com.jniwrapper.win32.ie.samples.demo.components.LineBevel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;

class DOMStructurePanel
extends JPanel
implements TreeSelectionListener {
    private static final String PAGE_NODE_INFO = "Node";
    private static final String PAGE_TEXT = "Text";
    private JSplitPane _splitPane;
    private JTree _nodeTree;
    private JTable _attrTable;
    private TreeModel _nodeTreeModel;
    private NodeDetailsTableModel _attrTableModel;
    private Node _rootNode;
    private DOMNodeInfoPanel _domNodeInfoPanel;
    private TextAreaPanel _textAreaPanel;
    private JPanel _detailsPanel;
    private CardLayout _detailsPanelLayout;
    private boolean _onlySpecified = true;

    public DOMStructurePanel() {
        this.initialize();
        this.setBorder(null);
    }

    public void setDocument(Node node) {
        this._rootNode = node;
        this._nodeTreeModel = new DOMNodeTreeModel(this._rootNode);
        this._nodeTree.setModel(this._nodeTreeModel);
        this._attrTableModel.setOnlySpecified(this._onlySpecified);
        this._attrTable.revalidate();
        this._attrTable.repaint();
    }

    public void initialize() {
        this.setLayout(new BorderLayout());
        this._nodeTreeModel = new DOMNodeTreeModel(null);
        this._nodeTree = new JTree(this._nodeTreeModel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void setExpandedState(TreePath path, boolean state) {
                if (state) {
                    Cursor waitCursor = Cursor.getPredefinedCursor(3);
                    Cursor defCursor = this.getCursor();
                    try {
                        this.setCursor(waitCursor);
                        super.setExpandedState(path, state);
                    }
                    finally {
                        this.setCursor(defCursor);
                    }
                } else {
                    super.setExpandedState(path, state);
                }
            }
        };
        this._nodeTree.setRootVisible(true);
        this._nodeTree.addTreeSelectionListener(this);
        this._nodeTree.setCellRenderer(new TreeCellRenderer());
        this._nodeTree.setBorder(null);
        this._attrTableModel = new DOMAttributeTableModel();
        this._attrTableModel.setOnlySpecified(this._onlySpecified);
        this._attrTable = new JTable(this._attrTableModel);
        this._attrTable.setSelectionMode(0);
        this._attrTable.setRowSelectionAllowed(true);
        this._attrTable.setShowHorizontalLines(false);
        this._attrTable.setShowVerticalLines(false);
        this._detailsPanelLayout = new CardLayout();
        this._detailsPanel = new JPanel(this._detailsPanelLayout);
        this._domNodeInfoPanel = new DOMNodeInfoPanel();
        this._textAreaPanel = new TextAreaPanel();
        this._detailsPanel.add((Component)this._domNodeInfoPanel, PAGE_NODE_INFO);
        this._detailsPanel.add((Component)this._textAreaPanel, PAGE_TEXT);
        JScrollPane treeScrollPane = new JScrollPane(this._nodeTree);
        treeScrollPane.setBorder(null);
        treeScrollPane.setPreferredSize(new Dimension(90, 1));
        this._splitPane = new JSplitPane(1, true, treeScrollPane, this._detailsPanel);
        this._splitPane.setBorder(null);
        this.add((Component)this._splitPane, "Center");
        this._splitPane.setDividerSize(2);
        this._splitPane.setResizeWeight(0.5);
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        DOMNodeTreeNode node = (DOMNodeTreeNode)path.getPathComponent(path.getPathCount() - 1);
        Node browserNode = node.getBrowserNode();
        if (node.getText() != null) {
            this._textAreaPanel.getTextPane().setText(node.getText());
            this._detailsPanelLayout.show(this._detailsPanel, PAGE_TEXT);
        } else if (DOMStructurePanel.isTextNode(browserNode)) {
            this._textAreaPanel.getTextPane().setText(browserNode.getNodeValue());
            this._detailsPanelLayout.show(this._detailsPanel, PAGE_TEXT);
        } else {
            if (browserNode != null) {
                this._domNodeInfoPanel._fieldName.setText(browserNode.getNodeName());
                this._domNodeInfoPanel._fieldType.setText("" + browserNode.getNodeType());
                this._attrTableModel.setBrowserNode(browserNode);
                this._attrTable.revalidate();
                this._attrTable.repaint();
            }
            this._detailsPanelLayout.show(this._detailsPanel, PAGE_NODE_INFO);
        }
    }

    private static boolean isTextNode(Node node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 3: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    JTree getTree() {
        return this._nodeTree;
    }

    static /* synthetic */ boolean access$102(DOMStructurePanel x0, boolean x1) {
        x0._onlySpecified = x1;
        return x0._onlySpecified;
    }

    static /* synthetic */ boolean access$100(DOMStructurePanel x0) {
        return x0._onlySpecified;
    }

    static /* synthetic */ NodeDetailsTableModel access$200(DOMStructurePanel x0) {
        return x0._attrTableModel;
    }

    class TextAreaPanel
    extends JPanel {
        private JTextPane _textArea;

        public TextAreaPanel() {
            this.setLayout(new BorderLayout());
            this._textArea = new JTextPane();
            this._textArea.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, this.getBackground()));
            this._textArea.setEditable(false);
            this.add((Component)this._textArea, "Center");
        }

        public JTextPane getTextPane() {
            return this._textArea;
        }
    }

    class DOMNodeInfoPanel
    extends JPanel {
        JTextField _fieldName;
        JTextField _fieldType;

        public DOMNodeInfoPanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(null);
            JLabel title = new JLabel("DOM Node");
            title.setFocusable(false);
            title.setBorder(null);
            this.add((Component)title, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)new LineBevel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
            JComboBox<Object> filters = new JComboBox<Object>(new Object[]{"Specified", "All"});
            filters.addActionListener(new ActionListener(this, filters){
                private final /* synthetic */ JComboBox val$filters;
                private final /* synthetic */ DOMNodeInfoPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$filters = val$filters;
                }

                public void actionPerformed(ActionEvent e) {
                    DOMStructurePanel.access$102(DOMNodeInfoPanel.access$000(this.this$1), this.val$filters.getSelectedIndex() == 0);
                    DOMStructurePanel.access$200(DOMNodeInfoPanel.access$000(this.this$1)).setOnlySpecified(DOMStructurePanel.access$100(DOMNodeInfoPanel.access$000(this.this$1)));
                    DOMStructurePanel.access$300(DOMNodeInfoPanel.access$000(this.this$1)).repaint();
                    DOMStructurePanel.access$300(DOMNodeInfoPanel.access$000(this.this$1)).revalidate();
                }
            });
            this.add((Component)new JLabel("Name:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this._fieldName = new JTextField();
            this._fieldName.setEditable(false);
            this.add((Component)this._fieldName, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)new JLabel("Type:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 5, 0, 0), 0, 0));
            this._fieldType = new JTextField();
            this._fieldType.setEditable(false);
            this.add((Component)this._fieldType, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 0, 0, 5), 0, 0));
            this.add((Component)new JLabel("Attributes:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 4, 0, 0), 0, 0));
            this.add(filters, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 0, 0, 5), 0, 0));
            JScrollPane attributesPane = new JScrollPane();
            JViewport viewport = new JViewport();
            viewport.add(DOMStructurePanel.this._attrTable);
            viewport.setBackground(Color.white);
            attributesPane.setViewport(viewport);
            attributesPane.setPreferredSize(new Dimension(10, 10));
            this.add((Component)attributesPane, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 17, 1, new Insets(2, 5, 5, 5), 0, 0));
        }

        static /* synthetic */ DOMStructurePanel access$000(DOMNodeInfoPanel x0) {
            return x0.DOMStructurePanel.this;
        }
    }
}

