/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ie.samples.demo;

import com.jniwrapper.win32.ie.samples.demo.TabbedBrowsersPane;
import com.jniwrapper.win32.ie.samples.demo.components.LineBevel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class TitledPane
extends JPanel {
    private long _hideTime = System.currentTimeMillis();
    private static final long HIDE_INTERVAL = 300L;
    protected JLabel _title;
    protected JLabel _menuIcon;
    protected JLabel _closeIcon;

    public TitledPane() {
        this.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new GridBagLayout());
        titlePanel.setBorder(null);
        this._closeIcon = new JLabel();
        Cursor handCursor = new Cursor(12);
        this._closeIcon.setCursor(handCursor);
        this._closeIcon.setIcon(new ImageIcon(this.getClass().getResource("res/Close.gif")));
        this._closeIcon.setToolTipText("Close");
        final Border emptyBorder = BorderFactory.createEmptyBorder(1, 2, 1, 2);
        final Border etchedBorder = BorderFactory.createEtchedBorder();
        this._closeIcon.setBorder(emptyBorder);
        this._closeIcon.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                TitledPane.this._closeIcon.setBorder(etchedBorder);
            }

            public void mouseExited(MouseEvent e) {
                TitledPane.this._closeIcon.setBorder(emptyBorder);
            }
        });
        this._menuIcon = new JLabel();
        this._menuIcon.setCursor(handCursor);
        this._menuIcon.setIcon(new ImageIcon(this.getClass().getResource("res/downArrow.gif")));
        this._menuIcon.setToolTipText("Menu");
        this._menuIcon.setBorder(emptyBorder);
        this._menuIcon.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                TitledPane.this._menuIcon.setBorder(etchedBorder);
            }

            public void mouseExited(MouseEvent e) {
                TitledPane.this._menuIcon.setBorder(emptyBorder);
            }
        });
        this._title = new JLabel("");
        this._title.setFocusable(false);
        this._title.setBorder(null);
        Font oldFont = this._title.getFont();
        Font newFont = new Font("Tahoma", 1, oldFont.getSize());
        this._title.setFont(newFont);
        titlePanel.add((Component)this._title, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        titlePanel.add((Component)this._menuIcon, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        titlePanel.add((Component)this._closeIcon, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        titlePanel.add((Component)new LineBevel(), new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)titlePanel, "North");
    }

    public TitledPane(String name, JComponent content, JPopupMenu actions, Action closeAction) {
        this();
        this.setTitle(name);
        this.setComponent(content);
        this.assignActions(actions);
        this.assignCloseAction(closeAction);
    }

    public void setTitle(final String value) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Font font = TabbedBrowsersPane.getJapaneseFont();
                if (font != null) {
                    TitledPane.this._title.setFont(font);
                }
                TitledPane.this._title.setText(value);
            }
        });
    }

    public void setComponent(JComponent component) {
        this.add((Component)component, "Center");
    }

    public void assignActions(final JPopupMenu actions) {
        this._menuIcon.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (System.currentTimeMillis() - TitledPane.this._hideTime < 300L) {
                    return;
                }
                actions.show(TitledPane.this._menuIcon, 0, TitledPane.this._menuIcon.getHeight());
            }
        });
        actions.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                TitledPane.this._hideTime = System.currentTimeMillis();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
    }

    public void assignCloseAction(final Action closeAction) {
        this._closeIcon.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                closeAction.actionPerformed(null);
            }
        });
    }
}

