/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.dde;

import com.jniwrapper.Function;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.dde.DdeCallback;
import com.jniwrapper.win32.dde.DdeClientEventHandler;
import com.jniwrapper.win32.dde.DdeException;
import com.jniwrapper.win32.dde.DdeFunctions;
import com.jniwrapper.win32.dde.DdeItem;
import com.jniwrapper.win32.ui.User32;

class DdeClientHelper {
    private static final String FUNCTION_CONNECT = "DdeConnect";
    private static final String FUNCTION_DISCONNECT = "DdeDisconnect";
    private static final String FUNCTION_CLIENTTRANSACTION = "DdeClientTransaction";
    private static final String FUNCTION_ABANDONTRANSACTION = "DdeAbandonTransaction";
    private static final long TIMEOUT_ASYNC = 0xFFFFFFFFL;
    private static final long XTYPF_NODATA = 4L;
    private static final long XTYPF_ACKREQ = 8L;
    private long _idInst;
    private boolean _connected = false;
    private DdeCallback _callback;
    private Handle _conv;

    public void createCallback() {
        this._callback = new DdeCallback();
    }

    public void connect(String service, String topic) throws DdeException {
        if (!this._connected) {
            this._idInst = DdeFunctions.ddeInitialize(this._callback);
            this._callback.setIdInst(this._idInst);
            this._connected = true;
        }
        this._conv = this.ddeConnect(this._idInst, service, topic);
    }

    public void disconnect() throws DdeException {
        if (this._connected) {
            this.ddeDisconnect(this._idInst, this._conv);
            DdeFunctions.ddeUninitialize(this._idInst);
            this._connected = false;
        }
    }

    public Long getAsync(DdeItem item) throws DdeException {
        Handle hItem = DdeFunctions.createStringHandle(this._idInst, item.getName());
        Handle result = this.clientTransaction(this._idInst, new Handle(), this._conv, hItem, 8368L, item.getFormat(), 0xFFFFFFFFL);
        DdeFunctions.freeStringHandle(this._idInst, hItem);
        return new Long(result.getValue());
    }

    public byte[] get(DdeItem item, Long timeout) throws DdeException {
        Handle hItem = DdeFunctions.createStringHandle(this._idInst, item.getName());
        Handle data = this.clientTransaction(this._idInst, new Handle(), this._conv, hItem, 8368L, item.getFormat(), (long)timeout);
        byte[] resData = DdeFunctions.getData(data);
        DdeFunctions.freeStringHandle(this._idInst, hItem);
        DdeFunctions.freeDataHandle(this._idInst, data);
        byte[] result = resData;
        return result;
    }

    public Long sendAsync(DdeItem item, byte[] data) throws DdeException {
        Handle hItem = DdeFunctions.createStringHandle(this._idInst, item.getName());
        Handle hData = DdeFunctions.createDataHandle(this._idInst, data, 0, item.getFormat(), hItem);
        Handle result = this.clientTransaction(this._idInst, hData, this._conv, hItem, 16528L, item.getFormat(), 0xFFFFFFFFL);
        DdeFunctions.freeStringHandle(this._idInst, hItem);
        DdeFunctions.freeDataHandle(this._idInst, hData);
        return new Long(result.getValue());
    }

    public void send(DdeItem item, byte[] data, Long timeout) throws DdeException {
        Handle hItem = DdeFunctions.createStringHandle(this._idInst, item.getName());
        Handle hData = DdeFunctions.createDataHandle(this._idInst, data, 0, item.getFormat(), hItem);
        this.clientTransaction(this._idInst, hData, this._conv, hItem, 16528L, item.getFormat(), (long)timeout);
        DdeFunctions.freeStringHandle(this._idInst, hItem);
        DdeFunctions.freeDataHandle(this._idInst, hData);
    }

    public Long executeAsync(String command) throws DdeException {
        Handle result = this.clientTransaction(this._idInst, command, this._conv, new Handle(), 16464L, 1L, 0xFFFFFFFFL);
        return new Long(result.getValue());
    }

    public void execute(String command, Long timeout) throws DdeException {
        this.clientTransaction(this._idInst, command, this._conv, new Handle(), 16464L, 1L, (long)timeout);
    }

    public Long startAdviseLoopAsync(DdeItem item, Boolean sendData, Boolean sync) throws DdeException {
        Handle hItem = DdeFunctions.createStringHandle(this._idInst, item.getName());
        long flag = 4144L;
        if (!sendData.booleanValue()) {
            flag |= 4L;
        }
        if (sync.booleanValue()) {
            flag |= 8L;
        }
        Handle result = this.clientTransaction(this._idInst, new Handle(), this._conv, hItem, flag, item.getFormat(), 0xFFFFFFFFL);
        DdeFunctions.freeStringHandle(this._idInst, hItem);
        return new Long(result.getValue());
    }

    public void startAdviseLoop(DdeItem item, Boolean sendData, Boolean sync, Long timeout) throws DdeException {
        Handle hItem = DdeFunctions.createStringHandle(this._idInst, item.getName());
        long flag = 4144L;
        if (!sendData.booleanValue()) {
            flag |= 4L;
        }
        if (sync.booleanValue()) {
            flag |= 8L;
        }
        this.clientTransaction(this._idInst, new Handle(), this._conv, hItem, flag, item.getFormat(), (long)timeout);
        DdeFunctions.freeStringHandle(this._idInst, hItem);
    }

    public Long stopAdviseLoopAsync(DdeItem item) throws DdeException {
        Handle hItem = DdeFunctions.createStringHandle(this._idInst, item.getName());
        Handle result = this.clientTransaction(this._idInst, new Handle(), this._conv, hItem, 32832L, 0L, 0xFFFFFFFFL);
        DdeFunctions.freeStringHandle(this._idInst, hItem);
        return new Long(result.getValue());
    }

    public void stopAdviseLoop(DdeItem item, Long timeout) throws DdeException {
        Handle hItem = DdeFunctions.createStringHandle(this._idInst, item.getName());
        this.clientTransaction(this._idInst, new Handle(), this._conv, hItem, 32832L, 0L, (long)timeout);
        DdeFunctions.freeStringHandle(this._idInst, hItem);
    }

    public void abandonTransaction(Long transactionID) throws DdeException {
        this.ddeAbandonTransaction(this._idInst, this._conv, transactionID);
    }

    private Handle ddeConnect(long idInst, String service, String topic) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_CONNECT);
        Handle result = new Handle();
        Handle hService = DdeFunctions.createStringHandle(idInst, service);
        Handle hTopic = DdeFunctions.createStringHandle(idInst, topic);
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst), (Parameter)hService, (Parameter)hTopic, (Parameter)new Pointer(null, true));
        DdeFunctions.freeStringHandle(idInst, hService);
        DdeFunctions.freeStringHandle(idInst, hTopic);
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
        return result;
    }

    private void ddeDisconnect(long idInst, Handle conv) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_DISCONNECT);
        IntBool result = new IntBool();
        function.invoke((Parameter)result, (Parameter)conv);
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }

    private void ddeAbandonTransaction(long idInst, Handle conv, long transactionID) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_ABANDONTRANSACTION);
        IntBool result = new IntBool();
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst), (Parameter)conv, (Parameter)new UInt32(transactionID));
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }

    private Handle clientTransaction(long idInst, Handle data, Handle conv, Handle item, long type, long format, long timeout) throws DdeException {
        return this.clientTransaction(idInst, (Parameter)data, conv, item, type, format, timeout);
    }

    private Handle clientTransaction(long idInst, String data, Handle conv, Handle item, long type, long format, long timeout) throws DdeException {
        return this.clientTransaction(idInst, (Parameter)new Str(data), conv, item, type, format, timeout);
    }

    private Handle clientTransaction(long idInst, Parameter data, Handle conv, Handle item, long type, long format, long timeout) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_CLIENTTRANSACTION);
        Handle retVal = new Handle();
        UInt32 result = new UInt32();
        function.invoke((Parameter)retVal, new Parameter[]{data, data instanceof Str ? new UInt32((long)((Str)data).getLength()) : new UInt32(-1L), conv, item, new UInt(format), new UInt(type), new UInt32(timeout), new Pointer((Parameter)result)});
        if (retVal.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
        if (timeout == 0xFFFFFFFFL) {
            return new Handle(result.getValue());
        }
        return retVal;
    }

    public boolean isConnected() {
        return this._connected;
    }

    public void setEventHandler(DdeClientEventHandler eventHandler) {
        this._callback.addClientEventHandler(this._conv, eventHandler);
    }

    public void removeEventHandler() {
        this._callback.removeClientEventHandler(this._conv);
    }
}

