/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.process;

import com.jniwrapper.util.FlagSet;

public class ProcessOptions
extends FlagSet {
    public static final int CREATE_NO_WINDOW = 0x8000000;
    public static final int CREATE_DEFAULT_ERROR_MODE = 0x4000000;
    public static final int CREATE_NEW_CONSOLE = 16;
    public static final int CREATE_NEW_PROCESS_GROUP = 512;
    public static final int CREATE_SHARED_WOW_VDM = 4096;
    public static final int CREATE_SUSPENDED = 4;
    public static final int CREATE_UNICODE_ENVIRONMENT = 1024;
    public static final int CREATE_FORCEDOS = 8192;
    public static final int SYNCHRONIZE = 0x100000;

    public ProcessOptions() {
    }

    public ProcessOptions(long flags) {
        super(flags);
    }

    public ProcessOptions(boolean createDefault) {
        this.setDefaultErrorMode(createDefault);
    }

    public void setNoWindow(boolean value) {
        this.setupFlag(0x8000000L, value);
    }

    public boolean isNoWindow() {
        return this.contains(0x8000000L);
    }

    public void setDefaultErrorMode(boolean value) {
        this.setupFlag(0x4000000L, value);
    }

    public boolean isDefaultErrorMode() {
        return this.contains(0x4000000L);
    }

    public void setNewConsole(boolean value) {
        this.setupFlag(16L, value);
    }

    public boolean isNewConsole() {
        return this.contains(16L);
    }

    public void setNewProcessGroup(boolean value) {
        this.setupFlag(512L, value);
    }

    public boolean isNewProcessGroup() {
        return this.contains(512L);
    }

    public void setSharedWOW_VDM(boolean value) {
        this.setupFlag(4096L, value);
    }

    public boolean isSharedWOW_VDM() {
        return this.contains(4096L);
    }

    public void setSuspended(boolean value) {
        this.setupFlag(4L, value);
    }

    public boolean isSuspended() {
        return this.contains(4L);
    }

    public void setUnicodeEnvironment(boolean value) {
        this.setupFlag(1024L, value);
    }

    public boolean isUnicodeEnvironment() {
        return this.contains(1024L);
    }

    public void setSynchronize(boolean value) {
        this.setupFlag(0x100000L, value);
    }

    public boolean isSynchronize() {
        return this.contains(0x100000L);
    }
}

