/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package com.jniwrapper.win32.ie.samples.demo;

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.Browser;
import com.jniwrapper.win32.ie.event.NewWindowEventHandler;
import com.jniwrapper.win32.automation.OleMessageLoop;

/**
 * @author Alexei Orischenko
 */
class BrowserNewWindowEventHandler implements NewWindowEventHandler
{
    protected TabbedBrowsersPane _tabbedBrowsersPane;
    protected WebBrowser _browser;

    public BrowserNewWindowEventHandler(WebBrowser browser)
    {
        _browser = browser;
    }

    public NewWindowEventHandler.NewWindowAction newWindow()
    {
        Browser browser = new Browser(_browser.getOleMessageLoop());

        _tabbedBrowsersPane.addBrowser(browser);

        NewWindowEventHandler.NewWindowAction result = new NewWindowEventHandler.NewWindowAction(NewWindowEventHandler.NewWindowAction.ACTION_REPLACE_BROWSER);
        result.setBrowser(browser);

        return result;
    }
}
