package command;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import core.BasicSample;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import com.jniwrapper.win32.ie.command.BrowserCommand;
import com.jniwrapper.win32.ole.types.OleCmdID;

/**
 * This sample inserts text from clipboard to the input field.
 *
 * @author Alexei Orischenko
 */
public class PasteSample extends BasicSample
{
    public PasteSample()
    {
        super("Paste Sample");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();
        browser.setContent("<html><body><input id='inp' length='20'></body></html>");
        browser.waitReady();

        HTMLElement element = (HTMLElement) browser.getDocument().getElementById("inp");
        element.focus();

        browser.execute(new BrowserCommand() {
            public Object getId()
            {
                return new OleCmdID(OleCmdID.OLECMDID_PASTE);
            }
        });
    }

    public static void main(String[] args) throws Exception
    {
        new PasteSample().run();
    }
}
