package contextmenu;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.Browser;
import com.jniwrapper.win32.ie.ContextMenuProvider;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.ElementTypes;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import core.BasicSample;

/**
 * This sample demonstrates technique of customizing browser's context menu and
 * working with links that contain images.
 *
 * @author Alexei Orischenko
 */
public class ContextMenuSample extends BasicSample
{
    public ContextMenuSample()
    {
        super("Context Menu");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        // wait when the browser will be ready to work
        browser.waitReady();

        ((Browser)browser).setContextMenuProvider(new ContextMenuProvider()
        {
            public JPopupMenu getPopupMenu(Element contextElement)
            {
                JPopupMenu popupMenu = new JPopupMenu();
                if (isLinkElement(contextElement))
                {
                    JMenuItem menuItem = new JMenuItem("Open link");
                    popupMenu.add(menuItem);
                    menuItem.addActionListener(new ActionListener()
                    {
                        public void actionPerformed(ActionEvent e)
                        {
                            navigateLink();
                        }
                    });
                    popupMenu.addSeparator();
                }

                JMenuItem closeItem = new JMenuItem("Close");
                popupMenu.add(closeItem);
                closeItem.addActionListener(new ActionListener()
                {
                    public void actionPerformed(ActionEvent e)
                    {
                        System.exit(0);
                    }
                });

                return popupMenu;
            }
        });

        browser.navigate("http://google.com");
        browser.waitReady();

        showMessage("Please right click on link");
    }

    private void navigateLink()
    {
        Element element = ((Browser)getBrowser()).getContextElement();
        while (element != null && !ElementTypes.isLink(element))
        {
            element = (Element)element.getParentNode();
        }

        if (element != null)
        {
            String href = element.getAttribute("href");
            getBrowser().navigate(href);
        }
    }

    /**
     * Returns true for link or link with image.
     *
     * @param element html element
     * @return true for link or link with image
     */
    private static boolean isLinkElement(Element element)
    {
        while (element != null && !ElementTypes.isLink(element))
        {
            if (ElementTypes.isBody(element))
            {
                return false;
            }

            Node parent = element.getParentNode();

            if (!(parent instanceof Element))
            {
                return false;   
            }

            element = (Element) parent;
        }

        return (element != null);
    }

    public static void main(String[] args) throws Exception
    {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);

        new ContextMenuSample().run();
    }
}
