package core;

import com.jniwrapper.win32.ie.Browser;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

/**
 * @author Ikryanov Vladimir
 */
public class BrowserScreenShotSample extends BasicSample
{
    protected BrowserScreenShotSample()
    {
        super("HTML to Image");
    }

    protected void execute()
    {
        final Browser browser = (Browser) getBrowser();

        browser.navigate("http://teamdev.com/java_integration.html");
        browser.waitReady();

        // Saves the visible area of the page
        BufferedImage screenShot = (BufferedImage) browser.getScreenShot(false);
        File file1 = new File("page1.png");
        try
        {
            ImageIO.write(screenShot, "png", file1);
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
        screenShot.flush();

        // Saves the whole webpage
        BufferedImage fullScreenShot = (BufferedImage) browser.getScreenShot(true);
        File file2 = new File("page2.png");
        try
        {
            ImageIO.write(fullScreenShot, "png", file2);
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
        fullScreenShot.flush();

        showMessage("The page is saved.");
    }

    public static void main(String[] args) throws Exception
    {
        new BrowserScreenShotSample().run();
    }
}
