package core;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.Cookie;

import java.util.Set;

/**
 * This sample demonstrates technique of working with cookies.
 *
 * @author Alexei Orischenko
 */
public class CookieSample extends BasicSample
{
    public CookieSample()
    {
        super("Cookie");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        browser.navigate("http://google.com");
        browser.waitReady();

        Set cookies = browser.getDocument().getCookies();
        if (cookies.size() > 0)
        {
            Cookie cookie = (Cookie)cookies.iterator().next();
            showMessage(cookie.toString());
        }
    }

    public static void main(String[] args) throws Exception
    {
        new CookieSample().run();
    }
}
